<style>
.promo li a {
    float: left;
    width: 130px;
    height: 20px;
    text-align: center;
    margin: 10px 30px;
    padding: 150px 0 0 0;
    background-position: 0 50%;
    background-size: 130px auto;
    background-repeat: no-repeat;
    font-size: 120%;
    color: black;
}
.promo li {
    list-style: none;
}
</style>

# Django REST framework 3.7

The 3.7 release focuses on improvements to schema generation and the interactive API documentation.

This release has been made possible by [Bayer](https://www.bayer.com/) who have sponsored the release.

<a href="https://www.bayer.com/"><img src="/img/bayer.png"/></a>

---

## Funding

If you use REST framework commercially and would like to see this work continue, we strongly encourage you to invest in its continued development by
**[signing up for a paid&nbsp;plan][funding]**.

<ul class="premium-promo promo">
    <li><a href="https://www.rover.com/careers/" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/rover_130x130.png)">Rover.com</a></li>
    <li><a href="https://sentry.io/welcome/" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/sentry130.png)">Sentry</a></li>
    <li><a href="https://getstream.io/try-the-api/?utm_source=drf&utm_medium=banner&utm_campaign=drf" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/stream-130.png)">Stream</a></li>
    <li><a href="https://machinalis.com/" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/Machinalis130.png)">Machinalis</a></li>
    <li><a href="https://rollbar.com" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/rollbar.png)">Rollbar</a></li>
</ul>
<div style="clear: both; padding-bottom: 20px;"></div>

*As well as our release sponsor, we'd like to say thanks in particular our premium backers, [Rover](https://www.rover.com/careers/), [Sentry](https://sentry.io/welcome/), [Stream](https://getstream.io/?utm_source=drf&utm_medium=banner&utm_campaign=drf), [Machinalis](https://machinalis.com/), and [Rollbar](https://rollbar.com).*

---

## Customizing API docs & schema generation.

The schema generation introduced in 3.5 and the related API docs generation in 3.6 are both hugely powerful features, however they've been somewhat limited in cases where the view introspection isn't able to correctly identify the schema for a particular view.

In order to try to address this we're now adding the ability for per-view customization of the API schema. The interface that we're adding for this allows either basic manual overrides over which fields should be included on a view, or for more complex programmatic overriding of the schema generation. We believe this release comprehensively addresses some of the existing shortcomings of the schema features.

Let's take a quick look at using the new functionality...

The `APIView` class has a `schema` attribute, that is used to control how the Schema for that particular view is generated. The default behavior is to use the `AutoSchema` class.

    from rest_framework.views import APIView
    from rest_framework.schemas import AutoSchema

    class CustomView(APIView):
        schema = AutoSchema()  # Included for demonstration only. This is the default behavior.

We can remove a view from the API schema and docs, like so:

    class CustomView(APIView):
        schema = None

If we want to mostly use the default behavior, but additionally include some additional fields on a particular view, we can now do so easily...

    class CustomView(APIView):
        schema = AutoSchema(manual_fields=[
            coreapi.Field('search', location='query')
        ])

To ignore the automatic generation for a particular view, and instead specify the schema explicitly, we use the `ManualSchema` class instead...

    class CustomView(APIView):
        schema = ManualSchema(fields=[...])

For more advanced behaviors you can subclass `AutoSchema` to provide for customized schema generation, and apply that to particular views.

    class CustomView(APIView):
        schema = CustomizedSchemaGeneration()

For full details on the new functionality, please see the [Schema Documentation][schema-docs].

---

## Django 2.0 support

REST framework 3.7 supports Django versions 1.10, 1.11, and 2.0 alpha.

---

## Minor fixes and improvements

There are a large number of minor fixes and improvements in this release. See the [release notes](release-notes.md) page for a complete listing.

The number of [open tickets against the project](https://github.com/encode/django-rest-framework/issues) currently at its lowest number in quite some time, and we're continuing to focus on reducing these to a manageable amount.

---

## Deprecations

### `exclude_from_schema`

Both `APIView.exclude_from_schema` and the `exclude_from_schema` argument to the `@api_view` decorator and now `PendingDeprecation`. They will be moved to deprecated in the 3.8 release, and removed entirely in 3.9.

For `APIView` you should instead set a `schema = None` attribute on the view class.

For function based views the `@schema` decorator can be used to exclude the view from the schema, by using `@schema(None)`.

### `DjangoFilterBackend`

The `DjangoFilterBackend` was moved to pending deprecation in 3.5, and deprecated in 3.6. It has now been removed from the core framework.

The functionality remains fully available, but is instead provided in the `django-filter` package.

---

## What's next

We're still planning to work on improving real-time support for REST framework by providing documentation on integrating with Django channels, as well adding support for more easily adding WebSocket support to existing HTTP endpoints.

This will likely be timed so that any REST framework development here ties in with similar work on [API Star][api-star].

[funding]: funding.md
[schema-docs]: ../api-guide/schemas.md
[api-star]: https://github.com/encode/apistar
