<style>
.promo li a {
    float: left;
    width: 130px;
    height: 20px;
    text-align: center;
    margin: 10px 30px;
    padding: 150px 0 0 0;
    background-position: 0 50%;
    background-size: 130px auto;
    background-repeat: no-repeat;
    font-size: 120%;
    color: black;
}
.promo li {
    list-style: none;
}
</style>

# Django REST framework 3.9

The 3.9 release gives access to _extra actions_ in the Browsable API, introduces composable permissions and built-in [OpenAPI][openapi] schema support. (Formerly known as Swagger)

---

## Funding

If you use REST framework commercially and would like to see this work continue, we strongly encourage you to invest in its continued development by
**[signing up for a paid&nbsp;plan][funding]**.


<ul class="premium-promo promo">
    <li><a href="https://www.rover.com/careers/" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/rover_130x130.png)">Rover.com</a></li>
    <li><a href="https://sentry.io/welcome/" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/sentry130.png)">Sentry</a></li>
    <li><a href="https://getstream.io/try-the-api/?utm_source=drf&utm_medium=banner&utm_campaign=drf" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/stream-130.png)">Stream</a></li>
    <li><a href="https://auklet.io" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/auklet-new.png)">Auklet</a></li>
    <li><a href="https://rollbar.com" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/rollbar2.png)">Rollbar</a></li>
    <li><a href="https://cadre.com" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/cadre.png)">Cadre</a></li>
    <li><a href="https://loadimpact.com/?utm_campaign=Sponsorship%20links&utm_source=drf&utm_medium=drf" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/load-impact.png)">Load Impact</a></li>
    <li><a href="https://hubs.ly/H0f30Lf0" style="background-image: url(https://fund-rest-framework.s3.amazonaws.com/kloudless.png)">Kloudless</a></li>
</ul>
<div style="clear: both; padding-bottom: 20px;"></div>

*Many thanks to all our [wonderful sponsors][sponsors], and in particular to our premium backers, [Rover](https://www.rover.com/careers/), [Sentry](https://sentry.io/welcome/), [Stream](https://getstream.io/?utm_source=drf&utm_medium=banner&utm_campaign=drf), [Auklet](https://auklet.io/), [Rollbar](https://rollbar.com), [Cadre](https://cadre.com), [Load Impact](https://loadimpact.com/?utm_campaign=Sponsorship%20links&utm_source=drf&utm_medium=drf), and [Kloudless](https://hubs.ly/H0f30Lf0).*

---

## Built-in OpenAPI schema support

REST framework now has a first-pass at directly including OpenAPI schema support. (Formerly known as Swagger)

Specifically:

* There are now `OpenAPIRenderer`, and `JSONOpenAPIRenderer` classes that deal with encoding `coreapi.Document` instances into OpenAPI YAML or OpenAPI JSON.
* The `get_schema_view(...)` method now defaults to OpenAPI YAML, with CoreJSON as a secondary
option if it is selected via HTTP content negotiation.
* There is a new management command `generateschema`, which you can use to dump
the schema into your repository.

Here's an example of adding an OpenAPI schema to the URL conf:

```python
from rest_framework.schemas import get_schema_view
from rest_framework.renderers import JSONOpenAPIRenderer
from django.urls import path

schema_view = get_schema_view(
    title="Server Monitoring API",
    url="https://www.example.org/api/",
    renderer_classes=[JSONOpenAPIRenderer],
)

urlpatterns = [path("schema.json", schema_view), ...]
```

And here's how you can use the `generateschema` management command:

```shell
$ python manage.py generateschema --format openapi > schema.yml
```

There's lots of different tooling that you can use for working with OpenAPI
schemas. One option that we're working on is the [API Star](https://docs.apistar.com/)
command line tool.

You can use `apistar` to validate your API schema:

```shell
$ apistar validate --path schema.json --format openapi
✓ Valid OpenAPI schema.
```

Or to build API documentation:

```shell
$ apistar docs --path schema.json --format openapi
✓ Documentation built at "build/index.html".
```

API Star also includes a [dynamic client library](https://docs.apistar.com/client-library/)
that uses an API schema to automatically provide a client library interface for making requests.

## Composable permission classes

You can now compose permission classes using the and/or operators, `&` and `|`.

For example...

```python
permission_classes = [IsAuthenticated & (ReadOnly | IsAdminUser)]
```

If you're using custom permission classes then make sure that you are subclassing
from `BasePermission` in order to enable this support.

## ViewSet _Extra Actions_ available in the Browsable API

Following the introduction of the `action` decorator in v3.8, _extra actions_ defined on a ViewSet are now available
from the Browsable API.

![Extra Actions displayed in the Browsable API](https://user-images.githubusercontent.com/2370209/32976956-1ca9ab7e-cbf1-11e7-981a-a20cb1e83d63.png)

When defined, a dropdown of "Extra Actions", appropriately filtered to detail/non-detail actions, is displayed.

---

## Supported Versions

REST framework 3.9 supports Django versions 1.11, 2.0, and 2.1.

---

## Deprecations

### `DjangoObjectPermissionsFilter` moved to third-party package.

The `DjangoObjectPermissionsFilter` class is pending deprecation, will be deprecated in 3.10 and removed entirely in 3.11.

It has been moved to the third-party [`djangorestframework-guardian`](https://github.com/rpkilby/django-rest-framework-guardian)
package. Please use this instead.

### Router argument/method renamed to use `basename` for consistency.

* The `Router.register` `base_name` argument has been renamed in favor of `basename`.
* The `Router.get_default_base_name` method has been renamed in favor of `Router.get_default_basename`. [#5990][gh5990]

See [#5990][gh5990].

[gh5990]: https://github.com/encode/django-rest-framework/pull/5990

`base_name` and `get_default_base_name()` are pending deprecation. They will be deprecated in 3.10 and removed entirely in 3.11.

### `action` decorator replaces `list_route` and `detail_route`

Both `list_route` and `detail_route` are now deprecated in favor of the single `action` decorator.
They will be removed entirely in 3.10.

The `action` decorator takes a boolean `detail` argument.

* Replace `detail_route` uses with `@action(detail=True)`.
* Replace `list_route` uses with `@action(detail=False)`.

### `exclude_from_schema`

Both `APIView.exclude_from_schema` and the `exclude_from_schema` argument to the `@api_view` have now been removed.

For `APIView` you should instead set a `schema = None` attribute on the view class.

For function-based views the `@schema` decorator can be used to exclude the view from the schema, by using `@schema(None)`.

---

## Minor fixes and improvements

There are a large number of minor fixes and improvements in this release. See the [release notes](release-notes.md) page for a complete listing.


## What's next

We're planning to iteratively work towards OpenAPI becoming the standard schema
representation. This will mean that the `coreapi` dependency will gradually become
removed, and we'll instead generate the schema directly, rather than building
a CoreAPI `Document` object.

OpenAPI has clearly become the standard for specifying Web APIs, so there's not
much value any more in our schema-agnostic document model. Making this change
will mean that we'll more easily be able to take advantage of the full set of
OpenAPI functionality.

This will also make a wider range of tooling available.

We'll focus on continuing to develop the [API Star](https://docs.apistar.com/)
library and client tool into a recommended option for generating API docs,
validating API schemas, and providing a dynamic client library.

There's also a huge amount of ongoing work on maturing the ASGI landscape,
with the possibility that some of this work will eventually [feed back into
Django](https://www.aeracode.org/2018/06/04/django-async-roadmap/).

There will be further work on the [Uvicorn](https://www.uvicorn.org/)
web server, as well as lots of functionality planned for the [Starlette](https://www.starlette.io/)
web framework, which is building a foundational set of tooling for working with
ASGI.


[funding]: funding.md
[gh5886]: https://github.com/encode/django-rest-framework/issues/5886
[gh5705]: https://github.com/encode/django-rest-framework/issues/5705
[openapi]: https://www.openapis.org/
[sponsors]: https://fund.django-rest-framework.org/topics/funding/#our-sponsors
