(*
 * Copyright (c) Meta Platforms, Inc. and affiliates.
 *
 * This source code is licensed under the MIT license found in the
 * LICENSE file in the root directory of this source tree.
 *)

val instantiate_error
  :  lookup_source:(ArtifactPath.t -> SourcePath.t option) ->
  show_error_traces:bool ->
  source_code_api:Analysis.SourceCodeApi.t ->
  Analysis.AnalysisError.t ->
  Analysis.AnalysisError.Instantiated.t

val instantiate_error_with_build_system
  :  build_system:BuildSystem.t ->
  source_code_api:Analysis.SourceCodeApi.t ->
  Analysis.AnalysisError.t ->
  Analysis.AnalysisError.Instantiated.t

val create_info_response : ServerProperties.t -> Response.t

val process_request
  :  properties:ServerProperties.t ->
  state:ServerState.t ->
  Request.t ->
  (ServerState.t * Response.t) Lwt.t
