# Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved
# type: ignore
from pathlib import Path

from read_version import read_version
from setuptools import find_namespace_packages, setup

setup(
    name="hydra-ax-sweeper",
    version=read_version("hydra_plugins/hydra_ax_sweeper", "__init__.py"),
    author="Omry Yadan, Shagun Sodhani",
    author_email="omry@fb.com, sshagunsodhani@gmail.com",
    description="Hydra Ax Sweeper plugin",
    long_description=(Path(__file__).parent / "README.md").read_text(),
    long_description_content_type="text/markdown",
    url="https://github.com/facebookresearch/hydra/",
    packages=find_namespace_packages(include=["hydra_plugins.*"]),
    classifiers=[
        "License :: OSI Approved :: MIT License",
        "Programming Language :: Python :: 3.9",
        "Programming Language :: Python :: 3.10",
        "Operating System :: POSIX :: Linux",
        "Operating System :: MacOS",
        "Development Status :: 4 - Beta",
    ],
    python_requires=">=3.9",
    install_requires=[
        "hydra-core>=1.1.0.dev7",
        "ax-platform>=0.1.20,<0.2.1",  # https://github.com/facebookresearch/hydra/issues/1767
        "torch",
        "gpytorch<=1.8.1",  # avoid deprecation warnings. This can probably be removed when ax-platform is unpinned.
        "pandas<1.5.0",  # https://github.com/facebook/Ax/issues/1153, unpin when upgrading ax to >=0.2.8
        "numpy<1.25.0",  # same as above, silences deprecation from np.find_common_type for pandas <1.5
    ],
    include_package_data=True,
)
