# Copyright (c) Facebook, Inc. and its affiliates. All Rights Reserved
# Generated by configen, do not edit.
# See https://github.com/facebookresearch/hydra/tree/main/tools/configen
# fmt: off
# isort:skip_file
# flake8: noqa

from dataclasses import dataclass, field
from omegaconf import MISSING
from tests.test_modules import Color
from tests.test_modules import User
from typing import Any
from typing import Dict
from typing import List
from typing import Optional
from typing import Tuple


@dataclass
class EmptyConf:
    _target_: str = "tests.test_modules.Empty"


@dataclass
class UntypedArgConf:
    _target_: str = "tests.test_modules.UntypedArg"
    param: Any = MISSING


@dataclass
class IntArgConf:
    _target_: str = "tests.test_modules.IntArg"
    param: int = MISSING


@dataclass
class UnionArgConf:
    _target_: str = "tests.test_modules.UnionArg"
    param: Any = MISSING  # Union[int, float]


@dataclass
class WithLibraryClassArgConf:
    _target_: str = "tests.test_modules.WithLibraryClassArg"
    num: int = MISSING
    param: Any = MISSING  # LibraryClass


@dataclass
class IncompatibleDataclassArgConf:
    _target_: str = "tests.test_modules.IncompatibleDataclassArg"
    num: int = MISSING
    incompat: Any = MISSING  # IncompatibleDataclass


@dataclass
class WithStringDefaultConf:
    _target_: str = "tests.test_modules.WithStringDefault"
    no_default: str = MISSING
    default_str: str = "Bond, James Bond"
    none_str: Optional[str] = None


@dataclass
class WithUntypedStringDefaultConf:
    _target_: str = "tests.test_modules.WithUntypedStringDefault"
    default_str: Any = "Bond, James Bond"


@dataclass
class ListValuesConf:
    _target_: str = "tests.test_modules.ListValues"
    lst: List[str] = MISSING
    enum_lst: List[Color] = MISSING
    passthrough_list: Any = MISSING  # List[LibraryClass]
    dataclass_val: List[User] = MISSING
    def_value: List[str] = field(default_factory=lambda: [])


@dataclass
class DictValuesConf:
    _target_: str = "tests.test_modules.DictValues"
    dct: Dict[str, str] = MISSING
    enum_key: Dict[Color, str] = MISSING
    dataclass_val: Dict[str, User] = MISSING
    passthrough_dict: Any = MISSING  # Dict[str, LibraryClass]
    def_value: Dict[str, str] = field(default_factory=lambda: {})


@dataclass
class TuplesConf:
    _target_: str = "tests.test_modules.Tuples"
    t1: Tuple[float, float] = MISSING
    t2: Any = (1, 2, 3)
    t3: Tuple[float, ...] = (0.1, 0.2, 0.3)


@dataclass
class PeskySentinelUsageConf:
    _target_: str = "tests.test_modules.PeskySentinelUsage"
    foo: Any = MISSING  # PeskySentinel
