import queue
import unittest

from patterns.creational.pool import ObjectPool


class TestPool(unittest.TestCase):
    def setUp(self):
        self.sample_queue = queue.Queue()
        self.sample_queue.put("first")
        self.sample_queue.put("second")

    def test_items_recoil(self):
        with ObjectPool(self.sample_queue, True) as pool:
            self.assertEqual(pool, "first")
        self.assertTrue(self.sample_queue.get() == "second")
        self.assertFalse(self.sample_queue.empty())
        self.assertTrue(self.sample_queue.get() == "first")
        self.assertTrue(self.sample_queue.empty())

    def test_frozen_pool(self):
        with ObjectPool(self.sample_queue) as pool:
            self.assertEqual(pool, "first")
            self.assertEqual(pool, "first")
        self.assertTrue(self.sample_queue.get() == "second")
        self.assertFalse(self.sample_queue.empty())
        self.assertTrue(self.sample_queue.get() == "first")
        self.assertTrue(self.sample_queue.empty())


class TestNaitivePool(unittest.TestCase):
    """def test_object(queue):
    queue_object = QueueObject(queue, True)
    print('Inside func: {}'.format(queue_object.object))"""

    def test_pool_behavior_with_single_object_inside(self):
        sample_queue = queue.Queue()
        sample_queue.put("yam")
        with ObjectPool(sample_queue) as obj:
            # print('Inside with: {}'.format(obj))
            self.assertEqual(obj, "yam")
        self.assertFalse(sample_queue.empty())
        self.assertTrue(sample_queue.get() == "yam")
        self.assertTrue(sample_queue.empty())

    # sample_queue.put('sam')
    # test_object(sample_queue)
    # print('Outside func: {}'.format(sample_queue.get()))

    # if not sample_queue.empty():
