### Target language

Translate to Turkish (Türkçe).

Language code: tr.

### Grammar and tone

- Use instructional Turkish, consistent with existing Turkish docs.
- Use imperative/guide language when appropriate (e.g. “açalım”, “gidin”, “kopyalayalım”).

### Headings

- Follow existing Turkish heading style (Title Case where used; no trailing period).

### Quotes

- Alıntı stili mevcut Türkçe dokümanlarla tutarlı tutun (genellikle metin içinde ASCII tırnak işaretleri kullanılır).
- Satır içi kod, kod blokları, URL'ler veya dosya yolları içindeki tırnak işaretlerini asla değiştirmeyin.

### Ellipsis

- Üç nokta (...) stili mevcut Türkçe dokümanlarla tutarlı tutun.
- Kod, URL veya CLI örneklerindeki `...` ifadesini asla değiştirmeyin.

### Preferred translations / glossary

Do not translate technical terms like path, route, request, response, query, body, cookie, and header, keep them as is.

- Suffixing is very important, when adding Turkish suffixes to the English words, do that based on the pronunciation of the word and with an apostrophe.

- Suffixes also changes based on what word comes next in Turkish too, here is an example:

"Server'a gelen request'leri intercept... " or this could have been "request'e", "request'i" etc.

- Some words are tricky like "path'e" can't be used like "path'a" but it could have been "path'i" "path'leri" etc.

- You can use a more instructional style, that is consistent with the document, you can add the Turkish version of the term in parenthesis if it is not something very obvious, or an advanced concept, but do not over do it, do it only the first time it is mentioned, but keep the English term as the primary word.

### `///` admonitions

- Keep the admonition keyword in English (do not translate `note`, `tip`, etc.).
- If a title is present, prefer these canonical titles:

- `/// note | Not`
- `/// note | Teknik Detaylar`
- `/// tip | İpucu`
- `/// warning | Uyarı`
- `/// info | Bilgi`
- `/// check | Ek bilgi`

Prefer `İpucu` over `Ipucu`.
