# Додаткові типи даних { #extra-data-types }

До цього часу ви використовували загальнопоширені типи даних, такі як:

* `int`
* `float`
* `str`
* `bool`

Але ви також можете використовувати більш складні типи даних.

І ви все ще матимете ті ж можливості, які були показані до цього:

* Чудова підтримка редактора.
* Конвертація даних з вхідних запитів.
* Конвертація даних для відповіді.
* Валідація даних.
* Автоматична анотація та документація.

## Інші типи даних { #other-data-types }

Ось додаткові типи даних для використання:

* `UUID`:
    * Стандартний "Універсальний унікальний ідентифікатор", який часто використовується як ID у багатьох базах даних та системах.
    * У запитах та відповідях буде представлений як `str`.
* `datetime.datetime`:
    * Пайтонівський `datetime.datetime`.
    * У запитах та відповідях буде представлений як `str` у форматі ISO 8601, як: `2008-09-15T15:53:00+05:00`.
* `datetime.date`:
    * Пайтонівський `datetime.date`.
    * У запитах та відповідях буде представлений як `str` у форматі ISO 8601, як: `2008-09-15`.
* `datetime.time`:
    * Пайтонівський `datetime.time`.
    * У запитах та відповідях буде представлений як `str` у форматі ISO 8601, як: `14:23:55.003`.
* `datetime.timedelta`:
    * Пайтонівський `datetime.timedelta`.
    * У запитах та відповідях буде представлений як `float` загальної кількості секунд.
    * Pydantic також дозволяє представляти це як "ISO 8601 time diff encoding", <a href="https://docs.pydantic.dev/latest/concepts/serialization/#custom-serializers" class="external-link" target="_blank">дивіться документацію для отримання додаткової інформації</a>.
* `frozenset`:
    * У запитах і відповідях це буде оброблено так само, як і `set`:
        * У запитах список буде зчитано, дублікати буде видалено, і його буде перетворено на `set`.
        * У відповідях `set` буде перетворено на `list`.
        * Згенерована схема буде вказувати, що значення `set` є унікальними (з використанням JSON Schema's `uniqueItems`).
* `bytes`:
    * Стандартний Пайтонівський `bytes`.
    * У запитах і відповідях це буде оброблено як `str`.
    * Згенерована схема буде вказувати, що це `str` з "форматом" `binary`.
* `Decimal`:
    * Стандартний Пайтонівський `Decimal`.
    * У запитах і відповідях це буде оброблено так само, як і `float`.
* Ви можете перевірити всі дійсні типи даних Pydantic тут: <a href="https://docs.pydantic.dev/latest/usage/types/types/" class="external-link" target="_blank">типи даних Pydantic</a>.

## Приклад { #example }

Ось приклад *операції шляху* з параметрами, використовуючи деякі з вищезазначених типів.

{* ../../docs_src/extra_data_types/tutorial001_an_py310.py hl[1,3,12:16] *}

Зверніть увагу, що параметри всередині функції мають свій звичайний тип даних, і ви можете, наприклад, виконувати звичайні маніпуляції з датами, такі як:

{* ../../docs_src/extra_data_types/tutorial001_an_py310.py hl[18:19] *}
