# Параметри шляху та валідація числових даних { #path-parameters-and-numeric-validations }

Так само як ви можете оголошувати додаткові перевірки та метадані для query параметрів за допомогою `Query`, ви можете оголошувати той самий тип перевірок і метаданих для параметрів шляху за допомогою `Path`.

## Імпорт `Path` { #import-path }

Спочатку імпортуйте `Path` з `fastapi` і імпортуйте `Annotated`:

{* ../../docs_src/path_params_numeric_validations/tutorial001_an_py310.py hl[1,3] *}

/// info | Інформація

FastAPI додав підтримку `Annotated` (і почав рекомендувати його використання) у версії 0.95.0.

Якщо у вас стара версія, при спробі використати `Annotated` можуть виникати помилки.

Переконайтеся, що ви [оновили версію FastAPI](../deployment/versions.md#upgrading-the-fastapi-versions){.internal-link target=_blank} принаймні до версії 0.95.1 перед використанням `Annotated`.

///

## Оголошення метаданих { #declare-metadata }

Ви можете оголошувати всі ті ж параметри, що і для `Query`.

Наприклад, щоб оголосити значення метаданих `title` для параметра шляху `item_id`, ви можете написати:

{* ../../docs_src/path_params_numeric_validations/tutorial001_an_py310.py hl[10] *}

/// note | Примітка

Параметр шляху завжди є обов’язковим, оскільки він має бути частиною шляху. Навіть якщо ви оголосите його зі значенням `None` або встановите значення за замовчуванням — це ні на що не вплине, він все одно завжди буде обов’язковим.

///

## Упорядковуйте параметри, як вам потрібно { #order-the-parameters-as-you-need }

/// tip | Порада

Це, мабуть, не настільки важливо або необхідно, якщо ви використовуєте `Annotated`.

///

Припустимо, ви хочете оголосити параметр запиту `q` як обов’язковий `str`.

І вам не потрібно оголошувати нічого іншого для цього параметра, тому вам насправді не потрібно використовувати `Query`.

Але вам все одно потрібно використовувати `Path` для параметра шляху `item_id`. І з певних причин ви не хочете використовувати `Annotated`.

Python видасть помилку, якщо розмістити значення з "default" перед значенням, яке не має "default".

Але ви можете змінити порядок і розмістити значення без значення за замовчуванням (параметр запиту `q`) першим.

Для **FastAPI** порядок не має значення. Він визначає параметри за їхніми іменами, типами та оголошеннями за замовчуванням (`Query`, `Path` тощо) і не звертає уваги на порядок.

Тому ви можете оголосити вашу функцію так:

{* ../../docs_src/path_params_numeric_validations/tutorial002_py39.py hl[7] *}

Але майте на увазі, що якщо ви використовуєте `Annotated`, цієї проблеми не буде, це не матиме значення, оскільки ви не використовуєте значення за замовчуванням параметрів функції для `Query()` або `Path()`.

{* ../../docs_src/path_params_numeric_validations/tutorial002_an_py39.py *}

## Упорядковуйте параметри, як вам потрібно: хитрощі { #order-the-parameters-as-you-need-tricks }

/// tip | Порада

Це, мабуть, не настільки важливо або необхідно, якщо ви використовуєте `Annotated`.

///

Ось **невелика хитрість**, яка може стати в пригоді, хоча вона рідко знадобиться.

Якщо ви хочете:

* оголосити параметр запиту `q` без `Query` і без жодного значення за замовчуванням
* оголосити параметр шляху `item_id`, використовуючи `Path`
* розмістити їх у різному порядку
* не використовувати `Annotated`

...у Python є спеціальний синтаксис для цього.

Передайте `*` як перший параметр функції.

Python нічого не зробить із цією `*`, але розпізнає, що всі наступні параметри слід викликати як аргументи за ключовим словом (пари ключ-значення), також відомі як <abbr title="From: K-ey W-ord Arg-uments"><code>kwargs</code></abbr>. Навіть якщо вони не мають значення за замовчуванням.

{* ../../docs_src/path_params_numeric_validations/tutorial003_py39.py hl[7] *}

### Краще з `Annotated` { #better-with-annotated }

Майте на увазі, що якщо ви використовуєте `Annotated`, оскільки ви не використовуєте значення за замовчуванням параметрів функції, цієї проблеми не буде, і, ймовірно, вам не потрібно буде використовувати `*`.

{* ../../docs_src/path_params_numeric_validations/tutorial003_an_py39.py hl[10] *}

## Валідація числових даних: більше або дорівнює { #number-validations-greater-than-or-equal }

За допомогою `Query` і `Path` (та інших, які ви побачите пізніше) можна оголошувати числові обмеження.

Тут, завдяки `ge=1`, `item_id` має бути цілим числом, яке "`g`reater than or `e`qual" (більше або дорівнює) `1`.

{* ../../docs_src/path_params_numeric_validations/tutorial004_an_py39.py hl[10] *}

## Валідація числових даних: більше ніж і менше або дорівнює { #number-validations-greater-than-and-less-than-or-equal }

Те саме застосовується до:

* `gt`: `g`reater `t`han
* `le`: `l`ess than or `e`qual

{* ../../docs_src/path_params_numeric_validations/tutorial005_an_py39.py hl[10] *}

## Валідація числових даних: float, більше ніж і менше ніж { #number-validations-floats-greater-than-and-less-than }

Валідація чисел також працює для значень типу `float`.

Ось де стає важливо мати можливість оголошувати <abbr title="greater than"><code>gt</code></abbr>, а не тільки <abbr title="greater than or equal"><code>ge</code></abbr>. Це дозволяє, наприклад, вимагати, щоб значення було більше `0`, навіть якщо воно менше `1`.

Таким чином, значення `0.5` буде допустимим. Але `0.0` або `0` — ні.

Те саме стосується <abbr title="less than"><code>lt</code></abbr>.

{* ../../docs_src/path_params_numeric_validations/tutorial006_an_py39.py hl[13] *}

## Підсумок { #recap }

За допомогою `Query`, `Path` (і інших параметрів, які ви ще не бачили) можна оголошувати метадані та перевірки рядків так само як у [Query параметри та валідація рядків](query-params-str-validations.md){.internal-link target=_blank}.

Також можна оголошувати числові перевірки:

* `gt`: `g`reater `t`han
* `ge`: `g`reater than or `e`qual
* `lt`: `l`ess `t`han
* `le`: `l`ess than or `e`qual

/// info | Інформація

`Query`, `Path` та інші класи, які ви побачите пізніше, є підкласами спільного класу `Param`.

Всі вони мають однакові параметри для додаткових перевірок і метаданих, які ви вже бачили.

///

/// note | Технічні деталі

Коли ви імпортуєте `Query`, `Path` та інші з `fastapi`, насправді це функції.

При виклику вони повертають екземпляри класів з такими ж іменами.

Тобто ви імпортуєте `Query`, яка є функцією. А коли ви її викликаєте, вона повертає екземпляр класу, який теж називається `Query`.

Ці функції створені таким чином (замість використання класів напряму), щоб ваш редактор не відзначав їхні типи як помилки.

Таким чином, ви можете користуватися своїм звичайним редактором і інструментами для програмування без додаткових налаштувань для ігнорування таких помилок.

///
