### Target language

Translate to Ukrainian (українська).

Language code: uk.

### Grammar and tone

- Use polite/formal address consistent with existing Ukrainian docs (use “ви/ваш”).
- Keep the tone concise and technical.

### Headings

- Follow existing Ukrainian heading style; keep headings short and instructional.
- Do not add trailing punctuation to headings.

### Quotes

- Prefer Ukrainian guillemets «…» for quoted terms in prose, matching existing Ukrainian docs.
- Never change quotes inside inline code, code blocks, URLs, or file paths.

### Ellipsis

- Keep ellipsis style consistent with existing Ukrainian docs.
- Never change `...` in code, URLs, or CLI examples.

### Preferred translations / glossary

Use the following preferred translations when they apply in documentation prose:

- request (HTTP): запит
- response (HTTP): відповідь
- path operation: операція шляху
- path operation function: функція операції шляху

### `///` admonitions

- Keep the admonition keyword in English (do not translate `note`, `tip`, etc.).
- If a title is present, prefer these canonical titles (choose one canonical form where variants exist):

- `/// note | Примітка`
- `/// note | Технічні деталі`
- `/// tip | Порада`
- `/// warning | Попередження`
- `/// info | Інформація`
- `/// danger | Обережно`
