Contributing to Feature-engine
==============================

Feature-engine is a community-driven open-source project that relies on contributions from 
people like you. Every contribution, no matter how big or small, can make a significant 
impact on the project. If you've never contributed to an open-source project before, don't 
worry! Feature-engine is a great place to start. Your help will be appreciated and welcomed 
with gratitude.

The latest contributing guide is available online at:

https://feature-engine.trainindata.com/en/latest/contribute/index.html

There are many ways to contribute to Feature-engine, with the most common ones
being contribution of code or documentation to the project. Improving the
documentation is no less important than improving the library itself. If you
find a typo in the documentation, or have made improvements, do not hesitate to
submit a GitHub pull request.

Documentation can be found under the
[doc/](https://github.com/feature-engine/feature_engine/tree/main/docs) directory.

You can check out requested enhancements and current bugs on the
[issue tracker](https://github.com/feature-engine/feature_engine/issues),
and suggest a PR with the fix. Every contribution is valuable and decreases the burden 
on the project maintainer.

Another way to contribute is to report issues you're facing, and give a "thumbs
up" on issues that others reported and that are relevant to you. It also helps
us if you spread the word: reference the project from your blog and articles,
link to it from your website, or simply star it in GitHub to say "I use it".

Quick links
-----------

* [Submitting a bug report or feature request](https://github.com/feature-engine/feature_engine/issues)
* [Contributing code](https://feature-engine.trainindata.com/en/latest/contribute/contribute_code.html)
* [Contributing docs](https://feature-engine.trainindata.com/en/latest/contribute/contribute_docs.html)
* [Other ways to contribute](https://feature-engine.trainindata.com/en/latest/contribute/contribute_other.html)

Code of Conduct
---------------

We abide by the principles of openness, respect, and consideration of others
of the Python Software Foundation: https://www.python.org/psf/codeofconduct/.