## Introduction

First off, thank you for considering contributing to Flexx! Following
these guidelines should help to streamline the communication between
you and the developers.

There are many ways to contribute, from writing tutorials or blog posts,
improving the docs, submitting bug reports and feature requests or
writing code to be included in Flexx itself.

As there are currently no other channels for communication of support questions,
these can be asked using Github issues (for now). For more formal support, you
can contact almarklein via gmail.


## Ground Rules

* Communicate respectfully.
* Be welcoming to newcomers and encourage diverse new contributors from
  all backgrounds. See the [Python Community Code of
  Conduct](https://www.python.org/psf/codeofconduct/).
* Keep in mind that the code must be cross platform (Window, OSX, Linux, at least).
* In most cases, new code should be covered by tests
* Please make sure that new code follows the style guides. Flexx intends
  to not be overly dogmatic about style (e.g. most whitespace-related
  rules are ignored) but style is enforced by tests.


## Your First Contribution

If you're relatively new to Flexx, but would want to contribute, it is already
helpful to just try it out and report any problems that you run into (e.g. things
thare are unclear, counterintuitive or not documented well). Writing a
blog post about something cool that you made with Flexx is also very
helpful.

At this point, we do not have a special label for "easy issues" to work on.

Never contributed to open source before? Here are some useful reads:
http://makeapullrequest.com/ and http://www.firsttimersonly.com/

Feel free to ask for help; everyone is a beginner at first :)


## How to report a bug

If you find a security vulnerability, do NOT open an issue. Send
almarklein an email via gmail instead.

When filing an issue, make sure to answer these five questions:

* What version of Flexx are you using?
* What operating system and processor architecture are you using?
* What browser are you using (if applicable)?
* What did you do?
* What did you expect to see?
* What did you see instead?


## How to suggest a feature or enhancement

Please first check whether the feature (or a very similar feature) has
already been requested. If so, subscribe to that issue. Otherwise,
create a new issue describing the proposed feature and why it is
relevant (to you).


## Code review process

Pull requests are not merged if they the tests do not pass. Though review
may start before the pull request is completely finished.

All pull requests are reviewed before they are merged. Reviewers may ask
to clarify code or make suggestions to improve readability and style.
Don't feel bad if your contribution does not go as smooth as you had
hoped; we are gratefull with your contribution and the review
process is there to ensure code quality.

A reviewer may not always respond within a day; it might just be a busy
week. If a reviewer has not responded in say a week or two, feel free
to post a comment with a gentle reminder.


## Community

All community traffic goes through Github for now.
