# Contribution Guidelines

Your contributions are always welcome! Thank you for your suggestions! :smiley:

Please note that this project is released with a 
[Contributor Code of Conduct](https://github.com/frenck/awesome-home-assistant/blob/master/CODE_OF_CONDUCT.md).
By participating in this project you agree to abide by its terms.

Contributing is pretty easy, all you need is an GitHub account.

[Just click this link to edit the list, right from your browser](https://github.com/frenck/awesome-home-assistant/edit/master/README.md).

## Guidelines

### Link requirements

The site the link targets **MUST BE**:

- Be widely recommended regardless of personal opinion.
- Well known or discussed within the Community.
- Related to Home Assistant OR provide software, tools, and utilities
  that can be used with Home Assistant.
- Written in English.

Self-promotion is frowned upon, so please consider seriously whether your
project meets the criteria before opening a pull request, otherwise, it may
be closed without being reviewed.

### Adding a new link

- **Make an individual pull request for each link suggestion.**
- Search previous suggestions before making a new one, as yours may be a duplicate.
- Use the following format: `- [project-name](http://example.com/) - A short description ends with a period.`
  - Keep the description short and simple, but descriptive.
  - A description ends with a full stop/period `.`!
  - Don't mention `Home Assistant` in the description as it's implied.
- Check your spelling and grammar.
- Make sure that your suggestion is positioned as the last item category.

### Adding a new section/category

New categories or improvements to the existing categorization are welcome.

- Ensure the section has a nice description.
- A description ends with a full stop/period `.`!
- Add the section to the table of contents.
- Check your spelling and grammar.
- Remove any trailing whitespace.

### Deleting a link

Typical reasons for deleting links:

- The item does no longer apply to or work with the latest Home Assistant.
- No updates / abandoned.
- Deprecated.
- In case of software: License missing.
- Dead link.
