# Contribution Guidelines

Before sending a Pull Request or opening an Issue, ensure it adheres to the following guidelines and policies.

Search previous suggestions and open issues before making a new one, as yours may be a duplicate.

Here's how you can contribute:

- Look at open [Issues](https://github.com/avivace/awesome-gbdev/issues) and provide help or feedback 
- [Add a resource](#adding-a-resource)
- [Correct and improve existing entries](#correcting-and-improving-resources)
- [Fix broken links and unavailable resources](#removing-unavailable-resources)
- [Discuss on what should and shouldn't go on the list](https://github.com/gbdev/awesome-gbdev/issues/96), the 'awesome' quality standard

If you are unsure about something or need help, we have a friendly Discord [chat](https://discord.gg/gpBxq85).

## Adding a resource

### Is it "awesome"?

For a resource to be added to the list, it must...

- Be in english;
- Be in a minimal working state;
- Have a clear purpose (implementation reference is okay, too) and/or provide something interesting;
- Provide a minimal documentation briefly describing what is the project and how to make use of it.

These criteria are discussed [here](https://github.com/gbdev/awesome-gbdev/issues/96).

If the resource is in another language, still work in progress, abandoned or you don't think reaches the described standard BUT it's still related to Game Boy development/hacking you can add it to the **MORE.md** file.

### Pull Request

- Make an individual pull request for each suggestion.
- Use the following format: `[resource](link) - Description.`
- Additions should be added to the bottom of the relevant category.
- New categories or improvements to the existing categorization are appreciated. You're welcome to discuss discrimination and categorization criteria in Issues/PRs.
- Keep descriptions short and simple, but descriptive, pointing out the particularities or major features of the resource.
- Start the description with a capital and end with a full stop/period.
- Check your spelling and grammar.
- It's `Game Boy`, not `gameboy`, `game boy` or `GameBoy`, however, you should honor the title or name of the resource while linking it, even if it's using a wrong lettering \[[1](https://github.com/avivace/awesome-gbdev/issues/34)\].
- Open source emulators go to the EMULATORS.md file.

If you are not confident in forking the repository, making the change and sending the PR, don't hesitate to open an Issue describing the addition (or the change you want to make/discuss).

Before the PR gets approved and merged, we may require a number of reviews from our contributors.

## Correcting and improving resources

Most of the linked resources are hosted on Git repositories. You are encouraged to report errors in the corresponding upstream repository or contact the authors. If the correction doesn't get merged, fork it and mantain an updated/correct version and open a PR replacing the link on the list with your version.

In any case, open an Issue mentioning the error and its magnitude. This can have two outcomes:

- If the resource is unique/important - while we wait for the error getting corrected in the upstream source - we add an Errata notice next near the link. OR
- The resource gets moved in MORE, until it reaches a decent/maintanable/correct state.

If you think something doesn't fit the list, open an Issue or a PR mentioning the reasons.

## Removing unavailable resources

You're welcome to remove any broken link in the repository, but first try to find a reliable mirror and replace it:

- Check on [Archive.org](https://archive.org/) and Google Cache;
- We may already mirrored it in [*The Game Boy Archive*](https://github.com/gb-archive/core) project;
- Try the GitHub search.

Then, **open an Issue** with any useful details.

If you have some old and unavailable resource (not necessarly listed in the missing list) archived in your hard disk that maybe in the interest (even historical!) of the Game Boy development community, please open an Issue attaching or linking the resource.

### Keeping a resource online

If the resource was published under a license (e.g. OSS), keeping it online (re-uploading, finding mirrors, etc) is always suggested.

If there isn't, discuss with upstream authors and understand their decisions/wishes. You should open an issue to discuss about this.

#### Thank you!
