### Open Source emulators

| Name | Language | Details |
| --- | --- | --- |
| [Binjgb](https://github.com/binji/binjgb) | C | 5kloc emulator that passes most of the tests. *Rewind* feature. Runs in the browser using WebAssembly |
| [Wadatsumi](https://github.com/arrow-lang/wadatsumi) | Arrow | |
| [cboy](https://github.com/jkbenaim/cboy) | C |
| [miniBoy](https://github.com/Dhole/miniBoy) | C | |
| [SameBoy](https://github.com/LIJI32/SameBoy) | C | |
| [giibiiadvance](https://github.com/AntonioND/giibiiadvance) | C | A GB, GBC emulator with GB Camera support.|
| [mGBA](https://github.com/mgba-emu/mgba) | C | A modern cross platform GBA emulator which also runs GB/GBC games. |
| [gnuboy](https://github.com/rofl0r/gnuboy) | C | ANSI C |
| [PlutoBoy](https://github.com/RossMeikleham/PlutoBoy) | C | Cross platform (Windows, OSX, Linux/Unix, Android, iOS, Web Browsers, and Sony PSP) emulator |
| [SuperGameHerm](https://github.com/foxkit-us/supergameherm) | C 11 | Cross platform emulator |
| [Castor](https://github.com/kosinw/Castor) | C#, Monogame |
| [GameYob](https://github.com/Drenn1/GameYob) | C++, C# | GB, GBC emulator for Nintendo DS/3DS |
| [jgilchrist](https://github.com/jgilchrist/emulator) | C++ |
| [gameboycore](https://github.com/nnarain/gameboycore) | C++ 11 | C++ emulation backend. Dependency free library. |
| [GameBoyEmulator-GBS](https://github.com/Salgat/GameBoyEmulator-GBS) | C++ 14 | with a single library dependency of SFML |
| [oneup-gb](https://github.com/oneup40/oneup-gb) | C++ | DMG. Currently provides SDL frontend and Retroarch integration |
| [Gearboy](https://github.com/drhelius/Gearboy) | C++ | iOS, Raspberry Pi, Mac, Windows and Linux |
| [SmartGear](https://github.com/bitbank2/sg_free) | C++, SDL2 | Focus on optimized performance for resource-limited devices. GTK or direct framebuffer build |
| [PatBoy](https://github.com/Jonazan2/PatBoy) | C++, SDL2 | with a fully functional visual debugger |
| [GameLad](https://github.com/Dooskington/GameLad) | C++/SDL | Almost fully featured emulator |
| [GBE+](https://github.com/shonumi/gbe-plus) | C++, SDL | Focused on enhancements |
| [hhugboy](https://github.com/tzlion/hhugboy) | C++ | Windows, based on GEST v1.1.1 by TM, with added support for unlicensed mappers, Unicode filenames, screenshots and some other stuff |
| [DDMG](https://github.com/mstojcevich/ddmg) | D |
| [FunGBC](https://github.com/andreasjhkarlsson/fungbc) | F# | |
| [gameboyGO](https://github.com/gonccalo/gameboyGO) | Go |
| [gomeboycolor](https://github.com/djhworld/gomeboycolor) | Go | Cross platform [documented](http://djhworld.github.io/gomeboycolor/) emulator. [WASM](https://github.com/djhworld/gomeboycolor-wasm) port. |
| [AndroidGameBoyEmulator](https://github.com/pedrovgs/AndroidGameBoyEmulator) | Java | |
| [OOPBoy](https://github.com/429ers/OOPBoy) | Java | Full-featured, cycle-accurate, cross-platform emulator with several debugging features. |
| [Coffee GB](https://github.com/trekawek/coffee-gb) | Java 8 |
| [weplay](https://github.com/rauchg/weplay) | JavaScript | Collaborative Game Boy emulation |
| [GBRE](https://github.com/ericgramgb/GBRE) | JavaScript | GB Runtime Environment for iOS (iOS Safari and Chrome) |
| [gameboy-Online](https://github.com/taisel/gameboy-Online) | JavaScript | Uses HTML5 canvas and JavaScript audio APIs |
| [node-gameboy](https://github.com/gb-archive/node-gameboy) | Node.js |
| [php-terminal-Game Boy-emulator](https://github.com/gabrielrcouto/php-terminal-gameboy-emulator) | PHP | |
| [PyBoy](https://github.com/Baekalfen/PyBoy) | Python | Mac, Linux and Windows |
| [barnacleboy](https://github.com/rep-nop/barnacleboy) | Rust | |
| [gb-rs](https://github.com/simias/gb-rs) | Rust | |
| [scimitar](https://github.com/tompko/scimitar) | Rust | |
| [rustboy](https://github.com/VelocityRa/rustboy) | Rust | A basic DMG emulator written in Rust, using the Piston engine for window creation and graphics |
| [Gambattye](https://github.com/Ben10do/Gambattye) | Swift | macOS, powered by a fork of Gambatte |
| [wasmBoy](https://github.com/torch2424/wasmBoy) | Web Assembly (AssemblyScript) | GB/GBC *Library* written for Web Assembly using AssemblyScript. Shell/Debugger in Preact.|
| [vaporBoy](https://github.com/torch2424/vaporBoy) | Javascript | PWA. Powered by [wasmBoy](https://github.com/torch2424/wasmBoy) |
| [elmBoy](https://github.com/Malax/elmboy) | Elm | |
| [goboy](https://github.com/Humpheh/goboy) | Go | |
| [xgbc](https://github.com/kotcrab/xgbc) | Kotlin | |
| [UEFIBoy](https://github.com/RossMeikleham/UEFIBoy) | UEFI | |
| [Peanut-GB](https://github.com/deltabeard/Peanut-GB) | C | A high performance, inaccurate, DMG emulator single header library written in C99. Comes with examples, such as [Peanut-SDL](https://github.com/deltabeard/Peanut-GB/tree/master/examples/sdl2), which uses its own [APU implementation](https://github.com/deltabeard/Peanut-GB/blob/master/examples/sdl2/minigb_apu/minigb_apu.c), or optionally Shay Green's gb_apu. MIT. |
| [Worldwide](https://github.com/Akatsuki-py/Worldwide) | Go | Cross platform and full-featured GBC emulator (Japanese) |
| [Kotlin-Gameboy-Emulator](https://github.com/stan-roelofs/Kotlin-Gameboy-Emulator) | Kotlin | Cross platform DMG emulator |
| [Emux](https://github.com/Washi1337/Emux) | C# | |
| [Y2Dmg](https://github.com/Y2JB/DMG) | C# | Fully featured DMG emulator written in C#. Passes Blargg's test roms and supports most games. Core is cross platform (.net core), renderer is Windows only.|
| [Gandalf](https://github.com/stan-roelofs/Gandalf) | C++ | Cross-platform GB, GBC emulator with an SDL/ImGui frontend that provides several debugging features. |
| [Boytacean](https://github.com/joamag/boytacean) | Rust | A Game Boy emulator that is written in Rust, with a beautiful Web interface that makes use of WASM. |
| [Gameboy](https://github.com/raphamorim/gameboy) | Rust | Game Boy emulator written in Rust that runs as a desktop application or in the browser through WebAssembly |
