# Contributing
First of all, your contributions are always welcome!

This list aims to provide a concise overview of significant Vision-Language Models (VLMs) and resources. This means that the suggested models or resources are:

- Endorsed by a broad audience, not just based on individual preference.
- Subject to widespread discussion within the community for its groundbreaking aspects.
- Fills a specific void, catering to a particular need.

## Guidelines
To ensure your pull request is accepted, please follow these guidelines:

- Verify if your suggestion has already been submitted to prevent redundancy.
- Ensure the recommended item is under active development. Avoid suggestions that are unmaintained, deprecated, have an archived repository, or lack documentation.
- Submit one pull request per suggestion for clarity.
- Contributions that introduce new categories or refine the existing framework are encouraged.
- Documentation should be in English.
- Proofread your submission to avoid spelling or grammatical errors.
- Adjust your text editor settings to remove trailing whitespace.
- While we appreciate contributions, we advise against submitting your own projects. It's preferable to have someone else recognize the value of your work and recommend it.

## Pull requests
1. Fork it!
2. Create your branch: git checkout -b my-new-branch
3. Commit your changes: git commit -am 'fix stuff'
4. Push to the branch: git push origin my-new-branch
5. Submit a pull request