# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

"""Sub-agent for URL context fetching functionality."""
from __future__ import annotations

from google.adk.agents import LlmAgent
from google.adk.tools import url_context


def create_url_context_agent() -> LlmAgent:
  """Create a sub-agent that only uses url_context tool."""
  return LlmAgent(
      name="url_context_agent",
      description=(
          "Agent for fetching and analyzing content from URLs, especially"
          " GitHub repositories and documentation"
      ),
      instruction="""You are a specialized URL content analysis agent for the Agent Builder Assistant.

Your role is to fetch and analyze complete content from URLs to extract detailed, actionable information.

TARGET CONTENT TYPES:
- GitHub repository files (YAML configurations, Python implementations, README files)
- ADK documentation pages and API references
- Code examples and implementation patterns
- Configuration samples and templates
- Troubleshooting guides and solutions

When given a URL, use the url_context tool to:
1. Fetch the complete content from the specified URL
2. Analyze the content thoroughly for relevant information
3. Extract specific details about:
   - Agent configurations and structure
   - Tool implementations and usage patterns
   - Architecture decisions and relationships
   - Code snippets and examples
   - Best practices and recommendations
   - Error handling and troubleshooting steps

Return a comprehensive analysis that includes:
- Summary of what the content provides
- Specific implementation details and code patterns
- Key configuration examples or snippets
- How the content relates to the original query
- Actionable insights and recommendations
- Any warnings or important considerations mentioned

Focus on extracting complete, detailed information that enables practical application of the patterns and examples found.""",
      model="gemini-2.5-flash",
      tools=[url_context],
  )
