# Copyright 2025 Google LLC
#
# Licensed under the Apache License, Version 2.0 (the "License");
# you may not use this file except in compliance with the License.
# You may obtain a copy of the License at
#
#     http://www.apache.org/licenses/LICENSE-2.0
#
# Unless required by applicable law or agreed to in writing, software
# distributed under the License is distributed on an "AS IS" BASIS,
# WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
# See the License for the specific language governing permissions and
# limitations under the License.

from __future__ import annotations

import logging
from typing import List
from typing import Optional
from typing import Union

from ...auth.auth_credential import ServiceAccount
from ..base_toolset import ToolPredicate
from .google_api_toolset import GoogleApiToolset

logger = logging.getLogger("google_adk." + __name__)


class BigQueryToolset(GoogleApiToolset):
  """Auto-generated BigQuery toolset based on Google BigQuery API v2 spec exposed by Google API discovery API.

  Args:
    client_id: OAuth2 client ID for authentication.
    client_secret: OAuth2 client secret for authentication.
    tool_filter: Optional filter to include only specific tools or use a predicate function.
    service_account: Optional service account for authentication.
    tool_name_prefix: Optional prefix to add to all tool names in this toolset.
  """

  def __init__(
      self,
      client_id: Optional[str] = None,
      client_secret: Optional[str] = None,
      tool_filter: Optional[Union[ToolPredicate, List[str]]] = None,
      service_account: Optional[ServiceAccount] = None,
      tool_name_prefix: Optional[str] = None,
  ):
    super().__init__(
        "bigquery",
        "v2",
        client_id,
        client_secret,
        tool_filter,
        service_account,
        tool_name_prefix,
    )


class CalendarToolset(GoogleApiToolset):
  """Auto-generated Calendar toolset based on Google Calendar API v3 spec exposed by Google API discovery API.

  Args:
    client_id: OAuth2 client ID for authentication.
    client_secret: OAuth2 client secret for authentication.
    tool_filter: Optional filter to include only specific tools or use a predicate function.
    service_account: Optional service account for authentication.
    tool_name_prefix: Optional prefix to add to all tool names in this toolset.
  """

  def __init__(
      self,
      client_id: Optional[str] = None,
      client_secret: Optional[str] = None,
      tool_filter: Optional[Union[ToolPredicate, List[str]]] = None,
      service_account: Optional[ServiceAccount] = None,
      tool_name_prefix: Optional[str] = None,
  ):
    super().__init__(
        "calendar",
        "v3",
        client_id,
        client_secret,
        tool_filter,
        service_account,
        tool_name_prefix,
    )


class GmailToolset(GoogleApiToolset):
  """Auto-generated Gmail toolset based on Google Gmail API v1 spec exposed by Google API discovery API.

  Args:
    client_id: OAuth2 client ID for authentication.
    client_secret: OAuth2 client secret for authentication.
    tool_filter: Optional filter to include only specific tools or use a predicate function.
    service_account: Optional service account for authentication.
    tool_name_prefix: Optional prefix to add to all tool names in this toolset.
  """

  def __init__(
      self,
      client_id: Optional[str] = None,
      client_secret: Optional[str] = None,
      tool_filter: Optional[Union[ToolPredicate, List[str]]] = None,
      service_account: Optional[ServiceAccount] = None,
      tool_name_prefix: Optional[str] = None,
  ):
    super().__init__(
        "gmail",
        "v1",
        client_id,
        client_secret,
        tool_filter,
        service_account,
        tool_name_prefix,
    )


class YoutubeToolset(GoogleApiToolset):
  """Auto-generated YouTube toolset based on YouTube API v3 spec exposed by Google API discovery API.

  Args:
    client_id: OAuth2 client ID for authentication.
    client_secret: OAuth2 client secret for authentication.
    tool_filter: Optional filter to include only specific tools or use a predicate function.
    service_account: Optional service account for authentication.
    tool_name_prefix: Optional prefix to add to all tool names in this toolset.
  """

  def __init__(
      self,
      client_id: Optional[str] = None,
      client_secret: Optional[str] = None,
      tool_filter: Optional[Union[ToolPredicate, List[str]]] = None,
      service_account: Optional[ServiceAccount] = None,
      tool_name_prefix: Optional[str] = None,
  ):
    super().__init__(
        "youtube",
        "v3",
        client_id,
        client_secret,
        tool_filter,
        service_account,
        tool_name_prefix,
    )


class SlidesToolset(GoogleApiToolset):
  """Auto-generated Slides toolset based on Google Slides API v1 spec exposed by Google API discovery API.

  Args:
    client_id: OAuth2 client ID for authentication.
    client_secret: OAuth2 client secret for authentication.
    tool_filter: Optional filter to include only specific tools or use a predicate function.
    service_account: Optional service account for authentication.
    tool_name_prefix: Optional prefix to add to all tool names in this toolset.
  """

  def __init__(
      self,
      client_id: Optional[str] = None,
      client_secret: Optional[str] = None,
      tool_filter: Optional[Union[ToolPredicate, List[str]]] = None,
      service_account: Optional[ServiceAccount] = None,
      tool_name_prefix: Optional[str] = None,
  ):
    super().__init__(
        "slides",
        "v1",
        client_id,
        client_secret,
        tool_filter,
        service_account,
        tool_name_prefix,
    )


class SheetsToolset(GoogleApiToolset):
  """Auto-generated Sheets toolset based on Google Sheets API v4 spec exposed by Google API discovery API.

  Args:
    client_id: OAuth2 client ID for authentication.
    client_secret: OAuth2 client secret for authentication.
    tool_filter: Optional filter to include only specific tools or use a predicate function.
    service_account: Optional service account for authentication.
    tool_name_prefix: Optional prefix to add to all tool names in this toolset.
  """

  def __init__(
      self,
      client_id: Optional[str] = None,
      client_secret: Optional[str] = None,
      tool_filter: Optional[Union[ToolPredicate, List[str]]] = None,
      service_account: Optional[ServiceAccount] = None,
      tool_name_prefix: Optional[str] = None,
  ):
    super().__init__(
        "sheets",
        "v4",
        client_id,
        client_secret,
        tool_filter,
        service_account,
        tool_name_prefix,
    )


class DocsToolset(GoogleApiToolset):
  """Auto-generated Docs toolset based on Google Docs API v1 spec exposed by Google API discovery API.

  Args:
    client_id: OAuth2 client ID for authentication.
    client_secret: OAuth2 client secret for authentication.
    tool_filter: Optional filter to include only specific tools or use a predicate function.
    service_account: Optional service account for authentication.
    tool_name_prefix: Optional prefix to add to all tool names in this toolset.
  """

  def __init__(
      self,
      client_id: Optional[str] = None,
      client_secret: Optional[str] = None,
      tool_filter: Optional[Union[ToolPredicate, List[str]]] = None,
      service_account: Optional[ServiceAccount] = None,
      tool_name_prefix: Optional[str] = None,
  ):
    super().__init__(
        "docs",
        "v1",
        client_id,
        client_secret,
        tool_filter,
        service_account,
        tool_name_prefix,
    )
