import gradio as gr
from transformers import pipeline

generator = pipeline('text-generation', model = 'gpt2')

def generate_text(text_prompt):
  response = generator(text_prompt, max_length = 30, num_return_sequences=5)
  return response[0]['generated_text']  # type: ignore

textbox = gr.Textbox()

demo = gr.Interface(generate_text, textbox, textbox, api_name="predict")

if __name__ == "__main__":
    demo.launch()
