# @gradio/fileexplorer

## 0.6.0

### Dependency updates

- @gradio/utils@0.11.1
- @gradio/client@2.0.2

## 0.6.0

### Features

- [#12539](https://github.com/gradio-app/gradio/pull/12539) [`f1d83fa`](https://github.com/gradio-app/gradio/commit/f1d83fac3d6e4bad60cf896a026fa2d572f26073) - Add ability to add custom buttons to components.  Thanks @abidlabs!
- [#12537](https://github.com/gradio-app/gradio/pull/12537) [`f753b0c`](https://github.com/gradio-app/gradio/commit/f753b0c97400068b7c0aa306e5d03fb500eec5fb) - Add `.select()` and `.input()` events to `gr.FileExplorer`.  Thanks @abidlabs!

### Dependency updates

- @gradio/atoms@0.20.0
- @gradio/checkbox@0.6.0
- @gradio/utils@0.11.0
- @gradio/client@2.0.1
- @gradio/statustracker@0.12.1
- @gradio/upload@0.17.3
- @gradio/file@0.14.0

## 0.5.42

### Dependency updates

- @gradio/checkbox@0.5.1

## 0.5.42

### Dependency updates

- @gradio/utils@0.10.4

## 0.5.42

### Features

- [#11908](https://github.com/gradio-app/gradio/pull/11908) [`029034f`](https://github.com/gradio-app/gradio/commit/029034f7853ea018d110efe9b7e2ef7d1407091c) - Clear Error statuses
- [#12438](https://github.com/gradio-app/gradio/pull/12438) [`25ffc03`](https://github.com/gradio-app/gradio/commit/25ffc0398f8feb43d817c02b2ab970c16de6d797) - Svelte5 migration and bugfix

### Dependencies

- @gradio/atoms@0.19.0
- @gradio/checkbox@0.5.0
- @gradio/client@2.0.0
- @gradio/file@0.13.1
- @gradio/icons@0.15.0
- @gradio/statustracker@0.12.0
- @gradio/upload@0.17.2
- @gradio/utils@0.10.3

## 0.5.42-dev.2

### Dependency updates

- @gradio/atoms@0.19.0-dev.1
- @gradio/client@2.0.0-dev.2
- @gradio/statustracker@0.12.0-dev.1
- @gradio/upload@0.17.2-dev.2
- @gradio/checkbox@0.5.0-dev.1
- @gradio/file@0.13.1-dev.2

## 0.5.42-dev.1

### Dependency updates

- @gradio/atoms@0.18.2-dev.0
- @gradio/upload@0.17.2-dev.1
- @gradio/utils@0.10.3-dev.0
- @gradio/statustracker@0.12.0-dev.0
- @gradio/icons@0.15.0-dev.0
- @gradio/checkbox@0.5.0-dev.0
- @gradio/file@0.13.1-dev.1

## 0.5.42-dev.0

### Dependency updates

- @gradio/client@2.0.0-dev.1

## 0.5.42-dev.0

### Dependency updates

- @gradio/upload@0.17.2-dev.0
- @gradio/client@2.0.0-dev.0
- @gradio/file@0.13.1-dev.0

## 0.5.41

### Dependency updates

- @gradio/client@1.19.1

## 0.5.41

### Dependency updates

- @gradio/upload@0.17.1
- @gradio/atoms@0.18.1

## 0.5.41

### Fixes

- [#11784](https://github.com/gradio-app/gradio/pull/11784) [`d9dd3f5`](https://github.com/gradio-app/gradio/commit/d9dd3f54b7fb34cf7118e549d39fc63937ca3489) - Add "hidden" option to component's `visible` kwarg to render but visually hide the component.  Thanks @pngwn!

### Dependency updates

- @gradio/statustracker@0.11.1
- @gradio/atoms@0.18.0
- @gradio/checkbox@0.4.30
- @gradio/client@1.19.0
- @gradio/upload@0.17.0
- @gradio/file@0.13.0

## 0.5.40

### Dependency updates

- @gradio/client@1.18.0
- @gradio/icons@0.14.0
- @gradio/atoms@0.17.0
- @gradio/statustracker@0.11.0
- @gradio/upload@0.16.17
- @gradio/file@0.12.29
- @gradio/checkbox@0.4.29

## 0.5.39

### Dependency updates

- @gradio/statustracker@0.10.18

## 0.5.39

### Dependency updates

- @gradio/icons@0.13.1
- @gradio/upload@0.16.16

## 0.5.39

### Dependency updates

- @gradio/statustracker@0.10.17
- @gradio/atoms@0.16.5
- @gradio/client@1.17.1
- @gradio/icons@0.13.0
- @gradio/upload@0.16.15
- @gradio/checkbox@0.4.28
- @gradio/file@0.12.28

## 0.5.38

### Dependency updates

- @gradio/statustracker@0.10.16
- @gradio/atoms@0.16.4
- @gradio/client@1.17.0
- @gradio/upload@0.16.14
- @gradio/checkbox@0.4.27
- @gradio/file@0.12.27

## 0.5.37

### Dependency updates

- @gradio/upload@0.16.13
- @gradio/client@1.16.0
- @gradio/file@0.12.26

## 0.5.36

### Dependency updates

- @gradio/upload@0.16.12
- @gradio/client@1.15.7
- @gradio/file@0.12.25

## 0.5.35

### Dependency updates

- @gradio/client@1.15.6
- @gradio/statustracker@0.10.15
- @gradio/upload@0.16.11
- @gradio/checkbox@0.4.26
- @gradio/file@0.12.24

## 0.5.34

### Dependency updates

- @gradio/atoms@0.16.3
- @gradio/statustracker@0.10.14
- @gradio/upload@0.16.10
- @gradio/client@1.15.5
- @gradio/checkbox@0.4.25
- @gradio/file@0.12.23

## 0.5.33

### Dependency updates

- @gradio/upload@0.16.9
- @gradio/client@1.15.4
- @gradio/file@0.12.22

## 0.5.32

### Dependency updates

- @gradio/statustracker@0.10.13
- @gradio/atoms@0.16.2
- @gradio/client@1.15.3
- @gradio/upload@0.16.8
- @gradio/checkbox@0.4.24
- @gradio/file@0.12.21

## 0.5.31

### Dependency updates

- @gradio/statustracker@0.10.12
- @gradio/checkbox@0.4.23

## 0.5.31

### Dependency updates

- @gradio/upload@0.16.7
- @gradio/checkbox@0.4.23
- @gradio/client@1.15.2
- @gradio/file@0.12.20

## 0.5.30

### Dependency updates

- @gradio/statustracker@0.10.12
- @gradio/file@0.12.19

## 0.5.30

### Dependency updates

- @gradio/statustracker@0.10.12
- @gradio/client@1.15.1
- @gradio/upload@0.16.6
- @gradio/checkbox@0.4.22
- @gradio/file@0.12.19

## 0.5.29

### Dependency updates

- @gradio/statustracker@0.10.11
- @gradio/atoms@0.16.1
- @gradio/client@1.15.0
- @gradio/upload@0.16.5
- @gradio/file@0.12.18
- @gradio/checkbox@0.4.21

## 0.5.28

### Dependency updates

- @gradio/upload@0.16.4
- @gradio/file@0.12.17

## 0.5.27

### Dependency updates

- @gradio/statustracker@0.10.10
- @gradio/upload@0.16.3
- @gradio/atoms@0.16.0
- @gradio/checkbox@0.4.20
- @gradio/file@0.12.16

## 0.5.26

### Dependency updates

- @gradio/statustracker@0.10.9
- @gradio/atoms@0.15.2
- @gradio/client@1.14.2
- @gradio/utils@0.10.2
- @gradio/upload@0.16.2
- @gradio/file@0.12.15
- @gradio/checkbox@0.4.19

## 0.5.25

### Dependency updates

- @gradio/upload@0.16.1
- @gradio/atoms@0.15.1
- @gradio/statustracker@0.10.8
- @gradio/icons@0.12.0
- @gradio/file@0.12.14
- @gradio/checkbox@0.4.18

## 0.5.24

### Dependency updates

- @gradio/statustracker@0.10.7
- @gradio/atoms@0.15.0
- @gradio/icons@0.11.0
- @gradio/upload@0.16.0
- @gradio/checkbox@0.4.17
- @gradio/file@0.12.13

## 0.5.23

### Dependency updates

- @gradio/client@1.14.1
- @gradio/upload@0.15.7
- @gradio/file@0.12.12

## 0.5.22

### Dependency updates

- @gradio/atoms@0.14.1
- @gradio/statustracker@0.10.6
- @gradio/client@1.14.0
- @gradio/upload@0.15.6
- @gradio/file@0.12.11
- @gradio/checkbox@0.4.16

## 0.5.21

### Dependency updates

- @gradio/upload@0.15.5
- @gradio/statustracker@0.10.5
- @gradio/atoms@0.14.0
- @gradio/checkbox@0.4.15
- @gradio/file@0.12.10

## 0.5.20

### Dependency updates

- @gradio/client@1.13.1
- @gradio/upload@0.15.4
- @gradio/file@0.12.9

## 0.5.19

### Dependency updates

- @gradio/upload@0.15.3
- @gradio/client@1.13.0
- @gradio/file@0.12.8

## 0.5.18

### Dependency updates

- @gradio/upload@0.15.2
- @gradio/statustracker@0.10.4
- @gradio/atoms@0.13.3
- @gradio/checkbox@0.4.14
- @gradio/file@0.12.7

## 0.5.17

### Dependency updates

- @gradio/statustracker@0.10.3
- @gradio/atoms@0.13.2
- @gradio/utils@0.10.1
- @gradio/client@1.12.0
- @gradio/upload@0.15.1
- @gradio/file@0.12.6
- @gradio/checkbox@0.4.13

## 0.5.16

### Dependency updates

- @gradio/client@1.11.0
- @gradio/upload@0.15.0
- @gradio/file@0.12.5

## 0.5.15

### Dependency updates

- @gradio/upload@0.14.8
- @gradio/file@0.12.4

## 0.5.14

### Dependency updates

- @gradio/upload@0.14.7
- @gradio/file@0.12.3

## 0.5.13

### Dependency updates

- @gradio/upload@0.14.6
- @gradio/statustracker@0.10.2
- @gradio/file@0.12.2
- @gradio/checkbox@0.4.12

## 0.5.12

### Dependency updates

- @gradio/atoms@0.13.1
- @gradio/statustracker@0.10.1
- @gradio/client@1.10.0
- @gradio/icons@0.10.0
- @gradio/upload@0.14.5
- @gradio/file@0.12.1
- @gradio/checkbox@0.4.11

## 0.5.11

### Dependency updates

- @gradio/atoms@0.13.0
- @gradio/utils@0.10.0
- @gradio/upload@0.14.4
- @gradio/client@1.9.0
- @gradio/icons@0.9.0
- @gradio/statustracker@0.10.0
- @gradio/file@0.12.0
- @gradio/checkbox@0.4.10

## 0.5.10

### Dependency updates

- @gradio/statustracker@0.9.7
- @gradio/upload@0.14.3
- @gradio/atoms@0.12.0
- @gradio/file@0.11.3
- @gradio/checkbox@0.4.9

## 0.5.9

### Dependency updates

- @gradio/atoms@0.11.2
- @gradio/utils@0.9.0
- @gradio/statustracker@0.9.6
- @gradio/upload@0.14.2
- @gradio/file@0.11.2
- @gradio/checkbox@0.4.8

## 0.5.8

### Dependency updates

- @gradio/atoms@0.11.1
- @gradio/client@1.8.0
- @gradio/utils@0.8.0
- @gradio/upload@0.14.1
- @gradio/statustracker@0.9.5
- @gradio/file@0.11.1
- @gradio/checkbox@0.4.7

## 0.5.7

### Fixes

- [#9835](https://github.com/gradio-app/gradio/pull/9835) [`4d90883`](https://github.com/gradio-app/gradio/commit/4d9088354df528c8edf981f3e756d8927d3e8805) - Allows selection of directories in File Explorer.  Thanks @aliabid94!

### Dependency updates

- @gradio/statustracker@0.9.4
- @gradio/atoms@0.11.0
- @gradio/file@0.11.0
- @gradio/upload@0.14.0
- @gradio/checkbox@0.4.6

## 0.5.6

### Dependency updates

- @gradio/statustracker@0.9.3
- @gradio/atoms@0.10.1
- @gradio/client@1.7.1
- @gradio/upload@0.13.5
- @gradio/checkbox@0.4.5
- @gradio/file@0.10.6

## 0.5.5

### Dependency updates

- @gradio/statustracker@0.9.2
- @gradio/atoms@0.10.0
- @gradio/icons@0.8.1
- @gradio/upload@0.13.4
- @gradio/file@0.10.5
- @gradio/checkbox@0.4.4

## 0.5.4

### Dependency updates

- @gradio/statustracker@0.9.1
- @gradio/upload@0.13.3
- @gradio/atoms@0.9.2
- @gradio/checkbox@0.4.3
- @gradio/file@0.10.4

## 0.5.3

### Dependency updates

- @gradio/atoms@0.9.1
- @gradio/statustracker@0.9.0
- @gradio/client@1.7.0
- @gradio/upload@0.13.2
- @gradio/file@0.10.3
- @gradio/checkbox@0.4.2

## 0.5.2

### Dependency updates

- @gradio/file@0.10.2
- @gradio/upload@0.13.1

## 0.5.1

### Dependency updates

- @gradio/statustracker@0.8.1
- @gradio/checkbox@0.4.1
- @gradio/file@0.10.1

## 0.5.0

### Features

- [#8843](https://github.com/gradio-app/gradio/pull/8843) [`6f95286`](https://github.com/gradio-app/gradio/commit/6f95286337459efbccb95c9cfac63355669df9ee) - Standardize `height` across components and add `max_height` and `min_height` parameters where appropriate

### Dependencies

- @gradio/atoms@0.9.0
- @gradio/checkbox@0.4.0
- @gradio/client@1.6.0
- @gradio/file@0.10.0
- @gradio/icons@0.8.0
- @gradio/statustracker@0.8.0
- @gradio/upload@0.13.0
- @gradio/utils@0.7.0

## 0.5.0-beta.7

### Dependency updates

- @gradio/upload@0.13.0-beta.7
- @gradio/statustracker@0.8.0-beta.5
- @gradio/icons@0.8.0-beta.4
- @gradio/atoms@0.9.0-beta.5
- @gradio/checkbox@0.4.0-beta.5
- @gradio/file@0.10.0-beta.7

## 0.5.0-beta.6

### Dependency updates

- @gradio/statustracker@0.8.0-beta.4
- @gradio/atoms@0.9.0-beta.4
- @gradio/client@1.6.0-beta.4
- @gradio/upload@0.13.0-beta.6
- @gradio/checkbox@0.4.0-beta.4
- @gradio/file@0.10.0-beta.6

## 0.5.0-beta.5

### Dependency updates

- @gradio/upload@0.13.0-beta.5
- @gradio/statustracker@0.8.0-beta.3
- @gradio/icons@0.8.0-beta.3
- @gradio/atoms@0.9.0-beta.3
- @gradio/file@0.10.0-beta.5
- @gradio/checkbox@0.4.0-beta.3

## 0.5.0-beta.4

### Dependency updates

- @gradio/statustracker@0.8.0-beta.2
- @gradio/upload@0.13.0-beta.4
- @gradio/checkbox@0.4.0-beta.2
- @gradio/file@0.10.0-beta.4

## 0.5.0-beta.3

### Dependency updates

- @gradio/upload@0.13.0-beta.3
- @gradio/client@1.6.0-beta.3
- @gradio/file@0.10.0-beta.3

## 0.5.0-beta.2

### Features

- [#9313](https://github.com/gradio-app/gradio/pull/9313) [`1fef9d9`](https://github.com/gradio-app/gradio/commit/1fef9d9a26f0ebce4de18c486702661f6539b1c6) - Standardize `height` across components and add `max_height` and `min_height` parameters where appropriate.  Thanks @abidlabs!

### Dependency updates

- @gradio/atoms@0.9.0-beta.2
- @gradio/upload@0.13.0-beta.2
- @gradio/client@1.6.0-beta.2
- @gradio/icons@0.8.0-beta.2
- @gradio/statustracker@0.8.0-beta.2
- @gradio/utils@0.7.0-beta.2
- @gradio/file@0.10.0-beta.2
- @gradio/checkbox@0.4.0-beta.2

## 0.4.19-beta.1

### Dependency updates

- @gradio/atoms@0.8.1-beta.1
- @gradio/icons@0.8.0-beta.1
- @gradio/statustracker@0.8.0-beta.1
- @gradio/utils@0.7.0-beta.1
- @gradio/client@1.6.0-beta.1
- @gradio/upload@0.12.4-beta.1
- @gradio/file@0.9.4-beta.1
- @gradio/checkbox@0.4.0-beta.1

## 0.4.19

### Fixes

- [#9163](https://github.com/gradio-app/gradio/pull/9163) [`2b6cbf2`](https://github.com/gradio-app/gradio/commit/2b6cbf25908e42cf027324e54ef2cc0baad11a91) - fix exports and generate types.  Thanks @pngwn!

### Dependency updates

- @gradio/utils@0.6.1
- @gradio/statustracker@0.7.6
- @gradio/atoms@0.8.1
- @gradio/icons@0.7.2
- @gradio/client@1.5.2
- @gradio/upload@0.12.4
- @gradio/file@0.9.4
- @gradio/checkbox@0.3.13

## 0.4.18

### Features

- [#9118](https://github.com/gradio-app/gradio/pull/9118) [`e1c404d`](https://github.com/gradio-app/gradio/commit/e1c404da1143fb52b659d03e028bdba1badf443d) - setup npm-previews of all packages.  Thanks @pngwn!

### Dependency updates

- @gradio/utils@0.6.0
- @gradio/upload@0.12.3
- @gradio/atoms@0.8.0
- @gradio/client@1.5.1
- @gradio/statustracker@0.7.5
- @gradio/icons@0.7.1
- @gradio/checkbox@0.3.12
- @gradio/file@0.9.3

## 0.4.17

### Dependency updates

- @gradio/atoms@0.7.9
- @gradio/statustracker@0.7.4
- @gradio/client@1.5.0
- @gradio/icons@0.7.0
- @gradio/upload@0.12.2
- @gradio/file@0.9.2
- @gradio/checkbox@0.3.11

## 0.4.16

### Dependency updates

- @gradio/atoms@0.7.8
- @gradio/icons@0.6.1
- @gradio/utils@0.5.2
- @gradio/statustracker@0.7.3
- @gradio/upload@0.12.1
- @gradio/file@0.9.1
- @gradio/checkbox@0.3.10

## 0.4.15

### Dependency updates

- @gradio/client@1.4.0
- @gradio/statustracker@0.7.2
- @gradio/file@0.9.0
- @gradio/upload@0.12.0
- @gradio/atoms@0.7.7
- @gradio/checkbox@0.3.9

## 0.4.14

### Dependency updates

- @gradio/atoms@0.7.6
- @gradio/utils@0.5.1
- @gradio/statustracker@0.7.1
- @gradio/client@1.3.0
- @gradio/upload@0.11.5
- @gradio/icons@0.6.0
- @gradio/file@0.8.5
- @gradio/checkbox@0.3.8

## 0.4.13

### Dependency updates

- @gradio/upload@0.11.4
- @gradio/client@1.2.1
- @gradio/file@0.8.4

## 0.4.12

### Dependency updates

- @gradio/atoms@0.7.5
- @gradio/utils@0.5.0
- @gradio/icons@0.5.0
- @gradio/client@1.2.0
- @gradio/statustracker@0.7.0
- @gradio/checkbox@0.3.7
- @gradio/file@0.8.3
- @gradio/upload@0.11.3

## 0.4.11

### Dependency updates

- @gradio/client@1.1.1
- @gradio/upload@0.11.2
- @gradio/file@0.8.2

## 0.4.10

### Dependency updates

- @gradio/upload@0.11.1
- @gradio/client@1.1.0
- @gradio/file@0.8.1

## 0.4.9

### Dependency updates

- @gradio/statustracker@0.6.0
- @gradio/client@1.0.0
- @gradio/file@0.8.0
- @gradio/upload@0.11.0
- @gradio/checkbox@0.3.6

## 0.4.8

### Dependency updates

- @gradio/upload@0.10.7
- @gradio/client@0.20.1
- @gradio/file@0.7.7

## 0.4.7

### Dependency updates

- @gradio/client@0.20.0
- @gradio/statustracker@0.6.0
- @gradio/file@0.7.6
- @gradio/upload@0.10.6
- @gradio/checkbox@0.3.6

## 0.4.6

### Dependency updates

- @gradio/utils@0.4.2
- @gradio/atoms@0.7.4
- @gradio/statustracker@0.5.5
- @gradio/upload@0.10.5
- @gradio/client@0.19.4
- @gradio/file@0.7.5
- @gradio/checkbox@0.3.5

## 0.4.5

### Dependency updates

- @gradio/client@0.19.3
- @gradio/statustracker@0.5.4
- @gradio/file@0.7.4
- @gradio/upload@0.10.4
- @gradio/checkbox@0.3.4

## 0.4.4

### Dependency updates

- @gradio/upload@0.10.3
- @gradio/client@0.19.2
- @gradio/file@0.7.3

## 0.4.3

### Dependency updates

- @gradio/statustracker@0.5.3
- @gradio/client@0.19.1
- @gradio/checkbox@0.3.3
- @gradio/file@0.7.2
- @gradio/upload@0.10.2

## 0.4.2

### Dependency updates

- @gradio/atoms@0.7.3
- @gradio/statustracker@0.5.2
- @gradio/client@0.19.0
- @gradio/icons@0.4.1
- @gradio/upload@0.10.1
- @gradio/file@0.7.1
- @gradio/checkbox@0.3.2

## 0.4.1

### Dependency updates

- @gradio/atoms@0.7.2
- @gradio/client@0.18.0
- @gradio/upload@0.10.0
- @gradio/utils@0.4.1
- @gradio/statustracker@0.5.1
- @gradio/file@0.7.0
- @gradio/checkbox@0.3.1

## 0.4.0

### Highlights

#### Setting File Upload Limits ([#7909](https://github.com/gradio-app/gradio/pull/7909) [`2afca65`](https://github.com/gradio-app/gradio/commit/2afca6541912b37dc84f447c7ad4af21607d7c72))

We have added a `max_file_size` size parameter to `launch()` that limits to size of files uploaded to the server. This limit applies to each individual file. This parameter can be specified as a string or an integer (corresponding to the size in bytes).

The following code snippet sets a max file size of 5 megabytes.

```python
import gradio as gr

demo = gr.Interface(lambda x: x, "image", "image")

demo.launch(max_file_size="5mb")
# or
demo.launch(max_file_size=5 * gr.FileSize.MB)
```

![max_file_size_upload](https://github.com/gradio-app/gradio/assets/41651716/7547330c-a082-4901-a291-3f150a197e45)


#### Error states can now be cleared

When a component encounters an error, the error state shown in the UI can now be cleared by clicking on the `x` icon in the top right of the component. This applies to all types of errors, whether it's raised in the UI or the server.

![error_modal_calculator](https://github.com/gradio-app/gradio/assets/41651716/16cb071c-accd-45a6-9c18-0dea27d4bd98)

 Thanks @freddyaboulton!

### Fixes

- [#8066](https://github.com/gradio-app/gradio/pull/8066) [`624f9b9`](https://github.com/gradio-app/gradio/commit/624f9b9477f74a581a6c14119234f9efdfcda398) - make gradio dev tools a local dependency rather than bundling.  Thanks @pngwn!

### Dependency updates

- @gradio/atoms@0.7.1
- @gradio/client@0.17.0
- @gradio/checkbox@0.3.0
- @gradio/file@0.6.0
- @gradio/statustracker@0.5.0
- @gradio/upload@0.9.0
- @gradio/utils@0.4.0

## 0.3.32

### Dependency updates

- @gradio/utils@0.3.2
- @gradio/statustracker@0.4.12
- @gradio/client@0.16.0
- @gradio/upload@0.8.5
- @gradio/atoms@0.7.0
- @gradio/icons@0.4.0
- @gradio/file@0.5.12
- @gradio/checkbox@0.2.15

## 0.3.31

### Dependency updates

- @gradio/utils@0.3.1
- @gradio/atoms@0.6.2
- @gradio/statustracker@0.4.11
- @gradio/upload@0.8.4
- @gradio/client@0.15.1
- @gradio/file@0.5.11
- @gradio/checkbox@0.2.14

## 0.3.30

### Dependency updates

- @gradio/upload@0.8.3
- @gradio/client@0.15.0
- @gradio/file@0.5.10

## 0.3.29

### Dependency updates

- @gradio/atoms@0.6.1
- @gradio/statustracker@0.4.10
- @gradio/icons@0.3.4
- @gradio/upload@0.8.2
- @gradio/file@0.5.9
- @gradio/checkbox@0.2.13

## 0.3.28

### Dependency updates

- @gradio/upload@0.8.1
- @gradio/statustracker@0.4.9
- @gradio/atoms@0.6.0
- @gradio/file@0.5.8
- @gradio/checkbox@0.2.12

## 0.3.27

### Dependency updates

- @gradio/client@0.14.0
- @gradio/upload@0.8.0
- @gradio/file@0.5.7

## 0.3.26

### Dependency updates

- @gradio/upload@0.7.7
- @gradio/client@0.13.0
- @gradio/file@0.5.6

## 0.3.25

### Patch Changes

- Updated dependencies [[`8181695`](https://github.com/gradio-app/gradio/commit/8181695e70187e8bc2bf7518697098c8d1b9843d)]:
  - @gradio/upload@0.7.6
  - @gradio/file@0.5.5

## 0.3.24

### Patch Changes

- Updated dependencies [[`26356a6`](https://github.com/gradio-app/gradio/commit/26356a623c4196f48ca236d973a597831743cdb8), [`eda33b3`](https://github.com/gradio-app/gradio/commit/eda33b3763897a542acf298e523fa493dc655aee), [`4b0d589`](https://github.com/gradio-app/gradio/commit/4b0d58933057432758a54169a360eb352903d6b4)]:
  - @gradio/file@0.5.4
  - @gradio/upload@0.7.5
  - @gradio/client@0.12.2

## 0.3.23

### Patch Changes

- Updated dependencies [[`98a2719`](https://github.com/gradio-app/gradio/commit/98a2719bfb9c64338caf9009891b6c6b0b33ea89), [`9c36572`](https://github.com/gradio-app/gradio/commit/9c36572e32aeec6e6352a861dfea6ee0f9a15e79)]:
  - @gradio/statustracker@0.4.8
  - @gradio/file@0.5.3
  - @gradio/checkbox@0.2.11

## 0.3.22

### Fixes

- [#7441](https://github.com/gradio-app/gradio/pull/7441) [`f52cab6`](https://github.com/gradio-app/gradio/commit/f52cab634b94638d7f4625d40bf3d9afbe68040b) - Dispatch change event for file explorer. Thanks [@aliabid94](https://github.com/aliabid94)!

## 0.3.21

### Fixes

- [#7337](https://github.com/gradio-app/gradio/pull/7337) [`65437ce`](https://github.com/gradio-app/gradio/commit/65437ce832f806da316aa074539b6263e1d8b7ac) - Improve File Explorer performance. Thanks [@aliabid94](https://github.com/aliabid94)!

## 0.3.20

### Patch Changes

- Updated dependencies [[`f35f615`](https://github.com/gradio-app/gradio/commit/f35f615e33a5dd90bfeb106b6f5dca689849fcef), [`49d9c48`](https://github.com/gradio-app/gradio/commit/49d9c48537aa706bf72628e3640389470138bdc6)]:
  - @gradio/file@0.5.0
  - @gradio/client@0.12.0
  - @gradio/upload@0.7.2

## 0.3.19

### Fixes

- [#7192](https://github.com/gradio-app/gradio/pull/7192) [`8dd6f4b`](https://github.com/gradio-app/gradio/commit/8dd6f4bc1901792f05cd59e86df7b1dbab692739) - Handle the case where examples is `null` for all components. Thanks [@abidlabs](https://github.com/abidlabs)!

## 0.3.18

### Patch Changes

- Updated dependencies [[`5727b92`](https://github.com/gradio-app/gradio/commit/5727b92abc8a00a675bfc0a921b38de771af947b), [`bc2cdc1`](https://github.com/gradio-app/gradio/commit/bc2cdc1df95b38025486cf76df4a494b66d98585), [`c60ad4d`](https://github.com/gradio-app/gradio/commit/c60ad4d34ab5b56a89bf6796822977e51e7a4a32)]:
  - @gradio/utils@0.2.1
  - @gradio/upload@0.7.0
  - @gradio/atoms@0.5.0
  - @gradio/checkbox@0.2.7
  - @gradio/file@0.4.8
  - @gradio/statustracker@0.4.4

## 0.3.17

### Patch Changes

- Updated dependencies [[`3c3cf86`](https://github.com/gradio-app/gradio/commit/3c3cf8618a8cad1ef66a7f96664923d2c9f5e0e2), [`523b6bc`](https://github.com/gradio-app/gradio/commit/523b6bc534e221b028a3ea3f274c7466fe242d5a), [`3f139c7`](https://github.com/gradio-app/gradio/commit/3f139c7c995f749562bb007d2a567bb167669de9)]:
  - @gradio/client@0.10.1
  - @gradio/file@0.4.7
  - @gradio/upload@0.6.1

## 0.3.16

### Patch Changes

- Updated dependencies [[`793bf8f`](https://github.com/gradio-app/gradio/commit/793bf8f7b1943f265c5d016c1a0c682ee549232a), [`5d00dd3`](https://github.com/gradio-app/gradio/commit/5d00dd37ca14bbfef2ceac550b29dbe05ba8cab0)]:
  - @gradio/upload@0.6.0
  - @gradio/file@0.4.6

## 0.3.15

### Features

- [#6931](https://github.com/gradio-app/gradio/pull/6931) [`6c863af`](https://github.com/gradio-app/gradio/commit/6c863af92fa9ceb5c638857eb22cc5ddb718d549) - Fix functional tests. Thanks [@aliabid94](https://github.com/aliabid94)!

## 0.3.14

### Patch Changes

- Updated dependencies [[`d406855`](https://github.com/gradio-app/gradio/commit/d4068557953746662235d595ec435c42ceb24414)]:
  - @gradio/client@0.9.4
  - @gradio/file@0.4.4
  - @gradio/upload@0.5.7

## 0.3.13

### Patch Changes

- Updated dependencies [[`828fb9e`](https://github.com/gradio-app/gradio/commit/828fb9e6ce15b6ea08318675a2361117596a1b5d), [`73268ee`](https://github.com/gradio-app/gradio/commit/73268ee2e39f23ebdd1e927cb49b8d79c4b9a144)]:
  - @gradio/client@0.9.3
  - @gradio/statustracker@0.4.3
  - @gradio/atoms@0.4.1
  - @gradio/upload@0.5.6
  - @gradio/file@0.4.3
  - @gradio/checkbox@0.2.6

## 0.3.12

### Patch Changes

- Updated dependencies [[`245d58e`](https://github.com/gradio-app/gradio/commit/245d58eff788e8d44a59d37a2d9b26d0f08a62b4)]:
  - @gradio/client@0.9.2
  - @gradio/file@0.4.2
  - @gradio/upload@0.5.5

## 0.3.11

### Patch Changes

- Updated dependencies [[`5d51fbc`](https://github.com/gradio-app/gradio/commit/5d51fbce7826da840a2fd4940feb5d9ad6f1bc5a), [`34f9431`](https://github.com/gradio-app/gradio/commit/34f943101bf7dd6b8a8974a6131c1ed7c4a0dac0)]:
  - @gradio/upload@0.5.4
  - @gradio/client@0.9.1
  - @gradio/file@0.4.1

## 0.3.10

### Fixes

- [#6689](https://github.com/gradio-app/gradio/pull/6689) [`c9673ca`](https://github.com/gradio-app/gradio/commit/c9673cacd6470296ee01d7717e2080986e750572) - Fix directory-only glob for FileExplorer. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!
- [#6691](https://github.com/gradio-app/gradio/pull/6691) [`128ab5d`](https://github.com/gradio-app/gradio/commit/128ab5d65b51390e706a515a1708fe6c88659209) - Ensure checked files persist after FileExplorer rerenders. Thanks [@hannahblair](https://github.com/hannahblair)!

## 0.3.9

### Fixes

- [#6550](https://github.com/gradio-app/gradio/pull/6550) [`3156598`](https://github.com/gradio-app/gradio/commit/315659817e5e67a04a1375d35ea6fa58d20622d2) - Make FileExplorer work on python 3.8 and 3.9. Also make it update on changes to root, glob, or glob_dir. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

## 0.3.8

### Patch Changes

- Updated dependencies [[`71f1a1f99`](https://github.com/gradio-app/gradio/commit/71f1a1f9931489d465c2c1302a5c8d768a3cd23a), [`f94db6b73`](https://github.com/gradio-app/gradio/commit/f94db6b7319be902428887867500311a6a32a165)]:
  - @gradio/client@0.8.2
  - @gradio/file@0.3.0
  - @gradio/upload@0.5.1

## 0.3.7

### Patch Changes

- Updated dependencies [[`9caddc17b`](https://github.com/gradio-app/gradio/commit/9caddc17b1dea8da1af8ba724c6a5eab04ce0ed8)]:
  - @gradio/atoms@0.3.0
  - @gradio/icons@0.3.0
  - @gradio/statustracker@0.4.0
  - @gradio/upload@0.5.0
  - @gradio/checkbox@0.2.3
  - @gradio/file@0.2.7

## 0.3.6

### Patch Changes

- Updated dependencies [[`2f805a7dd`](https://github.com/gradio-app/gradio/commit/2f805a7dd3d2b64b098f659dadd5d01258290521), [`f816136a0`](https://github.com/gradio-app/gradio/commit/f816136a039fa6011be9c4fb14f573e4050a681a)]:
  - @gradio/upload@0.4.2
  - @gradio/atoms@0.2.2
  - @gradio/icons@0.2.1
  - @gradio/file@0.2.6
  - @gradio/checkbox@0.2.2
  - @gradio/statustracker@0.3.2

## 0.3.5

### Patch Changes

- Updated dependencies [[`324867f63`](https://github.com/gradio-app/gradio/commit/324867f63c920113d89a565892aa596cf8b1e486)]:
  - @gradio/client@0.8.1
  - @gradio/file@0.2.5
  - @gradio/upload@0.4.1

## 0.3.4

### Patch Changes

- Updated dependencies [[`854b482f5`](https://github.com/gradio-app/gradio/commit/854b482f598e0dc47673846631643c079576da9c), [`f1409f95e`](https://github.com/gradio-app/gradio/commit/f1409f95ed39c5565bed6a601e41f94e30196a57)]:
  - @gradio/upload@0.4.0
  - @gradio/client@0.8.0
  - @gradio/file@0.2.4

## 0.3.3

### Patch Changes

- Updated dependencies [[`bca6c2c80`](https://github.com/gradio-app/gradio/commit/bca6c2c80f7e5062427019de45c282238388af95), [`3cdeabc68`](https://github.com/gradio-app/gradio/commit/3cdeabc6843000310e1a9e1d17190ecbf3bbc780), [`fad92c29d`](https://github.com/gradio-app/gradio/commit/fad92c29dc1f5cd84341aae417c495b33e01245f)]:
  - @gradio/client@0.7.2
  - @gradio/atoms@0.2.1
  - @gradio/upload@0.3.3
  - @gradio/file@0.2.3
  - @gradio/checkbox@0.2.1
  - @gradio/statustracker@0.3.1

## 0.3.2

### Fixes

- [#5876](https://github.com/gradio-app/gradio/pull/5876) [`d7a1a6559`](https://github.com/gradio-app/gradio/commit/d7a1a6559005e6a1e0be03a3bd5212d1bc60d1ee) - Fix file overflow and add keyboard navigation to `FileExplorer`. Thanks [@hannahblair](https://github.com/hannahblair)!

## 0.3.1

### Patch Changes

- Updated dependencies [[`2ba14b284`](https://github.com/gradio-app/gradio/commit/2ba14b284f908aa13859f4337167a157075a68eb)]:
  - @gradio/client@0.7.1
  - @gradio/file@0.2.1
  - @gradio/upload@0.3.1

## 0.3.0

### Features

- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - fix circular dependency with client + upload. Thanks [@pngwn](https://github.com/pngwn)!

## 0.3.0-beta.2

### Features

- [#6143](https://github.com/gradio-app/gradio/pull/6143) [`e4f7b4b40`](https://github.com/gradio-app/gradio/commit/e4f7b4b409323b01aa01b39e15ce6139e29aa073) - fix circular dependency with client + upload. Thanks [@pngwn](https://github.com/pngwn)!
- [#6149](https://github.com/gradio-app/gradio/pull/6149) [`90318b1dd`](https://github.com/gradio-app/gradio/commit/90318b1dd118ae08a695a50e7c556226234ab6dc) - swap `mode` on the frontned to `interactive` to match the backend. Thanks [@pngwn](https://github.com/pngwn)!

## 0.3.0-beta.1

### Features

- [#6016](https://github.com/gradio-app/gradio/pull/6016) [`83e947676`](https://github.com/gradio-app/gradio/commit/83e947676d327ca2ab6ae2a2d710c78961c771a0) - Format js in v4 branch. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

## 0.3.0-beta.0

### Features

- [#5960](https://github.com/gradio-app/gradio/pull/5960) [`319c30f3f`](https://github.com/gradio-app/gradio/commit/319c30f3fccf23bfe1da6c9b132a6a99d59652f7) - rererefactor frontend files. Thanks [@pngwn](https://github.com/pngwn)!

## 0.2.2

### Patch Changes

- Updated dependencies [[`4e62b8493`](https://github.com/gradio-app/gradio/commit/4e62b8493dfce50bafafe49f1a5deb929d822103), [`e70805d54`](https://github.com/gradio-app/gradio/commit/e70805d54cc792452545f5d8eccc1aa0212a4695)]:
  - @gradio/client@0.5.2
  - @gradio/atoms@0.2.0
  - @gradio/file@0.2.2
  - @gradio/checkbox@0.2.3
  - @gradio/statustracker@0.2.3
  - @gradio/upload@0.3.3

## 0.2.1

### Patch Changes

- Updated dependencies [[`796145e2c`](https://github.com/gradio-app/gradio/commit/796145e2c48c4087bec17f8ec0be4ceee47170cb)]:
  - @gradio/client@0.5.1
  - @gradio/file@0.2.1

## 0.2.0

### Highlights

#### new `FileExplorer` component ([#5672](https://github.com/gradio-app/gradio/pull/5672) [`e4a307ed6`](https://github.com/gradio-app/gradio/commit/e4a307ed6cde3bbdf4ff2f17655739addeec941e))

Thanks to a new capability that allows components to communicate directly with the server _without_ passing data via the value, we have created a new `FileExplorer` component.

This component allows you to populate the explorer by passing a glob, but only provides the selected file(s) in your prediction function.

Users can then navigate the virtual filesystem and select files which will be accessible in your predict function. This component will allow developers to build more complex spaces, with more flexible input options.

![output](https://github.com/pngwn/MDsveX/assets/12937446/ef108f0b-0e84-4292-9984-9dc66b3e144d)

For more information check the [`FileExplorer` documentation](https://gradio.app/docs/fileexplorer).

Thanks [@aliabid94](https://github.com/aliabid94)!