# @gradio/upload

## 0.17.3

### Dependency updates

- @gradio/utils@0.11.1
- @gradio/client@2.0.2

## 0.17.3

### Dependency updates

- @gradio/atoms@0.20.0
- @gradio/utils@0.11.0
- @gradio/client@2.0.1

## 0.17.2

### Dependency updates

- @gradio/utils@0.10.4

## 0.17.2

### Features

- [#12438](https://github.com/gradio-app/gradio/pull/12438) [`25ffc03`](https://github.com/gradio-app/gradio/commit/25ffc0398f8feb43d817c02b2ab970c16de6d797) - Svelte5 migration and bugfix

### Dependencies

- @gradio/atoms@0.19.0
- @gradio/icons@0.15.0
- @gradio/client@2.0.0
- @gradio/utils@0.10.3

## 0.17.2-dev.2

### Dependency updates

- @gradio/atoms@0.19.0-dev.1
- @gradio/client@2.0.0-dev.2

## 0.17.2-dev.1

### Dependency updates

- @gradio/atoms@0.18.2-dev.0
- @gradio/utils@0.10.3-dev.0
- @gradio/icons@0.15.0-dev.0

## 0.17.2-dev.0

### Dependency updates

- @gradio/client@2.0.0-dev.1

## 0.17.2-dev.0

### Dependency updates

- @gradio/client@2.0.0-dev.0

## 0.17.1

### Dependency updates

- @gradio/client@1.19.1

## 0.17.1

### Fixes

- [#11969](https://github.com/gradio-app/gradio/pull/11969) [`c8f7909`](https://github.com/gradio-app/gradio/commit/c8f79090ede3b071a8d9620a885350b6ee5a8926) - Show UploadProgress for Webcam Uploads.  Thanks @freddyaboulton!

### Dependency updates

- @gradio/atoms@0.18.1

## 0.17.0

### Features

- [#11858](https://github.com/gradio-app/gradio/pull/11858) [`3f8ea13`](https://github.com/gradio-app/gradio/commit/3f8ea13a8ca92abf0ad34392e403a449fda3c6c2) - remove lite.  Thanks @pngwn!

### Dependency updates

- @gradio/atoms@0.18.0
- @gradio/client@1.19.0

## 0.16.17

### Dependency updates

- @gradio/client@1.18.0
- @gradio/icons@0.14.0
- @gradio/atoms@0.17.0

## 0.16.16

### Fixes

- [#11771](https://github.com/gradio-app/gradio/pull/11771) [`f53b24b`](https://github.com/gradio-app/gradio/commit/f53b24b010a98d9028d8bade39db9c4dd37782d1) - Fix file upload error due to file extension case differences.  Thanks @rca-umb!

### Dependency updates

- @gradio/icons@0.13.1

## 0.16.15

### Dependency updates

- @gradio/atoms@0.16.5
- @gradio/client@1.17.1
- @gradio/icons@0.13.0

## 0.16.14

### Dependency updates

- @gradio/atoms@0.16.4
- @gradio/client@1.17.0

## 0.16.13

### Dependency updates

- @gradio/client@1.16.0

## 0.16.12

### Dependency updates

- @gradio/client@1.15.7

## 0.16.11

### Dependency updates

- @gradio/client@1.15.6

## 0.16.10

### Dependency updates

- @gradio/atoms@0.16.3
- @gradio/client@1.15.5

## 0.16.9

### Dependency updates

- @gradio/client@1.15.4

## 0.16.8

### Dependency updates

- @gradio/atoms@0.16.2
- @gradio/client@1.15.3

## 0.16.7

### Dependency updates

- @gradio/client@1.15.2

## 0.16.6

### Dependency updates

- @gradio/client@1.15.1

## 0.16.5

### Dependency updates

- @gradio/atoms@0.16.1
- @gradio/client@1.15.0

## 0.16.4

### Fixes

- [#11098](https://github.com/gradio-app/gradio/pull/11098) [`49ad594`](https://github.com/gradio-app/gradio/commit/49ad5943eeab96b153f0b56fe8d42d755fe1e0f8) - Fix #10281: Dragging image replaces existing instead of opening new tab.  Thanks @Martim-Rito!

## 0.16.3

### Dependency updates

- @gradio/atoms@0.16.0

## 0.16.2

### Dependency updates

- @gradio/atoms@0.15.2
- @gradio/client@1.14.2
- @gradio/utils@0.10.2

## 0.16.1

### Dependency updates

- @gradio/atoms@0.15.1
- @gradio/icons@0.12.0

## 0.16.0

### Features

- [#10635](https://github.com/gradio-app/gradio/pull/10635) [`2f68c9d`](https://github.com/gradio-app/gradio/commit/2f68c9d988dcbc53a0b8e53bdb1de49c9c8c65d8) - Refactor and redesign `ImageEditor` component.  Thanks @pngwn!

### Dependency updates

- @gradio/atoms@0.15.0
- @gradio/icons@0.11.0

## 0.15.7

### Dependency updates

- @gradio/wasm@0.18.1
- @gradio/client@1.14.1

## 0.15.6

### Dependency updates

- @gradio/atoms@0.14.1
- @gradio/client@1.14.0
- @gradio/wasm@0.18.0

## 0.15.5

### Dependency updates

- @gradio/atoms@0.14.0

## 0.15.4

### Dependency updates

- @gradio/client@1.13.1
- @gradio/wasm@0.17.4

## 0.15.3

### Dependency updates

- @gradio/client@1.13.0

## 0.15.2

### Dependency updates

- @gradio/atoms@0.13.3

## 0.15.1

### Dependency updates

- @gradio/atoms@0.13.2
- @gradio/utils@0.10.1
- @gradio/client@1.12.0
- @gradio/wasm@0.17.3

## 0.15.0

### Features

- [#10478](https://github.com/gradio-app/gradio/pull/10478) [`afb96c6`](https://github.com/gradio-app/gradio/commit/afb96c64451e5a282bfee89445d831d1c87f9746) - Improve dataframe's upload accessibility.  Thanks @hannahblair!

### Dependency updates

- @gradio/client@1.11.0

## 0.14.8

### Dependency updates

- @gradio/wasm@0.17.2

## 0.14.7

### Dependency updates

- @gradio/wasm@0.17.1

## 0.14.6

### Dependency updates

- @gradio/wasm@0.17.0

## 0.14.5

### Dependency updates

- @gradio/atoms@0.13.1
- @gradio/client@1.10.0
- @gradio/icons@0.10.0

## 0.14.4

### Fixes

- [#10209](https://github.com/gradio-app/gradio/pull/10209) [`2700d18`](https://github.com/gradio-app/gradio/commit/2700d1898bc8eeb3fd9f65ce77be17c2614a388f) - Ensure the `height` param in `gr.File` works as expected.  Thanks @hannahblair!

### Dependency updates

- @gradio/atoms@0.13.0
- @gradio/utils@0.10.0
- @gradio/client@1.9.0
- @gradio/icons@0.9.0
- @gradio/wasm@0.16.0

## 0.14.3

### Dependency updates

- @gradio/atoms@0.12.0

## 0.14.2

### Dependency updates

- @gradio/atoms@0.11.2
- @gradio/utils@0.9.0

## 0.14.1

### Dependency updates

- @gradio/atoms@0.11.1
- @gradio/client@1.8.0
- @gradio/utils@0.8.0

## 0.14.0

### Features

- [#9891](https://github.com/gradio-app/gradio/pull/9891) [`fc12496`](https://github.com/gradio-app/gradio/commit/fc124964a1b4922e54a4ca4755f0a536dfae1a21) - Allow uploading more files in gr.File.  Thanks @hannahblair!

### Dependency updates

- @gradio/atoms@0.11.0
- @gradio/wasm@0.15.0

## 0.13.5

### Dependency updates

- @gradio/atoms@0.10.1
- @gradio/client@1.7.1

## 0.13.4

### Fixes

- [#9770](https://github.com/gradio-app/gradio/pull/9770) [`47b5565`](https://github.com/gradio-app/gradio/commit/47b556523db3b63d6a9c2f9f69e8632bfa4ddff6) - Fix broken image select.  Thanks @aliabid94!

### Dependency updates

- @gradio/atoms@0.10.0
- @gradio/icons@0.8.1

## 0.13.3

### Dependency updates

- @gradio/atoms@0.9.2

## 0.13.2

### Dependency updates

- @gradio/atoms@0.9.1
- @gradio/client@1.7.0
- @gradio/wasm@0.14.2

## 0.13.1

### Dependency updates

- @gradio/wasm@0.14.1

## 0.13.0

### Features

- [#8843](https://github.com/gradio-app/gradio/pull/8843) [`6f95286`](https://github.com/gradio-app/gradio/commit/6f95286337459efbccb95c9cfac63355669df9ee) - Improve Icon Button consistency
- [#8843](https://github.com/gradio-app/gradio/pull/8843) [`6f95286`](https://github.com/gradio-app/gradio/commit/6f95286337459efbccb95c9cfac63355669df9ee) - Ssr part 2

### Dependencies

- @gradio/atoms@0.9.0
- @gradio/icons@0.8.0
- @gradio/client@1.6.0
- @gradio/utils@0.7.0
- @gradio/wasm@0.14.0

## 0.13.0-beta.7

### Dependency updates

- @gradio/icons@0.8.0-beta.4
- @gradio/atoms@0.9.0-beta.5

## 0.13.0-beta.6

### Dependency updates

- @gradio/atoms@0.9.0-beta.4
- @gradio/client@1.6.0-beta.4

## 0.13.0-beta.5

### Dependency updates

- @gradio/icons@0.8.0-beta.3
- @gradio/atoms@0.9.0-beta.3

## 0.13.0-beta.4

### Dependency updates

- @gradio/wasm@0.14.0-beta.3

## 0.13.0-beta.3

### Dependency updates

- @gradio/client@1.6.0-beta.3

## 0.13.0-beta.2

### Features

- [#9339](https://github.com/gradio-app/gradio/pull/9339) [`4c8c6f2`](https://github.com/gradio-app/gradio/commit/4c8c6f2fe603081941c5fdc43f48a0632b9f31ad) - Ssr part 2.  Thanks @pngwn!
- [#9250](https://github.com/gradio-app/gradio/pull/9250) [`350b0a5`](https://github.com/gradio-app/gradio/commit/350b0a5cafb9176f914f62e7c90de51d4352cc77) - Improve Icon Button consistency.  Thanks @hannahblair!

### Dependency updates

- @gradio/atoms@0.9.0-beta.2
- @gradio/wasm@0.14.0-beta.2
- @gradio/client@1.6.0-beta.2
- @gradio/icons@0.8.0-beta.2
- @gradio/utils@0.7.0-beta.2

## 0.12.4-beta.1

### Dependency updates

- @gradio/atoms@0.8.1-beta.1
- @gradio/icons@0.8.0-beta.1
- @gradio/utils@0.7.0-beta.1
- @gradio/client@1.6.0-beta.1
- @gradio/wasm@0.13.1-beta.1

## 0.12.4

### Fixes

- [#9163](https://github.com/gradio-app/gradio/pull/9163) [`2b6cbf2`](https://github.com/gradio-app/gradio/commit/2b6cbf25908e42cf027324e54ef2cc0baad11a91) - fix exports and generate types.  Thanks @pngwn!

### Dependency updates

- @gradio/utils@0.6.1
- @gradio/atoms@0.8.1
- @gradio/icons@0.7.2
- @gradio/wasm@0.13.1
- @gradio/client@1.5.2

## 0.12.3

### Features

- [#9031](https://github.com/gradio-app/gradio/pull/9031) [`04b7d32`](https://github.com/gradio-app/gradio/commit/04b7d327ec1227a693fc2dfea51b1e2729851bde) - Allow drag and replace image in `gr.Image` and Multimodal textbox.  Thanks @hannahblair!
- [#9118](https://github.com/gradio-app/gradio/pull/9118) [`e1c404d`](https://github.com/gradio-app/gradio/commit/e1c404da1143fb52b659d03e028bdba1badf443d) - setup npm-previews of all packages.  Thanks @pngwn!

### Dependency updates

- @gradio/utils@0.6.0
- @gradio/atoms@0.8.0
- @gradio/client@1.5.1
- @gradio/wasm@0.13.0
- @gradio/icons@0.7.1

## 0.12.2

### Dependency updates

- @gradio/atoms@0.7.9
- @gradio/client@1.5.0
- @gradio/icons@0.7.0

## 0.12.1

### Fixes

- [#8879](https://github.com/gradio-app/gradio/pull/8879) [`67c08bf`](https://github.com/gradio-app/gradio/commit/67c08bfb9e59d801081591b8a59232c32d4467cf) - Fix file uploading in iOS.  Thanks @hannahblair!
- [#8905](https://github.com/gradio-app/gradio/pull/8905) [`4b14ea8`](https://github.com/gradio-app/gradio/commit/4b14ea860d5055410a3a2257974b61a5c8eaac9d) - Allow use of file extensions in gr.File in iOS.  Thanks @hannahblair!

### Dependency updates

- @gradio/atoms@0.7.8
- @gradio/icons@0.6.1
- @gradio/utils@0.5.2

## 0.12.0

### Features

- [#8803](https://github.com/gradio-app/gradio/pull/8803) [`e1a4040`](https://github.com/gradio-app/gradio/commit/e1a404093cfaf9d8f2a92bc1d28fb6aa254848d1) - Ensure all upload components have consistent upload regions.  Thanks @pngwn!

### Dependency updates

- @gradio/wasm@0.12.0
- @gradio/client@1.4.0
- @gradio/atoms@0.7.7

## 0.11.5

### Fixes

- [#8714](https://github.com/gradio-app/gradio/pull/8714) [`1b5b5b0`](https://github.com/gradio-app/gradio/commit/1b5b5b0b43e69ee84f3baad2aae59ffc9c4d995a) - Bind `fetch` and `stream` in JS client.  Thanks @hannahblair!

### Dependency updates

- @gradio/atoms@0.7.6
- @gradio/utils@0.5.1
- @gradio/client@1.3.0
- @gradio/icons@0.6.0

## 0.11.4

### Fixes

- [#8608](https://github.com/gradio-app/gradio/pull/8608) [`c12f82a`](https://github.com/gradio-app/gradio/commit/c12f82a36dc75ff30918dc2ce5f24e583b676f22) - Bugfix: Add a `file_count` parameter to `gr.MultimodalTextbox`. Multiple files cab be uploaded by setting `file_count="multiple"`. Default is `"single"` to preserve the previous behavior.  Thanks @freddyaboulton!

### Dependency updates

- @gradio/client@1.2.1

## 0.11.3

### Dependency updates

- @gradio/atoms@0.7.5
- @gradio/utils@0.5.0
- @gradio/icons@0.5.0
- @gradio/wasm@0.11.0
- @gradio/client@1.2.0

## 0.11.2

### Features

- [#8491](https://github.com/gradio-app/gradio/pull/8491) [`ffd53fa`](https://github.com/gradio-app/gradio/commit/ffd53fa2dcb13d564fd07aa441d4016df8d2f155) - Remove broken guide redirect.  Thanks @aliabd!

### Dependency updates

- @gradio/client@1.1.1

## 0.11.1

### Dependency updates

- @gradio/upload@0.11.1
- @gradio/client@1.1.0

## 0.11.0

### Features

- [#8417](https://github.com/gradio-app/gradio/pull/8417) [`96d8de2`](https://github.com/gradio-app/gradio/commit/96d8de231270321da5f310768643363276df3204) - add delete event to `File` component.  Thanks @pngwn!

### Dependency updates

- @gradio/client@1.0.0
- @gradio/upload@0.11.0

## 0.10.7

### Dependency updates

- @gradio/upload@0.10.7
- @gradio/client@0.20.1

## 0.10.6

### Dependency updates

- @gradio/client@0.20.0
- @gradio/upload@0.10.6

## 0.10.5

### Dependency updates

- @gradio/utils@0.4.2
- @gradio/atoms@0.7.4
- @gradio/upload@0.10.5
- @gradio/client@0.19.4

## 0.10.4

### Dependency updates

- @gradio/client@0.19.3
- @gradio/upload@0.10.4

## 0.10.3

### Dependency updates

- @gradio/upload@0.10.3
- @gradio/client@0.19.2

## 0.10.2

### Dependency updates

- @gradio/client@0.19.1
- @gradio/upload@0.10.2

## 0.10.1

### Fixes

- [#8252](https://github.com/gradio-app/gradio/pull/8252) [`22df61a`](https://github.com/gradio-app/gradio/commit/22df61a26adf8023f6dd49c051979990e8d3879a) - Client node fix.  Thanks @pngwn!

### Dependency updates

- @gradio/atoms@0.7.3
- @gradio/client@0.19.0
- @gradio/icons@0.4.1
- @gradio/upload@0.10.1

## 0.10.0

### Features

- [#8121](https://github.com/gradio-app/gradio/pull/8121) [`f5b710c`](https://github.com/gradio-app/gradio/commit/f5b710c919b0ce604ea955f0d5f4faa91095ca4a) - chore(deps): update dependency eslint to v9.  Thanks @renovate!
- [#8209](https://github.com/gradio-app/gradio/pull/8209) [`b9afe93`](https://github.com/gradio-app/gradio/commit/b9afe93915401df5bd6737c89395c2477acfa585) - Rename `eventSource_Factory` and `fetch_implementation`.  Thanks @hannahblair!

### Fixes

- [#8179](https://github.com/gradio-app/gradio/pull/8179) [`6a218b4`](https://github.com/gradio-app/gradio/commit/6a218b4148095aaa0c58d8c20973ba01c8764fc2) - rework upload to be a class method + pass client into each component.  Thanks @pngwn!
- [#8118](https://github.com/gradio-app/gradio/pull/8118) [`7aca673`](https://github.com/gradio-app/gradio/commit/7aca673b38a087533524b2fd8dd3a03e0e4bacfe) - Add eventsource polyfill for Node.js and browser environments.  Thanks @hannahblair!

### Dependency updates

- @gradio/atoms@0.7.2
- @gradio/client@0.18.0
- @gradio/upload@0.10.0
- @gradio/utils@0.4.1
- @gradio/wasm@0.10.1

## 0.9.0

### Highlights

#### Setting File Upload Limits ([#7909](https://github.com/gradio-app/gradio/pull/7909) [`2afca65`](https://github.com/gradio-app/gradio/commit/2afca6541912b37dc84f447c7ad4af21607d7c72))

We have added a `max_file_size` size parameter to `launch()` that limits to size of files uploaded to the server. This limit applies to each individual file. This parameter can be specified as a string or an integer (corresponding to the size in bytes).

The following code snippet sets a max file size of 5 megabytes.

```python
import gradio as gr

demo = gr.Interface(lambda x: x, "image", "image")

demo.launch(max_file_size="5mb")
# or
demo.launch(max_file_size=5 * gr.FileSize.MB)
```

![max_file_size_upload](https://github.com/gradio-app/gradio/assets/41651716/7547330c-a082-4901-a291-3f150a197e45)


#### Error states can now be cleared

When a component encounters an error, the error state shown in the UI can now be cleared by clicking on the `x` icon in the top right of the component. This applies to all types of errors, whether it's raised in the UI or the server.

![error_modal_calculator](https://github.com/gradio-app/gradio/assets/41651716/16cb071c-accd-45a6-9c18-0dea27d4bd98)

 Thanks @freddyaboulton!

### Dependency updates

- @gradio/atoms@0.7.1
- @gradio/client@0.17.0
- @gradio/upload@0.9.0
- @gradio/utils@0.4.0

## 0.8.5

### Fixes

- [#8002](https://github.com/gradio-app/gradio/pull/8002) [`8903415`](https://github.com/gradio-app/gradio/commit/8903415e49b1526d31ff454b2235ea238e319c2c) - Add show_progress prop to Upload Component to bring back upload progress animation.  Thanks @freddyaboulton!

### Dependency updates

- @gradio/utils@0.3.2
- @gradio/client@0.16.0
- @gradio/upload@0.8.5
- @gradio/atoms@0.7.0
- @gradio/icons@0.4.0

## 0.8.4

### Dependency updates

- @gradio/utils@0.3.1
- @gradio/atoms@0.6.2
- @gradio/upload@0.8.4
- @gradio/client@0.15.1

## 0.8.3

### Dependency updates

- @gradio/upload@0.8.3
- @gradio/client@0.15.0

## 0.8.2

### Fixes

- [#7848](https://github.com/gradio-app/gradio/pull/7848) [`8d7b3ca`](https://github.com/gradio-app/gradio/commit/8d7b3caebd8f95b1372f8412cadbb5862766c365) - Multimodal Textbox Loading + other fixes.  Thanks @dawoodkhan82!

### Dependency updates

- @gradio/atoms@0.6.1
- @gradio/icons@0.3.4
- @gradio/upload@0.8.2

## 0.8.1

### Dependency updates

- @gradio/upload@0.8.1
- @gradio/wasm@0.10.0
- @gradio/atoms@0.6.0

## 0.8.0

### Features

- [#7420](https://github.com/gradio-app/gradio/pull/7420) [`15da39f`](https://github.com/gradio-app/gradio/commit/15da39fca01d09a30cf47e7e72d7efa5052f61f8) - Multimodal Textbox (Chat Input Component).  Thanks @dawoodkhan82!

### Dependency updates

- @gradio/client@0.14.0
- @gradio/upload@0.8.0
- @gradio/wasm@0.9.0

## 0.7.7

### Dependency updates

- @gradio/upload@0.7.7
- @gradio/client@0.13.0
- @gradio/wasm@0.8.0

## 0.7.6

### Features

- [#7625](https://github.com/gradio-app/gradio/pull/7625) [`8181695`](https://github.com/gradio-app/gradio/commit/8181695e70187e8bc2bf7518697098c8d1b9843d) - image upload fix.  Thanks [@dawoodkhan82](https://github.com/dawoodkhan82)!

## 0.7.5

### Fixes

- [#7559](https://github.com/gradio-app/gradio/pull/7559) [`26356a6`](https://github.com/gradio-app/gradio/commit/26356a623c4196f48ca236d973a597831743cdb8) - Fixes: Invalid file_type breaks drag and drop.  Thanks [@dawoodkhan82](https://github.com/dawoodkhan82)!

## 0.7.4

### Patch Changes

- Updated dependencies [[`f191786`](https://github.com/gradio-app/gradio/commit/f1917867916647d383b8d7ce15e0c17f2abbdec1)]:
  - @gradio/icons@0.3.3
  - @gradio/atoms@0.5.3
  - @gradio/upload@0.7.4

## 0.7.3

### Patch Changes

- Updated dependencies [[`065c5b1`](https://github.com/gradio-app/gradio/commit/065c5b163c4badb9d9cbd06d627fb4ba086003e7), [`32b317f`](https://github.com/gradio-app/gradio/commit/32b317f24e3d43f26684bb9f3964f31efd0ea556)]:
  - @gradio/utils@0.3.0
  - @gradio/client@0.12.1
  - @gradio/atoms@0.5.2
  - @gradio/upload@0.7.3

## 0.7.2

### Patch Changes

- Updated dependencies [[`49d9c48`](https://github.com/gradio-app/gradio/commit/49d9c48537aa706bf72628e3640389470138bdc6)]:
  - @gradio/client@0.12.0
  - @gradio/upload@0.7.2

## 0.7.1

### Features

- [#7206](https://github.com/gradio-app/gradio/pull/7206) [`572e360`](https://github.com/gradio-app/gradio/commit/572e360fff4a03c335b86e1a7517a44cb6af2bcd) - Upload tweak. Thanks [@pngwn](https://github.com/pngwn)!

### Fixes

- [#7141](https://github.com/gradio-app/gradio/pull/7141) [`c3e61e4`](https://github.com/gradio-app/gradio/commit/c3e61e4f70696a71aede67b65d28447eb67daf16) - Few File component drag and drop. Thanks [@dawoodkhan82](https://github.com/dawoodkhan82)!

## 0.7.0

### Features

- [#7104](https://github.com/gradio-app/gradio/pull/7104) [`bc2cdc1`](https://github.com/gradio-app/gradio/commit/bc2cdc1df95b38025486cf76df4a494b66d98585) - Allow download button for interactive Audio and Video components. Thanks [@hannahblair](https://github.com/hannahblair)!

## 0.6.1

### Fixes

- [#6982](https://github.com/gradio-app/gradio/pull/6982) [`3f139c7`](https://github.com/gradio-app/gradio/commit/3f139c7c995f749562bb007d2a567bb167669de9) - Fix File drag and drop for specific file_types. Thanks [@dawoodkhan82](https://github.com/dawoodkhan82)!

## 0.6.0

### Features

- [#6965](https://github.com/gradio-app/gradio/pull/6965) [`5d00dd3`](https://github.com/gradio-app/gradio/commit/5d00dd37ca14bbfef2ceac550b29dbe05ba8cab0) - Make <UploadProgress /> Wasm-compatible. Thanks [@whitphx](https://github.com/whitphx)!

### Fixes

- [#6969](https://github.com/gradio-app/gradio/pull/6969) [`793bf8f`](https://github.com/gradio-app/gradio/commit/793bf8f7b1943f265c5d016c1a0c682ee549232a) - Display pending file in `<Upload />` while waiting for upload request. Thanks [@hannahblair](https://github.com/hannahblair)!

## 0.5.8

### Features

- [#6931](https://github.com/gradio-app/gradio/pull/6931) [`6c863af`](https://github.com/gradio-app/gradio/commit/6c863af92fa9ceb5c638857eb22cc5ddb718d549) - Fix functional tests. Thanks [@aliabid94](https://github.com/aliabid94)!

## 0.5.7

### Patch Changes

- Updated dependencies [[`d406855`](https://github.com/gradio-app/gradio/commit/d4068557953746662235d595ec435c42ceb24414)]:
  - @gradio/client@0.9.4
  - @gradio/upload@0.5.7

## 0.5.6

### Fixes

- [#6766](https://github.com/gradio-app/gradio/pull/6766) [`73268ee`](https://github.com/gradio-app/gradio/commit/73268ee2e39f23ebdd1e927cb49b8d79c4b9a144) - Improve source selection UX. Thanks [@hannahblair](https://github.com/hannahblair)!

## 0.5.5

### Patch Changes

- Updated dependencies [[`245d58e`](https://github.com/gradio-app/gradio/commit/245d58eff788e8d44a59d37a2d9b26d0f08a62b4)]:
  - @gradio/client@0.9.2
  - @gradio/upload@0.5.5

## 0.5.4

### Fixes

- [#6525](https://github.com/gradio-app/gradio/pull/6525) [`5d51fbc`](https://github.com/gradio-app/gradio/commit/5d51fbce7826da840a2fd4940feb5d9ad6f1bc5a) - Fixes Drag and Drop for Upload. Thanks [@dawoodkhan82](https://github.com/dawoodkhan82)!

## 0.5.3

### Fixes

- [#6709](https://github.com/gradio-app/gradio/pull/6709) [`6a9151d`](https://github.com/gradio-app/gradio/commit/6a9151d5c9432c724098da7d88a539aaaf5ffe88) - Remove progress animation on streaming. Thanks [@aliabid94](https://github.com/aliabid94)!

## 0.5.2

### Patch Changes

- Updated dependencies [[`206af31`](https://github.com/gradio-app/gradio/commit/206af31d7c1a31013364a44e9b40cf8df304ba50)]:
  - @gradio/icons@0.3.1
  - @gradio/atoms@0.3.1
  - @gradio/upload@0.5.2

## 0.5.1

### Patch Changes

- Updated dependencies [[`71f1a1f99`](https://github.com/gradio-app/gradio/commit/71f1a1f9931489d465c2c1302a5c8d768a3cd23a)]:
  - @gradio/client@0.8.2
  - @gradio/upload@0.5.1

## 0.5.0

### Highlights

#### New `ImageEditor` component ([#6169](https://github.com/gradio-app/gradio/pull/6169) [`9caddc17b`](https://github.com/gradio-app/gradio/commit/9caddc17b1dea8da1af8ba724c6a5eab04ce0ed8))

A brand new component, completely separate from `Image` that provides simple editing capabilities.

- Set background images from file uploads, webcam, or just paste!
- Crop images with an improved cropping UI. App authors can event set specific crop size, or crop ratios (`1:1`, etc)
- Paint on top of any image (or no image) and erase any mistakes!
- The ImageEditor supports layers, confining draw and erase actions to that layer.
- More flexible access to data. The image component returns a composite image representing the final state of the canvas as well as providing the background and all layers as individual images.
- Fully customisable. All features can be enabled and disabled. Even the brush color swatches can be customised.

<video src="https://user-images.githubusercontent.com/12937446/284027169-31188926-fd16-4a1c-8718-998e7aae4695.mp4" autoplay muted></video>

```py

def fn(im):
    im["composite"] # the full canvas
    im["background"] # the background image
    im["layers"] # a list of individual layers


im = gr.ImageEditor(
    # decide which sources you'd like to accept
    sources=["upload", "webcam", "clipboard"],
    # set a cropsize constraint, can either be a ratio or a concrete [width, height]
    crop_size="1:1",
    # enable crop (or disable it)
    transforms=["crop"],
    # customise the brush
    brush=Brush(
      default_size="25", # or leave it as 'auto'
      color_mode="fixed", # 'fixed' hides the user swatches and colorpicker, 'defaults' shows it
      default_color="hotpink", # html names are supported
      colors=[
        "rgba(0, 150, 150, 1)", # rgb(a)
        "#fff", # hex rgb
        "hsl(360, 120, 120)" # in fact any valid colorstring
      ]
    ),
    brush=Eraser(default_size="25")
)

```

Thanks [@pngwn](https://github.com/pngwn)!

## 0.4.2

### Fixes

- [#6441](https://github.com/gradio-app/gradio/pull/6441) [`2f805a7dd`](https://github.com/gradio-app/gradio/commit/2f805a7dd3d2b64b098f659dadd5d01258290521) - Small but important bugfixes for gr.Image: The upload event was not triggering at all. The paste-from-clipboard was not triggering an upload event. The clear button was not triggering a change event. The change event was triggering infinitely. Uploaded images were not preserving their original names. Uploading a new image should clear out the previous image. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

## 0.4.1

### Patch Changes

- Updated dependencies [[`324867f63`](https://github.com/gradio-app/gradio/commit/324867f63c920113d89a565892aa596cf8b1e486)]:
  - @gradio/client@0.8.1
  - @gradio/upload@0.4.1

## 0.4.0

### Features

- [#6356](https://github.com/gradio-app/gradio/pull/6356) [`854b482f5`](https://github.com/gradio-app/gradio/commit/854b482f598e0dc47673846631643c079576da9c) - Redesign file upload. Thanks [@hannahblair](https://github.com/hannahblair)!
- [#6307](https://github.com/gradio-app/gradio/pull/6307) [`f1409f95e`](https://github.com/gradio-app/gradio/commit/f1409f95ed39c5565bed6a601e41f94e30196a57) - Provide status updates on file uploads. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

## 0.3.3

### Fixes

- [#6279](https://github.com/gradio-app/gradio/pull/6279) [`3cdeabc68`](https://github.com/gradio-app/gradio/commit/3cdeabc6843000310e1a9e1d17190ecbf3bbc780) - Ensure source selection does not get hidden in overflow. Thanks [@hannahblair](https://github.com/hannahblair)!

## 0.3.2

### Fixes

- [#6234](https://github.com/gradio-app/gradio/pull/6234) [`aaa55ce85`](https://github.com/gradio-app/gradio/commit/aaa55ce85e12f95aba9299445e9c5e59824da18e) - Video/Audio fixes. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

## 0.3.1

### Patch Changes

- Updated dependencies [[`2ba14b284`](https://github.com/gradio-app/gradio/commit/2ba14b284f908aa13859f4337167a157075a68eb)]:
  - @gradio/client@0.7.1
  - @gradio/upload@0.3.1

## 0.3.0

### Features

- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - fix circular dependency with client + upload. Thanks [@pngwn](https://github.com/pngwn)!
- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - Image v4. Thanks [@pngwn](https://github.com/pngwn)!
- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - Custom components. Thanks [@pngwn](https://github.com/pngwn)!

## 0.3.0-beta.6

### Features

- [#6143](https://github.com/gradio-app/gradio/pull/6143) [`e4f7b4b40`](https://github.com/gradio-app/gradio/commit/e4f7b4b409323b01aa01b39e15ce6139e29aa073) - fix circular dependency with client + upload. Thanks [@pngwn](https://github.com/pngwn)!
- [#6136](https://github.com/gradio-app/gradio/pull/6136) [`667802a6c`](https://github.com/gradio-app/gradio/commit/667802a6cdbfb2ce454a3be5a78e0990b194548a) - JS Component Documentation. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!
- [#6094](https://github.com/gradio-app/gradio/pull/6094) [`c476bd5a5`](https://github.com/gradio-app/gradio/commit/c476bd5a5b70836163b9c69bf4bfe068b17fbe13) - Image v4. Thanks [@pngwn](https://github.com/pngwn)!

## 0.3.0-beta.5

### Features

- [#6044](https://github.com/gradio-app/gradio/pull/6044) [`9053c95a1`](https://github.com/gradio-app/gradio/commit/9053c95a10de12aef572018ee37c71106d2da675) - Simplify File Component. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

### Fixes

- [#6046](https://github.com/gradio-app/gradio/pull/6046) [`dbb7de5e0`](https://github.com/gradio-app/gradio/commit/dbb7de5e02c53fee05889d696d764d212cb96c74) - fix tests. Thanks [@pngwn](https://github.com/pngwn)!

## 0.3.0-beta.4

### Features

- [#5938](https://github.com/gradio-app/gradio/pull/5938) [`13ed8a485`](https://github.com/gradio-app/gradio/commit/13ed8a485d5e31d7d75af87fe8654b661edcca93) - V4: Use beta release versions for '@gradio' packages. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

## 0.3.3

### Patch Changes

- Updated dependencies [[`e70805d54`](https://github.com/gradio-app/gradio/commit/e70805d54cc792452545f5d8eccc1aa0212a4695)]:
  - @gradio/atoms@0.2.0

## 0.3.2

### Patch Changes

- Updated dependencies []:
  - @gradio/atoms@0.1.4

## 0.3.1

### Patch Changes

- Updated dependencies [[`8f0fed857`](https://github.com/gradio-app/gradio/commit/8f0fed857d156830626eb48b469d54d211a582d2)]:
  - @gradio/icons@0.2.0
  - @gradio/atoms@0.1.3

## 0.3.0

### Features

- [#5554](https://github.com/gradio-app/gradio/pull/5554) [`75ddeb390`](https://github.com/gradio-app/gradio/commit/75ddeb390d665d4484667390a97442081b49a423) - Accessibility Improvements. Thanks [@hannahblair](https://github.com/hannahblair)!

## 0.2.1

### Patch Changes

- Updated dependencies []:
  - @gradio/atoms@0.1.2

## 0.2.0

### Features

- [#5373](https://github.com/gradio-app/gradio/pull/5373) [`79d8f9d8`](https://github.com/gradio-app/gradio/commit/79d8f9d891901683c5a1b7486efb44eab2478c96) - Adds `height` and `zoom_speed` parameters to `Model3D` component, as well as a button to reset the camera position. Thanks [@abidlabs](https://github.com/abidlabs)!

## 0.1.0

### Highlights

#### Improve startup performance and markdown support ([#5279](https://github.com/gradio-app/gradio/pull/5279) [`fe057300`](https://github.com/gradio-app/gradio/commit/fe057300f0672c62dab9d9b4501054ac5d45a4ec))

##### Improved markdown support

We now have better support for markdown in `gr.Markdown` and `gr.Dataframe`. Including syntax highlighting and Github Flavoured Markdown. We also have more consistent markdown behaviour and styling.

##### Various performance improvements

These improvements will be particularly beneficial to large applications.

- Rather than attaching events manually, they are now delegated, leading to a significant performance improvement and addressing a performance regression introduced in a recent version of Gradio. App startup for large applications is now around twice as fast.
- Optimised the mounting of individual components, leading to a modest performance improvement during startup (~30%).
- Corrected an issue that was causing markdown to re-render infinitely.
- Ensured that the `gr.3DModel` does re-render prematurely.

Thanks [@pngwn](https://github.com/pngwn)!

### Features

- [#5216](https://github.com/gradio-app/gradio/pull/5216) [`4b58ea6d`](https://github.com/gradio-app/gradio/commit/4b58ea6d98e7a43b3f30d8a4cb6f379bc2eca6a8) - Update i18n tokens and locale files. Thanks [@hannahblair](https://github.com/hannahblair)!

### Fixes

- [#5285](https://github.com/gradio-app/gradio/pull/5285) [`cdfd4217`](https://github.com/gradio-app/gradio/commit/cdfd42174a9c777eaee9c1209bf8e90d8c7791f2) - Tweaks to `icon` parameter in `gr.Button()`. Thanks [@abidlabs](https://github.com/abidlabs)!

## 0.0.3

### Fixes

- [#5077](https://github.com/gradio-app/gradio/pull/5077) [`667875b2`](https://github.com/gradio-app/gradio/commit/667875b2441753e74d25bd9d3c8adedd8ede11cd) - Live audio streaming output

highlight:

#### Now supports loading streamed outputs

Allows users to use generators to stream audio out, yielding consecutive chunks of audio. Requires `streaming=True` to be set on the output audio.

```python
import gradio as gr
from pydub import AudioSegment

def stream_audio(audio_file):
    audio = AudioSegment.from_mp3(audio_file)
    i = 0
    chunk_size = 3000

    while chunk_size*i < len(audio):
        chunk = audio[chunk_size*i:chunk_size*(i+1)]
        i += 1
        if chunk:
            file = f"/tmp/{i}.mp3"
            chunk.export(file, format="mp3")
            yield file

demo = gr.Interface(
    fn=stream_audio,
    inputs=gr.Audio(type="filepath", label="Audio file to stream"),
    outputs=gr.Audio(autoplay=True, streaming=True),
)

demo.queue().launch()
```

From the backend, streamed outputs are served from the `/stream/` endpoint instead of the `/file/` endpoint. Currently just used to serve audio streaming output. The output JSON will have `is_stream`: `true`, instead of `is_file`: `true` in the file data object. Thanks [@aliabid94](https://github.com/aliabid94)!

## 0.0.2

### Patch Changes

- Updated dependencies []:
  - @gradio/atoms@0.0.2