import gradio as gr
from transformers import pipeline
import numpy as np

transcriber = pipeline("automatic-speech-recognition", model="openai/whisper-base.en")

def transcribe(audio):
    sr, y = audio
    
    # Convert to mono if stereo
    if y.ndim > 1:
        y = y.mean(axis=1)
        
    y = y.astype(np.float32)
    y /= np.max(np.abs(y))

    return transcriber({"sampling_rate": sr, "raw": y})["text"]  # type: ignore

demo = gr.Interface(
    transcribe,
    gr.Audio(sources="microphone"),
    "text",
    api_name="predict",
)

if __name__ == "__main__":
    demo.launch()
