import gradio as gr
from gradio.media import get_audio, MEDIA_PATHS

# get_audio returns the path to the audio file
audio_file = get_audio("cantina.wav")

with gr.Blocks() as demo:
    with gr.Tab("Audio"):
        gr.Audio(audio_file, buttons=["download"])
    with gr.Tab("Interface"):
        gr.Interface(
            lambda x: x,
            gr.Audio(),
            gr.Audio(),
            examples=[audio_file],
            cache_examples=True,
            api_name="predict",
        )
    with gr.Tab("Streaming"):
        gr.Interface(
            lambda x: x,
            gr.Audio(streaming=True),
            "audio",
            examples=[audio_file],
            cache_examples=True,
            api_name="predict",
        )
    with gr.Tab("console"):
        ip = gr.Textbox(label="User IP Address")
        gr.Interface(
            lambda cmd: f"You typed this command: {cmd}",
            "text",
            "text",
            api_name="predict",
        )

    def get_ip(request: gr.Request):
        return request.client.host

    demo.load(get_ip, None, ip)

if __name__ == "__main__":
    demo.launch(allowed_paths=MEDIA_PATHS)
