# 接口状态 (Interface State)

本指南介绍了 Gradio 中如何处理状态。了解全局状态和会话状态的区别，以及如何同时使用它们。

## 全局状态 (Global State)

您的函数可能使用超出单个函数调用的持久性数据。如果数据是所有函数调用和所有用户都可访问的内容，您可以在函数调用外部创建一个变量，并在函数内部访问它。例如，您可能会在函数外部加载一个大模型，并在函数内部使用它，以便每个函数调用都不需要重新加载模型。

$code_score_tracker

在上面的代码中，'scores' 数组在所有用户之间共享。如果多个用户访问此演示，他们的得分将全部添加到同一列表中，并且返回的前 3 个得分将从此共享引用中收集。

## 全局状态 (Global State)

Gradio 支持的另一种数据持久性是会话状态，其中数据在页面会话中的多个提交之间持久存在。但是，不同用户之间的数据*不*共享。要将数据存储在会话状态中，需要执行以下三个步骤：

1. 将额外的参数传递给您的函数，表示接口的状态。
2. 在函数的末尾，作为额外的返回值返回状态的更新值。
3. 在创建界面时添加 `'state'` 输入和 `'state'` 输出组件。

聊天机器人就是需要会话状态的一个例子 - 您希望访问用户之前的提交，但不能将聊天记录存储在全局变量中，因为这样聊天记录会在不同用户之间混乱。

$code_chatbot_dialogpt
$demo_chatbot_dialogpt

请注意，在每个页面中，状态在提交之间保持不变，但是如果在另一个标签中加载此演示（或刷新页面），演示将不共享聊天记录。

`state` 的默认值为 None。如果您将默认值传递给函数的状态参数，则该默认值将用作状态的默认值。`Interface` 类仅支持单个输入和输出状态变量，但可以是具有多个元素的列表。对于更复杂的用例，您可以使用 Blocks，[它支持多个 `State` 变量](/state_in_blocks/)。
