# 分块状态 (State in Blocks)

我们已经介绍了[接口状态](https://gradio.app/interface-state)，这篇指南将介绍分块状态，它的工作原理大致相同。

## 全局状态 (Global State)

分块中的全局状态与接口中的全局状态相同。在函数调用外创建的任何变量都是在所有用户之间共享的引用。

## 会话状态 (Session State)

Gradio 在分块应用程序中同样支持会话**状态**，即在页面会话中跨多次提交保持的数据。需要再次强调，会话数据*不会*在模型的不同用户之间共享。要在会话状态中存储数据，需要完成以下三个步骤：

1. 创建一个 `gr.State()` 对象。如果此可状态对象有一个默认值，请将其传递给构造函数。
2. 在事件监听器中，将 `State` 对象作为输入和输出。
3. 在事件监听器函数中，将变量添加到输入参数和返回值中。

让我们来看一个猜词游戏的例子。

$code_hangman
$demo_hangman

让我们看看在这个游戏中如何完成上述的 3 个步骤：

1. 我们将已使用的字母存储在 `used_letters_var` 中。在 `State` 的构造函数中，将其初始值设置为空列表`[]`。
2. 在 `btn.click()` 中，我们在输入和输出中都引用了 `used_letters_var`。
3. 在 `guess_letter` 中，我们将此 `State` 的值传递给 `used_letters`，然后在返回语句中返回更新后的该 `State` 的值。

对于更复杂的应用程序，您可能会在一个单独的分块应用程序中使用许多存储会话状态的 `State` 变量。

在[文档](https://gradio.app/docs/state)中了解更多关于 `State` 的信息。
