# @gradio/gallery

## 0.16.1

### Dependency updates

- @gradio/utils@0.11.1
- @gradio/client@2.0.2
- @gradio/video@0.20.0

## 0.16.0

### Features

- [#12539](https://github.com/gradio-app/gradio/pull/12539) [`f1d83fa`](https://github.com/gradio-app/gradio/commit/f1d83fac3d6e4bad60cf896a026fa2d572f26073) - Add ability to add custom buttons to components.  Thanks @abidlabs!

### Fixes

- [#12577](https://github.com/gradio-app/gradio/pull/12577) [`b4c00d2`](https://github.com/gradio-app/gradio/commit/b4c00d2f531d38e2677ea76cfeb412a7bd3bb1a3) - Fix Gallery preview_close event not firing on ESC key.  Thanks @majiayu000!

### Dependency updates

- @gradio/atoms@0.20.0
- @gradio/utils@0.11.0
- @gradio/client@2.0.1
- @gradio/statustracker@0.12.1
- @gradio/upload@0.17.3
- @gradio/file@0.14.0
- @gradio/image@0.25.0
- @gradio/video@0.19.0

## 0.15.36

### Dependency updates

- @gradio/video@0.18.0

## 0.15.35

### Dependency updates

- @gradio/utils@0.10.4

## 0.15.35

### Features

- [#11908](https://github.com/gradio-app/gradio/pull/11908) [`029034f`](https://github.com/gradio-app/gradio/commit/029034f7853ea018d110efe9b7e2ef7d1407091c) - Clear Error statuses
- [#12438](https://github.com/gradio-app/gradio/pull/12438) [`25ffc03`](https://github.com/gradio-app/gradio/commit/25ffc0398f8feb43d817c02b2ab970c16de6d797) - Svelte5 migration and bugfix

### Fixes


- [#11908](https://github.com/gradio-app/gradio/pull/11908) [`029034f`](https://github.com/gradio-app/gradio/commit/029034f7853ea018d110efe9b7e2ef7d1407091c) - Gallery: Allow empty columns when items < columns

### Dependencies

- @gradio/atoms@0.19.0
- @gradio/client@2.0.0
- @gradio/file@0.13.1
- @gradio/icons@0.15.0
- @gradio/image@0.24.0
- @gradio/statustracker@0.12.0
- @gradio/upload@0.17.2
- @gradio/utils@0.10.3
- @gradio/video@0.17.0

## 0.15.35-dev.3

### Dependency updates

- @gradio/atoms@0.19.0-dev.1
- @gradio/client@2.0.0-dev.2
- @gradio/statustracker@0.12.0-dev.1
- @gradio/upload@0.17.2-dev.2
- @gradio/image@0.24.0-dev.2
- @gradio/video@0.17.0-dev.2
- @gradio/file@0.13.1-dev.2

## 0.15.35-dev.2

### Dependency updates

- @gradio/atoms@0.18.2-dev.0
- @gradio/upload@0.17.2-dev.1
- @gradio/utils@0.10.3-dev.0
- @gradio/image@0.23.2-dev.1
- @gradio/statustracker@0.12.0-dev.0
- @gradio/icons@0.15.0-dev.0
- @gradio/video@0.17.0-dev.1
- @gradio/file@0.13.1-dev.1

## 0.15.35-dev.1

### Fixes

- [#12066](https://github.com/gradio-app/gradio/pull/12066) [`6a4757a`](https://github.com/gradio-app/gradio/commit/6a4757ab289e8e53b5503eb6887333d7ad26c9eb) - Gallery: Allow empty columns when items < columns.  Thanks @missionfloyd!

### Dependency updates

- @gradio/client@2.0.0-dev.1

## 0.15.35-dev.0

### Dependency updates

- @gradio/upload@0.17.2-dev.0
- @gradio/client@2.0.0-dev.0
- @gradio/image@0.23.2-dev.0
- @gradio/file@0.13.1-dev.0
- @gradio/video@0.17.0-dev.0

## 0.15.34

### Dependency updates

- @gradio/client@1.19.1

## 0.15.34

### Dependency updates

- @gradio/image@0.23.1
- @gradio/upload@0.17.1
- @gradio/atoms@0.18.1

## 0.15.34

### Fixes

- [#11938](https://github.com/gradio-app/gradio/pull/11938) [`beddde5`](https://github.com/gradio-app/gradio/commit/beddde5d432904d6384b7285acdbf1fd78469af7) - Fix bug where Gallery scrollbar would not show up.  Thanks @freddyaboulton!

## 0.15.33

### Fixes

- [#11784](https://github.com/gradio-app/gradio/pull/11784) [`d9dd3f5`](https://github.com/gradio-app/gradio/commit/d9dd3f54b7fb34cf7118e549d39fc63937ca3489) - Add "hidden" option to component's `visible` kwarg to render but visually hide the component.  Thanks @pngwn!

### Dependency updates

- @gradio/statustracker@0.11.1
- @gradio/atoms@0.18.0
- @gradio/client@1.19.0
- @gradio/upload@0.17.0
- @gradio/image@0.23.0
- @gradio/file@0.13.0
- @gradio/video@0.16.0

## 0.15.32

### Fixes

- [#11787](https://github.com/gradio-app/gradio/pull/11787) [`b19576c`](https://github.com/gradio-app/gradio/commit/b19576c45f0748ca655864f4d80ff835318f1299) - Allow deleting and uploading additional images to interactive `gr.Gallery` and other fixes.  Thanks @abidlabs!

### Dependency updates

- @gradio/client@1.18.0
- @gradio/icons@0.14.0
- @gradio/atoms@0.17.0
- @gradio/statustracker@0.11.0
- @gradio/upload@0.16.17
- @gradio/file@0.12.29
- @gradio/image@0.22.18
- @gradio/video@0.15.1

## 0.15.31

### Dependency updates

- @gradio/statustracker@0.10.18

## 0.15.31

### Dependency updates

- @gradio/icons@0.13.1
- @gradio/upload@0.16.16

## 0.15.31

### Dependency updates

- @gradio/statustracker@0.10.17
- @gradio/atoms@0.16.5
- @gradio/client@1.17.1
- @gradio/icons@0.13.0
- @gradio/upload@0.16.15
- @gradio/image@0.22.17
- @gradio/file@0.12.28
- @gradio/video@0.15.0

## 0.15.30

### Dependency updates

- @gradio/statustracker@0.10.16
- @gradio/video@0.14.24
- @gradio/atoms@0.16.4
- @gradio/client@1.17.0
- @gradio/upload@0.16.14
- @gradio/file@0.12.27
- @gradio/image@0.22.16

## 0.15.29

### Dependency updates

- @gradio/upload@0.16.13
- @gradio/video@0.14.23
- @gradio/client@1.16.0
- @gradio/image@0.22.15
- @gradio/file@0.12.26

## 0.15.28

### Dependency updates

- @gradio/upload@0.16.12
- @gradio/video@0.14.22
- @gradio/client@1.15.7
- @gradio/image@0.22.14
- @gradio/file@0.12.25

## 0.15.27

### Dependency updates

- @gradio/video@0.14.21
- @gradio/client@1.15.6
- @gradio/statustracker@0.10.15
- @gradio/upload@0.16.11
- @gradio/image@0.22.13
- @gradio/file@0.12.24

## 0.15.26

### Dependency updates

- @gradio/atoms@0.16.3
- @gradio/statustracker@0.10.14
- @gradio/upload@0.16.10
- @gradio/video@0.14.20
- @gradio/client@1.15.5
- @gradio/image@0.22.12
- @gradio/file@0.12.23

## 0.15.25

### Dependency updates

- @gradio/upload@0.16.9
- @gradio/video@0.14.19
- @gradio/client@1.15.4
- @gradio/image@0.22.11
- @gradio/file@0.12.22

## 0.15.24

### Dependency updates

- @gradio/statustracker@0.10.13
- @gradio/video@0.14.18
- @gradio/atoms@0.16.2
- @gradio/client@1.15.3
- @gradio/upload@0.16.8
- @gradio/image@0.22.10
- @gradio/file@0.12.21

## 0.15.23

### Dependency updates

- @gradio/statustracker@0.10.12

## 0.15.23

### Fixes

- [#11362](https://github.com/gradio-app/gradio/pull/11362) [`1b88339`](https://github.com/gradio-app/gradio/commit/1b883395eb3feceed60ec79fcf19285269e2b171) - Fix Gallery thumbnail overflow.  Thanks @freddyaboulton!

## 0.15.22

### Dependency updates

- @gradio/upload@0.16.7
- @gradio/video@0.14.17
- @gradio/client@1.15.2
- @gradio/file@0.12.20
- @gradio/image@0.22.9

## 0.15.21

### Dependency updates

- @gradio/statustracker@0.10.12
- @gradio/video@0.14.16
- @gradio/image@0.22.8
- @gradio/file@0.12.19

## 0.15.20

### Dependency updates

- @gradio/statustracker@0.10.12
- @gradio/client@1.15.1
- @gradio/upload@0.16.6
- @gradio/image@0.22.7
- @gradio/file@0.12.19
- @gradio/video@0.14.15

## 0.15.19

### Features

- [#11177](https://github.com/gradio-app/gradio/pull/11177) [`3068196`](https://github.com/gradio-app/gradio/commit/3068196d47234fd1c1634f33b9ddfc089f5cbbe0) - Improved, smoother fullscreen mode for components.  Thanks @aliabid94!

### Dependency updates

- @gradio/statustracker@0.10.11
- @gradio/atoms@0.16.1
- @gradio/client@1.15.0
- @gradio/upload@0.16.5
- @gradio/image@0.22.6
- @gradio/video@0.14.14
- @gradio/file@0.12.18

## 0.15.18

### Dependency updates

- @gradio/video@0.14.13
- @gradio/upload@0.16.4
- @gradio/image@0.22.5
- @gradio/file@0.12.17

## 0.15.17

### Dependency updates

- @gradio/video@0.14.12
- @gradio/image@0.22.4

## 0.15.16

### Dependency updates

- @gradio/statustracker@0.10.10
- @gradio/image@0.22.3
- @gradio/upload@0.16.3
- @gradio/video@0.14.11
- @gradio/atoms@0.16.0
- @gradio/file@0.12.16

## 0.15.15

### Dependency updates

- @gradio/statustracker@0.10.9
- @gradio/video@0.14.10
- @gradio/atoms@0.15.2
- @gradio/client@1.14.2
- @gradio/utils@0.10.2
- @gradio/upload@0.16.2
- @gradio/image@0.22.2
- @gradio/file@0.12.15

## 0.15.14

### Dependency updates

- @gradio/upload@0.16.1
- @gradio/atoms@0.15.1
- @gradio/statustracker@0.10.8
- @gradio/icons@0.12.0
- @gradio/image@0.22.1
- @gradio/video@0.14.9
- @gradio/file@0.12.14

## 0.15.13

### Dependency updates

- @gradio/statustracker@0.10.7
- @gradio/video@0.14.8
- @gradio/atoms@0.15.0
- @gradio/icons@0.11.0
- @gradio/upload@0.16.0
- @gradio/image@0.22.0
- @gradio/file@0.12.13

## 0.15.12

### Dependency updates

- @gradio/video@0.14.7
- @gradio/client@1.14.1
- @gradio/upload@0.15.7
- @gradio/image@0.21.7
- @gradio/file@0.12.12

## 0.15.11

### Dependency updates

- @gradio/video@0.14.6
- @gradio/atoms@0.14.1
- @gradio/statustracker@0.10.6
- @gradio/client@1.14.0
- @gradio/upload@0.15.6
- @gradio/image@0.21.6
- @gradio/file@0.12.11

## 0.15.10

### Dependency updates

- @gradio/image@0.21.5
- @gradio/upload@0.15.5
- @gradio/statustracker@0.10.5
- @gradio/video@0.14.5
- @gradio/atoms@0.14.0
- @gradio/file@0.12.10

## 0.15.9

### Dependency updates

- @gradio/video@0.14.4
- @gradio/client@1.13.1
- @gradio/upload@0.15.4
- @gradio/image@0.21.4
- @gradio/file@0.12.9

## 0.15.8

### Dependency updates

- @gradio/upload@0.15.3
- @gradio/video@0.14.3
- @gradio/client@1.13.0
- @gradio/image@0.21.3
- @gradio/file@0.12.8

## 0.15.7

### Dependency updates

- @gradio/image@0.21.2
- @gradio/upload@0.15.2
- @gradio/statustracker@0.10.4
- @gradio/video@0.14.2
- @gradio/atoms@0.13.3
- @gradio/file@0.12.7

## 0.15.6

### Dependency updates

- @gradio/statustracker@0.10.3
- @gradio/video@0.14.1
- @gradio/atoms@0.13.2
- @gradio/utils@0.10.1
- @gradio/client@1.12.0
- @gradio/upload@0.15.1
- @gradio/image@0.21.1
- @gradio/file@0.12.6

## 0.15.5

### Dependency updates

- @gradio/client@1.11.0
- @gradio/upload@0.15.0
- @gradio/image@0.21.0
- @gradio/file@0.12.5
- @gradio/video@0.14.0

## 0.15.4

### Dependency updates

- @gradio/upload@0.14.8
- @gradio/file@0.12.4
- @gradio/image@0.20.4
- @gradio/video@0.13.4

## 0.15.3

### Dependency updates

- @gradio/upload@0.14.7
- @gradio/file@0.12.3
- @gradio/image@0.20.3
- @gradio/video@0.13.3

## 0.15.2

### Dependency updates

- @gradio/upload@0.14.6
- @gradio/video@0.13.2
- @gradio/statustracker@0.10.2
- @gradio/image@0.20.2
- @gradio/file@0.12.2

## 0.15.1

### Dependency updates

- @gradio/video@0.13.1
- @gradio/atoms@0.13.1
- @gradio/statustracker@0.10.1
- @gradio/client@1.10.0
- @gradio/icons@0.10.0
- @gradio/upload@0.14.5
- @gradio/image@0.20.1
- @gradio/file@0.12.1

## 0.15.0

### Features

- [#10303](https://github.com/gradio-app/gradio/pull/10303) [`f19ca89`](https://github.com/gradio-app/gradio/commit/f19ca89cdd4040dbaa41bbc3b9915edc032603a0) - Add preview_open and preview_close events to Gallery.  Thanks @freddyaboulton!

## 0.14.1

### Fixes

- [#10269](https://github.com/gradio-app/gradio/pull/10269) [`890eaa3`](https://github.com/gradio-app/gradio/commit/890eaa3a9e53dab5bcb16c5d017ae0470109b8fb) - Allow displaying SVG images securely in `gr.Image` and `gr.Gallery` components.  Thanks @abidlabs!

### Dependency updates

- @gradio/atoms@0.13.0
- @gradio/utils@0.10.0
- @gradio/upload@0.14.4
- @gradio/client@1.9.0
- @gradio/icons@0.9.0
- @gradio/statustracker@0.10.0
- @gradio/image@0.20.0
- @gradio/video@0.13.0
- @gradio/file@0.12.0

## 0.14.0

### Features

- [#10098](https://github.com/gradio-app/gradio/pull/10098) [`9a6ce6f`](https://github.com/gradio-app/gradio/commit/9a6ce6f6b089d94c06da0b8620f28967f39f8383) - Refactor full screen logic to be reusable.  Thanks @hannahblair!

### Dependency updates

- @gradio/video@0.12.1
- @gradio/statustracker@0.9.7
- @gradio/upload@0.14.3
- @gradio/atoms@0.12.0
- @gradio/image@0.19.0
- @gradio/file@0.11.3

## 0.13.10

### Dependency updates

- @gradio/image@0.18.0
- @gradio/video@0.12.0

## 0.13.9

### Fixes

- [#10016](https://github.com/gradio-app/gradio/pull/10016) [`7b8f1e4`](https://github.com/gradio-app/gradio/commit/7b8f1e447acae4506236db9819c7c4a54f8b8153) - Fix double gallery close button in preview.  Thanks @freddyaboulton!

### Dependency updates

- @gradio/video@0.11.9
- @gradio/atoms@0.11.2
- @gradio/utils@0.9.0
- @gradio/statustracker@0.9.6
- @gradio/upload@0.14.2
- @gradio/image@0.17.0
- @gradio/file@0.11.2

## 0.13.8

### Dependency updates

- @gradio/video@0.11.8
- @gradio/atoms@0.11.1
- @gradio/client@1.8.0
- @gradio/utils@0.8.0
- @gradio/upload@0.14.1
- @gradio/statustracker@0.9.5
- @gradio/image@0.16.8
- @gradio/file@0.11.1

## 0.13.7

### Fixes

- [#9881](https://github.com/gradio-app/gradio/pull/9881) [`6866a54`](https://github.com/gradio-app/gradio/commit/6866a5433afe7e29ad73bac10ecbc3b44f5867f4) - Ensure gallery share button is positioned correctly.  Thanks @hannahblair!

### Dependency updates

- @gradio/video@0.11.7
- @gradio/statustracker@0.9.4
- @gradio/atoms@0.11.0
- @gradio/file@0.11.0
- @gradio/upload@0.14.0
- @gradio/image@0.16.7

## 0.13.6

### Dependency updates

- @gradio/video@0.11.6
- @gradio/statustracker@0.9.3
- @gradio/atoms@0.10.1
- @gradio/client@1.7.1
- @gradio/image@0.16.6
- @gradio/upload@0.13.5
- @gradio/file@0.10.6

## 0.13.5

### Dependency updates

- @gradio/video@0.11.5
- @gradio/statustracker@0.9.2
- @gradio/atoms@0.10.0
- @gradio/icons@0.8.1
- @gradio/upload@0.13.4
- @gradio/file@0.10.5
- @gradio/image@0.16.5

## 0.13.4

### Dependency updates

- @gradio/statustracker@0.9.1
- @gradio/upload@0.13.3
- @gradio/video@0.11.4
- @gradio/atoms@0.9.2
- @gradio/file@0.10.4
- @gradio/image@0.16.4

## 0.13.3

### Dependency updates

- @gradio/video@0.11.3
- @gradio/atoms@0.9.1
- @gradio/statustracker@0.9.0
- @gradio/client@1.7.0
- @gradio/upload@0.13.2
- @gradio/image@0.16.3
- @gradio/file@0.10.3

## 0.13.2

### Dependency updates

- @gradio/file@0.10.2
- @gradio/upload@0.13.1
- @gradio/image@0.16.2
- @gradio/video@0.11.2

## 0.13.1

### Dependency updates

- @gradio/video@0.11.1
- @gradio/statustracker@0.8.1
- @gradio/file@0.10.1
- @gradio/image@0.16.1

## 0.13.0

### Features

- [#8843](https://github.com/gradio-app/gradio/pull/8843) [`6f95286`](https://github.com/gradio-app/gradio/commit/6f95286337459efbccb95c9cfac63355669df9ee) - Improve Icon Button consistency
- [#8843](https://github.com/gradio-app/gradio/pull/8843) [`6f95286`](https://github.com/gradio-app/gradio/commit/6f95286337459efbccb95c9cfac63355669df9ee) - Video gallery
- [#8843](https://github.com/gradio-app/gradio/pull/8843) [`6f95286`](https://github.com/gradio-app/gradio/commit/6f95286337459efbccb95c9cfac63355669df9ee) - Ssr part 2

### Dependencies

- @gradio/atoms@0.9.0
- @gradio/client@1.6.0
- @gradio/icons@0.8.0
- @gradio/image@0.16.0
- @gradio/statustracker@0.8.0
- @gradio/upload@0.13.0
- @gradio/utils@0.7.0
- @gradio/video@0.11.0
- @gradio/file@0.10.0

## 0.13.0-beta.7

### Dependency updates

- @gradio/upload@0.13.0-beta.7
- @gradio/statustracker@0.8.0-beta.5
- @gradio/icons@0.8.0-beta.4
- @gradio/atoms@0.9.0-beta.5
- @gradio/image@0.16.0-beta.7
- @gradio/video@0.11.0-beta.7
- @gradio/file@0.10.0-beta.7

## 0.13.0-beta.6

### Dependency updates

- @gradio/video@0.11.0-beta.6
- @gradio/statustracker@0.8.0-beta.4
- @gradio/atoms@0.9.0-beta.4
- @gradio/client@1.6.0-beta.4
- @gradio/upload@0.13.0-beta.6
- @gradio/image@0.16.0-beta.6
- @gradio/file@0.10.0-beta.6

## 0.13.0-beta.5

### Dependency updates

- @gradio/upload@0.13.0-beta.5
- @gradio/statustracker@0.8.0-beta.3
- @gradio/video@0.11.0-beta.5
- @gradio/icons@0.8.0-beta.3
- @gradio/atoms@0.9.0-beta.3
- @gradio/file@0.10.0-beta.5
- @gradio/image@0.16.0-beta.5

## 0.13.0-beta.4

### Dependency updates

- @gradio/statustracker@0.8.0-beta.2
- @gradio/upload@0.13.0-beta.4
- @gradio/file@0.10.0-beta.4
- @gradio/image@0.16.0-beta.4
- @gradio/video@0.11.0-beta.4

## 0.13.0-beta.3

### Dependency updates

- @gradio/upload@0.13.0-beta.3
- @gradio/video@0.11.0-beta.3
- @gradio/client@1.6.0-beta.3
- @gradio/file@0.10.0-beta.3
- @gradio/image@0.16.0-beta.3

## 0.13.0-beta.2

### Features

- [#9339](https://github.com/gradio-app/gradio/pull/9339) [`4c8c6f2`](https://github.com/gradio-app/gradio/commit/4c8c6f2fe603081941c5fdc43f48a0632b9f31ad) - Ssr part 2.  Thanks @pngwn!
- [#9250](https://github.com/gradio-app/gradio/pull/9250) [`350b0a5`](https://github.com/gradio-app/gradio/commit/350b0a5cafb9176f914f62e7c90de51d4352cc77) - Improve Icon Button consistency.  Thanks @hannahblair!

### Dependency updates

- @gradio/atoms@0.9.0-beta.2
- @gradio/upload@0.13.0-beta.2
- @gradio/client@1.6.0-beta.2
- @gradio/icons@0.8.0-beta.2
- @gradio/statustracker@0.8.0-beta.2
- @gradio/utils@0.7.0-beta.2
- @gradio/file@0.10.0-beta.2
- @gradio/image@0.16.0-beta.2
- @gradio/video@0.11.0-beta.2

## 0.13.0-beta.1

### Dependency updates

- @gradio/video@0.11.0-beta.1
- @gradio/atoms@0.8.1-beta.1
- @gradio/icons@0.8.0-beta.1
- @gradio/statustracker@0.8.0-beta.1
- @gradio/utils@0.7.0-beta.1
- @gradio/client@1.6.0-beta.1
- @gradio/image@0.16.0-beta.1
- @gradio/upload@0.12.4-beta.1
- @gradio/file@0.9.4-beta.1

## 0.13.0-beta.0

### Features

- [#9052](https://github.com/gradio-app/gradio/pull/9052) [`f3652eb`](https://github.com/gradio-app/gradio/commit/f3652ebe08211e12739df73c15fd97e5ff81276a) - Video gallery.  Thanks @dawoodkhan82!

## 0.12.2

### Fixes

- [#9163](https://github.com/gradio-app/gradio/pull/9163) [`2b6cbf2`](https://github.com/gradio-app/gradio/commit/2b6cbf25908e42cf027324e54ef2cc0baad11a91) - fix exports and generate types.  Thanks @pngwn!

### Dependency updates

- @gradio/utils@0.6.1
- @gradio/statustracker@0.7.6
- @gradio/atoms@0.8.1
- @gradio/icons@0.7.2
- @gradio/client@1.5.2
- @gradio/upload@0.12.4
- @gradio/image@0.15.1
- @gradio/file@0.9.4

## 0.12.1

### Features

- [#9118](https://github.com/gradio-app/gradio/pull/9118) [`e1c404d`](https://github.com/gradio-app/gradio/commit/e1c404da1143fb52b659d03e028bdba1badf443d) - setup npm-previews of all packages.  Thanks @pngwn!

### Dependency updates

- @gradio/utils@0.6.0
- @gradio/upload@0.12.3
- @gradio/atoms@0.8.0
- @gradio/client@1.5.1
- @gradio/statustracker@0.7.5
- @gradio/icons@0.7.1
- @gradio/image@0.15.0
- @gradio/file@0.9.3

## 0.12.0

### Features

- [#8964](https://github.com/gradio-app/gradio/pull/8964) [`bf6bbd9`](https://github.com/gradio-app/gradio/commit/bf6bbd971acddbf78f03bea431ed7d1e0003ccf9) - Add min/max-imize button to gr.Image and gr.Gallery.  Thanks @hannahblair!

### Dependency updates

- @gradio/atoms@0.7.9
- @gradio/statustracker@0.7.4
- @gradio/client@1.5.0
- @gradio/icons@0.7.0
- @gradio/upload@0.12.2
- @gradio/image@0.14.0
- @gradio/file@0.9.2

## 0.11.4

### Dependency updates

- @gradio/atoms@0.7.8
- @gradio/icons@0.6.1
- @gradio/utils@0.5.2
- @gradio/statustracker@0.7.3
- @gradio/upload@0.12.1
- @gradio/image@0.13.1
- @gradio/file@0.9.1

## 0.11.3

### Dependency updates

- @gradio/client@1.4.0
- @gradio/image@0.13.0
- @gradio/statustracker@0.7.2
- @gradio/file@0.9.0
- @gradio/upload@0.12.0
- @gradio/atoms@0.7.7

## 0.11.2

### Dependency updates

- @gradio/atoms@0.7.6
- @gradio/utils@0.5.1
- @gradio/statustracker@0.7.1
- @gradio/client@1.3.0
- @gradio/upload@0.11.5
- @gradio/image@0.12.2
- @gradio/icons@0.6.0
- @gradio/file@0.8.5

## 0.11.1

### Dependency updates

- @gradio/upload@0.11.4
- @gradio/client@1.2.1
- @gradio/image@0.12.1
- @gradio/file@0.8.4

## 0.11.0

### Features

- [#8131](https://github.com/gradio-app/gradio/pull/8131) [`bb504b4`](https://github.com/gradio-app/gradio/commit/bb504b494947a287d6386e0e7ead3860c0f15223) - Gradio components in `gr.Chatbot()`.  Thanks @dawoodkhan82!

### Fixes

- [#8594](https://github.com/gradio-app/gradio/pull/8594) [`530f8a0`](https://github.com/gradio-app/gradio/commit/530f8a0b056b35dabe9bdd148e1ab7c4577f017d) - chatbot component tweaks.  Thanks @pngwn!

### Dependency updates

- @gradio/atoms@0.7.5
- @gradio/image@0.12.0
- @gradio/utils@0.5.0
- @gradio/icons@0.5.0
- @gradio/client@1.2.0
- @gradio/statustracker@0.7.0
- @gradio/file@0.8.3
- @gradio/upload@0.11.3

## 0.10.10

### Dependency updates

- @gradio/client@1.1.1
- @gradio/upload@0.11.2
- @gradio/file@0.8.2
- @gradio/image@0.11.10

## 0.10.9

### Dependency updates

- @gradio/upload@0.11.1
- @gradio/client@1.1.0
- @gradio/file@0.8.1
- @gradio/image@0.11.9

## 0.10.8

### Dependency updates

- @gradio/statustracker@0.6.0
- @gradio/client@1.0.0
- @gradio/file@0.8.0
- @gradio/upload@0.11.0
- @gradio/image@0.11.8

## 0.10.7

### Dependency updates

- @gradio/upload@0.10.7
- @gradio/client@0.20.1
- @gradio/file@0.7.7
- @gradio/image@0.11.7

## 0.10.6

### Dependency updates

- @gradio/client@0.20.0
- @gradio/statustracker@0.6.0
- @gradio/file@0.7.6
- @gradio/image@0.11.6
- @gradio/upload@0.10.6

## 0.10.5

### Dependency updates

- @gradio/utils@0.4.2
- @gradio/atoms@0.7.4
- @gradio/statustracker@0.5.5
- @gradio/upload@0.10.5
- @gradio/client@0.19.4
- @gradio/image@0.11.5
- @gradio/file@0.7.5

## 0.10.4

### Dependency updates

- @gradio/client@0.19.3
- @gradio/statustracker@0.5.4
- @gradio/file@0.7.4
- @gradio/image@0.11.4
- @gradio/upload@0.10.4

## 0.10.3

### Dependency updates

- @gradio/upload@0.10.3
- @gradio/client@0.19.2
- @gradio/file@0.7.3
- @gradio/image@0.11.3

## 0.10.2

### Dependency updates

- @gradio/statustracker@0.5.3
- @gradio/client@0.19.1
- @gradio/file@0.7.2
- @gradio/image@0.11.2
- @gradio/upload@0.10.2

## 0.10.1

### Fixes

- [#8252](https://github.com/gradio-app/gradio/pull/8252) [`22df61a`](https://github.com/gradio-app/gradio/commit/22df61a26adf8023f6dd49c051979990e8d3879a) - Client node fix.  Thanks @pngwn!

### Dependency updates

- @gradio/atoms@0.7.3
- @gradio/statustracker@0.5.2
- @gradio/client@0.19.0
- @gradio/icons@0.4.1
- @gradio/image@0.11.1
- @gradio/upload@0.10.1
- @gradio/file@0.7.1

## 0.10.0

### Features

- [#8121](https://github.com/gradio-app/gradio/pull/8121) [`f5b710c`](https://github.com/gradio-app/gradio/commit/f5b710c919b0ce604ea955f0d5f4faa91095ca4a) - chore(deps): update dependency eslint to v9.  Thanks @renovate!
- [#8209](https://github.com/gradio-app/gradio/pull/8209) [`b9afe93`](https://github.com/gradio-app/gradio/commit/b9afe93915401df5bd6737c89395c2477acfa585) - Rename `eventSource_Factory` and `fetch_implementation`.  Thanks @hannahblair!

### Fixes

- [#8179](https://github.com/gradio-app/gradio/pull/8179) [`6a218b4`](https://github.com/gradio-app/gradio/commit/6a218b4148095aaa0c58d8c20973ba01c8764fc2) - rework upload to be a class method + pass client into each component.  Thanks @pngwn!

### Dependency updates

- @gradio/atoms@0.7.2
- @gradio/client@0.18.0
- @gradio/upload@0.10.0
- @gradio/utils@0.4.1
- @gradio/statustracker@0.5.1
- @gradio/image@0.11.0
- @gradio/file@0.7.0

## 0.9.0

### Highlights

#### Setting File Upload Limits ([#7909](https://github.com/gradio-app/gradio/pull/7909) [`2afca65`](https://github.com/gradio-app/gradio/commit/2afca6541912b37dc84f447c7ad4af21607d7c72))

We have added a `max_file_size` size parameter to `launch()` that limits to size of files uploaded to the server. This limit applies to each individual file. This parameter can be specified as a string or an integer (corresponding to the size in bytes).

The following code snippet sets a max file size of 5 megabytes.

```python
import gradio as gr

demo = gr.Interface(lambda x: x, "image", "image")

demo.launch(max_file_size="5mb")
# or
demo.launch(max_file_size=5 * gr.FileSize.MB)
```

![max_file_size_upload](https://github.com/gradio-app/gradio/assets/41651716/7547330c-a082-4901-a291-3f150a197e45)


#### Error states can now be cleared

When a component encounters an error, the error state shown in the UI can now be cleared by clicking on the `x` icon in the top right of the component. This applies to all types of errors, whether it's raised in the UI or the server.

![error_modal_calculator](https://github.com/gradio-app/gradio/assets/41651716/16cb071c-accd-45a6-9c18-0dea27d4bd98)

 Thanks @freddyaboulton!

### Fixes

- [#8066](https://github.com/gradio-app/gradio/pull/8066) [`624f9b9`](https://github.com/gradio-app/gradio/commit/624f9b9477f74a581a6c14119234f9efdfcda398) - make gradio dev tools a local dependency rather than bundling.  Thanks @pngwn!

### Dependency updates

- @gradio/atoms@0.7.1
- @gradio/client@0.17.0
- @gradio/file@0.6.0
- @gradio/image@0.10.0
- @gradio/statustracker@0.5.0
- @gradio/upload@0.9.0
- @gradio/utils@0.4.0

## 0.8.8

### Dependency updates

- @gradio/utils@0.3.2
- @gradio/statustracker@0.4.12
- @gradio/client@0.16.0
- @gradio/upload@0.8.5
- @gradio/atoms@0.7.0
- @gradio/icons@0.4.0
- @gradio/image@0.9.12
- @gradio/file@0.5.12

## 0.8.7

### Dependency updates

- @gradio/utils@0.3.1
- @gradio/atoms@0.6.2
- @gradio/statustracker@0.4.11
- @gradio/upload@0.8.4
- @gradio/image@0.9.11
- @gradio/client@0.15.1
- @gradio/file@0.5.11

## 0.8.6

### Dependency updates

- @gradio/upload@0.8.3
- @gradio/client@0.15.0
- @gradio/file@0.5.10
- @gradio/image@0.9.10

## 0.8.5

### Dependency updates

- @gradio/atoms@0.6.1
- @gradio/statustracker@0.4.10
- @gradio/icons@0.3.4
- @gradio/upload@0.8.2
- @gradio/image@0.9.9
- @gradio/file@0.5.9

## 0.8.4

### Dependency updates

- @gradio/upload@0.8.1
- @gradio/statustracker@0.4.9
- @gradio/atoms@0.6.0
- @gradio/file@0.5.8
- @gradio/image@0.9.8

## 0.8.3

### Dependency updates

- @gradio/client@0.14.0
- @gradio/upload@0.8.0
- @gradio/file@0.5.7
- @gradio/image@0.9.7

## 0.8.2

### Dependency updates

- @gradio/upload@0.7.7
- @gradio/client@0.13.0
- @gradio/file@0.5.6
- @gradio/image@0.9.6

## 0.8.1

### Patch Changes

- Updated dependencies [[`8181695`](https://github.com/gradio-app/gradio/commit/8181695e70187e8bc2bf7518697098c8d1b9843d)]:
  - @gradio/upload@0.7.6
  - @gradio/file@0.5.5
  - @gradio/image@0.9.5

## 0.8.0

### Features

- [#7516](https://github.com/gradio-app/gradio/pull/7516) [`3645da5`](https://github.com/gradio-app/gradio/commit/3645da5f1e5539668cad75071a82fdd78f50263c) - Fix incorrect relative mouse coordinates for `Gallery` preview overlay. Thanks [@MMP0](https://github.com/MMP0)!

## 0.7.3

### Fixes

- [#7505](https://github.com/gradio-app/gradio/pull/7505) [`b186767`](https://github.com/gradio-app/gradio/commit/b18676774448f44a2ef3a9490224703254cffa7c) - Fix `Gallery` preview overlay and backdrop. Thanks [@MMP0](https://github.com/MMP0)!

## 0.7.2

### Patch Changes

- Updated dependencies [[`f191786`](https://github.com/gradio-app/gradio/commit/f1917867916647d383b8d7ce15e0c17f2abbdec1)]:
  - @gradio/icons@0.3.3
  - @gradio/atoms@0.5.3
  - @gradio/file@0.5.2
  - @gradio/image@0.9.2
  - @gradio/statustracker@0.4.7
  - @gradio/upload@0.7.4

## 0.7.1

### Patch Changes

- Updated dependencies [[`065c5b1`](https://github.com/gradio-app/gradio/commit/065c5b163c4badb9d9cbd06d627fb4ba086003e7), [`32b317f`](https://github.com/gradio-app/gradio/commit/32b317f24e3d43f26684bb9f3964f31efd0ea556)]:
  - @gradio/utils@0.3.0
  - @gradio/client@0.12.1
  - @gradio/atoms@0.5.2
  - @gradio/file@0.5.1
  - @gradio/image@0.9.1
  - @gradio/statustracker@0.4.6
  - @gradio/upload@0.7.3

## 0.7.0

### Features

- [#7183](https://github.com/gradio-app/gradio/pull/7183) [`49d9c48`](https://github.com/gradio-app/gradio/commit/49d9c48537aa706bf72628e3640389470138bdc6) - [WIP] Refactor file normalization to be in the backend and remove it from the frontend of each component. Thanks [@abidlabs](https://github.com/abidlabs)!
- [#7369](https://github.com/gradio-app/gradio/pull/7369) [`7b10d97`](https://github.com/gradio-app/gradio/commit/7b10d97b0f928fde6a71a94460fb8ca784e7a31d) - Remove the `@gradio/wasm` dependency from `@gradio/gallery` that is not used. Thanks [@whitphx](https://github.com/whitphx)!

## 0.6.1

### Patch Changes

- Updated dependencies [[`572e360`](https://github.com/gradio-app/gradio/commit/572e360fff4a03c335b86e1a7517a44cb6af2bcd), [`733ca26`](https://github.com/gradio-app/gradio/commit/733ca266bb1ba9049ed7309b8f0614199682e173), [`68a54a7`](https://github.com/gradio-app/gradio/commit/68a54a7a310d8d7072fdae930bf1cfdf12c45a7f), [`2e6672c`](https://github.com/gradio-app/gradio/commit/2e6672c815e39fd6af78353e66661100b9102cd4), [`fdd1521`](https://github.com/gradio-app/gradio/commit/fdd15213c24b9cbc58bbc1b6beb4af7c18f48557), [`200e251`](https://github.com/gradio-app/gradio/commit/200e2518e4d449aa82819a8d119e912bd1d95c15), [`c3e61e4`](https://github.com/gradio-app/gradio/commit/c3e61e4f70696a71aede67b65d28447eb67daf16), [`cae05c0`](https://github.com/gradio-app/gradio/commit/cae05c05ecde56c4d92c6b5ed8d13353505cbd14), [`05d8a3c`](https://github.com/gradio-app/gradio/commit/05d8a3c8030b733bd47250f5db6f89f230f9a707), [`8dd6f4b`](https://github.com/gradio-app/gradio/commit/8dd6f4bc1901792f05cd59e86df7b1dbab692739)]:
  - @gradio/upload@0.7.1
  - @gradio/image@0.8.0
  - @gradio/client@0.11.0
  - @gradio/utils@0.2.2
  - @gradio/file@0.4.9
  - @gradio/wasm@0.6.0
  - @gradio/atoms@0.5.1
  - @gradio/statustracker@0.4.5

## 0.6.0

### Features

- [#7148](https://github.com/gradio-app/gradio/pull/7148) [`c60ad4d`](https://github.com/gradio-app/gradio/commit/c60ad4d34ab5b56a89bf6796822977e51e7a4a32) - Use Gallery as input component. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

## 0.5.0

### Features

- [#7024](https://github.com/gradio-app/gradio/pull/7024) [`f2d69fc`](https://github.com/gradio-app/gradio/commit/f2d69fc7d0c1c3457112e702b53e38a0255fc1b7) - Fix gallery thumbnail design regression. Thanks [@hannahblair](https://github.com/hannahblair)!

## 0.4.17

### Fixes

- [#6967](https://github.com/gradio-app/gradio/pull/6967) [`5e00162`](https://github.com/gradio-app/gradio/commit/5e0016267f1d683e2daab82ee4a33d2f09513a34) - Make <Gallery /> Wasm-compatible. Thanks [@whitphx](https://github.com/whitphx)!

## 0.4.16

### Patch Changes

- Updated dependencies [[`b1b78c2`](https://github.com/gradio-app/gradio/commit/b1b78c2168e24fb65251a9b9b6cbc9382179a8ca), [`f742d0e`](https://github.com/gradio-app/gradio/commit/f742d0e861c8e25c5d77d9102c9d50f94b0d3383), [`6c863af`](https://github.com/gradio-app/gradio/commit/6c863af92fa9ceb5c638857eb22cc5ddb718d549), [`fb9c6ca`](https://github.com/gradio-app/gradio/commit/fb9c6cacd7ca4598c000f1f97d7d39a8c4463519), [`649cd4d`](https://github.com/gradio-app/gradio/commit/649cd4d68041d11fcbe31f8efa455345ac49fc74)]:
  - @gradio/image@0.6.0
  - @gradio/client@0.10.0
  - @gradio/upload@0.5.8

## 0.4.15

### Patch Changes

- Updated dependencies [[`d406855`](https://github.com/gradio-app/gradio/commit/d4068557953746662235d595ec435c42ceb24414), [`15c97c6`](https://github.com/gradio-app/gradio/commit/15c97c6d346c475141d20615b5a865e9c44bdc76)]:
  - @gradio/client@0.9.4
  - @gradio/image@0.5.4
  - @gradio/upload@0.5.7

## 0.4.14

### Patch Changes

- Updated dependencies [[`828fb9e`](https://github.com/gradio-app/gradio/commit/828fb9e6ce15b6ea08318675a2361117596a1b5d), [`73268ee`](https://github.com/gradio-app/gradio/commit/73268ee2e39f23ebdd1e927cb49b8d79c4b9a144)]:
  - @gradio/client@0.9.3
  - @gradio/statustracker@0.4.3
  - @gradio/atoms@0.4.1
  - @gradio/image@0.5.3
  - @gradio/upload@0.5.6

## 0.4.13

### Patch Changes

- Updated dependencies [[`245d58e`](https://github.com/gradio-app/gradio/commit/245d58eff788e8d44a59d37a2d9b26d0f08a62b4)]:
  - @gradio/client@0.9.2
  - @gradio/image@0.5.2
  - @gradio/upload@0.5.5

## 0.4.12

### Patch Changes

- Updated dependencies [[`5d51fbc`](https://github.com/gradio-app/gradio/commit/5d51fbce7826da840a2fd4940feb5d9ad6f1bc5a), [`34f9431`](https://github.com/gradio-app/gradio/commit/34f943101bf7dd6b8a8974a6131c1ed7c4a0dac0)]:
  - @gradio/upload@0.5.4
  - @gradio/client@0.9.1
  - @gradio/image@0.5.1

## 0.4.11

### Fixes

- [#6487](https://github.com/gradio-app/gradio/pull/6487) [`9a5811d`](https://github.com/gradio-app/gradio/commit/9a5811df9218b622af59ba243a937a9c36ba00f9) - Fix the download button of the `gr.Gallery()` component to work. Thanks [@whitphx](https://github.com/whitphx)!

## 0.4.10

### Patch Changes

- Updated dependencies [[`b639e04`](https://github.com/gradio-app/gradio/commit/b639e040741e6c0d9104271c81415d7befbd8cf3), [`206af31`](https://github.com/gradio-app/gradio/commit/206af31d7c1a31013364a44e9b40cf8df304ba50)]:
  - @gradio/image@0.4.2
  - @gradio/icons@0.3.1
  - @gradio/atoms@0.3.1
  - @gradio/statustracker@0.4.1
  - @gradio/upload@0.5.2

## 0.4.9

### Patch Changes

- Updated dependencies [[`71f1a1f99`](https://github.com/gradio-app/gradio/commit/71f1a1f9931489d465c2c1302a5c8d768a3cd23a)]:
  - @gradio/client@0.8.2
  - @gradio/image@0.4.1
  - @gradio/upload@0.5.1

## 0.4.8

### Patch Changes

- Updated dependencies [[`9caddc17b`](https://github.com/gradio-app/gradio/commit/9caddc17b1dea8da1af8ba724c6a5eab04ce0ed8)]:
  - @gradio/atoms@0.3.0
  - @gradio/icons@0.3.0
  - @gradio/image@0.4.0
  - @gradio/statustracker@0.4.0
  - @gradio/upload@0.5.0

## 0.4.7

### Patch Changes

- Updated dependencies [[`2f805a7dd`](https://github.com/gradio-app/gradio/commit/2f805a7dd3d2b64b098f659dadd5d01258290521), [`f816136a0`](https://github.com/gradio-app/gradio/commit/f816136a039fa6011be9c4fb14f573e4050a681a)]:
  - @gradio/image@0.3.6
  - @gradio/upload@0.4.2
  - @gradio/atoms@0.2.2
  - @gradio/icons@0.2.1
  - @gradio/statustracker@0.3.2

## 0.4.6

### Patch Changes

- Updated dependencies [[`324867f63`](https://github.com/gradio-app/gradio/commit/324867f63c920113d89a565892aa596cf8b1e486)]:
  - @gradio/client@0.8.1
  - @gradio/image@0.3.5
  - @gradio/upload@0.4.1

## 0.4.5

### Patch Changes

- Updated dependencies [[`6204ccac5`](https://github.com/gradio-app/gradio/commit/6204ccac5967763e0ebde550d04d12584243a120), [`4d3aad33a`](https://github.com/gradio-app/gradio/commit/4d3aad33a0b66639dbbb2928f305a79fb7789b2d), [`854b482f5`](https://github.com/gradio-app/gradio/commit/854b482f598e0dc47673846631643c079576da9c), [`f1409f95e`](https://github.com/gradio-app/gradio/commit/f1409f95ed39c5565bed6a601e41f94e30196a57)]:
  - @gradio/image@0.3.4
  - @gradio/upload@0.4.0
  - @gradio/client@0.8.0

## 0.4.4

### Patch Changes

- Updated dependencies [[`bca6c2c80`](https://github.com/gradio-app/gradio/commit/bca6c2c80f7e5062427019de45c282238388af95), [`3cdeabc68`](https://github.com/gradio-app/gradio/commit/3cdeabc6843000310e1a9e1d17190ecbf3bbc780), [`fad92c29d`](https://github.com/gradio-app/gradio/commit/fad92c29dc1f5cd84341aae417c495b33e01245f)]:
  - @gradio/client@0.7.2
  - @gradio/atoms@0.2.1
  - @gradio/upload@0.3.3
  - @gradio/image@0.3.3
  - @gradio/statustracker@0.3.1

## 0.4.3

### Fixes

- [#6288](https://github.com/gradio-app/gradio/pull/6288) [`92278729e`](https://github.com/gradio-app/gradio/commit/92278729ee008126af15ffe6be399236211b2f34) - Gallery preview fix and optionally skip download of urls in postprcess. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

## 0.4.2

### Fixes

- [#6277](https://github.com/gradio-app/gradio/pull/6277) [`5fe091367`](https://github.com/gradio-app/gradio/commit/5fe091367fbe0eecdd504aa734ca1c70b0621f52) - handle selected_index prop change for gallery. Thanks [@pngwn](https://github.com/pngwn)!

## 0.4.1

### Patch Changes

- Updated dependencies [[`2ba14b284`](https://github.com/gradio-app/gradio/commit/2ba14b284f908aa13859f4337167a157075a68eb)]:
  - @gradio/client@0.7.1
  - @gradio/image@0.3.1
  - @gradio/upload@0.3.1

## 0.4.0

### Features

- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - fix circular dependency with client + upload. Thanks [@pngwn](https://github.com/pngwn)!
- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - Clean root url. Thanks [@pngwn](https://github.com/pngwn)!
- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - Image v4. Thanks [@pngwn](https://github.com/pngwn)!
- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - Publish all components to npm. Thanks [@pngwn](https://github.com/pngwn)!
- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - Custom components. Thanks [@pngwn](https://github.com/pngwn)!

## 0.4.0-beta.9

### Features

- [#6143](https://github.com/gradio-app/gradio/pull/6143) [`e4f7b4b40`](https://github.com/gradio-app/gradio/commit/e4f7b4b409323b01aa01b39e15ce6139e29aa073) - fix circular dependency with client + upload. Thanks [@pngwn](https://github.com/pngwn)!
- [#6136](https://github.com/gradio-app/gradio/pull/6136) [`667802a6c`](https://github.com/gradio-app/gradio/commit/667802a6cdbfb2ce454a3be5a78e0990b194548a) - JS Component Documentation. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!
- [#6094](https://github.com/gradio-app/gradio/pull/6094) [`c476bd5a5`](https://github.com/gradio-app/gradio/commit/c476bd5a5b70836163b9c69bf4bfe068b17fbe13) - Image v4. Thanks [@pngwn](https://github.com/pngwn)!

## 0.4.0-beta.8

### Features

- [#6016](https://github.com/gradio-app/gradio/pull/6016) [`83e947676`](https://github.com/gradio-app/gradio/commit/83e947676d327ca2ab6ae2a2d710c78961c771a0) - Format js in v4 branch. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

### Fixes

- [#6046](https://github.com/gradio-app/gradio/pull/6046) [`dbb7de5e0`](https://github.com/gradio-app/gradio/commit/dbb7de5e02c53fee05889d696d764d212cb96c74) - fix tests. Thanks [@pngwn](https://github.com/pngwn)!

## 0.4.0-beta.7

### Patch Changes

- Updated dependencies []:
  - @gradio/image@0.3.0-beta.7

## 0.4.0-beta.6

### Features

- [#5960](https://github.com/gradio-app/gradio/pull/5960) [`319c30f3f`](https://github.com/gradio-app/gradio/commit/319c30f3fccf23bfe1da6c9b132a6a99d59652f7) - rererefactor frontend files. Thanks [@pngwn](https://github.com/pngwn)!
- [#5938](https://github.com/gradio-app/gradio/pull/5938) [`13ed8a485`](https://github.com/gradio-app/gradio/commit/13ed8a485d5e31d7d75af87fe8654b661edcca93) - V4: Use beta release versions for '@gradio' packages. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

## 0.5.1

### Patch Changes

- Updated dependencies [[`b67115e8e`](https://github.com/gradio-app/gradio/commit/b67115e8e6e489fffd5271ea830211863241ddc5), [`8d909624f`](https://github.com/gradio-app/gradio/commit/8d909624f61a49536e3c0f71cb2d9efe91216219), [`e70805d54`](https://github.com/gradio-app/gradio/commit/e70805d54cc792452545f5d8eccc1aa0212a4695)]:
  - @gradio/image@0.4.0
  - @gradio/atoms@0.2.0
  - @gradio/statustracker@0.2.3
  - @gradio/upload@0.3.3

## 0.5.0

### Features

- [#5780](https://github.com/gradio-app/gradio/pull/5780) [`ed0f9a21b`](https://github.com/gradio-app/gradio/commit/ed0f9a21b04ad6b941b63d2ce45100dbd1abd5c5) - Adds `change()` event to `gr.Gallery`. Thanks [@abidlabs](https://github.com/abidlabs)!
- [#5783](https://github.com/gradio-app/gradio/pull/5783) [`4567788bd`](https://github.com/gradio-app/gradio/commit/4567788bd1fc25df9322902ba748012e392b520a) - Adds the ability to set the `selected_index` in a `gr.Gallery`. Thanks [@abidlabs](https://github.com/abidlabs)!

### Fixes

- [#5798](https://github.com/gradio-app/gradio/pull/5798) [`a0d3cc45c`](https://github.com/gradio-app/gradio/commit/a0d3cc45c6db48dc0db423c229b8fb285623cdc4) - Fix `gr.SelectData` so that the target attribute is correctly attached, and the filedata is included in the data attribute with `gr.Gallery`. Thanks [@abidlabs](https://github.com/abidlabs)!

## 0.4.1

### Fixes

- [#5735](https://github.com/gradio-app/gradio/pull/5735) [`abb5e9df4`](https://github.com/gradio-app/gradio/commit/abb5e9df47989b2c56c2c312d74944678f9f2d4e) - Ensure images with no caption download in gallery. Thanks [@hannahblair](https://github.com/hannahblair)!
- [#5754](https://github.com/gradio-app/gradio/pull/5754) [`502054848`](https://github.com/gradio-app/gradio/commit/502054848fdbe39fc03ec42445242b4e49b7affc) - Fix Gallery `columns` and `rows` params. Thanks [@abidlabs](https://github.com/abidlabs)!

## 0.4.0

### Features

- [#5554](https://github.com/gradio-app/gradio/pull/5554) [`75ddeb390`](https://github.com/gradio-app/gradio/commit/75ddeb390d665d4484667390a97442081b49a423) - Accessibility Improvements. Thanks [@hannahblair](https://github.com/hannahblair)!

## 0.3.4

### Patch Changes

- Updated dependencies [[`e0d61b8ba`](https://github.com/gradio-app/gradio/commit/e0d61b8baa0f6293f53b9bdb1647d42f9ae2583a)]:
  - @gradio/image@0.2.4

## 0.3.3

### Fixes

- [#5528](https://github.com/gradio-app/gradio/pull/5528) [`dc86e4a7`](https://github.com/gradio-app/gradio/commit/dc86e4a7e1c40b910c74558e6f88fddf9b3292bc) - Lazy load all images. Thanks [@aliabid94](https://github.com/aliabid94)!

## 0.3.2

### Patch Changes

- Updated dependencies [[`afac0006`](https://github.com/gradio-app/gradio/commit/afac0006337ce2840cf497cd65691f2f60ee5912)]:
  - @gradio/statustracker@0.2.0
  - @gradio/image@0.2.2
  - @gradio/utils@0.1.1
  - @gradio/atoms@0.1.2
  - @gradio/upload@0.2.1

## 0.3.1

### Patch Changes

- Updated dependencies [[`abf1c57d`](https://github.com/gradio-app/gradio/commit/abf1c57d7d85de0df233ee3b38aeb38b638477db), [`79d8f9d8`](https://github.com/gradio-app/gradio/commit/79d8f9d891901683c5a1b7486efb44eab2478c96)]:
  - @gradio/icons@0.1.0
  - @gradio/utils@0.1.0
  - @gradio/upload@0.2.0
  - @gradio/atoms@0.1.1
  - @gradio/image@0.2.1
  - @gradio/statustracker@0.1.1

## 0.3.0

### Highlights

#### Improve startup performance and markdown support ([#5279](https://github.com/gradio-app/gradio/pull/5279) [`fe057300`](https://github.com/gradio-app/gradio/commit/fe057300f0672c62dab9d9b4501054ac5d45a4ec))

##### Improved markdown support

We now have better support for markdown in `gr.Markdown` and `gr.Dataframe`. Including syntax highlighting and Github Flavoured Markdown. We also have more consistent markdown behaviour and styling.

##### Various performance improvements

These improvements will be particularly beneficial to large applications.

- Rather than attaching events manually, they are now delegated, leading to a significant performance improvement and addressing a performance regression introduced in a recent version of Gradio. App startup for large applications is now around twice as fast.
- Optimised the mounting of individual components, leading to a modest performance improvement during startup (~30%).
- Corrected an issue that was causing markdown to re-render infinitely.
- Ensured that the `gr.3DModel` does re-render prematurely.

Thanks [@pngwn](https://github.com/pngwn)!

### Features

- [#5215](https://github.com/gradio-app/gradio/pull/5215) [`fbdad78a`](https://github.com/gradio-app/gradio/commit/fbdad78af4c47454cbb570f88cc14bf4479bbceb) - Lazy load interactive or static variants of a component individually, rather than loading both variants regardless. This change will improve performance for many applications. Thanks [@pngwn](https://github.com/pngwn)!
- [#5216](https://github.com/gradio-app/gradio/pull/5216) [`4b58ea6d`](https://github.com/gradio-app/gradio/commit/4b58ea6d98e7a43b3f30d8a4cb6f379bc2eca6a8) - Update i18n tokens and locale files. Thanks [@hannahblair](https://github.com/hannahblair)!

## 0.2.0

### Features

- [#5025](https://github.com/gradio-app/gradio/pull/5025) [`6693660a`](https://github.com/gradio-app/gradio/commit/6693660a790996f8f481feaf22a8c49130d52d89) - Add download button to selected images in `Gallery`. Thanks [@hannahblair](https://github.com/hannahblair)!

## 0.1.0

### Features

- [#4995](https://github.com/gradio-app/gradio/pull/4995) [`3f8c210b`](https://github.com/gradio-app/gradio/commit/3f8c210b01ef1ceaaf8ee73be4bf246b5b745bbf) - Implement left and right click in `Gallery` component and show implicit images in `Gallery` grid. Thanks [@hannahblair](https://github.com/hannahblair)!