# @gradio/uploadbutton

## 0.9.16

### Fixes

- [#12681](https://github.com/gradio-app/gradio/pull/12681) [`ba46c2d`](https://github.com/gradio-app/gradio/commit/ba46c2df1405c11e495304af8f91acfdf69d0b18) - Migrate Button to Svelte 5.  Thanks @freddyaboulton!

### Dependency updates

- @gradio/utils@0.11.1
- @gradio/button@0.6.2
- @gradio/client@2.0.2

## 0.9.15

### Dependency updates

- @gradio/utils@0.11.0
- @gradio/client@2.0.1
- @gradio/upload@0.17.3
- @gradio/button@0.6.1

## 0.9.14

### Dependency updates

- @gradio/button@0.6.0

## 0.9.13

### Dependency updates

- @gradio/utils@0.10.4

## 0.9.13

### Features

- [#11908](https://github.com/gradio-app/gradio/pull/11908) [`029034f`](https://github.com/gradio-app/gradio/commit/029034f7853ea018d110efe9b7e2ef7d1407091c) - Fix textbox updates
- [#12438](https://github.com/gradio-app/gradio/pull/12438) [`25ffc03`](https://github.com/gradio-app/gradio/commit/25ffc0398f8feb43d817c02b2ab970c16de6d797) - Svelte5 migration and bugfix

### Dependencies

- @gradio/button@0.5.14
- @gradio/client@2.0.0
- @gradio/upload@0.17.2
- @gradio/utils@0.10.3

## 0.9.13-dev.1

### Dependency updates

- @gradio/client@2.0.0-dev.2
- @gradio/button@0.5.14-dev.2
- @gradio/upload@0.17.2-dev.2

## 0.9.13-dev.1

### Dependency updates

- @gradio/upload@0.17.2-dev.1
- @gradio/utils@0.10.3-dev.0
- @gradio/button@0.5.14-dev.1

## 0.9.13-dev.0

### Dependency updates

- @gradio/client@2.0.0-dev.1

## 0.9.13-dev.0

### Dependency updates

- @gradio/upload@0.17.2-dev.0
- @gradio/client@2.0.0-dev.0
- @gradio/button@0.5.14-dev.0

## 0.9.12

### Dependency updates

- @gradio/client@1.19.1

## 0.9.12

### Dependency updates

- @gradio/upload@0.17.1

## 0.9.12

### Fixes

- [#11784](https://github.com/gradio-app/gradio/pull/11784) [`d9dd3f5`](https://github.com/gradio-app/gradio/commit/d9dd3f54b7fb34cf7118e549d39fc63937ca3489) - Add "hidden" option to component's `visible` kwarg to render but visually hide the component.  Thanks @pngwn!

### Dependency updates

- @gradio/client@1.19.0
- @gradio/upload@0.17.0
- @gradio/button@0.5.13

## 0.9.11

### Dependency updates

- @gradio/client@1.18.0
- @gradio/upload@0.16.17
- @gradio/button@0.5.12

## 0.9.11

### Dependency updates

- @gradio/upload@0.16.16

## 0.9.11

### Dependency updates

- @gradio/client@1.17.1
- @gradio/upload@0.16.15
- @gradio/button@0.5.11

## 0.9.10

### Dependency updates

- @gradio/client@1.17.0
- @gradio/upload@0.16.14
- @gradio/button@0.5.10

## 0.9.9

### Dependency updates

- @gradio/upload@0.16.13
- @gradio/client@1.16.0
- @gradio/button@0.5.9

## 0.9.8

### Dependency updates

- @gradio/upload@0.16.12
- @gradio/client@1.15.7
- @gradio/button@0.5.8

## 0.9.7

### Dependency updates

- @gradio/client@1.15.6
- @gradio/button@0.5.7
- @gradio/upload@0.16.11

## 0.9.6

### Dependency updates

- @gradio/upload@0.16.10
- @gradio/client@1.15.5
- @gradio/button@0.5.6

## 0.9.5

### Dependency updates

- @gradio/upload@0.16.9
- @gradio/client@1.15.4
- @gradio/button@0.5.5

## 0.9.4

### Dependency updates

- @gradio/client@1.15.3
- @gradio/upload@0.16.8
- @gradio/button@0.5.4

## 0.9.3

### Dependency updates

- @gradio/button@0.5.3

## 0.9.3

### Dependency updates

- @gradio/upload@0.16.7
- @gradio/client@1.15.2
- @gradio/button@0.5.3

## 0.9.2

### Dependency updates

- @gradio/button@0.5.2

## 0.9.1

### Dependency updates

- @gradio/client@1.15.1
- @gradio/button@0.5.1
- @gradio/upload@0.16.6

## 0.9.0

### Features

- [#11047](https://github.com/gradio-app/gradio/pull/11047) [`6d4b8a7`](https://github.com/gradio-app/gradio/commit/6d4b8a7f10daefc9c79aa224635da23fbaeebb76) - Implement custom i18n.  Thanks @hannahblair!

### Dependency updates

- @gradio/client@1.15.0
- @gradio/upload@0.16.5
- @gradio/button@0.5.0

## 0.8.18

### Dependency updates

- @gradio/button@0.4.18
- @gradio/upload@0.16.4

## 0.8.17

### Dependency updates

- @gradio/button@0.4.17

## 0.8.16

### Dependency updates

- @gradio/upload@0.16.3
- @gradio/button@0.4.16

## 0.8.15

### Dependency updates

- @gradio/client@1.14.2
- @gradio/utils@0.10.2
- @gradio/button@0.4.15
- @gradio/upload@0.16.2

## 0.8.14

### Dependency updates

- @gradio/button@0.4.14
- @gradio/upload@0.16.1

## 0.8.13

### Dependency updates

- @gradio/button@0.4.13
- @gradio/upload@0.16.0

## 0.8.12

### Dependency updates

- @gradio/client@1.14.1
- @gradio/upload@0.15.7
- @gradio/button@0.4.12

## 0.8.11

### Dependency updates

- @gradio/client@1.14.0
- @gradio/upload@0.15.6
- @gradio/button@0.4.11

## 0.8.10

### Dependency updates

- @gradio/upload@0.15.5
- @gradio/button@0.4.10

## 0.8.9

### Dependency updates

- @gradio/client@1.13.1
- @gradio/upload@0.15.4
- @gradio/button@0.4.9

## 0.8.8

### Dependency updates

- @gradio/upload@0.15.3
- @gradio/client@1.13.0
- @gradio/button@0.4.8

## 0.8.7

### Dependency updates

- @gradio/upload@0.15.2
- @gradio/button@0.4.7

## 0.8.6

### Dependency updates

- @gradio/utils@0.10.1
- @gradio/client@1.12.0
- @gradio/upload@0.15.1
- @gradio/button@0.4.6

## 0.8.5

### Dependency updates

- @gradio/client@1.11.0
- @gradio/upload@0.15.0
- @gradio/button@0.4.5

## 0.8.4

### Dependency updates

- @gradio/upload@0.14.8
- @gradio/button@0.4.4

## 0.8.3

### Dependency updates

- @gradio/upload@0.14.7
- @gradio/button@0.4.3

## 0.8.2

### Dependency updates

- @gradio/upload@0.14.6
- @gradio/button@0.4.2

## 0.8.1

### Dependency updates

- @gradio/client@1.10.0
- @gradio/upload@0.14.5
- @gradio/button@0.4.1

## 0.8.0

### Features

- [#10191](https://github.com/gradio-app/gradio/pull/10191) [`5ce2832`](https://github.com/gradio-app/gradio/commit/5ce28324971e974ae24dc9a229b2160793140fb2) - Support saving chat history in `gr.ChatInterface`.  Thanks @abidlabs!

### Dependency updates

- @gradio/utils@0.10.0
- @gradio/upload@0.14.4
- @gradio/client@1.9.0
- @gradio/button@0.4.0

## 0.7.9

### Dependency updates

- @gradio/upload@0.14.3
- @gradio/button@0.3.9

## 0.7.8

### Dependency updates

- @gradio/utils@0.9.0
- @gradio/button@0.3.8
- @gradio/upload@0.14.2

## 0.7.7

### Dependency updates

- @gradio/client@1.8.0
- @gradio/utils@0.8.0
- @gradio/button@0.3.7
- @gradio/upload@0.14.1

## 0.7.6

### Dependency updates

- @gradio/button@0.3.6
- @gradio/upload@0.14.0

## 0.7.5

### Dependency updates

- @gradio/client@1.7.1
- @gradio/upload@0.13.5
- @gradio/button@0.3.5

## 0.7.4

### Dependency updates

- @gradio/button@0.3.4
- @gradio/upload@0.13.4

## 0.7.3

### Dependency updates

- @gradio/upload@0.13.3
- @gradio/button@0.3.3

## 0.7.2

### Dependency updates

- @gradio/client@1.7.0
- @gradio/upload@0.13.2
- @gradio/button@0.3.2

## 0.7.1

### Dependency updates

- @gradio/upload@0.13.1
- @gradio/button@0.3.1

## 0.7.0

### Features

- [#8843](https://github.com/gradio-app/gradio/pull/8843) [`6f95286`](https://github.com/gradio-app/gradio/commit/6f95286337459efbccb95c9cfac63355669df9ee) - Ssr part 2

### Dependencies

- @gradio/button@0.3.0
- @gradio/client@1.6.0
- @gradio/upload@0.13.0
- @gradio/utils@0.7.0

## 0.7.0-beta.7

### Dependency updates

- @gradio/upload@0.13.0-beta.7
- @gradio/button@0.3.0-beta.7

## 0.7.0-beta.6

### Dependency updates

- @gradio/client@1.6.0-beta.4
- @gradio/upload@0.13.0-beta.6
- @gradio/button@0.3.0-beta.6

## 0.7.0-beta.5

### Dependency updates

- @gradio/upload@0.13.0-beta.5
- @gradio/button@0.3.0-beta.5

## 0.7.0-beta.4

### Dependency updates

- @gradio/upload@0.13.0-beta.4
- @gradio/button@0.3.0-beta.4

## 0.7.0-beta.3

### Dependency updates

- @gradio/upload@0.13.0-beta.3
- @gradio/client@1.6.0-beta.3
- @gradio/button@0.3.0-beta.3

## 0.7.0-beta.2

### Features

- [#9339](https://github.com/gradio-app/gradio/pull/9339) [`4c8c6f2`](https://github.com/gradio-app/gradio/commit/4c8c6f2fe603081941c5fdc43f48a0632b9f31ad) - Ssr part 2.  Thanks @pngwn!

### Dependency updates

- @gradio/upload@0.13.0-beta.2
- @gradio/client@1.6.0-beta.2
- @gradio/utils@0.7.0-beta.2
- @gradio/button@0.3.0-beta.2

## 0.6.19-beta.1

### Dependency updates

- @gradio/utils@0.7.0-beta.1
- @gradio/client@1.6.0-beta.1
- @gradio/upload@0.12.4-beta.1
- @gradio/button@0.3.0-beta.1

## 0.6.19

### Fixes

- [#9163](https://github.com/gradio-app/gradio/pull/9163) [`2b6cbf2`](https://github.com/gradio-app/gradio/commit/2b6cbf25908e42cf027324e54ef2cc0baad11a91) - fix exports and generate types.  Thanks @pngwn!

### Dependency updates

- @gradio/utils@0.6.1
- @gradio/client@1.5.2
- @gradio/upload@0.12.4
- @gradio/button@0.2.51

## 0.6.18

### Features

- [#9118](https://github.com/gradio-app/gradio/pull/9118) [`e1c404d`](https://github.com/gradio-app/gradio/commit/e1c404da1143fb52b659d03e028bdba1badf443d) - setup npm-previews of all packages.  Thanks @pngwn!

### Dependency updates

- @gradio/utils@0.6.0
- @gradio/upload@0.12.3
- @gradio/button@0.2.50
- @gradio/client@1.5.1

## 0.6.17

### Dependency updates

- @gradio/client@1.5.0
- @gradio/upload@0.12.2
- @gradio/button@0.2.49

## 0.6.16

### Dependency updates

- @gradio/utils@0.5.2
- @gradio/upload@0.12.1
- @gradio/button@0.2.48

## 0.6.15

### Dependency updates

- @gradio/client@1.4.0
- @gradio/upload@0.12.0
- @gradio/button@0.2.47

## 0.6.14

### Dependency updates

- @gradio/utils@0.5.1
- @gradio/client@1.3.0
- @gradio/upload@0.11.5
- @gradio/button@0.2.46

## 0.6.13

### Dependency updates

- @gradio/upload@0.11.4
- @gradio/client@1.2.1
- @gradio/button@0.2.45

## 0.6.12

### Dependency updates

- @gradio/utils@0.5.0
- @gradio/client@1.2.0
- @gradio/button@0.2.44
- @gradio/upload@0.11.3

## 0.6.11

### Dependency updates

- @gradio/client@1.1.1
- @gradio/upload@0.11.2
- @gradio/button@0.2.43

## 0.6.10

### Dependency updates

- @gradio/upload@0.11.1
- @gradio/client@1.1.0
- @gradio/button@0.2.42

## 0.6.9

### Dependency updates

- @gradio/client@1.0.0
- @gradio/upload@0.11.0
- @gradio/button@0.2.41

## 0.6.8

### Dependency updates

- @gradio/upload@0.10.7
- @gradio/client@0.20.1
- @gradio/button@0.2.40

## 0.6.7

### Dependency updates

- @gradio/client@0.20.0
- @gradio/button@0.2.39
- @gradio/upload@0.10.6

## 0.6.6

### Dependency updates

- @gradio/utils@0.4.2
- @gradio/upload@0.10.5
- @gradio/client@0.19.4
- @gradio/button@0.2.38

## 0.6.5

### Dependency updates

- @gradio/client@0.19.3
- @gradio/button@0.2.37
- @gradio/upload@0.10.4

## 0.6.4

### Dependency updates

- @gradio/upload@0.10.3
- @gradio/client@0.19.2
- @gradio/button@0.2.36

## 0.6.3

### Dependency updates

- @gradio/client@0.19.1
- @gradio/button@0.2.35
- @gradio/upload@0.10.2

## 0.6.2

### Dependency updates

- @gradio/client@0.19.0
- @gradio/upload@0.10.1
- @gradio/button@0.2.34

## 0.6.1

### Fixes

- [#8179](https://github.com/gradio-app/gradio/pull/8179) [`6a218b4`](https://github.com/gradio-app/gradio/commit/6a218b4148095aaa0c58d8c20973ba01c8764fc2) - rework upload to be a class method + pass client into each component.  Thanks @pngwn!

### Dependency updates

- @gradio/client@0.18.0
- @gradio/upload@0.10.0
- @gradio/utils@0.4.1
- @gradio/button@0.2.33

## 0.6.0

### Highlights

#### Setting File Upload Limits ([#7909](https://github.com/gradio-app/gradio/pull/7909) [`2afca65`](https://github.com/gradio-app/gradio/commit/2afca6541912b37dc84f447c7ad4af21607d7c72))

We have added a `max_file_size` size parameter to `launch()` that limits to size of files uploaded to the server. This limit applies to each individual file. This parameter can be specified as a string or an integer (corresponding to the size in bytes).

The following code snippet sets a max file size of 5 megabytes.

```python
import gradio as gr

demo = gr.Interface(lambda x: x, "image", "image")

demo.launch(max_file_size="5mb")
# or
demo.launch(max_file_size=5 * gr.FileSize.MB)
```

![max_file_size_upload](https://github.com/gradio-app/gradio/assets/41651716/7547330c-a082-4901-a291-3f150a197e45)


#### Error states can now be cleared

When a component encounters an error, the error state shown in the UI can now be cleared by clicking on the `x` icon in the top right of the component. This applies to all types of errors, whether it's raised in the UI or the server.

![error_modal_calculator](https://github.com/gradio-app/gradio/assets/41651716/16cb071c-accd-45a6-9c18-0dea27d4bd98)

 Thanks @freddyaboulton!

### Fixes

- [#8066](https://github.com/gradio-app/gradio/pull/8066) [`624f9b9`](https://github.com/gradio-app/gradio/commit/624f9b9477f74a581a6c14119234f9efdfcda398) - make gradio dev tools a local dependency rather than bundling.  Thanks @pngwn!

### Dependency updates

- @gradio/client@0.17.0
- @gradio/button@0.2.32
- @gradio/upload@0.9.0
- @gradio/utils@0.4.0

## 0.5.8

### Dependency updates

- @gradio/utils@0.3.2
- @gradio/client@0.16.0
- @gradio/upload@0.8.5
- @gradio/button@0.2.31

## 0.5.7

### Dependency updates

- @gradio/utils@0.3.1
- @gradio/upload@0.8.4
- @gradio/client@0.15.1
- @gradio/button@0.2.30

## 0.5.6

### Dependency updates

- @gradio/button@0.2.29
- @gradio/upload@0.8.3
- @gradio/client@0.15.0

## 0.5.5

### Dependency updates

- @gradio/button@0.2.28
- @gradio/upload@0.8.2

## 0.5.4

### Dependency updates

- @gradio/upload@0.8.1
- @gradio/button@0.2.27

## 0.5.3

### Dependency updates

- @gradio/client@0.14.0
- @gradio/upload@0.8.0
- @gradio/button@0.2.26

## 0.5.2

### Dependency updates

- @gradio/button@0.2.25
- @gradio/upload@0.7.7
- @gradio/client@0.13.0

## 0.5.1

### Patch Changes

- Updated dependencies [[`8181695`](https://github.com/gradio-app/gradio/commit/8181695e70187e8bc2bf7518697098c8d1b9843d)]:
  - @gradio/upload@0.7.6
  - @gradio/button@0.2.24

## 0.5.0

### Features

- [#7528](https://github.com/gradio-app/gradio/pull/7528) [`eda33b3`](https://github.com/gradio-app/gradio/commit/eda33b3763897a542acf298e523fa493dc655aee) - Refactors `get_fetchable_url_or_file()` to remove it from the frontend. Thanks [@abidlabs](https://github.com/abidlabs)!
- [#7518](https://github.com/gradio-app/gradio/pull/7518) [`bd2c695`](https://github.com/gradio-app/gradio/commit/bd2c69532801f9a0626cd1192de158bde6068b9a) - Adds a `gr.DownloadButton` component. Thanks [@abidlabs](https://github.com/abidlabs)!

## 0.4.7

### Patch Changes

- Updated dependencies []:
  - @gradio/upload@0.7.4
  - @gradio/button@0.2.22

## 0.4.6

### Patch Changes

- Updated dependencies [[`065c5b1`](https://github.com/gradio-app/gradio/commit/065c5b163c4badb9d9cbd06d627fb4ba086003e7), [`32b317f`](https://github.com/gradio-app/gradio/commit/32b317f24e3d43f26684bb9f3964f31efd0ea556)]:
  - @gradio/utils@0.3.0
  - @gradio/client@0.12.1
  - @gradio/button@0.2.21
  - @gradio/upload@0.7.3

## 0.4.5

### Patch Changes

- Updated dependencies [[`49d9c48`](https://github.com/gradio-app/gradio/commit/49d9c48537aa706bf72628e3640389470138bdc6)]:
  - @gradio/client@0.12.0
  - @gradio/button@0.2.20
  - @gradio/upload@0.7.2

## 0.4.4

### Patch Changes

- Updated dependencies [[`572e360`](https://github.com/gradio-app/gradio/commit/572e360fff4a03c335b86e1a7517a44cb6af2bcd), [`68a54a7`](https://github.com/gradio-app/gradio/commit/68a54a7a310d8d7072fdae930bf1cfdf12c45a7f), [`fdd1521`](https://github.com/gradio-app/gradio/commit/fdd15213c24b9cbc58bbc1b6beb4af7c18f48557), [`c3e61e4`](https://github.com/gradio-app/gradio/commit/c3e61e4f70696a71aede67b65d28447eb67daf16)]:
  - @gradio/upload@0.7.1
  - @gradio/client@0.11.0
  - @gradio/utils@0.2.2
  - @gradio/button@0.2.19

## 0.4.3

### Fixes

- [#7126](https://github.com/gradio-app/gradio/pull/7126) [`5727b92`](https://github.com/gradio-app/gradio/commit/5727b92abc8a00a675bfc0a921b38de771af947b) - Allow buttons to take null value. Thanks [@abidlabs](https://github.com/abidlabs)!

## 0.4.2

### Patch Changes

- Updated dependencies [[`3c3cf86`](https://github.com/gradio-app/gradio/commit/3c3cf8618a8cad1ef66a7f96664923d2c9f5e0e2), [`3f139c7`](https://github.com/gradio-app/gradio/commit/3f139c7c995f749562bb007d2a567bb167669de9)]:
  - @gradio/client@0.10.1
  - @gradio/upload@0.6.1
  - @gradio/button@0.2.17

## 0.4.1

### Patch Changes

- Updated dependencies [[`793bf8f`](https://github.com/gradio-app/gradio/commit/793bf8f7b1943f265c5d016c1a0c682ee549232a), [`5d00dd3`](https://github.com/gradio-app/gradio/commit/5d00dd37ca14bbfef2ceac550b29dbe05ba8cab0)]:
  - @gradio/upload@0.6.0
  - @gradio/button@0.2.16

## 0.4.0

### Features

- [#6897](https://github.com/gradio-app/gradio/pull/6897) [`fb9c6ca`](https://github.com/gradio-app/gradio/commit/fb9c6cacd7ca4598c000f1f97d7d39a8c4463519) - Lite: Chatbot. Thanks [@whitphx](https://github.com/whitphx)!

## 0.3.5

### Patch Changes

- Updated dependencies [[`d406855`](https://github.com/gradio-app/gradio/commit/d4068557953746662235d595ec435c42ceb24414)]:
  - @gradio/client@0.9.4
  - @gradio/button@0.2.14
  - @gradio/upload@0.5.7

## 0.3.4

### Patch Changes

- Updated dependencies [[`828fb9e`](https://github.com/gradio-app/gradio/commit/828fb9e6ce15b6ea08318675a2361117596a1b5d), [`73268ee`](https://github.com/gradio-app/gradio/commit/73268ee2e39f23ebdd1e927cb49b8d79c4b9a144)]:
  - @gradio/client@0.9.3
  - @gradio/upload@0.5.6
  - @gradio/button@0.2.13

## 0.3.3

### Patch Changes

- Updated dependencies [[`245d58e`](https://github.com/gradio-app/gradio/commit/245d58eff788e8d44a59d37a2d9b26d0f08a62b4)]:
  - @gradio/client@0.9.2
  - @gradio/button@0.2.12
  - @gradio/upload@0.5.5

## 0.3.2

### Patch Changes

- Updated dependencies [[`5d51fbc`](https://github.com/gradio-app/gradio/commit/5d51fbce7826da840a2fd4940feb5d9ad6f1bc5a), [`34f9431`](https://github.com/gradio-app/gradio/commit/34f943101bf7dd6b8a8974a6131c1ed7c4a0dac0)]:
  - @gradio/upload@0.5.4
  - @gradio/client@0.9.1
  - @gradio/button@0.2.11

## 0.3.1

### Patch Changes

- Updated dependencies [[`6a9151d`](https://github.com/gradio-app/gradio/commit/6a9151d5c9432c724098da7d88a539aaaf5ffe88), [`d76bcaa`](https://github.com/gradio-app/gradio/commit/d76bcaaaf0734aaf49a680f94ea9d4d22a602e70), [`67ddd40`](https://github.com/gradio-app/gradio/commit/67ddd40b4b70d3a37cb1637c33620f8d197dbee0)]:
  - @gradio/upload@0.5.3
  - @gradio/client@0.9.0
  - @gradio/button@0.2.10

## 0.3.0

### Features

- [#6584](https://github.com/gradio-app/gradio/pull/6584) [`9bcb1da`](https://github.com/gradio-app/gradio/commit/9bcb1da189a9738d023ef6daad8c6c827e3f6371) - Feat: make UploadButton accept icon. Thanks [@Justin-Xiang](https://github.com/Justin-Xiang)!

## 0.2.2

### Patch Changes

- Updated dependencies [[`71f1a1f99`](https://github.com/gradio-app/gradio/commit/71f1a1f9931489d465c2c1302a5c8d768a3cd23a)]:
  - @gradio/client@0.8.2
  - @gradio/button@0.2.8
  - @gradio/upload@0.5.1

## 0.2.1

### Patch Changes

- Updated dependencies [[`9caddc17b`](https://github.com/gradio-app/gradio/commit/9caddc17b1dea8da1af8ba724c6a5eab04ce0ed8)]:
  - @gradio/upload@0.5.0
  - @gradio/button@0.2.7

## 0.2.0

### Features

- [#6461](https://github.com/gradio-app/gradio/pull/6461) [`6b53330a5`](https://github.com/gradio-app/gradio/commit/6b53330a5be53579d9128aea4858713082ce302d) - UploadButton tests. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

## 0.1.5

### Patch Changes

- Updated dependencies [[`324867f63`](https://github.com/gradio-app/gradio/commit/324867f63c920113d89a565892aa596cf8b1e486)]:
  - @gradio/client@0.8.1
  - @gradio/button@0.2.5
  - @gradio/upload@0.4.1

## 0.1.4

### Patch Changes

- Updated dependencies [[`854b482f5`](https://github.com/gradio-app/gradio/commit/854b482f598e0dc47673846631643c079576da9c), [`f1409f95e`](https://github.com/gradio-app/gradio/commit/f1409f95ed39c5565bed6a601e41f94e30196a57)]:
  - @gradio/upload@0.4.0
  - @gradio/client@0.8.0
  - @gradio/button@0.2.4

## 0.1.3

### Patch Changes

- Updated dependencies [[`bca6c2c80`](https://github.com/gradio-app/gradio/commit/bca6c2c80f7e5062427019de45c282238388af95), [`3cdeabc68`](https://github.com/gradio-app/gradio/commit/3cdeabc6843000310e1a9e1d17190ecbf3bbc780)]:
  - @gradio/client@0.7.2
  - @gradio/upload@0.3.3
  - @gradio/button@0.2.3

## 0.1.2

### Patch Changes

- Updated dependencies [[`aaa55ce85`](https://github.com/gradio-app/gradio/commit/aaa55ce85e12f95aba9299445e9c5e59824da18e)]:
  - @gradio/upload@0.3.2
  - @gradio/button@0.2.2

## 0.1.1

### Features

- [#6181](https://github.com/gradio-app/gradio/pull/6181) [`62ec2075c`](https://github.com/gradio-app/gradio/commit/62ec2075ccad8025a7721a08d0f29eb5a4f87fad) - modify preprocess to use pydantic models. Thanks [@abidlabs](https://github.com/abidlabs)!

## 0.1.0

### Features

- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - fix circular dependency with client + upload. Thanks [@pngwn](https://github.com/pngwn)!
- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - Image v4. Thanks [@pngwn](https://github.com/pngwn)!
- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - Publish all components to npm. Thanks [@pngwn](https://github.com/pngwn)!
- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - Custom components. Thanks [@pngwn](https://github.com/pngwn)!

## 0.1.0-beta.7

### Features

- [#6143](https://github.com/gradio-app/gradio/pull/6143) [`e4f7b4b40`](https://github.com/gradio-app/gradio/commit/e4f7b4b409323b01aa01b39e15ce6139e29aa073) - fix circular dependency with client + upload. Thanks [@pngwn](https://github.com/pngwn)!
- [#6136](https://github.com/gradio-app/gradio/pull/6136) [`667802a6c`](https://github.com/gradio-app/gradio/commit/667802a6cdbfb2ce454a3be5a78e0990b194548a) - JS Component Documentation. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!
- [#6094](https://github.com/gradio-app/gradio/pull/6094) [`c476bd5a5`](https://github.com/gradio-app/gradio/commit/c476bd5a5b70836163b9c69bf4bfe068b17fbe13) - Image v4. Thanks [@pngwn](https://github.com/pngwn)!
- [#6149](https://github.com/gradio-app/gradio/pull/6149) [`90318b1dd`](https://github.com/gradio-app/gradio/commit/90318b1dd118ae08a695a50e7c556226234ab6dc) - swap `mode` on the frontned to `interactive` to match the backend. Thanks [@pngwn](https://github.com/pngwn)!

## 0.1.0-beta.6

### Features

- [#6016](https://github.com/gradio-app/gradio/pull/6016) [`83e947676`](https://github.com/gradio-app/gradio/commit/83e947676d327ca2ab6ae2a2d710c78961c771a0) - Format js in v4 branch. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!
- [#6044](https://github.com/gradio-app/gradio/pull/6044) [`9053c95a1`](https://github.com/gradio-app/gradio/commit/9053c95a10de12aef572018ee37c71106d2da675) - Simplify File Component. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

## 0.1.0-beta.5

### Features

- [#5960](https://github.com/gradio-app/gradio/pull/5960) [`319c30f3f`](https://github.com/gradio-app/gradio/commit/319c30f3fccf23bfe1da6c9b132a6a99d59652f7) - rererefactor frontend files. Thanks [@pngwn](https://github.com/pngwn)!
- [#5938](https://github.com/gradio-app/gradio/pull/5938) [`13ed8a485`](https://github.com/gradio-app/gradio/commit/13ed8a485d5e31d7d75af87fe8654b661edcca93) - V4: Use beta release versions for '@gradio' packages. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

## 0.0.12

### Patch Changes

- Updated dependencies [[`4e62b8493`](https://github.com/gradio-app/gradio/commit/4e62b8493dfce50bafafe49f1a5deb929d822103)]:
  - @gradio/client@0.5.2
  - @gradio/upload@0.3.3
  - @gradio/button@0.2.3

## 0.0.11

### Patch Changes

- Updated dependencies [[`796145e2c`](https://github.com/gradio-app/gradio/commit/796145e2c48c4087bec17f8ec0be4ceee47170cb)]:
  - @gradio/client@0.5.1

## 0.0.10

### Patch Changes

- Updated dependencies [[`e4a307ed6`](https://github.com/gradio-app/gradio/commit/e4a307ed6cde3bbdf4ff2f17655739addeec941e), [`caeee8bf7`](https://github.com/gradio-app/gradio/commit/caeee8bf7821fd5fe2f936ed82483bed00f613ec), [`c0fef4454`](https://github.com/gradio-app/gradio/commit/c0fef44541bfa61568bdcfcdfc7d7d79869ab1df)]:
  - @gradio/client@0.5.0
  - @gradio/utils@0.1.2
  - @gradio/button@0.2.2
  - @gradio/upload@0.3.2

## 0.0.9

### Patch Changes

- Updated dependencies [[`6e56a0d9b`](https://github.com/gradio-app/gradio/commit/6e56a0d9b0c863e76c69e1183d9d40196922b4cd)]:
  - @gradio/client@0.4.2

## 0.0.8

### Patch Changes

- Updated dependencies []:
  - @gradio/upload@0.3.1
  - @gradio/button@0.2.1

## 0.0.7

### Patch Changes

- Updated dependencies [[`78e7cf516`](https://github.com/gradio-app/gradio/commit/78e7cf5163e8d205e8999428fce4c02dbdece25f)]:
  - @gradio/client@0.4.1

## 0.0.6

### Patch Changes

- Updated dependencies [[`c57f1b75e`](https://github.com/gradio-app/gradio/commit/c57f1b75e272c76b0af4d6bd0c7f44743ff34f26), [`40de3d217`](https://github.com/gradio-app/gradio/commit/40de3d2178b61ebe424b6f6228f94c0c6f679bea), [`ea0e00b20`](https://github.com/gradio-app/gradio/commit/ea0e00b207b4b90a10e9d054c4202d4e705a29ba), [`75ddeb390`](https://github.com/gradio-app/gradio/commit/75ddeb390d665d4484667390a97442081b49a423)]:
  - @gradio/client@0.4.0
  - @gradio/button@0.2.0
  - @gradio/upload@0.3.0

## 0.0.5

### Patch Changes

- Updated dependencies [[`26fef8c7`](https://github.com/gradio-app/gradio/commit/26fef8c7f85a006c7e25cdbed1792df19c512d02)]:
  - @gradio/client@0.3.1
  - @gradio/utils@0.1.1
  - @gradio/button@0.1.3
  - @gradio/upload@0.2.1

## 0.0.4

### Patch Changes

- Updated dependencies [[`119c8343`](https://github.com/gradio-app/gradio/commit/119c834331bfae60d4742c8f20e9cdecdd67e8c2), [`abf1c57d`](https://github.com/gradio-app/gradio/commit/abf1c57d7d85de0df233ee3b38aeb38b638477db), [`79d8f9d8`](https://github.com/gradio-app/gradio/commit/79d8f9d891901683c5a1b7486efb44eab2478c96)]:
  - @gradio/client@0.3.0
  - @gradio/utils@0.1.0
  - @gradio/upload@0.2.0
  - @gradio/button@0.1.2

## 0.0.3

### Highlights

#### Improve startup performance and markdown support ([#5279](https://github.com/gradio-app/gradio/pull/5279) [`fe057300`](https://github.com/gradio-app/gradio/commit/fe057300f0672c62dab9d9b4501054ac5d45a4ec))

##### Improved markdown support

We now have better support for markdown in `gr.Markdown` and `gr.Dataframe`. Including syntax highlighting and Github Flavoured Markdown. We also have more consistent markdown behaviour and styling.

##### Various performance improvements

These improvements will be particularly beneficial to large applications.

- Rather than attaching events manually, they are now delegated, leading to a significant performance improvement and addressing a performance regression introduced in a recent version of Gradio. App startup for large applications is now around twice as fast.
- Optimised the mounting of individual components, leading to a modest performance improvement during startup (~30%).
- Corrected an issue that was causing markdown to re-render infinitely.
- Ensured that the `gr.3DModel` does re-render prematurely.

Thanks [@pngwn](https://github.com/pngwn)!

## 0.0.2

### Patch Changes

- Updated dependencies [[`61129052`](https://github.com/gradio-app/gradio/commit/61129052ed1391a75c825c891d57fa0ad6c09fc8), [`667875b2`](https://github.com/gradio-app/gradio/commit/667875b2441753e74d25bd9d3c8adedd8ede11cd), [`67265a58`](https://github.com/gradio-app/gradio/commit/67265a58027ef1f9e4c0eb849a532f72eaebde48), [`8b4eb8ca`](https://github.com/gradio-app/gradio/commit/8b4eb8cac9ea07bde31b44e2006ca2b7b5f4de36), [`37caa2e0`](https://github.com/gradio-app/gradio/commit/37caa2e0fe95d6cab8beb174580fb557904f137f)]:
  - @gradio/client@0.2.0
  - @gradio/upload@0.0.3
  - @gradio/button@0.1.0