# @gradio/video

## 0.20.0

### Features

- [#12680](https://github.com/gradio-app/gradio/pull/12680) [`c99a50b`](https://github.com/gradio-app/gradio/commit/c99a50b9434bf66282a5308d442beeb97f6cf6bb) - Add .input() to Video.  Thanks @hysts!

### Dependency updates

- @gradio/utils@0.11.1
- @gradio/client@2.0.2

## 0.19.0

### Features

- [#12539](https://github.com/gradio-app/gradio/pull/12539) [`f1d83fa`](https://github.com/gradio-app/gradio/commit/f1d83fac3d6e4bad60cf896a026fa2d572f26073) - Add ability to add custom buttons to components.  Thanks @abidlabs!

### Dependency updates

- @gradio/atoms@0.20.0
- @gradio/utils@0.11.0
- @gradio/client@2.0.1
- @gradio/statustracker@0.12.1
- @gradio/upload@0.17.3
- @gradio/image@0.25.0

## 0.18.0

### Features

- [#12504](https://github.com/gradio-app/gradio/pull/12504) [`4476400`](https://github.com/gradio-app/gradio/commit/44764009dfebecf894298efe80366e42578ea65d) - Add `playback_position` to gr.Audio and gr.Video, which can be updated and read.  Thanks @aliabid94!

## 0.17.0

### Dependency updates

- @gradio/utils@0.10.4

## 0.17.0

### Features

- [#11908](https://github.com/gradio-app/gradio/pull/11908) [`029034f`](https://github.com/gradio-app/gradio/commit/029034f7853ea018d110efe9b7e2ef7d1407091c) - Clear Error statuses
- [#11908](https://github.com/gradio-app/gradio/pull/11908) [`029034f`](https://github.com/gradio-app/gradio/commit/029034f7853ea018d110efe9b7e2ef7d1407091c) - Video subtitles
- [#12438](https://github.com/gradio-app/gradio/pull/12438) [`25ffc03`](https://github.com/gradio-app/gradio/commit/25ffc0398f8feb43d817c02b2ab970c16de6d797) - Svelte5 migration and bugfix

### Dependencies

- @gradio/atoms@0.19.0
- @gradio/client@2.0.0
- @gradio/icons@0.15.0
- @gradio/image@0.24.0
- @gradio/statustracker@0.12.0
- @gradio/upload@0.17.2
- @gradio/utils@0.10.3

## 0.17.0-dev.2

### Dependency updates

- @gradio/atoms@0.19.0-dev.1
- @gradio/client@2.0.0-dev.2
- @gradio/statustracker@0.12.0-dev.1
- @gradio/upload@0.17.2-dev.2
- @gradio/image@0.24.0-dev.2

## 0.17.0-dev.1

### Dependency updates

- @gradio/atoms@0.18.2-dev.0
- @gradio/upload@0.17.2-dev.1
- @gradio/utils@0.10.3-dev.0
- @gradio/image@0.23.2-dev.1
- @gradio/statustracker@0.12.0-dev.0
- @gradio/icons@0.15.0-dev.0

## 0.17.0-dev.0

### Dependency updates

- @gradio/client@2.0.0-dev.1

## 0.17.0-dev.0

### Features

- [#12041](https://github.com/gradio-app/gradio/pull/12041) [`90e8a2c`](https://github.com/gradio-app/gradio/commit/90e8a2c23774e1d2a7401bccf4bdc86f70531de5) - Video subtitles.  Thanks @dawoodkhan82!

### Dependency updates

- @gradio/upload@0.17.2-dev.0
- @gradio/client@2.0.0-dev.0
- @gradio/image@0.23.2-dev.0

## 0.16.0

### Dependency updates

- @gradio/client@1.19.1

## 0.16.0

### Dependency updates

- @gradio/image@0.23.1
- @gradio/upload@0.17.1
- @gradio/atoms@0.18.1

## 0.16.0

### Features

- [#11858](https://github.com/gradio-app/gradio/pull/11858) [`3f8ea13`](https://github.com/gradio-app/gradio/commit/3f8ea13a8ca92abf0ad34392e403a449fda3c6c2) - remove lite.  Thanks @pngwn!

### Fixes

- [#11784](https://github.com/gradio-app/gradio/pull/11784) [`d9dd3f5`](https://github.com/gradio-app/gradio/commit/d9dd3f54b7fb34cf7118e549d39fc63937ca3489) - Add "hidden" option to component's `visible` kwarg to render but visually hide the component.  Thanks @pngwn!

### Dependency updates

- @gradio/statustracker@0.11.1
- @gradio/atoms@0.18.0
- @gradio/client@1.19.0
- @gradio/upload@0.17.0
- @gradio/image@0.23.0

## 0.15.1

### Dependency updates

- @gradio/client@1.18.0
- @gradio/icons@0.14.0
- @gradio/atoms@0.17.0
- @gradio/statustracker@0.11.0
- @gradio/upload@0.16.17
- @gradio/image@0.22.18

## 0.15.0

### Dependency updates

- @gradio/statustracker@0.10.18

## 0.15.0

### Dependency updates

- @gradio/icons@0.13.1
- @gradio/upload@0.16.16

## 0.15.0

### Features

- [#11721](https://github.com/gradio-app/gradio/pull/11721) [`58d9d9e`](https://github.com/gradio-app/gradio/commit/58d9d9e98194dada5267ac1599063cf21723cbde) - Remove dupe maximise/maximize icon.  Thanks @hannahblair!

### Dependency updates

- @gradio/statustracker@0.10.17
- @gradio/atoms@0.16.5
- @gradio/client@1.17.1
- @gradio/icons@0.13.0
- @gradio/upload@0.16.15
- @gradio/image@0.22.17

## 0.14.24

### Dependency updates

- @gradio/statustracker@0.10.16
- @gradio/atoms@0.16.4
- @gradio/client@1.17.0
- @gradio/upload@0.16.14
- @gradio/image@0.22.16

## 0.14.23

### Dependency updates

- @gradio/upload@0.16.13
- @gradio/client@1.16.0
- @gradio/image@0.22.15

## 0.14.22

### Dependency updates

- @gradio/upload@0.16.12
- @gradio/client@1.15.7
- @gradio/image@0.22.14

## 0.14.21

### Dependency updates

- @gradio/client@1.15.6
- @gradio/statustracker@0.10.15
- @gradio/upload@0.16.11
- @gradio/image@0.22.13

## 0.14.20

### Dependency updates

- @gradio/atoms@0.16.3
- @gradio/statustracker@0.10.14
- @gradio/upload@0.16.10
- @gradio/client@1.15.5
- @gradio/image@0.22.12

## 0.14.19

### Dependency updates

- @gradio/upload@0.16.9
- @gradio/client@1.15.4
- @gradio/image@0.22.11

## 0.14.18

### Dependency updates

- @gradio/statustracker@0.10.13
- @gradio/atoms@0.16.2
- @gradio/client@1.15.3
- @gradio/upload@0.16.8
- @gradio/image@0.22.10

## 0.14.17

### Dependency updates

- @gradio/statustracker@0.10.12

## 0.14.17

### Dependency updates

- @gradio/upload@0.16.7
- @gradio/client@1.15.2
- @gradio/image@0.22.9

## 0.14.16

### Dependency updates

- @gradio/statustracker@0.10.12
- @gradio/image@0.22.8

## 0.14.15

### Fixes

- [#11272](https://github.com/gradio-app/gradio/pull/11272) [`8177b01`](https://github.com/gradio-app/gradio/commit/8177b014e5539aa1011a74856d065dbb17fa0326) - Fix bug where streaming one chunk of audio or video would not play.  Thanks @freddyaboulton!

### Dependency updates

- @gradio/statustracker@0.10.12
- @gradio/client@1.15.1
- @gradio/upload@0.16.6
- @gradio/image@0.22.7

## 0.14.14

### Fixes

- [#11117](https://github.com/gradio-app/gradio/pull/11117) [`9b976b7`](https://github.com/gradio-app/gradio/commit/9b976b750a61368f369bcefaacda6d4fb0975c5f) - Raise UI error if video not playable in the browser.  Thanks @freddyaboulton!

### Dependency updates

- @gradio/statustracker@0.10.11
- @gradio/atoms@0.16.1
- @gradio/client@1.15.0
- @gradio/upload@0.16.5
- @gradio/image@0.22.6

## 0.14.13

### Dependency updates

- @gradio/upload@0.16.4
- @gradio/image@0.22.5

## 0.14.12

### Dependency updates

- @gradio/image@0.22.4

## 0.14.11

### Dependency updates

- @gradio/statustracker@0.10.10
- @gradio/image@0.22.3
- @gradio/upload@0.16.3
- @gradio/atoms@0.16.0

## 0.14.10

### Dependency updates

- @gradio/statustracker@0.10.9
- @gradio/atoms@0.15.2
- @gradio/client@1.14.2
- @gradio/utils@0.10.2
- @gradio/upload@0.16.2
- @gradio/image@0.22.2

## 0.14.9

### Fixes

- [#10979](https://github.com/gradio-app/gradio/pull/10979) [`975feee`](https://github.com/gradio-app/gradio/commit/975feee3925e5b65e52ae00da5c5066d8889ae6a) - improve webcam options for the ImageEditor.  Thanks @pngwn!

### Dependency updates

- @gradio/upload@0.16.1
- @gradio/atoms@0.15.1
- @gradio/statustracker@0.10.8
- @gradio/icons@0.12.0
- @gradio/image@0.22.1

## 0.14.8

### Dependency updates

- @gradio/statustracker@0.10.7
- @gradio/atoms@0.15.0
- @gradio/icons@0.11.0
- @gradio/upload@0.16.0
- @gradio/image@0.22.0

## 0.14.7

### Dependency updates

- @gradio/wasm@0.18.1
- @gradio/client@1.14.1
- @gradio/upload@0.15.7
- @gradio/image@0.21.7

## 0.14.6

### Dependency updates

- @gradio/atoms@0.14.1
- @gradio/statustracker@0.10.6
- @gradio/client@1.14.0
- @gradio/wasm@0.18.0
- @gradio/upload@0.15.6
- @gradio/image@0.21.6

## 0.14.5

### Dependency updates

- @gradio/image@0.21.5
- @gradio/upload@0.15.5
- @gradio/statustracker@0.10.5
- @gradio/atoms@0.14.0

## 0.14.4

### Dependency updates

- @gradio/client@1.13.1
- @gradio/wasm@0.17.4
- @gradio/upload@0.15.4
- @gradio/image@0.21.4

## 0.14.3

### Dependency updates

- @gradio/upload@0.15.3
- @gradio/client@1.13.0
- @gradio/image@0.21.3

## 0.14.2

### Dependency updates

- @gradio/image@0.21.2
- @gradio/upload@0.15.2
- @gradio/statustracker@0.10.4
- @gradio/atoms@0.13.3

## 0.14.1

### Dependency updates

- @gradio/statustracker@0.10.3
- @gradio/atoms@0.13.2
- @gradio/utils@0.10.1
- @gradio/client@1.12.0
- @gradio/upload@0.15.1
- @gradio/wasm@0.17.3
- @gradio/image@0.21.1

## 0.14.0

### Features

- [#10478](https://github.com/gradio-app/gradio/pull/10478) [`afb96c6`](https://github.com/gradio-app/gradio/commit/afb96c64451e5a282bfee89445d831d1c87f9746) - Improve dataframe's upload accessibility.  Thanks @hannahblair!

### Dependency updates

- @gradio/client@1.11.0
- @gradio/upload@0.15.0
- @gradio/image@0.21.0

## 0.13.4

### Dependency updates

- @gradio/upload@0.14.8
- @gradio/image@0.20.4
- @gradio/wasm@0.17.2

## 0.13.3

### Dependency updates

- @gradio/upload@0.14.7
- @gradio/image@0.20.3
- @gradio/wasm@0.17.1

## 0.13.2

### Dependency updates

- @gradio/upload@0.14.6
- @gradio/wasm@0.17.0
- @gradio/statustracker@0.10.2
- @gradio/image@0.20.2

## 0.13.1

### Dependency updates

- @gradio/atoms@0.13.1
- @gradio/statustracker@0.10.1
- @gradio/client@1.10.0
- @gradio/icons@0.10.0
- @gradio/upload@0.14.5
- @gradio/image@0.20.1

## 0.13.0

### Features

- [#10192](https://github.com/gradio-app/gradio/pull/10192) [`4fc7fb7`](https://github.com/gradio-app/gradio/commit/4fc7fb777c42af537e4af612423fa44029657d41) - Ensure components can be remounted with their previous data.  Thanks @pngwn!

### Dependency updates

- @gradio/atoms@0.13.0
- @gradio/utils@0.10.0
- @gradio/upload@0.14.4
- @gradio/client@1.9.0
- @gradio/icons@0.9.0
- @gradio/statustracker@0.10.0
- @gradio/wasm@0.16.0
- @gradio/image@0.20.0

## 0.12.1

### Dependency updates

- @gradio/statustracker@0.9.7
- @gradio/upload@0.14.3
- @gradio/atoms@0.12.0
- @gradio/image@0.19.0

## 0.12.0

### Features

- [#10032](https://github.com/gradio-app/gradio/pull/10032) [`e450674`](https://github.com/gradio-app/gradio/commit/e450674ce41ca28f1f37a27fb149c728593a6ddf) - add  `webcam_height` and `webcam_width` to specify the resolution of the Webcam.  Thanks @yinsumirage!

### Dependency updates

- @gradio/image@0.18.0

## 0.11.9

### Dependency updates

- @gradio/atoms@0.11.2
- @gradio/utils@0.9.0
- @gradio/statustracker@0.9.6
- @gradio/upload@0.14.2
- @gradio/image@0.17.0

## 0.11.8

### Dependency updates

- @gradio/atoms@0.11.1
- @gradio/client@1.8.0
- @gradio/utils@0.8.0
- @gradio/upload@0.14.1
- @gradio/statustracker@0.9.5
- @gradio/image@0.16.8

## 0.11.7

### Dependency updates

- @gradio/statustracker@0.9.4
- @gradio/atoms@0.11.0
- @gradio/upload@0.14.0
- @gradio/wasm@0.15.0
- @gradio/image@0.16.7

## 0.11.6

### Dependency updates

- @gradio/statustracker@0.9.3
- @gradio/atoms@0.10.1
- @gradio/client@1.7.1
- @gradio/image@0.16.6
- @gradio/upload@0.13.5

## 0.11.5

### Dependency updates

- @gradio/statustracker@0.9.2
- @gradio/atoms@0.10.0
- @gradio/icons@0.8.1
- @gradio/upload@0.13.4
- @gradio/image@0.16.5

## 0.11.4

### Dependency updates

- @gradio/statustracker@0.9.1
- @gradio/upload@0.13.3
- @gradio/atoms@0.9.2
- @gradio/image@0.16.4

## 0.11.3

### Dependency updates

- @gradio/atoms@0.9.1
- @gradio/statustracker@0.9.0
- @gradio/client@1.7.0
- @gradio/upload@0.13.2
- @gradio/wasm@0.14.2
- @gradio/image@0.16.3

## 0.11.2

### Dependency updates

- @gradio/upload@0.13.1
- @gradio/image@0.16.2
- @gradio/wasm@0.14.1

## 0.11.1

### Dependency updates

- @gradio/statustracker@0.8.1
- @gradio/image@0.16.1

## 0.11.0

### Features

- [#8843](https://github.com/gradio-app/gradio/pull/8843) [`6f95286`](https://github.com/gradio-app/gradio/commit/6f95286337459efbccb95c9cfac63355669df9ee) - Improve Icon Button consistency
- [#8843](https://github.com/gradio-app/gradio/pull/8843) [`6f95286`](https://github.com/gradio-app/gradio/commit/6f95286337459efbccb95c9cfac63355669df9ee) - Adds ability to block event trigger when file is uploading
- [#8843](https://github.com/gradio-app/gradio/pull/8843) [`6f95286`](https://github.com/gradio-app/gradio/commit/6f95286337459efbccb95c9cfac63355669df9ee) - Chatbot autoscroll
- [#8843](https://github.com/gradio-app/gradio/pull/8843) [`6f95286`](https://github.com/gradio-app/gradio/commit/6f95286337459efbccb95c9cfac63355669df9ee) - Streaming inputs for 5.0
- [#8843](https://github.com/gradio-app/gradio/pull/8843) [`6f95286`](https://github.com/gradio-app/gradio/commit/6f95286337459efbccb95c9cfac63355669df9ee) - Ssr part 2

### Dependencies

- @gradio/atoms@0.9.0
- @gradio/client@1.6.0
- @gradio/icons@0.8.0
- @gradio/image@0.16.0
- @gradio/statustracker@0.8.0
- @gradio/upload@0.13.0
- @gradio/utils@0.7.0
- @gradio/wasm@0.14.0

## 0.11.0-beta.7

### Features

- [#9582](https://github.com/gradio-app/gradio/pull/9582) [`43a7f42`](https://github.com/gradio-app/gradio/commit/43a7f420d8ac34c7f7fa71d6e630a4c8618d3780) - Chatbot autoscroll.  Thanks @whitphx!

### Dependency updates

- @gradio/upload@0.13.0-beta.7
- @gradio/statustracker@0.8.0-beta.5
- @gradio/icons@0.8.0-beta.4
- @gradio/atoms@0.9.0-beta.5
- @gradio/image@0.16.0-beta.7

## 0.11.0-beta.6

### Dependency updates

- @gradio/statustracker@0.8.0-beta.4
- @gradio/atoms@0.9.0-beta.4
- @gradio/client@1.6.0-beta.4
- @gradio/upload@0.13.0-beta.6
- @gradio/image@0.16.0-beta.6

## 0.11.0-beta.5

### Dependency updates

- @gradio/upload@0.13.0-beta.5
- @gradio/statustracker@0.8.0-beta.3
- @gradio/icons@0.8.0-beta.3
- @gradio/atoms@0.9.0-beta.3
- @gradio/image@0.16.0-beta.5

## 0.11.0-beta.4

### Dependency updates

- @gradio/statustracker@0.8.0-beta.2
- @gradio/upload@0.13.0-beta.4
- @gradio/image@0.16.0-beta.4
- @gradio/wasm@0.14.0-beta.3

## 0.11.0-beta.3

### Dependency updates

- @gradio/upload@0.13.0-beta.3
- @gradio/client@1.6.0-beta.3
- @gradio/image@0.16.0-beta.3

## 0.11.0-beta.2

### Features

- [#9339](https://github.com/gradio-app/gradio/pull/9339) [`4c8c6f2`](https://github.com/gradio-app/gradio/commit/4c8c6f2fe603081941c5fdc43f48a0632b9f31ad) - Ssr part 2.  Thanks @pngwn!
- [#9250](https://github.com/gradio-app/gradio/pull/9250) [`350b0a5`](https://github.com/gradio-app/gradio/commit/350b0a5cafb9176f914f62e7c90de51d4352cc77) - Improve Icon Button consistency.  Thanks @hannahblair!
- [#9253](https://github.com/gradio-app/gradio/pull/9253) [`99648ec`](https://github.com/gradio-app/gradio/commit/99648ec7c4443e74799941e47b0015ac9ca581e1) - Adds ability to block event trigger when file is uploading.  Thanks @dawoodkhan82!

### Dependency updates

- @gradio/atoms@0.9.0-beta.2
- @gradio/upload@0.13.0-beta.2
- @gradio/wasm@0.14.0-beta.2
- @gradio/client@1.6.0-beta.2
- @gradio/icons@0.8.0-beta.2
- @gradio/statustracker@0.8.0-beta.2
- @gradio/utils@0.7.0-beta.2
- @gradio/image@0.16.0-beta.2

## 0.11.0-beta.1

### Dependency updates

- @gradio/atoms@0.8.1-beta.1
- @gradio/icons@0.8.0-beta.1
- @gradio/statustracker@0.8.0-beta.1
- @gradio/utils@0.7.0-beta.1
- @gradio/client@1.6.0-beta.1
- @gradio/image@0.16.0-beta.1
- @gradio/upload@0.12.4-beta.1
- @gradio/wasm@0.13.1-beta.1

## 0.11.0

### Features

- [#8941](https://github.com/gradio-app/gradio/pull/8941) [`97a7bf6`](https://github.com/gradio-app/gradio/commit/97a7bf66a79179d1b91a3199d68e5c11216ca500) - Streaming inputs for 5.0.  Thanks @freddyaboulton!
## 0.10.4

### Fixes

- [#9163](https://github.com/gradio-app/gradio/pull/9163) [`2b6cbf2`](https://github.com/gradio-app/gradio/commit/2b6cbf25908e42cf027324e54ef2cc0baad11a91) - fix exports and generate types.  Thanks @pngwn!

### Dependency updates

- @gradio/utils@0.6.1
- @gradio/statustracker@0.7.6
- @gradio/atoms@0.8.1
- @gradio/icons@0.7.2
- @gradio/wasm@0.13.1
- @gradio/client@1.5.2
- @gradio/upload@0.12.4
- @gradio/image@0.15.1

## 0.10.3

### Features

- [#9118](https://github.com/gradio-app/gradio/pull/9118) [`e1c404d`](https://github.com/gradio-app/gradio/commit/e1c404da1143fb52b659d03e028bdba1badf443d) - setup npm-previews of all packages.  Thanks @pngwn!
- [#9102](https://github.com/gradio-app/gradio/pull/9102) [`efdc323`](https://github.com/gradio-app/gradio/commit/efdc3231a7bde38cfe45d10086d0d36a24c1b9b4) - Initial SSR refactor.  Thanks @pngwn!

### Dependency updates

- @gradio/utils@0.6.0
- @gradio/upload@0.12.3
- @gradio/atoms@0.8.0
- @gradio/client@1.5.1
- @gradio/statustracker@0.7.5
- @gradio/wasm@0.13.0
- @gradio/icons@0.7.1
- @gradio/image@0.15.0

## 0.10.2

### Dependency updates

- @gradio/atoms@0.7.9
- @gradio/statustracker@0.7.4
- @gradio/client@1.5.0
- @gradio/icons@0.7.0
- @gradio/upload@0.12.2
- @gradio/image@0.14.0

## 0.10.1

### Dependency updates

- @gradio/atoms@0.7.8
- @gradio/icons@0.6.1
- @gradio/utils@0.5.2
- @gradio/statustracker@0.7.3
- @gradio/upload@0.12.1
- @gradio/image@0.13.1

## 0.10.0

### Features

- [#8806](https://github.com/gradio-app/gradio/pull/8806) [`a3d23b4`](https://github.com/gradio-app/gradio/commit/a3d23b43e71c22bc2b019ae96668605e744768d5) - Add `loop` parameters to `gr.Audio` and `gr.Video`.  Thanks @abidlabs!
- [#8803](https://github.com/gradio-app/gradio/pull/8803) [`e1a4040`](https://github.com/gradio-app/gradio/commit/e1a404093cfaf9d8f2a92bc1d28fb6aa254848d1) - Ensure all upload components have consistent upload regions.  Thanks @pngwn!

### Dependency updates

- @gradio/wasm@0.12.0
- @gradio/client@1.4.0
- @gradio/image@0.13.0
- @gradio/statustracker@0.7.2
- @gradio/upload@0.12.0
- @gradio/atoms@0.7.7

## 0.9.2

### Dependency updates

- @gradio/atoms@0.7.6
- @gradio/utils@0.5.1
- @gradio/statustracker@0.7.1
- @gradio/client@1.3.0
- @gradio/upload@0.11.5
- @gradio/image@0.12.2
- @gradio/icons@0.6.0

## 0.9.1

### Dependency updates

- @gradio/upload@0.11.4
- @gradio/client@1.2.1
- @gradio/image@0.12.1

## 0.9.0

### Features

- [#8131](https://github.com/gradio-app/gradio/pull/8131) [`bb504b4`](https://github.com/gradio-app/gradio/commit/bb504b494947a287d6386e0e7ead3860c0f15223) - Gradio components in `gr.Chatbot()`.  Thanks @dawoodkhan82!

### Fixes

- [#8594](https://github.com/gradio-app/gradio/pull/8594) [`530f8a0`](https://github.com/gradio-app/gradio/commit/530f8a0b056b35dabe9bdd148e1ab7c4577f017d) - chatbot component tweaks.  Thanks @pngwn!

### Dependency updates

- @gradio/atoms@0.7.5
- @gradio/image@0.12.0
- @gradio/utils@0.5.0
- @gradio/icons@0.5.0
- @gradio/wasm@0.11.0
- @gradio/client@1.2.0
- @gradio/statustracker@0.7.0
- @gradio/upload@0.11.3

## 0.8.10

### Dependency updates

- @gradio/client@1.1.1
- @gradio/upload@0.11.2
- @gradio/image@0.11.10

## 0.8.9

### Dependency updates

- @gradio/upload@0.11.1
- @gradio/client@1.1.0
- @gradio/image@0.11.9

## 0.8.8

### Dependency updates

- @gradio/statustracker@0.6.0
- @gradio/client@1.0.0
- @gradio/upload@0.11.0
- @gradio/image@0.11.8

## 0.8.7

### Dependency updates

- @gradio/upload@0.10.7
- @gradio/client@0.20.1
- @gradio/image@0.11.7

## 0.8.6

### Dependency updates

- @gradio/client@0.20.0
- @gradio/statustracker@0.6.0
- @gradio/image@0.11.6
- @gradio/upload@0.10.6

## 0.8.5

### Dependency updates

- @gradio/utils@0.4.2
- @gradio/atoms@0.7.4
- @gradio/statustracker@0.5.5
- @gradio/upload@0.10.5
- @gradio/client@0.19.4
- @gradio/image@0.11.5

## 0.8.4

### Dependency updates

- @gradio/client@0.19.3
- @gradio/statustracker@0.5.4
- @gradio/image@0.11.4
- @gradio/upload@0.10.4

## 0.8.3

### Dependency updates

- @gradio/upload@0.10.3
- @gradio/client@0.19.2
- @gradio/image@0.11.3

## 0.8.2

### Dependency updates

- @gradio/statustracker@0.5.3
- @gradio/client@0.19.1
- @gradio/image@0.11.2
- @gradio/upload@0.10.2

## 0.8.1

### Fixes

- [#8252](https://github.com/gradio-app/gradio/pull/8252) [`22df61a`](https://github.com/gradio-app/gradio/commit/22df61a26adf8023f6dd49c051979990e8d3879a) - Client node fix.  Thanks @pngwn!

### Dependency updates

- @gradio/atoms@0.7.3
- @gradio/statustracker@0.5.2
- @gradio/client@0.19.0
- @gradio/icons@0.4.1
- @gradio/image@0.11.1
- @gradio/upload@0.10.1

## 0.8.0

### Features

- [#8121](https://github.com/gradio-app/gradio/pull/8121) [`f5b710c`](https://github.com/gradio-app/gradio/commit/f5b710c919b0ce604ea955f0d5f4faa91095ca4a) - chore(deps): update dependency eslint to v9.  Thanks @renovate!
- [#8209](https://github.com/gradio-app/gradio/pull/8209) [`b9afe93`](https://github.com/gradio-app/gradio/commit/b9afe93915401df5bd6737c89395c2477acfa585) - Rename `eventSource_Factory` and `fetch_implementation`.  Thanks @hannahblair!

### Fixes

- [#8179](https://github.com/gradio-app/gradio/pull/8179) [`6a218b4`](https://github.com/gradio-app/gradio/commit/6a218b4148095aaa0c58d8c20973ba01c8764fc2) - rework upload to be a class method + pass client into each component.  Thanks @pngwn!

### Dependency updates

- @gradio/atoms@0.7.2
- @gradio/client@0.18.0
- @gradio/upload@0.10.0
- @gradio/utils@0.4.1
- @gradio/wasm@0.10.1
- @gradio/statustracker@0.5.1
- @gradio/image@0.11.0

## 0.7.0

### Highlights

#### Setting File Upload Limits ([#7909](https://github.com/gradio-app/gradio/pull/7909) [`2afca65`](https://github.com/gradio-app/gradio/commit/2afca6541912b37dc84f447c7ad4af21607d7c72))

We have added a `max_file_size` size parameter to `launch()` that limits to size of files uploaded to the server. This limit applies to each individual file. This parameter can be specified as a string or an integer (corresponding to the size in bytes).

The following code snippet sets a max file size of 5 megabytes.

```python
import gradio as gr

demo = gr.Interface(lambda x: x, "image", "image")

demo.launch(max_file_size="5mb")
# or
demo.launch(max_file_size=5 * gr.FileSize.MB)
```

![max_file_size_upload](https://github.com/gradio-app/gradio/assets/41651716/7547330c-a082-4901-a291-3f150a197e45)


#### Error states can now be cleared

When a component encounters an error, the error state shown in the UI can now be cleared by clicking on the `x` icon in the top right of the component. This applies to all types of errors, whether it's raised in the UI or the server.

![error_modal_calculator](https://github.com/gradio-app/gradio/assets/41651716/16cb071c-accd-45a6-9c18-0dea27d4bd98)

 Thanks @freddyaboulton!

### Fixes

- [#8066](https://github.com/gradio-app/gradio/pull/8066) [`624f9b9`](https://github.com/gradio-app/gradio/commit/624f9b9477f74a581a6c14119234f9efdfcda398) - make gradio dev tools a local dependency rather than bundling.  Thanks @pngwn!

### Dependency updates

- @gradio/atoms@0.7.1
- @gradio/client@0.17.0
- @gradio/image@0.10.0
- @gradio/statustracker@0.5.0
- @gradio/upload@0.9.0
- @gradio/utils@0.4.0

## 0.6.12

### Dependency updates

- @gradio/utils@0.3.2
- @gradio/statustracker@0.4.12
- @gradio/client@0.16.0
- @gradio/upload@0.8.5
- @gradio/atoms@0.7.0
- @gradio/icons@0.4.0
- @gradio/image@0.9.12

## 0.6.11

### Dependency updates

- @gradio/utils@0.3.1
- @gradio/atoms@0.6.2
- @gradio/statustracker@0.4.11
- @gradio/upload@0.8.4
- @gradio/image@0.9.11
- @gradio/client@0.15.1

## 0.6.10

### Dependency updates

- @gradio/upload@0.8.3
- @gradio/client@0.15.0
- @gradio/image@0.9.10

## 0.6.9

### Dependency updates

- @gradio/atoms@0.6.1
- @gradio/statustracker@0.4.10
- @gradio/icons@0.3.4
- @gradio/upload@0.8.2
- @gradio/image@0.9.9

## 0.6.8

### Dependency updates

- @gradio/upload@0.8.1
- @gradio/statustracker@0.4.9
- @gradio/wasm@0.10.0
- @gradio/atoms@0.6.0
- @gradio/image@0.9.8

## 0.6.7

### Dependency updates

- @gradio/client@0.14.0
- @gradio/upload@0.8.0
- @gradio/wasm@0.9.0
- @gradio/image@0.9.7

## 0.6.6

### Dependency updates

- @gradio/upload@0.7.7
- @gradio/client@0.13.0
- @gradio/wasm@0.8.0
- @gradio/image@0.9.6

## 0.6.5

### Patch Changes

- Updated dependencies [[`8181695`](https://github.com/gradio-app/gradio/commit/8181695e70187e8bc2bf7518697098c8d1b9843d)]:
  - @gradio/upload@0.7.6
  - @gradio/image@0.9.5

## 0.6.4

### Features

- [#7528](https://github.com/gradio-app/gradio/pull/7528) [`eda33b3`](https://github.com/gradio-app/gradio/commit/eda33b3763897a542acf298e523fa493dc655aee) - Refactors `get_fetchable_url_or_file()` to remove it from the frontend. Thanks [@abidlabs](https://github.com/abidlabs)!

## 0.6.3

### Patch Changes

- Updated dependencies [[`98a2719`](https://github.com/gradio-app/gradio/commit/98a2719bfb9c64338caf9009891b6c6b0b33ea89)]:
  - @gradio/statustracker@0.4.8
  - @gradio/image@0.9.3

## 0.6.2

### Patch Changes

- Updated dependencies [[`f191786`](https://github.com/gradio-app/gradio/commit/f1917867916647d383b8d7ce15e0c17f2abbdec1)]:
  - @gradio/icons@0.3.3
  - @gradio/atoms@0.5.3
  - @gradio/image@0.9.2
  - @gradio/statustracker@0.4.7
  - @gradio/upload@0.7.4

## 0.6.1

### Patch Changes

- Updated dependencies [[`065c5b1`](https://github.com/gradio-app/gradio/commit/065c5b163c4badb9d9cbd06d627fb4ba086003e7), [`32b317f`](https://github.com/gradio-app/gradio/commit/32b317f24e3d43f26684bb9f3964f31efd0ea556)]:
  - @gradio/utils@0.3.0
  - @gradio/client@0.12.1
  - @gradio/atoms@0.5.2
  - @gradio/image@0.9.1
  - @gradio/statustracker@0.4.6
  - @gradio/upload@0.7.3

## 0.6.0

### Features

- [#7183](https://github.com/gradio-app/gradio/pull/7183) [`49d9c48`](https://github.com/gradio-app/gradio/commit/49d9c48537aa706bf72628e3640389470138bdc6) - [WIP] Refactor file normalization to be in the backend and remove it from the frontend of each component. Thanks [@abidlabs](https://github.com/abidlabs)!

## 0.5.1

### Features

- [#7274](https://github.com/gradio-app/gradio/pull/7274) [`fdd1521`](https://github.com/gradio-app/gradio/commit/fdd15213c24b9cbc58bbc1b6beb4af7c18f48557) - chore: Change time format (thanks @jjshoots for the independent contribution). Thanks [@arian81](https://github.com/arian81)!

### Fixes

- [#7192](https://github.com/gradio-app/gradio/pull/7192) [`8dd6f4b`](https://github.com/gradio-app/gradio/commit/8dd6f4bc1901792f05cd59e86df7b1dbab692739) - Handle the case where examples is `null` for all components. Thanks [@abidlabs](https://github.com/abidlabs)!

## 0.5.0

### Features

- [#7104](https://github.com/gradio-app/gradio/pull/7104) [`bc2cdc1`](https://github.com/gradio-app/gradio/commit/bc2cdc1df95b38025486cf76df4a494b66d98585) - Allow download button for interactive Audio and Video components. Thanks [@hannahblair](https://github.com/hannahblair)!

## 0.4.0

### Fixes

- [#6933](https://github.com/gradio-app/gradio/pull/6933) [`9cefd2e`](https://github.com/gradio-app/gradio/commit/9cefd2e90a1d0cc4d3e4e953fc5b9b1a7afb68dd) - Refactor examples so they accept data in the same format as is returned by function, rename `.as_example()` to `.process_example()`. Thanks [@abidlabs](https://github.com/abidlabs)!
- [#7038](https://github.com/gradio-app/gradio/pull/7038) [`6be3c2c`](https://github.com/gradio-app/gradio/commit/6be3c2c47a616c904c8497d1fbef7a851c54d488) - Fix Chatbot custom component template. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

## 0.3.1

### Fixes

- [#6885](https://github.com/gradio-app/gradio/pull/6885) [`640b7fe`](https://github.com/gradio-app/gradio/commit/640b7fe05276e11720b4341cadf088491395e53d) - Fix issue with Webcam Recording. Thanks [@dawoodkhan82](https://github.com/dawoodkhan82)!

## 0.3.0

### Features

- [#6133](https://github.com/gradio-app/gradio/pull/6133) [`f742d0e`](https://github.com/gradio-app/gradio/commit/f742d0e861c8e25c5d77d9102c9d50f94b0d3383) - Lite: Support AnnotatedImage on Wasm. Thanks [@whitphx](https://github.com/whitphx)!
- [#6897](https://github.com/gradio-app/gradio/pull/6897) [`fb9c6ca`](https://github.com/gradio-app/gradio/commit/fb9c6cacd7ca4598c000f1f97d7d39a8c4463519) - Lite: Chatbot. Thanks [@whitphx](https://github.com/whitphx)!

## 0.2.4

### Features

- [#6854](https://github.com/gradio-app/gradio/pull/6854) [`e528f98`](https://github.com/gradio-app/gradio/commit/e528f98b88f4322f61d315e1770fce0448ca5e26) - chore(deps): update dependency mrmime to v2. Thanks [@renovate](https://github.com/apps/renovate)!

## 0.2.3

### Fixes

- [#6766](https://github.com/gradio-app/gradio/pull/6766) [`73268ee`](https://github.com/gradio-app/gradio/commit/73268ee2e39f23ebdd1e927cb49b8d79c4b9a144) - Improve source selection UX. Thanks [@hannahblair](https://github.com/hannahblair)!

## 0.2.2

### Patch Changes

- Updated dependencies [[`245d58e`](https://github.com/gradio-app/gradio/commit/245d58eff788e8d44a59d37a2d9b26d0f08a62b4)]:
  - @gradio/client@0.9.2
  - @gradio/image@0.5.2
  - @gradio/upload@0.5.5

## 0.2.1

### Patch Changes

- Updated dependencies [[`5d51fbc`](https://github.com/gradio-app/gradio/commit/5d51fbce7826da840a2fd4940feb5d9ad6f1bc5a), [`34f9431`](https://github.com/gradio-app/gradio/commit/34f943101bf7dd6b8a8974a6131c1ed7c4a0dac0)]:
  - @gradio/upload@0.5.4
  - @gradio/client@0.9.1
  - @gradio/image@0.5.1

## 0.2.0

### Features

- [#6726](https://github.com/gradio-app/gradio/pull/6726) [`21cfb0a`](https://github.com/gradio-app/gradio/commit/21cfb0acc309bb1a392f4d8a8e42f6be864c5978) - Remove the styles from the Image/Video primitive components and Fix the container styles. Thanks [@whitphx](https://github.com/whitphx)!
- [#6398](https://github.com/gradio-app/gradio/pull/6398) [`67ddd40`](https://github.com/gradio-app/gradio/commit/67ddd40b4b70d3a37cb1637c33620f8d197dbee0) - Lite v4. Thanks [@whitphx](https://github.com/whitphx)!

### Fixes

- [#6698](https://github.com/gradio-app/gradio/pull/6698) [`798eca5`](https://github.com/gradio-app/gradio/commit/798eca524d44289c536c47eec7c4fdce9fe81905) - Fit video media within Video component. Thanks [@hannahblair](https://github.com/hannahblair)!

## 0.1.9

### Fixes

- [#6566](https://github.com/gradio-app/gradio/pull/6566) [`d548202`](https://github.com/gradio-app/gradio/commit/d548202d2b5bd8a99e3ebc5bf56820b0282ce0f5) - Improve video trimming and error handling. Thanks [@hannahblair](https://github.com/hannahblair)!

## 0.1.8

### Patch Changes

- Updated dependencies [[`71f1a1f99`](https://github.com/gradio-app/gradio/commit/71f1a1f9931489d465c2c1302a5c8d768a3cd23a)]:
  - @gradio/client@0.8.2
  - @gradio/image@0.4.1
  - @gradio/upload@0.5.1

## 0.1.7

### Patch Changes

- Updated dependencies [[`9caddc17b`](https://github.com/gradio-app/gradio/commit/9caddc17b1dea8da1af8ba724c6a5eab04ce0ed8)]:
  - @gradio/atoms@0.3.0
  - @gradio/icons@0.3.0
  - @gradio/image@0.4.0
  - @gradio/statustracker@0.4.0
  - @gradio/upload@0.5.0

## 0.1.6

### Patch Changes

- Updated dependencies [[`2f805a7dd`](https://github.com/gradio-app/gradio/commit/2f805a7dd3d2b64b098f659dadd5d01258290521), [`f816136a0`](https://github.com/gradio-app/gradio/commit/f816136a039fa6011be9c4fb14f573e4050a681a)]:
  - @gradio/image@0.3.6
  - @gradio/upload@0.4.2
  - @gradio/atoms@0.2.2
  - @gradio/icons@0.2.1
  - @gradio/statustracker@0.3.2

## 0.1.5

### Features

- [#6406](https://github.com/gradio-app/gradio/pull/6406) [`0401c77f3`](https://github.com/gradio-app/gradio/commit/0401c77f3d35763b79e040dbe876e69083defd36) - Move ffmpeg to `Video` deps. Thanks [@hannahblair](https://github.com/hannahblair)!

## 0.1.4

### Patch Changes

- Updated dependencies [[`6204ccac5`](https://github.com/gradio-app/gradio/commit/6204ccac5967763e0ebde550d04d12584243a120), [`4d3aad33a`](https://github.com/gradio-app/gradio/commit/4d3aad33a0b66639dbbb2928f305a79fb7789b2d), [`854b482f5`](https://github.com/gradio-app/gradio/commit/854b482f598e0dc47673846631643c079576da9c), [`f1409f95e`](https://github.com/gradio-app/gradio/commit/f1409f95ed39c5565bed6a601e41f94e30196a57)]:
  - @gradio/image@0.3.4
  - @gradio/upload@0.4.0
  - @gradio/client@0.8.0

## 0.1.3

### Fixes

- [#6279](https://github.com/gradio-app/gradio/pull/6279) [`3cdeabc68`](https://github.com/gradio-app/gradio/commit/3cdeabc6843000310e1a9e1d17190ecbf3bbc780) - Ensure source selection does not get hidden in overflow. Thanks [@hannahblair](https://github.com/hannahblair)!

## 0.1.2

### Fixes

- [#6234](https://github.com/gradio-app/gradio/pull/6234) [`aaa55ce85`](https://github.com/gradio-app/gradio/commit/aaa55ce85e12f95aba9299445e9c5e59824da18e) - Video/Audio fixes. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

## 0.1.1

### Patch Changes

- Updated dependencies [[`2ba14b284`](https://github.com/gradio-app/gradio/commit/2ba14b284f908aa13859f4337167a157075a68eb)]:
  - @gradio/client@0.7.1
  - @gradio/image@0.3.1
  - @gradio/upload@0.3.1

## 0.1.0

### Features

- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - fix circular dependency with client + upload. Thanks [@pngwn](https://github.com/pngwn)!
- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - Clean root url. Thanks [@pngwn](https://github.com/pngwn)!
- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - Improve Video Component. Thanks [@pngwn](https://github.com/pngwn)!
- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - Image v4. Thanks [@pngwn](https://github.com/pngwn)!
- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - Publish all components to npm. Thanks [@pngwn](https://github.com/pngwn)!
- [#5498](https://github.com/gradio-app/gradio/pull/5498) [`287fe6782`](https://github.com/gradio-app/gradio/commit/287fe6782825479513e79a5cf0ba0fbfe51443d7) - Custom components. Thanks [@pngwn](https://github.com/pngwn)!

## 0.1.0-beta.9

### Features

- [#6143](https://github.com/gradio-app/gradio/pull/6143) [`e4f7b4b40`](https://github.com/gradio-app/gradio/commit/e4f7b4b409323b01aa01b39e15ce6139e29aa073) - fix circular dependency with client + upload. Thanks [@pngwn](https://github.com/pngwn)!
- [#6136](https://github.com/gradio-app/gradio/pull/6136) [`667802a6c`](https://github.com/gradio-app/gradio/commit/667802a6cdbfb2ce454a3be5a78e0990b194548a) - JS Component Documentation. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!
- [#6094](https://github.com/gradio-app/gradio/pull/6094) [`c476bd5a5`](https://github.com/gradio-app/gradio/commit/c476bd5a5b70836163b9c69bf4bfe068b17fbe13) - Image v4. Thanks [@pngwn](https://github.com/pngwn)!
- [#6149](https://github.com/gradio-app/gradio/pull/6149) [`90318b1dd`](https://github.com/gradio-app/gradio/commit/90318b1dd118ae08a695a50e7c556226234ab6dc) - swap `mode` on the frontned to `interactive` to match the backend. Thanks [@pngwn](https://github.com/pngwn)!
- [#6118](https://github.com/gradio-app/gradio/pull/6118) [`88bccfdba`](https://github.com/gradio-app/gradio/commit/88bccfdba3df2df4b2747ea5d649ed528047cf50) - Improve Video Component. Thanks [@hannahblair](https://github.com/hannahblair)!
- [#6140](https://github.com/gradio-app/gradio/pull/6140) [`71bf2702c`](https://github.com/gradio-app/gradio/commit/71bf2702cd5b810c89e2e53452532650acdcfb87) - Fix video. Thanks [@abidlabs](https://github.com/abidlabs)!

## 0.1.0-beta.8

### Features

- [#6016](https://github.com/gradio-app/gradio/pull/6016) [`83e947676`](https://github.com/gradio-app/gradio/commit/83e947676d327ca2ab6ae2a2d710c78961c771a0) - Format js in v4 branch. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

### Fixes

- [#6067](https://github.com/gradio-app/gradio/pull/6067) [`bf38e5f06`](https://github.com/gradio-app/gradio/commit/bf38e5f06a7039be913614901c308794fea83ae0) - remove dupe component. Thanks [@pngwn](https://github.com/pngwn)!
- [#6046](https://github.com/gradio-app/gradio/pull/6046) [`dbb7de5e0`](https://github.com/gradio-app/gradio/commit/dbb7de5e02c53fee05889d696d764d212cb96c74) - fix tests. Thanks [@pngwn](https://github.com/pngwn)!

## 0.1.0-beta.7

### Patch Changes

- Updated dependencies [[`174b73619`](https://github.com/gradio-app/gradio/commit/174b736194756e23f51bbaf6f850bac5f1ca95b5), [`5fbda0bd2`](https://github.com/gradio-app/gradio/commit/5fbda0bd2b2bbb2282249b8875d54acf87cd7e84)]:
  - @gradio/wasm@0.2.0-beta.1
  - @gradio/image@0.3.0-beta.7

## 0.1.0-beta.6

### Features

- [#5960](https://github.com/gradio-app/gradio/pull/5960) [`319c30f3f`](https://github.com/gradio-app/gradio/commit/319c30f3fccf23bfe1da6c9b132a6a99d59652f7) - rererefactor frontend files. Thanks [@pngwn](https://github.com/pngwn)!
- [#5938](https://github.com/gradio-app/gradio/pull/5938) [`13ed8a485`](https://github.com/gradio-app/gradio/commit/13ed8a485d5e31d7d75af87fe8654b661edcca93) - V4: Use beta release versions for '@gradio' packages. Thanks [@freddyaboulton](https://github.com/freddyaboulton)!

## 0.1.0

### Features

- [#5627](https://github.com/gradio-app/gradio/pull/5627) [`b67115e8e`](https://github.com/gradio-app/gradio/commit/b67115e8e6e489fffd5271ea830211863241ddc5) - Lite: Make the Examples component display media files using pseudo HTTP requests to the Wasm server. Thanks [@whitphx](https://github.com/whitphx)!
- [#5934](https://github.com/gradio-app/gradio/pull/5934) [`8d909624f`](https://github.com/gradio-app/gradio/commit/8d909624f61a49536e3c0f71cb2d9efe91216219) - Fix styling issues with Audio, Image and Video components. Thanks [@aliabd](https://github.com/aliabd)!

## 0.0.11

### Patch Changes

- Updated dependencies []:
  - @gradio/utils@0.1.2
  - @gradio/atoms@0.1.4
  - @gradio/image@0.3.2
  - @gradio/statustracker@0.2.2
  - @gradio/upload@0.3.2

## 0.0.10

### Patch Changes

- Updated dependencies [[`8f0fed857`](https://github.com/gradio-app/gradio/commit/8f0fed857d156830626eb48b469d54d211a582d2)]:
  - @gradio/icons@0.2.0
  - @gradio/atoms@0.1.3
  - @gradio/image@0.3.1
  - @gradio/statustracker@0.2.1
  - @gradio/upload@0.3.1

## 0.0.9

### Patch Changes

- Updated dependencies [[`75ddeb390`](https://github.com/gradio-app/gradio/commit/75ddeb390d665d4484667390a97442081b49a423)]:
  - @gradio/image@0.3.0
  - @gradio/upload@0.3.0

## 0.0.8

### Patch Changes

- Updated dependencies [[`e0d61b8ba`](https://github.com/gradio-app/gradio/commit/e0d61b8baa0f6293f53b9bdb1647d42f9ae2583a)]:
  - @gradio/image@0.2.4

## 0.0.7

### Patch Changes

- Updated dependencies [[`dc86e4a7`](https://github.com/gradio-app/gradio/commit/dc86e4a7e1c40b910c74558e6f88fddf9b3292bc)]:
  - @gradio/image@0.2.3

## 0.0.6

### Patch Changes

- Updated dependencies [[`afac0006`](https://github.com/gradio-app/gradio/commit/afac0006337ce2840cf497cd65691f2f60ee5912)]:
  - @gradio/statustracker@0.2.0
  - @gradio/image@0.2.2
  - @gradio/utils@0.1.1
  - @gradio/atoms@0.1.2
  - @gradio/upload@0.2.1

## 0.0.5

### Patch Changes

- Updated dependencies [[`abf1c57d`](https://github.com/gradio-app/gradio/commit/abf1c57d7d85de0df233ee3b38aeb38b638477db), [`79d8f9d8`](https://github.com/gradio-app/gradio/commit/79d8f9d891901683c5a1b7486efb44eab2478c96)]:
  - @gradio/icons@0.1.0
  - @gradio/utils@0.1.0
  - @gradio/upload@0.2.0
  - @gradio/atoms@0.1.1
  - @gradio/image@0.2.1
  - @gradio/statustracker@0.1.1

## 0.0.4

### Highlights

#### Improve startup performance and markdown support ([#5279](https://github.com/gradio-app/gradio/pull/5279) [`fe057300`](https://github.com/gradio-app/gradio/commit/fe057300f0672c62dab9d9b4501054ac5d45a4ec))

##### Improved markdown support

We now have better support for markdown in `gr.Markdown` and `gr.Dataframe`. Including syntax highlighting and Github Flavoured Markdown. We also have more consistent markdown behaviour and styling.

##### Various performance improvements

These improvements will be particularly beneficial to large applications.

- Rather than attaching events manually, they are now delegated, leading to a significant performance improvement and addressing a performance regression introduced in a recent version of Gradio. App startup for large applications is now around twice as fast.
- Optimised the mounting of individual components, leading to a modest performance improvement during startup (~30%).
- Corrected an issue that was causing markdown to re-render infinitely.
- Ensured that the `gr.3DModel` does re-render prematurely.

Thanks [@pngwn](https://github.com/pngwn)!

### Features

- [#5215](https://github.com/gradio-app/gradio/pull/5215) [`fbdad78a`](https://github.com/gradio-app/gradio/commit/fbdad78af4c47454cbb570f88cc14bf4479bbceb) - Lazy load interactive or static variants of a component individually, rather than loading both variants regardless. This change will improve performance for many applications. Thanks [@pngwn](https://github.com/pngwn)!

## 0.0.3

### Fixes

- [#5140](https://github.com/gradio-app/gradio/pull/5140) [`cd1353fa`](https://github.com/gradio-app/gradio/commit/cd1353fa3eb1b015f5860ca5d5a8e8d1aa4a831c) - Fixes the display of minutes in the video player. Thanks [@abidlabs](https://github.com/abidlabs)!

## 0.0.2

### Patch Changes

- Updated dependencies [[`44ac8ad0`](https://github.com/gradio-app/gradio/commit/44ac8ad08d82ea12c503dde5c78f999eb0452de2)]:
  - @gradio/image@0.1.0
  - @gradio/utils@0.0.2
  - @gradio/atoms@0.0.2
  - @gradio/upload@0.0.2