# Contribution Guidelines

This projects conforms to a [Contributor Code of Conduct](https://github.com/sindresorhus/awesome/blob/master/code-of-conduct.md). By participating in this project you agree to abide by its terms. Also, it is released under a [Creative Commons Zero v1.0 Universal license](https://github.com/guillaume-chevalier/awesome-deep-learning-resources/blob/master/LICENSE), which dedicates this project to the world-wide public domain and ensure this work has the widest reach.

Specifically, the current repository and the ones I link to are about learning resources related to Artificial Intelligence, Machine Learning, Deep Learning, Maths, Data Science, and related Computer Science subjects. To contribute on different subjects, please visit the global [Curated list of awesome lists](https://github.com/sindresorhus/awesome).

<a name="two-ways" />

## Two ways to contribute

I consider [my list](https://github.com/guillaume-chevalier/awesome-deep-learning-resources) as mine (personalized) while shared to the public. That way, I will accept two types of contributions:
- Personalized contributions that are direct links to useful learning resources. I only post to [my list](https://github.com/guillaume-chevalier/awesome-deep-learning-resources) content that I have carefully reviewed and liked. If you want to have my approval to contribute directly to it rather than to a fork of it, I will first need to read your content, and then to consider it helpful enough or interesting enough within the scope of my work, interests and knowledge.
- Links to other lists: those links are not necessarily links I have reviewed in depth. If you want to have your own list, read the section (directly below) on [How to make your own personal or general awesome list (and make me add a link to it)](#fork). This way, rather than incorporating links directly in my list and on my behalf, I will point to your own awesome list that is managed by you.


<a name="fork" />

## How to make your own personal or general awesome list based on this one (and to have me link to it)

Steps:

- [Fork](https://github.com/guillaume-chevalier/awesome-deep-learning-resources/network/members) my repository for this list (with the fork button at the top right corner) to make a "branched-off" copy of it to your GitHub account.
  - Once forked, remove my name such as found in the first paragraph of the [README.md](https://github.com/guillaume-chevalier/awesome-deep-learning-resources/blob/master/README.md). Be sure to edit your own repository rather than opening a pull request in my repository for your changes if they are personal.
  - You might else want to put your name (rather than no name) to make your fork yours. If you do that, ensure to review every link in your forked list to make them point to YOUR favorite content rather than mine. Your list may else be general such as to accept everyone's contributions, if you prefer.
- If you want to personalize how people can contribute to your list, edit your copy of `contributing.md`. In case your repository is not following the "personal" template, you might want to strip out the [Two ways to contribute](#two-ways) section and other details.
- You may want to generate a new [Contributor Code of Conduct](https://github.com/sindresorhus/conduct), or reuse the [Awesome Contributor Code of Conduct](https://github.com/sindresorhus/awesome/blob/master/code-of-conduct.md) like I did.
- I am willing to link to your list from my own personalized repository, and if you follow the visual style for lists such described in the [instructions on how to create a new awesome list](https://github.com/sindresorhus/awesome/blob/master/create-list.md). The link to forks will be placed within a [Contributing section of my README.md](https://github.com/guillaume-chevalier/awesome-deep-learning-resources/blob/master/README.md#contributing). Please open an issue or a clean pull request.

Hint: You may also want to post your fork to [other awesome lists](#other-lists). My repository has a somehow "personal" template that can also be converted to a general one. If you prefer creating a repository from scratch rather than a fork of mine - and that you want me to link to it - I will also require that you first link to my repository within yours.


<a name="other-lists" />

## Other Awesome Lists

Check these out! You might also want to contribute to those awesome lists, too:
- [The Curated list of Awesome Lists](https://github.com/sindresorhus/awesome).
- [Awesome TensorFlow, by jtoy](https://github.com/jtoy/awesome-tensorflow).
- [Awesome Deep Learning, by ChristosChristofidis](https://github.com/ChristosChristofidis/awesome-deep-learning).
- [Awesome Deep Learning Papers, by terryum](https://github.com/terryum/awesome-deep-learning-papers).

Note: different lists might have different contributing guidelines.
