package hex.glm;

import org.junit.Test;
import org.junit.runner.RunWith;
import water.TestUtil;
import water.runner.CloudSize;
import water.runner.H2ORunner;

import static java.lang.Math.abs;

@RunWith(H2ORunner.class)
@CloudSize(1)
public class GLMTweediePowerEstimationTest extends TestUtil {
    /*
    // USEFUL tests for debugging the likelihood estimation but not used for automated tests
    @Test
    public void testVK() {
        double y = 65536;
        double phi = 0.5;
        double p = 4;
        double w = 1;

//> log(dtweedie(0.0724909999575569, mu=7.155736314515837, p=3.64, phi=1))
//[1] -13.205224237922922

        double alpha = (2 - p) / (1 - p);
        int kmax = 1;


        Scope.enter();
        try {
            TweedieVariancePowerMLEstimator tvpe = new TweedieVariancePowerMLEstimator(p, phi);
            double r = (alpha - 1) * log(phi) + alpha * log(p - 1) - (alpha - 1) * log(w) - log(p - 2) - alpha * log(y);
            tvpe.cleanSums();
            tvpe.Vk(r, kmax, -PI * alpha * kmax, logGamma(kmax * alpha + 1), logGamma(kmax + 1));
            double logVMax = tvpe._logVMax;
            tvpe.cleanSums();
            tvpe._logVMax = logVMax;
            for (int k = 1; k < 10; k++) {
                tvpe.Vk(r, k, -PI * alpha * k, logGamma(k * alpha + 1), logGamma(k + 1));
                System.out.println(k + " =>  sumVe: " + (tvpe._logVSum) + "; " + (log(tvpe._logVSum) + tvpe._logVMax));
            }

        } finally {
            Scope.exit();
        }
    }

    @Test
    public void testVKCalculation() {
        // power = 4.0, phi = 0.5, y = 65536.0, mu = 64.0
        double y = 65536;
        double phi = 0.5;
        double p = 4;
        double w = 1;


        Scope.enter();
        try {
            TweedieVariancePowerMLEstimator tvpe = new TweedieVariancePowerMLEstimator(p, phi);
            tvpe.calculateVkSums(y, w);
            System.out.println((tvpe._logVSum + tvpe._logVMax) + "; " + tvpe._logVSum + "; " + tvpe._logVMax + "; diff = " +
                    (tvpe._logVSum + tvpe._logVMax - -7.36888425515632761176));
            assert tvpe._logVSum + tvpe._logVMax == -7.36888425515632761176;
        } finally {
            Scope.exit();
        }
    }

    @Test
    public void testSingleLogLikelihoodCalculation() {
        double expected = -7.69752787144296;
        TweedieVariancePowerMLEstimator tvp = new TweedieVariancePowerMLEstimator(2.00001, 1,
                false, false, false, true);
        double llh = tvp.logLikelihood(1.0000000001, 0.1);
        Log.info("LLH = " + llh + "; diff = " + (llh - expected));
        assert roughlyEqual(llh, expected);
    }
    */

    private boolean roughlyEqual(double actual, double expected) {
        // The expected results are taken from R by taking a logarithm from the dtweedie
        // since we have a limited precision we need to take into account possible differences
        final double rMachineMin = -708.3964; // log(.Machine$double.xmin)
        final double rMachineEps = 36.04365; // abs(log(.Machine$double.eps))
        if (Double.isNaN(expected))
            return true;
        if (Double.NEGATIVE_INFINITY == expected) {
            if (actual < rMachineMin)
                return true;
            return false;
        }
        if (Double.POSITIVE_INFINITY == expected)
            return abs(actual) > 1e6 || !Double.isFinite(actual);
        if (actual < rMachineMin || expected < rMachineMin)
            return Math.abs(actual - expected) < rMachineEps || Math.abs(actual - expected) / Math.max(Math.abs(actual), Math.abs(expected)) < 1e-6;
        if (Math.abs(expected) > 20)
            return Math.abs(actual - expected) < 1e-4;
        if (Math.abs(expected) > 50)
            return Math.abs(actual - expected) < 0.01;
        //System.err.println("diff = "+ Math.abs(actual - expected) / Math.max(Math.abs(actual), Math.abs(expected)) );
        return Math.abs(actual - expected) / Math.max(Math.abs(actual), Math.abs(expected)) < 1e-6;
    }

    @Test
    public void testLogLikelihoodCalculationP_LT_2() {
        int counter = 0;

        double[] mus = new double[]{
                1e-16, 0.1, 0.99,
                0.9999999999, 1.0, 1.0000000001,
                1.1, 2.0, 64.0,
                128.0, 1024.0, 65536.0
        };
        double[] ys = new double[]{
                1e-16, 0.1, 0.99,
                0.9999999999, 1.0, 1.0000000001,
                1.1, 2.0, 64.0,
                128.0, 1024.0, 65536.0
        };
        double[] ps = new double[]{
                1.01, 1.1, 1.2,
                1.3, 1.4, 1.5,
                1.6, 1.7, 1.8,
                1.9, 1.95, 1.99,
                1.99999
        };
        double[] phis = new double[]{
                0.5, 1.0, 2.0
        };
        double[] results = new double[]{
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -83.8646032431066, -75.6283935308295, -76.9580190131897,
                -76.97600984821, -76.97600984839, -76.97600984857,
                -77.1568601006149, -78.8301526679874, -198.167158167859,
                -320.347282434772, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -85.7490023120838, -2.37066603300593, 0.427970613776466,
                0.427870275409788, 0.42787027540777, 0.42787027540578,
                0.416591321043569, -0.196736731982043, -113.512291283958,
                -234.512965962795, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -86.6599656805288, -2.43733585296346, 0.407685761098264,
                0.40778643954593, 0.407786439545902, 0.407786439545902,
                0.398412780644207, -0.203005558856148, -113.450903359285,
                -234.438325795692, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -86.6599656897374, -2.43733585372917, 0.407685760796397,
                0.407786439246081, 0.407786439246053, 0.407786439246081,
                0.398412780363429, -0.203005559017811, -113.45090335877,
                -234.438325795044, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -86.6599656989463, -2.43733585449507, 0.407685760494331,
                0.407786438946033, 0.407786438946005, 0.407786438946005,
                0.398412780082424, -0.203005559179729, -113.450903358256,
                -234.438325794397, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -96.7926418033865, -4.12707639807476, -0.818205106117432,
                -0.816094259504411, -0.816094259484458, -0.81609425946445,
                -0.806414963551276, -1.28873616648906, -113.860066444006,
                -234.714966454654, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -177.182814357838, -8.53082882879499, -1.04731043995196,
                -1.02710807986892, -1.02710807966895, -1.02710807946886,
                -0.845952190393518, -0.256399165339928, -106.738621742738,
                -226.400819922747, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -698.423514708331, -403.353196311806,
                -402.086689690456, -402.086689677855, -402.086689665255,
                -390.09270180278, -315.662924182771, -2.67328297420235,
                -40.1715772657572, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -50.3390417385063,
                -3.02298362907635, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -4.0728020313236, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -6.17299487785858,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -138.724923591642, -134.606818735503, -135.271631476683,
                -135.280626894194, -135.280626894284, -135.280626894374,
                -135.371052020396, -136.207698304082, -195.876201054018,
                -256.966263187474, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -42.7006569882562, -1.01148884871718, 0.387829474674021,
                0.387779305490682, 0.387779305489673, 0.387779305488678,
                0.382139828307572, 0.0754758017947665, -56.5823014741933,
                -117.082638813612, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -43.1611638407045, -1.04984892692185, 0.372661880109007,
                0.37271221933284, 0.372712219332826, 0.372712219332826,
                0.368025389881979, 0.0673162201318006, -56.5566326800827,
                -117.050343898286, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -43.1611638453589, -1.04984892735477, 0.372661879908009,
                0.372712219132851, 0.372712219132836, 0.372712219132851,
                0.368025389691525, 0.0673162200009045, -56.5566326798753,
                -117.050343898012, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -43.1611638500133, -1.04984892778768, 0.372661879707024,
                0.372712218932875, 0.372712218932861, 0.372712218932861,
                0.368025389501071, 0.0673162198699941, -56.556632679668,
                -117.050343897739, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -48.2751639319937, -1.94238122933788, -0.287945583359217,
                -0.286890160052707, -0.286890160042731, -0.286890160032726,
                -0.28205051207614, -0.523211113545031, -56.8088762523035,
                -117.236326257627, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -88.7394072319714, -4.41341446744988, -0.671655273028364,
                -0.661554092986847, -0.66155409288686, -0.661554092786815,
                -0.570976148249144, -0.27619963572235, -53.5173109244215,
                -113.348410014426, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -350.895644953921, -203.360485755658,
                -202.727232444981, -202.727232438682, -202.727232432381,
                -196.730238501145, -159.51534969114, -3.0205290868571,
                -21.7696762326332, -738.205661195663, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -488.72077649553,
                -487.444269372587, -487.444269359887, -487.444269347187,
                -475.350329881292, -400.024357409375, -27.0279296897527,
                -3.3699006350377, -594.333008842831, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -4.41941944838166, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -6.51956918092365,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -200.812442793907, -198.753390365837, -199.085796736427,
                -199.090294445183, -199.090294445228, -199.090294445273,
                -199.135507008284, -199.553830150127, -229.388081525095,
                -259.933112591823, -680.788683308816, Double.NEGATIVE_INFINITY,
                -40.4661063923273, -19.6215223225578, -18.9218631608622,
                -18.9218882454539, -18.9218882454544, -18.9218882454549,
                -18.9247079840454, -19.0780399973018, -47.4069286352958,
                -77.657097305005, -497.640245232431, Double.NEGATIVE_INFINITY,
                -40.2038933666299, -19.1482359097385, -18.4369805062231,
                -18.4369553366112, -18.4369553366112, -18.4369553366112,
                -18.4392987513366, -18.5896533362117, -46.901627786319,
                -77.1484833954206, -497.121828819691, Double.NEGATIVE_INFINITY,
                -40.2038933640571, -19.148235905055, -18.4369805014236,
                -18.4369553318112, -18.4369553318112, -18.4369553318112,
                -18.4392987465318, -18.5896533313772, -46.9016277813153,
                -77.1484833903838, -497.121828814556, Double.NEGATIVE_INFINITY,
                -40.2038933614842, -19.1482359003714, -18.4369804966241,
                -18.4369553270112, -18.4369553270112, -18.4369553270112,
                -18.4392987417271, -18.5896533265426, -46.9016277763116,
                -77.148483385347, -497.121828809421, Double.NEGATIVE_INFINITY,
                -38.0906945969629, -14.9243032456349, -14.0970854226456,
                -14.0965577109923, -14.0965577109873, -14.0965577109823,
                -14.0941378870041, -14.2147181877385, -42.3575507571178,
                -72.5712757597797, -492.446596151416, Double.NEGATIVE_INFINITY,
                -44.5474582064789, -2.38446182421812, -0.513582227007362,
                -0.508531636986604, -0.50853163693661, -0.508531636886588,
                -0.463242664617752, -0.315854408354355, -26.9364100527039,
                -56.8519595977061, -475.845054696522, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -177.301647149037, -103.534067549906,
                -103.217440894567, -103.217440891417, -103.217440888267,
                -100.218943922649, -81.6114995176463, -3.36408921550492,
                -12.738662788393, -370.956237715106, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -394.376137061508, -246.392609073296,
                -245.754355511824, -245.754355505474, -245.754355499123,
                -239.707385766177, -202.044399530218, -15.5461856704078,
                -3.71717114305011, -299.198725246946, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -587.588818108419, -4.76608069289151, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -6.86614419841405,
                -277.575396647779, -277.8551578504, -279.777608833141,
                -279.797618869801, -279.797618870001, -279.797618870201,
                -279.996653723415, -281.722209943498, -371.40707030274,
                -452.671490990167, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -80.8866195347055, -4.0627974502151, -5.46940868696937,
                -5.48740764604806, -5.48740764622806, -5.48740764640806,
                -5.66747101607038, -7.27806470279859, -96.4163669897401,
                -177.592424179739, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -3.77346878407285, -0.589106281545952,
                -0.589206650147634, -0.589206650149635, -0.589206650151631,
                -0.600423816210441, -1.18785095607535, -85.4617863995404,
                -165.85140846243, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -3.83344081737332, -0.597494340763596,
                -0.59739360160912, -0.59739360160912, -0.59739360160912,
                -0.606713619331803, -1.18264450597613, -85.4019241427577,
                -165.782709855993, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -3.83344081797415, -0.597494340848588,
                -0.597393601692101, -0.597393601692101, -0.597393601692101,
                -0.606713619395812, -1.18264450592518, -85.4019241421602,
                -165.782709855307, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -3.83344081857498, -0.597494340933579,
                -0.597393601775082, -0.597393601775082, -0.597393601775082,
                -0.606713619459821, -1.18264450587422, -85.4019241415627,
                -165.782709854621, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -4.43724621008498, -0.685459986972773,
                -0.683348170234602, -0.6833481702146, -0.683348170194599,
                -0.673696704347357, -1.13466505752129, -84.8073866214556,
                -165.099808837174, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -10.1451524576478, -1.75080852065572,
                -1.73059700568238, -1.73059700548238, -1.73059700528238,
                -1.55020218747652, -0.976507740451602, -79.7302066536794,
                -159.227357392547, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -676.248334135134, -348.033347686419,
                -346.766268070801, -346.766268058201, -346.766268045601,
                -334.823553426202, -262.973088298811, -2.86078238559253,
                -27.5725647191132, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -644.991862558086, -35.0823903724055,
                -3.24153435202016, -670.058368705917, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -4.38475948205737, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -6.67206214592514,
                -284.506868453379, -284.646749054689, -285.607974546059,
                -285.61797956439, -285.61797956449, -285.61797956459,
                -285.717496991196, -286.580275101238, -331.422705280859,
                -372.054915624573, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -48.0073743493802, -9.59546330713501, -10.2987689255122,
                -10.3077684050515, -10.3077684051415, -10.3077684052315,
                -10.3978000900627, -11.2030969334268, -55.7722480768975,
                -96.3602766718969, -577.585546182919, Double.NEGATIVE_INFINITY,
                -383.926525615748, -2.40366894585727, -0.811487694593822,
                -0.811537878894663, -0.811537878895663, -0.811537878896662,
                -0.817146461926066, -1.11086003185852, -43.2478277535911,
                -83.4426387850359, -563.639315656673, Double.NEGATIVE_INFINITY,
                -387.822054586035, -2.44401879034083, -0.826045552035975,
                -0.825995182458737, -0.825995182458737, -0.825995182458737,
                -0.830655191320078, -1.11862063464224, -43.228260453033,
                -83.4186533096507, -563.603772960736, Double.NEGATIVE_INFINITY,
                -387.822054624992, -2.44401879074641, -0.826045552183624,
                -0.82599518260538, -0.82599518260538, -0.82599518260538,
                -0.830655191457236, -1.11862063472192, -43.2282604528394,
                -83.4186533094129, -563.603772960383, Double.NEGATIVE_INFINITY,
                -387.82205466395, -2.44401879115198, -0.826045552331276,
                -0.825995182752028, -0.825995182752028, -0.825995182752028,
                -0.830655191594397, -1.1186206348016, -43.2282604526458,
                -83.4186533091751, -563.60377296003, Double.NEGATIVE_INFINITY,
                -426.792830198509, -2.86300272070686, -0.987109609150755,
                -0.986053700781669, -0.986053700771668, -0.986053700761667,
                -0.981227967838047, -1.21171214442501, -43.0480729263921,
                -83.1942840342516, -563.263831478549, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -5.8942098507858, -1.69703788228977,
                -1.68693212480311, -1.68693212470311, -1.68693212460311,
                -1.59673471570018, -1.30988749218772, -40.6867369488016,
                -80.4353123182352, -559.464709902481, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -339.902164677876, -175.794671453518,
                -175.161131645709, -175.161131639409, -175.161131633109,
                -169.18977432341, -133.264541759714, -3.20838880310498,
                -15.5642799698653, -422.938909417187, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -739.669387296916, -410.496385064819,
                -409.21930043087, -409.21930041817, -409.21930040547,
                -397.177068359464, -324.463825122032, -19.509089029192,
                -3.58866101899935, -336.997078195948, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -706.849972734131, -4.73141812585478, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -7.01863775027056,
                -291.438340258978, -291.508280559633, -291.988893305319,
                -291.993895814484, -291.993895814534, -291.993895814584,
                -292.043654527887, -292.475043582908, -314.896258672718,
                -335.212363844575, -575.882784703422, Double.NEGATIVE_INFINITY,
                -35.0334876273677, -15.8275321062451, -16.1791849154336,
                -16.1836846552033, -16.1836846552483, -16.1836846552933,
                -16.2287004977089, -16.6313489193909, -38.9159244911263,
                -59.209938788626, -299.822573544137, Double.NEGATIVE_INFINITY,
                -193.850844286228, -3.08941595128271, -2.29332532565098,
                -2.2933504178014, -2.2933504178019, -2.2933504178024,
                -2.29615470931711, -2.44301149428333, -23.5114953551496,
                -43.608900870872, -283.707239306691, Double.NEGATIVE_INFINITY,
                -195.760972114628, -3.07195421678115, -2.26296759762872,
                -2.2629424128401, -2.2629424128401, -2.2629424128401,
                -2.26527241727077, -2.40925513893186, -23.4640750481272,
                -43.5592714764361, -283.651831301979, Double.NEGATIVE_INFINITY,
                -195.760972133734, -3.07195421661056, -2.26296759732917,
                -2.26294241254005, -2.26294241254005, -2.26294241254005,
                -2.26527241696597, -2.40925513859832, -23.4640750476571,
                -43.5592714759438, -283.651831301429, Double.NEGATIVE_INFINITY,
                -195.760972152839, -3.07195421643997, -2.26296759702962,
                -2.26294241223999, -2.26294241223999, -2.26294241223999,
                -2.26527241666118, -2.40925513826478, -23.4640750471869,
                -43.5592714754515, -283.651831300879, Double.NEGATIVE_INFINITY,
                -214.903765716872, -2.93885197797118, -2.00090542219313,
                -2.00037746800859, -2.00037746800359, -2.00037746799859,
                -1.99796460153678, -2.11320668983026, -23.0313870808138,
                -43.1044926347436, -283.139266356892, Double.NEGATIVE_INFINITY,
                -389.238433747515, -3.7904576126135, -1.69187162836549,
                -1.68681874962215, -1.68681874957215, -1.68681874952215,
                -1.64172004507069, -1.49829643331446, -21.1867211616214,
                -41.0610088463382, -280.575707638461, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -171.903919150392, -89.8501725382129,
                -89.5334026343084, -89.5334026311584, -89.5334026280084,
                -86.5477239731587, -68.585107691311, -3.55703121300627,
                -9.73497679638643, -213.422291520047, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -371.978309682389, -207.390203712346,
                -206.751661395372, -206.751661389022, -206.751661382672,
                -200.730545359669, -164.373923740953, -11.8965556945333,
                -3.93634168943697, -170.640550277911, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -562.031887393426,
                -356.137439149658, -5.07816184552053, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -7.36521536870062,
                -102.189212829094, -102.585436127207, -104.669192748649,
                -104.689212828892, -104.689212829092, -104.689212829292,
                -104.887288692339, -106.541965645573, -171.833257892782,
                -223.446538149924, -742.242847344045, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -0.552512989468673, -2.05338850715941,
                -2.07139649871228, -2.07139649889228, -2.07139649907228,
                -2.25059085786577, -3.79469987866903, -68.6507168442303,
                -120.207650961352, -638.821396498892, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -4.2997944786139, -0.613028172919423,
                -0.613128575131603, -0.613128575133603, -0.613128575135603,
                -0.624277546070848, -1.18433196824585, -62.1663989271394,
                -113.221852398079, -630.688128575134, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -4.36384863096426, -0.618794215477543,
                -0.618693408822738, -0.618693408822738, -0.618693408822738,
                -0.627954229351491, -1.17695185839405, -62.115491289558,
                -113.165310146552, -630.618693409573, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -4.36384863160555, -0.618794215535949,
                -0.618693408879134, -0.618693408879134, -0.618693408879134,
                -0.627954229389006, -1.176951858321, -62.1154912890497,
                -113.165310145987, -630.618693408879, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -4.36384863224683, -0.618794215594358,
                -0.618693408935528, -0.618693408935528, -0.618693408935528,
                -0.627954229426518, -1.17695185824794, -62.1154912885414,
                -113.165310145422, -630.618693408186, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -5.01227248989861, -0.684336970077869,
                -0.682224074731087, -0.682224074711087, -0.682224074691087,
                -0.672603390947222, -1.11103308744907, -61.6142972365297,
                -112.607769953447, -629.932224074711, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -11.3450014997252, -1.77113604614409,
                -1.75091435258762, -1.75091435238762, -1.75091435218762,
                -1.57136013016013, -1.01467843479072, -57.6004650490388,
                -108.086822505771, -624.250914352388, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -669.576953621983, -298.61680384269,
                -297.349087161355, -297.349087148755, -297.349087136155,
                -285.463000276811, -216.354200474755, -3.06931246720427,
                -18.6210631112501, -454.849087148755, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -682.253338509143,
                -679.697885066231, -679.697885040831, -679.697885015431,
                -655.727635433696, -515.855358876351, -23.9942906140401,
                -3.48451164498988, -357.197885040831, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -4.73142383499751, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -7.22658418633141,
                -105.654948731893, -105.853060380949, -106.89493869167,
                -106.904948731792, -106.904948731892, -106.904948731992,
                -107.003986663515, -107.831325140132, -140.476971263737,
                -166.283611392308, -425.654948731892, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -3.02913129039992, -3.77956904924529,
                -3.78857304502172, -3.78857304511172, -3.78857304520172,
                -3.87817022459847, -4.65022473500009, -37.0782332177807,
                -62.8567002763415, -322.163573045112, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -2.82529829348829, -0.981915140641045,
                -0.981965341747135, -0.981965341748135, -0.981965341749135,
                -0.987539827216758, -1.26756703830426, -31.758600517751,
                -57.2863272532207, -316.019465341748, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -2.86112167473798, -0.988594466994622,
                -0.988544063667219, -0.988544063667219, -0.988544063667219,
                -0.993174473931596, -1.26767328845288, -31.7369430040349,
                -57.2618524325317, -315.988544064042, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -2.86112167509644, -0.988594467061642,
                -0.988544063733234, -0.988544063733234, -0.988544063733234,
                -0.99317447398817, -1.26767328845417, -31.7369430038185,
                -57.2618524322872, -315.988544063733, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -2.8611216754549, -0.988594467128664,
                -0.988544063799249, -0.988544063799249, -0.988544063799249,
                -0.993174474044744, -1.26767328845546, -31.7369430036022,
                -57.2618524320426, -315.988544063424, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -3.22117851013652, -1.05721075022615,
                -1.05615430255275, -1.05615430254275, -1.05615430253275,
                -1.05134396066082, -1.27055880891175, -31.5221908834521,
                -57.0189272419105, -315.681154302543, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -6.55384536137684, -1.7669126345863,
                -1.75680178780806, -1.75680178770806, -1.75680178760806,
                -1.66702467659432, -1.38868382890962, -29.6815771360337,
                -54.9247558644, -313.006801787708, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -336.671328933903, -151.191254044257,
                -150.557395703589, -150.557395697289, -150.557395690989,
                -144.614352261318, -110.05995236029, -3.4175083565143,
                -11.1933836785372, -229.30739569729, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -715.218456828754, -343.21642873874,
                -341.938702017284, -341.938702004584, -341.938701991884,
                -329.953577201017, -260.017438922344, -14.0869047911887,
                -3.83201530666361, -180.688702004584, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -668.509637858828,
                -405.824041082631, -5.07817328890519, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -7.57316408670242,
                -109.120684634692, -109.21974045922, -109.740679614581,
                -109.745684634641, -109.745684634691, -109.745684634741,
                -109.795203600503, -110.208872838812, -126.531695900614,
                -139.435015964899, -269.120684634691, Double.NEGATIVE_INFINITY,
                -401.72765211202, -5.99963311938631, -6.37485199880899,
                -6.37935399669721, -6.37935399674221, -6.37935399678721,
                -6.42415258648558, -6.8101798416864, -23.0241840830767,
                -35.9134176123571, -165.566853996742, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -2.63454104615767, -1.71284946973405,
                -1.7128745702871, -1.7128745702876, -1.7128745702881,
                -1.71566181302191, -1.85567541856566, -17.101192158289,
                -29.8650555260239, -159.231624570288, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -2.64344665570508, -1.7071830518334,
                -1.70715785016969, -1.70715785016969, -1.70715785016969,
                -1.70947305530188, -1.84672246256252, -17.0813573203535,
                -29.8438120346019, -159.207157850357, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -2.64344665579556, -1.70718305177816,
                -1.70715785011395, -1.70715785011395, -1.70715785011395,
                -1.70947305524142, -1.84672246247442, -17.0813573201566,
                -29.8438120343909, -159.207157850114, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -2.64344665588604, -1.70718305172292,
                -1.70715785005821, -1.70715785005821, -1.70715785005821,
                -1.70947305518096, -1.84672246238632, -17.0813573199597,
                -29.8438120341799, -159.207157849871, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -2.74709700668358, -1.66511312672839,
                -1.6645849028917, -1.6645849028867, -1.6645849028817,
                -1.66217973194573, -1.77178715607119, -16.8976031933414,
                -29.6459713725706, -158.977084902887, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -4.32851778782663, -1.93505142443136,
                -1.92999600104224, -1.92999600099224, -1.92999600094224,
                -1.88510744543537, -1.74593702159302, -15.892383675155,
                -28.5139730393382, -157.554996000992, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -170.394250641885, -77.654213197062,
                -77.3372840267283, -77.3372840235783, -77.3372840204283,
                -74.3657623055924, -57.0885623550783, -3.76734035319069,
                -7.65527801420215, -116.712284023578, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -359.873674372477, -173.87266032747,
                -173.233796966742, -173.233796960392, -173.233796954042,
                -167.241234558608, -132.273165419272, -9.30789835369436,
                -4.1804536114318, -92.608796960392, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -337.140831056078,
                -205.798032667979, -5.42509877111606, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -7.9197502973823,
                -43.8198703254121, -44.389945272486, -46.6569830517424,
                -46.6770131822949, -46.6770131824949, -46.6770131826949,
                -46.8741361679701, -48.4613125902448, -96.3317951252165,
                -129.125743837289, -409.534156039638, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, 0.375818529335889, -1.22972414043733,
                -1.24774117051375, -1.24774117069375, -1.24774117087375,
                -1.42607206217889, -2.90687550934782, -50.4273061725815,
                -83.1853106574104, -363.521550694503, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -4.89653990749402, -0.614776102866744,
                -0.614876538706309, -0.614876538708307, -0.614876538710307,
                -0.625957793681543, -1.16004176240938, -45.565010767175,
                -78.0031116295378, -357.697019395851, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -4.96896059355267, -0.621047278638564,
                -0.620946404432535, -0.620946404432535, -0.620946404432534,
                -0.630148450025551, -1.15359512134919, -45.5235589392911,
                -77.9580653789655, -357.644755928825, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -4.96896059427758, -0.621047278701985,
                -0.620946404493944, -0.620946404493944, -0.620946404493942,
                -0.630148450068169, -1.15359512128543, -45.5235589388773,
                -77.9580653785158, -357.644755928303, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -4.9689605950025, -0.621047278765406,
                -0.620946404555353, -0.620946404555353, -0.620946404555351,
                -0.630148450110784, -1.15359512122167, -45.5235589384635,
                -77.958065378066, -357.644755927781, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -5.70071244617079, -0.691304021111989,
                -0.689190046427896, -0.689190046407896, -0.689190046387896,
                -0.679599997992021, -1.09667369410354, -45.1165856399574,
                -77.5151478523525, -357.129666236884, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -12.7542967272379, -1.79143231683031,
                -1.77120043786176, -1.77120043766176, -1.77120043746175,
                -1.59248154333497, -1.05219846349481, -41.9216435637068,
                -73.9967077309116, -352.961676628138, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -680.120397892648, -259.030565602655,
                -257.762211428535, -257.762211415935, -257.762211403335,
                -245.932394247746, -179.440866602345, -3.27815122500704,
                -13.0677945013217, -247.286020939745, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -578.122032389297,
                -575.565293910504, -575.565293885104, -575.565293859704,
                -551.70853656325, -417.138304850175, -16.9423915605268,
                -3.72772940108388, -191.755770075581, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -463.712741485153, -5.07818146468437, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -7.78111519227628,
                -46.1303609272486, -46.4153984007855, -47.5489172904137,
                -47.5589323556899, -47.5589323557899, -47.5589323558899,
                -47.6574938485276, -48.4510820596649, -72.3863233271507,
                -88.7832976831868, -228.987503784361, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -1.0243369028334, -1.82710823772001,
                -1.83611675275822, -1.83611675284822, -1.83611675293822,
                -1.92528219859078, -2.66568392217525, -26.4258992537921,
                -42.8049014962065, -182.973021514753, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -3.1528816662221, -1.01199976390846,
                -1.01204998182824, -1.01204998182924, -1.01204998183024,
                -1.01759060931586, -1.28463259367978, -23.4871170960626,
                -39.706167527244, -179.553121410401, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -3.19180461515525, -1.0178479576982,
                -1.01779752059519, -1.01779752059519, -1.01779752059519,
                -1.0223985433917, -1.28412187905351, -23.4691037880245,
                -39.6863570078617, -179.529702282792, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -3.19180461554475, -1.01784795775696,
                -1.01779752065293, -1.01779752065293, -1.01779752065293,
                -1.02239854344005, -1.28412187904868, -23.4691037878446,
                -39.6863570076639, -179.529702282558, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -3.19180461593425, -1.01784795781571,
                -1.01779752071068, -1.01779752071068, -1.01779752071068,
                -1.0223985434884, -1.28412187904384, -23.4691037876647,
                -39.686357007466, -179.529702282324, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -3.5838385889429, -1.0791343764135,
                -1.07807738907146, -1.07807738906146, -1.07807738905146,
                -1.07328236485352, -1.28181921290928, -23.2917751858362,
                -39.4910562920338, -179.2983154843, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -7.28111914865278, -1.79968694344897,
                -1.78957100396469, -1.78957100386469, -1.78957100376469,
                -1.7002115567013, -1.43007001678122, -21.8647925668872,
                -37.9023246504896, -177.384809099103, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -342.048374870889, -131.503458725892,
                -130.869281638832, -130.869281632532, -130.869281626232,
                -124.954373048437, -91.7086092257374, -3.62725153706822,
                -8.52207317522553, -125.631186394437, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -713.496355905759, -291.273004726138,
                -289.994635486741, -289.994635474041, -289.994635461341,
                -278.066256813114, -210.781140956577, -10.6831843117524,
                -4.07585323203094, -98.0898735692793, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -402.379864338805,
                -234.74239520878, -5.42511519854601, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -8.12770835496067,
                -48.4408515291, -48.5833702658685, -49.1501297106826,
                -49.1551372433207, -49.1551372433707, -49.1551372434207,
                -49.2044179897395, -49.6012120953082, -61.5688327290511,
                -69.7673199070692, -139.869422957656, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -2.86377033282728, -3.26515600027058,
                -3.26966025778969, -3.26966025783469, -3.26966025787969,
                -3.31424298070597, -3.68444384249821, -15.5645515083066,
                -23.7540526295138, -93.838112638787, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -2.67688496926951, -1.60644401811269,
                -1.60646912707258, -1.60646912707308, -1.60646912707358,
                -1.60923944081639, -1.74276043299835, -12.8440026841898,
                -20.9535278997805, -90.8770048413588, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -2.69466070119108, -1.60768237246255,
                -1.60765715391105, -1.60765715391105, -1.60765715391105,
                -1.6099576653093, -1.74081933314021, -12.8333102876257,
                -20.9419368975443, -90.8636095350092, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -2.69466070136938, -1.60768237247548,
                -1.60765715392347, -1.60765715392347, -1.60765715392347,
                -1.60995766531703, -1.74081933312135, -12.8333102875193,
                -20.9419368974289, -90.8636095348758, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -2.69466070154769, -1.60768237248841,
                -1.6076571539359, -1.6076571539359, -1.6076571539359,
                -1.60995766532476, -1.74081933310248, -12.8333102874129,
                -20.9419368973136, -90.8636095347424, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -2.87796755717494, -1.62561545091024,
                -1.62508695723921, -1.62508695723421, -1.62508695722921,
                -1.62268944513024, -1.72695786915812, -12.7319358556216,
                -20.8315764087204, -90.7352060048532, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -4.7698509113968, -2.02913480879489,
                -2.02407683905276, -2.02407683900276, -2.02407683895276,
                -1.97939711542106, -1.84432634546102, -12.061687620514,
                -20.0804536623152, -89.8216958866218, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -173.189484086523, -67.9170260140249,
                -67.5999374704948, -67.5999374673448, -67.5999374641948,
                -64.6424831752975, -48.0196012639474, -3.97892241961282,
                -6.42633323869148, -64.9808898482972, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -359.13579512503, -148.024119535219,
                -147.384934915521, -147.384934909171, -147.384934902821,
                -141.420745578708, -107.778187650439, -7.72920932802668,
                -4.42554378816595, -51.4325539567901, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -204.249784534079,
                -120.431049969066, -5.77240996394903, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -8.47432109266915,
                -14.6817688354333, -15.5190643105099, -17.9950619788791,
                -18.0151021664734, -18.0151021666734, -18.0151021668734,
                -18.2112783430793, -19.7341573883747, -55.1008772736173,
                -75.9456810998486, -228.015102166674, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, 0.740658671998577, -0.981409893576221,
                -0.999435968230106, -0.999435968410106, -0.999435968590106,
                -1.17690889614414, -2.59742033173903, -37.679943360761,
                -58.5018085487726, -210.53068596841, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -5.60332728758344, -0.615426838288647,
                -0.615527307772494, -0.615527307774494, -0.615527307776494,
                -0.626541322328473, -1.13598103158906, -33.6891520402468,
                -54.3068633481041, -205.974902307775, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -5.68553432773029, -0.62224096890999,
                -0.622140027101805, -0.622140027101805, -0.622140027101805,
                -0.631283716807296, -1.1304866652002, -33.65523798852,
                -54.2706554325784, -205.934640027571, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -5.68553432855304, -0.622240968978809,
                -0.622140027168611, -0.622140027168611, -0.622140027168613,
                -0.631283716855399, -1.13048666514593, -33.6552379881816,
                -54.270655432217, -205.934640027169, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -5.68553432937579, -0.622240969047631,
                -0.622140027235419, -0.622140027235419, -0.622140027235419,
                -0.631283716903503, -1.13048666509167, -33.6552379878431,
                -54.2706554318556, -205.934640026767, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -6.51480770103283, -0.697585238664269,
                -0.695470183913615, -0.695470183893617, -0.695470183873615,
                -0.685910624908487, -1.08274596349854, -33.3233004303135,
                -53.9157792361293, -205.539220183894, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -14.4148486524135, -1.81226426489594,
                -1.79202219368121, -1.79202219348121, -1.79202219328121,
                -1.61413339644883, -1.08966024773452, -30.7724430085632,
                -51.1584740704027, -202.417022193481, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -707.08063332294, -227.042005202933,
                -225.773013108637, -225.773013096037, -225.773013083437,
                -213.999110122417, -150.006718959402, -3.48745086339721,
                -9.65152622909396, -135.773013096037, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -496.702910635296,
                -494.14488625911, -494.14488623371, -494.14488620831,
                -470.400904110063, -340.893242738739, -12.4879866614858,
                -3.97133356664798, -104.14488623371, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -482.569502731743,
                -268.522651189422, -5.42512505814404, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -8.33567350366997,
                -16.4146367857865, -16.8332845233248, -18.0712833575094,
                -18.0813034513066, -18.0813034514066, -18.0813034515066,
                -18.1793915396096, -18.9408310622572, -36.6241910048786,
                -47.0465929179942, -123.081303451407, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -0.14621450431646, -1.00724878710386,
                -1.0162618244308, -1.0162618245208, -1.0162618246108,
                -1.10499828838782, -1.81525400618526, -19.3565155206962,
                -29.7674481147021, -105.781886824521, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -3.51481636304416, -1.02086613839676,
                -1.02091637313868, -1.02091637313968, -1.02091637314068,
                -1.02642338041667, -1.28114323504697, -17.5577287393758,
                -27.8665843933045, -103.70060387314, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -3.55879252771744, -1.02714584830729,
                -1.0270953774032, -1.0270953774032, -1.0270953774032,
                -1.03166722225594, -1.2812686964524, -17.5436443581123,
                -27.8513530801415, -103.683345377638, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -3.55879252815744, -1.02714584837032,
                -1.02709537746522, -1.02709537746522, -1.02709537746522,
                -1.03166722230862, -1.28126869645388, -17.5436443579717,
                -27.8513530799894, -103.683345377465, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -3.55879252859743, -1.02714584843335,
                -1.02709537752724, -1.02709537752724, -1.02709537752724,
                -1.03166722236129, -1.28126869645537, -17.5436443578311,
                -27.8513530798373, -103.683345377293, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -4.00101566379824, -1.09240443261396,
                -1.09134690523863, -1.09134690522863, -1.09134690521863,
                -1.08656712573607, -1.28498479503109, -17.4052620284386,
                -27.7015014313465, -103.513221905229, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -8.13391492558725, -1.83262273182845,
                -1.82250169622108, -1.82250169612108, -1.82250169602108,
                -1.7335572976049, -1.47132072324774, -16.3127121036621,
                -26.5057276345818, -102.135001696121, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -355.634522469552, -115.615208409549,
                -114.980712362401, -114.980712356101, -114.980712349801,
                -109.093760869291, -77.0975652877833, -3.83793123978074,
                -6.91996892262911, -69.9807123561009, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -731.962888756243, -250.686259975365,
                -249.407247787271, -249.407247774571, -249.407247761871,
                -237.535256712748, -172.781426027086, -8.5787979884592,
                -4.32047144104031, -54.4072477745714, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -244.344618709962,
                -137.321192938802, -5.77242987316288, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -8.6823072417258,
                -18.1475047366631, -18.3568286054322, -18.9758280225245,
                -18.9808380694231, -18.9808380694731, -18.9808380695231,
                -19.0298821135746, -19.4106018748984, -28.2522818462091,
                -33.4634828027669, -71.4808380694732, -664.853239780577,
                Double.NEGATIVE_INFINITY, -1.39328262516183, -1.82379976655553,
                -1.828306285219, -1.828306285264, -1.828306285309,
                -1.87267451719751, -2.22780237609623, -10.9984331333517,
                -16.2038994303546, -54.211118785264, -647.577188188327,
                Double.NEGATIVE_INFINITY, -2.80955187880552, -1.56257676648183,
                -1.56260188385279, -1.56260188385329, -1.56260188385379,
                -1.56535538749178, -1.69271531480693, -9.83100806697135,
                -14.9854358939357, -52.9024456338533, -646.212157495356,
                Double.NEGATIVE_INFINITY, -2.8324749147981, -1.56665157509302,
                -1.56662633964098, -1.56662633964098, -1.56662633964098,
                -1.56891226206735, -1.69371299916557, -9.82490082999553,
                -14.9787551910101, -52.8947513397582, -646.203829970463,
                Double.NEGATIVE_INFINITY, -2.83247491502752, -1.56665157513396,
                -1.56662633968141, -1.56662633968141, -1.56662633968141,
                -1.56891226210311, -1.69371299917574, -9.82490082993465,
                -14.9787551909435, -52.8947513396814, -646.20382997038,
                Double.NEGATIVE_INFINITY, -2.83247491525694, -1.5666515751749,
                -1.56662633972185, -1.56662633972185, -1.56662633972185,
                -1.56891226213887, -1.69371299918591, -9.82490082987377,
                -14.9787551908769, -52.8947513396047, -646.203829970297,
                Double.NEGATIVE_INFINITY, -3.06366815207871, -1.60936253648657,
                -1.60883377279891, -1.60883377279391, -1.60883377278891,
                -1.60644388304763, -1.70565271769514, -9.76579133439887,
                -14.9139110358528, -52.8197712727939, -646.122517595452,
                Double.NEGATIVE_INFINITY, -5.23850884948177, -2.08786275260237,
                -2.08280223479868, -2.08280223474868, -2.08280223469868,
                -2.03833003549059, -1.90721174831201, -9.32790743851917,
                -14.4244152039791, -52.2390522347487, -645.484807785042,
                Double.NEGATIVE_INFINITY, -180.090735025162, -60.0810779951606,
                -59.7638299715866, -59.7638299684366, -59.7638299652866,
                -56.8203542250315, -40.8222564342778, -4.19243941027652,
                -5.73345825170071, -37.2638299684366, -626.583554533609,
                Double.NEGATIVE_INFINITY, -368.493432981706, -127.855119504611,
                -127.215613410564, -127.215613404214, -127.215613397864,
                -121.279617873302, -88.9027025304711, -6.80138851115787,
                -4.67222523744842, -29.7156134042139, -614.982660823455,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -125.406564476874,
                -71.8948515912934, -6.12047005847396, -534.650037434682,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -9.02900115547739,
                2.77258864223978, 1.50767765817243, -1.2073610261867,
                -1.22741127756022, -1.22741127776022, -1.22741127796022,
                -1.42264667044083, -2.8842655272526, -29.2274112777602,
                -42.4822452736993, -125.22741127776, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, 0.957763058449566, -0.894379687945895,
                -0.912414813235731, -0.912414813415731, -0.912414813595731,
                -1.08903524179457, -2.45211177538273, -28.5624148134157,
                -41.8026041484141, -124.524914813416, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -6.44292378037606, -0.615292678894888,
                -0.615393182039928, -0.615393182041928, -0.615393182043928,
                -0.62634042813508, -1.11239028503304, -25.1503931820419,
                -38.2602450346683, -120.779143182042, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -6.53658000392463, -0.622659309509989,
                -0.622558300048676, -0.622558300048676, -0.622558300048676,
                -0.631644049730267, -1.1078396744044, -25.1225583003987,
                -38.2309456869456, -120.747558300436, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -6.53658000486184, -0.622659309584305,
                -0.622558300120977, -0.622558300120977, -0.622558300120977,
                -0.631644049783953, -1.10783967435955, -25.122558300121,
                -38.2309456866533, -120.747558300121, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -6.53658000579906, -0.62265930965862,
                -0.622558300193277, -0.622558300193277, -0.622558300193277,
                -0.631644049837637, -1.10783967431469, -25.1225582998433,
                -38.2309456863609, -120.747558299806, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -7.47999961809538, -0.703182984854173,
                -0.701066849307161, -0.701066849287161, -0.701066849267161,
                -0.691537634648373, -1.06919093600035, -24.8510668492872,
                -37.9448095748788, -120.438566849287, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -16.3763883645091, -1.8335082895949,
                -1.81325601929473, -1.81325601909473, -1.81325601889473,
                -1.63619212574007, -1.12696451807949, -22.8132560190947,
                -35.7751967962203, -118.063256019095, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -200.967063500376,
                -199.697433058192, -199.697433045592, -199.697433032992,
                -187.979091285144, -126.37362327884, -3.69743304559152,
                -7.57968403950009, -75.6974330455915, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -432.265197126586,
                -429.705885990843, -429.705885965443, -429.705885940043,
                -406.073967051867, -281.401412182447, -9.70588596544276,
                -4.21555395732084, -57.7058859654428, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -293.772436511726,
                -157.065942475177, -5.77243651172574, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -8.89031425983539,
                1.38629432111989, 0.75383882908622, -0.603680513093345,
                -0.613705638780104, -0.613705638880106, -0.613705638980108,
                -0.711323335220406, -1.4421327636263, -14.6137056388801,
                -21.2411226368496, -62.6137056388801, -510.61370563888,
                Double.NEGATIVE_INFINITY, 0.315128345205982, -0.610943027991749,
                -0.619960590636667, -0.619960590726667, -0.619960590816667,
                -0.708270804916089, -1.38980907171017, -14.4449605907267,
                -21.0650552582259, -62.4262105907267, -510.420741840727,
                Double.NEGATIVE_INFINITY, -3.93555973302448, -1.0217441822839,
                -1.02179443385642, -1.02179443385742, -1.02179443385842,
                -1.02726805690399, -1.27029298535297, -13.2892944338574,
                -19.8442203601706, -61.1036694338574, -509.049528808857,
                Double.NEGATIVE_INFINITY, -3.98562607221157, -1.02866572500425,
                -1.02861522027359, -1.02861522027359, -1.02861522027359,
                -1.03315809511439, -1.27125590745146, -13.2786152204486,
                -19.8328089137221, -61.0911152204673, -509.036427720473,
                Double.NEGATIVE_INFINITY, -3.98562607271242, -1.02866572507365,
                -1.02861522034198, -1.02861522034198, -1.02861522034198,
                -1.03315809517347, -1.27125590746127, -13.278615220342,
                -19.8328089136081, -61.091115220342, -509.036427720342,
                Double.NEGATIVE_INFINITY, -3.98562607321326, -1.02866572514304,
                -1.02861522041037, -1.02861522041037, -1.02861522041037,
                -1.03315809523255, -1.27125590747108, -13.2786152202354,
                -19.8328089134942, -61.0911152202166, -509.036427720211,
                Double.NEGATIVE_INFINITY, -4.4882422159977, -1.0998338993771,
                -1.09877583160359, -1.09877583159359, -1.09877583158359,
                -1.0940112242742, -1.28283787495019, -13.1737758315936,
                -19.7206471943894, -60.9675258315936, -508.907369581594,
                Double.NEGATIVE_INFINITY, -9.1368969616742, -1.8654569242171,
                -1.85533078906701, -1.85533078896701, -1.85533078886701,
                -1.76679884228968, -1.51218503845939, -12.355330788967,
                -18.8363011775298, -59.980330788967, -507.870955788967,
                Double.NEGATIVE_INFINITY, -377.454003954652, -102.684823148458,
                -102.050007927366, -102.050007921066, -102.050007914766,
                -96.1908370408417, -65.3881030376899, -4.05000792106562,
                -5.99113341801991, -40.0500079210656, -484.550007921066,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -218.591162598621,
                -217.31150703075, -217.31150701805, -217.31150700535,
                -205.495547561262, -143.159270126552, -7.31150701804963,
                -4.56634101398867, -31.3115070180496, -472.31150701805,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -150.120483598024,
                -81.7672365797496, -6.12048359802395, -398.120483598024,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -9.23707108982844,
                -1.99999945273353e-08, -0.31622776601683, -0.994987437106616,
                -0.999999999949992, -0.999999999999993, -1.00000000004999,
                -1.04880884817015, -1.41421356237309, -7.99999999999999,
                -11.3137084989848, -32.0, -256.0,
                Double.NEGATIVE_INFINITY, -0.582865390202177, -1.04590107680104,
                -1.0504098581235, -1.0504098581685, -1.0504098582135,
                -1.09456496526321, -1.43533409866025, -7.9629098581685,
                -11.2729571919181, -31.9535348581685, -255.950800483169,
                Double.NEGATIVE_INFINITY, -2.9870821464568, -1.53017437108651,
                -1.53019949687277, -1.53019949687327, -1.53019949687377,
                -1.53293630839656, -1.65444877262105, -7.66394949687327,
                -10.9414124600299, -31.5711369968733, -255.544066684373,
                Double.NEGATIVE_INFINITY, -3.01437095236614, -1.53589077876248,
                -1.53586552639715, -1.53586552639715, -1.53586552639715,
                -1.53813696381755, -1.65718586998608, -7.66086552648465,
                -10.9379623731214, -31.567115526494, -255.539771776497,
                Double.NEGATIVE_INFINITY, -3.01437095263906, -1.53589077881967,
                -1.53586552645384, -1.53586552645384, -1.53586552645384,
                -1.53813696386958, -1.65718587001348, -7.66086552645384,
                -10.9379623730869, -31.5671155264538, -255.539771776454,
                Double.NEGATIVE_INFINITY, -3.01437095291197, -1.53589077887686,
                -1.53586552651053, -1.53586552651053, -1.53586552651053,
                -1.53813696392162, -1.65718587004088, -7.66086552642303,
                -10.9379623730524, -31.5671155264137, -255.539771776411,
                Double.NEGATIVE_INFINITY, -3.28755186379774, -1.59334770548743,
                -1.59281867160068, -1.59281867159568, -1.59281867159068,
                -1.59043636793598, -1.68484969327398, -7.63031867159568,
                -10.9037543529936, -31.5271936715957, -255.497115546596,
                Double.NEGATIVE_INFINITY, -5.76746954506996, -2.13174952634141,
                -2.12668645876636, -2.12668645871636, -2.12668645866636,
                -2.0824204853777, -1.95511358346255, -7.37668645871636,
                -10.6171716529978, -31.1891864587164, -255.134498958716,
                Double.NEGATIVE_INFINITY, -191.110886062949, -53.7262956598517,
                -53.4088880493055, -53.4088880461555, -53.4088880430055,
                -50.4793026060435, -35.0779356044676, -4.40888804615547,
                -5.37945079463261, -22.4088880461555, -244.658888046155,
                Double.NEGATIVE_INFINITY, -387.381840152885, -111.933899675601,
                -111.294071891665, -111.294071885315, -111.294071878965,
                -105.386092156921, -74.2179534395666, -6.29407188531543,
                -4.92148888328495, -18.2940718853154, -238.794071885315,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -667.961579265229, -78.4700217678313,
                -44.2933982586942, -6.47002176783131, -202.470021767831,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -9.58401142856017,
                14.389386685428, 12.3988541502202, 9.4094503250828,
                9.38939000318771, 9.38939000298771, 9.38939000278771,
                9.19508941171728, 7.79185044912324, -12.0007682124702,
                -20.4326325288572, -65.6106099970122, -407.853141444338,
                Double.NEGATIVE_INFINITY, 1.13003565491461, -0.867693741637412,
                -0.885737923626248, -0.885737923806248, -0.885737923986248,
                -1.06151127818397, -2.3698621294662, -21.9700525540719,
                -30.3925635923865, -75.5576129238062, -417.795365565113,
                Double.NEGATIVE_INFINITY, -7.44248787990471, -0.614314862046666,
                -0.614415398869818, -0.614415398871818, -0.614415398873819,
                -0.625296344904496, -1.08914300551156, -18.9767221209266,
                -27.3159889843966, -72.3659778988718, -414.561199166613,
                Double.NEGATIVE_INFINITY, -7.54958217953753, -0.622241719812617,
                -0.622140642647162, -0.622140642647162, -0.622140642647162,
                -0.631168865009096, -1.08552671457987, -18.9538630064886,
                -27.2921945421607, -72.3408906429752, -414.53563403012,
                Double.NEGATIVE_INFINITY, -7.54958218060909, -0.622241719892506,
                -0.622140642725033, -0.622140642725033, -0.622140642725033,
                -0.63116886506844, -1.08552671454433, -18.9538630062606,
                -27.2921945419234, -72.340890642725, -414.535634029865,
                Double.NEGATIVE_INFINITY, -7.54958218168066, -0.622241719972392,
                -0.622140642802904, -0.622140642802904, -0.622140642802904,
                -0.631168865127785, -1.08552671450878, -18.9538630060326,
                -27.292194541686, -72.3408906424747, -414.53563402961,
                Double.NEGATIVE_INFINITY, -8.62703406757574, -0.708019178273746,
                -0.705901961200016, -0.705901961180018, -0.705901961160018,
                -0.696402946630723, -1.0558726847948, -18.7317807395234,
                -27.0607589971137, -72.09652696118, -414.286491542301,
                Double.NEGATIVE_INFINITY, -18.6991026956436, -1.85501794907297,
                -1.83475547284293, -1.83475547264293, -1.83475547244293,
                -1.65851132605932, -1.16398806241705, -17.1080419842562,
                -25.3528407391946, -70.2722554726429, -412.419210799596,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -179.52842103278,
                -178.258151814671, -178.258151802071, -178.258151789471,
                -166.595020782012, -107.269868505044, -3.90841549450061,
                -6.35418184453075, -43.2581518020708, -382.442247397474,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -380.651309672929,
                -378.090710914816, -378.090710889416, -378.090710864016,
                -354.570148258028, -234.516604741497, -8.00108005881736,
                -4.46074844249057, -33.0907108894156, -369.216370632897,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -180.672315905483,
                -93.3266127601588, -6.12047005847401, -299.428027875043,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -9.44520185216393,
                13.2341430431497, 12.2388767755459, 10.7441748629772,
                10.7341447020296, 10.7341447019296, 10.7341447018296,
                10.6369944062944, 9.93537492499738, 0.0390655942006789,
                -4.17686656399286, -26.7658552980704, -197.887121021733,
                Double.NEGATIVE_INFINITY, 0.605419036561805, -0.393445661714206,
                -0.402467752708623, -0.402467752798623, -0.402467752888623,
                -0.490354429987485, -1.1445298556286, -10.9446250679314,
                -15.1558805870888, -37.7384052527986, -208.857281573452,
                Double.NEGATIVE_INFINITY, -4.43259318816009, -1.01850667923107,
                -1.01855694764264, -1.01855694764364, -1.01855694764464,
                -1.02399742065998, -1.25592075096352, -10.199710308671,
                -14.369343740406, -36.8943381976436, -207.991948831514,
                Double.NEGATIVE_INFINITY, -4.48977148504885, -1.02610125518639,
                -1.02605071660367, -1.02605071660367, -1.02605071660367,
                -1.03056482778463, -1.25774375257002, -10.1919118985244,
                -14.3610776663604, -36.8854257167677, -207.98279741034,
                Double.NEGATIVE_INFINITY, -4.48977148562077, -1.02610125526248,
                -1.02605071667874, -1.02605071667874, -1.02605071667874,
                -1.03056482785045, -1.25774375258839, -10.1919118984465,
                -14.3610776662779, -36.8854257166787, -207.982797410248,
                Double.NEGATIVE_INFINITY, -4.48977148619269, -1.02610125533856,
                -1.02605071675382, -1.02605071675382, -1.02605071675382,
                -1.03056482791626, -1.25774375260676, -10.1919118983687,
                -14.3610776661954, -36.8854257165897, -207.982797410157,
                Double.NEGATIVE_INFINITY, -5.06303223830747, -1.10352479365647,
                -1.10246618511961, -1.10246618510961, -1.10246618509961,
                -1.09771667783496, -1.277451546917, -10.1154055742813,
                -14.2798947030764, -36.7977786851096, -207.89276097567,
                Double.NEGATIVE_INFINITY, -10.319306851091, -1.89726447780565,
                -1.88713323969063, -1.88713323959064, -1.88713323949064,
                -1.79901116629883, -1.5517495344777, -9.52377649539726,
                -13.6461758728665, -36.1058832395906, -207.179360903067,
                Double.NEGATIVE_INFINITY, -407.915263931326, -92.0741486965667,
                -91.4390140875121, -91.4390140812122, -91.4390140749121,
                -85.6074485711828, -55.9448724326987, -4.26414592742706,
                -5.48702910244213, -23.9390140812121, -193.531061878914,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -192.909482431653,
                -191.629183052597, -191.629183039897, -191.629183027197,
                -179.868901724203, -119.842129965938, -6.58436762459768,
                -4.81420181643429, -19.1291830398968, -187.192012911637,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -93.7459165239605,
                -50.0730649512986, -6.46999360045619, -153.123772508741,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -9.79232922847723,
                12.0788985715671, 11.5812654377652, 10.8339144814808,
                10.8288994010071, 10.8288994009571, 10.8288994009071,
                10.7803242531394, 10.4295145124909, 5.48135984709258,
                3.37339376799581, -7.92110059904293, -93.4817334608744,
                Double.NEGATIVE_INFINITY, -0.0859601853683678, -0.585392534506373,
                -0.589903580003582, -0.589903580048582, -0.589903580093582,
                -0.633846918643012, -0.96093463146357, -5.86098223761499,
                -7.96660999719366, -19.2578723300486, -104.817310490375,
                Double.NEGATIVE_INFINITY, -3.20879285302959, -1.50174959856508,
                -1.50177473277087, -1.50177473277137, -1.50177473277187,
                -1.50449496927953, -1.6204566344313, -6.09235141328506,
                -8.17716812915256, -19.4396653577714, -104.988470674707,
                Double.NEGATIVE_INFINITY, -3.24048594351189, -1.50865082858066,
                -1.5086255592893, -1.5086255592893, -1.5086255592893,
                -1.51088261487978, -1.62447207727248, -6.09155615024965,
                -8.17613903416768, -19.4383130593713, -104.986998906157,
                Double.NEGATIVE_INFINITY, -3.24048594382876, -1.50865082864961,
                -1.50862555935774, -1.50862555935774, -1.50862555935774,
                -1.51088261494359, -1.62447207731257, -6.09155615024163,
                -8.17613903415732, -19.4383130593577, -104.986998906143,
                Double.NEGATIVE_INFINITY, -3.24048594414562, -1.50865082871855,
                -1.50862555942618, -1.50862555942618, -1.50862555942618,
                -1.5108826150074, -1.62447207735265, -6.09155615023361,
                -8.17613903414696, -19.4383130593441, -104.986998906128,
                Double.NEGATIVE_INFINITY, -3.5567470448718, -1.5769933225463,
                -1.57646401827787, -1.57646401827287, -1.57646401826787,
                -1.57408926463554, -1.66395669917656, -6.0829337128587,
                -8.16517827725628, -19.4241202682729, -104.971611413553,
                Double.NEGATIVE_INFINITY, -6.37839577298894, -2.16737458634629,
                -2.16230896728878, -2.16230896723878, -2.16230896718878,
                -2.11824793059288, -1.99461711468231, -5.98063059514209,
                -8.0418302838767, -19.2716839672388, -104.808422798977,
                Double.NEGATIVE_INFINITY, -206.455282967166, -48.5347253497866,
                -48.2171580452593, -48.2171580421093, -48.2171580389593,
                -45.3013752870947, -30.4700872178526, -4.62972396521678,
                -5.24116555272431, -14.4671580421093, -99.2631819409602,
                Double.NEGATIVE_INFINITY, -415.811024899426, -99.2225587083823,
                -98.582409018854, -98.582409012504, -98.582409006154,
                -92.7022683546571, -62.6888824755245, -6.06000130485442,
                -5.17491840077273, -12.332409012504, -96.3638239483743,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -538.128629104048, -50.4604970808994,
                -28.6240712945684, -6.82253561914722, -80.1494250732894,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -707.538957995935, -10.1400127656552,
                22.6727549131437, 19.3316576311707, 16.02630958805,
                16.0062391888858, 16.0062391886858, 16.0062391884858,
                15.8128674592119, 14.4652764330531, -0.541775832544143,
                -5.90771981228198, -30.6604274779808, -163.044547647821,
                Double.NEGATIVE_INFINITY, 1.28288909281107, -0.878226865803266,
                -0.896280110558721, -0.896280110738721, -0.896280110918721,
                -1.07121177772466, -2.3274063539922, -17.1741263920276,
                -22.5340942319078, -47.2794646345483, -179.661474111107,
                Double.NEGATIVE_INFINITY, -8.63510109176979, -0.612551498277321,
                -0.612652068795517, -0.612652068797518, -0.612652068799516,
                -0.623467179640015, -1.06623335187524, -14.4859965646102,
                -19.7927767597574, -44.4728455211785, -176.836069827539,
                Double.NEGATIVE_INFINITY, -8.75801364953935, -0.621040848740474,
                -0.620939703819818, -0.620939703819818, -0.620939703819818,
                -0.629910808431951, -1.06353733576945, -14.4672673259086,
                -19.7734499070759, -44.4527849421985, -176.815798179233,
                Double.NEGATIVE_INFINITY, -8.75801365076906, -0.621040848825954,
                -0.620939703903282, -0.620939703903282, -0.620939703903282,
                -0.629910808496975, -1.06353733574308, -14.4672673257219,
                -19.7734499068833, -44.4527849419985, -176.81579817903,
                Double.NEGATIVE_INFINITY, -8.75801365199878, -0.621040848911434,
                -0.620939703986746, -0.620939703986746, -0.620939703986746,
                -0.629910808562, -1.06353733571671, -14.4672673255351,
                -19.7734499066906, -44.4527849417985, -176.815798178828,
                Double.NEGATIVE_INFINITY, -9.99330482092411, -0.712099934474617,
                -0.709981635143263, -0.709981635123265, -0.709981635103263,
                -0.700512677228931, -1.04274275458376, -14.2861405170007,
                -19.5863469583045, -44.2583447303614, -176.619247274113,
                Double.NEGATIVE_INFINITY, -21.4559318477574, -1.8766382007505,
                -1.85636551174101, -1.85636551154101, -1.85636551134101,
                -1.68093599125443, -1.20059801958783, -13.0010057339482,
                -18.2474269165332, -42.8533893210648, -175.195295625289,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -161.751727071971,
                -160.48081864958, -160.48081863698, -160.48081862438,
                -148.872550374116, -91.7264134698618, -4.12084009587947,
                -5.66205456672613, -25.7189138750747, -156.752190345209,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -338.820837914504,
                -336.258950670556, -336.258950645156, -336.258950619756,
                -312.849042389955, -197.209177555288, -6.99097854172609,
                -4.70746350368159, -20.0684744546799, -149.750907225108,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -112.680503436341,
                -56.8507752738205, -6.46990922191543, -117.240530196464,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -10.0008224692444,
                21.6826192727615, 20.012070631775, 18.3593966102146,
                18.3493614106325, 18.3493614105325, 18.3493614104325,
                18.2526755457955, 17.5788800327161, 10.0753538999175,
                7.39238191004862, -4.98397192280081, -71.1760320077207,
                Double.NEGATIVE_INFINITY, 0.820655263431687, -0.259902715875479,
                -0.268929338253207, -0.268929338343207, -0.268929338433207,
                -0.356395171836176, -0.984492459969946, -8.40785247898763,
                -11.0878363989277, -23.460521600248, -89.6515263385275,
                Double.NEGATIVE_INFINITY, -5.02421543018934, -1.01294063344311,
                -1.0129909187022, -1.0129909187032, -1.0129909187042,
                -1.01839847412445, -1.23978156024207, -7.94966316660955,
                -10.6030532641831, -22.9430876448937, -89.1246997980737,
                Double.NEGATIVE_INFINITY, -5.08968321316948, -1.02119681277004,
                -1.02114624030971, -1.02114624030971, -1.02114624030971,
                -1.02563179261578, -1.24244505628453, -7.94431005135408,
                -10.5974013419378, -22.9370688594991, -89.1185754780161,
                Double.NEGATIVE_INFINITY, -5.08968321382425, -1.0211968128527,
                -1.02114624039136, -1.02114624039136, -1.02114624039136,
                -1.02563179268821, -1.24244505631126, -7.94431005130065,
                -10.5974013418814, -22.937068859439, -89.118575477955,
                Double.NEGATIVE_INFINITY, -5.08968321447903, -1.02119681293536,
                -1.02114624047301, -1.02114624047301, -1.02114624047301,
                -1.02563179276064, -1.24244505633799, -7.94431005124721,
                -10.5974013418249, -22.9370688593789, -89.1185754778938,
                Double.NEGATIVE_INFINITY, -5.74541501760894, -1.10481257438419,
                -1.10375342471851, -1.10375342470851, -1.10375342469851,
                -1.09901894576135, -1.27013398443876, -7.89183286564723,
                -10.5419360862991, -22.8779349723276, -89.0583862442032,
                Double.NEGATIVE_INFINITY, -11.7173090018591, -1.92766217835567,
                -1.91752583385092, -1.91752583375092, -1.91752583365092,
                -1.82981107360763, -1.58964208777433, -7.48984594495451,
                -10.113056536247, -22.4160377385128, -88.5869908906249,
                Double.NEGATIVE_INFINITY, -447.798291534951, -83.296698514469,
                -82.6612443032732, -82.6612442969732, -82.6612442906732,
                -76.8571101655414, -48.2840417134143, -4.48125502642318,
                -5.25186226184651, -15.2802919160208, -80.7969301510879,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -172.121870099132,
                -170.840926477158, -170.840926464458, -170.840926451758,
                -159.135972336857, -101.316039919524, -6.20694041274283,
                -5.06518289372058, -12.7456883692198, -77.586904754434,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -59.9276502802462,
                -32.0127861989857, -6.82235317303317, -62.2076636603075,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -635.788972362232, -10.3490581978316,
                20.6924464332805, 19.8571721127873, 19.0308351020071,
                19.0258175022161, 19.0258175021661, 19.0258175021161,
                18.9774745697976, 18.6405768132579, 14.8888137468586,
                13.5473277519241, 7.3591508354994, -25.7368792069606,
                Double.NEGATIVE_INFINITY, 0.251162310532238, -0.289116679121345,
                -0.293629990310209, -0.293629990355209, -0.293629990400209,
                -0.337362907101694, -0.651411551168579, -4.36309156067742,
                -5.70308352064747, -11.8894261213076, -44.9849284904474,
                Double.NEGATIVE_INFINITY, -3.48147639986413, -1.47583900149101,
                -1.47586414412056, -1.47586414412106, -1.47586414412156,
                -1.47856792183168, -1.58925946489049, -4.94420026807423,
                -6.27089531686103, -12.4409125072163, -45.5317185838063,
                Double.NEGATIVE_INFINITY, -3.51794077022269, -1.48369757002297,
                -1.48367228379281, -1.48367228379281, -1.48367228379281,
                -1.48591505994584, -1.59432169178022, -4.94525418931499,
                -6.27179983460684, -12.4416335933875, -45.532386902646,
                Double.NEGATIVE_INFINITY, -3.5179407705872, -1.48369757010143,
                -1.48367228387076, -1.48367228387076, -1.48367228387076,
                -1.48591506001918, -1.59432169183071, -4.9452541893254,
                -6.27179983461576, -12.4416335933946, -45.5323869026526,
                Double.NEGATIVE_INFINITY, -3.51794077095172, -1.48369757017988,
                -1.48367228394871, -1.48367228394871, -1.48367228394871,
                -1.48591506009252, -1.5943216918812, -4.94525418933581,
                -6.27179983462467, -12.4416335934016, -45.5323869026591,
                Double.NEGATIVE_INFINITY, -3.88125840246745, -1.56095718085507,
                -1.56042760602223, -1.56042760601724, -1.56042760601223,
                -1.55806036654365, -1.64361788588236, -4.95446732648659,
                -6.27951893681254, -12.4475183798268, -45.5377440157646,
                Double.NEGATIVE_INFINITY, -7.09256078123641, -2.19773736948468,
                -2.19266919723231, -2.19266919718231, -2.19266919713231,
                -2.14881181711066, -2.02872732419401, -4.9788292527841,
                -6.29043454843035, -12.4419251495633, -45.5274017256193,
                Double.NEGATIVE_INFINITY, -226.515324336707, -44.2645278264658,
                -43.9468007208679, -43.9468007177179, -43.9468007145679,
                -41.044733652002, -26.7581994259384, -4.85680608244287,
                -5.24210970015454, -10.2563245272417, -43.0146436447752,
                Double.NEGATIVE_INFINITY, -454.291170422724, -88.9632403914618,
                -88.3227685804749, -88.3227685741249, -88.3227685677749,
                -82.4702915103247, -53.5603253016579, -6.00577554826739,
                -5.43489678875627, -9.27514952650586, -41.695757719113,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -726.387421449768,
                -721.228523759986, -721.228523708826, -721.228523657666,
                -674.070306671857, -440.432292706745, -33.733553214826,
                -19.7761211741958, -7.18090466121951, -34.8735599048567,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -323.41893210014, -10.69897501794,
                28.8680554128451, 22.5663689348491, 18.8960228630368,
                18.8759423798511, 18.8759423796511, 18.8759423794511,
                18.6834936147365, 17.3889588296807, 5.90197527971038,
                2.4857841641932, -11.1240576203489, -63.0199260201117,
                Double.NEGATIVE_INFINITY, 1.4246781979393, -0.920292682284018,
                -0.938354995878287, -0.938354996058287, -0.938354996238287,
                -1.11245032381182, -2.31892584040327, -13.6712963018974,
                -17.0836675392926, -30.6893315585583, -82.5842584513128,
                Double.NEGATIVE_INFINITY, -10.0609804821623, -0.610112157243385,
                -0.61021276147356, -0.61021276147556, -0.610212761477561,
                -0.620962498495904, -1.04371052575474, -11.1980244998106,
                -14.5763988219204, -28.1448807302256, -80.0314282106071,
                Double.NEGATIVE_INFINITY, -10.2025674802395, -0.619161637487061,
                -0.619060424760109, -0.619060424760109, -0.619060424760109,
                -0.6279748180827, -1.04191691858316, -11.182769583926,
                -14.5607619182274, -28.1288260500091, -80.0152793796908,
                Double.NEGATIVE_INFINITY, -10.2025674816559, -0.619161637578115,
                -0.619060424849144, -0.619060424849144, -0.619060424849144,
                -0.627974818153383, -1.04191691856579, -11.182769583774,
                -14.5607619180716, -28.1288260498491, -80.0152793795298,
                Double.NEGATIVE_INFINITY, -10.2025674830723, -0.619161637669167,
                -0.619060424938178, -0.619060424938178, -0.619060424938178,
                -0.627974818224065, -1.04191691854841, -11.182769583622,
                -14.5607619179158, -28.1288260496891, -80.0152793793689,
                Double.NEGATIVE_INFINITY, -11.6242689857939, -0.715487950127079,
                -0.713368567806636, -0.713368567786636, -0.713368567766636,
                -0.703929523929844, -1.02981235587791, -11.0360519326099,
                -14.4102243887855, -27.9741107552866, -79.8596225779591,
                Double.NEGATIVE_INFINITY, -24.7353839936904, -1.8982262337225,
                -1.87794332507882, -1.87794332487882, -1.87794332467882,
                -1.70332334657273, -1.23667276234176, -10.0313945427878,
                -13.3711880958658, -26.8974745748788, -78.7745128344774,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -146.889371572022,
                -145.617823516666, -145.617823504066, -145.617823491466,
                -134.06407248592, -79.0006754537991, -4.33528237899182,
                -5.30675149645607, -16.2428235040659, -67.5361274185748,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -304.531977671767,
                -301.96880107787, -301.968801052469, -301.968801027069,
                -278.668850251262, -167.247521401965, -6.42975170238053,
                -4.95649882179183, -13.2188010524695, -63.9095404817243,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -71.6918866371786,
                -35.9925257838487, -6.82205113747507, -49.0768877731744,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -575.688766937733, -10.5586024374367,
                28.0048196212453, 24.8539763822474, 23.0188033463412,
                23.0087631047483, 23.0087631046483, 23.0087631045483,
                22.9125387221911, 22.2652713296632, 16.521779554678,
                14.8136839969194, 8.00876310464835, -17.939171095233,
                Double.NEGATIVE_INFINITY, 0.999105796766039, -0.173379643345618,
                -0.182410800142753, -0.182410800232753, -0.182410800322753,
                -0.26945846410952, -0.872696222405242, -6.54888145315231,
                -8.25506707184992, -15.0578990814827, -41.00536252786,
                Double.NEGATIVE_INFINITY, -5.731431424972, -1.00599726251255,
                -1.00604756462764, -1.00604756462864, -1.00604756462964,
                -1.01142243313881, -1.22279644676823, -6.29995343379614,
                -7.98914059485104, -14.7733815490036, -40.7166552891944,
                Double.NEGATIVE_INFINITY, -5.80659539917126, -1.01489247779505,
                -1.01484187143157, -1.01484187143157, -1.01484187143157,
                -1.01929906809287, -1.2262701183431, -6.2966964510145,
                -7.98569261816522, -14.7697246840561, -40.7129513488969,
                Double.NEGATIVE_INFINITY, -5.80659539992296, -1.01489247788406,
                -1.01484187151958, -1.01484187151958, -1.01484187151958,
                -1.0192990681717, -1.2262701183779, -6.296696450982,
                -7.9856926181308, -14.7697246840196, -40.7129513488599,
                Double.NEGATIVE_INFINITY, -5.80659540067466, -1.01489247797307,
                -1.01484187160758, -1.01484187160758, -1.01484187160758,
                -1.01929906825052, -1.2262701184127, -6.29669645094949,
                -7.98569261809638, -14.7697246839831, -40.7129513488229,
                Double.NEGATIVE_INFINITY, -6.55890801294062, -1.10451749510722,
                -1.103457803947, -1.103457803937, -1.103457803927,
                -1.0987382820086, -1.26167969798263, -6.26479948634863,
                -7.95188571443645, -14.733828897687, -40.6765848090232,
                Double.NEGATIVE_INFINITY, -13.375147004482, -1.956568124498,
                -1.94642667017616, -1.94642667007616, -1.94642666997616,
                -1.85911668092312, -1.62579138880763, -6.02315227903065,
                -7.69304905556967, -14.4561922950762, -40.3947114248755,
                Double.NEGATIVE_INFINITY, -498.264341534234, -75.9794532616565,
                -75.3436792339785, -75.3436792276785, -75.3436792213786,
                -69.5668037186054, -42.0351052025451, -4.70240866514148,
                -5.18814322387361, -10.6561792276785, -36.3028311849329,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -155.108603782588,
                -153.82701548564, -153.82701547294, -153.82701546024,
                -142.177040072336, -86.4663756476876, -6.05749079789514,
                -5.32086435760079, -9.45201547293961, -34.797385187567,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -723.09064292588, -39.6151217024879,
                -21.765441275823, -7.18020395263614, -28.3076222704858,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -293.475218540246, -10.9101362900983,
                27.1400440180057, 25.5646223985068, 24.6470358805537,
                24.6420157597572, 24.6420157597072, 24.6420157596572,
                24.5939035684786, 24.2702698722147, 21.3985239847221,
                20.5444762058428, 17.1420157597072, 4.16804865976655,
                Double.NEGATIVE_INFINITY, 0.503234279776473, -0.083008440279355,
                -0.0875240186779224, -0.0875240187229224, -0.0875240187679224,
                -0.131047850661306, -0.432666729809167, -3.2707593451827,
                -4.12385215453151, -7.52526815934792, -20.4989998825366,
                Double.NEGATIVE_INFINITY, -3.81464001747987, -1.45192293625015,
                -1.45194808730769, -1.45194808730819, -1.45194808730869,
                -1.45463552156328, -1.56032252837799, -4.09890102189195,
                -4.9434946024194, -8.33561507949569, -21.3072519495911,
                Double.NEGATIVE_INFINITY, -3.85645437384533, -1.46060291315723,
                -1.46057760997549, -1.46057760997549, -1.46057760997549,
                -1.46280620830614, -1.56629173343125, -4.10150489976696,
                -4.94600298334231, -8.33801901628774, -21.3096323487081,
                Double.NEGATIVE_INFINITY, -3.8564543742633, -1.46060291324385,
                -1.46057761006161, -1.46057761006161, -1.46057761006161,
                -1.46280620838767, -1.56629173349077, -4.10150489979282,
                -4.94600298336722, -8.3380190163116, -21.3096323487318,
                Double.NEGATIVE_INFINITY, -3.85645437468126, -1.46060291333047,
                -1.46057761014772, -1.46057761014772, -1.46057761014772,
                -1.46280620846919, -1.56629173355028, -4.10150489981868,
                -4.94600298339212, -8.33801901633546, -21.3096323487554,
                Double.NEGATIVE_INFINITY, -4.2727710201143, -1.5455757611976,
                -1.54504591561749, -1.54504591561249, -1.54504591560749,
                -1.54268615464829, -1.6241568626353, -4.1257167568183,
                -4.96925987086221, -8.36023146248749, -21.3316094181556,
                Double.NEGATIVE_INFINITY, -7.93375527889887, -2.22446583890689,
                -2.21939511174597, -2.21939511169597, -2.21939511164597,
                -2.17574011711945, -2.0590774710617, -4.25775791617321,
                -5.09270630444272, -8.47427792419596, -21.4435374890956,
                Double.NEGATIVE_INFINITY, -251.872493726154, -40.7300495898648,
                -40.4121625760259, -40.4121625728759, -40.4121625697259,
                -37.5237248183393, -23.7578755603092, -5.09152729160736,
                -5.33439457097342, -8.06841257287589, -20.8917385515031,
                Double.NEGATIVE_INFINITY, -503.800552106131, -80.5980773155999,
                -79.9572831671256, -79.9572831607756, -79.9572831544256,
                -74.1322954604738, -46.2769632481496, -6.07252082325334,
                -5.70420760310617, -7.76978316077558, -20.4424680180893,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -642.712026314968,
                -637.550532281599, -637.550532230449, -637.550532179299,
                -590.613845289434, -365.505751716992, -23.7679911053745,
                -14.843150892042, -7.5505322304486, -18.1142413893734,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -152.549295309665, -11.2667541845913,
                33.5086506389405, 18.1802829292348, 14.0869381978855,
                14.0668476239205, 14.0668476237205, 14.0668476235205,
                13.8753159681827, 12.6313783729946, 3.7525162935125,
                1.57675176947103, -5.93315237627955, -26.5618150366955,
                Double.NEGATIVE_INFINITY, 1.55927497485616, -0.993137309247725,
                -1.01120869775758, -1.01120869793758, -1.01120869811758,
                -1.18447299646056, -2.34354166672303, -11.1085807106682,
                -13.2819026507855, -20.7894205034932, -41.4176594152421,
                Double.NEGATIVE_INFINITY, -11.7689986643559, -0.607112167974982,
                -0.607212805934093, -0.607212805936094, -0.607212805938094,
                -0.61789762702761, -1.02163286545188, -8.77364689311785,
                -10.9252298363103, -18.4115096809361, -39.0359772295493,
                Double.NEGATIVE_INFINITY, -11.9326960984571, -0.616716358892529,
                -0.616615078308143, -0.616615078308143, -0.616615078308143,
                -0.62547316371645, -1.02072150973303, -8.76135323395912,
                -10.9126919187616, -18.3987331340855, -39.0231583078324,
                Double.NEGATIVE_INFINITY, -11.9326961000946, -0.616716358989102,
                -0.616615078402699, -0.616615078402699, -0.616615078402699,
                -0.625473163792737, -1.02072150972444, -8.76135323383672,
                -10.9126919186367, -18.3987331339583, -39.0231583077047,
                Double.NEGATIVE_INFINITY, -11.9326961017321, -0.616716359085672,
                -0.616615078497247, -0.616615078497247, -0.616615078497247,
                -0.625473163869017, -1.02072150971586, -8.76135323371431,
                -10.9126919185119, -18.398733133831, -39.0231583075771,
                Double.NEGATIVE_INFINITY, -13.5751780406539, -0.718265852302945,
                -0.716145386261402, -0.716145386241404, -0.716145386221402,
                -0.706736114616671, -1.01711553562274, -8.64392422419803,
                -10.7928203250739, -18.2764752473525, -38.900476672432,
                Double.NEGATIVE_INFINITY, -28.6449683699709, -1.91966415641055,
                -1.89937102127274, -1.89937102107275, -1.89937102087274,
                -1.72555553631508, -1.27211463299037, -7.87451600173282,
                -10.0014288472914, -17.4636071321839, -38.0837948192608,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -134.364202304993,
                -133.092014187668, -133.092014175068, -133.092014162468,
                -121.592437341153, -68.52026298393, -4.55238231974326,
                -5.16489313233103, -11.1475697306233, -31.5050332441925,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -276.117712397109,
                -273.553245588494, -273.553245563094, -273.553245537694,
                -250.362560239726, -142.974273930093, -6.15965052223721,
                -5.20890762337129, -9.66435667420527, -29.7506210409277,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -46.941278633726,
                -24.1049837745084, -7.17924716092614, -23.4687234717942,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -268.201926951781, -11.122663241132,
                32.8152427002272, 25.1510588453743, 23.1043864796997,
                23.0943411927172, 23.0943411926172, 23.0943411925172,
                22.9985753648483, 22.3766065672542, 17.9371755275132,
                16.8492932654924, 13.0943411926171, 2.78000986240918,
                Double.NEGATIVE_INFINITY, 1.15712780046224, -0.119078341589702,
                -0.128114035844632, -0.128114035934631, -0.128114036024632,
                -0.214746185196118, -0.794280520327357, -5.17680004229992,
                -6.26346101235858, -10.0172199387124, -20.3313393945869,
                Double.NEGATIVE_INFINITY, -6.57916643635179, -0.998223188161322,
                -0.998273507140878, -0.998273507141878, -0.998273507142878,
                -1.00361591768764, -1.20548353689977, -5.08149055073276,
                -6.15728202232896, -9.90042194464188, -20.2126557189485,
                Double.NEGATIVE_INFINITY, -6.66572285651053, -1.00773298672825,
                -1.00768234643606, -1.00768234643606, -1.00768234643606,
                -1.01211138914021, -1.2097355621485, -5.08005142426155,
                -6.15572076666277, -9.89874137432474, -20.2109539611982,
                Double.NEGATIVE_INFINITY, -6.66572285737612, -1.00773298682338,
                -1.00768234653018, -1.00768234653018, -1.00768234653018,
                -1.0121113892252, -1.20973556219105, -5.08005142424719,
                -6.15572076664719, -9.89874137430796, -20.2109539611812,
                Double.NEGATIVE_INFINITY, -6.66572285824171, -1.00773298691851,
                -1.0076823466243, -1.0076823466243, -1.0076823466243,
                -1.01211138931018, -1.2097355622336, -5.08005142423283,
                -6.1557207666316, -9.89874137429119, -20.2109539611642,
                Double.NEGATIVE_INFINITY, -7.5316113586005, -1.10315526442502,
                -1.10209503140424, -1.10209503139425, -1.10209503138424,
                -1.09739039558188, -1.25258010608491, -5.06598445037256,
                -6.14043250081048, -9.88225996194981, -20.1942606744896,
                Double.NEGATIVE_INFINITY, -15.346683702321, -1.98403159554081,
                -1.9738850279719, -1.9738850278719, -1.9738850277719,
                -1.88697728549307, -1.66025683383072, -4.96145751820194,
                -6.02491394098121, -9.75600308342746, -20.0660969269659,
                Double.NEGATIVE_INFINITY, -560.886019028464, -69.8343082755838,
                -69.1982142169213, -69.1982142106213, -69.1982142043213,
                -63.4484257936637, -36.9123386150525, -4.92839828295909,
                -5.23465368925298, -8.22599198839912, -18.4047237451837,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -141.037344906144,
                -139.755111501837, -139.755111489137, -139.755111476437,
                -128.159768827453, -74.465625672636, -6.0583139687082,
                -5.58294251927524, -7.81066704469223, -17.8537992280535,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -605.763613530012, -27.4291026204021,
                -16.0109551907933, -7.54808688400215, -15.6928250394362,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -140.023485980667, -11.4838541253427,
                32.0907509488672, 28.2586590214408, 27.2353228386034,
                27.2303001951122, 27.2303001950622, 27.2303001950122,
                27.1824172811778, 26.8714328823807, 24.6517173625102,
                24.1077762314998, 22.2303001950622, 17.0731345299582,
                Double.NEGATIVE_INFINITY, 0.707636117657848, 0.0695330466318768,
                0.0650151995044119, 0.0650151994594123, 0.0650151994144118,
                0.0216991248286692, -0.26806804273695, -2.45932780372323,
                -3.00265828875256, -4.87953775192948, -10.0365974798667,
                Double.NEGATIVE_INFINITY, -4.2201572594501, -1.42968563535487,
                -1.42971079484465, -1.42971079484515, -1.42971079484565,
                -1.43238200011803, -1.53331580972409, -3.47131931664059,
                -4.00921505243869, -5.88078501359515, -11.0369019007484,
                Double.NEGATIVE_INFINITY, -4.26809105609023, -1.43909612119909,
                -1.439070801053, -1.439070801053, -1.439070801053,
                -1.44128532240507, -1.54009740890922, -3.47525533996574,
                -4.01309001116635, -5.88460031499734, -11.0407066084341,
                Double.NEGATIVE_INFINITY, -4.26809105656935, -1.43909612129298,
                -1.43907080114638, -1.43907080114638, -1.43907080114638,
                -1.44128532249389, -1.54009740897681, -3.47525534000488,
                -4.01309001120488, -5.88460031503527, -11.0407066084719,
                Double.NEGATIVE_INFINITY, -4.26809105704847, -1.43909612138687,
                -1.43907080123976, -1.43907080123976, -1.43907080123976,
                -1.4412853225827, -1.54009740904441, -3.47525534004403,
                -4.01309001124342, -5.88460031507321, -11.0407066085097,
                Double.NEGATIVE_INFINITY, -4.74518988343352, -1.53096183634578,
                -1.53043171983539, -1.53043171983039, -1.53043171982539,
                -1.52807940192421, -1.60567425717573, -3.51237642931955,
                -4.04960045453851, -5.92051418510818, -11.0765145413781,
                Double.NEGATIVE_INFINITY, -8.92986498305853, -2.24853892966844,
                -2.24346564588399, -2.24346564583399, -2.24346564578399,
                -2.20001177464458, -2.0866515488134, -3.73725189099901,
                -4.26898010238865, -6.13452467361177, -11.289571595381,
                Double.NEGATIVE_INFINITY, -283.311889443959, -37.7860340675188,
                -37.4679870381876, -37.4679870350376, -37.4679870318876,
                -34.5930928265588, -21.3250492372532, -5.33307907120652,
                -5.48620677435346, -6.98187592392653, -12.0712418023188,
                Double.NEGATIVE_INFINITY, -565.786168145953, -73.7111212102353,
                -73.0700045080817, -73.0700045017317, -73.0700044953817,
                -67.2723331708896, -40.4252615934813, -6.22160574151743,
                -5.98392001680095, -7.09778227950944, -12.1193483711901,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -575.881024102726,
                -570.716931981057, -570.716931929907, -570.716931878757,
                -524.00038088598, -307.046917475135, -17.8796620203296,
                -12.1705883055252, -7.93915415212964, -12.0115232298466,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -465.222462129108, -76.1296860162208, -11.8598700885585,
                35.1049527112406, 6.12814968046391, 1.79828282790407,
                1.77818720601373, 1.77818720581373, 1.77818720561373,
                1.58711192232549, 0.367590252158628, -7.46758932798292,
                -9.20423788695676, -14.7903552891101, -27.8658578578762,
                Double.NEGATIVE_INFINITY, 1.62460073636862, -1.04149436115107,
                -1.05957028939894, -1.05957028957894, -1.05957028975893,
                -1.23242105289248, -2.36861618258576, -10.0988703247353,
                -11.8335653833812, -17.4178772198569, -30.493094630552,
                Double.NEGATIVE_INFINITY, -12.7469084969906, -0.605434974652916,
                -0.605535629482851, -0.605535629484855, -0.605535629486845,
                -0.616188163243585, -1.01077708272202, -7.8071948267424,
                -9.52450373246992, -15.0927460344143, -28.1654255382777,
                Double.NEGATIVE_INFINITY, -12.923164585539, -0.615313889361069,
                -0.615212574828781, -0.615212574828781, -0.615212574828774,
                -0.624042656588266, -1.01029892210267, -7.79622412242878,
                -9.51333767812545, -15.0813994235039, -28.1540504115605,
                Double.NEGATIVE_INFINITY, -12.9231645873021, -0.615313889460396,
                -0.615212574926083, -0.615212574926083, -0.615212574926076,
                -0.624042656667342, -1.01029892209842, -7.7962241223196,
                -9.51333767801432, -15.081399423391, -28.1540504114472,
                Double.NEGATIVE_INFINITY, -12.9231645890652, -0.615313889559687,
                -0.615212575023356, -0.615212575023356, -0.61521257502335,
                -0.62404265674639, -1.01029892209414, -7.7962241222104,
                -9.51333767790317, -15.081399423278, -28.154050411334,
                Double.NEGATIVE_INFINITY, -14.6910747509391, -0.719452298057213,
                -0.717331289880441, -0.717331289860439, -0.71733128984043,
                -0.707936851427007, -1.0108665763845, -7.69186633861365,
                -9.40702639398045, -14.9732825736794, -28.0456484036647,
                Double.NEGATIVE_INFINITY, -30.8758658745671, -1.93029762632384,
                -1.90999937536488, -1.90999937516488, -1.90999937496488,
                -1.73658425515917, -1.28957511585446, -7.02624593615528,
                -8.72382448857088, -14.2738305771708, -27.3436299845172,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -128.833779640757,
                -127.561271331469, -127.561271318869, -127.561271306269,
                -116.088653690551, -63.9791894576277, -4.66208872286576,
                -5.14849707197585, -9.57905244042114, -22.472053843757,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -263.70980719323,
                -261.144694952766, -261.144694927365, -261.144694901965,
                -238.008384387241, -132.569934251227, -6.10055320156178,
                -5.3367213408081, -8.61171467554536, -21.3222149134509,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -38.5309242770158,
                -20.2637294781695, -7.36085434099441, -17.5163382628761,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -185.215758972273, -11.4100681404371,
                34.5863681374973, 20.0979666221089, 17.933033195829,
                17.9229853848838, 17.9229853847838, 17.9229853846838,
                17.8274477430397, 17.2176869079563, 13.3000971178855,
                12.4317728383986, 9.63871413732193, 3.10096285293887,
                Double.NEGATIVE_INFINITY, 1.23110641438866, -0.101941134371181,
                -0.110979098495118, -0.110979098585116, -0.110979098675113,
                -0.197404480241886, -0.765502045088528, -4.63062911616328,
                -5.49797664548625, -8.29013256372408, -14.8277412690717,
                Double.NEGATIVE_INFINITY, -7.0648704160054, -0.994133654836538,
                -0.994183982251506, -0.994183982252508, -0.994183982253503,
                -0.999510249131873, -1.19680470887109, -4.59501358088128,
                -5.45366803374504, -8.23778918471724, -14.7741289366489,
                Double.NEGATIVE_INFINITY, -7.15786721440848, -1.00394186631949,
                -1.00389120905335, -1.00389120905335, -1.00389120905335,
                -1.00830624993309, -1.20143438269029, -4.59439698285335,
                -5.45295376070169, -8.2369846333909, -14.7733101274192,
                Double.NEGATIVE_INFINITY, -7.15786721533846, -1.00394186641759,
                -1.00389120915044, -1.00389120915044, -1.00389120915043,
                -1.00830625002106, -1.2014343827366, -4.59439698284719,
                -5.45295376069456, -8.23698463338287, -14.773310127411,
                Double.NEGATIVE_INFINITY, -7.15786721626844, -1.00394186651569,
                -1.00389120924753, -1.00389120924753, -1.00389120924752,
                -1.00830625010904, -1.20143438278292, -4.59439698284105,
                -5.45295376068743, -8.23698463337485, -14.7733101274028,
                Double.NEGATIVE_INFINITY, -8.08799475029939, -1.10218352385845,
                -1.10112301977006, -1.10112301976006, -1.10112301975006,
                -1.09642580054334, -1.24789066302209, -4.58839054413667,
                -5.44597057182007, -8.22909866166955, -14.7652815766622,
                Double.NEGATIVE_INFINITY, -16.4700367196951, -1.99725259557348,
                -1.987103470094, -1.987103469994, -1.987103469894,
                -1.90039590999114, -1.67689134033879, -4.5452267504892,
                -5.394016026697, -8.16901907099697, -14.7039187746702,
                Double.NEGATIVE_INFINITY, -597.371039691018, -67.1290115044475,
                -66.4927573498039, -66.4927573435039, -66.4927573372039,
                -60.7564485293448, -34.7017164128831, -5.04316604550212,
                -5.28637022005717, -7.50164790427981, -13.9481486059477,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -134.903203205609,
                -133.620647085376, -133.620647072676, -133.620647059976,
                -122.052491802614, -69.3332667346073, -6.09857620977459,
                -5.71666027939775, -7.35415694676638, -13.7094070657192,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -556.623270618121, -23.322617888964,
                -14.1890204895409, -7.73758292095331, -12.8153248818942,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -687.538773991774, -98.6840714343412, -11.7812260184234,
                34.0070380398664, 26.7628372821722, 25.6803705690322,
                25.6753466635597, 25.6753466635097, 25.6753466634597,
                25.6275778426376, 25.3226974250959, 23.3639025300605,
                22.929740390317, 21.5332110397787, 18.2643353975872,
                Double.NEGATIVE_INFINITY, 0.798397532121869, 0.131873757741947,
                0.127354775679978, 0.12735477563498, 0.127354775589981,
                0.0841420848065946, -0.199906697616727, -2.1324702331541,
                -2.56614399781559, -3.9622219569345, -7.23102630960829,
                Double.NEGATIVE_INFINITY, -4.45448824425087, -1.41911986366644,
                -1.41914502737393, -1.41914502737443, -1.41914502737493,
                -1.42180816081411, -1.52045539068372, -3.21955982668882,
                -3.64888705312069, -5.04094762860679, -8.30911750457264,
                Double.NEGATIVE_INFINITY, -4.50583262306212, -1.42886994901763,
                -1.42884462038456, -1.42884462038456, -1.42884462038456,
                -1.43105214082443, -1.52761620720303, -3.22409750728456,
                -3.65337589620873, -5.04539133255334, -8.31355407956748,
                Double.NEGATIVE_INFINITY, -4.50583262357533, -1.4288699491149,
                -1.42884462048132, -1.42884462048132, -1.42884462048132,
                -1.43105214091663, -1.5276162072744, -3.2240975073297,
                -3.65337589625338, -5.04539133259754, -8.3135540796116,
                Double.NEGATIVE_INFINITY, -4.50583262408854, -1.42886994921216,
                -1.42884462057808, -1.42884462057808, -1.42884462057808,
                -1.43105214100884, -1.52761620734577, -3.22409750737484,
                -3.65337589629803, -5.04539133264174, -8.31355407965573,
                Double.NEGATIVE_INFINITY, -5.01685312342084, -1.52394751020037,
                -1.52341725815618, -1.52341725815118, -1.52341725814617,
                -1.52106864854282, -1.59680107978219, -3.26705102033948,
                -3.69584103418118, -5.08740507910592, -8.35549653660224,
                Double.NEGATIVE_INFINITY, -9.49617808451574, -2.25978602245491,
                -2.25471145971517, -2.25471145966517, -2.25471145961517,
                -2.21135767966375, -2.09960539483757, -3.53377309991277,
                -3.95816773801667, -5.34566926016666, -8.61311911200326,
                Double.NEGATIVE_INFINITY, -301.61929661317, -36.4982825198852,
                -36.1801554425634, -36.1801554394134, -36.1801554362634,
                -33.3120010323339, -20.284634974103, -5.45535979041256,
                -5.57696187769008, -6.6846007198014, -9.90785107063537,
                Double.NEGATIVE_INFINITY, -602.044652606005, -70.720157706295,
                -70.0788796461788, -70.0788796398288, -70.0788796334788,
                -64.2948020047976, -37.9351894707942, -6.31784420837784,
                -6.12688624318942, -6.94563457687373, -10.1232596363501,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -547.36847934342,
                -542.203087524183, -542.203087473033, -542.203087421883,
                -495.596084646679, -282.58502145186, -15.9346950872811,
                -11.3678963875695, -8.14217760327575, -10.6810485837462,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -669.681865082712,
                -350.054533497334, -55.627182218617, -12.1757595106581,
                36.0249881374384, -19.6586235448477, -24.1910796920372,
                -24.2111793534855, -24.2111793536855, -24.2111793538855,
                -24.4018905824648, -25.6022893650293, -32.7043315219098,
                -34.154516078299, -38.5658718609441, -47.6686069681295,
                Double.NEGATIVE_INFINITY, 1.67609965579058, -1.08618018576263,
                -1.10425974689593, -1.10425974707596, -1.10425974725595,
                -1.2767806280396, -2.3950622382234, -9.39868232489883,
                -10.8472330194855, -15.2571434975208, -24.3596706036308,
                Double.NEGATIVE_INFINITY, -13.5963081974916, -0.604018918881621,
                -0.604119587211301, -0.60411958721329, -0.60411958721528,
                -0.614746372617844, -1.00218514861376, -7.12984881046384,
                -8.56385813500836, -12.9609054020159, -22.0615812985548,
                Double.NEGATIVE_INFINITY, -13.7834231180538, -0.614116210650309,
                -0.614014868950477, -0.614014868950477, -0.614014868950477,
                -0.622822619591659, -1.00204967843163, -7.11987113335962,
                -8.55371707172552, -12.9506198082736, -22.0512749047051,
                Double.NEGATIVE_INFINITY, -13.7834231199255, -0.614116210751831,
                -0.614014869049981, -0.614014869049981, -0.614014869049981,
                -0.622822619672974, -1.00204967843084, -7.1198711332604,
                -8.55371707162467, -12.9506198081712, -22.0512749046026,
                Double.NEGATIVE_INFINITY, -13.7834231217972, -0.614116210853354,
                -0.614014869149486, -0.614014869149486, -0.614014869149486,
                -0.622822619754288, -1.00204967843001, -7.11987113316118,
                -8.55371707152381, -12.950619808069, -22.0512749045001,
                Double.NEGATIVE_INFINITY, -15.6597965679173, -0.720313353107343,
                -0.718191911090457, -0.718191911070477, -0.718191911050468,
                -0.70880931387785, -1.00591920025502, -7.0253185848795,
                -8.45753066144127, -12.852988093378, -21.9534351887339,
                Double.NEGATIVE_INFINITY, -32.8098248673408, -1.93875490180403,
                -1.91845255695202, -1.91845255675202, -1.91845255655201,
                -1.74535682921871, -1.30341216416994, -6.43701291694859,
                -7.85452023728791, -12.2369699277359, -21.3355450134132,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -124.716977001566,
                -123.444212461402, -123.444212448802, -123.444212436202,
                -111.993101075578, -60.6385095345195, -4.75042676013967,
                -5.15493976293374, -8.64130059526977, -17.6109150141971,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -254.527346086106,
                -251.96171734433, -251.96171731893, -251.96171729353,
                -228.868783343704, -124.959201479022, -6.08099377338141,
                -5.43983522258034, -8.00120110460725, -16.8376948352765,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -33.177195214489,
                -17.8966349133561, -7.50807149105535, -14.4808755861116,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -138.857441654322, -11.6445919852433,
                35.622434201762, 7.780628360619, 5.51440028702424,
                5.50435045630007, 5.50435045620007, 5.50435045610007,
                5.40899484181043, 4.80879545052819, 1.25777437208794,
                0.532682093893342, -1.67299579742924, -6.22436335102192,
                Double.NEGATIVE_INFINITY, 1.28846618778127, -0.0926737329953369,
                -0.10171351356199, -0.101713513652001, -0.101713513741998,
                -0.187973954133824, -0.747114759225724, -4.24892480256344,
                -4.97320014985679, -7.17815538887444, -11.7294189419294,
                Double.NEGATIVE_INFINITY, -7.48693748832041, -0.990792849015406,
                -0.990843183180246, -0.990843183181241, -0.990843183182236,
                -0.996156575883518, -1.18987596388148, -4.25370779480652,
                -4.97071245707878, -7.16923609058256, -11.719574038852,
                Double.NEGATIVE_INFINITY, -7.58548918978163, -1.00083573607989,
                -1.00078506522998, -1.00078506522998, -1.00078506522998,
                -1.00518894055057, -1.19480246997055, -4.25371319743455,
                -4.9706361666175, -7.16908753489152, -11.7194150831073,
                Double.NEGATIVE_INFINITY, -7.58548919076716, -1.00083573618035,
                -1.00078506532942, -1.00078506532942, -1.00078506532942,
                -1.00518894064092, -1.19480247001985, -4.25371319743464,
                -4.97063616661677, -7.16908753489005, -11.7194150831057,
                Double.NEGATIVE_INFINITY, -7.58548919175271, -1.00083573628081,
                -1.00078506542887, -1.00078506542887, -1.00078506542887,
                -1.00518894073127, -1.19480247006913, -4.25371319743472,
                -4.97063616661603, -7.1690875348886, -11.7194150831042,
                Double.NEGATIVE_INFINITY, -8.57103774281565, -1.10129613541068,
                -1.10023541440223, -1.10023541439224, -1.10023541438224,
                -1.09554411579593, -1.24409905898452, -4.25379875129676,
                -4.96990478957764, -7.16763350554601, -11.717857053224,
                Double.NEGATIVE_INFINITY, -17.4431319167028, -2.00759693393439,
                -1.99744576150839, -1.99744576140839, -1.99744576130838,
                -1.91089789764173, -1.68992556511735, -4.25672594150667,
                -4.96547960167634, -7.15670444690033, -11.705991989739,
                Double.NEGATIVE_INFINITY, -629.309142181167, -65.1189524511409,
                -64.4825701810592, -64.4825701747592, -64.4825701684592,
                -58.7570144881473, -33.0797187176179, -5.135677330428,
                -5.33793383182503, -7.08111424799304, -11.5659214574567,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -130.368592856833,
                -129.085778485945, -129.085778473245, -129.085778460545,
                -117.539311485632, -65.5845205532909, -6.14541670047083,
                -5.8248374250703, -7.10552036608375, -11.5237672314184,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -521.096877139235, -20.7268987675922,
                -13.0866186170257, -7.89233690587535, -11.3787389534035,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -547.025582331288, -75.6338456643404, -12.0274208298013,
                35.1783979010735, 21.2574949805019, 20.1243809437046,
                20.1193560283425, 20.1193560282925, 20.1193560282425,
                20.0716782210976, 19.7715785254565, 17.9960679862364,
                17.6335218471391, 16.5306829014778, 14.2549991246815,
                Double.NEGATIVE_INFINITY, 0.866981063973071, 0.176411103584769,
                0.171891213301443, 0.171891213256437, 0.171891213211438,
                0.128760993015526, -0.150809409530424, -1.90171443119928,
                -2.26385210484596, -3.36632972435478, -5.64196150088227,
                Double.NEGATIVE_INFINITY, -4.65898124483664, -1.41090892518414,
                -1.41093409226656, -1.41093409226706, -1.41093409226755,
                -1.41359078861819, -1.51045048261717, -3.04236639807969,
                -3.40086872921582, -4.50013054596771, -6.77529952010244,
                Double.NEGATIVE_INFINITY, -4.71324723872755, -1.42092051187668,
                -1.42089517645172, -1.42089517645172, -1.42089517645172,
                -1.42309711411202, -1.51790387882201, -3.04735924255401,
                -3.40582072714548, -4.50504641128249, -6.78021018539037,
                Double.NEGATIVE_INFINITY, -4.71324723926997, -1.42092051197656,
                -1.4208951765511, -1.4208951765511, -1.4208951765511,
                -1.42309711420685, -1.51790387889631, -3.0473592426037,
                -3.40582072719477, -4.50504641133141, -6.78021018543924,
                Double.NEGATIVE_INFINITY, -4.71324723981238, -1.42092051207642,
                -1.42089517665045, -1.42089517665045, -1.42089517665045,
                -1.42309711430165, -1.51790387897059, -3.04735924265338,
                -3.40582072724403, -4.50504641138032, -6.7802101854881,
                Double.NEGATIVE_INFINITY, -5.2533444892849, -1.51847368558241,
                -1.51794332507819, -1.5179433250732, -1.5179433250682,
                -1.51559767577504, -1.58987514736933, -3.09472499352545,
                -3.4527780126659, -4.55164237065008, -6.82675414448906,
                Double.NEGATIVE_INFINITY, -9.98622824318939, -2.26846075180519,
                -2.26338516559218, -2.26338516554218, -2.26338516549218,
                -2.22011123365886, -2.10962506739666, -3.39302525559133,
                -3.74740208567616, -4.84301450828816, -7.11765827970748,
                Double.NEGATIVE_INFINITY, -317.640079331895, -35.5449844668821,
                -35.2267933318413, -35.2267933286913, -35.2267933255413,
                -32.3640154853853, -19.5253676001206, -5.55334690652568,
                -5.65447515722419, -6.5260653653082, -8.76846897004003,
                Double.NEGATIVE_INFINITY, -633.83728714091, -68.5139833740857,
                -67.8725761886419, -67.8725761822919, -67.8725761759419,
                -62.0993426884852, -36.1219472223147, -6.40239529590465,
                -6.24210565820438, -6.88244712871111, -9.09157056137842,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -526.516586696715,
                -521.35015480563, -521.35015475448, -521.35015470333,
                -474.830542153663, -264.910680554811, -14.7256913689895,
                -10.9055512937063, -8.30841043813106, -10.0516114618951,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -547.269599453829,
                -279.940227872574, -44.2443595391, -12.4411471218304,
                36.2274563243554, -30.8372949902259, -35.4223114869383,
                -35.4424121574557, -35.4424121576303, -35.4424121578631,
                -35.6330326080788, -36.8287113233237, -43.7603512898495,
                -45.1467081112787, -49.3058362329321, -57.6243519407581,
                Double.NEGATIVE_INFINITY, 1.68886669207131, -1.09819805799634,
                -1.11627852660604, -1.11627852678066, -1.11627852698439,
                -1.28871715051355, -2.4025773856265, -9.23734082019655,
                -10.6221350718406, -14.7798959300562, -23.0982193620002,
                Double.NEGATIVE_INFINITY, -13.8183614636364, -0.603655668732244,
                -0.603756340453401, -0.603756340424297, -0.603756340453401,
                -0.614376706449548, -1.00005246826913, -6.97261476851418,
                -8.34350214913138, -12.4890943626524, -20.8057065394241,
                Double.NEGATIVE_INFINITY, -14.0083082664933, -0.613807298708707,
                -0.613705950265285, -0.613705950236181, -0.613705950265285,
                -0.622508133616066, -1.00000204748358, -6.96287669462617,
                -8.33360781829106, -12.4790633054508, -20.7956562546315,
                Double.NEGATIVE_INFINITY, -14.0083082682104, -0.613807298621396,
                -0.613705950177973, -0.613705950148869, -0.613705950177973,
                -0.62250813349965, -1.00000204730895, -6.96287669436424,
                -8.33360781800002, -12.4790633051598, -20.7956562543404,
                Double.NEGATIVE_INFINITY, -14.0083082699566, -0.613807298563188,
                -0.613705950090662, -0.613705950090662, -0.613705950119765,
                -0.622508133412339, -1.00000204713433, -6.96287669410231,
                -8.33360781773808, -12.4790633048979, -20.7956562540785,
                Double.NEGATIVE_INFINITY, -15.9129695247102, -0.720516808476532,
                -0.718395258125383, -0.718395258067176, -0.71839525809628,
                -0.70901561473147, -1.00469104837975, -6.87068916347926,
                -8.23985771735897, -12.383945941081, -20.7003466143797,
                Double.NEGATIVE_INFINITY, -33.3148781577474, -1.94085972188623,
                -1.92055635442375, -1.92055635419092, -1.9205563540454,
                -1.74754027047311, -1.30684938281775, -6.30095871040248,
                -7.65606413627393, -11.7878469889401, -20.1025171794754,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -123.728632802842,
                -122.455804258323, -122.455804245692, -122.455804233119,
                -111.010055602528, -59.8419070251402, -4.77256654552184,
                -5.15887870860752, -8.44295822293498, -16.6384173771658,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -252.329614790651,
                -249.763857031066, -249.763857005659, -249.76385698028,
                -226.681739268883, -123.149763398891, -6.07944247312844,
                -5.46570997784147, -7.87474088484305, -15.9471434854786,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -32.0011475835345,
                -17.3867898712342, -7.54514027570258, -13.8947511261504,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -129.395396034146, -11.7040008708427,
                35.8411480423383, 2.30877238504763, 0.0162641366914614,
                0.00621380143275021, 0.00621380134543872, 0.00621380122902339,
                -0.0890964238788001, -0.686935781501234, -4.15275576476415,
                -4.84593417547876, -6.92549823630543, -11.0847560902184,
                Double.NEGATIVE_INFINITY, 1.30257101551979, -0.09096135951404,
                -0.100001593818888, -0.1000015939062, -0.100001594008063,
                -0.186220905772643, -0.743151023329119, -4.16053274061414,
                -4.85292986643617, -6.93181029554398, -11.090972011516,
                Double.NEGATIVE_INFINITY, -7.59730340617534, -0.989950508723268,
                -0.990000844583847, -0.990000844569295, -0.990000844583847,
                -0.99531102758192, -1.18814890849171, -4.17443005861423,
                -4.85987374892284, -6.93266985568334, -11.0909759440692,
                Double.NEGATIVE_INFINITY, -7.69730194464501, -1.00005146075273,
                -1.00000078653102, -1.00000078651647, -1.00000078653102,
                -1.00440187820641, -1.19314883514016, -4.17458615871146,
                -4.8599517205439, -6.93267946412379, -11.0909759387141,
                Double.NEGATIVE_INFINITY, -7.69730194556178, -1.00005146076728,
                -1.00000078654557, -1.00000078653102, -1.00000078654557,
                -1.00440187820641, -1.19314883511106, -4.1745861586387,
                -4.85995172045659, -6.93267946403648, -11.0909759386268,
                Double.NEGATIVE_INFINITY, -7.69730194666772, -1.00005146097101,
                -1.00000078673474, -1.00000078673474, -1.0000007867493,
                -1.00440187839558, -1.19314883525658, -4.17458615874057,
                -4.85995172055846, -6.93267946413835, -11.0909759387287,
                Double.NEGATIVE_INFINITY, -8.69728737125115, -1.10106101313431,
                -1.10000023795874, -1.10000023792963, -1.10000023794419,
                -1.09531041626178, -1.24314813308592, -4.17614719063567,
                -4.86073146757553, -6.93277557943657, -11.0909759160859,
                Double.NEGATIVE_INFINITY, -17.6971583536506, -2.01014913571998,
                -1.99999745198875, -1.99999745187233, -1.99999745179957,
                -1.91348941001343, -1.69314396618574, -4.19019862997811,
                -4.86775134291383, -6.93364276924694, -11.0909778645146,
                Double.NEGATIVE_INFINITY, -637.68894366594, -64.6368929929158,
                -64.0004787206562, -64.0004787143407, -64.0004787080543,
                -58.2776043927588, -32.6935301040648, -5.15885986425565,
                -5.35201594579848, -6.99405570296221, -11.0917852800776,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -129.283955450344,
                -128.001076570552, -128.001076557848, -128.001076545159,
                -116.46001768946, -64.6940297544643, -6.15886929158296,
                -5.85200304393948, -7.05651849744027, -11.092719797758,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -512.70145982258, -20.1594362366595,
                -12.8522573805094, -7.93143258274358, -11.1062380079675,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                -516.881312132129, -70.9359892421489, -12.0902916604973,
                35.4221869870089, 18.6559991583636, 17.5097450341855,
                17.5047198665561, 17.5047198665125, 17.5047198664543,
                17.4570647539003, 17.1581450750891, 15.4252350834577,
                15.0786458781004, 14.038863847687, 11.9592349207305,
                Double.NEGATIVE_INFINITY, 0.883629983531136, 0.186863796014222,
                0.182343678861798, 0.182343678818143, 0.182343678767211,
                0.139234022884921, -0.139231035893317, -1.84792189453583,
                -2.19412045744684, -3.23356067200075, -5.31314152998675,
                Double.NEGATIVE_INFINITY, -4.71256666049885, -1.40889021177281,
                -1.4089153797031, -1.40891537969583, -1.4089153797031,
                -1.41157047120214, -1.50798941165704, -3.0011299867183,
                -3.3438518318726, -4.38024988525285, -6.45940292944579,
                Double.NEGATIVE_INFINITY, -4.76759106277314, -1.418965820827,
                -1.41894048371614, -1.41894048370887, -1.41894048371614,
                -1.42114102955384, -1.51551450802071, -3.00623316980636,
                -3.34891595072258, -4.38527982251253, -6.46442805980769,
                Double.NEGATIVE_INFINITY, -4.76759106328973, -1.41896582089248,
                -1.41894048378163, -1.41894048377435, -1.41894048378163,
                -1.42114102961204, -1.51551450806437, -3.00623316982819,
                -3.34891595073714, -4.38527982252708, -6.46442805982224,
                Double.NEGATIVE_INFINITY, -4.76759106389363, -1.41896582104528,
                -1.41894048392714, -1.41894048392714, -1.41894048393442,
                -1.42114102975756, -1.51551450818806, -3.00623316993006,
                -3.348915950839, -4.38527982262895, -6.4644280599241,
                Double.NEGATIVE_INFINITY, -5.3152385357098, -1.51712535665138,
                -1.51659496906359, -1.51659496904904, -1.51659496905631,
                -1.51425005821511, -1.58816891662718, -3.05466844540206,
                -3.39696058387199, -4.4329826398025, -6.51208280812716,
                Double.NEGATIVE_INFINITY, -10.1140904553322, -2.27058584636688,
                -2.26551000450127, -2.26551000444306, -2.26551000440668,
                -2.22225598351361, -2.11208326159976, -3.36061059349595,
                -3.69938694996381, -4.73233266313036, -6.81100021076418,
                Double.NEGATIVE_INFINITY, -321.84283905154, -35.3168137150278,
                -34.998606578898, -34.9986065757403, -34.9986065725971,
                -32.1371694149493, -19.3451322706023, -5.57779715069773,
                -5.67437519146915, -6.49539507005102, -8.54425985860871,
                Double.NEGATIVE_INFINITY, -642.185220928965, -67.986916131762,
                -67.3454766918658, -67.3454766855139, -67.3454766791692,
                -61.5749472513198, -35.6919532838219, -6.42437305238127,
                -6.27093992855953, -6.87319765530992, -8.89129830546881,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -521.556284379178,
                -516.389592686617, -516.38959263546, -516.389592584317,
                -469.89177137363, -260.735381881961, -14.464370089001,
                -10.810780660926, -8.35036826204305, -9.937770974655,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, -520.56957849941,
                -264.904735165081, -41.9320737200906, -12.5092249292647
        };

        TweedieEstimator tvp = null, tvpDp = null;
        for (double p : ps) {
            for (double phi : phis) {
                tvp = new TweedieEstimator(p, phi, false, false, false, false);
                tvpDp = new TweedieEstimator(p, phi, false, true, true, false); // should have higher precision
                for (double y : ys) {
                    for (double mu : mus) {
                        final double actual = tvp.logLikelihood(y, mu);
                        final double diff = (actual - results[counter]);
                        if (!roughlyEqual(actual, results[counter]))
                            System.err.println("power = " + p + ", phi = " + phi + ", y = " + y + ", mu = " + mu + "; diff = " + diff +
                                    "; Expected: " + results[counter] + "; Actual: " + actual + "; method: " + tvp._method +
                                    "; counter: " + counter + "; xi = " + (phi / Math.pow(y, 2 - p)));

                        assert roughlyEqual(actual, results[counter]);

                        final double actualDp = tvpDp.logLikelihood(y, mu);
                        final double diffDp = (actualDp - results[counter]);
                        if (!roughlyEqual(actualDp, results[counter]))
                            System.err.println("(with grad calculation) power = " + p + ", phi = " + phi + ", y = " + y + ", mu = " + mu + "; diff = " + diffDp +
                                    "; Expected: " + results[counter] + "; Actual: " + actualDp + "; method: " + tvp._method +
                                    "; counter: " + counter + "; xi = " + (phi / Math.pow(y, 2 - p)));

                        assert roughlyEqual(actualDp, results[counter]);
                        counter++;
                    }
                }
            }
        }
    }


    @Test
    public void testLogLikelihoodCalculationP_GE_2() {
        int counter = 0;

        double[] mus = new double[]{1e-16, 0.1, 0.99, 0.9999999999, 1.0, 1.0000000001, 1.1, 2.0, 64.0, 128.0, 1024.0, 65536.0};
        double[] ys = new double[]{1e-16, 0.1, 0.99, 0.9999999999, 1.0, 1.0000000001, 1.1, 2.0, 64.0, 128.0, 1024.0, 65536.0};
        double[] ps = new double[]{2.0, 2.00001, 2.01, 2.1, 2.2, 2.9, 3.0, 3.1, 3.5, 4.0};
        double[] phis = new double[]{0.5, 1.0, 2.0};

        double[] results = new double[]{36.2276558490246, -30.8498969407968, -35.4349664550778, -35.4550671265848, -35.4550671267848,
                -35.4550671269848, -35.6456874863935, -36.8413614879047, -43.7728332935042, -45.1591276546241,
                -49.3180107379837, -57.6357769047031, -1999999999999927.0,
                1.68887945411394, -1.09821026218735, -1.11629073169415, -1.11629073187415, -1.11629073205415,
                -1.28872927330099, -2.40258509299405, -9.2371818985935, -10.6219137597134, -14.7794296555731,
                -23.0970035615502, -19799999999999924.0, -13.8185857887455, -0.603655303026608,
                -0.603755974731611, -0.603755974733611, -0.603755974735611, -0.61437633434226,
                -1.0000503358535, -6.97245964145295, -8.34328525257284, -12.4886331796825, -20.8044959650542,
                -19999999997999924.0, -14.008535450992, -0.613806987273106, -0.613705638780109,
                -0.613705638780109, -0.613705638780109, -0.622507816588759, -1.0, -6.96272180569633,
                -8.33339116681778, -12.4786023751788, -20.7944459344765, -19999999999999924.0,
                -14.008535452892, -0.613806987375127, -0.613705638880109, -0.613705638880109,
                -0.613705638880109, -0.622507816670577, -1.0, -6.96272180559945, -8.33339116671934,
                -12.478602375079, -20.7944459343765, -20000000001999924.0, -14.008535454792, -0.613806987477147,
                -0.613705638980109, -0.613705638980109, -0.613705638980109, -0.622507816752395,
                -1.0, -6.96272180550258, -8.33339116662091, -12.4786023749792, -20.7944459342765,
                -21999999999999924.0, -15.9132252730877, -0.720517009591004, -0.718395459095785,
                -0.718395459075785, -0.718395459055785, -0.709015818684434, -1.00468982019568,
                -6.87053662579513, -8.23964348691502, -12.3834875077747, -20.69913880633, -39999999999999928.0,
                -33.3153882723321, -1.9408618270172, -1.92055845852016, -1.92055845832016, -1.92055845812016,
                -1.74754245429245, -1.30685281944005, -6.30082462503951, -7.6558689861594, -11.7874083195191,
                -20.1013292713947, -1.28e+18, -1269.84965236953, -123.727651176743, -122.45482256812,
                -122.45482255552, -122.45482254292, -111.009079278765, -59.8411169166403, -4.77258872223978,
                -5.15888308335967, -8.44276616671934, -16.6374854584387, -2.56e+18, -2549.15650518897,
                -252.327433289112, -249.761675400361, -249.761675374961, -249.76167534956, -226.679568461842,
                -123.14796973608, -6.07944154167984, -5.46573590279973, -7.8746189861594, -15.9462914028787,
                -2.048e+19, -20467.0770636473, -2060.34900184844, -2039.68223403788, -2039.68223383328,
                -2039.68223362868, -1853.69103601107, -1017.0685281944, -32.0, -17.3862943611199,
                -7.54517744447956, -13.8941936111989, -1.31072e+21, -1310702.91818056, -132383.462846038,
                -131059.523363857, -131059.52335075, -131059.523337643, -119144.077607473, -65524.909645111,
                -2043.84111691664, -1021.22741127776, -129.38629436112, -11.7040605278392,
                35.8413614879047, 2.30258509299405, 0.0100503358535014,
                9.99999082690371e-11, -1e-16, -1.00000108279037e-10, -0.095310179804325, -0.693147180559945,
                -4.15888308335967, -4.85203026391962, -6.93147180559945, -11.0903548889591, -999999999999963.0,
                1.30258509299405, -0.0909597651565995, -0.09999999991, -0.1, -0.10000000009, -0.186219270713416,
                -0.743147180559945, -4.16044558335967, -4.85281151391962, -6.93156946184945, -11.090356414838,
                -9899999999999964.0, -7.59741490700595, -0.989949664146499, -0.989999999999, -0.99,
                -0.990000000001, -0.995310179804325, -1.18814718055995, -4.17435183335967, -4.85976463891962,
                -6.93243860247445, -11.0903699951603, -9999999998999964.0, -7.69741490600595,
                -1.0000506741465, -0.9999999999, -0.9999999999, -0.9999999999, -1.00440108880432,
                -1.19314718050995, -4.17450808335811, -4.85984276391884, -6.93244836809936, -11.0903701477482,
                -9999999999999964.0, -7.69741490700595, -1.00005067424751, -1.0, -1.0, -1.0, -1.00440108889523,
                -1.19314718055995, -4.17450808335967, -4.85984276391962, -6.93244836809945, -11.0903701477482,
                -1.0000000001e+16, -7.69741490800595, -1.00005067434852, -1.0000000001, -1.0000000001,
                -1.0000000001, -1.00440108898614, -1.19314718060995, -4.17450808336123, -4.8598427639204,
                -6.93244836809955, -11.0903701477482, -1.1e+16, -8.69741490700595, -1.10106077525761,
                -1.10000000001, -1.1, -1.09999999999, -1.09531017980432, -1.24314718055995, -4.17607058335967,
                -4.86062401391962, -6.93254602434945, -11.0903716736271, -2e+16, -17.697414907006,
                -2.01015168434852, -2.0000000001, -2.0, -1.9999999999, -1.91349199798614, -1.69314718055995,
                -4.19013308335967, -4.86765526391962, -6.93342493059945, -11.0903854065372, -6.4e+17,
                -637.697414907006, -64.6364143106111, -64.0000000063, -64.0, -63.9999999937, -58.2771283616225,
                -32.6931471805599, -5.15888308335967, -5.35203026391962, -6.99397180559945, -11.0913314514591,
                -1.28e+18, -1277.69741490701, -129.282878957076, -128.0000000127, -128.0, -127.9999999873,
                -116.458946543441, -64.6931471805599, -6.15888308335967, -5.85203026391962, -7.05647180559945,
                -11.0923080139591, -1.024e+19, -10237.697414907, -1034.33338400758, -1024.0000001023,
                -1024.0, -1023.9999998977, -931.004401088895, -512.69314718056, -20.1588830833597,
                -12.8520302639196, -7.93147180559945, -11.1059798889591, -6.5536e+20, -655357.697414907,
                -66197.9697476439, -65536.0000065535, -65536.0, -65535.9999934465, -59578.2771283616,
                -32768.6931471806, -1028.15888308336, -516.85203026392, -70.9314718055995, -12.0903548889591,
                35.4224229547001, 18.6530347572447, 17.5067673786744, 17.5017422107977,
                17.5017422107477, 17.5017422106977, 17.4540871208455, 17.1551686204677,
                15.4223006690679, 15.0757270787879, 14.036006307948,
                11.9565647662681, -499999999999981.0, 0.883646559789373, 0.18687413071405,
                0.18235401333735, 0.18235401329235, 0.18235401324735,
                0.139244377935642, -0.139219576987623, -1.84786877838749, -2.19405174366746, -3.23343071763238,
                -5.31282419412667, -4949999999999982.0, -4.7126208187809, -1.40888819735117, -1.40891336527742,
                -1.40891336527792, -1.40891336527842, -1.41156845518008, -1.50798695555789, -3.00108928195776,
                -3.34379568473773, -4.38013266651515, -6.45909836285807, -4999999999499982.0,
                -4.76764598615765, -1.41896387022792, -1.41893853310467, -1.41893853310467, -1.41893853310467,
                -1.42113907755684, -1.51551212340965, -3.00619257483373, -3.34885991511409, -4.38516271720435,
                -6.46412360702877, -4999999999999982.0, -4.76764598670765, -1.41896387032843,
                -1.41893853320467, -1.41893853320467, -1.41893853320467, -1.42113907765229, -1.51551212348465,
                -3.00619257488451, -3.34885991516448, -4.3851627172544, -6.46412360707877, -5000000000499982.0,
                -4.76764598725765, -1.41896387042893, -1.41893853330467, -1.41893853330467, -1.41893853330467,
                -1.42113907774774, -1.51551212355965, -3.00619257493529, -3.34885991521487, -4.38516271730445,
                -6.46412360712877, -5499999999999983.0, -5.31530107660981, -1.51712401073564,
                -1.51659362311184, -1.51659362310684, -1.51659362310184, -1.514248713009, -1.58816721338681,
                -3.05462891478667, -3.39690563006664, -4.43286663528156, -6.51177945992038, -9999999999999982.0,
                -10.1142195769876, -2.2705879656589, -2.26551212353465, -2.26551212348465, -2.26551212343465,
                -2.22225812247772, -2.11208571376462, -3.36057866516448, -3.69933975544445, -4.73222458878437,
                -6.81070482675327, -3.2e+17, -321.847087528387, -35.3165872301901, -34.9983800780345,
                -34.9983800748845, -34.9983800717345, -32.1369442556958, -19.3449536651645, -5.57782161656434,
                -5.67439520684432, -6.49536597768424, -8.54404580061407, -6.4e+17, -642.193661118667,
                -67.9863931437024, -67.3449536715145, -67.3449536651645, -67.3449536588145, -61.5744269368848,
                -35.6915272554445, -6.42439520684432, -6.27096879712429, -6.87318956796421, -8.89110767214404,
                -5.12e+18, -5123.23338188951, -521.551366439795, -516.384674487154, -516.384674436004,
                -516.384674384854, -469.886874980452, -260.731248026284, -14.4641159776842, -10.8106895679642,
                -8.35041033880413, -9.93766438048396, -3.2768e+20, -327685.312823431, -33105.4489897997,
                -32774.4641192544, -32774.4641159777, -32774.4641127009, -29795.6026801585, -16390.810689568,
                -520.543557519364, -264.890131109644, -41.929851880484, -12.5092934221638,
                36.2278553680871, -30.8625019726687, -35.4476245053165, -35.467725177813, -35.4677251780459,
                -35.4677251782205, -35.6583454467991, -36.8540147346439, -43.7853183840862, -45.1715502877132,
                -49.3301883473114, -57.6472050417151, Double.NEGATIVE_INFINITY,
                1.68889221588926, -1.09822246692182, -1.11630293730685, -1.11630293753968, -1.1163029376852,
                -1.2887413966322, -2.4025928009736, -9.23702298233673, -10.6216924557606, -14.7789634037848,
                -23.0957878525745,
                Double.NEGATIVE_INFINITY, -13.8188101182168, -0.603654937556741, -0.60375560921969,
                -0.603755609277898, -0.603755609248794, -0.614375962439255, -1.00004820371399,
                -6.9723045191204, -8.34306836352337, -12.4881720187259, -20.8032854814956,
                Double.NEGATIVE_INFINITY, -14.0087626400433, -0.61380667618653, -0.613705327655796,
                -0.6137053276849, -0.613705327655796, -0.622507499918017, -0.999997952903529,
                -6.96256692161262, -8.33317452300401, -12.4781414670375, -20.7932357052429,
                Double.NEGATIVE_INFINITY, -14.0087626418895, -0.613806676257426, -0.613705327726693,
                -0.613705327755796, -0.613705327726693, -0.62250749995981, -0.999997952887115,
                -6.96256692147979, -8.33317452287118, -12.4781414669047, -20.79323570511,
                Double.NEGATIVE_INFINITY, -14.008762643794, -0.613806676357423, -0.61370532782669,
                -0.613705327855793, -0.61370532782669, -0.622507500030703, -0.999997952870696,
                -6.96256692140517, -8.33317452276745, -12.4781414668301, -20.7932357050063,
                Double.NEGATIVE_INFINITY, -15.913481026436, -0.72051721096714, -0.718395660324953,
                -0.718395660354057, -0.718395660295849, -0.709016022897325, -1.00468859232124,
                -6.87038409286388, -8.23942926402297, -12.3830290965117, -20.6979310890739,
                Double.NEGATIVE_INFINITY, -33.3158983963476, -1.94086393237738, -1.92056056284853,
                -1.92056056267391, -1.92056056244108, -1.74754463832867, -1.30685625630938, -6.30069054411068,
                -7.65567384323729, -11.7869696717353, -20.1001414537131,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -123.726669566228, -122.453840893507, -122.453840880963,
                -122.453840868332, -111.008102970593, -59.8403268229331, -4.77261089928193, -5.15888745927346,
                -8.44257412349084, -16.636553620704, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -252.325251824151, -249.75949380624, -249.759493780862,
                -249.759493755454, -226.677397691398, -123.146176108233, -6.07944061151754, -5.46576182787355,
                -7.87449709665195, -15.9454393967036, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -31.9988524750839, -17.3857988804553, -7.54521461367002,
                -13.8936361531119, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -129.377193408372, -11.7041201853081,
                35.8415749236702, 2.29639625329228,
                0.00383498696837427, -0.00621534927986707, -0.00621534939628229, -0.00621534948359387,
                -0.101525483772914, -0.699360127695311, -4.16501195241645, -4.85812790422997,
                -6.93744693402905, -11.0959552812309, Double.NEGATIVE_INFINITY,
                1.3025991704587, -0.0909581709468371, -0.099998406139352, -0.0999984062557675,
                -0.099998406328527, -0.186217635802027, -0.743143337972728, -4.16035842865429,
                -4.85269316536622, -6.93132863937834, -11.0897408637732,
                Double.NEGATIVE_INFINITY, -7.59752640983926, -0.989948819509221, -0.989999155340696,
                -0.989999155369799, -0.989999155355248, -0.995309331950478, -1.18814545258784,
                -4.17427361029105, -4.85965553249254, -6.93220736009381, -11.0897640914786,
                Double.NEGATIVE_INFINITY, -7.69752786946763, -1.00004988753924, -0.999999213273871,
                -0.999999213288423, -0.999999213273871, -1.00440029940498, -1.19314552589774,
                -4.17443001025228, -4.85973381094798, -6.93221728296473, -11.0897644020674,
                Double.NEGATIVE_INFINITY, -7.69752787044074, -1.00004988762469, -0.999999213359323,
                -0.999999213373875, -0.999999213359323, -1.00440029947588, -1.19314552593953,
                -4.17443001023587, -4.85973381093156, -6.93221728294832, -11.089764402051,
                Double.NEGATIVE_INFINITY, -7.69752787144296, -1.00004988772469, -0.999999213459326,
                -0.999999213473878, -0.999999213459326, -1.00440029956133, -1.19314552598133,
                -4.17443001024856, -4.8597338109297, -6.93221728296101, -11.0897644020491,
                Double.NEGATIVE_INFINITY, -8.69754244507696, -1.10106053734254, -1.09999976202145,
                -1.099999762036, -1.0999997620069, -1.09530994330763, -1.24314622801959, -4.17599397829091,
                -4.86051656387046, -6.9323164801148, -11.0897674763959,
                Double.NEGATIVE_INFINITY, -17.6976714648869, -2.01015423290179, -2.00000254813737,
                -2.00000254805006, -2.00000254793364, -1.91349458587744, -1.6931503948678, -4.19006753876844,
                -4.86755918833175, -6.93320710258074, -11.0897929935697,
                Double.NEGATIVE_INFINITY, -637.705886315117, -64.6359356359452, -63.9995212995845,
                -63.9995212933126, -63.9995212869971, -58.2766523381278, -32.6927642642976, -5.15890630247207,
                -5.35204458246783, -6.99388791457653, -11.0908776631831,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -129.28180248214, -127.998923473185, -127.998923460495,
                -127.998923447792, -116.457875415764, -64.692264624181, -6.1588968758233, -5.85205748400131,
                -7.05642511839051, -11.0918962684163, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -512.684834719206, -20.1583299593112, -12.8518031619969,
                -7.93151102860428, -11.1057217983252, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -516.822750144425, -70.9269547294291, -12.0904181178969,
                35.4226589072417, 18.6500695720527, 17.5037889388908, 17.4987637707667,
                17.4987637707085, 17.4987637706648, 17.4511087035201, 17.1521913815589,
                15.4193654691984, 15.0728074932916, 14.0331479783921, 11.9538938047911,
                Double.NEGATIVE_INFINITY, 0.883663135930262, 0.186884465227492,
                0.182364347631235, 0.182364347573027, 0.182364347536647,
                0.139254732799897, -0.139208118285454, -1.84781566362624, -2.1939830319822, -3.23330076898826,
                -5.31250688118568,
                Double.NEGATIVE_INFINITY, -4.7126749780472, -1.40888618288218, -1.40891135079792,
                -1.40891135081247, -1.4089113508052, -1.41156643910281, -1.5079844994215, -3.0010485782731,
                -3.34373953937384, -4.38001545317448, -6.45879381886689,
                Double.NEGATIVE_INFINITY, -4.76770091057033, -1.41896191960614, -1.41893658247346,
                -1.41893658248073, -1.41893658247346, -1.42113712553901, -1.51550973878539, -3.00615198096266,
                -3.34880388131051, -4.38504561731889, -6.46381917687022,
                Double.NEGATIVE_INFINITY, -4.76770091110689, -1.41896191969886, -1.41893658256618,
                -1.41893658257346, -1.41893658256618, -1.42113712562446, -1.51550973885629, -3.00615198100446,
                -3.3488038813523, -4.38504561736068, -6.46381917691202,
                Double.NEGATIVE_INFINITY, -4.76770091165801, -1.41896191979887, -1.41893658266619,
                -1.41893658267346, -1.41893658266619, -1.42113712571719, -1.51550973892719, -3.00615198106081,
                -3.34880388140138, -4.38504561741703, -6.46381917696109,
                Double.NEGATIVE_INFINITY, -5.31536361864588, -1.51712266477867, -1.51659227711812,
                -1.5165922771254, -1.51659227711085, -1.51424736776122, -1.5881655101172, -3.05458938525286,
                -3.39685067804263, -4.4327506361648, -6.51147613430536,
                Double.NEGATIVE_INFINITY, -10.1143487008641, -2.27059008487151, -2.2655142424893,
                -2.26551424244564, -2.26551424238744, -2.22226026135933, -2.11208816585451, -3.36054673780483,
                -3.69929256258649, -4.73211651971098, -6.81040946520545,
                Double.NEGATIVE_INFINITY, -321.851336088693, -35.3163607491068, -34.9981535809265,
                -34.9981535777905, -34.9981535746328, -32.1367191001981, -19.344775063283, -5.57784608237024,
                -5.67441522236812, -6.49533688842247, -8.54383176272576,
                Double.NEGATIVE_INFINITY, -642.202101477081, -67.9858701647551, -67.3444306602775,
                -67.3444306539328, -67.3444306475809, -61.573906631567, -35.6911012357756, -6.42441736159676,
                -6.27099766568576, -6.87318148288036, -8.89091705789328,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -521.546448594167, -516.379756381448, -516.379756330305,
                -516.379756279148, -469.881978681016, -260.727114260964, -14.4638618810169, -10.8105984823597,
                -8.35045241566339, -9.93755780052387, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -520.51753792495, -264.875527929007, -41.9276302215092,
                -12.5093619157431,
                36.4246840636563, -45.1424146576039, -49.7809114319213, -49.8010131135547, -49.8010131137547,
                -49.8010131139547, -49.9915426619127, -51.1825140263475, -57.9481892487018, -59.2734135049672,
                -63.1944148063932, -70.7959989281602, Double.NEGATIVE_INFINITY,
                1.70162360982304, -1.11059051319525, -1.12867189113637, -1.12867189131639, -1.12867189149639,
                -1.30102814555172, -2.41047899157626, -9.08079624445451, -10.4045262398279, -14.3242342106937,
                -21.9256406080979,
                Double.NEGATIVE_INFINITY, -14.0449894833506, -0.603288009806059, -0.603388684886548,
                -0.603388684888566, -0.603388684890584, -0.614002623211557, -0.997920855385028,
                -6.81955217992641, -8.12998325336077, -12.038180582241, -19.6380052328164,
                Double.NEGATIVE_INFINITY, -14.2378237413004, -0.613494004452259, -0.613392649165571,
                -0.613392649165599, -0.613392649165599, -0.62218925811447, -0.997955438528459,
                -6.8100509662176, -8.12033261356424, -12.0284006093897, -19.6282074875291,
                Double.NEGATIVE_INFINITY, -14.2378237432293, -0.613494004554843, -0.613392649266108,
                -0.613392649266137, -0.613392649266137, -0.622189258196846, -0.997955438529294,
                -6.81005096612308, -8.12033261346824, -12.0284006092924, -19.6282074874316,
                Double.NEGATIVE_INFINITY, -14.2378237451581, -0.613494004657405, -0.613392649366653,
                -0.613392649366681, -0.61339264936671, -0.622189258279228, -0.997955438530163,
                -6.81005096602859, -8.12033261337222, -12.0284006091951, -19.6282074873341,
                Double.NEGATIVE_INFINITY, -16.1713285588145, -0.72071616884093, -0.71859450985999,
                -0.718594509840009, -0.718594509820029, -0.709217824847989, -1.00346348677021,
                -6.72020104488794, -8.02898843134107, -11.9357630966051, -19.5353922503815,
                Double.NEGATIVE_INFINITY, -33.8301219340893, -1.94296568242299, -1.92266129021221,
                -1.92266129001223, -1.92266128981225, -1.74972495971559, -1.31028595594575, -6.16880178877901,
                -7.46414082720386, -11.3592755174262, -18.9573051519376,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -122.753637502812, -121.480744821435, -121.480744808835,
                -121.480744796235, -110.040366246443, -59.0582058283288, -4.79478058601001, -5.16367787137782,
                -8.25694761428713, -15.7447881438755, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -250.164106546873, -247.598219502485, -247.598219477085,
                -247.598219451685, -224.526932804142, -121.37164060348, -6.07911489648819, -5.49168521095839,
                -7.75722339535104, -15.1313203327607, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -30.8811216035761, -16.9051143254797, -7.58241069063897,
                -13.3640973375474, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -120.635769192662, -11.7639149234826,
                36.0502807689413, -4.73326859168879, -7.05251697884753, -7.06256781966419, -7.0625678197642,
                -7.06256781986421, -7.15783259384323, -7.75331827606062, -11.1361558872378, -11.7987680153705,
                -13.7592686660835, -17.560060726967, Double.NEGATIVE_INFINITY,
                1.31662223889769, -0.0894848226114528, -0.0985255115820105, -0.098525511672022,
                -0.0985255117620192, -0.184703638789685, -0.739429061801956, -4.07458768824108,
                -4.73645268592777, -6.69630667136069, -10.4970098700628,
                Double.NEGATIVE_INFINITY, -7.70995436790383, -0.989103631131578, -0.989153968671822,
                -0.989153968672831, -0.989153968673841, -0.994460937834327, -1.18642005392106,
                -4.09723571619176, -4.75245125290893, -6.70654991734903, -10.5064622426368,
                Double.NEGATIVE_INFINITY, -7.81142741835017, -0.999262549926096, -0.999211872282752,
                -0.999211872282766, -0.999211872282766, -1.0036101767572, -1.1914932669642, -4.09754103080877,
                -4.75268185448209, -6.70671585239482, -10.5066192914645,
                Double.NEGATIVE_INFINITY, -7.8114274193649, -0.999262550027695, -0.999211872383328,
                -0.999211872383342, -0.999211872383342, -1.0036101768487, -1.19149326701492, -4.09754103081181,
                -4.75268185448439, -6.70671585239647, -10.5066192914661,
                Double.NEGATIVE_INFINITY, -7.81142742037964, -0.999262550129282, -0.999211872483906,
                -0.99921187248392, -0.999211872483934, -1.00361017694019, -1.19149326706566, -4.09754103081487,
                -4.75268185448669, -6.70671585239814, -10.5066192914677,
                Double.NEGATIVE_INFINITY, -8.82612658576262, -1.10082039077582, -1.09975956128535,
                -1.09975956127536, -1.09975956126537, -1.09507121877935, -1.24219404974046, -4.10056282879932,
                -4.75495652202589, -6.70834385465788, -10.5081584315461,
                Double.NEGATIVE_INFINITY, -17.95627225522, -2.01269412938688, -2.00254193328148,
                -2.0025419331815, -2.00254193308151, -1.91607376803318, -1.69635426614825, -4.12561218256488,
                -4.77328170177731, -6.72084904688849, -10.5198638641442,
                Double.NEGATIVE_INFINITY, -646.252743047596, -64.1615430190146, -63.5250966783259,
                -63.5250966720259, -63.5250966657259, -57.8049073908298, -32.3138271817729, -5.18211456061353,
                -5.36656320329743, -6.91319807475209, -10.6571183395463,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -128.215487057796, -126.932543535602, -126.932543522902,
                -126.932543510202, -115.39690018643, -63.8192540860993, -6.17299123260336, -5.87927638983846,
                -7.01204548203478, -10.6990939507396, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -504.470103251824, -19.6201371456164, -12.6321335065682,
                -7.97078168914782, -10.861625012602, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -488.427867241917, -66.5898099320943, -12.1538827975047,
                35.6512967819529, 15.2595221016379, 14.0998979080585, 14.0948724876502,
                14.0948724876002, 14.0948724875502, 14.0472401005607, 13.749497259452,
                12.0580784538634, 11.7267723897971, 10.7465220644406, 8.8461260339988,
                Double.NEGATIVE_INFINITY, 0.900136028868927, 0.197082498114354,
                0.192562153629075, 0.192562153584069, 0.19256215353907,
                0.149473090025238, -0.127889621480898, -1.79546893470046, -2.12640143354381, -3.10632842626026,
                -5.00668002561131,
                Double.NEGATIVE_INFINITY, -4.76730528652177, -1.40687991813564, -1.40690508690577,
                -1.40690508690627, -1.40690508690678, -1.40955857148702, -1.50553812953039, -2.96094596066573,
                -3.28855372902432, -4.26560306124437, -6.16555922388824,
                Double.NEGATIVE_INFINITY, -4.82310162238928, -1.41701918817724, -1.41699384935557,
                -1.41699384935558, -1.41699384935558, -1.41919300159279, -1.51313454669629, -2.96615842861858,
                -3.29372884045524, -4.2707458394116, -6.17069755894645,
                Double.NEGATIVE_INFINITY, -4.82310162294699, -1.41701918827839, -1.4169938494562,
                -1.41699384945621, -1.41699384945621, -1.41919300168889, -1.513134546772, -2.96615842867045,
                -3.29372884050674, -4.27074583946277, -6.17069755899758,
                Double.NEGATIVE_INFINITY, -4.82310162350471, -1.41701918837953, -1.41699384955684,
                -1.41699384955685, -1.41699384955685, -1.41919300178498, -1.51313454684772, -2.96615842872232,
                -3.29372884055823, -4.27074583951396, -6.17069755904871,
                Double.NEGATIVE_INFINITY, -5.37843485479089, -1.51578175729749, -1.51525134255226,
                -1.51525134254726, -1.51525134254227, -1.51290717129926, -1.58646858677981, -3.01565297630924,
                -3.34284982292253, -4.31954348923852, -6.21945077768263,
                Double.NEGATIVE_INFINITY, -10.244488391413, -2.27269932849645, -2.26762323044375,
                -2.26762323039375, -2.26762323034376, -2.2243891478196, -2.11452939687713, -3.32915835508545,
                -3.65299311469166, -4.62677678724725, -6.5262841958751,
                Double.NEGATIVE_INFINITY, -326.137591005155, -35.0919909908637, -34.7737678205193,
                -34.7737678173693, -34.7737678142193, -31.9136731767713, -19.1681330722428, -5.60227676166312,
                -5.69450108300507, -6.4678185187324, -8.33977865112949,
                Double.NEGATIVE_INFINITY, -650.71876979904, -67.4679455768793, -66.8264738157822,
                -66.8264738094322, -66.8264738030822, -61.0586521411967, -35.2698290910311, -6.44669766428309,
                -6.29984024290064, -6.8662247889988, -8.70974902335122,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -516.679956120865, -511.513004089229, -511.513004038079,
                -511.513003986929, -465.037003982918, -256.642219693832, -14.2172366407288, -10.7232348212046,
                -8.39255891249447, -9.83798057422158, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -495.203514995995, -250.715116510272, -39.7960878553608,
                -12.578124288066,
                38.1100762524856, -660.54263469981, -665.701032159676, -665.721142935493, -665.721142935693,
                -665.721142935893, -665.910857771402, -667.060483104957, -672.526063827964, -673.409698802244,
                -675.721142935693, -679.123603381829, Double.NEGATIVE_INFINITY,
                1.81488401650159, -1.23839755025904, -1.25648710684872, -1.25648710702872, -1.25648710720872,
                -1.42810512591424, -2.49883027552319, -7.88146411849122, -8.7640991841004, -11.0747577036196,
                -14.4771302865321,
                Double.NEGATIVE_INFINITY, -16.2820793010439, -0.599829419162373, -0.599930124630242,
                -0.599930124632242, -0.599930124634242, -0.610486473783753, -0.978999986279218,
                -5.62340659689854, -6.49714247533941, -8.80080903088224, -12.2023996311096,
                Double.NEGATIVE_INFINITY, -16.5032819016333, -0.610520432546288, -0.610419016093459,
                -0.610419016093459, -0.610419016093459, -0.619165683580661, -0.979789177760495,
                -5.61590110045885, -6.48953698803366, -8.79312498218428, -12.1947067960894,
                Double.NEGATIVE_INFINITY, -16.5032819038458, -0.610520432653671, -0.610419016198821,
                -0.610419016198821, -0.610419016198821, -0.619165683667929, -0.97978917776886,
                -5.61590110038427, -6.48953698795808, -8.79312498210791, -12.1947067960129,
                Double.NEGATIVE_INFINITY, -16.5032819060583, -0.610520432761062, -0.610419016304191,
                -0.610419016304191, -0.610419016304191, -0.619165683755197, -0.97978917777723,
                -5.61590110030969, -6.4895369878825, -8.79312498203155, -12.1947067959365,
                Double.NEGATIVE_INFINITY, -18.7201949951453, -0.722317630847342, -0.720194995165321,
                -0.720194995145323, -0.720194995125321, -0.710844845790382, -0.992568155945981,
                -5.54573319852221, -6.41836917742542, -8.72117155764532, -12.1226655083273,
                Double.NEGATIVE_INFINITY, -38.9056746159817, -1.96175421373101, -1.94144060500446,
                -1.94144060480446, -1.94144060460446, -1.76921910403311, -1.34084075868069, -5.14748388090429,
                -6.01112068177213, -8.30685253662264, -11.7075557182971,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -114.628324292539, -113.354854762967, -113.354854750367,
                -113.354854737767, -101.962606818687, -52.6161144272265, -4.99569192515843, -5.23938535025599,
                -7.04803656854837, -10.3942645519312, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -232.213825535325, -229.646775700363, -229.646775674963,
                -229.646775649563, -206.672564975894, -106.829954859419, -6.12352913227605, -5.72728100819141,
                -7.03313931132701, -10.3231348319572, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -23.0121497377738, -13.6567199251381, -7.92347741607883,
                -10.4262184581715, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -579.051379481524, -66.5028784944308, -12.3232970818268,
                37.762515692541, -311.563839783607, -314.14303851354, -314.153093901448, -314.153093901548,
                -314.153093901648, -314.247951319403, -314.82276398618, -317.555554347684, -317.997371834824,
                -319.153093901548, -320.854324124616, Double.NEGATIVE_INFINITY,
                1.43973455629955, -0.0869062270807686, -0.0959510053756097, -0.0959510054656106,
                -0.0959510055556097, -0.181760014908369, -0.717122589712845, -3.40843951119686,
                -3.84975704400145, -5.00508630376106, -6.7062725952173,
                Double.NEGATIVE_INFINITY, -8.82251044499722, -0.981385504056456, -0.98143585679039,
                -0.98143585679139, -0.98143585679239, -0.986714031367146, -1.17097078761488, -3.49317409292454,
                -3.93004203214497, -5.08187530991639, -6.78267061003005,
                Double.NEGATIVE_INFINITY, -8.93843705314362, -0.992056318600117, -0.992005610373703,
                -0.992005610373703, -0.992005610373703, -0.996378944117304, -1.17669069120722,
                -3.4947466525564, -3.9315645963438, -5.08335859341911, -6.78414950037166,
                Double.NEGATIVE_INFINITY, -8.93843705430286, -0.992056318706796, -0.99200561047937,
                -0.99200561047937, -0.99200561047937, -0.996378944213924, -1.17669069126439, -3.49474665257209,
                -3.931564596359, -5.08335859343392, -6.78414950038642,
                Double.NEGATIVE_INFINITY, -8.93843705546209, -0.992056318813476, -0.992005610585041,
                -0.992005610585041, -0.992005610585041, -0.996378944310544, -1.17669069132156,
                -3.49474665258779, -3.93156459637419, -5.08335859344872, -6.78414950040118,
                Double.NEGATIVE_INFINITY, -10.0973969240513, -1.09845824190227, -1.09739692406126,
                -1.09739692405126, -1.09739692404126, -1.09272184937379, -1.23358350445159, -3.5101660257397,
                -3.94648401519131, -5.09788520530126, -6.79863218064224,
                Double.NEGATIVE_INFINITY, -20.5070011700147, -2.03504096888934, -2.02488416452606,
                -2.02488416442606, -2.02488416432606, -1.93877341404039, -1.72458424136418, -3.62790580247598,
                -4.0597242029099, -5.20759013033515, -6.90794172117241,
                Double.NEGATIVE_INFINITY, -731.266029224107, -60.2081414599175, -59.5714066951314,
                -59.5714066888314, -59.5714066825314, -53.8752827229914, -29.2020365272613, -5.39182527622731,
                -5.51367198877609, -6.41799759792228, -8.09111158961371,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -119.369491351918, -118.085966434437, -118.085966421737,
                -118.085966409037, -106.598861072202, -56.6775560139649, -6.32434315039328, -6.12621908835095,
                -6.77914823991876, -8.42414600023384, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -437.831048033441, -15.8758125943421, -11.1980976880243,
                -8.33147643349462, -9.58284695454098, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -623.324411950145, -296.116156255991, -39.8419057624441,
                -12.7521150561421,
                37.4139724736439, -137.24920526443, -138.538804629396, -138.543832323351, -138.543832323401,
                -138.543832323451, -138.591261032328, -138.878667365717, -140.245062546468, -140.465971290038,
                -141.043832323401, -141.894447434935, Double.NEGATIVE_INFINITY,
                1.04171129496462, 0.278390903274462, 0.273868514127041, 0.273868514082041,
                0.273868514037041,
                0.230964009360662, -0.0367172780415761, -1.38237573878358, -1.60303450518588,
                -2.18069913506569, -3.0312922807938,
                Double.NEGATIVE_INFINITY, -5.30990091012292, -1.38933843965254, -1.38936361601951,
                -1.38936361602001, -1.38936361602051, -1.39200270330789, -1.48413108143175, -2.64523273408658,
                -2.8636667036968, -3.43958334258251, -4.28998099263934,
                Double.NEGATIVE_INFINITY, -5.373220349174, -1.40002998190225, -1.40000462778904,
                -1.40000462778904, -1.40000462778904, -1.40219129466084, -1.4923471682058, -2.65137514888039,
                -2.86978412077409, -3.44568111931175, -4.29607657278802,
                Double.NEGATIVE_INFINITY, -5.37322034980691, -1.40002998200888, -1.40000462789517,
                -1.40000462789517, -1.40000462789517, -1.40219129476244, -1.49234716828768, -2.65137514894153,
                -2.86978412083498, -3.44568111937244, -4.29607657284869,
                Double.NEGATIVE_INFINITY, -5.37322035043982, -1.40002998211552, -1.4000046280013,
                -1.4000046280013, -1.4000046280013, -1.40219129486405, -1.49234716836956, -2.65137514900267,
                -2.86978412089587, -3.44568111943314, -4.29607657290937,
                Double.NEGATIVE_INFINITY, -6.00349649296148, -1.50402715188698, -1.50349649296647,
                -1.50349649296147, -1.50349649295647, -1.50115895562274, -1.57158978316164, -2.7098810438057,
                -2.9280400385315, -3.50374063358647, -4.35411412125697,
                Double.NEGATIVE_INFINITY, -11.5270219983392, -2.29104189777649, -2.28596349559485,
                -2.28596349554485, -2.28596349549485, -2.24290812035201, -2.13581353401391, -3.08747431456981,
                -3.30338351478677, -3.87731647849939, -4.72749227391802,
                Double.NEGATIVE_INFINITY, -368.757744874359, -33.2288013423877, -32.9104339599947,
                -32.9104339568447, -32.9104339536947, -30.0623719739247, -17.7257488760596, -5.82064325054262,
                -5.88156660681702, -6.33372941139011, -7.17028640723582,
                Double.NEGATIVE_INFINITY, -735.528002823411, -63.1804478144399, -62.5386853556996,
                -62.5386853493496, -62.5386853429996, -56.7951326745823, -31.8344801454636, -6.6578737136778,
                -6.55881168265664, -6.88527625844054, -7.70777513859808,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -476.672373546302, -471.5030800187, -471.50307996755,
                -471.5030799164, -425.22265760692, -223.525593040251, -12.5479753207015, -10.2091178675426,
                -8.77580724027773, -9.40149250080091, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -318.507326412857, -154.90319856578, -26.7660733190062,
                -13.2211779658552, 39.9531095595437, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                1.93822830040657, -1.41778298682629, -1.43588163658938, -1.43588163676938, -1.43588163694938,
                -1.60668433037435, -2.63625521741615, -6.91759568300138, -7.48041695114654, -8.76925566020688,
                -10.1810270427231,
                Double.NEGATIVE_INFINITY, -19.2476134813494, -0.59570699110248, -0.595807730350192,
                -0.595807730352192, -0.595807730354192, -0.606300516678944, -0.958506312110252,
                -4.60427685472656, -5.16140094754249, -6.44621056238344, -7.85762226596368,
                Double.NEGATIVE_INFINITY, -19.5061152279031, -0.606928765101105, -0.606827280637181,
                -0.606827280637181, -0.606827280637181, -0.615518832068708, -0.960113783850164,
                -4.59874309144834, -5.15580317105897, -6.4405675151788, -7.85197517742273,
                Double.NEGATIVE_INFINITY, -19.5061152304886, -0.606928765213774, -0.606827280747829,
                -0.606827280747829, -0.606827280747829, -0.615518832161344, -0.960113783866692,
                -4.59874309139346, -5.15580317100344, -6.44056751512283, -7.85197517736671,
                Double.NEGATIVE_INFINITY, -19.5061152330741, -0.606928765326441, -0.606827280858474,
                -0.606827280858474, -0.606827280858474, -0.615518832253976, -0.960113783883216,
                -4.59874309133857, -5.15580317094791, -6.44056751506684, -7.85197517731069,
                Double.NEGATIVE_INFINITY, -22.0957205727953, -0.723734357241825, -0.72161063563932,
                -0.72161063561932, -0.72161063559932, -0.71228983790045, -0.980776352346191, -4.54799330897757,
                -5.10441325652809, -6.38872489343182, -7.80009214231211,
                Double.NEGATIVE_INFINITY, -45.6094808320545, -1.98229686399335, -1.96197300816181,
                -1.96197300796181, -1.96197300776181, -1.79054106805148, -1.37405164716077, -4.29855744573369,
                -4.84921620474903, -6.1294534767118, -7.54045700531974,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -106.78849479608, -105.514383915581, -105.514383902981,
                -105.514383890381, -94.1752955009925, -46.5715749791465, -5.22042322258059, -5.37420010472812,
                -6.37375890298111, -7.7597061461598, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -215.051608590025, -212.483265942128, -212.483265916728,
                -212.483265891328, -189.616274070013, -93.3031537020198, -6.24809737240746, -5.99218973649788,
                -6.70201591672788, -8.06209860720541, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -744.440071921381, -17.65151541761, -11.6600245289009,
                -8.31359405680895, -9.31157300947036, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -333.4585968156, -38.061687376325, -12.9881972062249,
                39.6065128367888, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY,
                1.57111262031566, -0.106893023300769, -0.115942348182314, -0.115942348272314,
                -0.115942348362314, -0.201343695074801, -0.716129138595699, -2.85679937138832,
                -3.1382100054609, -3.78262935999106, -4.48851505124919,
                Double.NEGATIVE_INFINITY, -10.298619550579, -0.972666305455572, -0.972716675079428,
                -0.972716675080428, -0.972716675081428, -0.977963068243804, -1.15406596595946,
                -2.97695123726761, -3.25551328367558, -3.89791809109605, -4.60362394288617,
                Double.NEGATIVE_INFINITY, -10.4334808556151, -0.983887624214102, -0.98383688198214,
                -0.98383688198214, -0.98383688198214, -0.988182657697903, -1.16048013358863, -2.97979478738772,
                -3.25832482719303, -3.90070699925295, -4.60641083037491,
                Double.NEGATIVE_INFINITY, -10.4334808569637, -0.98388762432626, -0.983836882093287,
                -0.983836882093287, -0.983836882093287, -0.988182657800044, -1.16048013365272,
                -2.9797947874161, -3.25832482722109, -3.90070699928079, -4.60641083040273,
                Double.NEGATIVE_INFINITY, -10.4334808583122, -0.983887624438418, -0.983836882204434,
                -0.983836882204434, -0.983836882204434, -0.988182657902185, -1.16048013371681,
                -2.97979478744448, -3.25832482724915, -3.90070699930862, -4.60641083043054,
                Double.NEGATIVE_INFINITY, -11.7814949231061, -1.09550181532942, -1.09443995452816,
                -1.09443995451816, -1.09443995450816, -1.08977955565873, -1.2240228128816, -3.00763129119729,
                -3.28584126497255, -3.92799708342441, -4.63368070786456,
                Double.NEGATIVE_INFINITY, -23.8724019122277, -2.05880992819716, -2.04864800028139,
                -2.04864800018139, -2.04864800008139, -1.96293203022622, -1.75468731978087, -3.21694021906733,
                -3.492269598575, -4.13238823455638, -4.83788999886035,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -56.4079147561642, -55.7708593159149, -55.7708593096149,
                -55.7708593033149, -50.1013151086207, -26.2994548476976, -5.62387896941468, -5.70076741048844,
                -6.20054680961494, -6.89352043120428, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -110.930798206836, -109.646626882888, -109.646626870188,
                -109.646626857488, -98.2131309468304, -50.0565707628336, -6.52904259802746, -6.40108878007266,
                -6.75600187018766, -7.43604321542643, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -376.864014164155, -13.4091539880234, -10.4134085436689,
                -8.74019330762288, -9.23918278395358, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -383.16509828069, -173.688355735555, -25.9899010159175,
                -13.4531559308675, 39.2598929868153, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, 1.18783922794746,
                0.348836406139246, 0.344311743698473, 0.344311743653473, 0.344311743608473,
                0.30161107025223,
                0.0442183484917807, -1.02611676790453, -1.16682208494082, -1.4890317622059, -1.84197460783496,
                Double.NEGATIVE_INFINITY, -6.0338554377824, -1.37087881522066, -1.37090400003259,
                -1.37090400003309, -1.37090400003359, -1.37352719661478, -1.4615786454726, -2.37302128112668,
                -2.51230230433066, -2.8335047080409, -3.18635763393596,
                Double.NEGATIVE_INFINITY, -6.10694423791411, -1.38214762221361, -1.38212225109763,
                -1.38212225109763, -1.38212225109763, -1.38429513895551, -1.47044387690087, -2.38010120380042,
                -2.51936622370307, -2.84055730973303, -3.19340922529401,
                Double.NEGATIVE_INFINITY, -6.10694423864469, -1.38214762232599, -1.3821222512095,
                -1.3821222512095, -1.3821222512095, -1.38429513906288, -1.47044387698922, -2.38010120387091,
                -2.5193662237734, -2.84055730980325, -3.19340922536422,
                Double.NEGATIVE_INFINITY, -6.10694423937527, -1.38214762243836, -1.38212225132137,
                -1.38212225132137, -1.38212225132137, -1.38429513917025, -1.47044387707756, -2.3801012039414,
                -2.51936622384373, -2.84055730987346, -3.19340922543443,
                Double.NEGATIVE_INFINITY, -6.83461660517885, -1.49162005129049, -1.49108912088986,
                -1.49108912088486, -1.49108912087986, -1.48875892145515, -1.55588055006658, -2.44768478922443,
                -2.58678977611206, -2.90786768533799, -3.26070949755806,
                Double.NEGATIVE_INFINITY, -13.2170003628384, -2.31020437082309, -2.30512340686521,
                -2.30512340681521, -2.30512340676521, -2.26226542183763, -2.15814306661495, -2.88926951625818,
                -3.02693420601201, -3.34699352400271, -3.69974440615469,
                Double.NEGATIVE_INFINITY, -425.639500579203, -31.4487432940002, -31.1302155738755,
                -31.1302155707256, -31.1302155675755, -28.2954434702284, -16.3945133397669, -6.05672540062542,
                -6.0951696211623, -6.34505932072555, -6.69154613152022,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -59.1051484306541, -58.4630627686798, -58.4630627623298,
                -58.4630627559798, -52.7463148006512, -28.6680347086528, -6.90427062624974, -6.84029371727234,
                -7.01775026232984, -7.35777093494923, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -439.058140628829, -433.886243780961, -433.886243729811,
                -433.886243678661, -387.821833711592, -193.260654158077, -11.5332240700112, -10.0353513478339,
                -9.19874372981091, -9.44823846797626, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -198.804311394224, -94.065940121657, -20.2167127618381,
                -13.9483402193131, 52.9124808136813, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                2.7656592799451, -4.38960789287491, -4.40777036577293, -4.40777036595293, -4.40777036613293,
                -4.57300823212298, -5.3620745922659, -6.47213933525213, -6.49653665911611, -6.52038935327618,
                -6.52462663924642,
                Double.NEGATIVE_INFINITY, -66.8682028376703, -0.562360043740179, -0.562461019923128,
                -0.562461019925128, -0.562461019927128, -0.572521120694073, -0.83094376772686,
                -1.69033456049904, -1.7144780975035, -1.73823968886973, -1.74247518861669,
                Double.NEGATIVE_INFINITY, -67.7083169527496, -0.577068437110099, -0.576966475129739,
                -0.576966475129739, -0.576966475129739, -0.585283005518354, -0.837743363699414,
                -1.6943175952614, -1.71845828072814, -1.74221884846748, -1.74645432814452,
                Double.NEGATIVE_INFINITY, -67.7083169611511, -0.577068437257463, -0.576966475275074,
                -0.576966475275074, -0.576966475275074, -0.585283005646253, -0.837743363767691,
                -1.69431759530151, -1.71845828076822, -1.74221884850755, -1.74645432818459,
                Double.NEGATIVE_INFINITY, -67.7083169695525, -0.577068437404826, -0.576966475420408,
                -0.576966475420408, -0.576966475420408, -0.585283005774152, -0.837743363835966,
                -1.69431759534162, -1.7184582808083, -1.74221884854762, -1.74645432822466,
                Double.NEGATIVE_INFINITY, -76.1120500612052, -0.726744237676719, -0.724612894040951,
                -0.724612894020951, -0.724612894000951, -0.715493720414478, -0.908331189422417,
                -1.73673980857264, -1.76085197866187, -1.78460231013223, -1.78883758911002,
                Double.NEGATIVE_INFINITY, -151.786903128063, -2.1150816078214, -2.09468582930522,
                -2.09468582910522, -2.09468582890522, -1.92864531969988, -1.58487678668633, -2.15979489438416,
                -2.18365042607611, -2.20730863112573, -2.21154210381032,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -73.0979537087784, -71.8193413051671, -71.8193412925671,
                -71.8193412799671, -60.8431643170173, -23.5332045336351, -6.64544296350074, -6.65161896115779,
                -6.66893067944574, -6.67303971859877, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -142.76870321591, -140.191286554136, -140.191286528736,
                -140.191286503336, -118.056259007489, -42.5876501914677, -7.67389669582919, -7.66182285190183,
                -7.67258335804869, -7.67656394968527, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -298.343014744777, -11.0653742920804, -10.7978026659713,
                -10.7168462021429, -10.7190285285492, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -42.315331953498, -23.6519200103011, -16.9673417082566,
                -16.8400489380826, 52.5356085007151, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                2.41842127165864, -1.15921231475136, -1.16829355120038, -1.16829355129038, -1.16829355138038,
                -1.2509124843754, -1.64544566444686, -2.20047803593997, -2.21267669787197, -2.224603044952,
                -2.22672168793712,
                Double.NEGATIVE_INFINITY, -34.0650719874805, -0.912150590515399, -0.912201078606874,
                -0.912201078607874, -0.912201078608874, -0.917231128992346, -1.04644245250874,
                -1.47613784889483, -1.48820961739706, -1.50009041308017, -1.50220816295365,
                Double.NEGATIVE_INFINITY, -34.4924503461799, -0.926826088360087, -0.926775107369907,
                -0.926775107369907, -0.926775107369907, -0.930933372564214, -1.05716355165474,
                -1.48545066743574, -1.49752101016911, -1.50940129403878, -1.5115190338773,
                Double.NEGATIVE_INFINITY, -34.4924503504534, -0.926826088506615, -0.926775107515421,
                -0.926775107515421, -0.926775107515421, -0.930933372701011, -1.05716355176173,
                -1.48545066752864, -1.49752101026199, -1.50940129413166, -1.51151903397018,
                Double.NEGATIVE_INFINITY, -34.492450354727, -0.926826088653146, -0.926775107660937,
                -0.926775107660937, -0.926775107660937, -0.930933372837809, -1.05716355186872,
                -1.48545066762154, -1.49752101035488, -1.50940129422454, -1.51151903406306,
                Double.NEGATIVE_INFINITY, -38.7637550278055, -1.07110211604131, -1.07003644422342,
                -1.07003644421342, -1.07003644420342, -1.06547685741019, -1.16189559191416, -1.57609990148927,
                -1.58815598653389, -1.60003115226907, -1.60214879175796,
                Double.NEGATIVE_INFINITY, -77.0370827310307, -2.20117197090962, -2.19097408165153,
                -2.19097408155153, -2.19097408145153, -2.10795382684885, -1.93606956034208, -2.22352861419099,
                -2.23545638003697, -2.24728548256178, -2.24940221890408,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -40.2309175447971, -39.5916113429915, -39.5916113366915,
                -39.5916113303915, -34.1035228489166, -15.4485429572255, -7.00466217215832, -7.00775017098684,
                -7.01640603013082, -7.01846054970733, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -75.5756987825462, -74.2869904516592, -74.2869904389592,
                -74.2869904262592, -63.2194766783356, -25.4851722703252, -8.0282955225059, -8.02225860054222,
                -8.02763885361565, -8.02962914943394, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -559.297469149125, -548.917131011099, -548.917130908799,
                -548.917130806499, -459.737663328293, -154.892815691812, -11.2539954654636, -11.1202096524091,
                -11.0797314204949, -11.080822583698, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -29.9421996948503, -20.6104937232518, -17.2682045722296,
                -17.2045581871426, 52.1709359930193, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, 2.07064967099591,
                0.281832877790912, 0.277292259566406, 0.277292259521406, 0.277292259476406,
                0.235982792978894,
                0.0387162029431641, -0.238799982803393, -0.24489931376939, -0.250862487309406,
                -0.251921808801965,
                Double.NEGATIVE_INFINITY, -17.8399506785857, -1.2634899801032, -1.26351522414894,
                -1.26351522414944, -1.26351522414994, -1.26603024934168, -1.33063591109987, -1.54548360929292,
                -1.55151949354403, -1.55745989138559, -1.55851876632233,
                Double.NEGATIVE_INFINITY, -18.0609742913463, -1.27816216243641, -1.27813667194132,
                -1.27813667194132, -1.27813667194132, -1.28021580453847, -1.34333089408373, -1.55747445197423,
                -1.56350962334092, -1.56944976527575, -1.57050863519501,
                Double.NEGATIVE_INFINITY, -18.0609742935561, -1.27816216258265, -1.27813667208705,
                -1.27813667208705, -1.27813667208705, -1.28021580467985, -1.34333089421021, -1.55747445209366,
                -1.56350962346034, -1.56944976539517, -1.57050863531443,
                Double.NEGATIVE_INFINITY, -18.0609742957658, -1.27816216272889, -1.27813667223278,
                -1.27813667223278, -1.27813667223278, -1.28021580482122, -1.34333089433667, -1.55747445221309,
                -1.56350962357976, -1.56944976551459, -1.57050863543385,
                Double.NEGATIVE_INFINITY, -20.2661899282246, -1.4198634723425, -1.41933063643356,
                -1.41933063642856, -1.41933063642356, -1.41705084302694, -1.46526021027892, -1.67236236506648,
                -1.67839040758879, -1.68432799045638, -1.68538681020082,
                Double.NEGATIVE_INFINITY, -39.8395548347603, -2.42159945469981, -2.41650051007077,
                -2.41650051002077, -2.41650050997076, -2.37499038266943, -2.28904824941604, -2.4327777763405,
                -2.43874165926349, -2.44465621052589, -2.44571457869704,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -23.9783476271159, -23.6586945262131, -23.6586945230631,
                -23.6586945199131, -20.9146502791757, -11.5871603333301, -7.36521994079653, -7.36676394021079,
                -7.37109186978278, -7.37211912957104, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -42.1605191245159, -41.5161649590724, -41.5161649527224,
                -41.5161649463724, -35.9824080724106, -17.1152558684054, -8.38681749449579, -8.38379903351395,
                -8.38648916005067, -8.38748430795981, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -285.552023088166, -280.361854019153, -280.361853968003,
                -280.361853916853, -235.77212017775, -83.3496963595096, -11.5302862463353, -11.4633933398081,
                -11.443154223851, -11.4436998054525, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -23.9379794981108, -19.2721265123115, -17.6009819368004,
                -17.5691587442569,
                54.6896772889324, -9999999999999926.0, -9999999999999944.0, -9999999999999944.0,
                -9999999999999944.0, -9999999999999944.0, -9999999999999944.0, -9999999999999944.0,
                -9999999999999946.0, -9999999999999944.0, -9999999999999944.0, -9999999999999946.0,
                -9.99999999999998e+30,
                2.88151269656637, -5.20031568829232, -5.21848730325363, -5.21848730343363, -5.21848730361363,
                -5.38295011335099, -6.14348730343363, -7.08726171749613, -7.10286840694926, -7.11653427380106,
                -7.11845678587879, -9.9e+31, -80.5673904492454, -0.557289439144448, -0.557390449243458,
                -0.557390449245458, -0.557390449247458, -0.567390449245458, -0.814890449245458,
                -1.53638214846421, -1.55182587405014, -1.56543826838303, -1.56735993189784, -9.999999999e+31,
                -81.5723649328747, -0.57246697317773, -0.5723649427747, -0.5723649427747, -0.5723649427747,
                -0.580629405601973, -0.8223649428497, -1.54135908349968, -1.55680097803094, -1.57041277154902,
                -1.57233442552941, -1e+32, -81.5723649429247, -0.572466973329761, -0.5723649429247,
                -0.5723649429247, -0.5723649429247, -0.580629405734617, -0.8223649429247, -1.5413590835497,
                -1.55680097808095, -1.57041277159902, -1.57233442557941, -1.0000000001e+32, -81.5723649529747,
                -0.572466973481791, -0.5723649430747, -0.5723649430747, -0.5723649430747, -0.580629405867262,
                -0.8223649429997, -1.54135908359972, -1.55680097813096, -1.57041277164902, -1.57233442562941,
                -1.1e+32, -91.6244211217221, -0.726553557187865, -0.724421121742096, -0.724421121722096,
                -0.724421121702096, -0.715330212631187, -0.899421121722096, -1.5934396764096,
                -1.60886326039397, -1.62246904576384, -1.62439060440008, -2e+32, -182.112085713765,
                -2.13249179477676, -2.11208571396462, -2.11208571376462, -2.11208571356462, -1.94679645756627,
                -1.61208571376462, -2.08132399501462, -2.09658278407712, -2.11013449611325, -2.11205519665215,
                -6.4e+33, -6386.82631456796, -70.1055717866154, -68.8263145805642, -68.8263145679642,
                -68.8263145553642, -57.9006947332535, -21.8263145679642, -6.81068956796421, -6.81459581796421,
                -6.82442247812046, -6.82628406528724, -1.28e+34, -12787.8582228388, -136.436939296308,
                -133.858222864204, -133.858222838804, -133.858222813404, -111.825164987564, -38.8582228388041,
                -7.85822283880413, -7.85041033880413, -7.85639178411663, -7.85819235102832, -1.024e+35,
                -102390.970549214, -1053.74169501527, -1032.97054941842, -1032.97054921382, -1032.97054900922,
                -855.433359131179, -265.970549213824, -11.1892992138239, -11.0174242138239, -10.9695726513239,
                -10.9705189346643, -6.5536e+36, -6553597.20791253, -66881.8339711006, -65551.2079256422,
                -65551.2079125352, -65551.2078994281, -54177.3732017914, -16400.2079125352, -33.1766625351524,
                -21.1922875351524, -17.2684594101524, -17.2078972763634,
                54.3431036986524, -4999999999999936.0, -4999999999999945.0, -4999999999999945.0,
                -4999999999999945.0, -4999999999999945.0, -4999999999999945.0, -4999999999999946.0,
                -4999999999999945.0, -4999999999999946.0, -4999999999999946.0, -4999999999999946.0,
                -4.99999999999999e+30,
                2.5349391062864, -1.50597508614295, -1.5150608936236, -1.5150608937136, -1.5150608938036,
                -1.59729229867228, -1.9775608937136, -2.44944810074485, -2.45725144547142, -2.46408437889732,
                -2.46504563493618, -4.95e+31, -40.9089135344749, -0.903863029424421, -0.903913534473926,
                -0.903913534474926, -0.903913534475925, -0.908913534474926, -1.03266353447493,
                -1.3934093840843, -1.40113124687727, -1.40793744404371, -1.40889827580112, -4.9999999995e+31,
                -41.4189385281047, -0.918989548256188, -0.918938533054673, -0.918938533054673,
                -0.918938533054673, -0.923070764468309, -1.04393853309217, -1.40343560341716,
                -1.41115655068279, -1.41796244744183, -1.41892327443203, -5e+31, -41.4189385332047,
                -0.918989548407203, -0.918938533204673, -0.918938533204673, -0.918938533204673,
                -0.923070764609631, -1.04393853320467, -1.40343560351717, -1.4111565507828, -1.41796244754183,
                -1.41892327453203, -5.0000000005e+31, -41.4189385383047, -0.918989548558218, -0.918938533354673,
                -0.918938533354673, -0.918938533354673, -0.923070764750954, -1.04393853331717,
                -1.40343560361718, -1.4111565508828, -1.41796244764183, -1.41892327463203, -5.5e+31,
                -46.5164492574566, -1.0675154751895, -1.06644925746661, -1.06644925745661, -1.06644925744661,
                -1.06190380291116, -1.15394925745661, -1.50095853480036, -1.50867032679255, -1.51547321947749,
                -1.51643399879561, -1e+32, -92.2086593040446, -2.21886234455066, -2.20865930414459,
                -2.20865930404459, -2.20865930394459, -2.12601467594542, -1.95865930404459, -2.19327844466959,
                -2.20090783920084, -2.20768369521891, -2.20864404548836, -3.2e+33, -3197.16507565824,
                -38.8047042675698, -38.1650756645442, -38.1650756582442, -38.1650756519442, -32.7022657408888,
                -14.6650756582442, -7.15726315824418, -7.15921628324418, -7.16412961332231, -7.1650604069057,
                -6.4e+33, -6398.20089017908, -72.4902484078363, -71.2008901917841, -71.2008901790841,
                -71.2008901663841, -60.1843612534643, -23.7008901790841, -8.2008901790841, -8.1969839290841,
                -8.19997465174035, -8.2008749351962, -5.12e+34, -51201.3166345229, -532.702207423578,
                -522.316634625154, -522.316634522854, -522.316634420554, -433.548039481531, -138.816634522854,
                -11.4260095228539, -11.3400720228539, -11.3161462416039, -11.3166193832741, -3.2768e+36,
                -3276807.5544785, -33449.8675077788, -32784.5544850495, -32784.554478496, -32784.5544719425,
                -27097.6371231241, -8209.05447849604, -25.5388534960379, -19.5466659960379, -17.5847519335379,
                -17.5544708666434,
                53.9965301083725, -2499999999999941.0, -2499999999999946.0, -2499999999999946.0,
                -2499999999999946.0, -2499999999999946.0, -2499999999999946.0, -2499999999999946.0,
                -2499999999999946.0, -2499999999999946.0, -2499999999999946.0, -2499999999999946.0,
                -2.5e+30, 2.18836551600642, 0.167908419791752, 0.163365516051423,
                0.163365516006423, 0.163365515961423,
                0.122249813527085, -0.0678844839935765, -0.303828087509202, -0.307729759872482,
                -0.311146226585437, -0.311626854604864, -2.475e+31, -21.2529618722296, -1.25043661970439,
                -1.25046187222915, -1.25046187222965, -1.25046187223015, -1.25296187222965, -1.31483687222965,
                -1.49520979703433, -1.49907072843082, -1.50247382701404, -1.50295424289274, -2.49999999975e+31,
                -21.5155121208596, -1.2655376309354, -1.26551212333465, -1.26551212333465, -1.26551212333465,
                -1.26757823904146, -1.3280121233534, -1.50776065851589, -1.51162113214871, -1.51502408052822,
                -1.51550449402332, -2.5e+31, -21.5155121234846, -1.26553763108591, -1.26551212348465,
                -1.26551212348465, -1.26551212348465, -1.26757823918712, -1.32801212348465, -1.5077606586409,
                -1.51162113227371, -1.51502408065322, -1.51550449414832, -2.50000000025e+31, -21.5155121261096,
                -1.26553763123642, -1.26551212363465, -1.26551212363465, -1.26551212363465, -1.26757823933279,
                -1.3280121236159, -1.5077606587659, -1.51162113239871, -1.51502408077822, -1.51550449427332,
                -2.75e+31, -24.1357501204639, -1.4112832293303, -1.41075012046886, -1.41075012046386,
                -1.41075012045886, -1.40847739319113, -1.45450012046386, -1.62800475913573, -1.63186065513183,
                -1.6352621014743, -1.63574249113335, -5e+31, -47.4302328943246, -2.4353344145776,
                -2.43023289437456, -2.43023289432456, -2.43023289427456, -2.38891058027498, -2.30523289432456,
                -2.42254246463706, -2.42635716190269, -2.42974508991172, -2.43022526504645, -1.6e+33,
                -1602.50774299852, -23.3275573031869, -23.0077430016742, -23.0077429985242, -23.0077429953742,
                -20.2763380398465, -11.2577429985242, -7.50383674852415, -7.50481331102415, -7.50726997606322,
                -7.50773537285491, -3.2e+33, -3203.54551064436, -40.6901897587402, -40.0455106507141,
                -40.0455106443641, -40.0455106380141, -34.5372461815541, -16.2955106443641, -8.54551064436407,
                -8.54355751936407, -8.5450528806922, -8.54550302242012, -2.56e+34, -25606.6629639725,
                -272.355750422871, -267.162964023659, -267.162963972509, -267.162963921359, -222.778666451848,
                -75.4129639725088, -11.7176514725088, -11.6746827225088, -11.6627198318838, -11.6629564027189,
                -1.6384e+36, -1638412.90104827, -16734.057562913, -16401.4010515484, -16401.4010482716,
                -16401.4010449949, -13557.9423705857, -4113.65104827162, -21.8932357716206, -18.8971420216206,
                -17.9161849903706, -17.9010444569233, 58.5681058556339,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                2.99713372916193, -6.16152889965876, -6.17970966281536, -6.17970966299536, -6.17970966317536,
                -6.34340229075684, -7.07665664667814, -7.88392571610412, -7.89391304079131, -7.90176564726124,
                -7.902644234086,
                Double.NEGATIVE_INFINITY, -97.2367473720929, -0.552192910996136, -0.55229395502828,
                -0.55229395503028, -0.55229395503228, -0.562234272528809, -0.79933602501491, -1.40902748884502,
                -1.41891013156506, -1.42673129585337, -1.42760947856697,
                Double.NEGATIVE_INFINITY, -98.4416374425284, -0.567833363100364, -0.567731264223029,
                -0.567731264223029, -0.567731264223029, -0.575944027690935, -0.807471031879579,
                -1.41494252263531, -1.42482398915348, -1.43264480015885, -1.43352297833188,
                Double.NEGATIVE_INFINITY, -98.4416374545775, -0.567833363256999, -0.567731264377633,
                -0.567731264377633, -0.567731264377633, -0.575944027828264, -0.807471031961161,
                -1.41494252269469, -1.42482398921285, -1.43264480021822, -1.43352297839125,
                Double.NEGATIVE_INFINITY, -98.4416374666267, -0.567833363413634, -0.567731264532237,
                -0.567731264532237, -0.567731264532237, -0.575944027965592, -0.807471032042741,
                -1.41494252275407, -1.42482398927222, -1.43264480027758, -1.43352297845061,
                Double.NEGATIVE_INFINITY, -110.492568442207, -0.72626804864895, -0.724134520654477,
                -0.724134520634477, -0.724134520614477, -0.715071743606125, -0.890851264206976,
                -1.47612302397468, -1.48599272847406, -1.49381000665003, -1.49468813941731,
                Double.NEGATIVE_INFINITY, -218.948305137209, -2.1495380235094, -2.12912163347897,
                -2.12912163327897, -2.12912163307897, -1.96457899193977, -1.63863116075221, -2.02410534182746,
                -2.03386918815782, -2.04165467086922, -2.04253239498478,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -67.3887731300236, -66.1088706886268, -66.1088706760268,
                -66.1088706634268, -55.2334929377182, -20.3441053166625, -6.96574629892473, -6.96821769361109,
                -6.9738128220969, -6.97466239464877, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -130.696971449191, -128.116954374126, -128.116954348726,
                -128.116954323326, -106.185230703869, -35.6174536223037, -8.03126678643648, -8.02621048910321,
                -8.02954460677551, -8.03036511964873, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -237.836534253441, -11.3407579637601, -11.2303139781522,
                -11.2019939444353, -11.2024076218075, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -27.577552511103, -19.8791949697201, -17.5717760359815,
                -17.5428975572817, 57.763070097023, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                2.65101640261185, -1.9283149117985, -1.9374052933768, -1.9374052934668, -1.9374052935568,
                -2.01925160734754, -2.38587878530819, -2.78951332002118, -2.79450698236477, -2.79843328559974,
                -2.79887257901212,
                Double.NEGATIVE_INFINITY, -49.2379668201714, -0.895689589622994, -0.895740111639067,
                -0.895740111640067, -0.895740111641067, -0.900710270389331, -1.01926114663238,
                -1.32410687854744, -1.32904819990746, -1.33295878205161, -1.33339787340841,
                Double.NEGATIVE_INFINITY, -49.8481611478208, -0.911259108106812, -0.911208058668144,
                -0.911208058668144, -0.911208058668144, -0.915314440402098, -1.03107794249642,
                -1.33481368787428, -1.33975442113337, -1.34366482663606, -1.34410391572257,
                Double.NEGATIVE_INFINITY, -49.848161153971, -0.911259108310713, -0.91120805887103,
                -0.91120805887103, -0.91120805887103, -0.915314440596345, -1.03107794266279, -1.33481368802956,
                -1.33975442128864, -1.34366482679132, -1.34410391587784,
                Double.NEGATIVE_INFINITY, -49.8481611600726, -0.911259108466135, -0.911208059025436,
                -0.911208059025436, -0.911208059025436, -0.915314440742113, -1.03107794278069,
                -1.33481368813635, -1.33975442139543, -1.34366482689811, -1.34410391598462,
                Double.NEGATIVE_INFINITY, -55.9471048046045, -1.06395460782527, -1.06288784382803,
                -1.06288784381803, -1.06288784380803, -1.05835645530385, -1.14624621560428, -1.43888209548813,
                -1.44381694773782, -1.44772558682581, -1.44816465320945,
                Double.NEGATIVE_INFINITY, -110.635418671928, -2.2360351150783, -2.22582692006308,
                -2.22582691996308, -2.22582691986308, -2.14355559929348, -1.9805816836997, -2.17331877423733,
                -2.17820069740251, -2.18209343875821, -2.18253230081598,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -37.511233402587, -36.8712821818886, -36.8712821755886,
                -36.8712821692886, -31.4335933064343, -13.9888994959064, -7.29971998703753, -7.30095568438071,
                -7.30375324862361, -7.30417803489955, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -69.6945604193907, -68.4045518818581, -68.4045518691581,
                -68.4045518564581, -57.4386900467292, -22.1548015059468, -8.36170808801317, -8.35917993934654,
                -8.36084699818269, -8.3612572546193, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -508.634141139222, -498.24333016601, -498.24333006371,
                -498.24332996141, -409.883046895437, -124.850432131092, -11.6025439862512, -11.5473219934472,
                -11.5331619765888, -11.5333688152749, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -22.8904286351349, -19.0412498644435, -17.8875403975742,
                -17.8731011582243, 57.1096794791966, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, 2.3052753609846,
                0.015609703779429, 0.0110645129902798, 0.0110645129452797,
                0.0110645129002797, -0.0298586439950895, -0.213172232975416, -0.414989500331909,
                -0.417486331503707, -0.41944948312119, -0.41966912982738,
                Double.NEGATIVE_INFINITY, -25.4089522615982, -1.23781364632397, -1.23783890733201,
                -1.23783890733251, -1.23783890733301, -1.24032398670714, -1.29959942482867, -1.45202229078619,
                -1.4544929514662, -1.45644824253828, -1.45666778821668,
                Double.NEGATIVE_INFINITY, -25.721784938647, -1.25333391878997, -1.25330839407064,
                -1.25330839407064, -1.25330839407064, -1.25536158493762, -1.31324333598478, -1.46511120867371,
                -1.46758157530325, -1.4695367780546, -1.46975632259785,
                Double.NEGATIVE_INFINITY, -25.7217849417748, -1.25333391894465, -1.25330839422481,
                -1.25330839422481, -1.25330839422481, -1.25536158508747, -1.31324333612069, -1.46511120880407,
                -1.46758157543361, -1.46953677818495, -1.46975632272821,
                Double.NEGATIVE_INFINITY, -25.7217849449026, -1.25333391909933, -1.25330839437898,
                -1.25330839437898, -1.25330839437898, -1.25536158523732, -1.3132433362566, -1.46511120893444,
                -1.46758157556397, -1.46953677831532, -1.46975632285857,
                Double.NEGATIVE_INFINITY, -28.8446036675453, -1.40302856915568, -1.40249518715707,
                -1.40249518715207, -1.40249518714707, -1.40022949289498, -1.44417437304519, -1.59049231298712,
                -1.59295973911196, -1.59491405865595, -1.59513359184777,
                Double.NEGATIVE_INFINITY, -56.6483742414729, -2.44868246304795, -2.44357836554035,
                -2.44357836549035, -2.44357836544035, -2.40244270515555, -2.32095574735866, -2.41732429262747,
                -2.41976525421006, -2.42171162488791, -2.4219310559168,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -22.7385276334131, -22.4185520230639, -22.4185520199139,
                -22.4185520167639, -19.6997075853367, -10.9773606800728, -7.63277092563835, -7.63338877430994,
                -7.63478755643139, -7.63499994956936, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -39.3591235964343, -38.714119327668, -38.714119321318,
                -38.714119314968, -33.2311884101035, -15.5892441397123, -8.69269743074551, -8.6914333564122,
                -8.69226688583027, -8.69247201404858, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -260.414527062981, -255.219121576375, -255.219121525225,
                -255.219121474075, -211.038979941089, -68.5226725589161, -11.898728486496, -11.871117490094,
                -11.8640374816648, -11.8641409010078, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -20.7119312835158, -18.78734189817, -18.2104871647354,
                -18.2032675450605, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                3.45828004180558, -12.1356500615622, -12.1538674789124, -12.1538674790924, -12.1538674792724,
                -12.3145274319129, -12.9499384272585, -13.4045990871653, -13.4062805320548, -13.4071601247058,
                -13.407200732953,
                Double.NEGATIVE_INFINITY, -209.361849670657, -0.531726607629262, -0.531827787564884,
                -0.531827787566884, -0.531827787568884, -0.541533495381463, -0.741763742784122,
                -1.07058112415543, -1.07224468162446, -1.07312045439949, -1.07316104142808,
                Double.NEGATIVE_INFINITY, -211.900904057097, -0.5491624443818, -0.54906007109008,
                -0.54906007109008, -0.54906007109008, -0.557069663809194, -0.752410239935549,
                -1.07981365189924, -1.08147700838603, -1.0823527382411, -1.08239332503128,
                Double.NEGATIVE_INFINITY, -211.900904082488, -0.549162444556291, -0.549060071262536,
                -0.549060071262536, -0.549060071262536, -0.557069663964688, -0.752410240042147,
                -1.0798136519917, -1.08147700847849, -1.08235273833356, -1.08239332512374,
                Double.NEGATIVE_INFINITY, -211.900904107878, -0.549162444730782, -0.549060071434991,
                -0.549060071434991, -0.549060071434991, -0.557069664120183, -0.752410240148744,
                -1.07981365208416, -1.08147700857094, -1.08235273842602, -1.08239332521619,
                Double.NEGATIVE_INFINITY, -237.292343420298, -0.724416033333581, -0.722278127746045,
                -0.722278127726045, -0.722278127706045, -0.713326569303939, -0.859770432129387,
                -1.17303414986146, -1.17469549652572, -1.17557079718126, -1.17561138158732,
                Double.NEGATIVE_INFINITY, -465.727913314912, -2.21431418664784, -2.19385649041627,
                -2.19385649021627, -2.19385649001627, -2.03225457167584, -1.7386280152332, -1.92463448500794,
                -1.92627774326951, -1.92714918112916, -1.9271897440782,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -58.6456944182834, -57.3632066999075, -57.3632066873075,
                -57.3632066747075, -46.6856910717269, -16.0761022990376, -7.4954983539742, -7.49589552227259,
                -7.4965008564156, -7.49653994121457, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -112.271330285724, -109.686101899328, -109.686101873928,
                -109.686101848528, -88.153449538822, -26.2499642848459, -8.61995604059465, -8.61906692247945,
                -8.61939756891496, -8.61943512788159, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -656.329465962693, -156.311429970701, -11.9897615378209,
                -11.9708644099153, -11.9673494284459, -11.9673656257597,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -20.2271514388693, -18.9116776060559, -18.6312774154318,
                -18.6297555737468, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                3.11277144439525, -4.68419360728862, -4.69330231596375, -4.69330231605375, -4.69330231614375,
                -4.77363229246399, -5.09133779013677, -5.31866812009021, -5.31950884253495, -5.31994863886043,
                -5.31996894298403,
                Double.NEGATIVE_INFINITY, -105.279209516076, -0.864147984561813, -0.864198574529624,
                -0.864198574530624, -0.864198574531624, -0.869051428437913, -0.969166552139243,
                -1.13357524282489, -1.13440702155941, -1.13484490794693, -1.13486520146122,
                Double.NEGATIVE_INFINITY, -106.557291327602, -0.881420521244503, -0.881369334598643,
                -0.881369334598643, -0.881369334598643, -0.8853741309582, -0.983044419021377,
                -1.14674612500322, -1.14757780324662, -1.14801566817415, -1.14803596156924,
                Double.NEGATIVE_INFINITY, -106.557291340503, -0.881420521537747, -0.881369334890869,
                -0.881369334890869, -0.881369334890869, -0.885374131241946, -0.983044419280675,
                -1.14674612525545, -1.14757780349884, -1.14801566842638, -1.14803596182147,
                Double.NEGATIVE_INFINITY, -106.557291353284, -0.881420521710103, -0.881369335062207,
                -0.881369335062207, -0.881369335062207, -0.885374131404803, -0.983044419419084,
                -1.14674612538679, -1.14757780363018, -1.14801566855772, -1.14803596195281,
                Double.NEGATIVE_INFINITY, -119.334060094447, -1.05009640096502, -1.04902744817126,
                -1.04902744816126, -1.04902744815126, -1.0445516689502, -1.11777360036293, -1.27440545922896,
                -1.2752361325611, -1.27567378288886, -1.27569407509189,
                Double.NEGATIVE_INFINITY, -234.057005036782, -2.30020547265047, -2.28997662453469,
                -2.28997662443469, -2.28997662433469, -2.20917566516448, -2.06236238694315, -2.15536562183052,
                -2.15618725096131, -2.15662296989113, -2.15664325136565,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -33.358134432243, -32.716890573055, -32.716890566755,
                -32.716890560455, -27.3781327589647, -12.0733383726201, -7.78303640008838, -7.78323498423758,
                -7.78353765130908, -7.78355719370857, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -60.7295007273997, -59.4368865342017, -59.4368865215017,
                -59.4368865088017, -48.6705603539487, -17.7188177269607, -8.90381360483507, -8.90336904577747,
                -8.90353436899522, -8.90355314847853, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -431.591889974339, -421.180091105001, -421.180091002701,
                -421.180090900401, -334.42780779847, -84.4187898024746, -12.2579555860343, -12.2485070220815,
                -12.2467495313468, -12.2467576300037, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -19.7058931961125, -19.0481562797058, -18.9079561843938,
                -18.9071952635513, 71.7747591843016, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                2.76819202832216, -1.13029049751977, -1.13484485185734, -1.13484485190234, -1.13484485194734,
                -1.17500984010746, -1.33386258894385, -1.44752775392057, -1.44794811514294, -1.44816801330568,
                -1.44817816536748,
                Double.NEGATIVE_INFINITY, -53.3985522640497, -1.1910214982927, -1.19104679327661,
                -1.19104679327711, -1.19104679327761, -1.19347322023075, -1.24353078208142, -1.32573512742424,
                -1.3261510167915, -1.32636995998526, -1.32638010674241,
                Double.NEGATIVE_INFINITY, -54.0460756027419, -1.20814019956306, -1.20811460624013,
                -1.20811460624013, -1.20811460624013, -1.21011700441991, -1.2589521484515, -1.34080300144242,
                -1.34121884056412, -1.34143777302789, -1.34144791972543,
                Double.NEGATIVE_INFINITY, -54.0460756092165, -1.20814019973363, -1.20811460641019,
                -1.20811460641019, -1.20811460641019, -1.21011700458573, -1.25895214860509, -1.34080300159248,
                -1.34121884071418, -1.34143777317795, -1.34144791987549,
                Double.NEGATIVE_INFINITY, -54.0460756156911, -1.2081401999042, -1.20811460658025,
                -1.20811460658025, -1.20811460658025, -1.21011700475155, -1.25895214875869, -1.34080300174254,
                -1.34121884086424, -1.34143777332801, -1.34144792002555,
                Double.NEGATIVE_INFINITY, -60.5148227360949, -1.37284088935374, -1.37230641295686,
                -1.37230641295186, -1.37230641294686, -1.37006852334633, -1.40667948905269, -1.48499541848571,
                -1.48541075515178, -1.48562958031566, -1.48563972641718,
                Double.NEGATIVE_INFINITY, -118.377193932767, -2.498794150701, -2.49367972664311,
                -2.49367972659311, -2.49367972654311, -2.453279246958, -2.37987260784734, -2.42637422529103,
                -2.42678503985642, -2.42700289932133, -2.42701304005859,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -20.8558452521241, -20.5352233225301, -20.5352233193801,
                -20.5352233162301, -17.865844415485, -10.2134472223126, -8.06829623604678, -8.06839552812137,
                -8.06854686165713, -8.06855663285687, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -35.0991317816431, -34.4528246850441, -34.4528246786941,
                -34.4528246723441, -29.0696615949176, -13.5937902814236, -9.18628822036075, -9.18606594083195,
                -9.18614860244083, -9.18615799218248, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -222.198211172589, -216.99231173792, -216.99231168677,
                -216.99231163562, -173.616170084655, -48.6116610866569, -12.5312439784367, -12.5265196964603,
                -12.525640951093, -12.5256450004214, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -19.5839402122488, -19.2550717540455, -19.1849717063894,
                -19.1845912459682, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                4.03362653928928, -28.3481100869122, -28.3663734605307, -28.3663734607107, -28.3663734608907,
                -28.5233481664457, -29.0580401273774, -29.2994629077322, -29.2996457906769, -29.2997058404318,
                -29.2997067938112,
                Double.NEGATIVE_INFINITY, -560.846488149192, -0.50638679898966, -0.50648814919002,
                -0.50648814919202, -0.50648814919402, -0.515909636795326, -0.67898814919202, -0.846246526267215,
                -0.846427428748294, -0.846487196132377, -0.846488148959192,
                Double.NEGATIVE_INFINITY, -567.525856206325, -0.525958990401321, -0.525856272924866,
                -0.525856272924866, -0.525856272924866, -0.533619859217428, -0.692522939649866,
                -0.858948008831376, -0.859128889060055, -0.859188653271431, -0.859189606092038,
                Double.NEGATIVE_INFINITY, -567.525856273119, -0.52595899059705, -0.525856273118554,
                -0.525856273118554, -0.525856273118554, -0.533619859394537, -0.692522939785221,
                -0.858948008958398, -0.859128889187076, -0.859188653398453, -0.859189606219059,
                Double.NEGATIVE_INFINITY, -567.525856339912, -0.525958990792777, -0.525856273312241,
                -0.525856273312241, -0.525856273312241, -0.533619859571645, -0.692522939920574,
                -0.858948009085418, -0.859128889314096, -0.859188653525473, -0.859189606346079,
                Double.NEGATIVE_INFINITY, -634.318975126452, -0.721118520738838, -0.718975126471784,
                -0.718975126451784, -0.718975126431784, -0.710159699454539, -0.827308459785118,
                -0.985400449938113, -0.985581107642784, -0.985640840127105, -0.985641792885623,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -2.28845978486638, -2.26795029950231, -2.26795029930231,
                -2.26795029910231, -2.10992375284601, -1.85128363263565, -1.934377911607, -1.93455656659561,
                -1.93461601353643, -1.93461696573615, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -50.9519432544068, -49.666214160137, -49.666214147537,
                -49.666214134937, -39.2291993716792, -13.0828808142037, -7.99946610066199, -7.99950679076616,
                -7.99954656693244, -7.99954748063764, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -96.0989565536978, -93.5071943147511, -93.5071942893511,
                -93.5071942639511, -72.4596110186274, -19.5905276226845, -9.17394233622614, -9.17384061096572,
                -9.17386008181635, -9.17386095578528, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -715.207452445888, -694.331226181465, -694.331225976865,
                -694.331225772264, -524.735683778016, -97.7478926435312, -12.6669193362395, -12.6648237958749,
                -12.6645589923064, -12.6645593099674, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -19.7703915560065, -19.6247413281419, -19.6040087663947,
                -19.6039690298872, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                3.68785181771326, -12.5030164953875, -12.5121481821967, -12.5121481822867, -12.5121481823767,
                -12.5906355351543, -12.8579815156201, -12.9786929057975, -12.9787843472698, -12.9788143721473,
                -12.978814848837,
                Double.NEGATIVE_INFINITY, -280.997262316663, -0.827211641561597, -0.827262316661777,
                -0.827262316662777, -0.827262316663777, -0.83197306046443, -0.913512316662777,
                -0.997141505200375, -0.997231956440914, -0.997261840132956, -0.997262316546363,
                Double.NEGATIVE_INFINITY, -284.346437593492, -0.84648898553024, -0.846437626792013,
                -0.846437626792013, -0.846437626792013, -0.850319419938294, -0.929770960154513,
                -1.01298349474527, -1.01307393485961, -1.0131038169653, -1.0131042933756,
                Double.NEGATIVE_INFINITY, -284.346437626952, -0.846488985690737, -0.84643762695149,
                -0.84643762695149, -0.84643762695149, -0.850319420089481, -0.929770960284823,
                -1.01298349487141, -1.01307393498575, -1.01310381709144, -1.01310429350174,
                Double.NEGATIVE_INFINITY, -284.346437660443, -0.846488985883018, -0.846437627142749,
                -0.846437627142749, -0.846437627142749, -0.850319420272451, -0.929770960446916,
                -1.01298349502934, -1.01307393514368, -1.01310381724937, -1.01310429365967,
                Double.NEGATIVE_INFINITY, -317.832794768427, -1.03386646557063, -1.03279476843711,
                -1.03279476842711, -1.03279476841711, -1.02838705492848, -1.08696143509377, -1.16600743017027,
                -1.16609775902261, -1.16612762526477, -1.16612810164403,
                Double.NEGATIVE_INFINITY, -618.861864986101, -2.37211972888308, -2.36186498620104,
                -2.36186498610104, -2.36186498600104, -2.28285171287289, -2.15353165276771, -2.19507879225339,
                -2.19516811974769, -2.1951978432181, -2.19519831931796,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -29.7173717042658, -29.0745071571309, -29.0745071508309,
                -29.0745071445309, -23.855999762902, -10.7828404841643, -8.24113312739342, -8.24115347244551,
                -8.24117336052865, -8.24117381738125, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -52.8742563716319, -51.5783752521585, -51.5783752394585,
                -51.5783752267585, -41.0545836040966, -14.6200419061252, -9.41174926289604, -9.41169840026584,
                -9.41170813569115, -9.41170857267561, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -364.168796187613, -353.730683055401, -353.730682953101,
                -353.730682850801, -268.932911853677, -55.4390162864345, -12.8985296327886, -12.8974818626063,
                -12.8973494608221, -12.8973496196526, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -19.918338971576, -19.8455138576437, -19.8351475767701,
                -19.8351277085163, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                3.34281671395823, -4.75261744259214, -4.75718328599677, -4.75718328604177, -4.75718328608677,
                -4.79642696247552, -4.93009995270843, -4.99045564779714, -4.99050136853332, -4.99051638097204,
                -4.99051661931689,
                Double.NEGATIVE_INFINITY, -141.224204109949, -1.13917877239887, -1.13920410994896,
                -1.13920410994946, -1.13920410994996, -1.14155948185029, -1.18232910994946, -1.22414370421826,
                -1.22418892983853, -1.22420387168455, -1.22420410989126,
                Double.NEGATIVE_INFINITY, -142.908136435237, -1.15816213125623, -1.15813645188711,
                -1.15813645188711, -1.15813645188711, -1.16007734846025, -1.19980311856836, -1.24140938586374,
                -1.24145460592091, -1.24146954697375, -1.24146978517891,
                Double.NEGATIVE_INFINITY, -142.908136452076, -1.15816213144532, -1.1581364520757,
                -1.1581364520757, -1.1581364520757, -1.1600773486447, -1.19980311874237, -1.24140938603566,
                -1.24145460609283, -1.24146954714568, -1.24146978535083,
                Double.NEGATIVE_INFINITY, -142.908136468914, -1.15816213163442, -1.15813645226429,
                -1.15813645226429, -1.15813645226429, -1.16007734882914, -1.19980311891637, -1.24140938620758,
                -1.24145460626475, -1.2414695473176, -1.24146978552275,
                Double.NEGATIVE_INFINITY, -159.739723522266, -1.34025937083738, -1.33972352227062,
                -1.33972352226562, -1.33972352226062, -1.33751966551631, -1.36680685559895, -1.4063298531372,
                -1.40637501756337, -1.40638995068445, -1.40639018887408,
                Double.NEGATIVE_INFINITY, -310.800467141825, -2.55559451321613, -2.55046714187511,
                -2.55046714182511, -2.55046714177511, -2.51096050521103, -2.44630047515844, -2.46707404490128,
                -2.46711870864843, -2.46713357038364, -2.46713380843357,
                Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -19.218812718842, -18.8973804452745, -18.8973804421245,
                -18.8973804389745, -16.2881267481601, -9.7515471087912, -8.48069343040578, -8.48070360293182,
                -8.48071354697339, -8.48071377539969, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -31.3794644436067, -30.7315238838701, -30.7315238775201,
                -30.7315238711701, -25.4696280598391, -12.2523572108534, -9.64821088923881, -9.6481854579237,
                -9.64819032563636, -9.64819054412859, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -188.765506214514, -183.546449648408, -183.546449597258,
                -183.546449546108, -141.147564047546, -34.400616263925, -13.1303729371021, -13.129849052011,
                -13.1297828511188, -13.1297829305341, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY, Double.NEGATIVE_INFINITY,
                Double.NEGATIVE_INFINITY, -20.1078694130054, -20.0714568560393, -20.0662737156024,
                -20.0662637814756};

        TweedieEstimator tvp = null, tvpDp = null;
        for (double p : ps) {
            for (double phi : phis) {
                boolean forceInversion = p > 1.95 && p < 2.1;
                tvp = new TweedieEstimator(p, phi, false, false, false, forceInversion);
                tvpDp = new TweedieEstimator(p, phi, false, true, true, false); // should have higher precision
                for (double y : ys) {
                    for (double mu : mus) {
                        final double actual = tvp.logLikelihood(y, mu);
                        final double diff = (actual - results[counter]);
                        if (!roughlyEqual(actual, results[counter]))
                            System.err.println("power = " + p + ", phi = " + phi + ", y = " + y + ", mu = " + mu + "; diff = " + diff +
                                    "; Expected: " + results[counter] + "; Actual: " + actual + "; method: " + tvp._method +
                                    "; counter: " + counter + "; xi = " + (phi / Math.pow(y, 2 - p)) + "; xix = " + ((phi * Math.pow(y, 2 - p)) / (1 + (phi * Math.pow(y, 2 - p)))));

                        assert roughlyEqual(actual, results[counter]);
                        if (!forceInversion) {
                            final double actualDp = tvpDp.logLikelihood(y, mu);
                            final double diffDp = (actualDp - results[counter]);
                            if (!roughlyEqual(actualDp, results[counter]))
                                System.err.println("(with grad calculation) power = " + p + ", phi = " + phi + ", y = " + y + ", mu = " + mu + "; diff = " + diffDp +
                                        "; Expected: " + results[counter] + "; Actual: " + actualDp + "; method: " + tvp._method +
                                        "; counter: " + counter + "; xi = " + (phi / Math.pow(y, 2 - p)));

                            assert roughlyEqual(actualDp, results[counter]);
                        }
                        counter++;
                    }
                }
            }
        }
    }
}
