# Style Guide


## Capitalization

### Mixed

(always capitalize as below)

- CoffeeScript
- GitHub
- H2OFrame
- H2Ostream
- IDEA IntelliJ (use 1st time, then use either IDEA or IntelliJ after) %Which is more common?
- IPython
- JUnit
- K-fold/N-fold
- MapReduce/MapR
- MLLib
- PyPI
- RUnit

### Initial Caps

(always capitalize as below)

- Bayesian
- Flow
- Gaussian
- Gedeon method
- Hadoop
- Java
- Maven
- Laplace
- Lasso
- Nesterov accelerated gradient method
- Newton method
- Python
- Poisson
- R
- Scala
- Spark Shell
- Sparkling Water
- Terminal
- Tweedie


### Always All Caps

For any acronym, spell out in 1st use, then provide acronym in parentheses after; for pluralization, add a lowercase "s" (POJO -> POJOs, API -> APIs)

- ADADELTA 
- ADMM (alternating direction method of multipliers)
- AIC (Akaike information criterion)
- AUC (area under curve)
- API (application programming interface)
- AWS (Amazon Web Services)
- CDH (Cloudera Distribution Including Apache Hadoop)
- CPU (central processor unit)
- CRAN (Comprehensive R Archive Network)
- EC2 (Amazon Elastic Compute Cloud)
- GBM (Gradient Boosted Models)
- GLM (Generalized Linear Modeling)
- H2O
- HDFS (Hadoop Distributed File System)
- ID (identity)
- IDE (integrated development environment)
- IP (internet protocol)
- IRLSM (Iteratively Reweighted Least Squares Method)
- JSON (JavaScript Object Notation)
- JVM (Java virtual machine)
- L-BFGS (Limited-memory Broyden-Fletcher-Goldfarb-Shanno algorithm)
- MSE (mean squared error)
- NA (not available)
- NFS (network file system)
- PCA (Principal Components Analysis)
- POJO (Plain Old Java Object)
- REST (Representational State Transfer)
- S3 (Simple Storage Service)
- SGD (stochastic gradient descent)
- RDD (Resilient Distributed Dataset)
- YARN (Yet Another Resource Negotiator) 

### Always Lowercase

(unless starting a sentence or in heading)

- alpha
- autoencoder
- gamma
- lambda
- rho
- tanh


## Algos

- Naïve Bayes
LATIN SMALL LETTER I WITH DIAERESIS
Unicode: U+00EF, UTF-8: C3 AF
- Distributed Random Forest (DRF); never just RF
- Deep Learning (for all cases, not just our version)
- K-means


# One word (not two)

- Dataset
