# This file is auto-generated by h2o-3/h2o-bindings/bin/gen_R.py
# Copyright 2016 H2O.ai;  Apache License Version 2.0 (see LICENSE for details) 
#
# -------------------------- pipeline -------------------------- #
#'
#' Build a pipeline model given a list of transformers and a final model.
#' 
#' Currently R model pipelines, as produced by AutoML for example, 
#' are only available as read-only models that can not be constructed and trained directly by the end-user.  
#'
#' @param model_id Destination id for this model; auto-generated if not specified.
#' @export
h2o.pipeline <- function(model_id = NULL)
{

  # Build parameter list to send to model builder
  parms <- list()

  if (!missing(model_id))
    parms$model_id <- model_id

  # Error check and build model
  model <- .h2o.modelJob('pipeline', parms, h2oRestApiVersion=3, verbose=FALSE)
  return(model)
}
.h2o.train_segments_pipeline <- function(segment_columns = NULL,
                                         segment_models_id = NULL,
                                         parallelism = 1)
{
  # formally define variables that were excluded from function parameters
  model_id <- NULL
  verbose <- NULL
  destination_key <- NULL

  # Build parameter list to send to model builder
  parms <- list()


  # Build segment-models specific parameters
  segment_parms <- list()
  if (!missing(segment_columns))
    segment_parms$segment_columns <- segment_columns
  if (!missing(segment_models_id))
    segment_parms$segment_models_id <- segment_models_id
  segment_parms$parallelism <- parallelism

  # Error check and build segment models
  segment_models <- .h2o.segmentModelsJob('pipeline', segment_parms, parms, h2oRestApiVersion=3)
  return(segment_models)
}


.h2o.fill_pipeline <- function(model, parameters, allparams) {
  if (!is.null(model$estimator)) {
    model$estimator_model <- h2o.getModel(model$estimator$name)
  } else {
    model$estimator_model <- NULL
  }
  model$transformers <- unlist(lapply(model$transformers, function(dt) new("H2ODataTransformer", id=dt$id, description=dt$description)))
  # class(model) <- "H2OPipeline"
  return(model)
}

