# Function call for R sided cross validation of h2o objects
h2o.deeplearning.cv <- function(x, y, training_frame, nfolds = 2,
                                model_id = "",
                                overwrite_with_best_model,
                                checkpoint,
                                autoencoder = FALSE,
                                use_all_factor_levels = TRUE,
                                activation = c("Rectifier", "Tanh", "TanhWithDropout", "RectifierWithDropout", "Maxout", "MaxoutWithDropout"),
                                hidden= c(200, 200),
                                epochs = 10.0,
                                train_samples_per_iteration = -2,
                                seed,
                                adaptive_rate = TRUE,
                                rho = 0.99,
                                epsilon = 1e-8,
                                rate = 0.005,
                                rate_annealing = 1e-6,
                                rate_decay = 1.0,
                                momentum_start = 0,
                                momentum_ramp = 1e6,
                                momentum_stable = 0,
                                nesterov_accelerated_gradient = TRUE,
                                input_dropout_ratio = 0,
                                hidden_dropout_ratios,
                                l1 = 0,
                                l2 = 0,
                                max_w2 = Inf,
                                initial_weight_distribution = c("UniformAdaptive", "Uniform", "Normal"),
                                initial_weight_scale = 1,
                                loss,
                                score_interval = 5,
                                score_training_samples,
                                score_validation_samples,
                                score_duty_cycle,
                                classification_stop,
                                regression_stop,
                                quiet_mode,
                                max_confusion_matrix_size,
                                balance_classes = FALSE,
                                class_sampling_factors,
                                max_after_balance_size,
                                score_validation_sampling,
                                diagnostics,
                                variable_importances,
                                fast_mode,
                                ignore_const_cols,
                                force_load_balance,
                                replicate_training_data,
                                single_node_mode,
                                shuffle_training_data,
                                sparse,
                                col_major,
                                average_activation,
                                sparsity_beta,
                                max_categorical_features,
                                reproducible,
                                export_weights_and_biases
                            )
{
  env <- parent.frame()
  parms <- lapply(as.list(match.call()[-1L]), eval, env)
  parms$nfolds <- NULL

  do.call("h2o.crossValidate", list(model.type = 'deeplearning', nfolds = nfolds, params = parms))
}
