setwd(normalizePath(dirname(R.utils::commandArgs(asValues=TRUE)$"f")))
source("../../../scripts/h2o-r-test-setup.R")



check.verify.parameters.slot <- function() {
    Log.info("Getting data...")
    iris.hex <- h2o.uploadFile( locate("smalldata/iris/iris.csv"))
    
    Log.info("Create and and duplicate...")
    iris.km <-  h2o.kmeans(x=1:4, training_frame=iris.hex, k = 3, seed = 1234, model_id = "f00b4r")
    parameters <- getParms(iris.km)
    parameters_unmunged <- getParms(iris.km)

    parameters$model_id <- NULL
    iris.km.cpy <- do.call("h2o.kmeans", parameters)

    wss.org <- sort.int(getWithinSS(iris.km))
    wss.cpy <- sort.int(getWithinSS(iris.km.cpy))

    Log.info("Verify outputs...")
    Log.info("centers")
    print(getCenters(iris.km))
    print(getCenters(iris.km.cpy))
    expect_equivalent(getCenters(iris.km), getCenters(iris.km.cpy))

    Log.info("Within Cluster SS")
    print(wss.org)
    print(wss.cpy)
    expect_equal(wss.org, wss.cpy)
    
}

doTest("Kmeans Test: Verify correct parameters passed into model", check.verify.parameters.slot)
