setwd(normalizePath(dirname(R.utils::commandArgs(asValues=TRUE)$"f")))
source("../../scripts/h2o-r-test-setup.R")
#----------------------------------------------------------------------
# Purpose:  This test exercises the GBM model downloaded as java code
#           for the iris data set.
#
# Notes:    Assumes unix environment.
#           curl, javac, java must be installed.
#           java must be at least 1.6.
#----------------------------------------------------------------------



test.gbm.javapredict.iris.pub <-
function() {
    #----------------------------------------------------------------------
    # Parameters for the test.
    #----------------------------------------------------------------------
    training_file <- locate("smalldata/iris/iris_train.csv")
    test_file <- locate("smalldata/iris/iris_test.csv")
    training_frame <- h2o.importFile(training_file)
    test_frame <- h2o.importFile(test_file)

    params                 <- list()
    params$ntrees          <- 944
    params$max_depth       <- 4
    params$min_rows        <- 2
    params$learn_rate      <- 0.2
    params$x               <- c("sepal_len","sepal_wid","petal_len","petal_wid");
    params$y               <- "species"
    params$training_frame  <- training_frame

    #----------------------------------------------------------------------
    # Run the test
    #----------------------------------------------------------------------
    doJavapredictTest("gbm",test_file,test_frame,params)
}

doTest("GBM test", test.gbm.javapredict.iris.pub)
