setwd(normalizePath(dirname(R.utils::commandArgs(asValues=TRUE)$"f")))
source("../../scripts/h2o-r-test-setup.R")


test.seed.string <- function() {
    data <- h2o.importFile(path = locate('smalldata/iris/iris.csv'))
    names(data)[5]<-paste("Species")
    df <- as.h2o(data)

    # Set parameters
    params                      <- list()
    params$y                    <- "Species"
    params$training_frame       <- df
    params$ntrees               <- 3
    params$score_each_iteration <- TRUE

    # Get autogenerated seed as string, it could not be string by default
    auto_seed <- NULL
    while(!is.character(auto_seed)){
        # Train GBM model
        gbm_model1 <- do.call(h2o.gbm, params)
        auto_seed <- h2o.get_seed(gbm_model1)
    }
    rmse1 <- gbm_model1@model$scoring_history$training_rmse
    logloss1 <- gbm_model1@model$scoring_history$training_logloss

    # Train model with string seed
    params$seed <- auto_seed
    gbm_model2 <- do.call(h2o.gbm, params)
    rmse2 <- gbm_model2@model$scoring_history$training_rmse
    logloss2 <- gbm_model2@model$scoring_history$training_logloss

    # Compare results with same string seed setting autogenerated from h2o server
    expect_equal(auto_seed, h2o.get_seed(gbm_model2))
    expect_equal(rmse1, rmse2)
    expect_equal(logloss1, logloss2)

    # Expect warning when using long number in R
    params$seed <- -8664354335142703762
    message <- "R can handle only 53-bit integer without loss."
    expect_warning(do.call(h2o.gbm, params), warn_string_of_interest=message)

    # Expect warning when using bigger number than 53 bit 
    params$seed <- 9007199254740992
    message <- "R can handle only 53-bit integer without loss."
    expect_warning(do.call(h2o.gbm, params), warn_string_of_interest=message)
    
    # should pass without loss, seed is less than 2^53
    params$seed <- 9007199254740991
    gbm_model <- do.call(h2o.gbm, params)
    seed <- h2o.get_seed(gbm_model)
    expect_equal(params$seed, seed)
    
    # Expect error when passing non-long string as the seed parameter
    params$seed <- "-86643543351427037621"
    message <- "\"seed\" must be of type long or string long, but got a string which cannot be converted to long."
    expect_error(do.call(h2o.gbm, params), warn_string_of_interest=message)

    # Expect error when passing non-long number as the seed parameter
    params$seed <- -86643543351427037621
    message <- "\"seed\" must be of type long or string long, but got a number which cannot be converted to long."
    expect_error(do.call(h2o.gbm, params), warn_string_of_interest=message)

    # Expect error when passing non-long number as the seed parameter
    params$seed <- "hello"
    message <- "\"seed\" must be of type long or string long, but got a string which cannot be converted to long."
    expect_error(do.call(h2o.gbm, params), warn_string_of_interest=message)
    
    options("h2o.warning.on.json.string.conversion" = TRUE)
    params$seed <- -1
    message <- "During parsing the JSON response from H2O API to R bindings a conversion from long to string has occurred."
    expect_warning(do.call(h2o.gbm, params), warn_string_of_interest=message)
}

doTest("Test seed long vs. string", test.seed.string)
