# Contributing to Awesome Elixir

:+1: First off, thanks for taking the time to contribute! :+1:

The following is a set of guidelines for contributing to Awesome Elixir.
These are just guidelines, not rules, use your best judgment and feel free to propose changes to this document in a pull request.

## How Can I Contribute?

### Submitting Pull Requests

Do you know any cool Elixir project that isn't listed here? Please submit a pull request, we will be happy to receive it.

Feel free to take any open issue, just make sure that you follow the contribution guidelines.

### Improving the tests

You are an awesome Elixir developer and think that we can improve our tests? Nice! Feel free to send your contributions.

## Contribution Guidelines

* Create a pull request, not an issue.
* Please search previous suggestions before making a new one, as yours may be a duplicate.
* Libraries that are compatible with latest Elixir, hex-installable, tested and documented are preferred.
* For packages use a link to the source repository like GitHub or Bitbucket.
* Please make an individual pull request for each suggestion.
* Prefix duplicate library names with their vendor or namespace followed by a space.
* Keep descriptions short and simple.
* End all descriptions with a full stop/period.
* Check your spelling and grammar.
* New categories, or improvements to the existing categorisation are welcome.
* Category names have to be alphabetically sorted from a-z.
* Entry names inside Categories have to be alphabetically sorted from a-z.
* Use [EditorConfig](http://editorconfig.org) to ensure consistent line-endings, tabs/spaces, etc. or make sure manually that your Editor is configured 'the right way' (see `.editorconfig` for details).

Thank you for your contribution and suggestions!
