# Mind Expanding Books

[![Awesome](https://cdn.rawgit.com/sindresorhus/awesome/d7305f38d29fed78fa85652e3a63e154dd8e8829/media/badge.svg)](https://github.com/sindresorhus/awesome)

Looking to find a book an interesting book to read but don't know where to start? You are in the right place!

See [Contributing Guidelines](CONTRIBUTING.md) for details on how the books are curated.

<a id="top"></a>
## Table of Contents
- [Mind Expanding Books](#mind-expanding-books)
  - [Table of Contents](#table-of-contents)
- [Books](#books)
  - [Startups and Business](#startups-and-business)
  - [Philosophy And Psychology](#philosophy-and-psychology)
  - [Autobiographies and Biographies](#autobiographies-and-biographies)
  - [History](#history)
  - [Science and Medicine](#science-and-medicine)
  - [Logic and Problem Solving](#logic-and-problem-solving)
  - [Politics](#politics)
  - [Economics](#economics)
  - [Gender](#gender)
  - [Sexuality](#sexuality)
  - [Race](#race)
  - [Education](#education)
  - [Writing](#writing)
  - [Theater and Film](#theater-and-film)
  - [Shakespeare](#shakespeare)
  - [Fiction](#fiction)
    - [Classics](#classics)
    - [Fantasy](#fantasy)
    - [Historical Fiction](#historical-fiction)
    - [Humor](#humor)
    - [Mystery](#mystery)
    - [Science Fiction](#science-fiction)
    - [Horror](#horror)
    - [Miscellaneous](#miscellaneous)
  - [Health](#health)
  - [Design](#design)
  - [Travel](#travel)
  - [Language](#language)
  - [Nature](#nature)
  - [Art](#art)
  - [Credits](#credits)
  - [License](#license)

# Books

## Startups and Business
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| Shoe Dog: A Memoir by the Creator of Nike | Phil Knight | [4.46](https://www.goodreads.com/book/show/27220736-shoe-dog) | 2016 |
| The Ride of a Lifetime: Lessons Learned from 15 Years as CEO of the Walt Disney Company | Robert Iger, Joel Lovell | [4.44](https://www.goodreads.com/book/show/44525305-the-ride-of-a-lifetime) | 2019 |
| Bad Blood: Secrets and Lies in a Silicon Valley Startup | John Carreyrou | [4.4](https://www.goodreads.com/book/show/37976541-bad-blood) | 2018 |
| The Compound Effect | Darren Hardy | [4.40](https://www.goodreads.com/book/show/9420697-the-compound-effect) | 2010 |
| Never Split the Difference | Chris Voss | [4.39](https://www.goodreads.com/book/show/26156469-never-split-the-difference) | 2016 |
| Failing to Succeed: The Story of India's First E-Commerce Company | K. Vaitheeswaran | [4.39](https://www.goodreads.com/book/show/35626210-failing-to-succeed) | 2017 |
| High Output Management | Andy Grove | [4.38](https://www.goodreads.com/book/show/324750.High_Output_Management) | 1995 |
| Outwitting the Devil: The Secret to Freedom and Success | Napoleon Hill | [4.38](https://www.goodreads.com/book/show/10713286-outwitting-the-devil) | 2011 |
| The Millionaire Fastlane: Crack the Code to Wealth and Live Rich for a Lifetime! | M.J. DeMarco | [4.28](https://www.goodreads.com/book/show/18872437-the-millionaire-fastlane) | 2011 |
| How to Get From Where You Are to Where You Want to Be : The 25 Principles of Success | Jack Canfield, Janet Switzer | [4.26](https://www.goodreads.com/book/show/96593.The_Success_Principles) | 2007 |
| The Big Short: Inside the Doomsday Machine | Michael Lewis | [4.26](https://www.goodreads.com/book/show/8032112-the-big-short) | 2015 |
| The Future Is Faster Than You Think: How Converging Technologies Are Transforming Business, Industries, and Our Lives | Peter H. Diamandis, Steven Kotler | [4.25](https://www.goodreads.com/book/show/52290273-the-future-is-faster-than-you-think) | 2020 |
| The Middle Finger Project | Ash Ambirge | [4.22](https://www.goodreads.com/book/show/46064079-the-middle-finger-project?from_search=true&from_srp=true&qid=WY4obsfps3&rank=1) | 2020 |
| Creativity, Inc.: Overcoming the Unseen Forces That Stand in the Way of True Inspiration |  Ed Catmull, Amy Wallace | [4.21](https://www.goodreads.com/book/show/18077903-creativity-inc) | 2014 |
| The Score Takes Care of Itself: My Philosophy of Leadership | Bill Walsh, Steve Jamison, Craig Walsh | [4.21](https://www.goodreads.com/book/show/6342995-the-score-takes-care-of-itself) | 2009 |
| The Hard Thing About Hard Things: Building a Business When There Are No Easy Answers | Ben Horowitz | [4.20](https://www.goodreads.com/book/show/18176747-the-hard-thing-about-hard-things) | 2014 |
| Think and Grow Rich | Napoleon Hill | [4.17](https://www.goodreads.com/book/show/30186948-think-and-grow-rich) | 1937 |
| AI Superpowers: China, Silicon Valley, and the New World Order |  Kai-Fu Lee | [4.16](https://www.goodreads.com/book/show/38242135-ai-superpowers) | 2018 |
| Nail it then Scale it: The Entrepreneur's Guide to Creating and Managing Breakthrough | Nathan Furr | [4.13](https://www.goodreads.com/book/show/12236649-nail-it-then-scale-it) | 2011 |
| Outliers: Story of Success | Malcolm Gladwell | [4.11](https://www.goodreads.com/work/quotes/3364437-outliers-the-story-of-success) | 2008 |
| The Strategy and Tactics of Pricing : A Guide to Move More Profitable | Thomas Nagle, John Hogan, Joseph Zale | [4.09](https://www.goodreads.com/book/show/99919.The_Strategy_and_Tactics_of_Pricing) | 2005 |
| Principles: Life and Work | Ray Dalio | [4.07](https://www.goodreads.com/book/show/34536488-principles) | 2017 |
| Start with Why: How Great Leaders Inspire Everyone to Take Action | Simon Sinek | [4.07](https://www.goodreads.com/book/show/7108725-start-with-why) | 2009 |
| Leaving Microsoft to Change the World: An Entrepreneur's Odyssey to Educate the World's Children | John Wood | [4.07](https://www.goodreads.com/book/show/95429.Leaving_Microsoft_to_Change_the_World) | 2006 |
| Hackers and Painters | Paul Graham | [4.06](https://www.goodreads.com/book/show/41793.Hackers_Painters) | 2004 |
| How Google Works | Eric Schmidt, Jonathan Rosenberg | [4.06](https://www.goodreads.com/book/show/23158207-how-google-works) | 2014 |
| Crucial Conversations: Tools for Talking When Stakes Are High | Kerry Patterson, Joseph Grenny, Ron McMillan, Al Switzler | [4.05](https://www.goodreads.com/book/show/15014.Crucial_Conversations) | 2002 |
| Good to Great: Why Some Companies Make the Leap And Others Don't | Jim Collins | [4.05](https://www.goodreads.com/book/show/76865.Good_to_Great) | 2001 |
| The Lean Startup: How Constant Innovation Creates Radically Successful Businesses | Eric Ries | [4.04](https://www.goodreads.com/book/show/10127019-the-lean-startup) | 2011 |
| The Power of Full Engagement: Managing Energy, Not Time, is the Key to High Performance and Personal Renewal | Jim Loehr, Tony Schwartz | [4.03](http://www.goodreads.com/book/show/68985.The_Power_of_Full_Engagement) | 2005 |
| The Checklist Manifesto: How To Get Things Right | Atul Gawande | [4.03](http://www.goodreads.com/book/show/6667514-the-checklist-manifesto) | 2009 |
| Where Good Ideas Come From | Steven Johnson | [4.03](https://www.goodreads.com/book/show/8034188-where-good-ideas-come-from) | 2010 |
| Delivering Happiness: A Path to Profits, Passion, and Purpose | Tony Hsieh | [4.01](http://www.goodreads.com/book/show/6828896-delivering-happiness) | 2010 |
| The Innovator's Dilemma | clayton m. christensen | [4.00](https://www.goodreads.com/book/show/2615.The_Innovator_s_Dilemma) | 1997 |
| Influencer: The New Science of Leading Change | Joseph Grenny, Kerry Patterson | [3.98](https://www.goodreads.com/book/show/914211.Influencer) | 2007 |
| The E-Myth Revisited: Why Most Small Businesses Don't Work and What to Do About It | Michael E. Gerber | [3.98](https://www.goodreads.com/book/show/81948.The_E_Myth_Revisited) | 1995 |
| Getting Things Done: The Art of Stress-Free Productivity | David Allen | [3.98](https://www.goodreads.com/book/show/1633.Getting_Things_Done) | 2001 |
| Losing My Virginity: How I Survived, Had Fun, and Made a Fortune Doing Business My Way | Richard Branson | [3.97](https://www.goodreads.com/book/show/211099.Losing_My_Virginity) | 1998 |
| SuperFreakonomics: Global Cooling, Patriotic Prostitutes, and Why Suicide Bombers Should Buy Life Insurance | Steven D. Litt | [3.96](https://www.goodreads.com/book/show/6402364-superfreakonomics) | 2009 |
| The Ten Faces of Innovation | Tom Kelley | [3.96](https://www.goodreads.com/book/show/95656.The_Ten_Faces_of_Innovation) | 2005 |
| Rich Dad Poor Dad : What The Rich Teach Their Kids About Money That The Poor And Middle Class Don't | Robert T. Kiyosaki | [3.95](https://www.goodreads.com/book/show/69571.Rich_Dad_Poor_Dad) | 1997 |
| Founders At Work: Stories Of Startups Early Days | Jessica Livingston | [3.94](https://www.goodreads.com/book/show/98233.Founders_at_Work) | 2007 |
| The Paypal Wars | Eric M. Jackson | [3.94](https://www.goodreads.com/book/show/4052.The_PayPal_Wars) | 2010 |
| Lean In : Women, Work and the Will to Lead | Sheryl Sandberg | [3.94](http://www.goodreads.com/book/show/16071764-lean-in) | 2013 |
| ReWork: Change the Way You Work Forever | David Heinemeier Hansson | [3.93](https://www.goodreads.com/book/show/6732019-rework) | 2010 |
| The 22 Immutable Laws Of Branding | Laura Ries and Al Ries | [3.93](https://www.goodreads.com/book/show/1565533.The_22_Immutable_Laws_of_Branding) | 1998 |
| Freakonomics: A Rogue Economist Explores the Hidden Side of Everything | Steven D. Levitt, Stephen J. Dubner | [3.93](https://www.goodreads.com/book/show/1202.Freakonomics) | 2006 |
| The Tipping Point: How Little Things Can Make a Big Difference | Malcolm Gladwell | [3.92](https://www.goodreads.com/book/show/2612.The_Tipping_Point) | 2002 |
| The Four Steps to the Epiphany | Steve Blank | [3.92](https://www.goodreads.com/book/show/762542.The_Four_Steps_to_the_Epiphany) | 2005 |
| The Curse of the Mogul | Jonathan A. Knee, Bruce C. Greenwald, Ava Seave | [3.91](https://www.goodreads.com/book/show/7162410-the-curse-of-the-mogul) | 2009 |
| David and Goliath: Underdogs, Misfits, and the Art of Battling Giants | Malcolm Gladwell | [3.90](https://www.goodreads.com/book/show/15751404-david-and-goliath) | 2013 |
| Strategy for Sustainability: A Business Manifesto | Adam Werbach | [3.89](https://www.goodreads.com/book/show/6553353-strategy-for-sustainability) | 2009 |
| The Black Swan: The Impact of the Highly Improbable | Nassim Nicholas Taleb | [3.88](http://www.goodreads.com/book/show/242472.The_Black_Swan) | 2007 |
| Contagious: Why Things Catch On | Jonah Berger | [3.88](https://www.goodreads.com/book/show/15801967-contagious) | 2013 |
| Who Says Elephants Can't Dance?: Leading a Great Enterprise through Dramatic Change | Louis V Gerstner, Jr | [3.88](https://www.goodreads.com/book/show/603985.Who_Says_Elephants_Can_t_Dance_) | 2003 |
| Linchpin: Are You Indispensable | Seth Godin | [3.87](https://www.goodreads.com/book/show/7155145-linchpin) | 2010 |
| The $100 Startup: Reinvent the Way You Make a Living, Do What You Love, and Create a New Future | Chris Guillebeau | [3.85](https://www.goodreads.com/book/show/12605157-the-100-startup) | 2012 |
| Too Big to Fail | Andrew Ross Sorkin | [3.85](https://www.goodreads.com/book/show/6687247-too-big-to-fail) | 2011 |
| The Paradox of Choice: Why More Is Less | Barry Shwartz | [3.84](https://www.goodreads.com/book/show/10639.The_Paradox_of_Choice) | 2005 |
| The Art of the Start: The Time-Tested, Battle-Hardened Guide for Anyone Starting Anything | Guy Kawasaki | [3.82](https://www.goodreads.com/book/show/37875.The_Art_of_the_Start) | 2004 |
| Crowdsourcing: Why the Power of the Crowd Is Driving the Future of Business | Jeff Howe | [3.82](https://www.goodreads.com/book/show/2601510-crowdsourcing) | 2008 |
| Cognitive Surplus: Creativity and Generosity in a Connected Age | Clay Shirky | [3.82](https://www.goodreads.com/book/show/7614793-cognitive-surplus) | 2010 |
| Data Driven | D.J. Patil | [3.80](https://www.goodreads.com/book/show/24780653-data-driven) | 2015 |
| Zero to One | Peter Thiel, Blake Masters | [3.75](https://www.goodreads.com/book/show/18050143-zero-to-one) | 2014 |
| One Click: Jeff Bezos and the Rise of Amazon.com | Richard Brandt | [3.75](https://www.goodreads.com/book/show/11223478-one-click) | 2011 |
| Big Data: A Revolution That Will Transform How We Live, Work, and Think | Kenneth Cukier | [3.70](https://www.goodreads.com/book/show/15815598-big-data) | 2013 |
| The 4-Hour Work Week: Escape the 9-5, Live Anywhere and Join the New Rich | Timothy Ferriss | [3.61](https://www.goodreads.com/book/show/368593.The_4_Hour_Workweek) | 2012 |
| The Accidental Billionaires : The Founding of Facebook, a Tale of Sex, Money, Genius and Betrayal | Ben Mezrich | [3.50](https://www.goodreads.com/book/show/6326920-the-accidental-billionaires) | 2009 |

If you like Mind Expanding books you should check out my new project http://diff.blog. It's a platform that help you keep updated with the developer community.

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Philosophy And Psychology
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| The Almanack of Naval Ravikant: A Guide to Wealth and Happiness | Eric Jorgenson | [4.64](https://www.goodreads.com/book/show/54898389-the-almanack-of-naval-ravikant) | 2020 |
| Karma Yoga | Swami Vivekanand | [4.51](https://www.goodreads.com/book/show/827031.Karma_Yoga) | 1999 |
| The Ascent of Humanity | Charles Eisenstein | [4.43](https://www.goodreads.com/book/show/482505.The_Ascent_of_Humanity) | 2007
| Tattoos on the Heart: The Power of Boundless Compassion | Gregory Boyle | [4.41](https://www.goodreads.com/book/show/7090193-tattoos-on-the-heart) | 2010 |
| The Slight Edge - Secret to a Successful Life | Jeff Olson | [4.39](https://www.goodreads.com/book/show/590652.The_Slight_Edge) | 2005 |
| Education and the Significance of Life | Krishnamurti | [4.38](https://www.goodreads.com/book/show/353435.Education_and_the_Significance_of_Life) | 2008 |
| Passions Within Reason: The Strategic Role of the Emotions | Robert H. Frank | [4.34](https://www.goodreads.com/book/show/452114.Passions_Within_Reason) | 1989 |
| The Daily Stoic: 366 Meditations on Wisdom, Perseverance, and the Art of Living | Ryan Holiday, Stephan Hanselman | [4.34](https://www.goodreads.com/book/show/29093292-the-daily-stoic) | 2016 |
| Man's Search for Meaning | Viktor E. Frankl | [4.33](https://www.goodreads.com/book/show/4069.Man_s_Search_for_Meaning) | 2006 |
| Atomic Habits: An Easy & Proven Way to Build Good Habits & Break Bad Ones| James Clear | [4.32](https://www.goodreads.com/book/show/40121378-atomic-habits) | 2018 |
| The User Illusion: Cutting Consciousness Down to Size | Tor Norretranders | [4.30](https://www.goodreads.com/book/show/106732.The_User_Illusion) | 1999 |
| Born to Run: A Hidden Tribe, Superathletes, and the Greatest Race the World Has Never Seen | Christopher McDougall | [4.27](https://www.goodreads.com/book/show/6289283-born-to-run) | 2009 |
| Prometheus Rising | Robert Anton Wilson | [4.26](https://www.goodreads.com/book/show/28597.Prometheus_Rising) | 2010 |
| The Concise 48 Laws of Power | Robert Greene | [4.25](https://www.goodreads.com/book/show/18224060-the-concise-48-laws-of-power) | 2011 |
| The Hero with a Thousand Faces | Joseph Campbell | [4.24](https://www.goodreads.com/book/show/588138.The_Hero_With_a_Thousand_Faces) | 1972 |
| The Magic of Thinking Big | David J. Schwartz | [4.23](https://www.goodreads.com/book/show/759945.The_Magic_of_Thinking_Big) | 1959 |
| Zen Mind, Beginner's Mind | Shunryu Suzuki, David Chadwick | [4.23](https://www.goodreads.com/book/show/402843.Zen_Mind_Beginner_s_Mind) |  |
| The Age of Insight: The Quest to Understand the Unconscious in Art, Mind, and Brain, from Vienna 1900 to the Present | Eric Kandel | [4.22](https://www.goodreads.com/book/show/12263681-the-age-of-insight) | 2012 |
| Meditations | Marcus Aurelius | [4.21](https://www.goodreads.com/book/show/30659.Meditations) |  |
| Influence: The Psychology of Persuasion | Robert B. Cialdini | [4.18](https://www.goodreads.com/book/show/5752.The_Blank_Slate) | 2006 |
| The Gift of Fear: Survival Signals That Protect Us from Violence | Gavin de Becker | [4.18](https://www.goodreads.com/book/show/56465.The_Gift_of_Fear) | 2000 |
| Gifts of Imperfection | Brene Brown | [4.18](https://www.goodreads.com/book/show/7015403-the-gifts-of-imperfection) |  |
| Metamagical Themas: Questing For The Essence Of Mind And Pattern | Douglas Hofstadter | [4.16](https://www.goodreads.com/book/show/181239.Metamagical_Themas) | 1996 |
| The Truth About Everything: An Irreverent History of Philosophy : With Illustrations | Matthew Stewart | [4.15](https://www.goodreads.com/book/show/18528861-the-truth-about-everything) | 1997 |
| Illusions: The Adventures of a Reluctant Messiah | Richard Bach | [4.15](https://www.goodreads.com/book/show/29946.Illusions) | 1977 |
| How to Win Friends and Influence People | Dale Carnegie | [4.14](https://www.goodreads.com/book/show/4865.How_to_Win_Friends_and_Influence_People) | 1998 |
| Creative Visualization: Use the Power of Your Imagination to Create What You Want in Your Life | Shakti Gawain | [4.13](https://www.goodreads.com/book/show/582533.Creative_Visualization) | 2002 |
| Bulfinch's Mythology | Thomas Bulfinch | [4.13](https://www.goodreads.com/book/show/588147.Bulfinch_s_Mythology) | 1998 |
| Ego Is the Enemy | Ryan Holiday | [4.12](https://www.goodreads.com/book/show/27036528-ego-is-the-enemy) | 2016 |
| Awaken the Giant Within: How to Take Immediate Control of Your Mental, Emotional, Physical and Financial Destiny! | Anthony Robbins | [4.11](https://www.goodreads.com/book/show/180116.Awaken_the_Giant_Within) | 1991 |
| The Power of Now: A Guide to Spiritual Enlightenment | Eckhart Tolle | [4.11](https://www.goodreads.com/book/show/6708.The_Power_of_Now) | 1997 |
| Tuesdays with Morrie | Mitch Albom | [4.11](https://www.goodreads.com/book/show/6900.Tuesdays_with_Morrie) | 1997 |
| The Way of the Monk | Gaur Gopal Das | [4.10](https://www.goodreads.com/book/show/45712959-the-way-of-the-monk) | 2020 |
| Predictably Irrational | Dan Ariely | [4.10](https://www.goodreads.com/book/show/1713426.Predictably_Irrational) | 2008 |
| Flow: The Psychology of Optimal Experience | Mihaly Csikszentmihalyi | [4.10](https://www.goodreads.com/book/show/66354.Flow) | 1990 |
| Thinking, Fast and Slow | Daniel Kahneman | [4.09](https://www.goodreads.com/book/show/11468377-thinking-fast-and-slow) | 2011 |
| Irrational Man: A Study in Existential Philosophy | William Barrett | [4.09](https://www.goodreads.com/book/show/83321.Irrational_Man) |  |
| Happy: Why More or Less Everything is Absolutely Fine | Derren Brown | [4.08](https://www.goodreads.com/book/show/30142270-happy) | 2016 |
| The Beginning of Infinity: Explanations That Transform the World | David Deutsch | [4.08](https://www.goodreads.com/book/show/10483171-the-beginning-of-infinity) | 2011 |
| Metaphors We Live By | George Lakoff, Mark Johnson | [4.08](https://www.goodreads.com/book/show/34459.Metaphors_We_Live_By) | 2003 |
| Grit | Angela Duckworth | [4.08](https://www.goodreads.com/book/show/27213329-grit) | 2016 |
| In Defense of Food: An Eater's Manifesto | Michael Pollan | [4.07](https://www.goodreads.com/book/show/315425.In_Defense_of_Food) | 2008 |
| The Blank Slate: The Modern Denial of Human Nature | Steven Pinker | [4.07](http://www.goodreads.com/book/show/5752.The_Blank_Slate) | 2003 |
| The History of Western Philosophy | Bertrand Russell | [4.06](https://www.goodreads.com/book/show/243685.A_History_of_Western_Philosophy) | 2008 |
| Moral Tribes: Emotion, Reason, and the Gap Between Us and Them | Joshua Greene | [4.05](https://www.goodreads.com/book/show/17707599-moral-tribes) | 2013 |
| Thus Spoke Zarathustra | Friedrich Nietzsche | [4.05](https://www.goodreads.com/book/show/51893.Thus_Spoke_Zarathustra) | 1883 |
| The Elephant in the Brain: Hidden Motives in Everyday Life | Kevin Simler, Robin Hanson | [4.05](https://www.goodreads.com/book/show/28820444-the-elephant-in-the-brain) | 2017 |
| Quiet: The Power of Introverts in a World That Can't Stop Talking | Susan Cain | [4.04](https://www.goodreads.com/book/show/8520610-quiet) | 2012 |
| The Future of the Mind: The Scientific Quest to Understand, Enhance, and Empower the Mind | Michio Kaku | [4.04](https://www.goodreads.com/book/show/17978489-the-future-of-the-mind) | 2014 |
| Every Thing Must Go: Metaphysics Naturalized | James Ladyman, Don Ross, et al | [4.04](https://www.goodreads.com/book/show/757403.Every_Thing_Must_Go) | 2007 |
| Antifragile: Things That Gain from Disorder (Incerto) | Nassim Nicholas Taleb | [4.04](https://www.goodreads.com/book/show/13530973-antifragile) | 2012 |
| Mindset: The new psychology of success | Carol S. Dweck,Ph.D. | [4.04](https://www.goodreads.com/book/show/40745.Mindset) | 2006 |
| The Power of Habit: Why We Do What We Do In Life And Business | Charles Duhigg | [4.03](https://www.goodreads.com/book/show/12609433-the-power-of-habit) | 2012 |
| The Upside of Irrationality: The Unexpected Benefits of Defying Logic | Dan Ariely | [4.00](https://www.goodreads.com/book/show/7815744-the-upside-of-irrationality) | 2010 |
| Outsmarting IQ: The Emerging Science of Learnable Intelligence | David Perkins | [4.00](https://www.goodreads.com/book/show/1008488.Outsmarting_Iq) | 1995 |
| The Art of War | Sun Tzu | [3.95](https://www.goodreads.com/book/show/10534.The_Art_of_War) | 2005 |
| Willpower: Rediscovering the Greatest Human Strength | Ron P. Baumeister, John Tierney | [3.95](https://www.goodreads.com/book/show/11104933-willpower) | 2011 |
| A Whole New Mind: Why Right-Brainers Will Rule the Future | Daniel H. Pink | [3.95](https://www.goodreads.com/book/show/99315.A_Whole_New_Mind) |2006  |
| Vagabonding: An Uncommon Guide to the Art of Long-Term World Travel | Rolf Potts | [3.92](https://www.goodreads.com/book/show/100247.Vagabonding) |2002  |
| Supernormal: Science, Yoga, and the Evidence for Extraordinary Psychic Abilities | Dean Radin | [3.91](https://www.goodreads.com/book/show/8694125-alone-together) | 2013 |
| Prisoner's Dilemma | William Poundstone | [3.91](https://www.goodreads.com/book/show/29506.Prisoner_s_Dilemma) | 1993 |
| The Subtle Art Of Not Giving a F@ck: A Counterintuitive Approach to Living a Good Life | Mark Manson | [3.91](https://www.goodreads.com/book/show/28257707-the-subtle-art-of-not-giving-a-f-ck) | 2017 |
| The Stuff of Thought: Language as a Window into Human Nature | Steven Pinker | [3.90](https://www.goodreads.com/book/show/373969.The_Stuff_of_Thought) | 2007 |
| Consilience: The Unity of Knowledge | Edward O. Wilson | [3.90](https://www.goodreads.com/book/show/55981.Consilience) | 1999 |
| Why We Make Mistakes: How We Look Without Seeing, Forget Things in Seconds, and Are All Pretty Sure We Are Way Above Average | Joseph T. Hallinan | [3.87](https://www.goodreads.com/book/show/5040579-why-we-make-mistakes) | 2009 |
| You Just Don't Understand: Women and Men in Conversation | Deborah Tannen | [3.86](https://www.goodreads.com/book/show/147222.You_Just_Don_t_Understand) | 2007 |
| Just the Arguments: 100 of the Most Important Arguments in Western Philosophy | Michael Bruce, Steven Barbone | [3.85](https://www.goodreads.com/book/show/12838972-just-the-arguments) | 2011 |
| What the Dog Saw: and other adventures | Malcolm Gladwell | [3.82](https://www.goodreads.com/book/show/6516450-what-the-dog-saw-and-other-adventures) | 2009 |
| Spent: Sex, Evolution, and Consumer Behavior | Geoffrey Miller | [3.82](https://www.goodreads.com/book/show/6283340-spent) | 2009 |
| Games People Play: The Basic Handbook of Transactional Analysis | Eric Berne. | [3.81](https://www.goodreads.com/book/show/49176.Games_People_Play) | 1964 |
| This Will Make You Smarter: New Scientific Concepts to Improve Your Thinking | John Brockman | [3.81](https://www.goodreads.com/book/show/13035774-this-will-make-you-smarter) | 2012 |
| Intuition Pumps And Other Tools for Thinking | Daniel C. Dennett | [3.80](https://www.goodreads.com/book/show/18378002-intuition-pumps-and-other-tools-for-thinking) | 2014 |
| Jonathan Livingston Seagull | Richard Bach | [3.80](https://www.goodreads.com/book/show/71728.Jonathan_Livingston_Seagull) |  1970|
| Why Does the World Exist?: An Existential Detective Story | Jim Holt | [3.77](http://www.goodreads.com/book/show/8854815-why-does-the-world-exist) | 2012 |
| The Social Contract | Jean-Jacques Rousseau, Maurice Cranston | [3.75](https://www.goodreads.com/book/show/12651.The_Social_Contract) | 2009 |
| The Ethical Brain: The Science of Our Moral Dilemmas | Michael S. Gazzaniga | [3.70](https://www.goodreads.com/book/show/328734.The_Ethical_Brain) | 2006 |
| Why Smart People Can Be So Stupid | Robert J Sternberg | [3.68](https://www.goodreads.com/book/show/300300.Why_Smart_People_Can_Be_So_Stupid) | 2003 |
| Alone Together: Why We Expect More from Technology and Less from Each Others | Sherry Turkle | [3.62](http://www.goodreads.com/book/show/8694125-alone-together) | 2011 |
| How to Win Every Argument: The Use and Abuse of Logic | Madsen Pirie | [3.55](https://www.goodreads.com/book/show/112731.How_to_Win_Every_Argument) | 2006 |
| Rapt: Attention and the Focused Life: Winifred Gallagher | Winifred Gallagher | [3.54](https://www.goodreads.com/book/show/6262510-rapt) | 2009 |
| Utilitarianism | Geoffrey Scarre | [3.50](https://www.goodreads.com/book/show/3807762-utilitarianism) | 1996 |
| The Age of Em: Work, Love and Life When Robots Rule the Earth | Robin Hanson | [3.41](https://www.goodreads.com/book/show/26831944-the-age-of-em) | 2016 |
| The Fine Art of Small Talk: How To Start a Conversation, Keep It Going, Build Networking Skills -- and Leave a Positive Impression | Debra Fine | [3.36](https://www.goodreads.com/book/show/93409.The_Fine_Art_of_Small_Talk) | 2005 |
| Snoop: What Your Stuff Says About You: Sam Gosling | Sam Gosling | [3.33](https://www.goodreads.com/book/show/1581330.Snoop) | 2001 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Autobiographies and Biographies
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| Becoming | Michelle Obama | [4.53](https://www.goodreads.com/book/show/38746485-becoming) | 2018 |
| Unbroken: A World War II Story of Survival, Resilience, and Redemption | Laura Hillenbrand | [4.39](https://www.goodreads.com/book/show/8664353-unbroken) | 2010 |
| Everything Beautiful in Its Time: Seasons of Love and Loss | Jenna Bush Hager | [4.38](https://www.goodreads.com/book/show/51822870-everything-beautiful-in-its-time) | 2020 |
| Long Walk to Freedom | Nelson Mandela | [4.31](http://www.goodreads.com/book/show/318431.Long_Walk_to_Freedom) | 1995 |
| My Life and My Work | Henry Ford | [4.29](http://www.goodreads.com/book/show/1122054.My_Life_And_Work) | 1922 |
| Surely You're Joking, Mr. Feynman!: Adventures of a Curious Character | Richard Feynman | [4.29](https://www.goodreads.com/book/show/5544.Surely_You_re_Joking_Mr_Feynman_) | 1997 |
| The Autobiography of Malcolm X | Malcolm X, Alex Haley | [4.29](http://www.goodreads.com/book/show/92057.The_Autobiography_of_Malcolm_X) |1965  |
| The Third Door:The Wild Quest to Uncover How the World's Most Successful People Launched Their Careers| Alex banayan|[4.28](https://www.goodreads.com/book/show/36739769-the-third-door) | 2018 |
| Elon Musk: Inventing the Future | Ashlee Vance | [4.25](https://www.goodreads.com/book/show/22543496-elon-musk) | 2015 |
| The Last Lecture | Randy Pausch | [4.25](http://www.goodreads.com/book/show/2318271.The_Last_Lecture) | 2008 |
| Freedom in Exile | Dalai Lama XIV | [4.24](http://www.goodreads.com/book/show/567720.Freedom_in_Exile) | 1991 |
| Madame Curie: A Biography | Marie Curie | [4.22](https://www.goodreads.com/book/show/341166.Madame_Curie) | 2001 |
| Autobiography of a Yogi | Paramahansa Yogananda | [4.21](https://www.goodreads.com/book/show/639864.Autobiography_of_a_Yogi) | 1946 |
| Wings of Fire | A.P.J. Abdul Kalam | [4.20](http://www.goodreads.com/book/show/634583.Wings_of_Fire) | 2011 |
| Man Without Fear | Rajat Gupta | [4.20](https://www.goodreads.com/en/book/show/44334846-mind-without-fear) | 2019 |
| The Man Who Knew Infinity : A Life of the Genius Ramanujan | Robert Kanigel | [4.15](https://www.goodreads.com/book/show/106139.The_Man_Who_Knew_Infinity) | 1991 |
| An Astronaut's Guide to Life on Earth | Chris Hadfield | [4.14](https://www.goodreads.com/book/show/18170143-an-astronaut-s-guide-to-life-on-earth) | 2013 |
| The Diary of a Young Girl | Anne Frank | [4.10](http://www.goodreads.com/book/show/48855.The_Diary_of_a_Young_Girl) | 1993 |
| The Innovators: How a Group of Hackers, Geniuses and Geeks Created the Digital Revolution | Walter Isaacson | [4.10](https://www.goodreads.com/book/show/21856367-the-innovators) | 2014 |
| A Sense of the World | Jason Roberts | [4.10](https://www.goodreads.com/book/show/126049.A_Sense_of_the_World?from_search=true&from_srp=true&qid=L2EvsarKWR&rank=1) | 2005 | 
| Einstein: His Life and Universe | Walter Isaacson | [4.09](https://www.goodreads.com/book/show/10884.Einstein) | 2007 |
| Steve Jobs | Walter Issacson | [4.09](http://www.goodreads.com/book/show/11084145-steve-jobs) | 2011 |
| My Experiments with Truth | Mahatma Gandhi | [4.07](http://www.goodreads.com/book/show/112803.The_Story_of_My_Experiments_With_Truth) | 1993 |
| The Story of My Life | Helen Keller | [4.07](http://www.goodreads.com/book/show/821611.The_Story_of_My_Life) | 1990 |
| The Immortal Life of Henrietta Lacks | Rebecca Skloot | [4.05](https://www.goodreads.com/book/show/6493208-the-immortal-life-of-henrietta-lacks?ac=1&from_search=true) | 2010 |
| Losing My Virginity: The Autobiography | Richard Branson | [3.97](https://www.goodreads.com/book/show/9533705-losing-my-virginity) |1999|
| My Inventions: The Autobiography of Nikola Tesla | Nikola Tesla | [3.96](https://www.goodreads.com/book/show/493.My_Inventions?ac=1&from_search=true&qid=PQw29iDQp5&rank=1) | 2006 |
| Ghost in the Wires:	My Adventures as the World's Most Wanted Hacker | Kevin Mitnick | [3.95](http://www.goodreads.com/book/show/10256723-ghost-in-the-wires) | 2011 |
| An Autobiography: Toward Freedom | Jawaharlal Nehru | [3.85](http://www.goodreads.com/book/show/322939.An_Autobiography) | 1989 |
| iWoz: Computer Geek to Cult Icon: How I Invented the Personal Computer, Co-Founded Apple, and Had Fun Doing It | Steve Wozniak | [3.82](http://www.goodreads.com/book/show/798635.iWoz) | 2007 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## History
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| Sapiens: A Brief History of Humankind | Yuval Noah Harari | [4.42](https://www.goodreads.com/book/show/23692271-sapiens) | 2014 |
| Bloodlands: Europe Between Hitler and Stalin | Timothy Snyder | [4.36](https://www.goodreads.com/book/show/6572270-bloodlands) | 2010 |
| How the Internet Happened: From Netscape to the iPhone | Brian McCullough | [4.36](https://www.goodreads.com/en/book/show/38212134-how-the-internet-happened) | 2018 |
| The Discoverers | Daniel J. Boorstin | [4.34](https://www.goodreads.com/book/show/714380.The_Discoverers) | 2012 |
| Homo Deus: A History of Tomorrow | Yuval Noah Harari | [4.27](https://www.goodreads.com/book/show/31138556-homo-deus) | 2017 |
| One Minute to Midnight: Kennedy, Khrushchev, and Castro on the Brink of Nuclear War | Michael Dobbs | [4.20](https://www.goodreads.com/book/show/2606779-one-minute-to-midnight) | 2008 |
| The Codebreakers: The Comprehensive History of Secret Communication from Ancient Times to the Internet | David Kahn | [4.18](https://www.goodreads.com/book/show/29608.The_Codebreakers) | 1996 |
| Blindness | José Saramago | [4.13](https://www.goodreads.com/book/show/2526.Blindness) | 1995 |
| From Dawn to Decadence: 500 Years of Western Cultural Life 1500 to the Present | Jacques Barzun | [4.12](https://www.goodreads.com/book/show/58233.From_Dawn_to_Decadence) | 2001 |
| The Soul of a New Machine | Tracy Kidder | [4.12](https://www.goodreads.com/book/show/7090.The_Soul_of_a_New_Machine) | 1981 |
| Why the West Rules--for Now: The Patterns of History, and What They Reveal About the Future | Ian Morris | [4.09](https://www.goodreads.com/book/show/9491855-why-the-west-rules-for-now) | 2010 |
| The Nazi Doctors: Medical Killing and the Psychology of Genocide | Robert Jay Lifton | [4.07](https://www.goodreads.com/book/show/173187.The_Nazi_Doctors) | 1986 |
| God Created The Integers: The Mathematical Breakthroughs that Changed History | Stephen Hawking | [4.06](https://www.goodreads.com/book/show/2096.God_Created_The_Integers) |  |
| Churchill's Secret War: The British Empire and the Ravaging of India during World War II | Madhusree Mukerjee | [4.05](https://www.goodreads.com/book/show/8890989-churchill-s-secret-war) | 2010 |
| El Tiempo Entre Costuras | María Dueñas | [4.04](https://www.goodreads.com/book/show/7502166-el-tiempo-entre-costuras) |2009 |
| Guns, Germs, And Steel : The Fates Of Human Societies | Jared M. Diamond | [4.00](https://www.goodreads.com/book/show/1842.Guns_Germs_and_Steel) | 2005 |
| Discovery of India | Jawaharlal Nehru | [3.98](http://www.goodreads.com/book/show/154126.The_Discovery_of_India) | 1946 |
| The Rational Optimist: How Prosperity Evolves (P.S.) | Matt Ridley | [3.98](https://www.goodreads.com/book/show/7776209-the-rational-optimist) | 2010 |
| Kingpin: How One Hacker Took Over the Billion-Dollar Cybercrime Underground | Kevin Poulson | [3.96](http://www.goodreads.com/book/show/9319468-kingpin) | 2011 |
| The Ghost Map: The Story of London's Most Terrifying Epidemic--and How It Changed Science, Cities, and the Modern World | Steven Johnson | [3.91](https://www.goodreads.com/book/show/36086.The_Ghost_Map) |2006 |
| The Rise and Fall of the British Empire | Lawrence James | [3.89](https://www.goodreads.com/book/show/143980.The_Rise_and_Fall_of_the_British_Empire) | 1997 |
| The Master Switch: The Rise and Fall of Information Empires | Tim Wu | [3.89](https://www.goodreads.com/book/show/8201080-the-master-switch) | 2010 |
| Spycraft | Robert Wallace, H. Keith Melton, Henry R. Schlesinger | [3.81](http://www.goodreads.com/book/show/971936.Spycraft) |1987  |
| Civilization: The West and the Rest: Niall Ferguson | Niall Ferguson | [3.78](https://www.goodreads.com/book/show/10475421-civilization) | 2011 |
| The UNIX-HATERS Handbook | Simson Garfinkel, Daniel Weise, Steven Strassmann | [3.78](https://www.goodreads.com/book/show/174904.The_UNIX_Hater_s_Handbook) | 1994 |
| The Revenge of Geography: What the Map Tells Us About Coming Conflicts and the Battle Against Fate | Robert D. Kaplan | [3.68](https://www.goodreads.com/book/show/13330422-the-revenge-of-geography) | 2012 |
| The World Is Flat: A Brief History of the Twenty-first Century | Thomas L. Friedman | [3.66](https://www.goodreads.com/book/show/1911.The_World_Is_Flat) | 2006 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Science and Medicine
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| Behave: The Biology of Humans at Our Best and Worst | Robert M. Sapolsky | [4.42](https://www.goodreads.com/book/show/31170723-behave) | 2017 |
| Asimov's New Guide to Science | Isaac Asimov | [4.36](https://www.goodreads.com/book/show/977262.Asimov_s_New_Guide_To_Science) | 1985 |
| Factfulness: Ten Reasons We're Wrong About the World – and Why Things Are Better Than You Think | Hans Rosling | [4.36](https://www.goodreads.com/book/show/34890015-factfulness) | 2018 |
| The Gene: An Intimate History | Siddhartha Mukherjee | [4.35](https://www.goodreads.com/book/show/27276428-the-gene) | 2016 |
| Origins of Form: The Shape of Natural and Man-Made Things | Christopher Williams | [4.31](https://www.goodreads.com/book/show/16255011-origins-of-form) | 2013 |
| The Body: A Guide for Occupants | Bill Bryson | [4.31](https://www.goodreads.com/book/show/43582376-the-body) | 2019 |
| Gödel, Escher, Bach: An Eternal Golden Braid | Douglas R. Hofstadter | [4.30](https://www.goodreads.com/book/show/24113.G_del_Escher_Bach) | 1979 |
| The Little Schemer | Daniel P. Friedman, Matthias Felleisen, Duane Bibby, Gerald J. Sussman | [4.27](https://www.goodreads.com/book/show/548914.The_Little_Schemer) | 1995 |
| Scientific Genius: A Psychology of Science | Dean Keith Simonton | [4.25](https://www.goodreads.com/book/show/1752295.Scientific_Genius) | 1988 |
| Out of Control: The New Biology of Machines, Social Systems, and the Economic World | Kevin Kelly | [4.24](https://www.goodreads.com/book/show/16080353-out-of-control) | 1995 |
| The Brain: The Story of You | David Eagleman | [4.20](https://www.goodreads.com/book/show/25776132.the-brain) | 2015 |
| A Short History of Nearly Everything | Bill Bryson | [4.19](https://www.goodreads.com/book/show/21.A_Short_History_of_Nearly_Everything) |2003  |
| Things to Make and Do in the Fourth Dimension |  Matt Parker | [4.19](https://www.goodreads.com/en/book/show/21805670-things-to-make-and-do-in-the-fourth-dimension) | 2014 |
| The Symbolic Species: The Co-evolution of Language and the Brain | Terrence W. Deacon | [4.17](https://www.goodreads.com/book/show/733691.The_Symbolic_Species) | 1998 |
| A Brief History of Time | Stephen Hawking | [4.12](https://www.goodreads.com/book/show/3869.A_Brief_History_of_Time) | 1998 |
| The Selfish Gene | Richard Dawkins | [4.11](http://www.goodreads.com/book/show/61535.The_Selfish_Gene) |1976  |
| Figments of Reality: The Evolution of the Curious Mind | Ian Stewart, Jack Cohen | [4.11](https://www.goodreads.com/book/show/164560.Figments_of_Reality) | 2009 |
| The New Executive Brain: Frontal Lobes in a Complex World | Elkhonon Goldberg | [4.07](https://www.goodreads.com/book/show/6745893-the-new-executive-brain) |  |
| The Extended Phenotype: The Long Reach of the Gene | Richard Dawkins | [4.07](https://www.goodreads.com/book/show/61538.The_Extended_Phenotype) | 1999 |
| Rare Earth: Why Complex Life is Uncommon in the Universe | Peter D. Ward, Donald Brownlee | [4.06](https://www.goodreads.com/book/show/88552.Rare_Earth) | 2003 |
| Stiff: The Curious Lives of Human Cadavers | Mary Roach | [4.05](https://www.goodreads.com/book/show/32145.Stiff) | 2004 |
| The Man Who Mistook His Wife for A Hat and Other Clinical Tales | Oliver Sacks | [4.05](https://www.goodreads.com/book/show/63697.The_Man_Who_Mistook_His_Wife_for_a_Hat_and_Other_Clinical_Tales) | 1998 |
| Darwin's Dangerous Idea | Daniel C. Dennett | [4.03](https://www.goodreads.com/book/show/2068.Darwin_s_Dangerous_Idea) |1995  |
| The Inevitable: Understanding the 12 Technological Forces That Will Shape Our Future | Kevin Kelly | [4.02](https://www.goodreads.com/book/show/27209431-the-inevitable) | 2016 |
| The Outer Limits of Reason: What Science, Mathematics, and Logic Cannot Tell Us | Noson S. Yanofsky | [4.00](http://www.goodreads.com/book/show/17841838-the-outer-limits-of-reason) | 2013 |
| The Structure of Scientific Revolutions: 50th Anniversary Edition | Thomas S. Kuhn | [3.99](https://www.goodreads.com/book/show/61539.The_Structure_of_Scientific_Revolutions) | 1996 |
| At Home in the Universe: The Search for the Laws of Self-Organization and Complexity | Stuart Kauffman | [3.97](https://www.goodreads.com/book/show/319006.At_Home_in_the_Universe) | 1996 |
| The Wealth of Networks: How Social Production Transforms Markets and Freedom | Yochai Benkler | [3.95](https://www.goodreads.com/book/show/14721.The_Wealth_of_Networks) | 2006 |
| Mind Children: The Future of Robot and Human Intelligence |  Hans Moravec. | [3.95](https://www.goodreads.com/book/show/648195.Mind_Children) | 1990 |
| Profiles of the Future: An Inquiry into the Limits of the Possible | Arthur C. Clarke | [3.94](https://www.goodreads.com/book/show/169258.Profiles_of_the_Future) | 1962 |
| How to Find a Habitable Planet | James Kasting | [3.93](https://www.goodreads.com/book/show/7551498-how-to-find-a-habitable-planet) | 2010 |
| The 10,000 Year Explosion: How Civilization Accelerated Human Evolution | Gregory Cochran, Henry Harpending | [3.91](https://www.goodreads.com/book/show/6033964-the-10-000-year-explosion) | 2009 |
| The Disappearing Spoon: And Other True Tales of Madness, Love, and the History of the World from the Periodic Table of the Elements | Sam Kean | [3.91](https://www.goodreads.com/book/show/7247854-the-disappearing-spoon) | 2010 |
| Evolution for Everyone: How Darwin's Theory Can Change the Way We Think About Our Lives | David Sloan Wilson | [3.90](http://www.goodreads.com/book/show/159062.Evolution_for_Everyone) | 2007 |
| Life at the Speed of Light: From the Double Helix to the Dawn of Digital Life | J. Craig Venter | [3.87](www.goodreads.com/book/show/17674969-life-at-the-speed-of-light) | 2013 |
| The Shallows: What the Internet is Doing to Our Brains | Nicholas Carr | [3.85](https://www.goodreads.com/book/show/9778945-the-shallows) | 2011 |
| Catching Fire: How Cooking Made Us Human | Richard Wrangham | [3.83](https://www.goodreads.com/book/show/11148989-catching-fire) | 2009 |
| Heaven in a Chip: Fuzzy Visions of Society and Science in the Digital Age | Bart Kosko | [3.82](https://www.goodreads.com/book/show/172645.Heaven_in_a_Chip) | 2000 |
| The Quark and the Jaguar: Adventures in the Simple and the Complex | Murray Gell-Mann | [3.81](https://www.goodreads.com/book/show/270881.The_Quark_and_the_Jaguar) |1994  |
| Tomorrowland: Our Staggering Journey from Science Fiction to Science Fact | Steven Kotler | [3.80](http://www.goodreads.com/book/show/25060233-tomorrowland) | 2015 |
| Origins of Genius: Darwinian Perspectives on Creativity | Dean Keith | [3.74](https://www.goodreads.com/book/show/254489.Origins_of_Genius) | 1999 |
| Waters of the World: the story of the scientists who unravelled the mysteries of our seas, glaciers, and atmosphere and made the planet whole | Sarah Dry | [3.65](https://www.goodreads.com/book/show/43389003-waters-of-the-world) | 2019 |
| Mind Wars: Brain Research and National Defense | Jonathan D. Moreno | [3.45](http://www.goodreads.com/book/show/599321.Mind_Wars) | 2007 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Logic and Problem Solving
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| What Is the Name of This Book?: The Riddle of Dracula and Other Logical Puzzles | Raymond M. Smullyan | [4.24](https://www.goodreads.com/book/show/493576.What_Is_the_Name_of_This_Book_) | 2011 |
| A Mind for Numbers: How to Excel at Math and Science even If You Flunked Algebra | Barbara Oakley | [4.22](http://www.goodreads.com/book/show/18693655-a-mind-for-numbers) | 2014 |
| How to Solve It: A New Aspect of Mathematical Method | George Polya | [4.16](https://www.goodreads.com/book/show/192221.How_to_Solve_It) | 2015 |
| Guide to Competitive Programming: Learning and Improving Algorithms Through Contests | Antti Laaksonen | [4.15]( https://www.goodreads.com/book/show/36881945-guide-to-competitive-programming) | 2016 |
| Superforecasting: The Art and Science of Prediction |  Philip E. Tetlock, Dan Gardner | [4.10](https://www.goodreads.com/book/show/23995360-superforecasting) | 2015 |
| Problem Solving 101: A Simple Book | Ken Watanabe | [4.10](https://www.goodreads.com/book/show/6271219-problem-solving-101) | 2009 |
| Labyrinths of Reason: Paradox, Puzzles, and the Frailty of Knowledge | William Poundstone | [4.05](https://www.goodreads.com/book/show/55436.Labyrinths_of_Reason) | 1989 |
| Mazes for the Mind: Computers and the Unexpected | Clifford A. Pickover | [4.05](https://www.goodreads.com/book/show/1986400.Mazes_for_the_Mind) | 1992 |
| Outnumbered: Exploring the Algorithms That Control Our Lives | David Sumpter | [3.99](https://www.goodreads.com/book/show/36762542-outnumbered) | 2018 |
| Thinking Forth: A Language and Philosophy for Solving Problems | Leo Brodie | [3.96](https://www.goodreads.com/book/show/2995657-thinking-forth) | 1984 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Politics
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| The New Jim Crow: Mass Incarceration in the Age of Colorblindness | Michelle Alexander | [4.49](https://www.goodreads.com/book/show/6792458-the-new-jim-crow)| 2010
| Justice: What's the Right Thing to Do? | Michael J. Sandel | [4.25](https://www.goodreads.com/book/show/6452731-justice) |  |
| On Tyranny: Twenty Lessons from the Twentieth Century | Timothy Snyder | [4.20](https://www.goodreads.com/book/show/33917107-on-tyranny) | 2017 |
| The Righteous Mind: Why Good People are Divided by Politics and Religion |  Jonathan Haidt | [4.16](https://www.goodreads.com/book/show/11324722-the-righteous-mind) | 2012 |
| Strangers in Their Own Land: Anger and Mourning on the American Right | Arlie Russell Hochschild | [4.15](https://www.goodreads.com/book/show/28695425-strangers-in-their-own-land) | 2016 |
| Game Change: Obama and the Clintons, McCain and Palin, and the Race of a Lifetime | John Heilemann, Mark Halperin | [4.10](https://www.goodreads.com/book/show/6694937-game-change) | 2010 |
| Bolo'bolo | P.M. | [4.05](https://www.goodreads.com/book/show/12395170-bolo-bolo) | 1984 |
| The Myth of the Rational Voter: Why Democracies Choose Bad Policies | Bryan Caplan | [3.96](https://www.goodreads.com/book/show/698866.The_Myth_of_the_Rational_Voter) | 2007 |
| The Art of Deception: Controlling the Human Element of Security | Kevin D. Mitnick | [3.76](https://www.goodreads.com/book/show/18160.The_Art_of_Deception) | 2003 |
| Resource Wars: The New Landscape of Global Conflict | Michael Klare | [3.73](https://www.goodreads.com/book/show/149206.Resource_Wars) |2001  |
| The Audacity of Hope: Thoughts on Reclaiming the American Dream | Barack Obama | [3.70](https://www.goodreads.com/book/show/9742.The_Audacity_of_Hope) | 2006 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Economics
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| The Simple Path to Wealth: Your road map to financial independence and a rich, free life |  J.L. Collins | [4.47](https://www.goodreads.com/book/show/30646587-the-simple-path-to-wealth) | 2016 |
| Origin of Wealth | Eric D. Beinhocker | [4.23](https://www.goodreads.com/book/show/22456.The_Origin_of_Wealth) | 2006 |
| Every Shot Counts: Using the Revolutionary Strokes Gained Approach to Improve Your Golf Performance and Strategy | Mark Broadie | [4.23](https://www.goodreads.com/book/show/17674971-every-shot-counts) | 2014 |
| Economic Facts and Fallacies | Thomas Sowell | [4.18](https://www.goodreads.com/book/show/2064279.Economic_Facts_and_Fallacies) | 2008 |
| Debt - Updated and Expanded: The First 5,000 Years | David Graeber | [4.17](https://www.goodreads.com/book/show/6617037-debt) | 2011 |
| Capital in the Twenty-First Century | Thomas Piketty | [4.01](http://www.goodreads.com/book/show/18736925-capital-in-the-twenty-first-century) | 2014 |
| Freakonomics: A Rogue Economist Explores the Hidden Side of Everything |  Steven D. Levitt, Stephen J. Dubner | [3.98](https://www.goodreads.com/book/show/1202.Freakonomics) | 2006 |
| 23 Things They Don't Tell You About Capitalism | Ha-Joon Chang | [3.97](http://www.goodreads.com/book/show/8913542-23-things-they-don-t-tell-you-about-capitalism) | 2010 |
| The Signal and the Noise: Why So Many Predictions Fail--but Some Don't | Nate Silver | [3.96](https://www.goodreads.com/book/show/13588394-the-signal-and-the-noise) | 2012 |
| Currency Wars: The Making of the Next Global Crisis | James Rickards | [3.96](https://www.goodreads.com/book/show/11515298-currency-wars) | 2011 |
| The Ascent of Money: A Financial History of the World | Niall Ferguson | [3.88](https://www.goodreads.com/book/show/2714607-the-ascent-of-money) |2008  |
| The Bottom Billion: Why the Poorest Countries are Failing and What Can Be Done About It | Paul Collier | [3.85](https://www.goodreads.com/book/show/493371.The_Bottom_Billion) | 2007 |
| The Thank You Economy | Gary Vaynerchuk | [3.83](https://www.goodreads.com/book/show/9203287-the-thank-you-economy) | 2011 |
| Super Crunchers: Why Thinking-By-Numbers is the New Way To Be Smart | Ian Ayres | [3.70](https://www.goodreads.com/book/show/1081413.Super_Crunchers) | 2007 |
| A Farewell to Alms : A Brief Economic History of the World | Gregory Clark | [3.67](https://www.goodreads.com/book/show/150437.A_Farewell_to_Alms) | 2007 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Gender
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| Cemetary Boys | Aiden Thomas | [4.48](https://www.goodreads.com/book/show/52339313-cemetery-boys) | 2020
| Delusions of Gender: How Our Minds, Society, and Neurosexism Create Difference | Cordelia Fine | [4.15](https://www.goodreads.com/book/show/8031168-delusions-of-gender) | 2010
| Paul Takes the Form of a Mortal Girl | Andrea Lawlor | [4.00](https://www.goodreads.com/book/show/35838277-paul-takes-the-form-of-a-mortal-girl) | 2017
| Becoming A Man | P. Carl | [3.95](https://www.goodreads.com/book/show/50091840-becoming-a-man) | 2020

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Sexuality
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| Sex at Dawn: The Prehistoric Origins of Modern | Christopher Ryan, Cacilda Jetha | [4.02](https://www.goodreads.com/book/show/7640261-sex-at-dawn) | 2010 |
| The Ethical Slut: A Guide to Infinite Sexual Possibilities |  Dossie Easton, Catherine A. Liszt. | [3.83](http://www.goodreads.com/book/show/54944.The_Ethical_Slut?from_search=true) | 2004 |
| The Sex Myth | Brooke Magnanti | [3.50](https://www.goodreads.com/book/show/13569582-the-sex-myth) | 2015 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Race
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| So You Want to Talk About Race | Ijeoma Oluo | [4.53](https://www.goodreads.com/book/show/35099718-so-you-want-to-talk-about-race) | 2018 |
| The Origin of Others | Toni Morrison | [4.22](https://www.goodreads.com/book/show/34758228-the-origin-of-others) | 2017 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Education
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| Educated: A Memoir | Tara Westover| [4.47](https://www.goodreads.com/book/show/35133922-educated) | 2018 |
| Mindstorms: Children, Computers, And Powerful Ideas | Seymour A. Papert | [4.32](https://www.goodreads.com/book/show/703532.Mindstorms) | 1993 |
| The Little Prince | Antoine de Saint-Exupéry | [4.31](https://www.goodreads.com/book/show/71091.Il_piccolo_principe) | 1943 |
| How Children Fail | John Holt | [4.22](https://www.goodreads.com/book/show/573009.How_Children_Fail) | 1995 |
| Deep Work: Rules for Focused Success in a Distracted World | Cal Newport | [4.20](https://www.goodreads.com/book/show/25744928-deep-work) | 2016 |
| Make It Stick: The Science of Successful Learning | Peter C. Brown, Henry L. Roediger III, Mark A. McDaniel | [4.20](https://www.goodreads.com/book/show/18770267.make-it-stick) | 2014 |
| Teaching as a Subversive Activity | Neil Postman, Charles Weingartner | [4.19](https://www.goodreads.com/book/show/79681.Teaching_as_a_Subversive_Activity) | 1971 |
| Limitless: Upgrade Your Brain, Learn Anything Faster, and Unlock Your Exceptional Life | Jim Kwik | [4.09](https://www.goodreads.com/book/show/49994260-limitless?from_search=true&from_srp=true&qid=pbeSkuESjB&rank=1) | 2020 |
| Summerhill School: A New View of Childhood | A. S. Neill, Albert Lamb | [4.09](https://www.goodreads.com/book/show/178734.Summerhill) | 1995 |
| The Art of Learning: An Inner Journey to Optimal Performance | Josh Waitzkin | [4.08](https://www.goodreads.com/book/show/857333.The_Art_of_Learning) | 2016 |
| Wounded by School: Recapturing the Joy in Learning and Standing Up to Old School Culture | Kirsten Olson, Sara Lawrence-Lightfoot, Parker J. Palmer | [3.92](https://www.goodreads.com/book/show/6425208-wounded-by-school) | 2009 |
| Curious Minds: How a Child Becomes a Scientist | John Brockman | [3.72](https://www.goodreads.com/book/show/409588.Curious_Minds) | 2005 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Writing
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| Hat Box: The Collected Lyrics | Stephen Sondheim | [4.77](https://www.goodreads.com/book/show/12909101-hat-box) |  |
| On Writing: A Memoir of the Craft | Stephen King | [4.31](https://www.goodreads.com/book/show/10569.On_Writing) | 2002 |
| Bird by Bird: Some Instructions on Writing and Life | Anne Lamott | [4.23](https://www.goodreads.com/book/show/12543.Bird_by_Bird) | 1995 |
| Clear and Simple as the Truth | Francis-Noël Thomas, Mark Turner | [4.06](https://www.goodreads.com/book/show/120549.Clear_and_Simple_as_the_Truth) | 1996 |
| The Sense of Style: The Thinking Person's Guide to Writing in the 21st Century | Steven Pinker | [4.03](http://www.goodreads.com/book/show/20821371-the-sense-of-style) | 2014 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Theater and Film
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| Different Every Night: Putting the play on stage and keeping it fresh | Mike Alfreds | [4.69](https://www.goodreads.com/book/show/3493241-different-every-night) | 2008 |
| Impro: Improvisation and the Theatre | Keith Johnstone | [4.27](https://www.goodreads.com/book/show/306940.Impro) |  |
| The Actor and the Target | Declan Donnellan | [4.25](https://www.goodreads.com/book/show/611466.The_Actor_and_the_Target) | 2006 |
| In the Blink of an Eye: A Perspective on Film Editing | Walter Murch | [4.24](https://www.goodreads.com/book/show/2141.In_the_Blink_of_an_Eye) | 1995 |
| Notes on Directing: 130 Lessons in Leadership from the Director's Chair | Frank Hauser, Russell Reich | [4.21](https://www.goodreads.com/book/show/254808.Notes_on_Directing) |  |
| How to Stop Acting | Harold Guskin | [4.17](https://www.goodreads.com/book/show/808735.How_to_Stop_Acting) | 2003 |
| A Practical Handbook for the Actor | Melissa Bruder, Lee Michael Cohn, Madeleine Olnek, Nathaniel Pollack, Robert Previtio, Scott Zigler, David Mamet | [3.87](https://www.goodreads.com/book/show/166207.A_Practical_Handbook_for_the_Actor) | 1986 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Shakespeare
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| Thinking Shakespeare: A How-to Guide for Student Actors, Directors, and Anyone Else Who Wants to Feel More Comfortable With the Bard | Barry Edelstein. | [4.62](https://www.goodreads.com/book/show/1334872.Thinking_Shakespeare) |  |
| Hamlet and Revenge | Eleanor Prosser | [4.50](https://www.goodreads.com/book/show/625956.Hamlet_Revenge_) | 1971 |
| Shakespeare's Metrical Art | George T. Wright | [4.39](https://www.goodreads.com/book/show/428615.Shakespeare_s_Metrical_Art) | 1991 |
| Hamlet in Purgatory | Stephen Greenblatt | [3.98](https://www.goodreads.com/book/show/33179.Hamlet_in_Purgatory) | 2002 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Fiction

### Classics
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| The Master and Margarita | Mikhail Bulgakov | [4.32](https://www.goodreads.com/book/show/117833.The_Master_and_Margarita) | 1966 |
| Infinite Jest | David Foster Wallace | [4.31](https://www.goodreads.com/book/show/6759.Infinite_Jest) | 1996 |
| The Brothers Karamazov | Fyodor Dostoevsky, Richard Pevear, Larissa Volokhonsky | [4.30](https://www.goodreads.com/book/show/4934.The_Brothers_Karamazov) | 1880 |
| Pride And Prejudice | Jane Austen | [4.24](https://www.goodreads.com/book/show/1885.Pride_and_Prejudice) | 1813 |
| A Prayer for Owen Meany | John Irving | [4.22](https://www.goodreads.com/book/show/4473.A_Prayer_for_Owen_Meany) | 1989 |
| Letters From The Earth | Mark Twain | [4.22](https://www.goodreads.com/book/show/37813.Letters_from_the_Earth) | 1962 |
| One Flew Over the Cuckoo's Nest | Ken Kesey | [4.18](https://www.goodreads.com/book/show/332613.One_Flew_Over_the_Cuckoo_s_Nest) | 1963 |
| Crime and Punishment | Fyodor Dostoyevsky | [4.18](https://www.goodreads.com/book/show/7144.Crime_and_Punishment) | 1866 |
| 1984 | George Orwell | [4.17](https://www.goodreads.com/book/show/40961427-1984) | 1949 |
| The Giver | Lois Lowry | [4.13](https://www.goodreads.com/book/show/3636.The_Giver) | 1993 |
| Steppenwolf: A Novel | Hermann Hesse, Basil Creighton | [4.11](https://www.goodreads.com/book/show/16631.Steppenwolf) | 1927 |
| The Glass Bead Game | Hermann Hesse, Richard and Clara Winston | [4.11](https://www.goodreads.com/book/show/16634.The_Glass_Bead_Game) | 1943 |
| War and Peace | Leo Tolstoy | [4.11](https://www.goodreads.com/book/show/656.War_and_Peace) | 1867 |
| Jane Eyre | Charlotte Brontë | [4.10](https://www.goodreads.com/book/show/10210.Jane_Eyre) | 1847 |
| Germinal | Emile Zola | [4.10](https://www.goodreads.com/book/show/28407.Germinal) | 1885 |
| If on a Winter's Night a Traveler | Italo Calvino and William Weaver | [4.08](https://www.goodreads.com/book/show/374233.If_on_a_Winter_s_Night_a_Traveler) | 1979 |
| Slaughterhouse-Five | Kurt Vonnegut Jr. | [4.08](https://www.goodreads.com/book/show/4981.Slaughterhouse_Five) | 1969 |
| The Wall: (Intimacy) and Other Stories | Jean-Paul Sartre, Lloyd Alexander | [4.07](https://www.goodreads.com/book/show/10031.The_Wall) | 1948 |
| Sense and Sensibility | Jane Austen | [4.06](https://www.goodreads.com/book/show/14935.Sense_and_Sensibility) | 1811 |
| The Picture of Dorian Gray | Oscar Wilde | [4.06](https://www.goodreads.com/book/show/5297.The_Picture_of_Dorian_Gray) | 1890 |
| Watership Down: A Novel | Richard Adams | [4.05 ](https://www.goodreads.com/book/show/76620.Watership_Down) |1972|
| One Hundred Years of Solitude | Gabriel Garcia Marquez, Gregory Rabassa | [4.04](https://www.goodreads.com/book/show/320.One_Hundred_Years_of_Solitude) | 1967 |
| The Death of Ivan Ilych | Leo Tolstoy | [4.04](https://www.goodreads.com/book/show/18386.The_Death_of_Ivan_Ilych) | 1886  |
| Siddhartha | Hermann Hesse | [4.03](https://www.goodreads.com/book/show/52036.Siddhartha) | 1922 |
| Anna Karenina | Leo Tolstoy | [4.02](https://www.goodreads.com/book/show/15823480-anna-karenina) | 1878 |
| Bleak House | Charles Dickens | [4.00](https://www.goodreads.com/book/show/31242.Bleak_House) | 1853 |
| J'accuse | Emile Zola | [3.99](https://www.goodreads.com/book/show/816964.J_accuse) | 1898 |
| Catch 22 | Joseph Heller | [3.98](https://www.goodreads.com/book/show/4610.Catch_22) | 1961 |
| The House of Mirth | Edith Wharton | [3.94](https://www.goodreads.com/book/show/17728.The_House_of_Mirth) | 1905 |
| Confessions of a Mask | Yukio Mishima | [3.91](https://www.goodreads.com/book/show/62794.Confessions_of_a_Mask) | 1949 |
| De L'esprit Des Lois | Montesquieu | [3.91](https://www.goodreads.com/book/show/29854007-de-l-esprit-des-lois-nouvelle-edition) | 1748 |
| Love in the Time of Cholera | Gabriel García Marquéz | [3.9](https://www.goodreads.com/book/show/9712.Love_in_the_Time_of_Cholera) | 1985 |
| Don Quixote | Miguel de Cervantes | [3.85](http://www.goodreads.com/book/show/3836.Don_Quixote) | 1605 |
| Mansfield Park | Jane Austen | [3.84](https://www.goodreads.com/book/show/45032) | 1814 |
| Wuthering Heights | Emily Bronte | [3.82](https://www.goodreads.com/book/show/6185.Wuthering_Heights) | 1847 |
| Père Goriot | Honoré de Balzac | [3.82](https://www.goodreads.com/book/show/59145.P_re_Goriot) | 1834 |
| Adventures of Huckleberry Finn | Mark Twain | [3.80](https://www.goodreads.com/book/show/2956.The_Adventures_of_Huckleberry_Finn) | 1884 |
| The Catcher in the Rye | J.D. Salinger | [3.79](https://www.goodreads.com/book/show/5107.The_Catcher_in_the_Rye) | 1951 |
| Eugénie Grandet | Honoré de Balzac | [3.79](https://www.goodreads.com/book/show/59142.Eug_nie_Grandet) | 1833 |
| Zen and the Art of Motorcycle Maintenance: An Inquiry Into Values  | Robert M. Pirsig | [3.76](https://www.goodreads.com/book/show/629.Zen_and_the_Art_of_Motorcycle_Maintenance) | 1974 |
| Candide | Voltaire | [3.76](https://www.goodreads.com/book/show/19380.Candide) | 1759 |
| Atlas Shrugged | Ayn Rand | [3.68](https://www.goodreads.com/book/show/9365.Atlas_Shrugged) | 1957 |
| Madame Bovary | Gustave Flaubert | [3.65](https://www.goodreads.com/book/show/2175.Madame_Bovary) | 1856 |
| Confessions | Jean-Jacques Rousseau | [3.61](https://www.goodreads.com/book/show/12649.Confessions) | 1782 |
| Lettres persanes | Montesquieu | [3.54](http://www.goodreads.com/book/show/509686.Persian_Letters) | 1721 |
| The Director | David Ignatius | [3.43](http://www.goodreads.com/book/show/23316525-the-director) | 2015 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

### Fantasy
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| The Stormlight Archive | Brandon Sanderson | [4.81](https://www.goodreads.com/book/show/39904817-stormlight-archive-4-book-set?ac=1&from_search=true&qid=QO2o6tRJg4&rank=1) | 2007 |
| The Kingkiller Chronicle | Patrick Rothfuss | [4.55](https://www.goodreads.com/series/45262-the-kingkiller-chronicle) | 2007 |
| The Lord of the Rings | J.R.R. Tolkien | [4.47](https://www.goodreads.com/series/66175-the-lord-of-the-rings) | 1954 |
| A Song of Ice and Fire | George R.R. Martin | [4.45](https://www.goodreads.com/series/43790-a-song-of-ice-and-fire) | 2005 |
| Harry Potter | J.K. Rowling | [4.44](https://www.goodreads.com/series/45175-harry-potter) | 1997 |
| Mistborn | Brandon Sanderson | [4.43](https://www.goodreads.com/series/40910-mistborn) | 2006 |
| Harry Potter and the Methods of Rationality | Eliezer Yudkowsky | [4.38](https://www.goodreads.com/book/show/10016013-harry-potter-and-the-methods-of-rationality) | 2015 |
| Discworld | Terry Pratchett | [4.32](https://www.goodreads.com/series/40650-discworld) | 2001 |
| The Dark Tower | Stephen King | [4.27](https://www.goodreads.com/series/40750-the-dark-tower) | 1982 |
| And the Mountains Echoed | Khaled Hosseini | [4.26](https://www.goodreads.com/book/show/21897740-and-the-mountains-echoed) | 2013 |
| His Dark Materials | Philip Pullman | [4.25](https://www.goodreads.com/book/show/18116.His_Dark_Materials) | 1995 |
| The Last Wish  | Andrzej Sapkowski | [4.2](https://www.goodreads.com/book/show/1128434.The_Last_Wish) | 1993 |
| The Chronicles of Narnia | Clive Staples Lewis | [4.24](https://www.goodreads.com/book/show/11127.The_Chronicles_of_Narnia) | 2002 |
| The Wheel of Time | Robert Jordan | [4.19](https://www.goodreads.com/series/41526-the-wheel-of-time) | 1990 |
| The City & The City | China Mieville | [3.91](https://www.goodreads.com/book/show/4703581-the-city-the-city) | 2009 |
| The Broken Empire | Mark Lawrence | [3.87](https://www.goodreads.com/series/64473-the-broken-empire) | 2011 |
| Of Fire and Stars Book |Audrey Coulthurst | [3.76](https://www.goodreads.com/book/show/25164304-of-fire-and-stars) | 2016 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

### Historical Fiction
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| Lonesome Dove | Larry McMurtry | [4.47](https://www.goodreads.com/book/show/256008.Lonesome_Dove) | 1985 |
| The Help | Kathryn Stockett | [4.45](https://www.goodreads.com/book/show/4667024-the-help) | 2009 |
| A Thousand Splendid Suns | Khaled Hosseini | [4.4](https://www.goodreads.com/book/show/128029.A_Thousand_Splendid_Suns) | 2007 |
| The Book Thief | Markus Zusak | [4.36](https://www.goodreads.com/book/show/19063.The_Book_Thief) | 2005 |
| All the Light We Cannot See | Anthony Doerr | [4.31](https://www.goodreads.com/book/show/18143977-all-the-light-we-cannot-see) | 2014 |
| The Kite Runner | Khaled Hosseini | [4.3](https://www.goodreads.com/book/show/77203.The_Kite_Runner) | 2003 |
| The Pillars of the Earth | Ken Follett | [4.29](https://www.goodreads.com/book/show/5043.The_Pillars_of_the_Earth?from_search=true) | 1989 |
| Kane and Abel | Jeffrey Archer | [4.27](http://www.goodreads.com/book/show/78983.Kane_and_Abel) | 1979 |
| Memoirs of a Geisha | Arthur Golden | [4.12](https://www.goodreads.com/book/show/929.Memoirs_of_a_Geisha) | 1997 |
| One Day in the Life of Ivan Denisovich | Aleksandr Solzhenitsyn | [4](https://www.goodreads.com/book/show/17125.One_Day_in_the_Life_of_Ivan_Denisovich) | 1962 |
| Emma | Jane Austen | [3.99](https://www.goodreads.com/book/show/6969.Emma) | 1815 |
| Sophie's World: A Novel About the History of Philosophy | Jostein Gaarder and Paulette Moller | [3.88](https://www.goodreads.com/book/show/10959.Sophie_s_World) | 1991 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

### Humor
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| I Hope They Serve Beer In Hell | Tucker Max | [3.51](https://www.goodreads.com/book/show/9010.I_Hope_They_Serve_Beer_in_Hell) | 2006 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

### Mystery
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| Sherlock Holmes | Arthur Conan Doyle | [4.30](https://www.goodreads.com/series/49996-sherlock-holmes) | 1998 |
| And Then There Were None | Agatha Christie | [4.26](https://www.goodreads.com/series/49996-sherlock-holmes) | 1939 |
| The Murder of Roger Ackroyd | Agatha Christie | [4.20](http://www.goodreads.com/book/show/16328.The_Murder_of_Roger_Ackroyd) | 2006 |
| The Eight | Katherine Neville | [4.17](https://www.goodreads.com/book/show/113310.The_Eight) |  |
| The Girl with the Dragon Tattoo | Stieg Larsson | [4.14](https://www.goodreads.com/book/show/2429135.The_Girl_with_the_Dragon_Tattoo) | 2005 |
| Memory Man | David Baldacci | [4.05](https://www.goodreads.com/book/show/23153154-memory-man) | 2015 |
| The Turn of the Key | Ruth Ware | [3.94](https://www.goodreads.com/book/show/42080142-the-turn-of-the-key) | 2019 |
| Angels & Demons | Dan Brown | [3.93](https://www.goodreads.com/book/show/960.Angels_Demons) | 2000 |
| The Girl on the Train | Paula Hawkins | [3.88](https://www.goodreads.com/book/show/22557272-the-girl-on-the-train) | 2015 |
| The Da Vinci Code | Dan Brown | [3.79](http://www.goodreads.com/book/show/968.The_Da_Vinci_Code) | 2006 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

### Science Fiction
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| Project Hail Mary | Andy Weir | [4.52](https://www.goodreads.com/book/show/54493401-project-hail-mary) | 2021 |
| The Martian | Andy Weir | [4.40](https://www.goodreads.com/book/show/18007564-the-martian) | 2012 |
| The Hitchhiker's Guide to the Galaxy | Douglas Adams | [4.38](http://www.goodreads.com/book/show/11.The_Hitchhiker_s_Guide_to_the_Galaxy) | 1979|
| Champion | Marie Lu | [4.32](https://www.goodreads.com/book/show/14290364-champion) | 2013 |
| Ready Player One | Ernest Cline | [4.31](https://www.goodreads.com/book/show/9969571-ready-player-one) | 2011 |
| 11/22/63 | Stephen King | [4.31](https://www.goodreads.com/book/show/10644930-11-22-63) | 2011 |
| Ender's Game - Saga | Orson Scott Card | [4.30](https://www.goodreads.com/search?utf8=%E2%9C%93&q=ender%27s+saga&search_type=books&search%5Bfield%5D=on) | 1994 |
| The Player of Games | Iain M. Banks | [4.26](https://www.goodreads.com/book/show/18630.The_Player_of_Games) | 1997 |
| The Fifth Sacred Thing | Starhawk | [4.25](https://www.goodreads.com/book/show/80689.The_Fifth_Sacred_Thing) | 1994 |
| Prodigy | Marie Lu | [4.24](https://www.goodreads.com/book/show/13414446-prodigy?ac=1&from_search=true&qid=BL85jNXP8P&rank=1) | 2013
| Hyperion | Dan Simmons | [4.21](https://www.goodreads.com/book/show/77566.Hyperion) | 1989 |
| Cosmicomics | Italo Calvino | [4.2](https://www.goodreads.com/book/show/59780.Cosmicomics) | 1965 |
| The Diamond Age | Neal Stephenson | [4.19](http://www.goodreads.com/book/show/827.The_Diamond_Age) | 2000 |
| Dune Chronicles | Frank Herbert | [4.19](https://www.goodreads.com/search?q=dune) | 2006 |
| Roadside Picnic | Arkady Strugatsky, Boris Strugatsky | [4.16](https://www.goodreads.com/book/show/331256.Roadside_Picnic) | 1972 |
| The Forever War | Joe Haldemann | [4.15](https://www.goodreads.com/book/show/21611.The_Forever_War) | 1974
| Contact | Carl Sagan | [4.14](https://www.goodreads.com/book/show/61666.Contact) | 1985 |
| Foundation | Isaac Asimov | [4.13](https://www.goodreads.com/book/show/29579.Foundation) | 2004 |
| Snow Crash | Neal Stephenson | [4.02](https://www.goodreads.com/book/show/830.Snow_Crash) | 2000 |
| Brave New World | Aldous Huxley | [3.99](https://www.goodreads.com/book/show/5129.Brave_New_World) | 1932 |
| Fahrenheit 451 | Ray Bradbury | [3.97](https://www.goodreads.com/book/show/17470674-fahrenheit-451) | 2006 |
| Little Brother | Cory Doctorow | [3.94](https://www.goodreads.com/book/show/954674.Little_Brother) | 2008 |
| The Time Machine | H.G Wells | [3.89](https://www.goodreads.com/book/show/2493.The_Time_Machine?from_search=true&from_srp=true&qid=UOQqEw4cz3&rank=1) | 1895 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

### Horror
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| It | Stephen King | [4.24](https://www.goodreads.com/book/show/830502.It) | 1986 |
| House of Leaves | Mark Z. Danielewski | [4.13](http://www.goodreads.com/book/show/24800.House_of_Leaves) | 2000 |
| If it bleeds | Stephen King | [4.10](https://www.goodreads.com/book/show/46015758-if-it-bleeds) | 2020 |
| Rosemary's Baby | Ira Levin | [4.00](https://www.goodreads.com/book/show/228296.Rosemary_s_Baby) | 1967 |
| Dracula | Bram Stoker | [3.98](http://www.goodreads.com/book/show/17245.Dracula) | 1986 |
| London (Surviving The Evacuation #1) | Frank Tayell | [3.86](https://www.goodreads.com/book/show/18655852-london) | 2013 |
| Frankenstein | Mary Shelley, Maurice Hindle | [3.75](http://www.goodreads.com/book/show/18490.Frankenstein) | 2003 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

### Miscellaneous
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| The Queen's Gambit | Walter Tevis | [4.11](https://www.goodreads.com/book/show/62022.The_Queen_s_Gambit) |  |
| The Bone People | Keri Hulme | [4.06](https://www.goodreads.com/book/show/460635.The_Bone_People) | 1986 |
| Cat's Eye | Margaret Atwood | [3.92](https://www.goodreads.com/book/show/51019.Cat_s_Eye) | 1998 |
| Xeelee Sequence | Stephen Baxter | [3.69](http://www.goodreads.com/series/49784-xeelee-sequence) | 1992 |
| Ghost Fleet | P.W. Singer and August Cole | [3.62](https://www.goodreads.com/book/show/22749719-ghost-fleet?from_search=true) | 2015 |
| Future Crimes | Marc Goodman | [3.42](https://www.goodreads.com/book/show/22318398-future-crimes?from_search=true) | 1990 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Health
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| How Not to Die: Discover the Foods Scientifically Proven to Prevent and Reverse Disease | Michael Greger, M.D. | [4.54](https://www.goodreads.com/book/show/25663961-how-not-to-die) | 2015 |
| Overcoming Gravity: A Systematic Approach to Gymnastics and Bodyweight Strength (2nd edition) | Steven Low | [4.3](https://www.goodreads.com/book/show/33293328-overcoming-gravity) | 2016 |
| Breath: The New Science of a Lost Art | James Nestor | [4.15](https://www.goodreads.com/book/show/48890486-breath) | 2020 |
| Convict Conditioning | Paul Wade | [4.13](http://www.goodreads.com/book/show/7305111-convict-conditioning) | 2012 |
| Eat and Run: My Unlikely Journey to Ultramarathon Greatness |  Scott Jurek, Steve Friedman | [3.95](https://www.goodreads.com/book/show/13202092-eat-and-run) | 2012 |
| Brain Food: The Surprising Science of Eating for Cognitive Power |  Lisa Mosconi | [3.92](https://www.goodreads.com/book/show/35457267-brain-food) | 2018 |
| Super Human: The Bulletproof Plan to Age Backward and Maybe Even Live Forever |  Dave Asprey | [3.86](https://www.goodreads.com/book/show/43801612-super-human?ref=nav_sb_ss_3_11) | 2019 |
| 8 Weeks to Optimum Health | Andrew Weil | [3.86](https://www.goodreads.com/book/show/37124.8_Weeks_to_Optimum_Health) |  |
| Grain Brain: The Surprising Truth about Wheat, Carbs, and Sugar--Your Brain's Silent Killers |  David Perlmutter | [3.89](https://www.goodreads.com/book/show/17333302-grain-brain) | 2013 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Design
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| Pattern Language: Towns, Buildings, Construction | Christopher Alexander, Sara Ishikawa, Murray Silverstein, Max Jacobson, Ingrid Fiksdahl-King and Shlomo Angel | [4.38](https://www.goodreads.com/book/show/79766.A_Pattern_Language) | 1977 |
| Data visualization handbook | Juuso Koponen, Jonatan Hildén | [4.33](https://www.goodreads.com/book/show/52326089-data-visualization-handbook) | 2019 |
| How Buildings Learn: What Happens After They're Built | Stewart Brand | [4.32](https://www.goodreads.com/book/show/38310.How_Buildings_Learn) | 1995 |
| Don't Make Me Think, Revisited: A Common Sense Approach to Web Usability | Steve Krug | [4.24](https://www.goodreads.com/book/show/18197267-don-t-make-me-think-revisited) | 2014 |
| The Design of Everyday Things | Donald Norman | [4.18](http://www.goodreads.com/book/show/840.The_Design_of_Everyday_Things) | 2002 |
| Mismatch: How Inclusion Shapes Design |  Kat Holmes, John Maeda | [4.14](https://www.goodreads.com/book/show/39644200-mismatch) | 2018 |
| The Art of Looking Sideways | Alan Fletcher | [4.10](https://www.goodreads.com/book/show/15778.The_Art_of_Looking_Sideways) | 2001 |
| Change by Design: How Design Thinking Transforms Organizations and Inspires Innovation | Tim Brown | [3.88](https://www.goodreads.com/book/show/6671664-change-by-design) | 2009 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Travel
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| Atlas Obscura: An Explorer's Guide to the World's Hidden Wonders | Joshua Foer | [4.24](https://www.goodreads.com/book/show/28110891-atlas-obscura) | 2016 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Language
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| Le Ton beau de Marot: In Praise of the Music of Language | Douglas R. Hofstadter | [4.22](https://www.goodreads.com/book/show/248193.Le_Ton_beau_de_Marot) | 1997 |
| The Language Instinct: How the Mind Creates Language | Steven Pinker | [4.02](https://www.goodreads.com/book/show/5755.The_Language_Instinct) | 2000 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Nature
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| The Wild Places |  Robert Macfarlane | [4.27](https://www.goodreads.com/book/show/2688775-the-wild-places) | 2007 |
| The Sixth Extinction: An Unnatural History | Elizabeth Kolbert | [4.13](https://www.goodreads.com/book/show/17910054-the-sixth-extinction) | 2014 |
| Pilgrim at Tinker Creek | Annie Dillard | [4.11](https://www.goodreads.com/book/show/12527.Pilgrim_at_Tinker_Creek) | 1974 |
| A Walk in the Woods: Rediscovering America on the Appalachian Trai | Bill Bryson | [4.06](https://www.goodreads.com/book/show/9791.A_Walk_in_the_Woods) | 2006 |
| The Uninhabitable Earth: Life After Warming | David Wallace-Wells | [4.06](https://www.goodreads.com/book/show/41552709-the-uninhabitable-earth) | 2019 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

## Art
| Name | Author | Goodreads Rating | Year Published |
|------|--------|------------------|----------------|
| The New Drawing on the Right Side of the Brain | Betty Edwards | [3.86](https://www.goodreads.com/book/show/627206.The_New_Drawing_on_the_Right_Side_of_the_Brain) | 1989 |
| Steal Like an Artist: 10 Things Nobody Told You About Being Creative | Austin Kleon | [3.92](https://www.goodreads.com/book/show/13099738-steal-like-an-artist) | 2012 |
| Show Your Work!: 10 Ways to Share Your Creativity and Get Discovered | Austin Kleon | [4.10](https://www.goodreads.com/book/show/18290401-show-your-work) | 2014 |

<a href="#top"><img src="https://img.shields.io/badge/Back%20to%20Top-↑-blue"/></a>

# Credits
* [@hackerkid](https://github.com/hackerkid) for starting the list.
* [@geritol](https://github.com/geritol) for building the framework for maintaining the list.
* All the [contributors](https://github.com/hackerkid/Mind-Expanding-Books/graphs/contributors) for keeping the list updated by adding new books.

# License
[![CC0](http://i.creativecommons.org/p/zero/1.0/88x31.png)](http://creativecommons.org/publicdomain/zero/1.0/)

To the extent possible under law, [Vishnu Ks](https://github.com/hackerkid) has waived all copyright and related or neighboring rights to this work.
