# Pull Request

If you want to submit a resource for recommendation for Awesome Claude Code, please use the [resource recommendation issue form](https://github.com/hesreallyhim/awesome-claude-code/issues/new?template=recommen-resource.yml) and don't open a PR.

It's fairly uncommon for anyone to open a PR to this repo, even the maintainer. However, if you've noticed a technical problem/bug or a documentation problem, then this may be appropriate. Otherwise, in general, only the bots get to make PRs.

## Type of Contribution

<!-- Select ONE by marking with an [x] -->

- [ ] **New Resource** - Adding a new resource to the list [ONLY THE BOT MAY DO THIS]
- [ ] **Update Resource** - Updating existing resource information (e.g., broken link, license info)
- [ ] **Repository Improvement** - Improving the repository itself (not adding resources) [Use [this issue template](https://github.com/hesreallyhim/awesome-claude-code/issues/new?template=repository-enhancement.yml) to suggest general improvements]

---

## For New Resources

### Resource Information

- **Display Name**: <!-- e.g., "Claude Task Manager" or "/commit" -->
- **Category**: <!-- Select from: Workflows & Knowledge Guides, Tooling, Hooks, Slash-Commands, CLAUDE.md Files, Official Documentation -->
- **Sub-Category** (if applicable): <!-- e.g., "Version Control & Git", "Code Analysis & Testing" -->
- **Primary Link**: <!-- The main URL for the resource -->
- **Author Name**: <!-- Creator/maintainer name -->
- **Author Link**: <!-- Link to author's profile -->
- **License** (if known): <!-- e.g., MIT, Apache-2.0, GPL-3.0 -->

### Description

<!-- 1-2 sentences describing what the resource does and why it's valuable to Claude Code users -->

### Automated Notification

<!-- Check if applicable -->
- [ ] This is a GitHub-hosted resource and will receive an automatic notification issue when merged

---

## For Resource Updates

### What Changed?

<!-- Describe what you're updating -->

- **Resource Name**:
- **Change Type**: <!-- e.g., Fix broken link, Update license, Update description -->
- **Details**:

---

## For Repository Improvements

### Description of Changes

<!-- Describe what you're improving and why -->

### Checklist for Repository Changes

- [ ] Changes follow existing code style
- [ ] Updated relevant documentation
- [ ] Tested changes locally
- [ ] Pre-commit hooks pass

---

## Additional Notes

<!-- Any additional context that would help reviewers -->

## Questions?

- See [CONTRIBUTING.md](../docs/CONTRIBUTING.md) for detailed contribution guidelines
