# Contributing

When contributing to this repository, please first discuss the change you wish to make via issue,
email, or any other method with the owners of this repository before making a change. 

Please note we have a code of conduct, please follow it in all your interactions with the project.

## Pull Request Process

1. Ensure any install or build dependencies are removed before the end of the layer when doing a 
   build.
2. Update the README.md with details of changes to the interface, this includes new environment 
   variables, exposed ports, useful file locations and container parameters.
3. Increase the version numbers in any examples files and the README.md to the new version that this
   Pull Request would represent.
4. To merge the Pull Request if you do not have permission to do that, you may request a second
   reviewer to merge it for you.
5. Optimus uses the LGTM convention for indicating the strongest level of technical sign-off on a patch: simply comment with     the word “LGTM”. It specifically means: “I’ve looked at this thoroughly and take as much ownership as if I wrote the patch myself”. If you comment LGTM you will be expected to help with bugs or follow-up issues on the patch.

### Developer and administrator

[Argenis León](https://github.com/argenisleon)

### Attribution

This Code of Conduct is adapted from the [Contributor Covenant][homepage], version 1.4,
available at [http://contributor-covenant.org/version/1/4][version]

LGTM inspired by the [Apache Spark project](https://spark.apache.org/contributing.html).

[homepage]: http://contributor-covenant.org
[version]: http://contributor-covenant.org/version/1/4/
