# Contribution Guidelines

Please note that this project is released with a [Contributor Code of Conduct](code-of-conduct.md). By participating in this project you agree to abide by its terms.

---

Is your plugin awesome?

> Only awesome is awesome
>
> -- <cite>[The awesome manifesto](https://github.com/sindresorhus/awesome/blob/main/awesome.md#only-awesome-is-awesome)</cite>

Ensure your pull request adheres to the following guidelines:

- Don't open a Draft / WIP pull request while you work on the guidelines. A pull request should be 100% ready and should adhere to all the guidelines when you open it.
- Wait at least 30 days after creating a plugin before submitting it, to give it a chance to mature.
- If you submit a plugin that is similar to an existing plugin in the list, argue how it's better.
- Search previous suggestions before making a new one, as yours may be a duplicate.
- Suggested plugins should be tested and documented.
- Make an individual pull request for each suggestion.
- Use the following format: `[PluginName](link) - Description.`
- Additions should be added to the bottom of the relevant category.
- Link to the GitHub repo, not nuget.org or its website.
- Keep descriptions short and simple, but descriptive.
- Descriptions should not be marketing taglines.
- Descriptions should follow sentence-case, where only the first word and proper nouns are capitalized.
- Don't mention `PowerToys Run` in the description as it's implied.
- Start the description with a capital and end with a full stop/period.
- Don't start the description with `A` or `An`.
- Check your spelling and grammar.
- Make sure your text editor is set to remove trailing whitespace.
- The pull request should have a useful title and include a link to the plugin and why it should be included.
- New categories or improvements to the existing categorization are welcome, but should be done in a separate pull request.

Thanks for being awesome! 😎

## Updating your Pull Request

Sometimes, a maintainer will ask you to edit your Pull Request before it is merged. This is normally due to spelling errors or because your PR didn't match the contribution guidelines.

[Here](https://github.com/RichardLitt/knowledge/blob/master/github/amending-a-commit-guide.md) is a write up on how to change a Pull Request and the different ways you can do that.

## Awesome mentioned badge

The *Awesome PowerToys Run Plugins* list is now officially awesome, having been included in the main list as per [#3075](https://github.com/sindresorhus/awesome/pull/3075).

If your plugin makes it onto this list, you can add a [badge](https://github.com/sindresorhus/awesome/blob/main/awesome.md#awesome-mentioned-badge) to your repository's README. It's a great way to show your users that your plugin has been featured in this awesome list. You can choose either the regular badge or the flat one.

[![Mentioned in Awesome PowerToys Run Plugins](https://awesome.re/mentioned-badge.svg)](https://github.com/hlaueriksson/awesome-powertoys-run-plugins)
[![Mentioned in Awesome PowerToys Run Plugins](https://awesome.re/mentioned-badge-flat.svg)](https://github.com/hlaueriksson/awesome-powertoys-run-plugins)

**Copy this markdown:**

```md
[![Mentioned in Awesome PowerToys Run Plugins](https://awesome.re/mentioned-badge.svg)](https://github.com/hlaueriksson/awesome-powertoys-run-plugins)
[![Mentioned in Awesome PowerToys Run Plugins](https://awesome.re/mentioned-badge-flat.svg)](https://github.com/hlaueriksson/awesome-powertoys-run-plugins)
```
