# Awesome PowerToys Run Plugins [![Awesome](https://awesome.re/badge.svg)](https://awesome.re)<!-- omit in toc -->

<!--lint disable double-link-->
[<img src="powertoys-logo.png" align="right" width="100">](https://learn.microsoft.com/en-us/windows/powertoys/run)

> A curated list of [PowerToys Run](https://learn.microsoft.com/en-us/windows/powertoys/run) community plugins and resources
<!--lint enable double-link-->

PowerToys Run is a quick launcher for Windows. It is open-source and modular for additional plugins.

![PowerToys Run](launcher-dark.png#gh-dark-mode-only)
![PowerToys Run](launcher-light.png#gh-light-mode-only)

## Contents<!-- omit in toc -->

- [Official](#official)
- [Installation](#installation)
- [Plugins](#plugins)
- [Resources](#resources)
- [Articles](#articles)

## Official

<!--lint disable double-link-->
- [Website](https://learn.microsoft.com/en-us/windows/powertoys/run)
- [Repository](https://github.com/microsoft/PowerToys)
- [Microsoft Store](https://apps.microsoft.com/detail/xp89dcgq3k6vld)
<!--lint enable double-link-->

## Installation

<!--lint disable no-undefined-references-->
> [!NOTE]
> Please read the [security](security.md) policy before installing any community plugins.
<!--lint enable no-undefined-references-->

<!--lint disable double-link-->
<!--lint disable no-undefined-references-->
> [!TIP]
> Install these awesome community plugins below, via the [Install](https://github.com/hlaueriksson/Community.PowerToys.Run.Plugin.Install) plugin ⬇️🔌📦
<!--lint enable no-undefined-references-->

- [Community.PowerToys.Run.Plugin.Install](https://github.com/hlaueriksson/Community.PowerToys.Run.Plugin.Install) - Install community PowerToys Run plugins from this awesome list.
<!--lint enable double-link-->

## Plugins

- [GEmojiSharp](https://github.com/hlaueriksson/GEmojiSharp#gemojisharppowertoysrun) - Find and copy GitHub emoji.
- [Everything](https://github.com/lin-ycv/EverythingPowerToys) - Find files and folders instantly with Everything.
- [PowerTranslator](https://github.com/N0I0C0K/PowerTranslator) - Translate text with Youdao Translation.
- [WinGet](https://github.com/bostrot/PowerToysRunPluginWinget) - Install and manage Windows packages with WinGet.
- [Lorem](https://github.com/dxn-9/prun-lorem) - Generate lorem ipsum texts.
- [TOTP](https://github.com/KawaiiZapic/PowertoysRunTOTP) - Copy time-based two factor verify codes.
- [Scoop](https://github.com/Quriz/PowerToysRunScoop) - Install and manage Windows packages with Scoop.
- [InputTyper](https://github.com/CoreyHayward/PowerToys-Run-InputTyper) - Type text as if sent from a keyboard.
- [CurrencyConverter](https://github.com/Advaith3600/PowerToys-Run-Currency-Converter) - Convert traditional and cryptocurrency with the latest exchange rates.
- [EdgeFavorite](https://github.com/davidegiacometti/PowerToys-Run-EdgeFavorite) - Open Microsoft Edge favorites.
- [GitKraken](https://github.com/davidegiacometti/PowerToys-Run-GitKraken) - Open GitKraken repositories.
- [VisualStudio](https://github.com/davidegiacometti/PowerToys-Run-VisualStudio) - Open recent solutions in Visual Studio.
- [ClipboardManager](https://github.com/CoreyHayward/PowerToys-Run-ClipboardManager) - Search and paste from clipboard history.
- [GitHubRepo](https://github.com/8LWXpg/PowerToysRun-GitHubRepo) - Open GitHub repositories.
- [ProcessKiller](https://github.com/8LWXpg/PowerToysRun-ProcessKiller) - Kill Windows processes.
- [WebSearchShortcut](https://github.com/Daydreamer-riri/PowerToys-Run-WebSearchShortcut) - Search with predefined search engines.
- [UnicodeInput](https://github.com/nathancartlidge/powertoys-run-unicode) - Find and copy Unicode characters with Agda-style shorthands.
- [Timer](https://github.com/CoreyHayward/PowerToys-Run-Timer) - Set and manage timers.
- [HexInspector](https://github.com/NaroZeol/PowerHexInspector) - Convert numbers between bases.
- [LocalLLM](https://github.com/Darkdriller/PowerToys-Run-LocalLLm) - Query local LLM models with Ollama.
- [JohnnyDecimal](https://github.com/seguri/PowerToys-Run-JohnnyDecimal) - Navigate through your JohnnyDecimal system.
- [BrowserFavorite](https://github.com/Der-Penz/PowerToys-Run-BrowserFavorite) - Quickly open your Browser Bookmarks.
- [Universal Search Suggestions](https://github.com/Fefedu973/PowerToys-Run-Universal-Search-Suggestions-Plugin/) - Adds search suggestions when typing something.<!--lint disable double-link-->
- [Bang](https://github.com/hlaueriksson/Community.PowerToys.Run.Plugins#bang) - Search websites with DuckDuckGo !Bangs.
- [DenCode](https://github.com/hlaueriksson/Community.PowerToys.Run.Plugins#dencode) - Encoding & Decoding.
- [Dice](https://github.com/hlaueriksson/Community.PowerToys.Run.Plugins#dice) - Roleplaying dice roller.
- [Need](https://github.com/hlaueriksson/Community.PowerToys.Run.Plugins#need) - Key-value store for important information.
- [Twitch](https://github.com/hlaueriksson/Community.PowerToys.Run.Plugins#twitch) - Browse, search and view streams on Twitch.<!--lint enable double-link-->
- [SVGL](https://github.com/SameerJS6/powertoys-svgl) - Browse, search, and copy SVG logos via svgl.
- [QuickNotes](https://github.com/ruslanlap/CommunityPowerToysRunPlugin-QuickNotes) - Create, manage, and search notes.
- [SpeedTest](https://github.com/ruslanlap/PowerToysRun-SpeedTest) - Test your internet connection speed.
- [VideoDownloader](https://github.com/ruslanlap/PowerToysRun-VideoDownloader) - Download videos from various platforms.
- [Definition](https://github.com/ruslanlap/PowerToysRun-Definition) - Lookup word definitions, phonetics, and synonyms.
- [RandomGen](https://github.com/ruslanlap/PowerToysRun-RandomGen) - Generate various types of random data.
- [Hotkeys](https://github.com/ruslanlap/PowerToysRun-Hotkeys) - Find and copy keyboard shortcuts for various applications.
- [TemplateRunner](https://github.com/Heck-R/PowerToys.Run.Plugin.TemplateRunner) - Use simple commands and scripts as mini plugins.

## Resources

- [Visual Studio Template](https://github.com/8LWXpg/PowerToysRun-PluginTemplate) - Visual Studio template for community plugins.
- [Community.PowerToys.Run.Plugin.Dependencies](https://github.com/hlaueriksson/Community.PowerToys.Run.Plugin.Dependencies) - NuGet package with community plugin dependencies.
- [Community.PowerToys.Run.Plugin.Templates](https://github.com/hlaueriksson/Community.PowerToys.Run.Plugin.Templates) - `dotnet new` templates for community plugins.
- [Community.PowerToys.Run.Plugin.Update](https://github.com/hlaueriksson/Community.PowerToys.Run.Plugin.Update) - NuGet package with support for updating community plugins.
- [Community.PowerToys.Run.Plugin.Abstractions](https://github.com/hlaueriksson/Community.PowerToys.Run.Plugin.Abstractions) - NuGet package with abstractions for community plugin dependencies.
- [ptr](https://github.com/8LWXpg/ptr) - CLI tool for installing and managing community plugins.
- [Community.PowerToys.Run.Plugin.Lint](https://github.com/hlaueriksson/Community.PowerToys.Run.Plugin.Lint) - Linter for community plugins.

## Articles

- [Creating custom PowerToys Run plugins](https://conductofcode.io/post/creating-custom-powertoys-run-plugins/) - A step by step guide on how to create community plugins for PowerToys Run.
- [How I developed the JohnnyDecimal plugin](https://blog.seguri.dev/posts/powertoys-run-johnnydecimal/) - A step by step guide on how the JohnnyDecimal community plugin was developed.

## Contributing

Contributions welcome!

1. First read the [community plugin checklist](checklist.md)
2. Then read the [contribution guidelines](contributing.md)

<!--
npx awesome-lint https://github.com/hlaueriksson/awesome-powertoys-run-plugins
-->
