
##########################################################
# Dear PyGui User Interface
#   ~ Version: master
#
#   Notes:
#     * This file is automatically generated.
#
#   Resources:
#     * FAQ:         https://github.com/hoffstadt/DearPyGui/discussions/categories/frequently-asked-questions-faq 
#     * Homepage:    https://github.com/hoffstadt/DearPyGui 
#     * Wiki:        https://github.com/hoffstadt/DearPyGui/wiki 
#     * Issues:      https://github.com/hoffstadt/DearPyGui/issues
#     * Discussions: https://github.com/hoffstadt/DearPyGui/discussions
##########################################################

from typing import List, Any, Callable, Union, Tuple
from contextlib import contextmanager
import warnings
import functools
import inspect
import dearpygui._dearpygui as internal_dpg
from dearpygui._dearpygui import mvBuffer
from dearpygui._dearpygui import mvVec4
from dearpygui._dearpygui import mvMat4

########################################################################################################################
# User API Index
#
#    * Sections
#      - Helper Commands
#      - Tool Commands
#      - Information Commands
#      - Configuration Getter Commands
#      - Configuration Setter Commands
#      - State Commands
#      - Viewport Setter Commands
#      - Viewport Getter Commands
#      - Deprecated Commands
#      - Container Context Managers
#      - Public _dearpygui Wrappings
#      - Constants
#
########################################################################################################################

########################################################################################################################
# Helper Commands
########################################################################################################################

def run_callbacks(jobs):
    """ New in 1.2. Runs callbacks from the callback queue and checks arguments. """

    if jobs is None:
        pass
    else:
        for job in jobs:
            if job[0] is None:
                pass
            else:
                sig = inspect.signature(job[0])
                args = []
                for arg in range(len(sig.parameters)):
                    args.append(job[arg+1])
                job[0](*args)

def get_major_version():
    """ return Dear PyGui Major Version """
    return internal_dpg.get_app_configuration()["major_version"]

def get_minor_version():
    """ return Dear PyGui Minor Version """
    return internal_dpg.get_app_configuration()["minor_version"]

def get_dearpygui_version():
    """ return Dear PyGui Version """
    return internal_dpg.get_app_configuration()["version"]

def configure_item(item : Union[int, str], **kwargs) -> None:
	"""Configures an item after creation."""
	internal_dpg.configure_item(item, **kwargs)

def configure_app(**kwargs) -> None:
	"""Configures an item after creation."""
	internal_dpg.configure_app(**kwargs)

def configure_viewport(item : Union[int, str], **kwargs) -> None:
	"""Configures a viewport after creation."""
	internal_dpg.configure_viewport(item, **kwargs)

def start_dearpygui():
    """Prepares viewport (if not done already). sets up, cleans up, and runs main event loop.

    Returns:
        None
    """

    if not internal_dpg.is_viewport_ok():
        raise RuntimeError("Viewport was not created and shown.")
        return

    while(internal_dpg.is_dearpygui_running()):
        internal_dpg.render_dearpygui_frame()   


@contextmanager
def mutex():
    """ Handles locking/unlocking render thread mutex. """
    try:
        yield internal_dpg.lock_mutex()
    finally:
        internal_dpg.unlock_mutex()


@contextmanager
def popup(parent: Union[int, str], mousebutton: int = internal_dpg.mvMouseButton_Right, modal: bool=False, tag:Union[int, str]=0, min_size:Union[List[int], Tuple[int, ...]]=[100,100], max_size: Union[List[int], Tuple[int, ...]] =[30000, 30000], no_move: bool=False, no_background: bool=False) -> int:
    """A window that will be displayed when a parent item is hovered and the corresponding mouse button has been clicked. By default a popup will shrink fit the items it contains.
    This is useful for context windows, and simple modal window popups.
    When popups are used a modal they have more avaliable settings (i.e. title, resize, width, height) These
    can be set by using configure item. 
    This is a light wrapper over window. For more control over a modal|popup window use a normal window with the modal|popup keyword 
    and set the item handler and mouse events manually.

    Args:
        parent: The UI item that will need to be hovered.
        **mousebutton: The mouse button that will trigger the window to popup.
        **modal: Will force the user to interact with the popup.
        **min_size: New in 1.4. Minimum window size.
        **max_size: New in 1.4. Maximum window size.
        **no_move: New in 1.4. Prevents the window from moving based on user input.
        **no_background: New in 1.4. Sets Background and border alpha to transparent.

    Returns:
        item's uuid
    """
    try:
        if tag == 0:
            _internal_popup_id = internal_dpg.generate_uuid()
        else:
            _internal_popup_id = tag
        _handler_reg_id = internal_dpg.add_item_handler_registry()
        internal_dpg.add_item_clicked_handler(mousebutton, parent=internal_dpg.last_item(), callback=lambda: internal_dpg.configure_item(_internal_popup_id, show=True))
        internal_dpg.bind_item_handler_registry(parent, _handler_reg_id)
        if modal:
            internal_dpg.add_window(modal=True, show=False, tag=_internal_popup_id, autosize=True, min_size=min_size, max_size=max_size, no_move=no_move, no_background=no_background)
        else:
            internal_dpg.add_window(popup=True, show=False, tag=_internal_popup_id, autosize=True, min_size=min_size, max_size=max_size, no_move=no_move, no_background=no_background)
        internal_dpg.push_container_stack(internal_dpg.last_container())
        yield _internal_popup_id

    finally:
        internal_dpg.pop_container_stack()


########################################################################################################################
# Tool Commands
########################################################################################################################

def show_style_editor() -> None:
    """Shows the standard style editor window

    Returns:
        None
    """
    internal_dpg.show_tool(internal_dpg.mvTool_Style)


def show_metrics() -> None:
    """Shows the standard metrics window

    Returns:
        None
    """
    internal_dpg.show_tool(internal_dpg.mvTool_Metrics)


def show_about() -> None:
    """Shows the standard about window

    Returns:
        None
    """
    internal_dpg.show_tool(internal_dpg.mvTool_About)


def show_debug() -> None:
    """Shows the standard debug window

    Returns:
        None
    """
    internal_dpg.show_tool(internal_dpg.mvTool_Debug)


def show_documentation() -> None:
    """Shows the standard documentation window

    Returns:
        None
    """
    internal_dpg.show_tool(internal_dpg.mvTool_Doc)


def show_font_manager() -> None:
    """Shows a debug tool for the font manager

    Returns:
        None
    """
    internal_dpg.show_tool(internal_dpg.mvTool_Font)


def show_item_registry() -> None:
    """Shows the item hierarchy of your application

    Returns:
        None
    """
    internal_dpg.show_tool(internal_dpg.mvTool_ItemRegistry)


########################################################################################################################
# Information Commands
########################################################################################################################

def get_item_slot(item: Union[int, str]) -> Union[int, None]:
    """Returns an item's target slot.

    Returns:
        slot as a int
    """
    return internal_dpg.get_item_info(item)["target"]


def is_item_container(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is a container.

    Returns:
        status as a bool
    """
    return internal_dpg.get_item_info(item)["container"]


def get_item_parent(item: Union[int, str]) -> Union[int, None]:
    """Gets the item's parent.

    Returns:
        parent as a int or None
    """
    return internal_dpg.get_item_info(item)["parent"]


def get_item_children(item: Union[int, str] , slot: int = -1) -> Union[dict, List[int], None]:
    """Provides access to the item's children slots.

    Returns:
        A 2-D tuple of children slots ex. ((child_slot_1),(child_slot_2),(child_slot_3),...) or a single slot if slot is used.
    """
    if slot < 0 or slot > 4:
        return internal_dpg.get_item_info(item)["children"]
    return internal_dpg.get_item_info(item)["children"][slot]


def get_item_type(item: Union[int, str]) -> Union[str]:
    """Gets the item's type.

    Returns:
        type as a string or None
    """
    return internal_dpg.get_item_info(item)["type"]


def get_item_theme(item: Union[int, str]) -> int:
    """Gets the item's theme.

    Returns:
        theme's uuid
    """
    return internal_dpg.get_item_info(item)["theme"]


def get_item_font(item: Union[int, str]) -> int:
    """Gets the item's font.

    Returns:
        font's uuid
    """
    return internal_dpg.get_item_info(item)["font"]


def get_item_disabled_theme(item: Union[int, str]) -> int:
    """Gets the item's disabled theme.

    Returns:
        theme's uuid
    """
    return internal_dpg.get_item_info(item)["disabled_theme"]


########################################################################################################################
# Configuration Setter Commands
########################################################################################################################

def enable_item(item: Union[int, str]):
    """Enables the item.

    Args:
        **item: Item to enable.

    Returns:
        None
    """
    internal_dpg.configure_item(item, enabled=True)


def disable_item(item: Union[int, str]):
    """Disables the item.

    Args:
        **item: Item to disable.

    Returns:
        None
    """
    internal_dpg.configure_item(item, enabled=False)


def set_item_label(item: Union[int, str], label: str):
    """Sets the item's displayed label, anything after the characters "##" in the name will not be shown.

    Args:
        item: Item label will be applied to.
        label: Displayed name to be applied.

    Returns:
        None
    """
    internal_dpg.configure_item(item, label=label)


def set_item_source(item: Union[int, str], source: Union[int, str]):
    """Sets the item's value, to the source's value. Widget's value will now be "linked" to source's value.

    Args:
        item: Item to me linked.
        source: Source to link to.

    Returns:
        None
    """
    internal_dpg.configure_item(item, source=source)


def set_item_pos(item: Union[int, str], pos: List[float]):
    """Sets the item's position.

    Args:
        item: Item the absolute position will be applied to.
        pos: X and Y positions relative to parent of the item.

    Returns:
        None
    """
    internal_dpg.configure_item(item, pos=pos)


def set_item_width(item: Union[int, str], width: int):
    """Sets the item's width.

    Args:
        item: Item the Width will be applied to.
        width: Width to be applied.

    Returns:
        None
    """
    internal_dpg.configure_item(item, width=width)


def set_item_height(item: Union[int, str], height: int):
    """Sets the item's height.

    Args:
        item: Item the Height will be applied to.
        height: Height to be applied.

    Returns:
        None
    """
    internal_dpg.configure_item(item, height=height)


def set_item_indent(item: Union[int, str], indent: int):
    """Sets the item's indent.

    Args:
        item: Item the Height will be applied to.
        height: Height to be applied.

    Returns:
        None
    """
    internal_dpg.configure_item(item, indent=indent)


def set_item_track_offset(item: Union[int, str], offset: float):
    """Sets the item's track offset.

    Args:
        item: Item the Height will be applied to.
        height: Height to be applied.

    Returns:
        None
    """
    internal_dpg.configure_item(item, track_offset=offset)


def set_item_payload_type(item: Union[int, str], payload_type: str):
    """Sets the item's payload type.

    Args:
        item: Item the Height will be applied to.
        height: Height to be applied.

    Returns:
        None
    """
    internal_dpg.configure_item(item, payload_type=str)


def set_item_callback(item: Union[int, str], callback: Callable):
    """Sets the item's callack.

    Args:
        item: Item the callback will be applied to.
        callback: Callback to be applied.

    Returns:
        None
    """
    internal_dpg.configure_item(item, callback=callback)


def set_item_drag_callback(item: Union[int, str], callback: Callable):
    """Sets the item's drag callack.

    Args:
        item: Item the callback will be applied to.
        callback: Callback to be applied.

    Returns:
        None
    """
    internal_dpg.configure_item(item, drag_callback=callback)


def set_item_drop_callback(item: Union[int, str], callback: Callable):
    """Sets the item's drop callack.

    Args:
        item: Item the callback will be applied to.
        callback: Callback to be applied.

    Returns:
        None
    """
    internal_dpg.configure_item(item, drop_callback=callback)


def track_item(item: Union[int, str]):
    """Track item in scroll region.

    Args:
        item: Item the callback will be applied to.
        callback: Callback to be applied.

    Returns:
        None
    """
    internal_dpg.configure_item(item, tracked=True)


def untrack_item(item: Union[int, str]):
    """Track item in scroll region.

    Args:
        item: Item the callback will be applied to.
        callback: Callback to be applied.

    Returns:
        None
    """
    internal_dpg.configure_item(item, tracked=False)


def set_item_user_data(item: Union[int, str], user_data: Any):
    """Sets the item's callack_data to any python object.

    Args:
        item: Item the callback will be applied to.
        user_data: Callback_data to be applied.

    Returns:
        None
    """
    internal_dpg.configure_item(item, user_data=user_data)


def show_item(item: Union[int, str]):
    """Shows the item.

    Args:
        item: Item to show.

    Returns:
        None
    """
    internal_dpg.configure_item(item, show=True)


def hide_item(item: Union[int, str], *, children_only: bool = False):
    """Hides the item.

    Args:
        **item: Item to hide.

    Returns:
        None
    """
    if children_only:
        children = get_item_children(item)
        for child in children:
            internal_dpg.configure_item(child, show=False)
    else:
        internal_dpg.configure_item(item, show=False)


########################################################################################################################
# Configuration Getter Commands
########################################################################################################################

def get_item_label(item: Union[int, str]) -> Union[str, None]:
    """Gets the item's label.

    Returns:
        label as a string or None
    """
    return internal_dpg.get_item_configuration(item)["label"]


def get_item_filter_key(item: Union[int, str]) -> Union[str, None]:
    """Gets the item's filter key.

    Returns:
        filter key as a string or None
    """
    return internal_dpg.get_item_configuration(item)["filter_key"]


def is_item_tracked(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is tracked.

    Returns:
        tracked as a bool or None
    """
    return internal_dpg.get_item_configuration(item)["tracked"]


def is_item_search_delayed(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is search delayed.

    Returns:
        tracked as a bool or None
    """
    return internal_dpg.get_item_configuration(item)["delay_search"]


def get_item_indent(item: Union[int, str]) -> Union[int, None]:
    """Gets the item's indent.

    Returns:
        indent as a int or None
    """
    return internal_dpg.get_item_configuration(item)["indent"]


def get_item_track_offset(item: Union[int, str]) -> Union[float, None]:
    """Gets the item's track offset.

    Returns:
        track offset as a int or None
    """
    return internal_dpg.get_item_configuration(item)["track_offset"]


def get_item_width(item: Union[int, str]) -> Union[int, None]:
    """Gets the item's width.

    Returns:
        width as a int or None
    """
    return internal_dpg.get_item_configuration(item)["width"]


def get_item_height(item: Union[int, str]) -> Union[int, None]:
    """Gets the item's height.

    Returns:
        height as a int or None
    """
    return internal_dpg.get_item_configuration(item)["height"]


def get_item_callback(item: Union[int, str]) -> Union[Callable, None]:
    """Gets the item's callback.

    Returns:
        callback as a callable or None
    """
    return internal_dpg.get_item_configuration(item)["callback"]


def get_item_drag_callback(item: Union[int, str]) -> Union[Callable, None]:
    """Gets the item's drag callback.

    Returns:
        callback as a callable or None
    """
    return internal_dpg.get_item_configuration(item)["drag_callback"]


def get_item_drop_callback(item: Union[int, str]) -> Union[Callable, None]:
    """Gets the item's drop callback.

    Returns:
        callback as a callable or None
    """
    return internal_dpg.get_item_configuration(item)["drop_callback"]


def get_item_user_data(item: Union[int, str]) -> Union[Any, None]:
    """Gets the item's callback data.

    Returns:
        callback data as a python object or None
    """
    return internal_dpg.get_item_configuration(item)["user_data"]


def get_item_source(item: Union[int, str]) -> Union[str, None]:
    """Gets the item's source.

    Returns:
        source as a string or None
    """
    return internal_dpg.get_item_configuration(item)["source"]


########################################################################################################################
# State Commands
########################################################################################################################

def is_item_hovered(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is hovered.

    Returns:
        status as a bool
    """
    return internal_dpg.get_item_state(item)["hovered"]


def is_item_active(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is active.

    Returns:
        status as a bool
    """
    return internal_dpg.get_item_state(item)["active"]


def is_item_focused(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is focused.

    Returns:
        status as a bool
    """
    return internal_dpg.get_item_state(item)["focused"]


def is_item_clicked(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is clicked.

    Returns:
        status as a bool
    """
    return internal_dpg.get_item_state(item)["clicked"]


def is_item_left_clicked(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is left clicked.

    Returns:
        status as a bool
    """
    return internal_dpg.get_item_state(item)["left_clicked"]


def is_item_right_clicked(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is right clicked.

    Returns:
        status as a bool
    """
    return internal_dpg.get_item_state(item)["right_clicked"]


def is_item_middle_clicked(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is middle clicked.

    Returns:
        status as a bool
    """
    return internal_dpg.get_item_state(item)["middle_clicked"]


def is_item_visible(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is visible.

    Returns:
        status as a bool
    """
    return internal_dpg.get_item_state(item)["visible"]


def is_item_edited(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is edited.

    Returns:
        status as a bool
    """
    return internal_dpg.get_item_state(item)["edited"]


def is_item_activated(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is activated.

    Returns:
        status as a bool
    """
    return internal_dpg.get_item_state(item)["activated"]


def is_item_deactivated(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is deactivated.

    Returns:
        status as a bool
    """
    return internal_dpg.get_item_state(item)["deactivated"]


def is_item_deactivated_after_edit(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is deactivated_after_edit.

    Returns:
        status as a bool
    """
    return internal_dpg.get_item_state(item)["deactivated_after_edit"]


def is_item_toggled_open(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is toggled_open.

    Returns:
        status as a bool
    """
    return internal_dpg.get_item_state(item)["toggled_open"]


def is_item_ok(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is ok and can be used.

    Returns:
        status as a bool
    """
    return internal_dpg.get_item_state(item)["ok"]


def is_item_shown(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is shown.

    Returns:
        status as a bool
    """
    return internal_dpg.get_item_configuration(item)["show"]


def is_item_enabled(item: Union[int, str]) -> Union[bool, None]:
    """Checks if item is enabled.

    Returns:
        status as a bool
    """
    return internal_dpg.get_item_configuration(item)["enabled"]


def get_item_pos(item: Union[int, str]) -> List[int]:
    """Returns item's position.

    Returns:
        position
    """
    return internal_dpg.get_item_state(item)["pos"]


def get_available_content_region(item: Union[int, str]) -> List[int]:
    """Returns item's available content region.

    Returns:
        position
    """
    return internal_dpg.get_item_state(item)["content_region_avail"]


def get_item_rect_size(item: Union[int, str]) -> List[int]:
    """Returns item's available content region.

    Returns:
        position
    """
    return internal_dpg.get_item_state(item)["rect_size"]


def get_item_rect_min(item: Union[int, str]) -> List[int]:
    """Returns item's minimum content region.

    Returns:
        position
    """
    return internal_dpg.get_item_state(item)["rect_min"]


def get_item_rect_max(item: Union[int, str]) -> List[int]:
    """Returns item's maximum content region.

    Returns:
        position
    """
    return internal_dpg.get_item_state(item)["rect_max"]


########################################################################################################################
# Viewport Setter Commands
########################################################################################################################

def set_viewport_clear_color(color: List[int]):
    """Sets the viewport's clear color.

    Returns:
        None
    """
    internal_dpg.configure_viewport(0, clear_color=color)


def set_viewport_small_icon(icon: str):
    """Sets the viewport's small icon. Must be ico for windows.

    Returns:
        None
    """
    internal_dpg.configure_viewport(0, small_icon=icon)


def set_viewport_large_icon(icon: str):
    """Sets the viewport's large icon. Must be ico for windows.

    Returns:
        None
    """
    internal_dpg.configure_viewport(0, large_icon=icon)


def set_viewport_pos(pos: List[float]):
    """Sets the viewport's position.

    Returns:
        None
    """
    internal_dpg.configure_viewport(0, x_pos=pos[0], y_pos=pos[1])


def set_viewport_width(width: int):
    """Sets the viewport's width.

    Returns:
        None
    """
    internal_dpg.configure_viewport(0, width=width)


def set_viewport_height(height: int):
    """Sets the viewport's height.

    Returns:
        None
    """
    internal_dpg.configure_viewport(0, height=height)


def set_viewport_min_width(width: int):
    """Sets the viewport's minimum width.

    Returns:
        None
    """
    internal_dpg.configure_viewport(0, min_width=width)


def set_viewport_max_width(width: int):
    """Sets the viewport's max width.

    Returns:
        None
    """
    internal_dpg.configure_viewport(0, max_width=width)


def set_viewport_min_height(height: int):
    """Sets the viewport's minimum height.

    Returns:
        None
    """
    internal_dpg.configure_viewport(0, min_height=height)


def set_viewport_max_height(height: int):
    """Sets the viewport's max width.

    Returns:
        None
    """
    internal_dpg.configure_viewport(0, max_height=height)


def set_viewport_title(title: str):
    """Sets the viewport's title.

    Returns:
        None
    """
    internal_dpg.configure_viewport(0, title=title)


def set_viewport_always_top(value: bool):
    """Sets the viewport always on top.

    Returns:
        None
    """
    internal_dpg.configure_viewport(0, always_on_top=value)


def set_viewport_resizable(value: bool):
    """Sets the viewport resizable.

    Returns:
        None
    """
    internal_dpg.configure_viewport(0, resizable=value)

def set_viewport_vsync(value: bool):
    """Sets the viewport vsync.

    Returns:
        None
    """
    internal_dpg.configure_viewport(0, vsync=value)


def set_viewport_decorated(value: bool):
    """Sets the viewport to be decorated.

    Returns:
        None
    """
    internal_dpg.configure_viewport(0, decorated=value)

########################################################################################################################
# Viewport Getter Commands
########################################################################################################################

def get_viewport_clear_color() ->List[int]:
    """Gets the viewport's clear color.

    Returns:
        List[int]
    """
    return internal_dpg.get_viewport_configuration()["clear_color"]


def get_viewport_pos() ->List[float]:
    """Gets the viewport's position.

    Returns:
        viewport position.
    """
    config = internal_dpg.get_viewport_configuration()
    x_pos = config["x_pos"]
    y_pos = config["y_pos"]
    return [x_pos, y_pos]


def get_viewport_width() -> int:
    """Gets the viewport's width.

    Returns:
        viewport width
    """
    return internal_dpg.get_viewport_configuration()["width"]


def get_viewport_client_width() -> int:
    """Gets the viewport's client width.

    Returns:
        viewport width
    """
    return internal_dpg.get_viewport_configuration()["client_width"]


def get_viewport_client_height() -> int:
    """Gets the viewport's client height.

    Returns:
        viewport width
    """
    return internal_dpg.get_viewport_configuration()["client_height"]


def get_viewport_height() -> int:
    """Gets the viewport's height.

    Returns:
        int
    """
    return internal_dpg.get_viewport_configuration()["height"]


def get_viewport_min_width() -> int:
    """Gets the viewport's minimum width.

    Returns:
        int
    """
    return internal_dpg.get_viewport_configuration()["min_width"]


def get_viewport_max_width() -> int:
    """Gets the viewport's max width.

    Returns:
        int
    """
    return internal_dpg.get_viewport_configuration()["max_width"]


def get_viewport_min_height() -> int:
    """Gets the viewport's minimum height.

    Returns:
        int
    """
    return internal_dpg.get_viewport_configuration()["min_height"]


def get_viewport_max_height() -> int:
    """Gets the viewport's max width.

    Returns:
        int
    """
    return internal_dpg.get_viewport_configuration()["max_height"]


def get_viewport_title() -> str:
    """Gets the viewport's title.

    Returns:
        str
    """
    return internal_dpg.get_viewport_configuration()["title"]


def is_viewport_always_top() -> bool:
    """Checks the viewport always on top flag.

    Returns:
        bool
    """
    return internal_dpg.get_viewport_configuration()["always_on_top"]


def is_viewport_resizable() -> bool:
    """Checks the viewport resizable flag.

    Returns:
        bool
    """
    return internal_dpg.get_viewport_configuration()["resizable"]


def is_viewport_vsync_on() -> bool:
    """Checks the viewport vsync flag.

    Returns:
        bool
    """
    return internal_dpg.get_viewport_configuration()["vsync"]


def is_viewport_decorated() -> bool:
    """Checks if the viewport is docorated.

    Returns:
        bool
    """
    return internal_dpg.get_viewport_configuration()["decorated"]

##########################################################
# Deprecated Commands
##########################################################

from typing import Union


def deprecated(reason):

	string_types = (type(b''), type(u''))

	if isinstance(reason, string_types):

		def decorator(func1):

			fmt1 = "Call to deprecated function {name} ({reason})."

			@functools.wraps(func1)
			def new_func1(*args, **kwargs):
				warnings.simplefilter('always', DeprecationWarning)
				warnings.warn(
					fmt1.format(name=func1.__name__, reason=reason),
					category=DeprecationWarning,
					stacklevel=2
				)
				warnings.simplefilter('default', DeprecationWarning)
				return func1(*args, **kwargs)

			return new_func1

		return decorator

	elif inspect.isfunction(reason):

		func2 = reason
		fmt2 = "Call to deprecated function {name}."

		@functools.wraps(func2)
		def new_func2(*args, **kwargs):
			warnings.simplefilter('always', DeprecationWarning)
			warnings.warn(
				fmt2.format(name=func2.__name__),
				category=DeprecationWarning,
				stacklevel=2
			)
			warnings.simplefilter('default', DeprecationWarning)
			return func2(*args, **kwargs)

		return new_func2

@deprecated("Use 'configure_app(init_file=file)'.")
def set_init_file(file="dpg.ini"):
    """ deprecated function """
    internal_dpg.configure_app(init_file=file)

@deprecated("Use 'configure_app(init_file=file, load_init_file=True)'.")
def load_init_file(file):
    """ deprecated function """
    internal_dpg.configure_app(init_file=file, load_init_file=True)

@deprecated("Use: `is_viewport_ok(...)`")
def is_viewport_created():
    """ deprecated function """
    return internal_dpg.is_viewport_ok()

@deprecated("Use: \ncreate_viewport()\nsetup_dearpygui()\nshow_viewport()")
def setup_viewport():
    """ deprecated function """
    internal_dpg.create_viewport()
    internal_dpg.setup_dearpygui()
    internal_dpg.show_viewport()

@deprecated("Use: `bind_item_theme(...)`")
def set_item_theme(item, theme):
    """ deprecated function """
    return internal_dpg.bind_item_theme(item, theme)

@deprecated("Use: `bind_item_type_disabled_theme(...)`")
def set_item_type_disabled_theme(item, theme):
    """ deprecated function """
    return internal_dpg.bind_item_type_disabled_theme(item, theme)

@deprecated("Use: `bind_item_type_theme(...)`")
def set_item_type_theme(item, theme):
    """ deprecated function """
    return internal_dpg.bind_item_type_theme(item, theme)

@deprecated("Use: `bind_item_font(...)`")
def set_item_font(item, font):
    """ deprecated function """
    return internal_dpg.bind_item_font(item, font)

@deprecated("Use: `add_item_activated_handler(...)`")
def add_activated_handler(parent, **kwargs):
    """ deprecated function """
    return internal_dpg.add_item_activated_handler(parent, **kwargs)

@deprecated("Use: `add_item_active_handler(...)`")
def add_active_handler(parent, **kwargs):
    """ deprecated function """
    return internal_dpg.add_item_active_handler(parent, **kwargs)

@deprecated("Use: `add_item_clicked_handler(...)`")
def add_clicked_handler(parent, button=-1, **kwargs):
    """ deprecated function """
    return internal_dpg.add_item_clicked_handler(parent, button, **kwargs)

@deprecated("Use: `add_item_deactived_after_edit_handler(...)`")
def add_deactivated_after_edit_handler(parent, **kwargs):
    """ deprecated function """
    return internal_dpg.add_item_deactivated_after_edit_handler(parent, **kwargs)

@deprecated("Use: `add_item_deactivated_handler(...)`")
def add_deactivated_handler(parent, **kwargs):
    """ deprecated function """
    return internal_dpg.add_item_deactivated_handler(parent, **kwargs)

@deprecated("Use: `add_item_edited_handler(...)`")
def add_edited_handler(parent, **kwargs):
    """ deprecated function """
    return internal_dpg.add_item_edited_handler(parent, **kwargs)

@deprecated("Use: `add_item_focus_handler(...)`")
def add_focus_handler(parent, **kwargs):
    """ deprecated function """
    return internal_dpg.add_item_focus_handler(parent, **kwargs)

@deprecated("Use: `add_item_hover_handler(...)`")
def add_hover_handler(parent, **kwargs):
    """ deprecated function """
    return internal_dpg.add_item_hover_handler(parent, **kwargs)

@deprecated("Use: `add_item_resize_handler(...)`")
def add_resize_handler(parent, **kwargs):
    """ deprecated function """
    return internal_dpg.add_item_resize_handler(parent, **kwargs)

@deprecated("Use: `add_item_toggled_open_handler(...)`")
def add_toggled_open_handler(parent, **kwargs):
    """ deprecated function """
    return internal_dpg.add_item_toggled_open_handler(parent, **kwargs)

@deprecated("Use: `add_item_visible_handler(...)`")
def add_visible_handler(parent, **kwargs):
    """ deprecated function """
    return internal_dpg.add_item_visible_handler(parent, **kwargs)

@deprecated("Use: `bind_colormap(...)`")
def set_colormap(item, source):
    """ deprecated function """
    return internal_dpg.bind_colormap(item, source)

@deprecated("Use: `bind_theme(0)`")
def reset_default_theme(item, source):
    """ deprecated function """
    return internal_dpg.bind_theme(item, source)

@deprecated
def set_staging_mode(mode):
    """ deprecated function """
    pass

@deprecated
def add_table_next_column(**kwargs):
    """ deprecated function """
    pass

@deprecated("Use: add_stage")
def add_staging_container(**kwargs):
    """ deprecated function """
    return internal_dpg.add_stage(**kwargs)

@deprecated("Use: stage")
@contextmanager
def staging_container(**kwargs):
	"""
	deprecated function
	Args:
		**label (str): Overrides 'name' as label.
		**user_data (Any): User data for callbacks.
		**use_internal_label (bool): Use generated internal label instead of user specified (appends ### uuid).
		**id (Union[int, str]): Unique id used to programmatically refer to the item.If label is unused this will be the label.
	Yields:
		Union[int, str]
	"""
	try:
		warnings.warn("'staging_container' is deprecated and was changed to 'stage'", DeprecationWarning, 2)
		widget = internal_dpg.add_stage_container(**kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@deprecated("Use: add_spacer(...)")
def add_spacing(**kwargs):
	"""	(deprecated function) Adds vertical spacing. 

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks.
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int]], optional): Places the item relative to window coordinates, [0,0] is top left.
		count (int, optional): Number of spacings to add the size is dependant on the curret style.
	Returns:
		Union[int, str]
	"""

	if 'count' in kwargs.keys():
		count = kwargs["count"]
		kwargs.pop("count", None)
		internal_dpg.add_group(**kwargs)
		internal_dpg.push_container_stack(internal_dpg.last_container())
		for i in range(count):
			internal_dpg.add_spacer()
		result_id = internal_dpg.pop_container_stack()
	else:
		result_id = internal_dpg.add_spacer(**kwargs)
	return result_id

@deprecated("Use: add_spacer(...)")
def add_dummy(**kwargs):
	"""	(deprecated function) Adds a spacer or 'dummy' object.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks.
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int]], optional): Places the item relative to window coordinates, [0,0] is top left.
	Returns:
		Union[int, str]
	"""

	return internal_dpg.add_spacer(**kwargs)

@deprecated("Use: `destroy_context()`")
def cleanup_dearpygui():
    """ deprecated function """
    return internal_dpg.destroy_context()

@deprecated("Use: group(horizontal=True)")
def add_same_line(**kwargs):
    """ deprecated function """

    last_item = internal_dpg.last_item()
    group = internal_dpg.add_group(horizontal=True, **kwargs)
    internal_dpg.move_item(last_item, parent=group)
    internal_dpg.capture_next_item(lambda s: internal_dpg.move_item(s, parent=group))
    return group

@deprecated("Use: `get_plot_query_rects()`")
def is_plot_queried(plot: Union[int, str], **kwargs):
	"""	(deprecated function) Returns true if the plot is currently being queried. 

	Args:
		plot (Union[int, str]): 
	Returns:
		bool
	"""

	return len(internal_dpg.get_plot_query_rects(plot, **kwargs)) > 0

@deprecated("Use: `get_plot_query_rects()`")
def get_plot_query_area(plot: Union[int, str], **kwargs):
	"""	(deprecated function) Returns the last/current query area of the plot. If no area is available [0, 0, 0, 0] will be returned.

	Args:
		plot (Union[int, str]): 
	Returns:
		Union[List[float], Tuple[float, ...]]
	"""

	if rects := internal_dpg.get_plot_query_rects(plot, **kwargs):
		return rects[0]
	else:
		return [0, 0, 0, 0]

@deprecated("Use: `add_inf_line_series(horizontal=True)`")
def add_hline_series(x, **kwargs):
	"""	(deprecated function) Adds an infinite horizontal line series to a plot.

	Args:
		x (Any): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated)
	Returns:
		Union[int, str]
	"""

	return internal_dpg.add_inf_line_series(x, **kwargs, horizontal=True)
            

@deprecated("Use: `add_inf_line_series()`")
def add_vline_series(x, **kwargs):
	"""	(deprecated function) Adds an infinite vertical line series to a plot.

	Args:
		x (Any): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated)
	Returns:
		Union[int, str]
	"""

	return internal_dpg.add_inf_line_series(x, **kwargs)


@deprecated("Use: `add_child_window()`")
def add_child(**kwargs):
	"""	(deprecated function) Adds an embedded child window. Will show scrollbars when items do not fit.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		border (bool, optional): Shows/Hides the border around the sides.
		autosize_x (bool, optional): Autosize the window to its parents size in x.
		autosize_y (bool, optional): Autosize the window to its parents size in y.
		no_scrollbar (bool, optional):  Disable scrollbars (window can still scroll with mouse or programmatically).
		horizontal_scrollbar (bool, optional): Allow horizontal scrollbar to appear (off by default).
		menubar (bool, optional): Shows/Hides the menubar at the top.
	Returns:
		Union[int, str]
	"""

	return internal_dpg.add_child_window(**kwargs)


@deprecated("Use: `child_window()`")
@contextmanager
def child(**kwargs):
	"""	(deprecated function) Adds an embedded child window. Will show scrollbars when items do not fit.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		border (bool, optional): Shows/Hides the border around the sides.
		autosize_x (bool, optional): Autosize the window to its parents size in x.
		autosize_y (bool, optional): Autosize the window to its parents size in y.
		no_scrollbar (bool, optional):  Disable scrollbars (window can still scroll with mouse or programmatically).
		horizontal_scrollbar (bool, optional): Allow horizontal scrollbar to appear (off by default).
		menubar (bool, optional): Shows/Hides the menubar at the top.
	Yields:
		Union[int, str]
	"""
	try:
		widget = internal_dpg.add_child_window(**kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@deprecated("Use: Just not recommended")
def setup_registries() -> None:
    """Adds default registries for fonts, handlers, textures, colormaps, and values."""
    internal_dpg.add_font_registry(tag=internal_dpg.mvReservedUUID_0)
    internal_dpg.add_handler_registry(tag=internal_dpg.mvReservedUUID_1)
    internal_dpg.add_texture_registry(tag=internal_dpg.mvReservedUUID_2)
    internal_dpg.add_value_registry(tag=internal_dpg.mvReservedUUID_3)
    internal_dpg.add_colormap_registry(tag=internal_dpg.mvReservedUUID_4)

@deprecated("Use: `set_frame_callback()`")
def set_start_callback(callback):
    """ deprecated function """
    return internal_dpg.set_frame_callback(3, callback)

##########################################################
# Container Context Managers
##########################################################


@contextmanager
def child_window(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, border: bool =True, autosize_x: bool =False, autosize_y: bool =False, no_scrollbar: bool =False, horizontal_scrollbar: bool =False, menubar: bool =False, no_scroll_with_mouse: bool =False, flattened_navigation: bool =True, always_use_window_padding: bool =False, resizable_x: bool =False, resizable_y: bool =False, always_auto_resize: bool =False, frame_style: bool =False, auto_resize_x: bool =False, auto_resize_y: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds an embedded child window. Will show scrollbars when items do not fit. About using auto_resize/resizable flags: size measurement for a given axis is only performed when the child window is within visible boundaries, or is just appearing and it won't update its auto-size while clipped. While not perfect, it is a better default behavior as the always-on performance gain is more valuable than the occasional 'resizing after becoming visible again' glitch. You may also use always_auto_resize to force an update even when child window is not in view. However doing so will degrade performance. Remember that combining both auto_resize_x and auto_resize_y defeats purpose of a scrolling region and is NOT recommended.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		border (bool, optional): Shows/Hides the border around the sides.
		autosize_x (bool, optional): Autosize the window to its parents size in x.
		autosize_y (bool, optional): Autosize the window to its parents size in y.
		no_scrollbar (bool, optional):  Disable scrollbars (window can still scroll with mouse or programmatically).
		horizontal_scrollbar (bool, optional): Allow horizontal scrollbar to appear (off by default).
		menubar (bool, optional): Shows/Hides the menubar at the top.
		no_scroll_with_mouse (bool, optional): Disable user vertically scrolling with mouse wheel.
		flattened_navigation (bool, optional): Allow gamepad/keyboard navigation to cross over parent border to this child (only use on child that have no scrolling!)
		always_use_window_padding (bool, optional): Pad with style.WindowPadding even if no border are drawn (no padding by default for non-bordered child windows because it makes more sense)
		resizable_x (bool, optional): Allow resize from right border (layout direction). Enable .ini saving.
		resizable_y (bool, optional): Allow resize from bottom border (layout direction). 
		always_auto_resize (bool, optional): Combined with auto_resize_x/auto_resize_y. Always measure size even when child is hidden and always disable clipping optimization! NOT RECOMMENDED.
		frame_style (bool, optional): Style the child window like a framed item: use FrameBg, FrameRounding, FrameBorderSize, FramePadding instead of ChildBg, ChildRounding, ChildBorderSize, WindowPadding.
		auto_resize_x (bool, optional): Enable auto-resizing width based on child content. Read 'IMPORTANT: Size measurement' details above.
		auto_resize_y (bool, optional): Enable auto-resizing height based on child content. Read 'IMPORTANT: Size measurement' details above.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_child_window(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, payload_type=payload_type, drop_callback=drop_callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, border=border, autosize_x=autosize_x, autosize_y=autosize_y, no_scrollbar=no_scrollbar, horizontal_scrollbar=horizontal_scrollbar, menubar=menubar, no_scroll_with_mouse=no_scroll_with_mouse, flattened_navigation=flattened_navigation, always_use_window_padding=always_use_window_padding, resizable_x=resizable_x, resizable_y=resizable_y, always_auto_resize=always_auto_resize, frame_style=frame_style, auto_resize_x=auto_resize_x, auto_resize_y=auto_resize_y, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def clipper(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, delay_search: bool =False, **kwargs) -> Union[int, str]:
	"""	 Helper to manually clip large list of items. Increases performance by not searching or drawing widgets outside of the clipped region.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_clipper(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, show=show, delay_search=delay_search, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def collapsing_header(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, closable: bool =False, default_open: bool =False, open_on_double_click: bool =False, open_on_arrow: bool =False, leaf: bool =False, bullet: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a collapsing header to add items to. Must be closed with the end command.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		closable (bool, optional): Adds the ability to hide this widget by pressing the (x) in the top right of widget.
		default_open (bool, optional): Sets the collapseable header open by default.
		open_on_double_click (bool, optional): Need double-click to open node.
		open_on_arrow (bool, optional): Only open when clicking on the arrow part.
		leaf (bool, optional): No collapsing, no arrow (use as a convenience for leaf nodes).
		bullet (bool, optional): Display a bullet instead of arrow.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_collapsing_header(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, payload_type=payload_type, drag_callback=drag_callback, drop_callback=drop_callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, closable=closable, default_open=default_open, open_on_double_click=open_on_double_click, open_on_arrow=open_on_arrow, leaf=leaf, bullet=bullet, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def colormap_registry(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, show: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a colormap registry.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_colormap_registry(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, show=show, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def custom_series(x : Union[List[float], Tuple[float, ...]], y : Union[List[float], Tuple[float, ...]], channel_count : int, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, callback: Callable =None, show: bool =True, y1: Any =[], y2: Any =[], y3: Any =[], tooltip: bool =True, no_fit: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a custom series to a plot. New in 1.6.

	Args:
		x (Any): 
		y (Any): 
		channel_count (int): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		y1 (Any, optional): 
		y2 (Any, optional): 
		y3 (Any, optional): 
		tooltip (bool, optional): Show tooltip when plot is hovered.
		no_fit (bool, optional): the item won't be considered for plot fits
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_custom_series(x, y, channel_count, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, callback=callback, show=show, y1=y1, y2=y2, y3=y3, tooltip=tooltip, no_fit=no_fit, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def drag_payload(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, show: bool =True, drag_data: Any =None, drop_data: Any =None, payload_type: str ='$$DPG_PAYLOAD', **kwargs) -> Union[int, str]:
	"""	 User data payload for drag and drop operations.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		show (bool, optional): Attempt to render widget.
		drag_data (Any, optional): Drag data
		drop_data (Any, optional): Drop data
		payload_type (str, optional): 
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_drag_payload(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, show=show, drag_data=drag_data, drop_data=drop_data, payload_type=payload_type, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def draw_layer(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, perspective_divide: bool =False, depth_clipping: bool =False, cull_mode: int =0, **kwargs) -> Union[int, str]:
	"""	 New in 1.1. Creates a layer useful for grouping drawlist items.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		perspective_divide (bool, optional): New in 1.1. apply perspective divide
		depth_clipping (bool, optional): New in 1.1. apply depth clipping
		cull_mode (int, optional): New in 1.1. culling mode, mvCullMode_* constants. Only works with triangles currently.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_draw_layer(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, perspective_divide=perspective_divide, depth_clipping=depth_clipping, cull_mode=cull_mode, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def draw_node(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 New in 1.1. Creates a drawing node to associate a transformation matrix. Child node matricies will concatenate.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_draw_node(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def drawlist(width : int, height : int, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, **kwargs) -> Union[int, str]:
	"""	 Adds a drawing canvas.

	Args:
		width (int): 
		height (int): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_drawlist(width, height, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, callback=callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def file_dialog(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, callback: Callable =None, show: bool =True, default_path: str ='', default_filename: str ='.', file_count: int =0, modal: bool =False, directory_selector: bool =False, min_size: Union[List[int], Tuple[int, ...]] =[100, 100], max_size: Union[List[int], Tuple[int, ...]] =[30000, 30000], cancel_callback: Callable =None, **kwargs) -> Union[int, str]:
	"""	 Displays a file or directory selector depending on keywords. Displays a file dialog by default. Callback will be ran when the file or directory picker is closed. The app_data arguemnt will be populated with information related to the file and directory as a dictionary.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		default_path (str, optional): Path that the file dialog will default to when opened.
		default_filename (str, optional): Default name that will show in the file name input.
		file_count (int, optional): Number of visible files in the dialog.
		modal (bool, optional): Forces user interaction with the file selector.
		directory_selector (bool, optional): Shows only directory/paths as options. Allows selection of directory/paths only.
		min_size (Union[List[int], Tuple[int, ...]], optional): Minimum window size.
		max_size (Union[List[int], Tuple[int, ...]], optional): Maximum window size.
		cancel_callback (Callable, optional): Callback called when cancel button is clicked.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_file_dialog(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, callback=callback, show=show, default_path=default_path, default_filename=default_filename, file_count=file_count, modal=modal, directory_selector=directory_selector, min_size=min_size, max_size=max_size, cancel_callback=cancel_callback, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def filter_set(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, delay_search: bool =False, **kwargs) -> Union[int, str]:
	"""	 Helper to parse and apply text filters (e.g. aaaaa[, bbbbb][, ccccc])

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_filter_set(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, show=show, delay_search=delay_search, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def font(file : str, size : int, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, pixel_snapH: bool =False, parent: Union[int, str] =internal_dpg.mvReservedUUID_0, **kwargs) -> Union[int, str]:
	"""	 Adds font to a font registry.

	Args:
		file (str): 
		size (int): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		pixel_snapH (bool, optional): Align every glyph to pixel boundary. Useful e.g. if you are merging a non-pixel aligned font with the default font, or rendering text piece-by-piece (e.g. for coloring).
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
		default_font (bool, optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']

		if 'default_font' in kwargs.keys():
			warnings.warn('default_font keyword removed', DeprecationWarning, 2)
			kwargs.pop('default_font', None)
		widget = internal_dpg.add_font(file, size, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, pixel_snapH=pixel_snapH, parent=parent, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def font_registry(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a font registry.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_font_registry(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, show=show, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def group(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, horizontal: bool =False, horizontal_spacing: float =-1, xoffset: float =0.0, **kwargs) -> Union[int, str]:
	"""	 Creates a group that other widgets can belong to. The group allows item commands to be issued for all of its members.
Enable property acts in a special way enabling/disabling everything inside the group. (Use mvStyleVar_DisabledAlpha to edit colors within the disabled group.)

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		horizontal (bool, optional): Forces child widgets to be added in a horizontal layout.
		horizontal_spacing (float, optional): Spacing for the horizontal layout.
		xoffset (float, optional): Offset from containing window x item location within group.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_group(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, payload_type=payload_type, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, horizontal=horizontal, horizontal_spacing=horizontal_spacing, xoffset=xoffset, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def handler_registry(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a handler registry.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_handler_registry(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, show=show, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def item_handler_registry(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds an item handler registry.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_item_handler_registry(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, show=show, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def menu(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drop_callback: Callable =None, show: bool =True, enabled: bool =True, filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, **kwargs) -> Union[int, str]:
	"""	 Adds a menu to an existing menu bar.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_menu(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, payload_type=payload_type, drop_callback=drop_callback, show=show, enabled=enabled, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def menu_bar(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, show: bool =True, delay_search: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a menu bar to a window.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		show (bool, optional): Attempt to render widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_menu_bar(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, show=show, delay_search=delay_search, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def node(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, draggable: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a node to a node editor.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		draggable (bool, optional): Allow node to be draggable.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_node(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, payload_type=payload_type, drag_callback=drag_callback, drop_callback=drop_callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, draggable=draggable, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def node_attribute(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, filter_key: str ='', tracked: bool =False, track_offset: float =0.5, attribute_type: int =0, shape: int =1, category: str ='general', **kwargs) -> Union[int, str]:
	"""	 Adds a node attribute to a node.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		attribute_type (int, optional): mvNode_Attr_Input, mvNode_Attr_Output, or mvNode_Attr_Static.
		shape (int, optional): Pin shape.
		category (str, optional): Category
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_node_attribute(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, show=show, filter_key=filter_key, tracked=tracked, track_offset=track_offset, attribute_type=attribute_type, shape=shape, category=category, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def node_editor(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, parent: Union[int, str] =0, before: Union[int, str] =0, callback: Callable =None, show: bool =True, filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, delink_callback: Callable =None, menubar: bool =False, minimap: bool =False, minimap_location: int =2, **kwargs) -> Union[int, str]:
	"""	 Adds a node editor.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		delink_callback (Callable, optional): Callback ran when a link is detached.
		menubar (bool, optional): Shows or hides the menubar.
		minimap (bool, optional): Shows or hides the Minimap. New in 1.6.
		minimap_location (int, optional): mvNodeMiniMap_Location_* constants. New in 1.6.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_node_editor(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, parent=parent, before=before, callback=callback, show=show, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, delink_callback=delink_callback, menubar=menubar, minimap=minimap, minimap_location=minimap_location, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def plot(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, no_title: bool =False, no_menus: bool =False, no_box_select: bool =False, no_mouse_pos: bool =False, query: bool =False, query_color: Union[List[float], Tuple[float, ...]] =(0, 255, 0, 255), min_query_rects: int =1, max_query_rects: int =1, crosshairs: bool =False, equal_aspects: bool =False, no_inputs: bool =False, no_frame: bool =False, use_local_time: bool =False, use_ISO8601: bool =False, use_24hour_clock: bool =False, pan_button: int =internal_dpg.mvMouseButton_Left, pan_mod: int =internal_dpg.mvKey_None, context_menu_button: int =internal_dpg.mvMouseButton_Right, fit_button: int =internal_dpg.mvMouseButton_Left, box_select_button: int =internal_dpg.mvMouseButton_Right, box_select_mod: int =internal_dpg.mvKey_None, box_select_cancel_button: int =internal_dpg.mvMouseButton_Left, query_toggle_mod: int =internal_dpg.mvKey_ModCtrl, horizontal_mod: int =internal_dpg.mvKey_ModAlt, vertical_mod: int =internal_dpg.mvKey_ModShift, override_mod: int =internal_dpg.mvKey_ModCtrl, zoom_mod: int =internal_dpg.mvKey_None, zoom_rate: int =0.1, **kwargs) -> Union[int, str]:
	"""	 Adds a plot which is used to hold series, and can be drawn to with draw commands. For all _mod parameters use mvKey_ModX enums, or mvKey_ModDisabled to disable the modifier.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		no_title (bool, optional): the plot title will not be displayed
		no_menus (bool, optional): the user will not be able to open context menus with right-click
		no_box_select (bool, optional): the user will not be able to box-select with right-click drag
		no_mouse_pos (bool, optional): the text of mouse position, in plot coordinates, will not be displayed inside of the plot
		query (bool, optional): the user will be able to draw query rects with CTRL + right-click drag
		query_color (Union[List[float], Tuple[float, ...]], optional): Color of the query rectangles.
		min_query_rects (int, optional): The minimum number of query rects that can be in the plot. If there are less rects than this value, it won't be possible to delete them.
		max_query_rects (int, optional): The maximum number of query rects that can be in the plot. If the number is reached any rect added will replace the latest one. (0 means unlimited)
		crosshairs (bool, optional): the default mouse cursor will be replaced with a crosshair when hovered
		equal_aspects (bool, optional): primary x and y axes will be constrained to have the same units/pixel (does not apply to auxiliary y-axes)
		no_inputs (bool, optional): the user will not be able to interact with the plot
		no_frame (bool, optional): the ImGui frame will not be rendered
		use_local_time (bool, optional): axis labels will be formatted for your timezone when
		use_ISO8601 (bool, optional): dates will be formatted according to ISO 8601 where applicable (e.g. YYYY-MM-DD, YYYY-MM, --MM-DD, etc.)
		use_24hour_clock (bool, optional): times will be formatted using a 24 hour clock
		pan_button (int, optional): mouse button that enables panning when held
		pan_mod (int, optional): optional modifier that must be held for panning
		context_menu_button (int, optional): opens context menus (if enabled) when clicked
		fit_button (int, optional): fits visible data when double clicked
		box_select_button (int, optional): begins box selection when pressed and confirms selection when released
		box_select_mod (int, optional): begins box selection when pressed and confirms selection when released
		box_select_cancel_button (int, optional): cancels active box selection when pressed
		query_toggle_mod (int, optional): when held, active box selections turn into queries
		horizontal_mod (int, optional): expands active box selection/query horizontally to plot edge when held
		vertical_mod (int, optional): expands active box selection/query vertically to plot edge when held
		override_mod (int, optional): when held, all input is ignored; used to enable axis/plots as DND sources
		zoom_mod (int, optional): optional modifier that must be held for scroll wheel zooming
		zoom_rate (int, optional): zoom rate for scroll (e.g. 0.1f = 10% plot range every scroll click); make negative to invert
		id (Union[int, str], optional): (deprecated) 
		no_highlight (bool, optional): (deprecated) Removed because not supported from the backend anymore. To control the highlighting of series use the same argument in `add_plot_legend`
		no_child (bool, optional): (deprecated) a child window region will not be used to capture mouse scroll (can boost performance for single ImGui window applications)
		anti_aliased (bool, optional): (deprecated) This feature was deprecated in ImPlot. To enable/disable anti_aliasing use `dpg.configure_app()` with the `anti_aliasing` parameters.
		query_button (int, optional): (deprecated) This refers to the old way of querying of ImPlot, now replaced with `DragRect()`
		query_mod (int, optional): (deprecated) This refers to the old way of querying of ImPlot, now replaced with `DragRect()`
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']

		if 'no_highlight' in kwargs.keys():
			warnings.warn('no_highlight keyword removed', DeprecationWarning, 2)
			kwargs.pop('no_highlight', None)

		if 'no_child' in kwargs.keys():
			warnings.warn('no_child keyword removed', DeprecationWarning, 2)
			kwargs.pop('no_child', None)

		if 'anti_aliased' in kwargs.keys():
			warnings.warn('anti_aliased keyword removed', DeprecationWarning, 2)
			kwargs.pop('anti_aliased', None)

		if 'query_button' in kwargs.keys():
			warnings.warn('query_button keyword removed', DeprecationWarning, 2)
			kwargs.pop('query_button', None)

		if 'query_mod' in kwargs.keys():
			warnings.warn('query_mod keyword removed', DeprecationWarning, 2)
			kwargs.pop('query_mod', None)
		widget = internal_dpg.add_plot(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, no_title=no_title, no_menus=no_menus, no_box_select=no_box_select, no_mouse_pos=no_mouse_pos, query=query, query_color=query_color, min_query_rects=min_query_rects, max_query_rects=max_query_rects, crosshairs=crosshairs, equal_aspects=equal_aspects, no_inputs=no_inputs, no_frame=no_frame, use_local_time=use_local_time, use_ISO8601=use_ISO8601, use_24hour_clock=use_24hour_clock, pan_button=pan_button, pan_mod=pan_mod, context_menu_button=context_menu_button, fit_button=fit_button, box_select_button=box_select_button, box_select_mod=box_select_mod, box_select_cancel_button=box_select_cancel_button, query_toggle_mod=query_toggle_mod, horizontal_mod=horizontal_mod, vertical_mod=vertical_mod, override_mod=override_mod, zoom_mod=zoom_mod, zoom_rate=zoom_rate, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def plot_axis(axis : int, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drop_callback: Callable =None, show: bool =True, no_label: bool =False, no_gridlines: bool =False, no_tick_marks: bool =False, no_tick_labels: bool =False, no_initial_fit: bool =False, no_menus: bool =False, no_side_switch: bool =False, no_highlight: bool =False, opposite: bool =False, foreground_grid: bool =False, tick_format: str ='', scale: int =internal_dpg.mvPlotScale_Linear, invert: bool =False, auto_fit: bool =False, range_fit: bool =False, pan_stretch: bool =False, lock_min: bool =False, lock_max: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds an axis to a plot.

	Args:
		axis (int): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		no_label (bool, optional): the axis label will not be displayed
		no_gridlines (bool, optional): no grid lines will be displayed
		no_tick_marks (bool, optional): no tick marks will be displayed
		no_tick_labels (bool, optional): no text labels will be displayed
		no_initial_fit (bool, optional): axis will not be initially fit to data extents on the first rendered frame
		no_menus (bool, optional): the user will not be able to open context menus with right-click
		no_side_switch (bool, optional): the user will not be able to switch the axis side by dragging it
		no_highlight (bool, optional): the axis will not have its background highlighted when hovered or held
		opposite (bool, optional): axis ticks and labels will be rendered on the conventionally opposite side (i.e, right or top)
		foreground_grid (bool, optional): grid lines will be displayed in the foreground (i.e. on top of data) instead of the background
		tick_format (str, optional): Sets a custom tick label formatter
		scale (int, optional): Sets the axis' scale. Can have only mvPlotScale_ values
		invert (bool, optional): the axis values will be inverted (i.e. growing from right to left)
		auto_fit (bool, optional): axis will be auto-fitting to data extents
		range_fit (bool, optional): axis will only fit points if the point is in the visible range of the **orthogonal** axis
		pan_stretch (bool, optional): panning in a locked or constrained state will cause the axis to stretch if possible
		lock_min (bool, optional): the axis minimum value will be locked when panning/zooming
		lock_max (bool, optional): the axis maximum value will be locked when panning/zooming
		id (Union[int, str], optional): (deprecated) 
		log_scale (bool, optional): (deprecated) Old way to set log scale in the axis. Use 'scale' argument instead.
		time (bool, optional): (deprecated) Old way to set time scale in the axis. Use 'scale' argument instead.
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']

		if 'log_scale' in kwargs.keys():
			warnings.warn('log_scale keyword deprecated. See the new scale argument.', DeprecationWarning, 2)

		if 'time' in kwargs.keys():
			warnings.warn('time keyword deprecated. See the new scale argument.', DeprecationWarning, 2)
		widget = internal_dpg.add_plot_axis(axis, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, payload_type=payload_type, drop_callback=drop_callback, show=show, no_label=no_label, no_gridlines=no_gridlines, no_tick_marks=no_tick_marks, no_tick_labels=no_tick_labels, no_initial_fit=no_initial_fit, no_menus=no_menus, no_side_switch=no_side_switch, no_highlight=no_highlight, opposite=opposite, foreground_grid=foreground_grid, tick_format=tick_format, scale=scale, invert=invert, auto_fit=auto_fit, range_fit=range_fit, pan_stretch=pan_stretch, lock_min=lock_min, lock_max=lock_max, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def stage(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, **kwargs) -> Union[int, str]:
	"""	 Adds a stage.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_stage(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def subplots(rows : int, columns : int, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, row_ratios: Union[List[float], Tuple[float, ...]] =[], column_ratios: Union[List[float], Tuple[float, ...]] =[], no_title: bool =False, no_menus: bool =False, no_resize: bool =False, no_align: bool =False, share_series: bool =False, link_rows: bool =False, link_columns: bool =False, link_all_x: bool =False, link_all_y: bool =False, column_major: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a collection of plots.

	Args:
		rows (int): 
		columns (int): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		row_ratios (Union[List[float], Tuple[float, ...]], optional): 
		column_ratios (Union[List[float], Tuple[float, ...]], optional): 
		no_title (bool, optional): the subplot title will not be displayed
		no_menus (bool, optional): the user will not be able to open context menus with right-click
		no_resize (bool, optional): resize splitters between subplot cells will be not be provided
		no_align (bool, optional): subplot edges will not be aligned vertically or horizontally
		share_series (bool, optional): when set to True, series from all sub-plots will be shared to some extent, using a single common color set and showing them in a single legend in the subplots item. Otherwise each plot will be independent from others and will have its own legend
		link_rows (bool, optional): link the y-axis limits of all plots in each row (does not apply auxiliary y-axes)
		link_columns (bool, optional): link the x-axis limits of all plots in each column
		link_all_x (bool, optional): link the x-axis limits in every plot in the subplot
		link_all_y (bool, optional): link the y-axis limits in every plot in the subplot (does not apply to auxiliary y-axes)
		column_major (bool, optional): subplots are added in column major order instead of the default row major order
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_subplots(rows, columns, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, callback=callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, row_ratios=row_ratios, column_ratios=column_ratios, no_title=no_title, no_menus=no_menus, no_resize=no_resize, no_align=no_align, share_series=share_series, link_rows=link_rows, link_columns=link_columns, link_all_x=link_all_x, link_all_y=link_all_y, column_major=column_major, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def tab(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drop_callback: Callable =None, show: bool =True, filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, closable: bool =False, no_tooltip: bool =False, order_mode: int =0, **kwargs) -> Union[int, str]:
	"""	 Adds a tab to a tab bar.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		closable (bool, optional): Creates a button on the tab that can hide the tab.
		no_tooltip (bool, optional): Disable tooltip for the given tab.
		order_mode (int, optional): set using a constant: mvTabOrder_Reorderable: allows reordering, mvTabOrder_Fixed: fixed ordering, mvTabOrder_Leading: adds tab to front, mvTabOrder_Trailing: adds tab to back
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_tab(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, payload_type=payload_type, drop_callback=drop_callback, show=show, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, closable=closable, no_tooltip=no_tooltip, order_mode=order_mode, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def tab_bar(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, reorderable: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a tab bar.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		reorderable (bool, optional): Allows for the user to change the order of the tabs.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_tab_bar(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, callback=callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, reorderable=reorderable, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def table(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, header_row: bool =True, clipper: bool =False, inner_width: int =0, policy: int =0, freeze_rows: int =0, freeze_columns: int =0, sort_multi: bool =False, sort_tristate: bool =False, resizable: bool =False, reorderable: bool =False, hideable: bool =False, sortable: bool =False, context_menu_in_body: bool =False, row_background: bool =False, borders_innerH: bool =False, borders_outerH: bool =False, borders_innerV: bool =False, borders_outerV: bool =False, no_host_extendX: bool =False, no_host_extendY: bool =False, no_keep_columns_visible: bool =False, precise_widths: bool =False, no_clip: bool =False, pad_outerX: bool =False, no_pad_outerX: bool =False, no_pad_innerX: bool =False, scrollX: bool =False, scrollY: bool =False, no_saved_settings: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a table.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		header_row (bool, optional): show headers at the top of the columns
		clipper (bool, optional): Use clipper (rows must be same height).
		inner_width (int, optional): 
		policy (int, optional): 
		freeze_rows (int, optional): 
		freeze_columns (int, optional): 
		sort_multi (bool, optional): Hold shift when clicking headers to sort on multiple column.
		sort_tristate (bool, optional): Allow no sorting, disable default sorting.
		resizable (bool, optional): Enable resizing columns
		reorderable (bool, optional): Enable reordering columns in header row (need calling TableSetupColumn() + TableHeadersRow() to display headers)
		hideable (bool, optional): Enable hiding/disabling columns in context menu.
		sortable (bool, optional): Enable sorting. Call TableGetSortSpecs() to obtain sort specs. Also see ImGuiTableFlags_SortMulti and ImGuiTableFlags_SortTristate.
		context_menu_in_body (bool, optional): Right-click on columns body/contents will display table context menu. By default it is available in TableHeadersRow().
		row_background (bool, optional): Set each RowBg color with ImGuiCol_TableRowBg or ImGuiCol_TableRowBgAlt (equivalent of calling TableSetBgColor with ImGuiTableBgFlags_RowBg0 on each row manually)
		borders_innerH (bool, optional): Draw horizontal borders between rows.
		borders_outerH (bool, optional): Draw horizontal borders at the top and bottom.
		borders_innerV (bool, optional): Draw vertical borders between columns.
		borders_outerV (bool, optional): Draw vertical borders on the left and right sides.
		no_host_extendX (bool, optional): Make outer width auto-fit to columns, overriding outer_size.x value. Only available when ScrollX/ScrollY are disabled and Stretch columns are not used.
		no_host_extendY (bool, optional): Make outer height stop exactly at outer_size.y (prevent auto-extending table past the limit). Only available when ScrollX/ScrollY are disabled. Data below the limit will be clipped and not visible.
		no_keep_columns_visible (bool, optional): Disable keeping column always minimally visible when ScrollX is off and table gets too small. Not recommended if columns are resizable.
		precise_widths (bool, optional): Disable distributing remainder width to stretched columns (width allocation on a 100-wide table with 3 columns: Without this flag: 33,33,34. With this flag: 33,33,33). With larger number of columns, resizing will appear to be less smooth.
		no_clip (bool, optional): Disable clipping rectangle for every individual columns.
		pad_outerX (bool, optional): Default if BordersOuterV is on. Enable outer-most padding. Generally desirable if you have headers.
		no_pad_outerX (bool, optional): Default if BordersOuterV is off. Disable outer-most padding.
		no_pad_innerX (bool, optional): Disable inner padding between columns (double inner padding if BordersOuterV is on, single inner padding if BordersOuterV is off).
		scrollX (bool, optional): Enable horizontal scrolling. Require 'outer_size' parameter of BeginTable() to specify the container size. Changes default sizing policy. Because this create a child window, ScrollY is currently generally recommended when using ScrollX.
		scrollY (bool, optional): Enable vertical scrolling.
		no_saved_settings (bool, optional): Never load/save settings in .ini file.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_table(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, source=source, callback=callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, header_row=header_row, clipper=clipper, inner_width=inner_width, policy=policy, freeze_rows=freeze_rows, freeze_columns=freeze_columns, sort_multi=sort_multi, sort_tristate=sort_tristate, resizable=resizable, reorderable=reorderable, hideable=hideable, sortable=sortable, context_menu_in_body=context_menu_in_body, row_background=row_background, borders_innerH=borders_innerH, borders_outerH=borders_outerH, borders_innerV=borders_innerV, borders_outerV=borders_outerV, no_host_extendX=no_host_extendX, no_host_extendY=no_host_extendY, no_keep_columns_visible=no_keep_columns_visible, precise_widths=precise_widths, no_clip=no_clip, pad_outerX=pad_outerX, no_pad_outerX=no_pad_outerX, no_pad_innerX=no_pad_innerX, scrollX=scrollX, scrollY=scrollY, no_saved_settings=no_saved_settings, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def table_cell(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, height: int =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, filter_key: str ='', **kwargs) -> Union[int, str]:
	"""	 Adds a table.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		height (int, optional): Height of the item.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		filter_key (str, optional): Used by filter widget.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_table_cell(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, height=height, parent=parent, before=before, show=show, filter_key=filter_key, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def table_row(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, height: int =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, filter_key: str ='', **kwargs) -> Union[int, str]:
	"""	 Adds a table row.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		height (int, optional): Height of the item.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		filter_key (str, optional): Used by filter widget.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_table_row(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, height=height, parent=parent, before=before, show=show, filter_key=filter_key, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def template_registry(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, **kwargs) -> Union[int, str]:
	"""	 Adds a template registry.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_template_registry(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def texture_registry(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, show: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a dynamic texture.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_texture_registry(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, show=show, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def theme(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, **kwargs) -> Union[int, str]:
	"""	 Adds a theme.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		id (Union[int, str], optional): (deprecated) 
		default_theme (bool, optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']

		if 'default_theme' in kwargs.keys():
			warnings.warn('default_theme keyword removed', DeprecationWarning, 2)
			kwargs.pop('default_theme', None)
		widget = internal_dpg.add_theme(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def theme_component(item_type : int =0, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, enabled_state: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a theme component.

	Args:
		item_type (int, optional): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		enabled_state (bool, optional): 
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_theme_component(item_type, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, enabled_state=enabled_state, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def tooltip(parent : Union[int, str], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, show: bool =True, delay: float =0.0, hide_on_activity: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a tooltip window.

	Args:
		parent (Union[int, str]): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		show (bool, optional): Attempt to render widget.
		delay (float, optional): Activation delay: time, in seconds, during which the mouse should stay still in order to display the tooltip.  May be zero for instant activation.
		hide_on_activity (bool, optional): Hide the tooltip if the user has moved the mouse.  If False, the tooltip will follow mouse pointer.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_tooltip(parent, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, show=show, delay=delay, hide_on_activity=hide_on_activity, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def tree_node(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, default_open: bool =False, open_on_double_click: bool =False, open_on_arrow: bool =False, leaf: bool =False, bullet: bool =False, selectable: bool =False, span_text_width: bool =False, span_full_width: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a tree node to add items to.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_open (bool, optional): Sets the tree node open by default.
		open_on_double_click (bool, optional): Need double-click to open node.
		open_on_arrow (bool, optional): Only open when clicking on the arrow part.
		leaf (bool, optional): No collapsing, no arrow (use as a convenience for leaf nodes).
		bullet (bool, optional): Display a bullet instead of arrow.
		selectable (bool, optional): Makes the tree selectable.
		span_text_width (bool, optional): Makes hitbox and highlight only cover the label.
		span_full_width (bool, optional): Extend hit box to the left-most and right-most edges (cover the indent area).
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_tree_node(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, payload_type=payload_type, drag_callback=drag_callback, drop_callback=drop_callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, default_open=default_open, open_on_double_click=open_on_double_click, open_on_arrow=open_on_arrow, leaf=leaf, bullet=bullet, selectable=selectable, span_text_width=span_text_width, span_full_width=span_full_width, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def value_registry(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, **kwargs) -> Union[int, str]:
	"""	 Adds a value registry.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_value_registry(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def viewport_drawlist(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, show: bool =True, filter_key: str ='', delay_search: bool =False, front: bool =True, **kwargs) -> Union[int, str]:
	"""	 A container that is used to present draw items or layers directly to the viewport. By default this will draw to the back of the viewport. Layers and draw items should be added to this widget as children.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		show (bool, optional): Attempt to render widget.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		front (bool, optional): Draws to the front of the view port instead of the back.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_viewport_drawlist(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, show=show, filter_key=filter_key, delay_search=delay_search, front=front, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def viewport_menu_bar(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, show: bool =True, delay_search: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a menubar to the viewport.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		show (bool, optional): Attempt to render widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_viewport_menu_bar(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, show=show, delay_search=delay_search, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

@contextmanager
def window(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], delay_search: bool =False, min_size: Union[List[int], Tuple[int, ...]] =[100, 100], max_size: Union[List[int], Tuple[int, ...]] =[30000, 30000], menubar: bool =False, collapsed: bool =False, autosize: bool =False, no_resize: bool =False, unsaved_document: bool =False, no_title_bar: bool =False, no_move: bool =False, no_scrollbar: bool =False, no_collapse: bool =False, horizontal_scrollbar: bool =False, no_focus_on_appearing: bool =False, no_bring_to_front_on_focus: bool =False, no_close: bool =False, no_background: bool =False, modal: bool =False, popup: bool =False, no_saved_settings: bool =False, no_open_over_existing_popup: bool =True, no_scroll_with_mouse: bool =False, on_close: Callable =None, **kwargs) -> Union[int, str]:
	"""	 Creates a new window for following items to be added to.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		min_size (Union[List[int], Tuple[int, ...]], optional): Minimum window size.
		max_size (Union[List[int], Tuple[int, ...]], optional): Maximum window size.
		menubar (bool, optional): Shows or hides the menubar.
		collapsed (bool, optional): Collapse the window.
		autosize (bool, optional): Autosized the window to fit it's items.
		no_resize (bool, optional): Allows for the window size to be changed or fixed.
		unsaved_document (bool, optional): Show a special marker if the document is not saved.
		no_title_bar (bool, optional): Title name for the title bar of the window.
		no_move (bool, optional): Allows for the window's position to be changed or fixed.
		no_scrollbar (bool, optional):  Disable scrollbars. (window can still scroll with mouse or programmatically)
		no_collapse (bool, optional): Disable user collapsing window by double-clicking on it.
		horizontal_scrollbar (bool, optional): Allow horizontal scrollbar to appear. (off by default)
		no_focus_on_appearing (bool, optional): Disable taking focus when transitioning from hidden to visible state.
		no_bring_to_front_on_focus (bool, optional): Disable bringing window to front when taking focus. (e.g. clicking on it or programmatically giving it focus)
		no_close (bool, optional): Disable user closing the window by removing the close button.
		no_background (bool, optional): Sets Background and border alpha to transparent.
		modal (bool, optional): Fills area behind window according to the theme and disables user ability to interact with anything except the window.
		popup (bool, optional): Fills area behind window according to the theme, removes title bar, collapse and close. Window can be closed by selecting area in the background behind the window.
		no_saved_settings (bool, optional): Never load/save settings in .ini file.
		no_open_over_existing_popup (bool, optional): Don't open if there's already a popup
		no_scroll_with_mouse (bool, optional): Disable user vertically scrolling with mouse wheel.
		on_close (Callable, optional): Callback ran when window is closed.
		id (Union[int, str], optional): (deprecated) 
	Yields:
		Union[int, str]
	"""
	try:

		if 'id' in kwargs.keys():
			warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
			tag=kwargs['id']
		widget = internal_dpg.add_window(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, show=show, pos=pos, delay_search=delay_search, min_size=min_size, max_size=max_size, menubar=menubar, collapsed=collapsed, autosize=autosize, no_resize=no_resize, unsaved_document=unsaved_document, no_title_bar=no_title_bar, no_move=no_move, no_scrollbar=no_scrollbar, no_collapse=no_collapse, horizontal_scrollbar=horizontal_scrollbar, no_focus_on_appearing=no_focus_on_appearing, no_bring_to_front_on_focus=no_bring_to_front_on_focus, no_close=no_close, no_background=no_background, modal=modal, popup=popup, no_saved_settings=no_saved_settings, no_open_over_existing_popup=no_open_over_existing_popup, no_scroll_with_mouse=no_scroll_with_mouse, on_close=on_close, **kwargs)
		internal_dpg.push_container_stack(widget)
		yield widget
	finally:
		internal_dpg.pop_container_stack()

##########################################################
# Core Wrappings
##########################################################

def add_2d_histogram_series(x : Union[List[float], Tuple[float, ...]], y : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, xbins: int =-1, ybins: int =-1, xmin_range: float =0.0, xmax_range: float =0.0, ymin_range: float =0.0, ymax_range: float =0.0, density: bool =False, outliers: bool =False, col_major: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a 2d histogram series.

	Args:
		x (Any): 
		y (Any): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		xbins (int, optional): 
		ybins (int, optional): 
		xmin_range (float, optional): set the min x range value, the values under this min will be ignored
		xmax_range (float, optional): set the max x range value, the values over this max will be ignored
		ymin_range (float, optional): set the min y range value, the values under this min will be ignored
		ymax_range (float, optional): set the max y range value, the values over this max will be ignored. If all xmin, xmax, ymin and ymax are 0.0, then the values will be the min and max values of the series
		density (bool, optional): counts will be normalized, i.e. the PDF will be visualized
		outliers (bool, optional): exclude values outside the specified histogram range from the count used for normalizing
		col_major (bool, optional): data will be read in column major order
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_2d_histogram_series(x, y, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, xbins=xbins, ybins=ybins, xmin_range=xmin_range, xmax_range=xmax_range, ymin_range=ymin_range, ymax_range=ymax_range, density=density, outliers=outliers, col_major=col_major, **kwargs)

def add_3d_slider(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: Union[List[float], Tuple[float, ...]] =(0.0, 0.0, 0.0, 0.0), max_x: float =100.0, max_y: float =100.0, max_z: float =100.0, min_x: float =0.0, min_y: float =0.0, min_z: float =0.0, scale: float =1.0, **kwargs) -> Union[int, str]:
	"""	 Adds a 3D box slider.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (Union[List[float], Tuple[float, ...]], optional): 
		max_x (float, optional): Applies upper limit to slider.
		max_y (float, optional): Applies upper limit to slider.
		max_z (float, optional): Applies upper limit to slider.
		min_x (float, optional): Applies lower limit to slider.
		min_y (float, optional): Applies lower limit to slider.
		min_z (float, optional): Applies lower limit to slider.
		scale (float, optional): Size of the widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_3d_slider(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, max_x=max_x, max_y=max_y, max_z=max_z, min_x=min_x, min_y=min_y, min_z=min_z, scale=scale, **kwargs)

def add_alias(alias : str, item : Union[int, str], **kwargs) -> None:
	"""	 Adds an alias.

	Args:
		alias (str): 
		item (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.add_alias(alias, item, **kwargs)

def add_area_series(x : Union[List[float], Tuple[float, ...]], y : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, fill: Union[List[int], Tuple[int, ...]] =(0, 0, 0, -255), contribute_to_bounds: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds an area series to a plot.

	Args:
		x (Any): 
		y (Any): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		fill (Union[List[int], Tuple[int, ...]], optional): 
		contribute_to_bounds (bool, optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_area_series(x, y, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, fill=fill, contribute_to_bounds=contribute_to_bounds, **kwargs)

def add_axis_tag(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, default_value: float =0.0, color: Union[List[int], Tuple[int, ...]] =(0, 0, 0, -255), auto_rounding: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds custom labels to axes.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		default_value (float, optional): 
		color (Union[List[int], Tuple[int, ...]], optional): 
		auto_rounding (bool, optional): When enabled, the value displayed on the tag will be automatically rounded to the precision of other values displayed at axis' ticks. Only makes sense when label is not set, i.e. when the tag displays its location on the axis.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_axis_tag(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, default_value=default_value, color=color, auto_rounding=auto_rounding, **kwargs)

def add_bar_group_series(values : Union[List[float], Tuple[float, ...]], label_ids : Union[List[str], Tuple[str, ...]], group_size : int, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, group_width: float =0.67, shift: int =0, horizontal: bool =False, stacked: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a bar groups series to a plot.

	Args:
		values (Any): 
		label_ids (Union[List[str], Tuple[str, ...]]): Label of each bar in a group
		group_size (int): Number of bars in a group
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		group_width (float, optional): Size of bar groups
		shift (int, optional): The position on the x axis where to start plotting bar groups
		horizontal (bool, optional): bar groups will be rendered horizontally on the current y-axis
		stacked (bool, optional): items in a group will be stacked on top of each other
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_bar_group_series(values, label_ids, group_size, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, group_width=group_width, shift=shift, horizontal=horizontal, stacked=stacked, **kwargs)

def add_bar_series(x : Union[List[float], Tuple[float, ...]], y : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, weight: float =1.0, horizontal: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a bar series to a plot.

	Args:
		x (Any): 
		y (Any): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		weight (float, optional): 
		horizontal (bool, optional): bars will be rendered horizontally on the current y-axis
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_bar_series(x, y, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, weight=weight, horizontal=horizontal, **kwargs)

def add_bool_value(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, source: Union[int, str] =0, default_value: bool =False, parent: Union[int, str] =internal_dpg.mvReservedUUID_3, **kwargs) -> Union[int, str]:
	"""	 Adds a bool value.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		default_value (bool, optional): 
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_bool_value(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, source=source, default_value=default_value, parent=parent, **kwargs)

def add_button(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, small: bool =False, arrow: bool =False, direction: int =0, repeat: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a button.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		small (bool, optional): Shrinks the size of the button to the text of the label it contains. Useful for embedding in text.
		arrow (bool, optional): Displays an arrow in place of the text string. This requires the direction keyword.
		direction (int, optional): Sets the cardinal direction for the arrow by using constants mvDir_Left, mvDir_Up, mvDir_Down, mvDir_Right, mvDir_None. Arrow keyword must be set to True.
		repeat (bool, optional): Hold to continuosly repeat the click.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_button(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, small=small, arrow=arrow, direction=direction, repeat=repeat, **kwargs)

def add_candle_series(dates : Union[List[float], Tuple[float, ...]], opens : Union[List[float], Tuple[float, ...]], closes : Union[List[float], Tuple[float, ...]], lows : Union[List[float], Tuple[float, ...]], highs : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, bull_color: Union[List[int], Tuple[int, ...]] =(0, 255, 113, 255), bear_color: Union[List[int], Tuple[int, ...]] =(218, 13, 79, 255), weight: float =0.25, tooltip: bool =True, time_unit: int =5, **kwargs) -> Union[int, str]:
	"""	 Adds a candle series to a plot.

	Args:
		dates (Any): 
		opens (Any): 
		closes (Any): 
		lows (Any): 
		highs (Any): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		bull_color (Union[List[int], Tuple[int, ...]], optional): 
		bear_color (Union[List[int], Tuple[int, ...]], optional): 
		weight (float, optional): 
		tooltip (bool, optional): 
		time_unit (int, optional): mvTimeUnit_* constants. Default mvTimeUnit_Day.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_candle_series(dates, opens, closes, lows, highs, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, bull_color=bull_color, bear_color=bear_color, weight=weight, tooltip=tooltip, time_unit=time_unit, **kwargs)

def add_char_remap(source : int, target : int, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, **kwargs) -> Union[int, str]:
	"""	 Remaps a character.

	Args:
		source (int): 
		target (int): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_char_remap(source, target, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, **kwargs)

def add_checkbox(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a checkbox.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (bool, optional): Sets the default value of the checkmark
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_checkbox(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, **kwargs)

def add_child_window(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, border: bool =True, autosize_x: bool =False, autosize_y: bool =False, no_scrollbar: bool =False, horizontal_scrollbar: bool =False, menubar: bool =False, no_scroll_with_mouse: bool =False, flattened_navigation: bool =True, always_use_window_padding: bool =False, resizable_x: bool =False, resizable_y: bool =False, always_auto_resize: bool =False, frame_style: bool =False, auto_resize_x: bool =False, auto_resize_y: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds an embedded child window. Will show scrollbars when items do not fit. About using auto_resize/resizable flags: size measurement for a given axis is only performed when the child window is within visible boundaries, or is just appearing and it won't update its auto-size while clipped. While not perfect, it is a better default behavior as the always-on performance gain is more valuable than the occasional 'resizing after becoming visible again' glitch. You may also use always_auto_resize to force an update even when child window is not in view. However doing so will degrade performance. Remember that combining both auto_resize_x and auto_resize_y defeats purpose of a scrolling region and is NOT recommended.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		border (bool, optional): Shows/Hides the border around the sides.
		autosize_x (bool, optional): Autosize the window to its parents size in x.
		autosize_y (bool, optional): Autosize the window to its parents size in y.
		no_scrollbar (bool, optional):  Disable scrollbars (window can still scroll with mouse or programmatically).
		horizontal_scrollbar (bool, optional): Allow horizontal scrollbar to appear (off by default).
		menubar (bool, optional): Shows/Hides the menubar at the top.
		no_scroll_with_mouse (bool, optional): Disable user vertically scrolling with mouse wheel.
		flattened_navigation (bool, optional): Allow gamepad/keyboard navigation to cross over parent border to this child (only use on child that have no scrolling!)
		always_use_window_padding (bool, optional): Pad with style.WindowPadding even if no border are drawn (no padding by default for non-bordered child windows because it makes more sense)
		resizable_x (bool, optional): Allow resize from right border (layout direction). Enable .ini saving.
		resizable_y (bool, optional): Allow resize from bottom border (layout direction). 
		always_auto_resize (bool, optional): Combined with auto_resize_x/auto_resize_y. Always measure size even when child is hidden and always disable clipping optimization! NOT RECOMMENDED.
		frame_style (bool, optional): Style the child window like a framed item: use FrameBg, FrameRounding, FrameBorderSize, FramePadding instead of ChildBg, ChildRounding, ChildBorderSize, WindowPadding.
		auto_resize_x (bool, optional): Enable auto-resizing width based on child content. Read 'IMPORTANT: Size measurement' details above.
		auto_resize_y (bool, optional): Enable auto-resizing height based on child content. Read 'IMPORTANT: Size measurement' details above.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_child_window(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, payload_type=payload_type, drop_callback=drop_callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, border=border, autosize_x=autosize_x, autosize_y=autosize_y, no_scrollbar=no_scrollbar, horizontal_scrollbar=horizontal_scrollbar, menubar=menubar, no_scroll_with_mouse=no_scroll_with_mouse, flattened_navigation=flattened_navigation, always_use_window_padding=always_use_window_padding, resizable_x=resizable_x, resizable_y=resizable_y, always_auto_resize=always_auto_resize, frame_style=frame_style, auto_resize_x=auto_resize_x, auto_resize_y=auto_resize_y, **kwargs)

def add_clipper(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, delay_search: bool =False, **kwargs) -> Union[int, str]:
	"""	 Helper to manually clip large list of items. Increases performance by not searching or drawing widgets outside of the clipped region.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_clipper(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, show=show, delay_search=delay_search, **kwargs)

def add_collapsing_header(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, closable: bool =False, default_open: bool =False, open_on_double_click: bool =False, open_on_arrow: bool =False, leaf: bool =False, bullet: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a collapsing header to add items to. Must be closed with the end command.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		closable (bool, optional): Adds the ability to hide this widget by pressing the (x) in the top right of widget.
		default_open (bool, optional): Sets the collapseable header open by default.
		open_on_double_click (bool, optional): Need double-click to open node.
		open_on_arrow (bool, optional): Only open when clicking on the arrow part.
		leaf (bool, optional): No collapsing, no arrow (use as a convenience for leaf nodes).
		bullet (bool, optional): Display a bullet instead of arrow.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_collapsing_header(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, payload_type=payload_type, drag_callback=drag_callback, drop_callback=drop_callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, closable=closable, default_open=default_open, open_on_double_click=open_on_double_click, open_on_arrow=open_on_arrow, leaf=leaf, bullet=bullet, **kwargs)

def add_color_button(default_value : Union[List[int], Tuple[int, ...]] =(0, 0, 0, 255), *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, no_alpha: bool =False, no_border: bool =False, no_drag_drop: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a color button.

	Args:
		default_value (Union[List[int], Tuple[int, ...]], optional): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		no_alpha (bool, optional): Removes the displayed slider that can change alpha channel.
		no_border (bool, optional): Disable border around the image.
		no_drag_drop (bool, optional): Disable ability to drag and drop small preview (color square) to apply colors to other items.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_color_button(default_value, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, no_alpha=no_alpha, no_border=no_border, no_drag_drop=no_drag_drop, **kwargs)

def add_color_edit(default_value : Union[List[int], Tuple[int, ...]] =(0, 0, 0, 255), *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, no_alpha: bool =False, no_picker: bool =False, no_options: bool =False, no_small_preview: bool =False, no_inputs: bool =False, no_tooltip: bool =False, no_label: bool =False, no_drag_drop: bool =False, alpha_bar: bool =False, alpha_preview: int =0, display_mode: int =internal_dpg.mvColorEdit_rgb, display_type: int =internal_dpg.mvColorEdit_uint8, input_mode: int =internal_dpg.mvColorEdit_input_rgb, **kwargs) -> Union[int, str]:
	"""	 Adds an RGBA color editor. Left clicking the small color preview will provide a color picker. Click and draging the small color preview will copy the color to be applied on any other color widget.

	Args:
		default_value (Union[List[int], Tuple[int, ...]], optional): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		no_alpha (bool, optional): Removes the displayed slider that can change alpha channel.
		no_picker (bool, optional): Disable picker popup when color square is clicked.
		no_options (bool, optional): Disable toggling options menu when right-clicking on inputs/small preview.
		no_small_preview (bool, optional): Disable colored square preview next to the inputs. (e.g. to show only the inputs). This only displays if the side preview is not shown.
		no_inputs (bool, optional): Disable inputs sliders/text widgets. (e.g. to show only the small preview colored square)
		no_tooltip (bool, optional): Disable tooltip when hovering the preview.
		no_label (bool, optional): Disable display of inline text label.
		no_drag_drop (bool, optional): Disable ability to drag and drop small preview (color square) to apply colors to other items.
		alpha_bar (bool, optional): Show vertical alpha bar/gradient in picker.
		alpha_preview (int, optional): mvColorEdit_AlphaPreviewNone, mvColorEdit_AlphaPreview, or mvColorEdit_AlphaPreviewHalf
		display_mode (int, optional): mvColorEdit_rgb, mvColorEdit_hsv, or mvColorEdit_hex
		display_type (int, optional): mvColorEdit_uint8 or mvColorEdit_float
		input_mode (int, optional): mvColorEdit_input_* values
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_color_edit(default_value, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, no_alpha=no_alpha, no_picker=no_picker, no_options=no_options, no_small_preview=no_small_preview, no_inputs=no_inputs, no_tooltip=no_tooltip, no_label=no_label, no_drag_drop=no_drag_drop, alpha_bar=alpha_bar, alpha_preview=alpha_preview, display_mode=display_mode, display_type=display_type, input_mode=input_mode, **kwargs)

def add_color_picker(default_value : Union[List[int], Tuple[int, ...]] =(0, 0, 0, 255), *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, no_alpha: bool =False, no_side_preview: bool =False, no_small_preview: bool =False, no_inputs: bool =False, no_tooltip: bool =False, no_label: bool =False, alpha_bar: bool =False, display_rgb: bool =False, display_hsv: bool =False, display_hex: bool =False, picker_mode: int =internal_dpg.mvColorPicker_bar, alpha_preview: int =0, display_type: int =internal_dpg.mvColorEdit_uint8, input_mode: int =internal_dpg.mvColorEdit_input_rgb, **kwargs) -> Union[int, str]:
	"""	 Adds an RGB color picker. Right click the color picker for options. Click and drag the color preview to copy the color and drop on any other color widget to apply. Right Click allows the style of the color picker to be changed.

	Args:
		default_value (Union[List[int], Tuple[int, ...]], optional): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		no_alpha (bool, optional): Removes the displayed slider that can change alpha channel.
		no_side_preview (bool, optional): Disable bigger color preview on right side of the picker, use small colored square preview instead , unless small preview is also hidden.
		no_small_preview (bool, optional): Disable colored square preview next to the inputs. (e.g. to show only the inputs). This only displays if the side preview is not shown.
		no_inputs (bool, optional): Disable inputs sliders/text widgets. (e.g. to show only the small preview colored square)
		no_tooltip (bool, optional): Disable tooltip when hovering the preview.
		no_label (bool, optional): Disable display of inline text label.
		alpha_bar (bool, optional): Show vertical alpha bar/gradient in picker.
		display_rgb (bool, optional): Override _display_ type among RGB/HSV/Hex.
		display_hsv (bool, optional): Override _display_ type among RGB/HSV/Hex.
		display_hex (bool, optional): Override _display_ type among RGB/HSV/Hex.
		picker_mode (int, optional): mvColorPicker_bar or mvColorPicker_wheel
		alpha_preview (int, optional): mvColorEdit_AlphaPreviewNone, mvColorEdit_AlphaPreview, or mvColorEdit_AlphaPreviewHalf
		display_type (int, optional): mvColorEdit_uint8 or mvColorEdit_float
		input_mode (int, optional): mvColorEdit_input_* values.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_color_picker(default_value, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, no_alpha=no_alpha, no_side_preview=no_side_preview, no_small_preview=no_small_preview, no_inputs=no_inputs, no_tooltip=no_tooltip, no_label=no_label, alpha_bar=alpha_bar, display_rgb=display_rgb, display_hsv=display_hsv, display_hex=display_hex, picker_mode=picker_mode, alpha_preview=alpha_preview, display_type=display_type, input_mode=input_mode, **kwargs)

def add_color_value(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, source: Union[int, str] =0, default_value: Union[List[float], Tuple[float, ...]] =(0.0, 0.0, 0.0, 0.0), parent: Union[int, str] =internal_dpg.mvReservedUUID_3, **kwargs) -> Union[int, str]:
	"""	 Adds a color value.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		default_value (Union[List[float], Tuple[float, ...]], optional): 
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_color_value(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, source=source, default_value=default_value, parent=parent, **kwargs)

def add_colormap(colors : List[Union[List[int], Tuple[int, ...]]], qualitative : bool, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, show: bool =True, parent: Union[int, str] =internal_dpg.mvReservedUUID_4, **kwargs) -> Union[int, str]:
	"""	 Adds a legend that pairs colors with normalized value 0.0->1.0. Each color will be  This is typically used with a heat series. (ex. [[0, 0, 0, 255], [255, 255, 255, 255]] will be mapped to a soft transition from 0.0-1.0)

	Args:
		colors (Any): colors that will be mapped to the normalized value 0.0->1.0
		qualitative (bool): Qualitative will create hard transitions for color boundries across the value range when enabled.
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		show (bool, optional): Attempt to render widget.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_colormap(colors, qualitative, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, show=show, parent=parent, **kwargs)

def add_colormap_button(default_value : Union[List[int], Tuple[int, ...]] =(0, 0, 0, 255), *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, **kwargs) -> Union[int, str]:
	"""	 Adds a button that a color map can be bound to.

	Args:
		default_value (Union[List[int], Tuple[int, ...]], optional): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_colormap_button(default_value, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, **kwargs)

def add_colormap_registry(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, show: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a colormap registry.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_colormap_registry(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, show=show, **kwargs)

def add_colormap_scale(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], colormap: Union[int, str] =0, min_scale: float =0.0, max_scale: float =1.0, format: str ='%g', reverse_dir: bool =False, mirror: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a legend that pairs values with colors. This is typically used with a heat series. 

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		colormap (Union[int, str], optional): mvPlotColormap_* constants or mvColorMap uuid from a color map registry
		min_scale (float, optional): Sets the min number of the color scale. Typically is the same as the min scale from the heat series.
		max_scale (float, optional): Sets the max number of the color scale. Typically is the same as the max scale from the heat series.
		format (str, optional): Formatting used for the labels.
		reverse_dir (bool, optional): invert the colormap bar and axis scale (this only affects rendering; if you only want to reverse the scale mapping, make scale_min > scale_max)
		mirror (bool, optional): render the colormap label and tick labels on the opposite side
		id (Union[int, str], optional): (deprecated) 
		drag_callback (Callable, optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	if 'drag_callback' in kwargs.keys():

		warnings.warn('drag_callback keyword removed', DeprecationWarning, 2)

		kwargs.pop('drag_callback', None)

	return internal_dpg.add_colormap_scale(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, drop_callback=drop_callback, show=show, pos=pos, colormap=colormap, min_scale=min_scale, max_scale=max_scale, format=format, reverse_dir=reverse_dir, mirror=mirror, **kwargs)

def add_colormap_slider(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: float =0.0, **kwargs) -> Union[int, str]:
	"""	 Adds a color slider that a color map can be bound to.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (float, optional): 
		id (Union[int, str], optional): (deprecated) 
		drag_callback (Callable, optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	if 'drag_callback' in kwargs.keys():

		warnings.warn('drag_callback keyword removed', DeprecationWarning, 2)

		kwargs.pop('drag_callback', None)

	return internal_dpg.add_colormap_slider(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, payload_type=payload_type, callback=callback, drop_callback=drop_callback, show=show, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, **kwargs)

def add_combo(items : Union[List[str], Tuple[str, ...]] =(), *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: str ='', popup_align_left: bool =False, no_arrow_button: bool =False, no_preview: bool =False, fit_width: bool =False, height_mode: int =1, **kwargs) -> Union[int, str]:
	"""	 Adds a combo dropdown that allows a user to select a single option from a drop down window. All items will be shown as selectables on the dropdown.

	Args:
		items (Union[List[str], Tuple[str, ...]], optional): A tuple of items to be shown in the drop down window. Can consist of any combination of types but will convert all items to strings to be shown.
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (str, optional): Sets a selected item from the drop down by specifying the string value.
		popup_align_left (bool, optional): Align the contents on the popup toward the left.
		no_arrow_button (bool, optional): Display the preview box without the square arrow button indicating dropdown activity.
		no_preview (bool, optional): Display only the square arrow button and not the selected value.
		fit_width (bool, optional): Fit the available width.
		height_mode (int, optional): Controlls the number of items shown in the dropdown by the constants mvComboHeight_Small, mvComboHeight_Regular, mvComboHeight_Large, mvComboHeight_Largest
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_combo(items, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, popup_align_left=popup_align_left, no_arrow_button=no_arrow_button, no_preview=no_preview, fit_width=fit_width, height_mode=height_mode, **kwargs)

def add_custom_series(x : Union[List[float], Tuple[float, ...]], y : Union[List[float], Tuple[float, ...]], channel_count : int, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, callback: Callable =None, show: bool =True, y1: Any =[], y2: Any =[], y3: Any =[], tooltip: bool =True, no_fit: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a custom series to a plot. New in 1.6.

	Args:
		x (Any): 
		y (Any): 
		channel_count (int): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		y1 (Any, optional): 
		y2 (Any, optional): 
		y3 (Any, optional): 
		tooltip (bool, optional): Show tooltip when plot is hovered.
		no_fit (bool, optional): the item won't be considered for plot fits
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_custom_series(x, y, channel_count, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, callback=callback, show=show, y1=y1, y2=y2, y3=y3, tooltip=tooltip, no_fit=no_fit, **kwargs)

def add_date_picker(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: dict ={'month_day': 14, 'year':20, 'month':5}, level: int =0, **kwargs) -> Union[int, str]:
	"""	 Adds a data picker.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (dict, optional): 
		level (int, optional): Use avaliable constants. mvDatePickerLevel_Day, mvDatePickerLevel_Month, mvDatePickerLevel_Year
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_date_picker(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, level=level, **kwargs)

def add_digital_series(x : Union[List[float], Tuple[float, ...]], y : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a digital series to a plot. Digital plots do not respond to y drag or zoom, and are always referenced to the bottom of the plot.

	Args:
		x (Any): 
		y (Any): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_digital_series(x, y, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, **kwargs)

def add_double4_value(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, source: Union[int, str] =0, default_value: Any =(0.0, 0.0, 0.0, 0.0), parent: Union[int, str] =internal_dpg.mvReservedUUID_3, **kwargs) -> Union[int, str]:
	"""	 Adds a double value.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		default_value (Any, optional): 
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_double4_value(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, source=source, default_value=default_value, parent=parent, **kwargs)

def add_double_value(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, source: Union[int, str] =0, default_value: float =0.0, parent: Union[int, str] =internal_dpg.mvReservedUUID_3, **kwargs) -> Union[int, str]:
	"""	 Adds a double value.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		default_value (float, optional): 
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_double_value(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, source=source, default_value=default_value, parent=parent, **kwargs)

def add_drag_double(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: float =0.0, format: str ='%0.3f', speed: float =1.0, min_value: float =0.0, max_value: float =100.0, no_input: bool =False, clamped: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds drag for a single double value. Useful when drag float is not accurate enough. Directly entry can be done with double click or CTRL+Click. Min and Max alone are a soft limit for the drag. Use clamped keyword to also apply limits to the direct entry modes.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (float, optional): 
		format (str, optional): Determines the format the float will be displayed as use python string formatting.
		speed (float, optional): Sets the sensitivity the float will be modified while dragging.
		min_value (float, optional): Applies a limit only to draging entry only.
		max_value (float, optional): Applies a limit only to draging entry only.
		no_input (bool, optional): Disable direct entry methods or Enter key allowing to input text directly into the widget.
		clamped (bool, optional): Applies the min and max limits to direct entry methods also such as double click and CTRL+Click.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_drag_double(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, format=format, speed=speed, min_value=min_value, max_value=max_value, no_input=no_input, clamped=clamped, **kwargs)

def add_drag_doublex(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: Any =(0.0, 0.0, 0.0, 0.0), size: int =4, format: str ='%0.3f', speed: float =1.0, min_value: float =0.0, max_value: float =100.0, no_input: bool =False, clamped: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds drag input for a set of double values up to 4. Useful when drag float is not accurate enough. Directly entry can be done with double click or CTRL+Click. Min and Max alone are a soft limit for the drag. Use clamped keyword to also apply limits to the direct entry modes.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (Any, optional): 
		size (int, optional): Number of doubles to be displayed.
		format (str, optional): Determines the format the float will be displayed as use python string formatting.
		speed (float, optional): Sets the sensitivity the float will be modified while dragging.
		min_value (float, optional): Applies a limit only to draging entry only.
		max_value (float, optional): Applies a limit only to draging entry only.
		no_input (bool, optional): Disable direct entry methods or Enter key allowing to input text directly into the widget.
		clamped (bool, optional): Applies the min and max limits to direct entry methods also such as double click and CTRL+Click.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_drag_doublex(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, size=size, format=format, speed=speed, min_value=min_value, max_value=max_value, no_input=no_input, clamped=clamped, **kwargs)

def add_drag_float(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: float =0.0, format: str ='%0.3f', speed: float =1.0, min_value: float =0.0, max_value: float =100.0, no_input: bool =False, clamped: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds drag for a single float value. Directly entry can be done with double click or CTRL+Click. Min and Max alone are a soft limit for the drag. Use clamped keyword to also apply limits to the direct entry modes.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (float, optional): 
		format (str, optional): Determines the format the float will be displayed as use python string formatting.
		speed (float, optional): Sets the sensitivity the float will be modified while dragging.
		min_value (float, optional): Applies a limit only to draging entry only.
		max_value (float, optional): Applies a limit only to draging entry only.
		no_input (bool, optional): Disable direct entry methods or Enter key allowing to input text directly into the widget.
		clamped (bool, optional): Applies the min and max limits to direct entry methods also such as double click and CTRL+Click.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_drag_float(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, format=format, speed=speed, min_value=min_value, max_value=max_value, no_input=no_input, clamped=clamped, **kwargs)

def add_drag_floatx(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: Union[List[float], Tuple[float, ...]] =(0.0, 0.0, 0.0, 0.0), size: int =4, format: str ='%0.3f', speed: float =1.0, min_value: float =0.0, max_value: float =100.0, no_input: bool =False, clamped: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds drag input for a set of float values up to 4. Directly entry can be done with double click or CTRL+Click. Min and Max alone are a soft limit for the drag. Use clamped keyword to also apply limits to the direct entry modes.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (Union[List[float], Tuple[float, ...]], optional): 
		size (int, optional): Number of floats to be displayed.
		format (str, optional): Determines the format the float will be displayed as use python string formatting.
		speed (float, optional): Sets the sensitivity the float will be modified while dragging.
		min_value (float, optional): Applies a limit only to draging entry only.
		max_value (float, optional): Applies a limit only to draging entry only.
		no_input (bool, optional): Disable direct entry methods or Enter key allowing to input text directly into the widget.
		clamped (bool, optional): Applies the min and max limits to direct entry methods also such as double click and CTRL+Click.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_drag_floatx(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, size=size, format=format, speed=speed, min_value=min_value, max_value=max_value, no_input=no_input, clamped=clamped, **kwargs)

def add_drag_int(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: int =0, format: str ='%d', speed: float =1.0, min_value: int =0, max_value: int =100, no_input: bool =False, clamped: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds drag for a single int value. Directly entry can be done with double click or CTRL+Click. Min and Max alone are a soft limit for the drag. Use clamped keyword to also apply limits to the direct entry modes.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (int, optional): 
		format (str, optional): Determines the format the float will be displayed as use python string formatting.
		speed (float, optional): Sets the sensitivity the float will be modified while dragging.
		min_value (int, optional): Applies a limit only to draging entry only.
		max_value (int, optional): Applies a limit only to draging entry only.
		no_input (bool, optional): Disable direct entry methods or Enter key allowing to input text directly into the widget.
		clamped (bool, optional): Applies the min and max limits to direct entry methods also such as double click and CTRL+Click.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_drag_int(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, format=format, speed=speed, min_value=min_value, max_value=max_value, no_input=no_input, clamped=clamped, **kwargs)

def add_drag_intx(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: Union[List[int], Tuple[int, ...]] =(0, 0, 0, 0), size: int =4, format: str ='%d', speed: float =1.0, min_value: int =0, max_value: int =100, no_input: bool =False, clamped: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds drag input for a set of int values up to 4. Directly entry can be done with double click or CTRL+Click. Min and Max alone are a soft limit for the drag. Use clamped keyword to also apply limits to the direct entry modes.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (Union[List[int], Tuple[int, ...]], optional): 
		size (int, optional): Number of ints to be displayed.
		format (str, optional): Determines the format the int will be displayed as use python string formatting.
		speed (float, optional): Sets the sensitivity the float will be modified while dragging.
		min_value (int, optional): Applies a limit only to draging entry only.
		max_value (int, optional): Applies a limit only to draging entry only.
		no_input (bool, optional): Disable direct entry methods or Enter key allowing to input text directly into the widget.
		clamped (bool, optional): Applies the min and max limits to direct entry methods also such as double click and CTRL+Click.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_drag_intx(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, size=size, format=format, speed=speed, min_value=min_value, max_value=max_value, no_input=no_input, clamped=clamped, **kwargs)

def add_drag_line(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, callback: Callable =None, show: bool =True, default_value: float =0.0, color: Union[List[int], Tuple[int, ...]] =(0, 0, 0, -255), thickness: float =1.0, show_label: bool =True, vertical: bool =True, delayed: bool =False, no_cursor: bool =False, no_fit: bool =False, no_inputs: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a drag line to a plot.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		default_value (float, optional): 
		color (Union[List[int], Tuple[int, ...]], optional): 
		thickness (float, optional): 
		show_label (bool, optional): 
		vertical (bool, optional): 
		delayed (bool, optional): tool rendering will be delayed one frame; useful when applying position-constraints
		no_cursor (bool, optional): drag tools won't change cursor icons when hovered or held
		no_fit (bool, optional): the drag tool won't be considered for plot fits
		no_inputs (bool, optional): lock the tool from user inputs
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_drag_line(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, callback=callback, show=show, default_value=default_value, color=color, thickness=thickness, show_label=show_label, vertical=vertical, delayed=delayed, no_cursor=no_cursor, no_fit=no_fit, no_inputs=no_inputs, **kwargs)

def add_drag_payload(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, show: bool =True, drag_data: Any =None, drop_data: Any =None, payload_type: str ='$$DPG_PAYLOAD', **kwargs) -> Union[int, str]:
	"""	 User data payload for drag and drop operations.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		show (bool, optional): Attempt to render widget.
		drag_data (Any, optional): Drag data
		drop_data (Any, optional): Drop data
		payload_type (str, optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_drag_payload(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, show=show, drag_data=drag_data, drop_data=drop_data, payload_type=payload_type, **kwargs)

def add_drag_point(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, callback: Callable =None, show: bool =True, default_value: Any =(0.0, 0.0), color: Union[List[int], Tuple[int, ...]] =(0, 0, 0, -255), thickness: float =1.0, show_label: bool =True, offset: Union[List[float], Tuple[float, ...]] =(16.0, 8.0), clamped: bool =True, delayed: bool =False, no_cursor: bool =False, no_fit: bool =False, no_inputs: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a drag point to a plot.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		default_value (Any, optional): 
		color (Union[List[int], Tuple[int, ...]], optional): 
		thickness (float, optional): 
		show_label (bool, optional): 
		offset (Union[List[float], Tuple[float, ...]], optional): Offset of the label, in pixels, relative to the drag point itself
		clamped (bool, optional): Keep the label within the visible area of the plot even if the drag point itself goes outside of the visible area
		delayed (bool, optional): tool rendering will be delayed one frame; useful when applying position-constraints
		no_cursor (bool, optional): drag tools won't change cursor icons when hovered or held
		no_fit (bool, optional): the drag tool won't be considered for plot fits
		no_inputs (bool, optional): lock the tool from user inputs
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_drag_point(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, callback=callback, show=show, default_value=default_value, color=color, thickness=thickness, show_label=show_label, offset=offset, clamped=clamped, delayed=delayed, no_cursor=no_cursor, no_fit=no_fit, no_inputs=no_inputs, **kwargs)

def add_drag_rect(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, callback: Callable =None, show: bool =True, default_value: Any =(0.0, 0.0, 0.0, 0.0), color: Union[List[int], Tuple[int, ...]] =(0, 0, 0, -255), delayed: bool =False, no_cursor: bool =False, no_fit: bool =False, no_inputs: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a drag rectangle to a plot.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		default_value (Any, optional): The coordinates are specified in a sequence of: (xmin, ymin, xmax, ymax)
		color (Union[List[int], Tuple[int, ...]], optional): 
		delayed (bool, optional): tool rendering will be delayed one frame; useful when applying position-constraints
		no_cursor (bool, optional): drag tools won't change cursor icons when hovered or held
		no_fit (bool, optional): the drag tool won't be considered for plot fits
		no_inputs (bool, optional): lock the tool from user inputs
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_drag_rect(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, callback=callback, show=show, default_value=default_value, color=color, delayed=delayed, no_cursor=no_cursor, no_fit=no_fit, no_inputs=no_inputs, **kwargs)

def add_draw_layer(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, perspective_divide: bool =False, depth_clipping: bool =False, cull_mode: int =0, **kwargs) -> Union[int, str]:
	"""	 New in 1.1. Creates a layer useful for grouping drawlist items.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		perspective_divide (bool, optional): New in 1.1. apply perspective divide
		depth_clipping (bool, optional): New in 1.1. apply depth clipping
		cull_mode (int, optional): New in 1.1. culling mode, mvCullMode_* constants. Only works with triangles currently.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_draw_layer(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, perspective_divide=perspective_divide, depth_clipping=depth_clipping, cull_mode=cull_mode, **kwargs)

def add_draw_node(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 New in 1.1. Creates a drawing node to associate a transformation matrix. Child node matricies will concatenate.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_draw_node(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, **kwargs)

def add_drawlist(width : int, height : int, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, **kwargs) -> Union[int, str]:
	"""	 Adds a drawing canvas.

	Args:
		width (int): 
		height (int): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_drawlist(width, height, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, callback=callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, **kwargs)

def add_dynamic_texture(width : int, height : int, default_value : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =internal_dpg.mvReservedUUID_2, **kwargs) -> Union[int, str]:
	"""	 Adds a dynamic texture.

	Args:
		width (int): 
		height (int): 
		default_value (Union[List[float], Tuple[float, ...]]): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_dynamic_texture(width, height, default_value, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, **kwargs)

def add_error_series(x : Union[List[float], Tuple[float, ...]], y : Union[List[float], Tuple[float, ...]], negative : Union[List[float], Tuple[float, ...]], positive : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, contribute_to_bounds: bool =True, horizontal: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds an error series to a plot.

	Args:
		x (Any): 
		y (Any): 
		negative (Any): 
		positive (Any): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		contribute_to_bounds (bool, optional): 
		horizontal (bool, optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_error_series(x, y, negative, positive, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, contribute_to_bounds=contribute_to_bounds, horizontal=horizontal, **kwargs)

def add_file_dialog(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, callback: Callable =None, show: bool =True, default_path: str ='', default_filename: str ='.', file_count: int =0, modal: bool =False, directory_selector: bool =False, min_size: Union[List[int], Tuple[int, ...]] =[100, 100], max_size: Union[List[int], Tuple[int, ...]] =[30000, 30000], cancel_callback: Callable =None, **kwargs) -> Union[int, str]:
	"""	 Displays a file or directory selector depending on keywords. Displays a file dialog by default. Callback will be ran when the file or directory picker is closed. The app_data arguemnt will be populated with information related to the file and directory as a dictionary.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		default_path (str, optional): Path that the file dialog will default to when opened.
		default_filename (str, optional): Default name that will show in the file name input.
		file_count (int, optional): Number of visible files in the dialog.
		modal (bool, optional): Forces user interaction with the file selector.
		directory_selector (bool, optional): Shows only directory/paths as options. Allows selection of directory/paths only.
		min_size (Union[List[int], Tuple[int, ...]], optional): Minimum window size.
		max_size (Union[List[int], Tuple[int, ...]], optional): Maximum window size.
		cancel_callback (Callable, optional): Callback called when cancel button is clicked.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_file_dialog(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, callback=callback, show=show, default_path=default_path, default_filename=default_filename, file_count=file_count, modal=modal, directory_selector=directory_selector, min_size=min_size, max_size=max_size, cancel_callback=cancel_callback, **kwargs)

def add_file_extension(extension : str, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, parent: Union[int, str] =0, before: Union[int, str] =0, custom_text: str ='', color: Union[List[int], Tuple[int, ...]] =(-255, 0, 0, 255), **kwargs) -> Union[int, str]:
	"""	 Creates a file extension filter option in the file dialog.

	Args:
		extension (str): Extension that will show as an when the parent is a file dialog.
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		custom_text (str, optional): Replaces the displayed text in the drop down for this extension.
		color (Union[List[int], Tuple[int, ...]], optional): Color for the text that will be shown with specified extensions.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_file_extension(extension, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, parent=parent, before=before, custom_text=custom_text, color=color, **kwargs)

def add_filter_set(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, delay_search: bool =False, **kwargs) -> Union[int, str]:
	"""	 Helper to parse and apply text filters (e.g. aaaaa[, bbbbb][, ccccc])

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_filter_set(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, show=show, delay_search=delay_search, **kwargs)

def add_float4_value(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, source: Union[int, str] =0, default_value: Union[List[float], Tuple[float, ...]] =(0.0, 0.0, 0.0, 0.0), parent: Union[int, str] =internal_dpg.mvReservedUUID_3, **kwargs) -> Union[int, str]:
	"""	 Adds a float4 value.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		default_value (Union[List[float], Tuple[float, ...]], optional): 
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_float4_value(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, source=source, default_value=default_value, parent=parent, **kwargs)

def add_float_value(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, source: Union[int, str] =0, default_value: float =0.0, parent: Union[int, str] =internal_dpg.mvReservedUUID_3, **kwargs) -> Union[int, str]:
	"""	 Adds a float value.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		default_value (float, optional): 
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_float_value(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, source=source, default_value=default_value, parent=parent, **kwargs)

def add_float_vect_value(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, source: Union[int, str] =0, default_value: Union[List[float], Tuple[float, ...]] =(), parent: Union[int, str] =internal_dpg.mvReservedUUID_3, **kwargs) -> Union[int, str]:
	"""	 Adds a float vect value.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		default_value (Union[List[float], Tuple[float, ...]], optional): 
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_float_vect_value(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, source=source, default_value=default_value, parent=parent, **kwargs)

def add_font(file : str, size : int, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, pixel_snapH: bool =False, parent: Union[int, str] =internal_dpg.mvReservedUUID_0, **kwargs) -> Union[int, str]:
	"""	 Adds font to a font registry.

	Args:
		file (str): 
		size (int): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		pixel_snapH (bool, optional): Align every glyph to pixel boundary. Useful e.g. if you are merging a non-pixel aligned font with the default font, or rendering text piece-by-piece (e.g. for coloring).
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
		default_font (bool, optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	if 'default_font' in kwargs.keys():

		warnings.warn('default_font keyword removed', DeprecationWarning, 2)

		kwargs.pop('default_font', None)

	return internal_dpg.add_font(file, size, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, pixel_snapH=pixel_snapH, parent=parent, **kwargs)

def add_font_chars(chars : Union[List[int], Tuple[int, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, **kwargs) -> Union[int, str]:
	"""	 Adds specific font characters to a font.

	Args:
		chars (Union[List[int], Tuple[int, ...]]): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_font_chars(chars, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, **kwargs)

def add_font_range(first_char : int, last_char : int, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, **kwargs) -> Union[int, str]:
	"""	 Adds a range of font characters to a font.

	Args:
		first_char (int): 
		last_char (int): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_font_range(first_char, last_char, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, **kwargs)

def add_font_range_hint(hint : int, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, **kwargs) -> Union[int, str]:
	"""	 Adds a range of font characters (mvFontRangeHint_ constants).

	Args:
		hint (int): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_font_range_hint(hint, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, **kwargs)

def add_font_registry(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a font registry.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_font_registry(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, show=show, **kwargs)

def add_group(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, horizontal: bool =False, horizontal_spacing: float =-1, xoffset: float =0.0, **kwargs) -> Union[int, str]:
	"""	 Creates a group that other widgets can belong to. The group allows item commands to be issued for all of its members.
Enable property acts in a special way enabling/disabling everything inside the group. (Use mvStyleVar_DisabledAlpha to edit colors within the disabled group.)

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		horizontal (bool, optional): Forces child widgets to be added in a horizontal layout.
		horizontal_spacing (float, optional): Spacing for the horizontal layout.
		xoffset (float, optional): Offset from containing window x item location within group.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_group(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, payload_type=payload_type, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, horizontal=horizontal, horizontal_spacing=horizontal_spacing, xoffset=xoffset, **kwargs)

def add_handler_registry(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a handler registry.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_handler_registry(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, show=show, **kwargs)

def add_heat_series(x : Union[List[float], Tuple[float, ...]], rows : int, cols : int, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, scale_min: float =0.0, scale_max: float =1.0, bounds_min: Any =(0.0, 0.0), bounds_max: Any =(1.0, 1.0), format: str ='%0.1f', contribute_to_bounds: bool =True, col_major: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a heat series to a plot.

	Args:
		x (Any): 
		rows (int): 
		cols (int): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		scale_min (float, optional): Sets the color scale min. Typically paired with the color scale widget scale_min.
		scale_max (float, optional): Sets the color scale max. Typically paired with the color scale widget scale_max.
		bounds_min (Any, optional): 
		bounds_max (Any, optional): 
		format (str, optional): 
		contribute_to_bounds (bool, optional): 
		col_major (bool, optional): data will be read in column major order
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_heat_series(x, rows, cols, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, scale_min=scale_min, scale_max=scale_max, bounds_min=bounds_min, bounds_max=bounds_max, format=format, contribute_to_bounds=contribute_to_bounds, col_major=col_major, **kwargs)

def add_histogram_series(x : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, bins: int =-1, bar_scale: float =1.0, min_range: float =0.0, max_range: float =0.0, cumulative: bool =False, density: bool =False, outliers: bool =True, horizontal: bool =False, contribute_to_bounds: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a histogram series to a plot.

	Args:
		x (Any): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		bins (int, optional): 
		bar_scale (float, optional): 
		min_range (float, optional): set the min range value, the values under this min will be ignored
		max_range (float, optional): set the max range value, the values over this max will be ignored. If both min and max are 0.0, then the values will be the min and max values of the series
		cumulative (bool, optional): each bin will contain its count plus the counts of all previous bins
		density (bool, optional): counts will be normalized, i.e. the PDF will be visualized, or the CDF will be visualized if Cumulative is also set
		outliers (bool, optional): exclude values outside the specifed histogram range from the count toward normalizing and cumulative counts
		horizontal (bool, optional): histogram bars will be rendered horizontally
		contribute_to_bounds (bool, optional): 
		id (Union[int, str], optional): (deprecated) 
		cumlative (bool, optional): (deprecated) Deprecated because of typo
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	if 'cumlative' in kwargs.keys():
		warnings.warn('cumlative keyword renamed to cumulative', DeprecationWarning, 2)
		cumulative=kwargs['cumlative']

	return internal_dpg.add_histogram_series(x, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, bins=bins, bar_scale=bar_scale, min_range=min_range, max_range=max_range, cumulative=cumulative, density=density, outliers=outliers, horizontal=horizontal, contribute_to_bounds=contribute_to_bounds, **kwargs)

def add_image(texture_tag : Union[int, str], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, tint_color: Union[List[float], Tuple[float, ...]] =(255, 255, 255, 255), border_color: Union[List[float], Tuple[float, ...]] =(0, 0, 0, 0), uv_min: Union[List[float], Tuple[float, ...]] =(0.0, 0.0), uv_max: Union[List[float], Tuple[float, ...]] =(1.0, 1.0), **kwargs) -> Union[int, str]:
	"""	 Adds an image from a specified texture. uv_min and uv_max represent the normalized texture coordinates of the original image that will be shown. Using range (0.0,0.0)->(1.0,1.0) for texture coordinates will generally display the entire texture.

	Args:
		texture_tag (Union[int, str]): The texture_tag should come from a texture that was added to a texture registry.
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		tint_color (Union[List[float], Tuple[float, ...]], optional): Applies a color tint to the entire texture.
		border_color (Union[List[float], Tuple[float, ...]], optional): Displays a border of the specified color around the texture. If the theme style has turned off the border it will not be shown.
		uv_min (Union[List[float], Tuple[float, ...]], optional): Normalized texture coordinates min point.
		uv_max (Union[List[float], Tuple[float, ...]], optional): Normalized texture coordinates max point.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_image(texture_tag, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, drag_callback=drag_callback, drop_callback=drop_callback, show=show, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, tint_color=tint_color, border_color=border_color, uv_min=uv_min, uv_max=uv_max, **kwargs)

def add_image_button(texture_tag : Union[int, str], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, tint_color: Union[List[float], Tuple[float, ...]] =(255, 255, 255, 255), background_color: Union[List[float], Tuple[float, ...]] =(0, 0, 0, 0), uv_min: Union[List[float], Tuple[float, ...]] =(0.0, 0.0), uv_max: Union[List[float], Tuple[float, ...]] =(1.0, 1.0), **kwargs) -> Union[int, str]:
	"""	 Adds an button with a texture. uv_min and uv_max represent the normalized texture coordinates of the original image that will be shown. Using range (0.0,0.0)->(1.0,1.0) texture coordinates will generally display the entire texture

	Args:
		texture_tag (Union[int, str]): The texture_tag should come from a texture that was added to a texture registry.
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		tint_color (Union[List[float], Tuple[float, ...]], optional): Applies a color tint to the entire texture.
		background_color (Union[List[float], Tuple[float, ...]], optional): Displays a border of the specified color around the texture.
		uv_min (Union[List[float], Tuple[float, ...]], optional): Normalized texture coordinates min point.
		uv_max (Union[List[float], Tuple[float, ...]], optional): Normalized texture coordinates max point.
		id (Union[int, str], optional): (deprecated) 
		frame_padding (int, optional): (deprecated) Empty space around the outside of the texture. Button will show around the texture.
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	if 'frame_padding' in kwargs.keys():
		warnings.warn('frame_padding keyword deprecated. This is not supported anymore by ImGui but still used here as deprecated.', DeprecationWarning, 2)

	return internal_dpg.add_image_button(texture_tag, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, tint_color=tint_color, background_color=background_color, uv_min=uv_min, uv_max=uv_max, **kwargs)

def add_image_series(texture_tag : Union[int, str], bounds_min : Union[List[float], Tuple[float, ...]], bounds_max : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, uv_min: Union[List[float], Tuple[float, ...]] =(0.0, 0.0), uv_max: Union[List[float], Tuple[float, ...]] =(1.0, 1.0), tint_color: Union[List[int], Tuple[int, ...]] =(255, 255, 255, 255), **kwargs) -> Union[int, str]:
	"""	 Adds an image series to a plot.

	Args:
		texture_tag (Union[int, str]): 
		bounds_min (Any): 
		bounds_max (Any): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		uv_min (Union[List[float], Tuple[float, ...]], optional): normalized texture coordinates
		uv_max (Union[List[float], Tuple[float, ...]], optional): normalized texture coordinates
		tint_color (Union[List[int], Tuple[int, ...]], optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_image_series(texture_tag, bounds_min, bounds_max, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, uv_min=uv_min, uv_max=uv_max, tint_color=tint_color, **kwargs)

def add_inf_line_series(x : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, horizontal: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds an infinite line series to a plot.

	Args:
		x (Any): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		horizontal (bool, optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_inf_line_series(x, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, horizontal=horizontal, **kwargs)

def add_input_double(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: float =0.0, format: str ='%.3f', min_value: float =0.0, max_value: float =100.0, step: float =0.1, step_fast: float =1.0, min_clamped: bool =False, max_clamped: bool =False, on_enter: bool =False, readonly: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds input for an double. Useful when input float is not accurate enough. +/- buttons can be activated by setting the value of step.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (float, optional): 
		format (str, optional): Determines the format the float will be displayed as use python string formatting.
		min_value (float, optional): Value for lower limit of input. By default this limits the step buttons. Use min_clamped to limit manual input.
		max_value (float, optional): Value for upper limit of input. By default this limits the step buttons. Use max_clamped to limit manual input.
		step (float, optional): Increment to change value by when the step buttons are pressed. Setting this and step_fast to a value of 0 or less will turn off step buttons.
		step_fast (float, optional): Increment to change value by when ctrl + step buttons are pressed. Setting this and step to a value of 0 or less will turn off step buttons.
		min_clamped (bool, optional): Activates and deactivates the enforcment of min_value.
		max_clamped (bool, optional): Activates and deactivates the enforcment of max_value.
		on_enter (bool, optional): Only runs callback on enter key press.
		readonly (bool, optional): Activates read only mode where no text can be input but text can still be highlighted.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_input_double(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, format=format, min_value=min_value, max_value=max_value, step=step, step_fast=step_fast, min_clamped=min_clamped, max_clamped=max_clamped, on_enter=on_enter, readonly=readonly, **kwargs)

def add_input_doublex(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: Any =(0.0, 0.0, 0.0, 0.0), format: str ='%.3f', min_value: float =0.0, max_value: float =100.0, size: int =4, min_clamped: bool =False, max_clamped: bool =False, on_enter: bool =False, readonly: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds multi double input for up to 4 double values. Useful when input float mulit is not accurate enough.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (Any, optional): 
		format (str, optional): Determines the format the float will be displayed as use python string formatting.
		min_value (float, optional): Value for lower limit of input for each cell. Use min_clamped to turn on.
		max_value (float, optional): Value for upper limit of input for each cell. Use max_clamped to turn on.
		size (int, optional): Number of components displayed for input.
		min_clamped (bool, optional): Activates and deactivates the enforcment of min_value.
		max_clamped (bool, optional): Activates and deactivates the enforcment of max_value.
		on_enter (bool, optional): Only runs callback on enter key press.
		readonly (bool, optional): Activates read only mode where no text can be input but text can still be highlighted.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_input_doublex(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, format=format, min_value=min_value, max_value=max_value, size=size, min_clamped=min_clamped, max_clamped=max_clamped, on_enter=on_enter, readonly=readonly, **kwargs)

def add_input_float(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: float =0.0, format: str ='%.3f', min_value: float =0.0, max_value: float =100.0, step: float =0.1, step_fast: float =1.0, min_clamped: bool =False, max_clamped: bool =False, on_enter: bool =False, readonly: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds input for an float. +/- buttons can be activated by setting the value of step.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (float, optional): 
		format (str, optional): Determines the format the float will be displayed as use python string formatting.
		min_value (float, optional): Value for lower limit of input. By default this limits the step buttons. Use min_clamped to limit manual input.
		max_value (float, optional): Value for upper limit of input. By default this limits the step buttons. Use max_clamped to limit manual input.
		step (float, optional): Increment to change value by when the step buttons are pressed. Setting this and step_fast to a value of 0 or less will turn off step buttons.
		step_fast (float, optional): Increment to change value by when ctrl + step buttons are pressed. Setting this and step to a value of 0 or less will turn off step buttons.
		min_clamped (bool, optional): Activates and deactivates the enforcment of min_value.
		max_clamped (bool, optional): Activates and deactivates the enforcment of max_value.
		on_enter (bool, optional): Only runs callback on enter key press.
		readonly (bool, optional): Activates read only mode where no text can be input but text can still be highlighted.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_input_float(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, format=format, min_value=min_value, max_value=max_value, step=step, step_fast=step_fast, min_clamped=min_clamped, max_clamped=max_clamped, on_enter=on_enter, readonly=readonly, **kwargs)

def add_input_floatx(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: Union[List[float], Tuple[float, ...]] =(0.0, 0.0, 0.0, 0.0), format: str ='%.3f', min_value: float =0.0, max_value: float =100.0, size: int =4, min_clamped: bool =False, max_clamped: bool =False, on_enter: bool =False, readonly: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds multi float input for up to 4 float values.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (Union[List[float], Tuple[float, ...]], optional): 
		format (str, optional): Determines the format the float will be displayed as use python string formatting.
		min_value (float, optional): Value for lower limit of input for each cell. Use min_clamped to turn on.
		max_value (float, optional): Value for upper limit of input for each cell. Use max_clamped to turn on.
		size (int, optional): Number of components displayed for input.
		min_clamped (bool, optional): Activates and deactivates the enforcment of min_value.
		max_clamped (bool, optional): Activates and deactivates the enforcment of max_value.
		on_enter (bool, optional): Only runs callback on enter key press.
		readonly (bool, optional): Activates read only mode where no text can be input but text can still be highlighted.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_input_floatx(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, format=format, min_value=min_value, max_value=max_value, size=size, min_clamped=min_clamped, max_clamped=max_clamped, on_enter=on_enter, readonly=readonly, **kwargs)

def add_input_int(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: int =0, min_value: int =0, max_value: int =100, step: int =1, step_fast: int =100, min_clamped: bool =False, max_clamped: bool =False, on_enter: bool =False, readonly: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds input for an int. +/- buttons can be activated by setting the value of step.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (int, optional): 
		min_value (int, optional): Value for lower limit of input. By default this limits the step buttons. Use min_clamped to limit manual input.
		max_value (int, optional): Value for upper limit of input. By default this limits the step buttons. Use max_clamped to limit manual input.
		step (int, optional): Increment to change value by when the step buttons are pressed. Setting this and step_fast to a value of 0 or less will turn off step buttons.
		step_fast (int, optional): Increment to change value by when ctrl + step buttons are pressed. Setting this and step to a value of 0 or less will turn off step buttons.
		min_clamped (bool, optional): Activates and deactivates the enforcment of min_value.
		max_clamped (bool, optional): Activates and deactivates the enforcment of max_value.
		on_enter (bool, optional): Only runs callback on enter key press.
		readonly (bool, optional): Activates read only mode where no text can be input but text can still be highlighted.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_input_int(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, min_value=min_value, max_value=max_value, step=step, step_fast=step_fast, min_clamped=min_clamped, max_clamped=max_clamped, on_enter=on_enter, readonly=readonly, **kwargs)

def add_input_intx(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: Union[List[int], Tuple[int, ...]] =(0, 0, 0, 0), min_value: int =0, max_value: int =100, size: int =4, min_clamped: bool =False, max_clamped: bool =False, on_enter: bool =False, readonly: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds multi int input for up to 4 integer values.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (Union[List[int], Tuple[int, ...]], optional): 
		min_value (int, optional): Value for lower limit of input for each cell. Use min_clamped to turn on.
		max_value (int, optional): Value for upper limit of input for each cell. Use max_clamped to turn on.
		size (int, optional): Number of components displayed for input.
		min_clamped (bool, optional): Activates and deactivates the enforcment of min_value.
		max_clamped (bool, optional): Activates and deactivates the enforcment of max_value.
		on_enter (bool, optional): Only runs callback on enter.
		readonly (bool, optional): Activates read only mode where no text can be input but text can still be highlighted.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_input_intx(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, min_value=min_value, max_value=max_value, size=size, min_clamped=min_clamped, max_clamped=max_clamped, on_enter=on_enter, readonly=readonly, **kwargs)

def add_input_text(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: str ='', hint: str ='', multiline: bool =False, no_spaces: bool =False, uppercase: bool =False, tab_input: bool =False, decimal: bool =False, hexadecimal: bool =False, readonly: bool =False, password: bool =False, scientific: bool =False, on_enter: bool =False, auto_select_all: bool =False, ctrl_enter_for_new_line: bool =False, no_horizontal_scroll: bool =False, always_overwrite: bool =False, no_undo_redo: bool =False, escape_clears_all: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds input for text.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (str, optional): 
		hint (str, optional): Displayed only when value is an empty string. Will reappear if input value is set to empty string. Will not show if default value is anything other than default empty string.
		multiline (bool, optional): Allows for multiline text input.
		no_spaces (bool, optional): Filter out spaces and tabs.
		uppercase (bool, optional): Automatically make all inputs uppercase.
		tab_input (bool, optional): Allows tabs to be input into the string value instead of changing item focus.
		decimal (bool, optional): Only allow characters 0123456789.+-*/
		hexadecimal (bool, optional): Only allow characters 0123456789ABCDEFabcdef
		readonly (bool, optional): Activates read only mode where no text can be input but text can still be highlighted.
		password (bool, optional): Display all input characters as '*'.
		scientific (bool, optional): Only allow characters 0123456789.+-*/eE (Scientific notation input)
		on_enter (bool, optional): Only runs callback on enter key press.
		auto_select_all (bool, optional): Select entire text when first taking mouse focus
		ctrl_enter_for_new_line (bool, optional): In multi-line mode, unfocus with Enter, add new line with Ctrl+Enter (default is opposite: unfocus with Ctrl+Enter, add line with Enter).
		no_horizontal_scroll (bool, optional): Disable following the cursor horizontally
		always_overwrite (bool, optional): Overwrite mode
		no_undo_redo (bool, optional): Disable undo/redo.
		escape_clears_all (bool, optional): Escape key clears content if not empty, and deactivate otherwise (contrast to default behavior of Escape to revert)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_input_text(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, hint=hint, multiline=multiline, no_spaces=no_spaces, uppercase=uppercase, tab_input=tab_input, decimal=decimal, hexadecimal=hexadecimal, readonly=readonly, password=password, scientific=scientific, on_enter=on_enter, auto_select_all=auto_select_all, ctrl_enter_for_new_line=ctrl_enter_for_new_line, no_horizontal_scroll=no_horizontal_scroll, always_overwrite=always_overwrite, no_undo_redo=no_undo_redo, escape_clears_all=escape_clears_all, **kwargs)

def add_int4_value(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, source: Union[int, str] =0, default_value: Union[List[int], Tuple[int, ...]] =(0, 0, 0, 0), parent: Union[int, str] =internal_dpg.mvReservedUUID_3, **kwargs) -> Union[int, str]:
	"""	 Adds a int4 value.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		default_value (Union[List[int], Tuple[int, ...]], optional): 
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_int4_value(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, source=source, default_value=default_value, parent=parent, **kwargs)

def add_int_value(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, source: Union[int, str] =0, default_value: int =0, parent: Union[int, str] =internal_dpg.mvReservedUUID_3, **kwargs) -> Union[int, str]:
	"""	 Adds a int value.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		default_value (int, optional): 
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_int_value(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, source=source, default_value=default_value, parent=parent, **kwargs)

def add_item_activated_handler(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, callback: Callable =None, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a activated handler.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_item_activated_handler(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, callback=callback, show=show, **kwargs)

def add_item_active_handler(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, callback: Callable =None, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a active handler.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_item_active_handler(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, callback=callback, show=show, **kwargs)

def add_item_clicked_handler(button : int =-1, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, callback: Callable =None, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a clicked handler.

	Args:
		button (int, optional): Submits callback for all mouse buttons
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_item_clicked_handler(button, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, callback=callback, show=show, **kwargs)

def add_item_deactivated_after_edit_handler(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, callback: Callable =None, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a deactivated after edit handler.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_item_deactivated_after_edit_handler(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, callback=callback, show=show, **kwargs)

def add_item_deactivated_handler(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, callback: Callable =None, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a deactivated handler.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_item_deactivated_handler(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, callback=callback, show=show, **kwargs)

def add_item_double_clicked_handler(button : int =-1, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, callback: Callable =None, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a double click handler.

	Args:
		button (int, optional): Submits callback for all mouse buttons
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_item_double_clicked_handler(button, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, callback=callback, show=show, **kwargs)

def add_item_edited_handler(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, callback: Callable =None, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds an edited handler.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_item_edited_handler(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, callback=callback, show=show, **kwargs)

def add_item_focus_handler(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, callback: Callable =None, show: bool =True, event_type: int =None, **kwargs) -> Union[int, str]:
	"""	 Adds a focus handler.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		event_type (int, optional): What kind of events to track: just got focus (mvEventType_Enter), currently having focus (mvEventType_On), lost focus (mvEventType_Leave). Can be a combination of these flags. Defaults to mvEventType_On.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_item_focus_handler(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, callback=callback, show=show, event_type=event_type, **kwargs)

def add_item_handler_registry(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds an item handler registry.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_item_handler_registry(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, show=show, **kwargs)

def add_item_hover_handler(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, callback: Callable =None, show: bool =True, event_type: int =None, **kwargs) -> Union[int, str]:
	"""	 Adds a hover handler.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		event_type (int, optional): What kind of events to track: mouse-in (mvEventType_Enter), mouse-over (mvEventType_On), mouse-out (mvEventType_Leave). Can be a combination of these flags. Defaults to mouse-over.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_item_hover_handler(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, callback=callback, show=show, event_type=event_type, **kwargs)

def add_item_resize_handler(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, callback: Callable =None, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a resize handler.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_item_resize_handler(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, callback=callback, show=show, **kwargs)

def add_item_scroll_handler(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, callback: Callable =None, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a scroll handler.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_item_scroll_handler(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, callback=callback, show=show, **kwargs)

def add_item_toggled_open_handler(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, callback: Callable =None, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a togged open handler.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_item_toggled_open_handler(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, callback=callback, show=show, **kwargs)

def add_item_visible_handler(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, callback: Callable =None, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a visible handler.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_item_visible_handler(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, callback=callback, show=show, **kwargs)

def add_key_down_handler(key : int =internal_dpg.mvKey_None, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, callback: Callable =None, show: bool =True, parent: Union[int, str] =internal_dpg.mvReservedUUID_1, **kwargs) -> Union[int, str]:
	"""	 Adds a key down handler.

	Args:
		key (int, optional): Submits callback for all keys
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_key_down_handler(key, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, callback=callback, show=show, parent=parent, **kwargs)

def add_key_press_handler(key : int =internal_dpg.mvKey_None, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, callback: Callable =None, show: bool =True, parent: Union[int, str] =internal_dpg.mvReservedUUID_1, **kwargs) -> Union[int, str]:
	"""	 Adds a key press handler.

	Args:
		key (int, optional): Submits callback for all keys
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_key_press_handler(key, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, callback=callback, show=show, parent=parent, **kwargs)

def add_key_release_handler(key : int =internal_dpg.mvKey_None, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, callback: Callable =None, show: bool =True, parent: Union[int, str] =internal_dpg.mvReservedUUID_1, **kwargs) -> Union[int, str]:
	"""	 Adds a key release handler.

	Args:
		key (int, optional): Submits callback for all keys
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_key_release_handler(key, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, callback=callback, show=show, parent=parent, **kwargs)

def add_knob_float(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: float =0.0, min_value: float =0.0, max_value: float =100.0, **kwargs) -> Union[int, str]:
	"""	 Adds a knob that rotates based on change in x mouse position.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (float, optional): 
		min_value (float, optional): Applies lower limit to value.
		max_value (float, optional): Applies upper limit to value.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_knob_float(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, min_value=min_value, max_value=max_value, **kwargs)

def add_line_series(x : Union[List[float], Tuple[float, ...]], y : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, segments: bool =False, loop: bool =False, skip_nan: bool =False, no_clip: bool =False, shaded: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a line series to a plot.

	Args:
		x (Any): 
		y (Any): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		segments (bool, optional): a line segment will be rendered from every two consecutive points
		loop (bool, optional): the last and first point will be connected to form a closed loop
		skip_nan (bool, optional): NaNs values will be skipped instead of rendered as missing data
		no_clip (bool, optional): markers (if displayed) on the edge of a plot will not be clipped
		shaded (bool, optional): a filled region between the line and horizontal origin will be rendered; use add_shade_series for more advanced cases
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_line_series(x, y, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, segments=segments, loop=loop, skip_nan=skip_nan, no_clip=no_clip, shaded=shaded, **kwargs)

def add_listbox(items : Union[List[str], Tuple[str, ...]] =(), *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: str ='', num_items: int =3, **kwargs) -> Union[int, str]:
	"""	 Adds a listbox. If height is not large enough to show all items a scroll bar will appear.

	Args:
		items (Union[List[str], Tuple[str, ...]], optional): A tuple of items to be shown in the listbox. Can consist of any combination of types. All items will be displayed as strings.
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (str, optional): String value of the item that will be selected by default.
		num_items (int, optional): Expands the height of the listbox to show specified number of items.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_listbox(items, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, num_items=num_items, **kwargs)

def add_loading_indicator(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], style: int =0, circle_count: int =8, speed: float =1.0, radius: float =3.0, thickness: float =1.0, color: Union[List[int], Tuple[int, ...]] =(51, 51, 55, 255), secondary_color: Union[List[int], Tuple[int, ...]] =(29, 151, 236, 103), **kwargs) -> Union[int, str]:
	"""	 Adds a rotating animated loading symbol.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		style (int, optional): 0 is rotating dots style, 1 is rotating bar style.
		circle_count (int, optional): Number of dots show if dots or size of circle if circle.
		speed (float, optional): Speed the anamation will rotate.
		radius (float, optional): Radius size of the loading indicator.
		thickness (float, optional): Thickness of the circles or line.
		color (Union[List[int], Tuple[int, ...]], optional): Color of the growing center circle.
		secondary_color (Union[List[int], Tuple[int, ...]], optional): Background of the dots in dot mode.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_loading_indicator(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, payload_type=payload_type, drop_callback=drop_callback, show=show, pos=pos, style=style, circle_count=circle_count, speed=speed, radius=radius, thickness=thickness, color=color, secondary_color=secondary_color, **kwargs)

def add_menu(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drop_callback: Callable =None, show: bool =True, enabled: bool =True, filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, **kwargs) -> Union[int, str]:
	"""	 Adds a menu to an existing menu bar.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_menu(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, payload_type=payload_type, drop_callback=drop_callback, show=show, enabled=enabled, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, **kwargs)

def add_menu_bar(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, show: bool =True, delay_search: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a menu bar to a window.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		show (bool, optional): Attempt to render widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_menu_bar(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, show=show, delay_search=delay_search, **kwargs)

def add_menu_item(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: bool =False, shortcut: str ='', check: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a menu item to an existing menu. Menu items act similar to selectables and has a bool value. When placed in a menu the checkmark will reflect its value.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (bool, optional): This value also controls the checkmark when shown.
		shortcut (str, optional): Displays text on the menu item. Typically used to show a shortcut key command.
		check (bool, optional): Displays a checkmark on the menu item when it is selected and placed in a menu.
		id (Union[int, str], optional): (deprecated) 
		drag_callback (Callable, optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	if 'drag_callback' in kwargs.keys():

		warnings.warn('drag_callback keyword removed', DeprecationWarning, 2)

		kwargs.pop('drag_callback', None)

	return internal_dpg.add_menu_item(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, payload_type=payload_type, callback=callback, drop_callback=drop_callback, show=show, enabled=enabled, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, shortcut=shortcut, check=check, **kwargs)

def add_mouse_click_handler(button : int =-1, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, callback: Callable =None, show: bool =True, parent: Union[int, str] =internal_dpg.mvReservedUUID_1, **kwargs) -> Union[int, str]:
	"""	 Adds a mouse click handler.

	Args:
		button (int, optional): Submits callback for all mouse buttons
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_mouse_click_handler(button, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, callback=callback, show=show, parent=parent, **kwargs)

def add_mouse_double_click_handler(button : int =-1, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, callback: Callable =None, show: bool =True, parent: Union[int, str] =internal_dpg.mvReservedUUID_1, **kwargs) -> Union[int, str]:
	"""	 Adds a mouse double click handler.

	Args:
		button (int, optional): Submits callback for all mouse buttons
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_mouse_double_click_handler(button, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, callback=callback, show=show, parent=parent, **kwargs)

def add_mouse_down_handler(button : int =-1, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, callback: Callable =None, show: bool =True, parent: Union[int, str] =internal_dpg.mvReservedUUID_1, **kwargs) -> Union[int, str]:
	"""	 Adds a mouse down handler.

	Args:
		button (int, optional): Submits callback for all mouse buttons
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_mouse_down_handler(button, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, callback=callback, show=show, parent=parent, **kwargs)

def add_mouse_drag_handler(button : int =-1, threshold : float =10.0, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, callback: Callable =None, show: bool =True, parent: Union[int, str] =internal_dpg.mvReservedUUID_1, **kwargs) -> Union[int, str]:
	"""	 Adds a mouse drag handler.

	Args:
		button (int, optional): Submits callback for all mouse buttons
		threshold (float, optional): The threshold the mouse must be dragged before the callback is ran
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_mouse_drag_handler(button, threshold, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, callback=callback, show=show, parent=parent, **kwargs)

def add_mouse_move_handler(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, callback: Callable =None, show: bool =True, parent: Union[int, str] =internal_dpg.mvReservedUUID_1, **kwargs) -> Union[int, str]:
	"""	 Adds a mouse move handler.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_mouse_move_handler(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, callback=callback, show=show, parent=parent, **kwargs)

def add_mouse_release_handler(button : int =-1, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, callback: Callable =None, show: bool =True, parent: Union[int, str] =internal_dpg.mvReservedUUID_1, **kwargs) -> Union[int, str]:
	"""	 Adds a mouse release handler.

	Args:
		button (int, optional): Submits callback for all mouse buttons
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_mouse_release_handler(button, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, callback=callback, show=show, parent=parent, **kwargs)

def add_mouse_wheel_handler(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, callback: Callable =None, show: bool =True, parent: Union[int, str] =internal_dpg.mvReservedUUID_1, **kwargs) -> Union[int, str]:
	"""	 Adds a mouse wheel handler.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_mouse_wheel_handler(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, callback=callback, show=show, parent=parent, **kwargs)

def add_node(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, draggable: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a node to a node editor.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		draggable (bool, optional): Allow node to be draggable.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_node(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, payload_type=payload_type, drag_callback=drag_callback, drop_callback=drop_callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, draggable=draggable, **kwargs)

def add_node_attribute(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, filter_key: str ='', tracked: bool =False, track_offset: float =0.5, attribute_type: int =0, shape: int =1, category: str ='general', **kwargs) -> Union[int, str]:
	"""	 Adds a node attribute to a node.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		attribute_type (int, optional): mvNode_Attr_Input, mvNode_Attr_Output, or mvNode_Attr_Static.
		shape (int, optional): Pin shape.
		category (str, optional): Category
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_node_attribute(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, show=show, filter_key=filter_key, tracked=tracked, track_offset=track_offset, attribute_type=attribute_type, shape=shape, category=category, **kwargs)

def add_node_editor(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, parent: Union[int, str] =0, before: Union[int, str] =0, callback: Callable =None, show: bool =True, filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, delink_callback: Callable =None, menubar: bool =False, minimap: bool =False, minimap_location: int =2, **kwargs) -> Union[int, str]:
	"""	 Adds a node editor.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		delink_callback (Callable, optional): Callback ran when a link is detached.
		menubar (bool, optional): Shows or hides the menubar.
		minimap (bool, optional): Shows or hides the Minimap. New in 1.6.
		minimap_location (int, optional): mvNodeMiniMap_Location_* constants. New in 1.6.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_node_editor(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, parent=parent, before=before, callback=callback, show=show, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, delink_callback=delink_callback, menubar=menubar, minimap=minimap, minimap_location=minimap_location, **kwargs)

def add_node_link(attr_1 : Union[int, str], attr_2 : Union[int, str], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, show: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a node link between 2 node attributes.

	Args:
		attr_1 (Union[int, str]): 
		attr_2 (Union[int, str]): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_node_link(attr_1, attr_2, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, show=show, **kwargs)

def add_pie_series(x : float, y : float, radius : float, values : Union[List[float], Tuple[float, ...]], labels : Union[List[str], Tuple[str, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, format: str ='%0.2f', angle: float =90.0, normalize: bool =False, ignore_hidden: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds an pie series to a plot.

	Args:
		x (float): 
		y (float): 
		radius (float): 
		values (Any): 
		labels (Union[List[str], Tuple[str, ...]]): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		format (str, optional): 
		angle (float, optional): 
		normalize (bool, optional): force normalization of pie chart values (i.e. always make a full circle if sum < 0)
		ignore_hidden (bool, optional): ignore hidden slices when drawing the pie chart (as if they were not there)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_pie_series(x, y, radius, values, labels, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, format=format, angle=angle, normalize=normalize, ignore_hidden=ignore_hidden, **kwargs)

def add_plot(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, no_title: bool =False, no_menus: bool =False, no_box_select: bool =False, no_mouse_pos: bool =False, query: bool =False, query_color: Union[List[float], Tuple[float, ...]] =(0, 255, 0, 255), min_query_rects: int =1, max_query_rects: int =1, crosshairs: bool =False, equal_aspects: bool =False, no_inputs: bool =False, no_frame: bool =False, use_local_time: bool =False, use_ISO8601: bool =False, use_24hour_clock: bool =False, pan_button: int =internal_dpg.mvMouseButton_Left, pan_mod: int =internal_dpg.mvKey_None, context_menu_button: int =internal_dpg.mvMouseButton_Right, fit_button: int =internal_dpg.mvMouseButton_Left, box_select_button: int =internal_dpg.mvMouseButton_Right, box_select_mod: int =internal_dpg.mvKey_None, box_select_cancel_button: int =internal_dpg.mvMouseButton_Left, query_toggle_mod: int =internal_dpg.mvKey_ModCtrl, horizontal_mod: int =internal_dpg.mvKey_ModAlt, vertical_mod: int =internal_dpg.mvKey_ModShift, override_mod: int =internal_dpg.mvKey_ModCtrl, zoom_mod: int =internal_dpg.mvKey_None, zoom_rate: int =0.1, **kwargs) -> Union[int, str]:
	"""	 Adds a plot which is used to hold series, and can be drawn to with draw commands. For all _mod parameters use mvKey_ModX enums, or mvKey_ModDisabled to disable the modifier.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		no_title (bool, optional): the plot title will not be displayed
		no_menus (bool, optional): the user will not be able to open context menus with right-click
		no_box_select (bool, optional): the user will not be able to box-select with right-click drag
		no_mouse_pos (bool, optional): the text of mouse position, in plot coordinates, will not be displayed inside of the plot
		query (bool, optional): the user will be able to draw query rects with CTRL + right-click drag
		query_color (Union[List[float], Tuple[float, ...]], optional): Color of the query rectangles.
		min_query_rects (int, optional): The minimum number of query rects that can be in the plot. If there are less rects than this value, it won't be possible to delete them.
		max_query_rects (int, optional): The maximum number of query rects that can be in the plot. If the number is reached any rect added will replace the latest one. (0 means unlimited)
		crosshairs (bool, optional): the default mouse cursor will be replaced with a crosshair when hovered
		equal_aspects (bool, optional): primary x and y axes will be constrained to have the same units/pixel (does not apply to auxiliary y-axes)
		no_inputs (bool, optional): the user will not be able to interact with the plot
		no_frame (bool, optional): the ImGui frame will not be rendered
		use_local_time (bool, optional): axis labels will be formatted for your timezone when
		use_ISO8601 (bool, optional): dates will be formatted according to ISO 8601 where applicable (e.g. YYYY-MM-DD, YYYY-MM, --MM-DD, etc.)
		use_24hour_clock (bool, optional): times will be formatted using a 24 hour clock
		pan_button (int, optional): mouse button that enables panning when held
		pan_mod (int, optional): optional modifier that must be held for panning
		context_menu_button (int, optional): opens context menus (if enabled) when clicked
		fit_button (int, optional): fits visible data when double clicked
		box_select_button (int, optional): begins box selection when pressed and confirms selection when released
		box_select_mod (int, optional): begins box selection when pressed and confirms selection when released
		box_select_cancel_button (int, optional): cancels active box selection when pressed
		query_toggle_mod (int, optional): when held, active box selections turn into queries
		horizontal_mod (int, optional): expands active box selection/query horizontally to plot edge when held
		vertical_mod (int, optional): expands active box selection/query vertically to plot edge when held
		override_mod (int, optional): when held, all input is ignored; used to enable axis/plots as DND sources
		zoom_mod (int, optional): optional modifier that must be held for scroll wheel zooming
		zoom_rate (int, optional): zoom rate for scroll (e.g. 0.1f = 10% plot range every scroll click); make negative to invert
		id (Union[int, str], optional): (deprecated) 
		no_highlight (bool, optional): (deprecated) Removed because not supported from the backend anymore. To control the highlighting of series use the same argument in `add_plot_legend`
		no_child (bool, optional): (deprecated) a child window region will not be used to capture mouse scroll (can boost performance for single ImGui window applications)
		anti_aliased (bool, optional): (deprecated) This feature was deprecated in ImPlot. To enable/disable anti_aliasing use `dpg.configure_app()` with the `anti_aliasing` parameters.
		query_button (int, optional): (deprecated) This refers to the old way of querying of ImPlot, now replaced with `DragRect()`
		query_mod (int, optional): (deprecated) This refers to the old way of querying of ImPlot, now replaced with `DragRect()`
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	if 'no_highlight' in kwargs.keys():

		warnings.warn('no_highlight keyword removed', DeprecationWarning, 2)

		kwargs.pop('no_highlight', None)

	if 'no_child' in kwargs.keys():

		warnings.warn('no_child keyword removed', DeprecationWarning, 2)

		kwargs.pop('no_child', None)

	if 'anti_aliased' in kwargs.keys():

		warnings.warn('anti_aliased keyword removed', DeprecationWarning, 2)

		kwargs.pop('anti_aliased', None)

	if 'query_button' in kwargs.keys():

		warnings.warn('query_button keyword removed', DeprecationWarning, 2)

		kwargs.pop('query_button', None)

	if 'query_mod' in kwargs.keys():

		warnings.warn('query_mod keyword removed', DeprecationWarning, 2)

		kwargs.pop('query_mod', None)

	return internal_dpg.add_plot(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, no_title=no_title, no_menus=no_menus, no_box_select=no_box_select, no_mouse_pos=no_mouse_pos, query=query, query_color=query_color, min_query_rects=min_query_rects, max_query_rects=max_query_rects, crosshairs=crosshairs, equal_aspects=equal_aspects, no_inputs=no_inputs, no_frame=no_frame, use_local_time=use_local_time, use_ISO8601=use_ISO8601, use_24hour_clock=use_24hour_clock, pan_button=pan_button, pan_mod=pan_mod, context_menu_button=context_menu_button, fit_button=fit_button, box_select_button=box_select_button, box_select_mod=box_select_mod, box_select_cancel_button=box_select_cancel_button, query_toggle_mod=query_toggle_mod, horizontal_mod=horizontal_mod, vertical_mod=vertical_mod, override_mod=override_mod, zoom_mod=zoom_mod, zoom_rate=zoom_rate, **kwargs)

def add_plot_annotation(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, default_value: Any =(0.0, 0.0), offset: Union[List[float], Tuple[float, ...]] =(0.0, 0.0), color: Union[List[int], Tuple[int, ...]] =(0, 0, 0, -255), clamped: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds an annotation to a plot.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		default_value (Any, optional): 
		offset (Union[List[float], Tuple[float, ...]], optional): 
		color (Union[List[int], Tuple[int, ...]], optional): 
		clamped (bool, optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_plot_annotation(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, default_value=default_value, offset=offset, color=color, clamped=clamped, **kwargs)

def add_plot_axis(axis : int, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drop_callback: Callable =None, show: bool =True, no_label: bool =False, no_gridlines: bool =False, no_tick_marks: bool =False, no_tick_labels: bool =False, no_initial_fit: bool =False, no_menus: bool =False, no_side_switch: bool =False, no_highlight: bool =False, opposite: bool =False, foreground_grid: bool =False, tick_format: str ='', scale: int =internal_dpg.mvPlotScale_Linear, invert: bool =False, auto_fit: bool =False, range_fit: bool =False, pan_stretch: bool =False, lock_min: bool =False, lock_max: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds an axis to a plot.

	Args:
		axis (int): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		no_label (bool, optional): the axis label will not be displayed
		no_gridlines (bool, optional): no grid lines will be displayed
		no_tick_marks (bool, optional): no tick marks will be displayed
		no_tick_labels (bool, optional): no text labels will be displayed
		no_initial_fit (bool, optional): axis will not be initially fit to data extents on the first rendered frame
		no_menus (bool, optional): the user will not be able to open context menus with right-click
		no_side_switch (bool, optional): the user will not be able to switch the axis side by dragging it
		no_highlight (bool, optional): the axis will not have its background highlighted when hovered or held
		opposite (bool, optional): axis ticks and labels will be rendered on the conventionally opposite side (i.e, right or top)
		foreground_grid (bool, optional): grid lines will be displayed in the foreground (i.e. on top of data) instead of the background
		tick_format (str, optional): Sets a custom tick label formatter
		scale (int, optional): Sets the axis' scale. Can have only mvPlotScale_ values
		invert (bool, optional): the axis values will be inverted (i.e. growing from right to left)
		auto_fit (bool, optional): axis will be auto-fitting to data extents
		range_fit (bool, optional): axis will only fit points if the point is in the visible range of the **orthogonal** axis
		pan_stretch (bool, optional): panning in a locked or constrained state will cause the axis to stretch if possible
		lock_min (bool, optional): the axis minimum value will be locked when panning/zooming
		lock_max (bool, optional): the axis maximum value will be locked when panning/zooming
		id (Union[int, str], optional): (deprecated) 
		log_scale (bool, optional): (deprecated) Old way to set log scale in the axis. Use 'scale' argument instead.
		time (bool, optional): (deprecated) Old way to set time scale in the axis. Use 'scale' argument instead.
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	if 'log_scale' in kwargs.keys():
		warnings.warn('log_scale keyword deprecated. See the new scale argument.', DeprecationWarning, 2)

	if 'time' in kwargs.keys():
		warnings.warn('time keyword deprecated. See the new scale argument.', DeprecationWarning, 2)

	return internal_dpg.add_plot_axis(axis, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, payload_type=payload_type, drop_callback=drop_callback, show=show, no_label=no_label, no_gridlines=no_gridlines, no_tick_marks=no_tick_marks, no_tick_labels=no_tick_labels, no_initial_fit=no_initial_fit, no_menus=no_menus, no_side_switch=no_side_switch, no_highlight=no_highlight, opposite=opposite, foreground_grid=foreground_grid, tick_format=tick_format, scale=scale, invert=invert, auto_fit=auto_fit, range_fit=range_fit, pan_stretch=pan_stretch, lock_min=lock_min, lock_max=lock_max, **kwargs)

def add_plot_legend(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drop_callback: Callable =None, show: bool =True, location: int =5, horizontal: bool =False, sort: bool =False, outside: bool =False, no_highlight_item: bool =False, no_highlight_axis: bool =False, no_menus: bool =False, no_buttons: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a plot legend to a plot.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		location (int, optional): location, mvPlot_Location_*
		horizontal (bool, optional): legend entries will be displayed horizontally
		sort (bool, optional): legend entries will be displayed in alphabetical order
		outside (bool, optional): legend will be rendered outside of the plot area
		no_highlight_item (bool, optional): plot items will not be highlighted when their legend entry is hovered
		no_highlight_axis (bool, optional): axes will not be highlighted when legend entries are hovered (only relevant if x/y-axis count > 1)
		no_menus (bool, optional): the user will not be able to open context menus with right-click
		no_buttons (bool, optional): legend icons will not function as hide/show buttons
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_plot_legend(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, payload_type=payload_type, drop_callback=drop_callback, show=show, location=location, horizontal=horizontal, sort=sort, outside=outside, no_highlight_item=no_highlight_item, no_highlight_axis=no_highlight_axis, no_menus=no_menus, no_buttons=no_buttons, **kwargs)

def add_progress_bar(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, overlay: str ='', default_value: float =0.0, **kwargs) -> Union[int, str]:
	"""	 Adds a progress bar.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		overlay (str, optional): Overlayed text onto the bar that typically used to display the value of the progress.
		default_value (float, optional): Normalized value to fill the bar from 0.0 to 1.0. Put a negative value to show an indeterminate progress bar.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_progress_bar(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, drag_callback=drag_callback, drop_callback=drop_callback, show=show, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, overlay=overlay, default_value=default_value, **kwargs)

def add_radio_button(items : Union[List[str], Tuple[str, ...]] =(), *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: str ='', horizontal: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a set of radio buttons. If items keyword is empty, nothing will be shown.

	Args:
		items (Union[List[str], Tuple[str, ...]], optional): A tuple of items to be shown as radio options. Can consist of any combination of types. All types will be shown as strings.
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (str, optional): Default selected radio option. Set by using the string value of the item.
		horizontal (bool, optional): Displays the radio options horizontally.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_radio_button(items, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, horizontal=horizontal, **kwargs)

def add_raw_texture(width : int, height : int, default_value : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, format: int =internal_dpg.mvFormat_Float_rgba, parent: Union[int, str] =internal_dpg.mvReservedUUID_2, **kwargs) -> Union[int, str]:
	"""	 Adds a raw texture.

	Args:
		width (int): 
		height (int): 
		default_value (Union[List[float], Tuple[float, ...]]): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		format (int, optional): Data format.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_raw_texture(width, height, default_value, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, format=format, parent=parent, **kwargs)

def add_scatter_series(x : Union[List[float], Tuple[float, ...]], y : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, no_clip: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a scatter series to a plot.

	Args:
		x (Any): 
		y (Any): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		no_clip (bool, optional): markers on the edge of a plot will not be clipped
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_scatter_series(x, y, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, no_clip=no_clip, **kwargs)

def add_selectable(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: bool =False, span_columns: bool =False, disable_popup_close: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a selectable. Similar to a button but can indicate its selected state.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (bool, optional): 
		span_columns (bool, optional): Forces the selectable to span the width of all columns if placed in a table.
		disable_popup_close (bool, optional): Disable closing a modal or popup window.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_selectable(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, span_columns=span_columns, disable_popup_close=disable_popup_close, **kwargs)

def add_separator(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], **kwargs) -> Union[int, str]:
	"""	 Adds a horizontal line separator. Use 'label' parameter to add text and mvStyleVar_SeparatorText* elements to style it.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_separator(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, show=show, pos=pos, **kwargs)

def add_series_value(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, source: Union[int, str] =0, default_value: Any =(), parent: Union[int, str] =internal_dpg.mvReservedUUID_3, **kwargs) -> Union[int, str]:
	"""	 Adds a plot series value.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		default_value (Any, optional): 
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_series_value(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, source=source, default_value=default_value, parent=parent, **kwargs)

def add_shade_series(x : Union[List[float], Tuple[float, ...]], y1 : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, y2: Any =[], **kwargs) -> Union[int, str]:
	"""	 Adds a shade series to a plot.

	Args:
		x (Any): 
		y1 (Any): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		y2 (Any, optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_shade_series(x, y1, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, y2=y2, **kwargs)

def add_simple_plot(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: Union[List[float], Tuple[float, ...]] =(), overlay: str ='', histogram: bool =False, autosize: bool =True, min_scale: float =0.0, max_scale: float =0.0, **kwargs) -> Union[int, str]:
	"""	 Adds a simple plot for visualization of a 1 dimensional set of values.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (Union[List[float], Tuple[float, ...]], optional): 
		overlay (str, optional): overlays text (similar to a plot title)
		histogram (bool, optional): 
		autosize (bool, optional): 
		min_scale (float, optional): 
		max_scale (float, optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_simple_plot(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, drag_callback=drag_callback, drop_callback=drop_callback, show=show, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, overlay=overlay, histogram=histogram, autosize=autosize, min_scale=min_scale, max_scale=max_scale, **kwargs)

def add_slider_double(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: float =0.0, vertical: bool =False, no_input: bool =False, clamped: bool =False, min_value: float =0.0, max_value: float =100.0, format: str ='%.3f', **kwargs) -> Union[int, str]:
	"""	 Adds slider for a single double value. Useful when slider float is not accurate enough. Directly entry can be done with double click or CTRL+Click. Min and Max alone are a soft limit for the slider. Use clamped keyword to also apply limits to the direct entry modes.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (float, optional): 
		vertical (bool, optional): Sets orientation of the slidebar and slider to vertical.
		no_input (bool, optional): Disable direct entry methods double-click or ctrl+click or Enter key allowing to input text directly into the item.
		clamped (bool, optional): Applies the min and max limits to direct entry methods also such as double click and CTRL+Click.
		min_value (float, optional): Applies a limit only to sliding entry only.
		max_value (float, optional): Applies a limit only to sliding entry only.
		format (str, optional): Determines the format the float will be displayed as use python string formatting.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_slider_double(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, vertical=vertical, no_input=no_input, clamped=clamped, min_value=min_value, max_value=max_value, format=format, **kwargs)

def add_slider_doublex(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: Any =(0.0, 0.0, 0.0, 0.0), size: int =4, no_input: bool =False, clamped: bool =False, min_value: float =0.0, max_value: float =100.0, format: str ='%.3f', **kwargs) -> Union[int, str]:
	"""	 Adds multi slider for up to 4 double values. Usueful for when multi slide float is not accurate enough. Directly entry can be done with double click or CTRL+Click. Min and Max alone are a soft limit for the slider. Use clamped keyword to also apply limits to the direct entry modes.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (Any, optional): 
		size (int, optional): Number of doubles to be displayed.
		no_input (bool, optional): Disable direct entry methods double-click or ctrl+click or Enter key allowing to input text directly into the item.
		clamped (bool, optional): Applies the min and max limits to direct entry methods also such as double click and CTRL+Click.
		min_value (float, optional): Applies a limit only to sliding entry only.
		max_value (float, optional): Applies a limit only to sliding entry only.
		format (str, optional): Determines the format the int will be displayed as use python string formatting.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_slider_doublex(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, size=size, no_input=no_input, clamped=clamped, min_value=min_value, max_value=max_value, format=format, **kwargs)

def add_slider_float(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: float =0.0, vertical: bool =False, no_input: bool =False, clamped: bool =False, min_value: float =0.0, max_value: float =100.0, format: str ='%.3f', **kwargs) -> Union[int, str]:
	"""	 Adds slider for a single float value. Directly entry can be done with double click or CTRL+Click. Min and Max alone are a soft limit for the slider. Use clamped keyword to also apply limits to the direct entry modes.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (float, optional): 
		vertical (bool, optional): Sets orientation of the slidebar and slider to vertical.
		no_input (bool, optional): Disable direct entry methods double-click or ctrl+click or Enter key allowing to input text directly into the item.
		clamped (bool, optional): Applies the min and max limits to direct entry methods also such as double click and CTRL+Click.
		min_value (float, optional): Applies a limit only to sliding entry only.
		max_value (float, optional): Applies a limit only to sliding entry only.
		format (str, optional): Determines the format the float will be displayed as use python string formatting.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_slider_float(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, vertical=vertical, no_input=no_input, clamped=clamped, min_value=min_value, max_value=max_value, format=format, **kwargs)

def add_slider_floatx(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: Union[List[float], Tuple[float, ...]] =(0.0, 0.0, 0.0, 0.0), size: int =4, no_input: bool =False, clamped: bool =False, min_value: float =0.0, max_value: float =100.0, format: str ='%.3f', **kwargs) -> Union[int, str]:
	"""	 Adds multi slider for up to 4 float values. Directly entry can be done with double click or CTRL+Click. Min and Max alone are a soft limit for the slider. Use clamped keyword to also apply limits to the direct entry modes.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (Union[List[float], Tuple[float, ...]], optional): 
		size (int, optional): Number of floats to be displayed.
		no_input (bool, optional): Disable direct entry methods double-click or ctrl+click or Enter key allowing to input text directly into the item.
		clamped (bool, optional): Applies the min and max limits to direct entry methods also such as double click and CTRL+Click.
		min_value (float, optional): Applies a limit only to sliding entry only.
		max_value (float, optional): Applies a limit only to sliding entry only.
		format (str, optional): Determines the format the int will be displayed as use python string formatting.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_slider_floatx(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, size=size, no_input=no_input, clamped=clamped, min_value=min_value, max_value=max_value, format=format, **kwargs)

def add_slider_int(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: int =0, vertical: bool =False, no_input: bool =False, clamped: bool =False, min_value: int =0, max_value: int =100, format: str ='%d', **kwargs) -> Union[int, str]:
	"""	 Adds slider for a single int value. Directly entry can be done with double click or CTRL+Click. Min and Max alone are a soft limit for the slider. Use clamped keyword to also apply limits to the direct entry modes.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (int, optional): 
		vertical (bool, optional): Sets orientation of the slidebar and slider to vertical.
		no_input (bool, optional): Disable direct entry methods double-click or ctrl+click or Enter key allowing to input text directly into the item.
		clamped (bool, optional): Applies the min and max limits to direct entry methods also such as double click and CTRL+Click.
		min_value (int, optional): Applies a limit only to sliding entry only.
		max_value (int, optional): Applies a limit only to sliding entry only.
		format (str, optional): Determines the format the int will be displayed as use python string formatting.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_slider_int(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, vertical=vertical, no_input=no_input, clamped=clamped, min_value=min_value, max_value=max_value, format=format, **kwargs)

def add_slider_intx(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, enabled: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: Union[List[int], Tuple[int, ...]] =(0, 0, 0, 0), size: int =4, no_input: bool =False, clamped: bool =False, min_value: int =0, max_value: int =100, format: str ='%d', **kwargs) -> Union[int, str]:
	"""	 Adds multi slider for up to 4 int values. Directly entry can be done with double click or CTRL+Click. Min and Max alone are a soft limit for the slider. Use clamped keyword to also apply limits to the direct entry modes.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (Union[List[int], Tuple[int, ...]], optional): 
		size (int, optional): Number of ints to be displayed.
		no_input (bool, optional): Disable direct entry methods double-click or ctrl+click or Enter key allowing to input text directly into the item.
		clamped (bool, optional): Applies the min and max limits to direct entry methods also such as double click and CTRL+Click.
		min_value (int, optional): Applies a limit only to sliding entry only.
		max_value (int, optional): Applies a limit only to sliding entry only.
		format (str, optional): Determines the format the int will be displayed as use python string formatting.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_slider_intx(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, enabled=enabled, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, size=size, no_input=no_input, clamped=clamped, min_value=min_value, max_value=max_value, format=format, **kwargs)

def add_spacer(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], **kwargs) -> Union[int, str]:
	"""	 Adds a spacer item that can be used to help with layouts or can be used as a placeholder item.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_spacer(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, show=show, pos=pos, **kwargs)

def add_stage(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, **kwargs) -> Union[int, str]:
	"""	 Adds a stage.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_stage(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, **kwargs)

def add_stair_series(x : Union[List[float], Tuple[float, ...]], y : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, pre_step: bool =False, shaded: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a stair series to a plot.

	Args:
		x (Any): 
		y (Any): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		pre_step (bool, optional): the y value is continued constantly to the left from every x position, i.e. the interval (x[i-1], x[i]] has the value y[i]
		shaded (bool, optional): a filled region between the line and horizontal origin will be rendered; use add_shade_series for more advanced cases
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_stair_series(x, y, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, pre_step=pre_step, shaded=shaded, **kwargs)

def add_static_texture(width : int, height : int, default_value : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =internal_dpg.mvReservedUUID_2, **kwargs) -> Union[int, str]:
	"""	 Adds a static texture.

	Args:
		width (int): 
		height (int): 
		default_value (Union[List[float], Tuple[float, ...]]): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_static_texture(width, height, default_value, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, **kwargs)

def add_stem_series(x : Union[List[float], Tuple[float, ...]], y : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, horizontal: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a stem series to a plot.

	Args:
		x (Any): 
		y (Any): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		horizontal (bool, optional): stems will be rendered horizontally on the current y-axis
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_stem_series(x, y, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, source=source, show=show, horizontal=horizontal, **kwargs)

def add_string_value(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, source: Union[int, str] =0, default_value: str ='', parent: Union[int, str] =internal_dpg.mvReservedUUID_3, **kwargs) -> Union[int, str]:
	"""	 Adds a string value.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		default_value (str, optional): 
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_string_value(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, source=source, default_value=default_value, parent=parent, **kwargs)

def add_subplots(rows : int, columns : int, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, row_ratios: Union[List[float], Tuple[float, ...]] =[], column_ratios: Union[List[float], Tuple[float, ...]] =[], no_title: bool =False, no_menus: bool =False, no_resize: bool =False, no_align: bool =False, share_series: bool =False, link_rows: bool =False, link_columns: bool =False, link_all_x: bool =False, link_all_y: bool =False, column_major: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a collection of plots.

	Args:
		rows (int): 
		columns (int): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		row_ratios (Union[List[float], Tuple[float, ...]], optional): 
		column_ratios (Union[List[float], Tuple[float, ...]], optional): 
		no_title (bool, optional): the subplot title will not be displayed
		no_menus (bool, optional): the user will not be able to open context menus with right-click
		no_resize (bool, optional): resize splitters between subplot cells will be not be provided
		no_align (bool, optional): subplot edges will not be aligned vertically or horizontally
		share_series (bool, optional): when set to True, series from all sub-plots will be shared to some extent, using a single common color set and showing them in a single legend in the subplots item. Otherwise each plot will be independent from others and will have its own legend
		link_rows (bool, optional): link the y-axis limits of all plots in each row (does not apply auxiliary y-axes)
		link_columns (bool, optional): link the x-axis limits of all plots in each column
		link_all_x (bool, optional): link the x-axis limits in every plot in the subplot
		link_all_y (bool, optional): link the y-axis limits in every plot in the subplot (does not apply to auxiliary y-axes)
		column_major (bool, optional): subplots are added in column major order instead of the default row major order
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_subplots(rows, columns, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, callback=callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, row_ratios=row_ratios, column_ratios=column_ratios, no_title=no_title, no_menus=no_menus, no_resize=no_resize, no_align=no_align, share_series=share_series, link_rows=link_rows, link_columns=link_columns, link_all_x=link_all_x, link_all_y=link_all_y, column_major=column_major, **kwargs)

def add_tab(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drop_callback: Callable =None, show: bool =True, filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, closable: bool =False, no_tooltip: bool =False, order_mode: int =0, **kwargs) -> Union[int, str]:
	"""	 Adds a tab to a tab bar.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		closable (bool, optional): Creates a button on the tab that can hide the tab.
		no_tooltip (bool, optional): Disable tooltip for the given tab.
		order_mode (int, optional): set using a constant: mvTabOrder_Reorderable: allows reordering, mvTabOrder_Fixed: fixed ordering, mvTabOrder_Leading: adds tab to front, mvTabOrder_Trailing: adds tab to back
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_tab(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, payload_type=payload_type, drop_callback=drop_callback, show=show, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, closable=closable, no_tooltip=no_tooltip, order_mode=order_mode, **kwargs)

def add_tab_bar(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, reorderable: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a tab bar.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		reorderable (bool, optional): Allows for the user to change the order of the tabs.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_tab_bar(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, callback=callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, reorderable=reorderable, **kwargs)

def add_tab_button(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, filter_key: str ='', tracked: bool =False, track_offset: float =0.5, no_reorder: bool =False, leading: bool =False, trailing: bool =False, no_tooltip: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a tab button to a tab bar.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		no_reorder (bool, optional): Disable reordering this tab or having another tab cross over this tab. Fixes the position of this tab in relation to the order of neighboring tabs at start. 
		leading (bool, optional): Enforce the tab position to the left of the tab bar (after the tab list popup button).
		trailing (bool, optional): Enforce the tab position to the right of the tab bar (before the scrolling buttons).
		no_tooltip (bool, optional): Disable tooltip for the given tab.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_tab_button(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, filter_key=filter_key, tracked=tracked, track_offset=track_offset, no_reorder=no_reorder, leading=leading, trailing=trailing, no_tooltip=no_tooltip, **kwargs)

def add_table(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, header_row: bool =True, clipper: bool =False, inner_width: int =0, policy: int =0, freeze_rows: int =0, freeze_columns: int =0, sort_multi: bool =False, sort_tristate: bool =False, resizable: bool =False, reorderable: bool =False, hideable: bool =False, sortable: bool =False, context_menu_in_body: bool =False, row_background: bool =False, borders_innerH: bool =False, borders_outerH: bool =False, borders_innerV: bool =False, borders_outerV: bool =False, no_host_extendX: bool =False, no_host_extendY: bool =False, no_keep_columns_visible: bool =False, precise_widths: bool =False, no_clip: bool =False, pad_outerX: bool =False, no_pad_outerX: bool =False, no_pad_innerX: bool =False, scrollX: bool =False, scrollY: bool =False, no_saved_settings: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a table.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		callback (Callable, optional): Registers a callback.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		header_row (bool, optional): show headers at the top of the columns
		clipper (bool, optional): Use clipper (rows must be same height).
		inner_width (int, optional): 
		policy (int, optional): 
		freeze_rows (int, optional): 
		freeze_columns (int, optional): 
		sort_multi (bool, optional): Hold shift when clicking headers to sort on multiple column.
		sort_tristate (bool, optional): Allow no sorting, disable default sorting.
		resizable (bool, optional): Enable resizing columns
		reorderable (bool, optional): Enable reordering columns in header row (need calling TableSetupColumn() + TableHeadersRow() to display headers)
		hideable (bool, optional): Enable hiding/disabling columns in context menu.
		sortable (bool, optional): Enable sorting. Call TableGetSortSpecs() to obtain sort specs. Also see ImGuiTableFlags_SortMulti and ImGuiTableFlags_SortTristate.
		context_menu_in_body (bool, optional): Right-click on columns body/contents will display table context menu. By default it is available in TableHeadersRow().
		row_background (bool, optional): Set each RowBg color with ImGuiCol_TableRowBg or ImGuiCol_TableRowBgAlt (equivalent of calling TableSetBgColor with ImGuiTableBgFlags_RowBg0 on each row manually)
		borders_innerH (bool, optional): Draw horizontal borders between rows.
		borders_outerH (bool, optional): Draw horizontal borders at the top and bottom.
		borders_innerV (bool, optional): Draw vertical borders between columns.
		borders_outerV (bool, optional): Draw vertical borders on the left and right sides.
		no_host_extendX (bool, optional): Make outer width auto-fit to columns, overriding outer_size.x value. Only available when ScrollX/ScrollY are disabled and Stretch columns are not used.
		no_host_extendY (bool, optional): Make outer height stop exactly at outer_size.y (prevent auto-extending table past the limit). Only available when ScrollX/ScrollY are disabled. Data below the limit will be clipped and not visible.
		no_keep_columns_visible (bool, optional): Disable keeping column always minimally visible when ScrollX is off and table gets too small. Not recommended if columns are resizable.
		precise_widths (bool, optional): Disable distributing remainder width to stretched columns (width allocation on a 100-wide table with 3 columns: Without this flag: 33,33,34. With this flag: 33,33,33). With larger number of columns, resizing will appear to be less smooth.
		no_clip (bool, optional): Disable clipping rectangle for every individual columns.
		pad_outerX (bool, optional): Default if BordersOuterV is on. Enable outer-most padding. Generally desirable if you have headers.
		no_pad_outerX (bool, optional): Default if BordersOuterV is off. Disable outer-most padding.
		no_pad_innerX (bool, optional): Disable inner padding between columns (double inner padding if BordersOuterV is on, single inner padding if BordersOuterV is off).
		scrollX (bool, optional): Enable horizontal scrolling. Require 'outer_size' parameter of BeginTable() to specify the container size. Changes default sizing policy. Because this create a child window, ScrollY is currently generally recommended when using ScrollX.
		scrollY (bool, optional): Enable vertical scrolling.
		no_saved_settings (bool, optional): Never load/save settings in .ini file.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_table(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, parent=parent, before=before, source=source, callback=callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, header_row=header_row, clipper=clipper, inner_width=inner_width, policy=policy, freeze_rows=freeze_rows, freeze_columns=freeze_columns, sort_multi=sort_multi, sort_tristate=sort_tristate, resizable=resizable, reorderable=reorderable, hideable=hideable, sortable=sortable, context_menu_in_body=context_menu_in_body, row_background=row_background, borders_innerH=borders_innerH, borders_outerH=borders_outerH, borders_innerV=borders_innerV, borders_outerV=borders_outerV, no_host_extendX=no_host_extendX, no_host_extendY=no_host_extendY, no_keep_columns_visible=no_keep_columns_visible, precise_widths=precise_widths, no_clip=no_clip, pad_outerX=pad_outerX, no_pad_outerX=no_pad_outerX, no_pad_innerX=no_pad_innerX, scrollX=scrollX, scrollY=scrollY, no_saved_settings=no_saved_settings, **kwargs)

def add_table_cell(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, height: int =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, filter_key: str ='', **kwargs) -> Union[int, str]:
	"""	 Adds a table.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		height (int, optional): Height of the item.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		filter_key (str, optional): Used by filter widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_table_cell(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, height=height, parent=parent, before=before, show=show, filter_key=filter_key, **kwargs)

def add_table_column(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, enabled: bool =True, init_width_or_weight: float =0.0, default_hide: bool =False, default_sort: bool =False, width_stretch: bool =False, width_fixed: bool =False, no_resize: bool =False, no_reorder: bool =False, no_hide: bool =False, no_clip: bool =False, no_sort: bool =False, no_sort_ascending: bool =False, no_sort_descending: bool =False, no_header_width: bool =False, prefer_sort_ascending: bool =True, prefer_sort_descending: bool =False, indent_enable: bool =False, indent_disable: bool =False, angled_header: bool =False, no_header_label: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a table column.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		enabled (bool, optional): Turns off functionality of widget and applies the disabled theme.
		init_width_or_weight (float, optional): 
		default_hide (bool, optional): Default as a hidden/disabled column.
		default_sort (bool, optional): Default as a sorting column.
		width_stretch (bool, optional): Column will stretch. Preferable with horizontal scrolling disabled (default if table sizing policy is _SizingStretchSame or _SizingStretchProp).
		width_fixed (bool, optional): Column will not stretch. Preferable with horizontal scrolling enabled (default if table sizing policy is _SizingFixedFit and table is resizable).
		no_resize (bool, optional): Disable manual resizing.
		no_reorder (bool, optional): Disable manual reordering this column, this will also prevent other columns from crossing over this column.
		no_hide (bool, optional): Disable ability to hide/disable this column.
		no_clip (bool, optional): Disable clipping for this column (all NoClip columns will render in a same draw command).
		no_sort (bool, optional): Disable ability to sort on this field (even if ImGuiTableFlags_Sortable is set on the table).
		no_sort_ascending (bool, optional): Disable ability to sort in the ascending direction.
		no_sort_descending (bool, optional): Disable ability to sort in the descending direction.
		no_header_width (bool, optional): Disable header text width contribution to automatic column width.
		prefer_sort_ascending (bool, optional): Make the initial sort direction Ascending when first sorting on this column (default).
		prefer_sort_descending (bool, optional): Make the initial sort direction Descending when first sorting on this column.
		indent_enable (bool, optional): Use current Indent value when entering cell (default for column 0).
		indent_disable (bool, optional): Ignore current Indent value when entering cell (default for columns > 0). Indentation changes _within_ the cell will still be honored.
		angled_header (bool, optional): Set this parameter to True to display the header text for this column in an angled (diagonal) orientation. This will add an additional row to accommodate the angled text.
		no_header_label (bool, optional): Disable horizontal label for this column. Name will still appear in context menu or in angled headers.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_table_column(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, parent=parent, before=before, show=show, enabled=enabled, init_width_or_weight=init_width_or_weight, default_hide=default_hide, default_sort=default_sort, width_stretch=width_stretch, width_fixed=width_fixed, no_resize=no_resize, no_reorder=no_reorder, no_hide=no_hide, no_clip=no_clip, no_sort=no_sort, no_sort_ascending=no_sort_ascending, no_sort_descending=no_sort_descending, no_header_width=no_header_width, prefer_sort_ascending=prefer_sort_ascending, prefer_sort_descending=prefer_sort_descending, indent_enable=indent_enable, indent_disable=indent_disable, angled_header=angled_header, no_header_label=no_header_label, **kwargs)

def add_table_row(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, height: int =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, filter_key: str ='', **kwargs) -> Union[int, str]:
	"""	 Adds a table row.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		height (int, optional): Height of the item.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		filter_key (str, optional): Used by filter widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_table_row(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, height=height, parent=parent, before=before, show=show, filter_key=filter_key, **kwargs)

def add_template_registry(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, **kwargs) -> Union[int, str]:
	"""	 Adds a template registry.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_template_registry(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, **kwargs)

def add_text(default_value : str ='', *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, wrap: int =-1, bullet: bool =False, color: Union[List[int], Tuple[int, ...]] =(-255, 0, 0, 255), show_label: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds text. Text can have an optional label that will display to the right of the text.

	Args:
		default_value (str, optional): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		wrap (int, optional): Number of pixels from the start of the item until wrapping starts.
		bullet (bool, optional): Places a bullet to the left of the text.
		color (Union[List[int], Tuple[int, ...]], optional): Color of the text (rgba).
		show_label (bool, optional): Displays the label to the right of the text.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_text(default_value, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, source=source, payload_type=payload_type, drag_callback=drag_callback, drop_callback=drop_callback, show=show, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, wrap=wrap, bullet=bullet, color=color, show_label=show_label, **kwargs)

def add_text_point(x : float, y : float, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, source: Union[int, str] =0, show: bool =True, offset: Union[List[float], Tuple[float, ...]] =(0.0, 0.0), vertical: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a label series to a plot. x and y can only have one elements each.

	Args:
		x (float): 
		y (float): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		source (Union[int, str], optional): Overrides 'id' as value storage key.
		show (bool, optional): Attempt to render widget.
		offset (Union[List[float], Tuple[float, ...]], optional): Offset of the label, in pixels, relative to the coordinates.
		vertical (bool, optional): 
		id (Union[int, str], optional): (deprecated) 
		x_offset (int, optional): (deprecated) Old way to set x offset of the label. Use `offset` argument instead.
		y_offset (int, optional): (deprecated) Old way to set y offset of the label. Use `offset` argument instead.
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	if 'x_offset' in kwargs.keys():
		warnings.warn('x_offset keyword deprecated. See the new offset argument.', DeprecationWarning, 2)

	if 'y_offset' in kwargs.keys():
		warnings.warn('y_offset keyword deprecated. See the new offset argument.', DeprecationWarning, 2)

	return internal_dpg.add_text_point(x, y, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, source=source, show=show, offset=offset, vertical=vertical, **kwargs)

def add_texture_registry(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, show: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a dynamic texture.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		show (bool, optional): Attempt to render widget.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_texture_registry(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, show=show, **kwargs)

def add_theme(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, **kwargs) -> Union[int, str]:
	"""	 Adds a theme.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		id (Union[int, str], optional): (deprecated) 
		default_theme (bool, optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	if 'default_theme' in kwargs.keys():

		warnings.warn('default_theme keyword removed', DeprecationWarning, 2)

		kwargs.pop('default_theme', None)

	return internal_dpg.add_theme(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, **kwargs)

def add_theme_color(target : int =0, value : Union[List[int], Tuple[int, ...]] =(0, 0, 0, 255), *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, category: int =0, **kwargs) -> Union[int, str]:
	"""	 Adds a theme color.

	Args:
		target (int, optional): 
		value (Union[List[int], Tuple[int, ...]], optional): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		category (int, optional): Options include mvThemeCat_Core, mvThemeCat_Plots, mvThemeCat_Nodes.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_theme_color(target, value, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, category=category, **kwargs)

def add_theme_component(item_type : int =0, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, enabled_state: bool =True, **kwargs) -> Union[int, str]:
	"""	 Adds a theme component.

	Args:
		item_type (int, optional): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		enabled_state (bool, optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_theme_component(item_type, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, enabled_state=enabled_state, **kwargs)

def add_theme_style(target : int =0, x : float =1.0, y : float =-1.0, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, category: int =0, **kwargs) -> Union[int, str]:
	"""	 Adds a theme style.

	Args:
		target (int, optional): 
		x (float, optional): 
		y (float, optional): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		category (int, optional): Options include mvThemeCat_Core, mvThemeCat_Plots, mvThemeCat_Nodes.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_theme_style(target, x, y, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, category=category, **kwargs)

def add_time_picker(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', callback: Callable =None, drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', tracked: bool =False, track_offset: float =0.5, default_value: dict ={'hour': 14, 'min': 32, 'sec': 23}, hour24: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a time picker.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		callback (Callable, optional): Registers a callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_value (dict, optional): 
		hour24 (bool, optional): Show 24 hour clock instead of 12 hour.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_time_picker(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, payload_type=payload_type, callback=callback, drag_callback=drag_callback, drop_callback=drop_callback, show=show, pos=pos, filter_key=filter_key, tracked=tracked, track_offset=track_offset, default_value=default_value, hour24=hour24, **kwargs)

def add_tooltip(parent : Union[int, str], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, show: bool =True, delay: float =0.0, hide_on_activity: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a tooltip window.

	Args:
		parent (Union[int, str]): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		show (bool, optional): Attempt to render widget.
		delay (float, optional): Activation delay: time, in seconds, during which the mouse should stay still in order to display the tooltip.  May be zero for instant activation.
		hide_on_activity (bool, optional): Hide the tooltip if the user has moved the mouse.  If False, the tooltip will follow mouse pointer.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_tooltip(parent, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, show=show, delay=delay, hide_on_activity=hide_on_activity, **kwargs)

def add_tree_node(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, before: Union[int, str] =0, payload_type: str ='$$DPG_PAYLOAD', drag_callback: Callable =None, drop_callback: Callable =None, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], filter_key: str ='', delay_search: bool =False, tracked: bool =False, track_offset: float =0.5, default_open: bool =False, open_on_double_click: bool =False, open_on_arrow: bool =False, leaf: bool =False, bullet: bool =False, selectable: bool =False, span_text_width: bool =False, span_full_width: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a tree node to add items to.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		payload_type (str, optional): Sender string type must be the same as the target for the target to run the payload_callback.
		drag_callback (Callable, optional): Registers a drag callback for drag and drop.
		drop_callback (Callable, optional): Registers a drop callback for drag and drop.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		tracked (bool, optional): Scroll tracking
		track_offset (float, optional): 0.0f:top, 0.5f:center, 1.0f:bottom
		default_open (bool, optional): Sets the tree node open by default.
		open_on_double_click (bool, optional): Need double-click to open node.
		open_on_arrow (bool, optional): Only open when clicking on the arrow part.
		leaf (bool, optional): No collapsing, no arrow (use as a convenience for leaf nodes).
		bullet (bool, optional): Display a bullet instead of arrow.
		selectable (bool, optional): Makes the tree selectable.
		span_text_width (bool, optional): Makes hitbox and highlight only cover the label.
		span_full_width (bool, optional): Extend hit box to the left-most and right-most edges (cover the indent area).
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_tree_node(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, before=before, payload_type=payload_type, drag_callback=drag_callback, drop_callback=drop_callback, show=show, pos=pos, filter_key=filter_key, delay_search=delay_search, tracked=tracked, track_offset=track_offset, default_open=default_open, open_on_double_click=open_on_double_click, open_on_arrow=open_on_arrow, leaf=leaf, bullet=bullet, selectable=selectable, span_text_width=span_text_width, span_full_width=span_full_width, **kwargs)

def add_value_registry(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, **kwargs) -> Union[int, str]:
	"""	 Adds a value registry.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_value_registry(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, **kwargs)

def add_viewport_drawlist(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, show: bool =True, filter_key: str ='', delay_search: bool =False, front: bool =True, **kwargs) -> Union[int, str]:
	"""	 A container that is used to present draw items or layers directly to the viewport. By default this will draw to the back of the viewport. Layers and draw items should be added to this widget as children.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		show (bool, optional): Attempt to render widget.
		filter_key (str, optional): Used by filter widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		front (bool, optional): Draws to the front of the view port instead of the back.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_viewport_drawlist(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, show=show, filter_key=filter_key, delay_search=delay_search, front=front, **kwargs)

def add_viewport_menu_bar(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, indent: int =-1, parent: Union[int, str] =0, show: bool =True, delay_search: bool =False, **kwargs) -> Union[int, str]:
	"""	 Adds a menubar to the viewport.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		show (bool, optional): Attempt to render widget.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_viewport_menu_bar(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, indent=indent, parent=parent, show=show, delay_search=delay_search, **kwargs)

def add_window(*, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, width: int =0, height: int =0, indent: int =-1, show: bool =True, pos: Union[List[int], Tuple[int, ...]] =[], delay_search: bool =False, min_size: Union[List[int], Tuple[int, ...]] =[100, 100], max_size: Union[List[int], Tuple[int, ...]] =[30000, 30000], menubar: bool =False, collapsed: bool =False, autosize: bool =False, no_resize: bool =False, unsaved_document: bool =False, no_title_bar: bool =False, no_move: bool =False, no_scrollbar: bool =False, no_collapse: bool =False, horizontal_scrollbar: bool =False, no_focus_on_appearing: bool =False, no_bring_to_front_on_focus: bool =False, no_close: bool =False, no_background: bool =False, modal: bool =False, popup: bool =False, no_saved_settings: bool =False, no_open_over_existing_popup: bool =True, no_scroll_with_mouse: bool =False, on_close: Callable =None, **kwargs) -> Union[int, str]:
	"""	 Creates a new window for following items to be added to.

	Args:
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		width (int, optional): Width of the item.
		height (int, optional): Height of the item.
		indent (int, optional): Offsets the widget to the right the specified number multiplied by the indent style.
		show (bool, optional): Attempt to render widget.
		pos (Union[List[int], Tuple[int, ...]], optional): Places the item relative to window coordinates, [0,0] is top left.
		delay_search (bool, optional): Delays searching container for specified items until the end of the app. Possible optimization when a container has many children that are not accessed often.
		min_size (Union[List[int], Tuple[int, ...]], optional): Minimum window size.
		max_size (Union[List[int], Tuple[int, ...]], optional): Maximum window size.
		menubar (bool, optional): Shows or hides the menubar.
		collapsed (bool, optional): Collapse the window.
		autosize (bool, optional): Autosized the window to fit it's items.
		no_resize (bool, optional): Allows for the window size to be changed or fixed.
		unsaved_document (bool, optional): Show a special marker if the document is not saved.
		no_title_bar (bool, optional): Title name for the title bar of the window.
		no_move (bool, optional): Allows for the window's position to be changed or fixed.
		no_scrollbar (bool, optional):  Disable scrollbars. (window can still scroll with mouse or programmatically)
		no_collapse (bool, optional): Disable user collapsing window by double-clicking on it.
		horizontal_scrollbar (bool, optional): Allow horizontal scrollbar to appear. (off by default)
		no_focus_on_appearing (bool, optional): Disable taking focus when transitioning from hidden to visible state.
		no_bring_to_front_on_focus (bool, optional): Disable bringing window to front when taking focus. (e.g. clicking on it or programmatically giving it focus)
		no_close (bool, optional): Disable user closing the window by removing the close button.
		no_background (bool, optional): Sets Background and border alpha to transparent.
		modal (bool, optional): Fills area behind window according to the theme and disables user ability to interact with anything except the window.
		popup (bool, optional): Fills area behind window according to the theme, removes title bar, collapse and close. Window can be closed by selecting area in the background behind the window.
		no_saved_settings (bool, optional): Never load/save settings in .ini file.
		no_open_over_existing_popup (bool, optional): Don't open if there's already a popup
		no_scroll_with_mouse (bool, optional): Disable user vertically scrolling with mouse wheel.
		on_close (Callable, optional): Callback ran when window is closed.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.add_window(label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, width=width, height=height, indent=indent, show=show, pos=pos, delay_search=delay_search, min_size=min_size, max_size=max_size, menubar=menubar, collapsed=collapsed, autosize=autosize, no_resize=no_resize, unsaved_document=unsaved_document, no_title_bar=no_title_bar, no_move=no_move, no_scrollbar=no_scrollbar, no_collapse=no_collapse, horizontal_scrollbar=horizontal_scrollbar, no_focus_on_appearing=no_focus_on_appearing, no_bring_to_front_on_focus=no_bring_to_front_on_focus, no_close=no_close, no_background=no_background, modal=modal, popup=popup, no_saved_settings=no_saved_settings, no_open_over_existing_popup=no_open_over_existing_popup, no_scroll_with_mouse=no_scroll_with_mouse, on_close=on_close, **kwargs)

def apply_transform(item : Union[int, str], transform : Any, **kwargs) -> None:
	"""	 New in 1.1. Applies a transformation matrix to a layer.

	Args:
		item (Union[int, str]): Drawing node to apply transform to.
		transform (Any): Transformation matrix.
	Returns:
		None
	"""

	return internal_dpg.apply_transform(item, transform, **kwargs)

def bind_colormap(item : Union[int, str], source : Union[int, str], **kwargs) -> None:
	"""	 Sets the color map for widgets that accept it.

	Args:
		item (Union[int, str]): item that the color map will be applied to
		source (Union[int, str]): The colormap tag. This should come from a colormap that was added to a colormap registry.  Built in color maps are accessible through their corresponding constants mvPlotColormap_Twilight, mvPlotColormap_***
	Returns:
		None
	"""

	return internal_dpg.bind_colormap(item, source, **kwargs)

def bind_font(font : Union[int, str], **kwargs) -> Union[int, str]:
	"""	 Binds a global font.

	Args:
		font (Union[int, str]): 
	Returns:
		Union[int, str]
	"""

	return internal_dpg.bind_font(font, **kwargs)

def bind_item_font(item : Union[int, str], font : Union[int, str], **kwargs) -> None:
	"""	 Sets an item's font.

	Args:
		item (Union[int, str]): 
		font (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.bind_item_font(item, font, **kwargs)

def bind_item_handler_registry(item : Union[int, str], handler_registry : Union[int, str], **kwargs) -> None:
	"""	 Binds an item handler registry to an item.

	Args:
		item (Union[int, str]): 
		handler_registry (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.bind_item_handler_registry(item, handler_registry, **kwargs)

def bind_item_theme(item : Union[int, str], theme : Union[int, str], **kwargs) -> None:
	"""	 Binds a theme to an item.

	Args:
		item (Union[int, str]): 
		theme (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.bind_item_theme(item, theme, **kwargs)

def bind_theme(theme : Union[int, str], **kwargs) -> None:
	"""	 Binds a global theme.

	Args:
		theme (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.bind_theme(theme, **kwargs)

def capture_next_item(callback : Callable, *, user_data: Any =None, **kwargs) -> None:
	"""	 Captures the next item.

	Args:
		callback (Callable): 
		user_data (Any, optional): New in 1.3. Optional user data to send to the callback
	Returns:
		None
	"""

	return internal_dpg.capture_next_item(callback, user_data=user_data, **kwargs)

def clear_selected_links(node_editor : Union[int, str], **kwargs) -> None:
	"""	 Clears a node editor's selected links.

	Args:
		node_editor (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.clear_selected_links(node_editor, **kwargs)

def clear_selected_nodes(node_editor : Union[int, str], **kwargs) -> None:
	"""	 Clears a node editor's selected nodes.

	Args:
		node_editor (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.clear_selected_nodes(node_editor, **kwargs)

def create_context(**kwargs) -> None:
	"""	 Creates the Dear PyGui context.

	Args:
	Returns:
		None
	"""

	return internal_dpg.create_context(**kwargs)

def create_fps_matrix(eye : Union[List[float], Tuple[float, ...]], pitch : float, yaw : float, **kwargs) -> Any:
	"""	 New in 1.1. Create a 'first person shooter' matrix.

	Args:
		eye (Union[List[float], Tuple[float, ...]]): eye position
		pitch (float): pitch (in radians)
		yaw (float): yaw (in radians)
	Returns:
		Any
	"""

	return internal_dpg.create_fps_matrix(eye, pitch, yaw, **kwargs)

def create_lookat_matrix(eye : Union[List[float], Tuple[float, ...]], target : Union[List[float], Tuple[float, ...]], up : Union[List[float], Tuple[float, ...]], **kwargs) -> Any:
	"""	 New in 1.1. Creates a 'Look at matrix'.

	Args:
		eye (Union[List[float], Tuple[float, ...]]): eye position
		target (Union[List[float], Tuple[float, ...]]): target position
		up (Union[List[float], Tuple[float, ...]]): up vector
	Returns:
		Any
	"""

	return internal_dpg.create_lookat_matrix(eye, target, up, **kwargs)

def create_orthographic_matrix(left : float, right : float, bottom : float, top : float, zNear : float, zFar : float, **kwargs) -> Any:
	"""	 New in 1.1. Creates an orthographic matrix.

	Args:
		left (float): left plane
		right (float): right plane
		bottom (float): bottom plane
		top (float): top plane
		zNear (float): Near clipping plane.
		zFar (float): Far clipping plane.
	Returns:
		Any
	"""

	return internal_dpg.create_orthographic_matrix(left, right, bottom, top, zNear, zFar, **kwargs)

def create_perspective_matrix(fov : float, aspect : float, zNear : float, zFar : float, **kwargs) -> Any:
	"""	 New in 1.1. Creates a perspective matrix.

	Args:
		fov (float): Field of view (in radians)
		aspect (float): Aspect ratio (width/height)
		zNear (float): Near clipping plane.
		zFar (float): Far clipping plane.
	Returns:
		Any
	"""

	return internal_dpg.create_perspective_matrix(fov, aspect, zNear, zFar, **kwargs)

def create_rotation_matrix(angle : float, axis : Union[List[float], Tuple[float, ...]], **kwargs) -> Any:
	"""	 New in 1.1. Applies a transformation matrix to a layer.

	Args:
		angle (float): angle to rotate
		axis (Union[List[float], Tuple[float, ...]]): axis to rotate around
	Returns:
		Any
	"""

	return internal_dpg.create_rotation_matrix(angle, axis, **kwargs)

def create_scale_matrix(scales : Union[List[float], Tuple[float, ...]], **kwargs) -> Any:
	"""	 New in 1.1. Applies a transformation matrix to a layer.

	Args:
		scales (Union[List[float], Tuple[float, ...]]): scale values per axis
	Returns:
		Any
	"""

	return internal_dpg.create_scale_matrix(scales, **kwargs)

def create_translation_matrix(translation : Union[List[float], Tuple[float, ...]], **kwargs) -> Any:
	"""	 New in 1.1. Creates a translation matrix.

	Args:
		translation (Union[List[float], Tuple[float, ...]]): translation vector
	Returns:
		Any
	"""

	return internal_dpg.create_translation_matrix(translation, **kwargs)

def create_viewport(*, title: str ='Dear PyGui', small_icon: str ='', large_icon: str ='', width: int =1280, height: int =800, x_pos: int =100, y_pos: int =100, min_width: int =250, max_width: int =10000, min_height: int =250, max_height: int =10000, resizable: bool =True, vsync: bool =True, always_on_top: bool =False, decorated: bool =True, clear_color: Union[List[float], Tuple[float, ...]] =(0, 0, 0, 255), disable_close: bool =False, **kwargs) -> None:
	"""	 Creates a viewport. Viewports are required.

	Args:
		title (str, optional): Sets the title of the viewport.
		small_icon (str, optional): Sets the small icon that is found in the viewport's decorator bar. Must be ***.ico on windows and either ***.ico or ***.png on mac.
		large_icon (str, optional): Sets the large icon that is found in the task bar while the app is running. Must be ***.ico on windows and either ***.ico or ***.png on mac.
		width (int, optional): Sets the width of the drawable space on the viewport. Does not inclue the border.
		height (int, optional): Sets the height of the drawable space on the viewport. Does not inclue the border or decorator bar.
		x_pos (int, optional): Sets x position the viewport will be drawn in screen coordinates.
		y_pos (int, optional): Sets y position the viewport will be drawn in screen coordinates.
		min_width (int, optional): Applies a minimuim limit to the width of the viewport.
		max_width (int, optional): Applies a maximum limit to the width of the viewport.
		min_height (int, optional): Applies a minimuim limit to the height of the viewport.
		max_height (int, optional): Applies a maximum limit to the height of the viewport.
		resizable (bool, optional): Enables and Disables user ability to resize the viewport.
		vsync (bool, optional): Enables and Disables the renderloop vsync limit. vsync frame value is set by refresh rate of display.
		always_on_top (bool, optional): Forces the viewport to always be drawn ontop of all other viewports.
		decorated (bool, optional): Enabled and disabled the decorator bar at the top of the viewport.
		clear_color (Union[List[float], Tuple[float, ...]], optional): Sets the color of the back of the viewport.
		disable_close (bool, optional): Disables the viewport close button. can be used with set_exit_callback
	Returns:
		None
	"""

	return internal_dpg.create_viewport(title=title, small_icon=small_icon, large_icon=large_icon, width=width, height=height, x_pos=x_pos, y_pos=y_pos, min_width=min_width, max_width=max_width, min_height=min_height, max_height=max_height, resizable=resizable, vsync=vsync, always_on_top=always_on_top, decorated=decorated, clear_color=clear_color, disable_close=disable_close, **kwargs)

def delete_item(item : Union[int, str], *, children_only: bool =False, slot: int =-1, **kwargs) -> None:
	"""	 Deletes an item..

	Args:
		item (Union[int, str]): 
		children_only (bool, optional): 
		slot (int, optional): 
	Returns:
		None
	"""

	return internal_dpg.delete_item(item, children_only=children_only, slot=slot, **kwargs)

def destroy_context(**kwargs) -> None:
	"""	 Destroys the Dear PyGui context.

	Args:
	Returns:
		None
	"""

	return internal_dpg.destroy_context(**kwargs)

def does_alias_exist(alias : str, **kwargs) -> bool:
	"""	 Checks if an alias exist.

	Args:
		alias (str): 
	Returns:
		bool
	"""

	return internal_dpg.does_alias_exist(alias, **kwargs)

def does_item_exist(item : Union[int, str], **kwargs) -> bool:
	"""	 Checks if an item exist..

	Args:
		item (Union[int, str]): 
	Returns:
		bool
	"""

	return internal_dpg.does_item_exist(item, **kwargs)

def draw_arrow(p1 : Union[List[float], Tuple[float, ...]], p2 : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, color: Union[List[int], Tuple[int, ...]] =(255, 255, 255, 255), thickness: float =1.0, size: int =4, **kwargs) -> Union[int, str]:
	"""	 Adds an arrow.

	Args:
		p1 (Union[List[float], Tuple[float, ...]]): Arrow tip.
		p2 (Union[List[float], Tuple[float, ...]]): Arrow tail.
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		color (Union[List[int], Tuple[int, ...]], optional): 
		thickness (float, optional): 
		size (int, optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.draw_arrow(p1, p2, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, color=color, thickness=thickness, size=size, **kwargs)

def draw_bezier_cubic(p1 : Union[List[float], Tuple[float, ...]], p2 : Union[List[float], Tuple[float, ...]], p3 : Union[List[float], Tuple[float, ...]], p4 : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, color: Union[List[int], Tuple[int, ...]] =(255, 255, 255, 255), thickness: float =1.0, segments: int =0, **kwargs) -> Union[int, str]:
	"""	 Adds a cubic bezier curve.

	Args:
		p1 (Union[List[float], Tuple[float, ...]]): First point in curve.
		p2 (Union[List[float], Tuple[float, ...]]): Second point in curve.
		p3 (Union[List[float], Tuple[float, ...]]): Third point in curve.
		p4 (Union[List[float], Tuple[float, ...]]): Fourth point in curve.
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		color (Union[List[int], Tuple[int, ...]], optional): 
		thickness (float, optional): 
		segments (int, optional): Number of segments to approximate bezier curve.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.draw_bezier_cubic(p1, p2, p3, p4, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, color=color, thickness=thickness, segments=segments, **kwargs)

def draw_bezier_quadratic(p1 : Union[List[float], Tuple[float, ...]], p2 : Union[List[float], Tuple[float, ...]], p3 : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, color: Union[List[int], Tuple[int, ...]] =(255, 255, 255, 255), thickness: float =1.0, segments: int =0, **kwargs) -> Union[int, str]:
	"""	 Adds a quadratic bezier curve.

	Args:
		p1 (Union[List[float], Tuple[float, ...]]): First point in curve.
		p2 (Union[List[float], Tuple[float, ...]]): Second point in curve.
		p3 (Union[List[float], Tuple[float, ...]]): Third point in curve.
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		color (Union[List[int], Tuple[int, ...]], optional): 
		thickness (float, optional): 
		segments (int, optional): Number of segments to approximate bezier curve.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.draw_bezier_quadratic(p1, p2, p3, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, color=color, thickness=thickness, segments=segments, **kwargs)

def draw_circle(center : Union[List[float], Tuple[float, ...]], radius : float, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, color: Union[List[int], Tuple[int, ...]] =(255, 255, 255, 255), fill: Union[List[int], Tuple[int, ...]] =(0, 0, 0, -255), thickness: float =1.0, segments: int =0, **kwargs) -> Union[int, str]:
	"""	 Adds a circle

	Args:
		center (Union[List[float], Tuple[float, ...]]): 
		radius (float): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		color (Union[List[int], Tuple[int, ...]], optional): 
		fill (Union[List[int], Tuple[int, ...]], optional): 
		thickness (float, optional): 
		segments (int, optional): Number of segments to approximate circle.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.draw_circle(center, radius, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, color=color, fill=fill, thickness=thickness, segments=segments, **kwargs)

def draw_ellipse(pmin : Union[List[float], Tuple[float, ...]], pmax : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, color: Union[List[int], Tuple[int, ...]] =(255, 255, 255, 255), fill: Union[List[int], Tuple[int, ...]] =(0, 0, 0, -255), thickness: float =1.0, segments: int =32, **kwargs) -> Union[int, str]:
	"""	 Adds an ellipse.

	Args:
		pmin (Union[List[float], Tuple[float, ...]]): Min point of bounding rectangle.
		pmax (Union[List[float], Tuple[float, ...]]): Max point of bounding rectangle.
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		color (Union[List[int], Tuple[int, ...]], optional): 
		fill (Union[List[int], Tuple[int, ...]], optional): 
		thickness (float, optional): 
		segments (int, optional): Number of segments to approximate bezier curve.
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.draw_ellipse(pmin, pmax, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, color=color, fill=fill, thickness=thickness, segments=segments, **kwargs)

def draw_image(texture_tag : Union[int, str], pmin : Union[List[float], Tuple[float, ...]], pmax : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, uv_min: Union[List[float], Tuple[float, ...]] =(0.0, 0.0), uv_max: Union[List[float], Tuple[float, ...]] =(1.0, 1.0), color: Union[List[int], Tuple[int, ...]] =(255, 255, 255, 255), **kwargs) -> Union[int, str]:
	"""	 Adds an image (for a drawing).

	Args:
		texture_tag (Union[int, str]): 
		pmin (Union[List[float], Tuple[float, ...]]): Point of to start drawing texture.
		pmax (Union[List[float], Tuple[float, ...]]): Point to complete drawing texture.
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		uv_min (Union[List[float], Tuple[float, ...]], optional): Normalized coordinates on texture that will be drawn.
		uv_max (Union[List[float], Tuple[float, ...]], optional): Normalized coordinates on texture that will be drawn.
		color (Union[List[int], Tuple[int, ...]], optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.draw_image(texture_tag, pmin, pmax, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, uv_min=uv_min, uv_max=uv_max, color=color, **kwargs)

def draw_image_quad(texture_tag : Union[int, str], p1 : Union[List[float], Tuple[float, ...]], p2 : Union[List[float], Tuple[float, ...]], p3 : Union[List[float], Tuple[float, ...]], p4 : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, uv1: Union[List[float], Tuple[float, ...]] =(0.0, 0.0), uv2: Union[List[float], Tuple[float, ...]] =(1.0, 0.0), uv3: Union[List[float], Tuple[float, ...]] =(1.0, 1.0), uv4: Union[List[float], Tuple[float, ...]] =(0.0, 1.0), color: Union[List[int], Tuple[int, ...]] =(255, 255, 255, 255), **kwargs) -> Union[int, str]:
	"""	 Adds an image (for a drawing).

	Args:
		texture_tag (Union[int, str]): 
		p1 (Union[List[float], Tuple[float, ...]]): 
		p2 (Union[List[float], Tuple[float, ...]]): 
		p3 (Union[List[float], Tuple[float, ...]]): 
		p4 (Union[List[float], Tuple[float, ...]]): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		uv1 (Union[List[float], Tuple[float, ...]], optional): Normalized coordinates on texture that will be drawn.
		uv2 (Union[List[float], Tuple[float, ...]], optional): Normalized coordinates on texture that will be drawn.
		uv3 (Union[List[float], Tuple[float, ...]], optional): Normalized coordinates on texture that will be drawn.
		uv4 (Union[List[float], Tuple[float, ...]], optional): Normalized coordinates on texture that will be drawn.
		color (Union[List[int], Tuple[int, ...]], optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.draw_image_quad(texture_tag, p1, p2, p3, p4, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, uv1=uv1, uv2=uv2, uv3=uv3, uv4=uv4, color=color, **kwargs)

def draw_line(p1 : Union[List[float], Tuple[float, ...]], p2 : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, color: Union[List[int], Tuple[int, ...]] =(255, 255, 255, 255), thickness: float =1.0, **kwargs) -> Union[int, str]:
	"""	 Adds a line.

	Args:
		p1 (Union[List[float], Tuple[float, ...]]): Start of line.
		p2 (Union[List[float], Tuple[float, ...]]): End of line.
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		color (Union[List[int], Tuple[int, ...]], optional): 
		thickness (float, optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.draw_line(p1, p2, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, color=color, thickness=thickness, **kwargs)

def draw_polygon(points : List[List[float]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, color: Union[List[int], Tuple[int, ...]] =(255, 255, 255, 255), fill: Union[List[int], Tuple[int, ...]] =(0, 0, 0, -255), thickness: float =1.0, **kwargs) -> Union[int, str]:
	"""	 Adds a polygon.

	Args:
		points (List[List[float]]): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		color (Union[List[int], Tuple[int, ...]], optional): 
		fill (Union[List[int], Tuple[int, ...]], optional): 
		thickness (float, optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.draw_polygon(points, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, color=color, fill=fill, thickness=thickness, **kwargs)

def draw_polyline(points : List[List[float]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, closed: bool =False, color: Union[List[int], Tuple[int, ...]] =(255, 255, 255, 255), thickness: float =1.0, **kwargs) -> Union[int, str]:
	"""	 Adds a polyline.

	Args:
		points (List[List[float]]): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		closed (bool, optional): Will close the polyline by returning to the first point.
		color (Union[List[int], Tuple[int, ...]], optional): 
		thickness (float, optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.draw_polyline(points, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, closed=closed, color=color, thickness=thickness, **kwargs)

def draw_quad(p1 : Union[List[float], Tuple[float, ...]], p2 : Union[List[float], Tuple[float, ...]], p3 : Union[List[float], Tuple[float, ...]], p4 : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, color: Union[List[int], Tuple[int, ...]] =(255, 255, 255, 255), fill: Union[List[int], Tuple[int, ...]] =(0, 0, 0, -255), thickness: float =1.0, **kwargs) -> Union[int, str]:
	"""	 Adds a quad.

	Args:
		p1 (Union[List[float], Tuple[float, ...]]): 
		p2 (Union[List[float], Tuple[float, ...]]): 
		p3 (Union[List[float], Tuple[float, ...]]): 
		p4 (Union[List[float], Tuple[float, ...]]): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		color (Union[List[int], Tuple[int, ...]], optional): 
		fill (Union[List[int], Tuple[int, ...]], optional): 
		thickness (float, optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.draw_quad(p1, p2, p3, p4, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, color=color, fill=fill, thickness=thickness, **kwargs)

def draw_rectangle(pmin : Union[List[float], Tuple[float, ...]], pmax : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, color: Union[List[int], Tuple[int, ...]] =(255, 255, 255, 255), fill: Union[List[int], Tuple[int, ...]] =(0, 0, 0, -255), multicolor: bool =False, rounding: float =0.0, thickness: float =1.0, corner_colors: Any =None, **kwargs) -> Union[int, str]:
	"""	 Adds a rectangle.

	Args:
		pmin (Union[List[float], Tuple[float, ...]]): Min point of bounding rectangle.
		pmax (Union[List[float], Tuple[float, ...]]): Max point of bounding rectangle.
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		color (Union[List[int], Tuple[int, ...]], optional): 
		fill (Union[List[int], Tuple[int, ...]], optional): 
		multicolor (bool, optional): 
		rounding (float, optional): Number of pixels of the radius that will round the corners of the rectangle. Note: doesn't work with multicolor
		thickness (float, optional): 
		corner_colors (Any, optional): Corner colors in a list, starting with upper-left and going clockwise: (upper-left, upper-right, bottom-right, bottom-left). 'multicolor' must be set to 'True'.
		id (Union[int, str], optional): (deprecated) 
		color_upper_left (Union[List[int], Tuple[int, ...]], optional): (deprecated) Use corner_colors instead
		color_upper_right (Union[List[int], Tuple[int, ...]], optional): (deprecated) Use corner_colors instead
		color_bottom_right (Union[List[int], Tuple[int, ...]], optional): (deprecated) Use corner_colors instead
		color_bottom_left (Union[List[int], Tuple[int, ...]], optional): (deprecated) Use corner_colors instead
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	if 'color_upper_left' in kwargs.keys():
		warnings.warn('color_upper_left keyword deprecated. Use corner_colors instead.', DeprecationWarning, 2)

	if 'color_upper_right' in kwargs.keys():
		warnings.warn('color_upper_right keyword deprecated. Use corner_colors instead.', DeprecationWarning, 2)

	if 'color_bottom_right' in kwargs.keys():
		warnings.warn('color_bottom_right keyword deprecated. Use corner_colors instead.', DeprecationWarning, 2)

	if 'color_bottom_left' in kwargs.keys():
		warnings.warn('color_bottom_left keyword deprecated. Use corner_colors instead.', DeprecationWarning, 2)

	return internal_dpg.draw_rectangle(pmin, pmax, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, color=color, fill=fill, multicolor=multicolor, rounding=rounding, thickness=thickness, corner_colors=corner_colors, **kwargs)

def draw_text(pos : Union[List[float], Tuple[float, ...]], text : str, *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, color: Union[List[int], Tuple[int, ...]] =(255, 255, 255, 255), size: float =10.0, **kwargs) -> Union[int, str]:
	"""	 Adds text (drawlist).

	Args:
		pos (Union[List[float], Tuple[float, ...]]): Top left point of bounding text rectangle.
		text (str): Text to draw.
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		color (Union[List[int], Tuple[int, ...]], optional): 
		size (float, optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.draw_text(pos, text, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, color=color, size=size, **kwargs)

def draw_triangle(p1 : Union[List[float], Tuple[float, ...]], p2 : Union[List[float], Tuple[float, ...]], p3 : Union[List[float], Tuple[float, ...]], *, label: str =None, user_data: Any =None, use_internal_label: bool =True, tag: Union[int, str] =0, parent: Union[int, str] =0, before: Union[int, str] =0, show: bool =True, color: Union[List[int], Tuple[int, ...]] =(255, 255, 255, 255), fill: Union[List[int], Tuple[int, ...]] =(0, 0, 0, -255), thickness: float =1.0, **kwargs) -> Union[int, str]:
	"""	 Adds a triangle.

	Args:
		p1 (Union[List[float], Tuple[float, ...]]): 
		p2 (Union[List[float], Tuple[float, ...]]): 
		p3 (Union[List[float], Tuple[float, ...]]): 
		label (str, optional): Overrides 'name' as label.
		user_data (Any, optional): User data for callbacks
		use_internal_label (bool, optional): Use generated internal label instead of user specified (appends ### uuid).
		tag (Union[int, str], optional): Unique id used to programmatically refer to the item.If label is unused this will be the label.
		parent (Union[int, str], optional): Parent to add this item to. (runtime adding)
		before (Union[int, str], optional): This item will be displayed before the specified item in the parent.
		show (bool, optional): Attempt to render widget.
		color (Union[List[int], Tuple[int, ...]], optional): 
		fill (Union[List[int], Tuple[int, ...]], optional): 
		thickness (float, optional): 
		id (Union[int, str], optional): (deprecated) 
	Returns:
		Union[int, str]
	"""

	if 'id' in kwargs.keys():
		warnings.warn('id keyword renamed to tag', DeprecationWarning, 2)
		tag=kwargs['id']

	return internal_dpg.draw_triangle(p1, p2, p3, label=label, user_data=user_data, use_internal_label=use_internal_label, tag=tag, parent=parent, before=before, show=show, color=color, fill=fill, thickness=thickness, **kwargs)

def empty_container_stack(**kwargs) -> None:
	"""	 Emptyes the container stack.

	Args:
	Returns:
		None
	"""

	return internal_dpg.empty_container_stack(**kwargs)

def fit_axis_data(axis : Union[int, str], **kwargs) -> None:
	"""	 Sets the axis boundaries max/min in the data series currently on the plot.

	Args:
		axis (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.fit_axis_data(axis, **kwargs)

def focus_item(item : Union[int, str], **kwargs) -> None:
	"""	 Focuses an item.

	Args:
		item (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.focus_item(item, **kwargs)

def generate_uuid(**kwargs) -> Union[int, str]:
	"""	 Generate a new UUID.

	Args:
	Returns:
		Union[int, str]
	"""

	return internal_dpg.generate_uuid(**kwargs)

def get_active_window(**kwargs) -> Union[int, str]:
	"""	 Returns the active window.

	Args:
	Returns:
		Union[int, str]
	"""

	return internal_dpg.get_active_window(**kwargs)

def get_alias_id(alias : str, **kwargs) -> Union[int, str]:
	"""	 Returns the ID associated with an alias.

	Args:
		alias (str): 
	Returns:
		Union[int, str]
	"""

	return internal_dpg.get_alias_id(alias, **kwargs)

def get_aliases(**kwargs) -> Union[List[str], Tuple[str, ...]]:
	"""	 Returns all aliases.

	Args:
	Returns:
		Union[List[str], Tuple[str, ...]]
	"""

	return internal_dpg.get_aliases(**kwargs)

def get_all_items(**kwargs) -> Union[List[int], Tuple[int, ...]]:
	"""	 Returns all items.

	Args:
	Returns:
		Union[List[int], Tuple[int, ...]]
	"""

	return internal_dpg.get_all_items(**kwargs)

def get_app_configuration(**kwargs) -> dict:
	"""	 Returns app configuration.

	Args:
	Returns:
		dict
	"""

	return internal_dpg.get_app_configuration(**kwargs)

def get_axis_limits(axis : Union[int, str], **kwargs) -> Union[List[float], Tuple[float, ...]]:
	"""	 Get the specified axis limits.

	Args:
		axis (Union[int, str]): 
	Returns:
		Union[List[float], Tuple[float, ...]]
	"""

	return internal_dpg.get_axis_limits(axis, **kwargs)

def get_callback_queue(**kwargs) -> Any:
	"""	 New in 1.2. Returns and clears callback queue.

	Args:
	Returns:
		Any
	"""

	return internal_dpg.get_callback_queue(**kwargs)

def get_clipboard_text(**kwargs) -> str:
	"""	 New in 1.3. Gets the clipboard text.

	Args:
	Returns:
		str
	"""

	return internal_dpg.get_clipboard_text(**kwargs)

def get_colormap_color(colormap : Union[int, str], index : int, **kwargs) -> Union[List[int], Tuple[int, ...]]:
	"""	 Returns a color from a colormap given an index >= 0. (ex. 0 will be the first color in the color list of the color map) Modulo will be performed against the number of items in the color list.

	Args:
		colormap (Union[int, str]): The colormap tag. This should come from a colormap that was added to a colormap registry. Built in color maps are accessible through their corresponding constants mvPlotColormap_Twilight, mvPlotColormap_***
		index (int): Desired position of the color in the colors list value of the colormap being quiered 
	Returns:
		Union[List[int], Tuple[int, ...]]
	"""

	return internal_dpg.get_colormap_color(colormap, index, **kwargs)

def get_delta_time(**kwargs) -> float:
	"""	 Returns time since last frame.

	Args:
	Returns:
		float
	"""

	return internal_dpg.get_delta_time(**kwargs)

def get_drawing_mouse_pos(**kwargs) -> Union[List[int], Tuple[int, ...]]:
	"""	 Returns mouse position in drawing.

	Args:
	Returns:
		Union[List[int], Tuple[int, ...]]
	"""

	return internal_dpg.get_drawing_mouse_pos(**kwargs)

def get_file_dialog_info(file_dialog : Union[int, str], **kwargs) -> dict:
	"""	 Returns information related to the file dialog. Typically used while the file dialog is in use to query data about the state or info related to the file dialog.

	Args:
		file_dialog (Union[int, str]): 
	Returns:
		dict
	"""

	return internal_dpg.get_file_dialog_info(file_dialog, **kwargs)

def get_focused_item(**kwargs) -> Union[int, str]:
	"""	 Returns the item currently having focus.

	Args:
	Returns:
		Union[int, str]
	"""

	return internal_dpg.get_focused_item(**kwargs)

def get_frame_count(**kwargs) -> int:
	"""	 Returns frame count.

	Args:
	Returns:
		int
	"""

	return internal_dpg.get_frame_count(**kwargs)

def get_frame_rate(**kwargs) -> float:
	"""	 Returns the average frame rate across 120 frames.

	Args:
	Returns:
		float
	"""

	return internal_dpg.get_frame_rate(**kwargs)

def get_global_font_scale(**kwargs) -> float:
	"""	 Returns global font scale.

	Args:
	Returns:
		float
	"""

	return internal_dpg.get_global_font_scale(**kwargs)

def get_item_alias(item : Union[int, str], **kwargs) -> str:
	"""	 Returns an item's alias.

	Args:
		item (Union[int, str]): 
	Returns:
		str
	"""

	return internal_dpg.get_item_alias(item, **kwargs)

def get_item_configuration(item : Union[int, str], **kwargs) -> dict:
	"""	 Returns an item's configuration.

	Args:
		item (Union[int, str]): 
	Returns:
		dict
	"""

	return internal_dpg.get_item_configuration(item, **kwargs)

def get_item_info(item : Union[int, str], **kwargs) -> dict:
	"""	 Returns an item's information.

	Args:
		item (Union[int, str]): 
	Returns:
		dict
	"""

	return internal_dpg.get_item_info(item, **kwargs)

def get_item_state(item : Union[int, str], **kwargs) -> dict:
	"""	 Returns an item's state.

	Args:
		item (Union[int, str]): 
	Returns:
		dict
	"""

	return internal_dpg.get_item_state(item, **kwargs)

def get_item_types(**kwargs) -> dict:
	"""	 Returns an item types.

	Args:
	Returns:
		dict
	"""

	return internal_dpg.get_item_types(**kwargs)

def get_mouse_drag_delta(**kwargs) -> float:
	"""	 Returns mouse drag delta.

	Args:
	Returns:
		float
	"""

	return internal_dpg.get_mouse_drag_delta(**kwargs)

def get_mouse_pos(*, local: bool =True, **kwargs) -> Union[List[int], Tuple[int, ...]]:
	"""	 Returns mouse position.

	Args:
		local (bool, optional): 
	Returns:
		Union[List[int], Tuple[int, ...]]
	"""

	return internal_dpg.get_mouse_pos(local=local, **kwargs)

def get_platform(**kwargs) -> int:
	"""	 New in 1.6. Returns platform constant.

	Args:
	Returns:
		int
	"""

	return internal_dpg.get_platform(**kwargs)

def get_plot_mouse_pos(**kwargs) -> Union[List[int], Tuple[int, ...]]:
	"""	 Returns mouse position in plot.

	Args:
	Returns:
		Union[List[int], Tuple[int, ...]]
	"""

	return internal_dpg.get_plot_mouse_pos(**kwargs)

def get_plot_query_rects(plot : Union[int, str], **kwargs) -> List[List[float]]:
	"""	 Returns the query rects of the plot. Returns an array of array containing the top-left coordinates and bottom-right coordinates of the plot area.

	Args:
		plot (Union[int, str]): 
	Returns:
		List[List[float]]
	"""

	return internal_dpg.get_plot_query_rects(plot, **kwargs)

def get_selected_links(node_editor : Union[int, str], **kwargs) -> List[List[str]]:
	"""	 Returns a node editor's selected links.

	Args:
		node_editor (Union[int, str]): 
	Returns:
		List[List[str]]
	"""

	return internal_dpg.get_selected_links(node_editor, **kwargs)

def get_selected_nodes(node_editor : Union[int, str], **kwargs) -> Union[List[int], Tuple[int, ...]]:
	"""	 Returns a node editor's selected nodes.

	Args:
		node_editor (Union[int, str]): 
	Returns:
		Union[List[int], Tuple[int, ...]]
	"""

	return internal_dpg.get_selected_nodes(node_editor, **kwargs)

def get_text_size(text : str, *, wrap_width: float =-1.0, font: Union[int, str] =0, **kwargs) -> Union[List[float], Tuple[float, ...]]:
	"""	 Returns width/height of text with specified font (must occur after 1st frame).

	Args:
		text (str): 
		wrap_width (float, optional): Wrap width to use (-1.0 turns wrap off).
		font (Union[int, str], optional): Font to use.
	Returns:
		Union[List[float], Tuple[float, ...]]
	"""

	return internal_dpg.get_text_size(text, wrap_width=wrap_width, font=font, **kwargs)

def get_total_time(**kwargs) -> float:
	"""	 Returns total time since Dear PyGui has started.

	Args:
	Returns:
		float
	"""

	return internal_dpg.get_total_time(**kwargs)

def get_value(item : Union[int, str], **kwargs) -> Any:
	"""	 Returns an item's value.

	Args:
		item (Union[int, str]): 
	Returns:
		Any
	"""

	return internal_dpg.get_value(item, **kwargs)

def get_values(items : Union[List[int], Tuple[int, ...]], **kwargs) -> Any:
	"""	 Returns values of a list of items.

	Args:
		items (Union[List[int], Tuple[int, ...]]): 
	Returns:
		Any
	"""

	return internal_dpg.get_values(items, **kwargs)

def get_viewport_configuration(item : Union[int, str], **kwargs) -> dict:
	"""	 Returns a viewport's configuration.

	Args:
		item (Union[int, str]): 
	Returns:
		dict
	"""

	return internal_dpg.get_viewport_configuration(item, **kwargs)

def get_windows(**kwargs) -> Union[List[int], Tuple[int, ...]]:
	"""	 Returns all windows.

	Args:
	Returns:
		Union[List[int], Tuple[int, ...]]
	"""

	return internal_dpg.get_windows(**kwargs)

def get_x_scroll(item : Union[int, str], **kwargs) -> float:
	"""	 Undocumented

	Args:
		item (Union[int, str]): 
	Returns:
		float
	"""

	return internal_dpg.get_x_scroll(item, **kwargs)

def get_x_scroll_max(item : Union[int, str], **kwargs) -> float:
	"""	 Undocumented

	Args:
		item (Union[int, str]): 
	Returns:
		float
	"""

	return internal_dpg.get_x_scroll_max(item, **kwargs)

def get_y_scroll(item : Union[int, str], **kwargs) -> float:
	"""	 Undocumented

	Args:
		item (Union[int, str]): 
	Returns:
		float
	"""

	return internal_dpg.get_y_scroll(item, **kwargs)

def get_y_scroll_max(item : Union[int, str], **kwargs) -> float:
	"""	 Undocumented

	Args:
		item (Union[int, str]): 
	Returns:
		float
	"""

	return internal_dpg.get_y_scroll_max(item, **kwargs)

def highlight_table_cell(table : Union[int, str], row : int, column : int, color : Union[List[int], Tuple[int, ...]], **kwargs) -> None:
	"""	 Highlight specified table cell.

	Args:
		table (Union[int, str]): 
		row (int): 
		column (int): 
		color (Union[List[int], Tuple[int, ...]]): 
	Returns:
		None
	"""

	return internal_dpg.highlight_table_cell(table, row, column, color, **kwargs)

def highlight_table_column(table : Union[int, str], column : int, color : Union[List[int], Tuple[int, ...]], **kwargs) -> None:
	"""	 Highlight specified table column.

	Args:
		table (Union[int, str]): 
		column (int): 
		color (Union[List[int], Tuple[int, ...]]): 
	Returns:
		None
	"""

	return internal_dpg.highlight_table_column(table, column, color, **kwargs)

def highlight_table_row(table : Union[int, str], row : int, color : Union[List[int], Tuple[int, ...]], **kwargs) -> None:
	"""	 Highlight specified table row.

	Args:
		table (Union[int, str]): 
		row (int): 
		color (Union[List[int], Tuple[int, ...]]): 
	Returns:
		None
	"""

	return internal_dpg.highlight_table_row(table, row, color, **kwargs)

def is_dearpygui_running(**kwargs) -> bool:
	"""	 Checks if Dear PyGui is running

	Args:
	Returns:
		bool
	"""

	return internal_dpg.is_dearpygui_running(**kwargs)

def is_key_down(key : int, **kwargs) -> bool:
	"""	 Checks if key is down.

	Args:
		key (int): 
	Returns:
		bool
	"""

	return internal_dpg.is_key_down(key, **kwargs)

def is_key_pressed(key : int, **kwargs) -> bool:
	"""	 Checks if key is pressed.

	Args:
		key (int): 
	Returns:
		bool
	"""

	return internal_dpg.is_key_pressed(key, **kwargs)

def is_key_released(key : int, **kwargs) -> bool:
	"""	 Checks if key is released.

	Args:
		key (int): 
	Returns:
		bool
	"""

	return internal_dpg.is_key_released(key, **kwargs)

def is_mouse_button_clicked(button : int, **kwargs) -> bool:
	"""	 Checks if mouse button is clicked.

	Args:
		button (int): 
	Returns:
		bool
	"""

	return internal_dpg.is_mouse_button_clicked(button, **kwargs)

def is_mouse_button_double_clicked(button : int, **kwargs) -> bool:
	"""	 Checks if mouse button is double clicked.

	Args:
		button (int): 
	Returns:
		bool
	"""

	return internal_dpg.is_mouse_button_double_clicked(button, **kwargs)

def is_mouse_button_down(button : int, **kwargs) -> bool:
	"""	 Checks if mouse button is down.

	Args:
		button (int): 
	Returns:
		bool
	"""

	return internal_dpg.is_mouse_button_down(button, **kwargs)

def is_mouse_button_dragging(button : int, threshold : float, **kwargs) -> bool:
	"""	 Checks if mouse button is down and dragging.

	Args:
		button (int): 
		threshold (float): 
	Returns:
		bool
	"""

	return internal_dpg.is_mouse_button_dragging(button, threshold, **kwargs)

def is_mouse_button_released(button : int, **kwargs) -> bool:
	"""	 Checks if mouse button is released.

	Args:
		button (int): 
	Returns:
		bool
	"""

	return internal_dpg.is_mouse_button_released(button, **kwargs)

def is_table_cell_highlighted(table : Union[int, str], row : int, column : int, **kwargs) -> bool:
	"""	 Checks if a table cell is highlighted.

	Args:
		table (Union[int, str]): 
		row (int): 
		column (int): 
	Returns:
		bool
	"""

	return internal_dpg.is_table_cell_highlighted(table, row, column, **kwargs)

def is_table_column_highlighted(table : Union[int, str], column : int, **kwargs) -> bool:
	"""	 Checks if a table column is highlighted.

	Args:
		table (Union[int, str]): 
		column (int): 
	Returns:
		bool
	"""

	return internal_dpg.is_table_column_highlighted(table, column, **kwargs)

def is_table_row_highlighted(table : Union[int, str], row : int, **kwargs) -> bool:
	"""	 Checks if a table row is highlighted.

	Args:
		table (Union[int, str]): 
		row (int): 
	Returns:
		bool
	"""

	return internal_dpg.is_table_row_highlighted(table, row, **kwargs)

def is_viewport_ok(**kwargs) -> bool:
	"""	 Checks if a viewport has been created and shown.

	Args:
	Returns:
		bool
	"""

	return internal_dpg.is_viewport_ok(**kwargs)

def last_container(**kwargs) -> Union[int, str]:
	"""	 Returns the last container item added.

	Args:
	Returns:
		Union[int, str]
	"""

	return internal_dpg.last_container(**kwargs)

def last_item(**kwargs) -> Union[int, str]:
	"""	 Returns the last item added.

	Args:
	Returns:
		Union[int, str]
	"""

	return internal_dpg.last_item(**kwargs)

def last_root(**kwargs) -> Union[int, str]:
	"""	 Returns the last root added (registry or window).

	Args:
	Returns:
		Union[int, str]
	"""

	return internal_dpg.last_root(**kwargs)

def load_image(file : str, *, gamma: float =1.0, gamma_scale_factor: float =1.0, **kwargs) -> Any:
	"""	 Loads an image. Returns width, height, channels, mvBuffer

	Args:
		file (str): 
		gamma (float, optional): Gamma correction factor. (default is 1.0 to avoid automatic gamma correction on loading.
		gamma_scale_factor (float, optional): Gamma scale factor.
	Returns:
		Any
	"""

	return internal_dpg.load_image(file, gamma=gamma, gamma_scale_factor=gamma_scale_factor, **kwargs)

def lock_mutex(**kwargs) -> None:
	"""	 Locks render thread mutex.

	Args:
	Returns:
		None
	"""

	return internal_dpg.lock_mutex(**kwargs)

def maximize_viewport(**kwargs) -> None:
	"""	 Maximizes the viewport.

	Args:
	Returns:
		None
	"""

	return internal_dpg.maximize_viewport(**kwargs)

def minimize_viewport(**kwargs) -> None:
	"""	 Minimizes a viewport.

	Args:
	Returns:
		None
	"""

	return internal_dpg.minimize_viewport(**kwargs)

def move_item(item : Union[int, str], *, parent: Union[int, str] =0, before: Union[int, str] =0, **kwargs) -> None:
	"""	 Moves an item to a new location.

	Args:
		item (Union[int, str]): 
		parent (Union[int, str], optional): 
		before (Union[int, str], optional): 
	Returns:
		None
	"""

	return internal_dpg.move_item(item, parent=parent, before=before, **kwargs)

def move_item_down(item : Union[int, str], **kwargs) -> None:
	"""	 Moves an item down.

	Args:
		item (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.move_item_down(item, **kwargs)

def move_item_up(item : Union[int, str], **kwargs) -> None:
	"""	 Moves an item up.

	Args:
		item (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.move_item_up(item, **kwargs)

def output_frame_buffer(file : str ='', *, callback: Callable =None, **kwargs) -> Any:
	"""	 Outputs frame buffer as a png if file is specified or through the second argument of a callback if specified. Render loop must have been started.

	Args:
		file (str, optional): 
		callback (Callable, optional): Callback will return framebuffer as an array through the second arg.
	Returns:
		Any
	"""

	return internal_dpg.output_frame_buffer(file, callback=callback, **kwargs)

def pop_container_stack(**kwargs) -> Union[int, str]:
	"""	 Pops the top item off the parent stack and return its ID.

	Args:
	Returns:
		Union[int, str]
	"""

	return internal_dpg.pop_container_stack(**kwargs)

def push_container_stack(item : Union[int, str], **kwargs) -> bool:
	"""	 Pushes an item onto the container stack.

	Args:
		item (Union[int, str]): 
	Returns:
		bool
	"""

	return internal_dpg.push_container_stack(item, **kwargs)

def remove_alias(alias : str, **kwargs) -> None:
	"""	 Removes an alias.

	Args:
		alias (str): 
	Returns:
		None
	"""

	return internal_dpg.remove_alias(alias, **kwargs)

def render_dearpygui_frame(**kwargs) -> None:
	"""	 Render a single Dear PyGui frame.

	Args:
	Returns:
		None
	"""

	return internal_dpg.render_dearpygui_frame(**kwargs)

def reorder_items(container : Union[int, str], slot : int, new_order : Union[List[int], Tuple[int, ...]], **kwargs) -> None:
	"""	 Reorders an item's children.

	Args:
		container (Union[int, str]): 
		slot (int): 
		new_order (Union[List[int], Tuple[int, ...]]): 
	Returns:
		None
	"""

	return internal_dpg.reorder_items(container, slot, new_order, **kwargs)

def reset_axis_limits_constraints(axis : Union[int, str], **kwargs) -> None:
	"""	 Remove an axis' limits constraints

	Args:
		axis (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.reset_axis_limits_constraints(axis, **kwargs)

def reset_axis_ticks(axis : Union[int, str], **kwargs) -> None:
	"""	 Removes the manually set axis ticks and applies the default axis ticks

	Args:
		axis (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.reset_axis_ticks(axis, **kwargs)

def reset_axis_zoom_constraints(axis : Union[int, str], **kwargs) -> None:
	"""	 Remove an axis' zoom constraints

	Args:
		axis (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.reset_axis_zoom_constraints(axis, **kwargs)

def reset_pos(item : Union[int, str], **kwargs) -> None:
	"""	 Resets an item's position after using 'set_item_pos'.

	Args:
		item (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.reset_pos(item, **kwargs)

def sample_colormap(colormap : Union[int, str], t : float, **kwargs) -> Union[List[int], Tuple[int, ...]]:
	"""	 Returns a color from a colormap given t between 0.0-1.0.

	Args:
		colormap (Union[int, str]): The colormap tag. This should come from a colormap that was added to a colormap registry. Built in color maps are accessible through their corresponding constants mvPlotColormap_Twilight, mvPlotColormap_***
		t (float): Value of the colormap to sample between 0.0-1.0
	Returns:
		Union[List[int], Tuple[int, ...]]
	"""

	return internal_dpg.sample_colormap(colormap, t, **kwargs)

def save_image(file : str, width : int, height : int, data : Any, *, components: int =4, quality: int =50, **kwargs) -> None:
	"""	 Saves an image. Possible formats: png, bmp, tga, hdr, jpg.

	Args:
		file (str): 
		width (int): 
		height (int): 
		data (Any): 
		components (int, optional): Number of components (1-4). Default of 4.
		quality (int, optional): Stride in bytes (only used for jpg).
	Returns:
		None
	"""

	return internal_dpg.save_image(file, width, height, data, components=components, quality=quality, **kwargs)

def save_init_file(file : str, **kwargs) -> None:
	"""	 Save dpg.ini file.

	Args:
		file (str): 
	Returns:
		None
	"""

	return internal_dpg.save_init_file(file, **kwargs)

def set_axis_limits(axis : Union[int, str], ymin : float, ymax : float, **kwargs) -> None:
	"""	 Sets limits on the axis for pan and zoom.

	Args:
		axis (Union[int, str]): 
		ymin (float): 
		ymax (float): 
	Returns:
		None
	"""

	return internal_dpg.set_axis_limits(axis, ymin, ymax, **kwargs)

def set_axis_limits_auto(axis : Union[int, str], **kwargs) -> None:
	"""	 Removes all limits on specified axis.

	Args:
		axis (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.set_axis_limits_auto(axis, **kwargs)

def set_axis_limits_constraints(axis : Union[int, str], vmin : float, vmax : float, **kwargs) -> None:
	"""	 Sets an axis' limits constraints so that users can't pan beyond a min or max value

	Args:
		axis (Union[int, str]): 
		vmin (float): 
		vmax (float): 
	Returns:
		None
	"""

	return internal_dpg.set_axis_limits_constraints(axis, vmin, vmax, **kwargs)

def set_axis_ticks(axis : Union[int, str], label_pairs : Any, **kwargs) -> None:
	"""	 Replaces axis ticks with 'label_pairs' argument.

	Args:
		axis (Union[int, str]): 
		label_pairs (Any): Tuples of label and value in the form '((label, axis_value), (label, axis_value), ...)'
	Returns:
		None
	"""

	return internal_dpg.set_axis_ticks(axis, label_pairs, **kwargs)

def set_axis_zoom_constraints(axis : Union[int, str], vmin : float, vmax : float, **kwargs) -> None:
	"""	 Sets an axis' zoom constraints so that users can't zoom beyond a min or max value

	Args:
		axis (Union[int, str]): 
		vmin (float): 
		vmax (float): 
	Returns:
		None
	"""

	return internal_dpg.set_axis_zoom_constraints(axis, vmin, vmax, **kwargs)

def set_clip_space(item : Union[int, str], top_left_x : float, top_left_y : float, width : float, height : float, min_depth : float, max_depth : float, **kwargs) -> None:
	"""	 New in 1.1. Set the clip space for depth clipping and 'viewport' transformation.

	Args:
		item (Union[int, str]): draw layer to set clip space
		top_left_x (float): angle to rotate
		top_left_y (float): angle to rotate
		width (float): angle to rotate
		height (float): angle to rotate
		min_depth (float): angle to rotate
		max_depth (float): angle to rotate
	Returns:
		None
	"""

	return internal_dpg.set_clip_space(item, top_left_x, top_left_y, width, height, min_depth, max_depth, **kwargs)

def set_clipboard_text(text : str, **kwargs) -> None:
	"""	 New in 1.3. Sets the clipboard text.

	Args:
		text (str): 
	Returns:
		None
	"""

	return internal_dpg.set_clipboard_text(text, **kwargs)

def set_exit_callback(callback : Callable, *, user_data: Any =None, **kwargs) -> str:
	"""	 Sets a callback to run on last frame.

	Args:
		callback (Callable): 
		user_data (Any, optional): New in 1.3. Optional user data to send to the callback
	Returns:
		str
	"""

	return internal_dpg.set_exit_callback(callback, user_data=user_data, **kwargs)

def set_frame_callback(frame : int, callback : Callable, *, user_data: Any =None, **kwargs) -> str:
	"""	 Sets a callback to run on first frame.

	Args:
		frame (int): 
		callback (Callable): 
		user_data (Any, optional): New in 1.3. Optional user data to send to the callback
	Returns:
		str
	"""

	return internal_dpg.set_frame_callback(frame, callback, user_data=user_data, **kwargs)

def set_global_font_scale(scale : float, **kwargs) -> None:
	"""	 Sets global font scale.

	Args:
		scale (float): 
	Returns:
		None
	"""

	return internal_dpg.set_global_font_scale(scale, **kwargs)

def set_item_alias(item : Union[int, str], alias : str, **kwargs) -> None:
	"""	 Sets an item's alias.

	Args:
		item (Union[int, str]): 
		alias (str): 
	Returns:
		None
	"""

	return internal_dpg.set_item_alias(item, alias, **kwargs)

def set_item_children(item : Union[int, str], source : Union[int, str], slot : int, **kwargs) -> None:
	"""	 Sets an item's children.

	Args:
		item (Union[int, str]): 
		source (Union[int, str]): 
		slot (int): 
	Returns:
		None
	"""

	return internal_dpg.set_item_children(item, source, slot, **kwargs)

def set_primary_window(window : Union[int, str], value : bool, **kwargs) -> None:
	"""	 Sets the primary window.

	Args:
		window (Union[int, str]): 
		value (bool): 
	Returns:
		None
	"""

	return internal_dpg.set_primary_window(window, value, **kwargs)

def set_table_row_color(table : Union[int, str], row : int, color : Union[List[int], Tuple[int, ...]], **kwargs) -> None:
	"""	 Set table row color.

	Args:
		table (Union[int, str]): 
		row (int): 
		color (Union[List[int], Tuple[int, ...]]): 
	Returns:
		None
	"""

	return internal_dpg.set_table_row_color(table, row, color, **kwargs)

def set_value(item : Union[int, str], value : Any, **kwargs) -> None:
	"""	 Set's an item's value.

	Args:
		item (Union[int, str]): 
		value (Any): 
	Returns:
		None
	"""

	return internal_dpg.set_value(item, value, **kwargs)

def set_viewport_resize_callback(callback : Callable, *, user_data: Any =None, **kwargs) -> str:
	"""	 Sets a callback to run on viewport resize.

	Args:
		callback (Callable): 
		user_data (Any, optional): New in 1.3. Optional user data to send to the callback
	Returns:
		str
	"""

	return internal_dpg.set_viewport_resize_callback(callback, user_data=user_data, **kwargs)

def set_x_scroll(item : Union[int, str], value : float, *, when: int =internal_dpg.mvSetScrollFlags_Delayed, **kwargs) -> None:
	"""	 Sets horizontal scroll position.

	Args:
		item (Union[int, str]): 
		value (float): Scroll position
		when (int, optional): Specifies whether the scroll position will be set in the nearest frame (mvSetScrollFlags_Now) or with a 1-frame delay (mvSetScrollFlags_Delayed).  The former prevents flickering, the latter works better if contents change in the same frame as when set_x_scroll called.  mvSetScrollFlags_Both can also be used to set the position twice.
	Returns:
		None
	"""

	return internal_dpg.set_x_scroll(item, value, when=when, **kwargs)

def set_y_scroll(item : Union[int, str], value : float, *, when: int =internal_dpg.mvSetScrollFlags_Delayed, **kwargs) -> None:
	"""	 Sets vertical scroll position.

	Args:
		item (Union[int, str]): 
		value (float): Scroll position
		when (int, optional): Specifies whether the scroll position will be set in the nearest frame (mvSetScrollFlags_Now) or with a 1-frame delay (mvSetScrollFlags_Delayed).  The former prevents flickering, the latter works better if contents change in the same frame as when set_x_scroll called.  mvSetScrollFlags_Both can also be used to set the position twice.
	Returns:
		None
	"""

	return internal_dpg.set_y_scroll(item, value, when=when, **kwargs)

def setup_dearpygui(**kwargs) -> None:
	"""	 Sets up Dear PyGui

	Args:
		viewport (Union[int, str], optional): (deprecated) 
	Returns:
		None
	"""

	if 'viewport' in kwargs.keys():

		warnings.warn('viewport keyword removed', DeprecationWarning, 2)

		kwargs.pop('viewport', None)

	return internal_dpg.setup_dearpygui(**kwargs)

def show_imgui_demo(**kwargs) -> None:
	"""	 Shows the imgui demo.

	Args:
	Returns:
		None
	"""

	return internal_dpg.show_imgui_demo(**kwargs)

def show_implot_demo(**kwargs) -> None:
	"""	 Shows the implot demo.

	Args:
	Returns:
		None
	"""

	return internal_dpg.show_implot_demo(**kwargs)

def show_item_debug(item : Union[int, str], **kwargs) -> None:
	"""	 Shows an item's debug window

	Args:
		item (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.show_item_debug(item, **kwargs)

def show_tool(tool : Union[int, str], **kwargs) -> str:
	"""	 Shows a built in tool.

	Args:
		tool (Union[int, str]): 
	Returns:
		str
	"""

	return internal_dpg.show_tool(tool, **kwargs)

def show_viewport(*, minimized: bool =False, maximized: bool =False, **kwargs) -> None:
	"""	 Shows the main viewport.

	Args:
		minimized (bool, optional): Sets the state of the viewport to minimized
		maximized (bool, optional): Sets the state of the viewport to maximized
		viewport (Union[int, str], optional): (deprecated) 
	Returns:
		None
	"""

	if 'viewport' in kwargs.keys():

		warnings.warn('viewport keyword removed', DeprecationWarning, 2)

		kwargs.pop('viewport', None)

	return internal_dpg.show_viewport(minimized=minimized, maximized=maximized, **kwargs)

def split_frame(**kwargs) -> None:
	"""	 Waits one frame.

	Args:
		delay (int, optional): (deprecated) Do not use it anymore, it has no effect.
	Returns:
		None
	"""

	if 'delay' in kwargs.keys():

		warnings.warn('delay keyword removed', DeprecationWarning, 2)

		kwargs.pop('delay', None)

	return internal_dpg.split_frame(**kwargs)

def stop_dearpygui(**kwargs) -> None:
	"""	 Stops Dear PyGui

	Args:
	Returns:
		None
	"""

	return internal_dpg.stop_dearpygui(**kwargs)

def toggle_viewport_fullscreen(**kwargs) -> None:
	"""	 Toggle viewport fullscreen mode..

	Args:
	Returns:
		None
	"""

	return internal_dpg.toggle_viewport_fullscreen(**kwargs)

def top_container_stack(**kwargs) -> Union[int, str]:
	"""	 Returns the item on the top of the container stack.

	Args:
	Returns:
		Union[int, str]
	"""

	return internal_dpg.top_container_stack(**kwargs)

def unhighlight_table_cell(table : Union[int, str], row : int, column : int, **kwargs) -> None:
	"""	 Unhighlight specified table cell.

	Args:
		table (Union[int, str]): 
		row (int): 
		column (int): 
	Returns:
		None
	"""

	return internal_dpg.unhighlight_table_cell(table, row, column, **kwargs)

def unhighlight_table_column(table : Union[int, str], column : int, **kwargs) -> None:
	"""	 Unhighlight specified table column.

	Args:
		table (Union[int, str]): 
		column (int): 
	Returns:
		None
	"""

	return internal_dpg.unhighlight_table_column(table, column, **kwargs)

def unhighlight_table_row(table : Union[int, str], row : int, **kwargs) -> None:
	"""	 Unhighlight specified table row.

	Args:
		table (Union[int, str]): 
		row (int): 
	Returns:
		None
	"""

	return internal_dpg.unhighlight_table_row(table, row, **kwargs)

def unlock_mutex(**kwargs) -> None:
	"""	 Unlocks render thread mutex

	Args:
	Returns:
		None
	"""

	return internal_dpg.unlock_mutex(**kwargs)

def unset_table_row_color(table : Union[int, str], row : int, **kwargs) -> None:
	"""	 Remove user set table row color.

	Args:
		table (Union[int, str]): 
		row (int): 
	Returns:
		None
	"""

	return internal_dpg.unset_table_row_color(table, row, **kwargs)

def unstage(item : Union[int, str], **kwargs) -> None:
	"""	 Unstages an item.

	Args:
		item (Union[int, str]): 
	Returns:
		None
	"""

	return internal_dpg.unstage(item, **kwargs)


##########################################################
# Constants #
##########################################################

mvGraphicsBackend_D3D11=internal_dpg.mvGraphicsBackend_D3D11
mvGraphicsBackend_D3D12=internal_dpg.mvGraphicsBackend_D3D12
mvGraphicsBackend_VULKAN=internal_dpg.mvGraphicsBackend_VULKAN
mvGraphicsBackend_METAL=internal_dpg.mvGraphicsBackend_METAL
mvGraphicsBackend_OPENGL=internal_dpg.mvGraphicsBackend_OPENGL
mvMouseButton_Left=internal_dpg.mvMouseButton_Left
mvMouseButton_Right=internal_dpg.mvMouseButton_Right
mvMouseButton_Middle=internal_dpg.mvMouseButton_Middle
mvMouseButton_X1=internal_dpg.mvMouseButton_X1
mvMouseButton_X2=internal_dpg.mvMouseButton_X2
mvKey_ModDisabled=internal_dpg.mvKey_ModDisabled
mvKey_None=internal_dpg.mvKey_None
mvKey_0=internal_dpg.mvKey_0
mvKey_1=internal_dpg.mvKey_1
mvKey_2=internal_dpg.mvKey_2
mvKey_3=internal_dpg.mvKey_3
mvKey_4=internal_dpg.mvKey_4
mvKey_5=internal_dpg.mvKey_5
mvKey_6=internal_dpg.mvKey_6
mvKey_7=internal_dpg.mvKey_7
mvKey_8=internal_dpg.mvKey_8
mvKey_9=internal_dpg.mvKey_9
mvKey_A=internal_dpg.mvKey_A
mvKey_B=internal_dpg.mvKey_B
mvKey_C=internal_dpg.mvKey_C
mvKey_D=internal_dpg.mvKey_D
mvKey_E=internal_dpg.mvKey_E
mvKey_F=internal_dpg.mvKey_F
mvKey_G=internal_dpg.mvKey_G
mvKey_H=internal_dpg.mvKey_H
mvKey_I=internal_dpg.mvKey_I
mvKey_J=internal_dpg.mvKey_J
mvKey_K=internal_dpg.mvKey_K
mvKey_L=internal_dpg.mvKey_L
mvKey_M=internal_dpg.mvKey_M
mvKey_N=internal_dpg.mvKey_N
mvKey_O=internal_dpg.mvKey_O
mvKey_P=internal_dpg.mvKey_P
mvKey_Q=internal_dpg.mvKey_Q
mvKey_R=internal_dpg.mvKey_R
mvKey_S=internal_dpg.mvKey_S
mvKey_T=internal_dpg.mvKey_T
mvKey_U=internal_dpg.mvKey_U
mvKey_V=internal_dpg.mvKey_V
mvKey_W=internal_dpg.mvKey_W
mvKey_X=internal_dpg.mvKey_X
mvKey_Y=internal_dpg.mvKey_Y
mvKey_Z=internal_dpg.mvKey_Z
mvKey_Back=internal_dpg.mvKey_Back
mvKey_Tab=internal_dpg.mvKey_Tab
mvKey_Return=internal_dpg.mvKey_Return
mvKey_LShift=internal_dpg.mvKey_LShift
mvKey_RShift=internal_dpg.mvKey_RShift
mvKey_LControl=internal_dpg.mvKey_LControl
mvKey_RControl=internal_dpg.mvKey_RControl
mvKey_LAlt=internal_dpg.mvKey_LAlt
mvKey_RAlt=internal_dpg.mvKey_RAlt
mvKey_Pause=internal_dpg.mvKey_Pause
mvKey_CapsLock=internal_dpg.mvKey_CapsLock
mvKey_Escape=internal_dpg.mvKey_Escape
mvKey_Spacebar=internal_dpg.mvKey_Spacebar
mvKey_End=internal_dpg.mvKey_End
mvKey_Home=internal_dpg.mvKey_Home
mvKey_Left=internal_dpg.mvKey_Left
mvKey_Up=internal_dpg.mvKey_Up
mvKey_Right=internal_dpg.mvKey_Right
mvKey_Down=internal_dpg.mvKey_Down
mvKey_Print=internal_dpg.mvKey_Print
mvKey_Insert=internal_dpg.mvKey_Insert
mvKey_Delete=internal_dpg.mvKey_Delete
mvKey_NumPad0=internal_dpg.mvKey_NumPad0
mvKey_NumPad1=internal_dpg.mvKey_NumPad1
mvKey_NumPad2=internal_dpg.mvKey_NumPad2
mvKey_NumPad3=internal_dpg.mvKey_NumPad3
mvKey_NumPad4=internal_dpg.mvKey_NumPad4
mvKey_NumPad5=internal_dpg.mvKey_NumPad5
mvKey_NumPad6=internal_dpg.mvKey_NumPad6
mvKey_NumPad7=internal_dpg.mvKey_NumPad7
mvKey_NumPad8=internal_dpg.mvKey_NumPad8
mvKey_NumPad9=internal_dpg.mvKey_NumPad9
mvKey_NumPadEnter=internal_dpg.mvKey_NumPadEnter
mvKey_NumPadEqual=internal_dpg.mvKey_NumPadEqual
mvKey_Subtract=internal_dpg.mvKey_Subtract
mvKey_Decimal=internal_dpg.mvKey_Decimal
mvKey_Divide=internal_dpg.mvKey_Divide
mvKey_Multiply=internal_dpg.mvKey_Multiply
mvKey_Add=internal_dpg.mvKey_Add
mvKey_F1=internal_dpg.mvKey_F1
mvKey_F2=internal_dpg.mvKey_F2
mvKey_F3=internal_dpg.mvKey_F3
mvKey_F4=internal_dpg.mvKey_F4
mvKey_F5=internal_dpg.mvKey_F5
mvKey_F6=internal_dpg.mvKey_F6
mvKey_F7=internal_dpg.mvKey_F7
mvKey_F8=internal_dpg.mvKey_F8
mvKey_F9=internal_dpg.mvKey_F9
mvKey_F10=internal_dpg.mvKey_F10
mvKey_F11=internal_dpg.mvKey_F11
mvKey_F12=internal_dpg.mvKey_F12
mvKey_F13=internal_dpg.mvKey_F13
mvKey_F14=internal_dpg.mvKey_F14
mvKey_F15=internal_dpg.mvKey_F15
mvKey_F16=internal_dpg.mvKey_F16
mvKey_F17=internal_dpg.mvKey_F17
mvKey_F18=internal_dpg.mvKey_F18
mvKey_F19=internal_dpg.mvKey_F19
mvKey_F20=internal_dpg.mvKey_F20
mvKey_F21=internal_dpg.mvKey_F21
mvKey_F22=internal_dpg.mvKey_F22
mvKey_F23=internal_dpg.mvKey_F23
mvKey_F24=internal_dpg.mvKey_F24
mvKey_NumLock=internal_dpg.mvKey_NumLock
mvKey_ScrollLock=internal_dpg.mvKey_ScrollLock
mvKey_Period=internal_dpg.mvKey_Period
mvKey_Slash=internal_dpg.mvKey_Slash
mvKey_Backslash=internal_dpg.mvKey_Backslash
mvKey_Open_Brace=internal_dpg.mvKey_Open_Brace
mvKey_Close_Brace=internal_dpg.mvKey_Close_Brace
mvKey_Browser_Back=internal_dpg.mvKey_Browser_Back
mvKey_Browser_Forward=internal_dpg.mvKey_Browser_Forward
mvKey_Comma=internal_dpg.mvKey_Comma
mvKey_Minus=internal_dpg.mvKey_Minus
mvKey_Menu=internal_dpg.mvKey_Menu
mvKey_ModSuper=internal_dpg.mvKey_ModSuper
mvKey_ModShift=internal_dpg.mvKey_ModShift
mvKey_ModAlt=internal_dpg.mvKey_ModAlt
mvKey_ModCtrl=internal_dpg.mvKey_ModCtrl
mvKey_Clear=internal_dpg.mvKey_Clear
mvKey_Prior=internal_dpg.mvKey_Prior
mvKey_Next=internal_dpg.mvKey_Next
mvKey_Select=internal_dpg.mvKey_Select
mvKey_Execute=internal_dpg.mvKey_Execute
mvKey_LWin=internal_dpg.mvKey_LWin
mvKey_RWin=internal_dpg.mvKey_RWin
mvKey_Apps=internal_dpg.mvKey_Apps
mvKey_Sleep=internal_dpg.mvKey_Sleep
mvKey_Help=internal_dpg.mvKey_Help
mvKey_Browser_Refresh=internal_dpg.mvKey_Browser_Refresh
mvKey_Browser_Stop=internal_dpg.mvKey_Browser_Stop
mvKey_Browser_Search=internal_dpg.mvKey_Browser_Search
mvKey_Browser_Favorites=internal_dpg.mvKey_Browser_Favorites
mvKey_Browser_Home=internal_dpg.mvKey_Browser_Home
mvKey_Volume_Mute=internal_dpg.mvKey_Volume_Mute
mvKey_Volume_Down=internal_dpg.mvKey_Volume_Down
mvKey_Volume_Up=internal_dpg.mvKey_Volume_Up
mvKey_Media_Next_Track=internal_dpg.mvKey_Media_Next_Track
mvKey_Media_Prev_Track=internal_dpg.mvKey_Media_Prev_Track
mvKey_Media_Stop=internal_dpg.mvKey_Media_Stop
mvKey_Media_Play_Pause=internal_dpg.mvKey_Media_Play_Pause
mvKey_Launch_Mail=internal_dpg.mvKey_Launch_Mail
mvKey_Launch_Media_Select=internal_dpg.mvKey_Launch_Media_Select
mvKey_Launch_App1=internal_dpg.mvKey_Launch_App1
mvKey_Launch_App2=internal_dpg.mvKey_Launch_App2
mvKey_Colon=internal_dpg.mvKey_Colon
mvKey_Plus=internal_dpg.mvKey_Plus
mvKey_Tilde=internal_dpg.mvKey_Tilde
mvKey_Quote=internal_dpg.mvKey_Quote
mvKey_F25=internal_dpg.mvKey_F25
mvAll=internal_dpg.mvAll
mvTool_About=internal_dpg.mvTool_About
mvTool_Debug=internal_dpg.mvTool_Debug
mvTool_Doc=internal_dpg.mvTool_Doc
mvTool_ItemRegistry=internal_dpg.mvTool_ItemRegistry
mvTool_Metrics=internal_dpg.mvTool_Metrics
mvTool_Stack=internal_dpg.mvTool_Stack
mvTool_Style=internal_dpg.mvTool_Style
mvTool_Font=internal_dpg.mvTool_Font
mvFontAtlas=internal_dpg.mvFontAtlas
mvAppUUID=internal_dpg.mvAppUUID
mvInvalidUUID=internal_dpg.mvInvalidUUID
mvDir_None=internal_dpg.mvDir_None
mvDir_Left=internal_dpg.mvDir_Left
mvDir_Right=internal_dpg.mvDir_Right
mvDir_Up=internal_dpg.mvDir_Up
mvDir_Down=internal_dpg.mvDir_Down
mvComboHeight_Small=internal_dpg.mvComboHeight_Small
mvComboHeight_Regular=internal_dpg.mvComboHeight_Regular
mvComboHeight_Large=internal_dpg.mvComboHeight_Large
mvComboHeight_Largest=internal_dpg.mvComboHeight_Largest
mvEventType_Off=internal_dpg.mvEventType_Off
mvEventType_Enter=internal_dpg.mvEventType_Enter
mvEventType_On=internal_dpg.mvEventType_On
mvEventType_Leave=internal_dpg.mvEventType_Leave
mvSetScrollFlags_Now=internal_dpg.mvSetScrollFlags_Now
mvSetScrollFlags_Delayed=internal_dpg.mvSetScrollFlags_Delayed
mvSetScrollFlags_Both=internal_dpg.mvSetScrollFlags_Both
mvScrollDirection_XAxis=internal_dpg.mvScrollDirection_XAxis
mvScrollDirection_YAxis=internal_dpg.mvScrollDirection_YAxis
mvScrollDirection_Horizontal=internal_dpg.mvScrollDirection_Horizontal
mvScrollDirection_Vertical=internal_dpg.mvScrollDirection_Vertical
mvPlatform_Windows=internal_dpg.mvPlatform_Windows
mvPlatform_Apple=internal_dpg.mvPlatform_Apple
mvPlatform_Linux=internal_dpg.mvPlatform_Linux
mvColorEdit_AlphaPreviewNone=internal_dpg.mvColorEdit_AlphaPreviewNone
mvColorEdit_AlphaPreview=internal_dpg.mvColorEdit_AlphaPreview
mvColorEdit_AlphaPreviewHalf=internal_dpg.mvColorEdit_AlphaPreviewHalf
mvColorEdit_uint8=internal_dpg.mvColorEdit_uint8
mvColorEdit_float=internal_dpg.mvColorEdit_float
mvColorEdit_rgb=internal_dpg.mvColorEdit_rgb
mvColorEdit_hsv=internal_dpg.mvColorEdit_hsv
mvColorEdit_hex=internal_dpg.mvColorEdit_hex
mvColorEdit_input_rgb=internal_dpg.mvColorEdit_input_rgb
mvColorEdit_input_hsv=internal_dpg.mvColorEdit_input_hsv
mvPlotColormap_Default=internal_dpg.mvPlotColormap_Default
mvPlotColormap_Deep=internal_dpg.mvPlotColormap_Deep
mvPlotColormap_Dark=internal_dpg.mvPlotColormap_Dark
mvPlotColormap_Pastel=internal_dpg.mvPlotColormap_Pastel
mvPlotColormap_Paired=internal_dpg.mvPlotColormap_Paired
mvPlotColormap_Viridis=internal_dpg.mvPlotColormap_Viridis
mvPlotColormap_Plasma=internal_dpg.mvPlotColormap_Plasma
mvPlotColormap_Hot=internal_dpg.mvPlotColormap_Hot
mvPlotColormap_Cool=internal_dpg.mvPlotColormap_Cool
mvPlotColormap_Pink=internal_dpg.mvPlotColormap_Pink
mvPlotColormap_Jet=internal_dpg.mvPlotColormap_Jet
mvPlotColormap_Twilight=internal_dpg.mvPlotColormap_Twilight
mvPlotColormap_RdBu=internal_dpg.mvPlotColormap_RdBu
mvPlotColormap_BrBG=internal_dpg.mvPlotColormap_BrBG
mvPlotColormap_PiYG=internal_dpg.mvPlotColormap_PiYG
mvPlotColormap_Spectral=internal_dpg.mvPlotColormap_Spectral
mvPlotColormap_Greys=internal_dpg.mvPlotColormap_Greys
mvColorPicker_bar=internal_dpg.mvColorPicker_bar
mvColorPicker_wheel=internal_dpg.mvColorPicker_wheel
mvTabOrder_Reorderable=internal_dpg.mvTabOrder_Reorderable
mvTabOrder_Fixed=internal_dpg.mvTabOrder_Fixed
mvTabOrder_Leading=internal_dpg.mvTabOrder_Leading
mvTabOrder_Trailing=internal_dpg.mvTabOrder_Trailing
mvTimeUnit_Us=internal_dpg.mvTimeUnit_Us
mvTimeUnit_Ms=internal_dpg.mvTimeUnit_Ms
mvTimeUnit_S=internal_dpg.mvTimeUnit_S
mvTimeUnit_Min=internal_dpg.mvTimeUnit_Min
mvTimeUnit_Hr=internal_dpg.mvTimeUnit_Hr
mvTimeUnit_Day=internal_dpg.mvTimeUnit_Day
mvTimeUnit_Mo=internal_dpg.mvTimeUnit_Mo
mvTimeUnit_Yr=internal_dpg.mvTimeUnit_Yr
mvDatePickerLevel_Day=internal_dpg.mvDatePickerLevel_Day
mvDatePickerLevel_Month=internal_dpg.mvDatePickerLevel_Month
mvDatePickerLevel_Year=internal_dpg.mvDatePickerLevel_Year
mvCullMode_None=internal_dpg.mvCullMode_None
mvCullMode_Back=internal_dpg.mvCullMode_Back
mvCullMode_Front=internal_dpg.mvCullMode_Front
mvFontRangeHint_Default=internal_dpg.mvFontRangeHint_Default
mvFontRangeHint_Japanese=internal_dpg.mvFontRangeHint_Japanese
mvFontRangeHint_Korean=internal_dpg.mvFontRangeHint_Korean
mvFontRangeHint_Chinese_Full=internal_dpg.mvFontRangeHint_Chinese_Full
mvFontRangeHint_Chinese_Simplified_Common=internal_dpg.mvFontRangeHint_Chinese_Simplified_Common
mvFontRangeHint_Cyrillic=internal_dpg.mvFontRangeHint_Cyrillic
mvFontRangeHint_Thai=internal_dpg.mvFontRangeHint_Thai
mvFontRangeHint_Vietnamese=internal_dpg.mvFontRangeHint_Vietnamese
mvNode_PinShape_Circle=internal_dpg.mvNode_PinShape_Circle
mvNode_PinShape_CircleFilled=internal_dpg.mvNode_PinShape_CircleFilled
mvNode_PinShape_Triangle=internal_dpg.mvNode_PinShape_Triangle
mvNode_PinShape_TriangleFilled=internal_dpg.mvNode_PinShape_TriangleFilled
mvNode_PinShape_Quad=internal_dpg.mvNode_PinShape_Quad
mvNode_PinShape_QuadFilled=internal_dpg.mvNode_PinShape_QuadFilled
mvNode_Attr_Input=internal_dpg.mvNode_Attr_Input
mvNode_Attr_Output=internal_dpg.mvNode_Attr_Output
mvNode_Attr_Static=internal_dpg.mvNode_Attr_Static
mvPlotBin_Sqrt=internal_dpg.mvPlotBin_Sqrt
mvPlotBin_Sturges=internal_dpg.mvPlotBin_Sturges
mvPlotBin_Rice=internal_dpg.mvPlotBin_Rice
mvPlotBin_Scott=internal_dpg.mvPlotBin_Scott
mvXAxis=internal_dpg.mvXAxis
mvXAxis2=internal_dpg.mvXAxis2
mvXAxis3=internal_dpg.mvXAxis3
mvYAxis=internal_dpg.mvYAxis
mvYAxis2=internal_dpg.mvYAxis2
mvYAxis3=internal_dpg.mvYAxis3
mvPlotScale_Linear=internal_dpg.mvPlotScale_Linear
mvPlotScale_Time=internal_dpg.mvPlotScale_Time
mvPlotScale_Log10=internal_dpg.mvPlotScale_Log10
mvPlotScale_SymLog=internal_dpg.mvPlotScale_SymLog
mvPlotMarker_None=internal_dpg.mvPlotMarker_None
mvPlotMarker_Circle=internal_dpg.mvPlotMarker_Circle
mvPlotMarker_Square=internal_dpg.mvPlotMarker_Square
mvPlotMarker_Diamond=internal_dpg.mvPlotMarker_Diamond
mvPlotMarker_Up=internal_dpg.mvPlotMarker_Up
mvPlotMarker_Down=internal_dpg.mvPlotMarker_Down
mvPlotMarker_Left=internal_dpg.mvPlotMarker_Left
mvPlotMarker_Right=internal_dpg.mvPlotMarker_Right
mvPlotMarker_Cross=internal_dpg.mvPlotMarker_Cross
mvPlotMarker_Plus=internal_dpg.mvPlotMarker_Plus
mvPlotMarker_Asterisk=internal_dpg.mvPlotMarker_Asterisk
mvPlot_Location_Center=internal_dpg.mvPlot_Location_Center
mvPlot_Location_North=internal_dpg.mvPlot_Location_North
mvPlot_Location_South=internal_dpg.mvPlot_Location_South
mvPlot_Location_West=internal_dpg.mvPlot_Location_West
mvPlot_Location_East=internal_dpg.mvPlot_Location_East
mvPlot_Location_NorthWest=internal_dpg.mvPlot_Location_NorthWest
mvPlot_Location_NorthEast=internal_dpg.mvPlot_Location_NorthEast
mvPlot_Location_SouthWest=internal_dpg.mvPlot_Location_SouthWest
mvPlot_Location_SouthEast=internal_dpg.mvPlot_Location_SouthEast
mvNodeMiniMap_Location_BottomLeft=internal_dpg.mvNodeMiniMap_Location_BottomLeft
mvNodeMiniMap_Location_BottomRight=internal_dpg.mvNodeMiniMap_Location_BottomRight
mvNodeMiniMap_Location_TopLeft=internal_dpg.mvNodeMiniMap_Location_TopLeft
mvNodeMiniMap_Location_TopRight=internal_dpg.mvNodeMiniMap_Location_TopRight
mvTable_SizingFixedFit=internal_dpg.mvTable_SizingFixedFit
mvTable_SizingFixedSame=internal_dpg.mvTable_SizingFixedSame
mvTable_SizingStretchProp=internal_dpg.mvTable_SizingStretchProp
mvTable_SizingStretchSame=internal_dpg.mvTable_SizingStretchSame
mvFormat_Float_rgba=internal_dpg.mvFormat_Float_rgba
mvFormat_Float_rgb=internal_dpg.mvFormat_Float_rgb
mvThemeCat_Core=internal_dpg.mvThemeCat_Core
mvThemeCat_Plots=internal_dpg.mvThemeCat_Plots
mvThemeCat_Nodes=internal_dpg.mvThemeCat_Nodes
mvThemeCol_Text=internal_dpg.mvThemeCol_Text
mvThemeCol_TextDisabled=internal_dpg.mvThemeCol_TextDisabled
mvThemeCol_WindowBg=internal_dpg.mvThemeCol_WindowBg
mvThemeCol_ChildBg=internal_dpg.mvThemeCol_ChildBg
mvThemeCol_Border=internal_dpg.mvThemeCol_Border
mvThemeCol_PopupBg=internal_dpg.mvThemeCol_PopupBg
mvThemeCol_BorderShadow=internal_dpg.mvThemeCol_BorderShadow
mvThemeCol_FrameBg=internal_dpg.mvThemeCol_FrameBg
mvThemeCol_FrameBgHovered=internal_dpg.mvThemeCol_FrameBgHovered
mvThemeCol_FrameBgActive=internal_dpg.mvThemeCol_FrameBgActive
mvThemeCol_TitleBg=internal_dpg.mvThemeCol_TitleBg
mvThemeCol_TitleBgActive=internal_dpg.mvThemeCol_TitleBgActive
mvThemeCol_TitleBgCollapsed=internal_dpg.mvThemeCol_TitleBgCollapsed
mvThemeCol_MenuBarBg=internal_dpg.mvThemeCol_MenuBarBg
mvThemeCol_ScrollbarBg=internal_dpg.mvThemeCol_ScrollbarBg
mvThemeCol_ScrollbarGrab=internal_dpg.mvThemeCol_ScrollbarGrab
mvThemeCol_ScrollbarGrabHovered=internal_dpg.mvThemeCol_ScrollbarGrabHovered
mvThemeCol_ScrollbarGrabActive=internal_dpg.mvThemeCol_ScrollbarGrabActive
mvThemeCol_CheckMark=internal_dpg.mvThemeCol_CheckMark
mvThemeCol_SliderGrab=internal_dpg.mvThemeCol_SliderGrab
mvThemeCol_SliderGrabActive=internal_dpg.mvThemeCol_SliderGrabActive
mvThemeCol_Button=internal_dpg.mvThemeCol_Button
mvThemeCol_ButtonHovered=internal_dpg.mvThemeCol_ButtonHovered
mvThemeCol_ButtonActive=internal_dpg.mvThemeCol_ButtonActive
mvThemeCol_Header=internal_dpg.mvThemeCol_Header
mvThemeCol_HeaderHovered=internal_dpg.mvThemeCol_HeaderHovered
mvThemeCol_HeaderActive=internal_dpg.mvThemeCol_HeaderActive
mvThemeCol_Separator=internal_dpg.mvThemeCol_Separator
mvThemeCol_SeparatorHovered=internal_dpg.mvThemeCol_SeparatorHovered
mvThemeCol_SeparatorActive=internal_dpg.mvThemeCol_SeparatorActive
mvThemeCol_ResizeGrip=internal_dpg.mvThemeCol_ResizeGrip
mvThemeCol_ResizeGripHovered=internal_dpg.mvThemeCol_ResizeGripHovered
mvThemeCol_ResizeGripActive=internal_dpg.mvThemeCol_ResizeGripActive
mvThemeCol_Tab=internal_dpg.mvThemeCol_Tab
mvThemeCol_TabHovered=internal_dpg.mvThemeCol_TabHovered
mvThemeCol_TabActive=internal_dpg.mvThemeCol_TabActive
mvThemeCol_TabUnfocused=internal_dpg.mvThemeCol_TabUnfocused
mvThemeCol_TabUnfocusedActive=internal_dpg.mvThemeCol_TabUnfocusedActive
mvThemeCol_DockingPreview=internal_dpg.mvThemeCol_DockingPreview
mvThemeCol_DockingEmptyBg=internal_dpg.mvThemeCol_DockingEmptyBg
mvThemeCol_PlotLines=internal_dpg.mvThemeCol_PlotLines
mvThemeCol_PlotLinesHovered=internal_dpg.mvThemeCol_PlotLinesHovered
mvThemeCol_PlotHistogram=internal_dpg.mvThemeCol_PlotHistogram
mvThemeCol_PlotHistogramHovered=internal_dpg.mvThemeCol_PlotHistogramHovered
mvThemeCol_TableHeaderBg=internal_dpg.mvThemeCol_TableHeaderBg
mvThemeCol_TableBorderStrong=internal_dpg.mvThemeCol_TableBorderStrong
mvThemeCol_TableBorderLight=internal_dpg.mvThemeCol_TableBorderLight
mvThemeCol_TableRowBg=internal_dpg.mvThemeCol_TableRowBg
mvThemeCol_TableRowBgAlt=internal_dpg.mvThemeCol_TableRowBgAlt
mvThemeCol_TextSelectedBg=internal_dpg.mvThemeCol_TextSelectedBg
mvThemeCol_DragDropTarget=internal_dpg.mvThemeCol_DragDropTarget
mvThemeCol_NavHighlight=internal_dpg.mvThemeCol_NavHighlight
mvThemeCol_NavWindowingHighlight=internal_dpg.mvThemeCol_NavWindowingHighlight
mvThemeCol_NavWindowingDimBg=internal_dpg.mvThemeCol_NavWindowingDimBg
mvThemeCol_ModalWindowDimBg=internal_dpg.mvThemeCol_ModalWindowDimBg
mvPlotCol_Line=internal_dpg.mvPlotCol_Line
mvPlotCol_Fill=internal_dpg.mvPlotCol_Fill
mvPlotCol_MarkerOutline=internal_dpg.mvPlotCol_MarkerOutline
mvPlotCol_MarkerFill=internal_dpg.mvPlotCol_MarkerFill
mvPlotCol_ErrorBar=internal_dpg.mvPlotCol_ErrorBar
mvPlotCol_FrameBg=internal_dpg.mvPlotCol_FrameBg
mvPlotCol_PlotBg=internal_dpg.mvPlotCol_PlotBg
mvPlotCol_PlotBorder=internal_dpg.mvPlotCol_PlotBorder
mvPlotCol_LegendBg=internal_dpg.mvPlotCol_LegendBg
mvPlotCol_LegendBorder=internal_dpg.mvPlotCol_LegendBorder
mvPlotCol_LegendText=internal_dpg.mvPlotCol_LegendText
mvPlotCol_TitleText=internal_dpg.mvPlotCol_TitleText
mvPlotCol_InlayText=internal_dpg.mvPlotCol_InlayText
mvPlotCol_AxisBg=internal_dpg.mvPlotCol_AxisBg
mvPlotCol_AxisBgActive=internal_dpg.mvPlotCol_AxisBgActive
mvPlotCol_AxisBgHovered=internal_dpg.mvPlotCol_AxisBgHovered
mvPlotCol_AxisGrid=internal_dpg.mvPlotCol_AxisGrid
mvPlotCol_AxisText=internal_dpg.mvPlotCol_AxisText
mvPlotCol_Selection=internal_dpg.mvPlotCol_Selection
mvPlotCol_Crosshairs=internal_dpg.mvPlotCol_Crosshairs
mvNodeCol_NodeBackground=internal_dpg.mvNodeCol_NodeBackground
mvNodeCol_NodeBackgroundHovered=internal_dpg.mvNodeCol_NodeBackgroundHovered
mvNodeCol_NodeBackgroundSelected=internal_dpg.mvNodeCol_NodeBackgroundSelected
mvNodeCol_NodeOutline=internal_dpg.mvNodeCol_NodeOutline
mvNodeCol_TitleBar=internal_dpg.mvNodeCol_TitleBar
mvNodeCol_TitleBarHovered=internal_dpg.mvNodeCol_TitleBarHovered
mvNodeCol_TitleBarSelected=internal_dpg.mvNodeCol_TitleBarSelected
mvNodeCol_Link=internal_dpg.mvNodeCol_Link
mvNodeCol_LinkHovered=internal_dpg.mvNodeCol_LinkHovered
mvNodeCol_LinkSelected=internal_dpg.mvNodeCol_LinkSelected
mvNodeCol_Pin=internal_dpg.mvNodeCol_Pin
mvNodeCol_PinHovered=internal_dpg.mvNodeCol_PinHovered
mvNodeCol_BoxSelector=internal_dpg.mvNodeCol_BoxSelector
mvNodeCol_BoxSelectorOutline=internal_dpg.mvNodeCol_BoxSelectorOutline
mvNodeCol_GridBackground=internal_dpg.mvNodeCol_GridBackground
mvNodeCol_GridLine=internal_dpg.mvNodeCol_GridLine
mvNodesCol_GridLinePrimary=internal_dpg.mvNodesCol_GridLinePrimary
mvNodesCol_MiniMapBackground=internal_dpg.mvNodesCol_MiniMapBackground
mvNodesCol_MiniMapBackgroundHovered=internal_dpg.mvNodesCol_MiniMapBackgroundHovered
mvNodesCol_MiniMapOutline=internal_dpg.mvNodesCol_MiniMapOutline
mvNodesCol_MiniMapOutlineHovered=internal_dpg.mvNodesCol_MiniMapOutlineHovered
mvNodesCol_MiniMapNodeBackground=internal_dpg.mvNodesCol_MiniMapNodeBackground
mvNodesCol_MiniMapNodeBackgroundHovered=internal_dpg.mvNodesCol_MiniMapNodeBackgroundHovered
mvNodesCol_MiniMapNodeBackgroundSelected=internal_dpg.mvNodesCol_MiniMapNodeBackgroundSelected
mvNodesCol_MiniMapNodeOutline=internal_dpg.mvNodesCol_MiniMapNodeOutline
mvNodesCol_MiniMapLink=internal_dpg.mvNodesCol_MiniMapLink
mvNodesCol_MiniMapLinkSelected=internal_dpg.mvNodesCol_MiniMapLinkSelected
mvNodesCol_MiniMapCanvas=internal_dpg.mvNodesCol_MiniMapCanvas
mvNodesCol_MiniMapCanvasOutline=internal_dpg.mvNodesCol_MiniMapCanvasOutline
mvStyleVar_Alpha=internal_dpg.mvStyleVar_Alpha
mvStyleVar_DisabledAlpha=internal_dpg.mvStyleVar_DisabledAlpha
mvStyleVar_WindowPadding=internal_dpg.mvStyleVar_WindowPadding
mvStyleVar_WindowRounding=internal_dpg.mvStyleVar_WindowRounding
mvStyleVar_WindowBorderSize=internal_dpg.mvStyleVar_WindowBorderSize
mvStyleVar_WindowMinSize=internal_dpg.mvStyleVar_WindowMinSize
mvStyleVar_WindowTitleAlign=internal_dpg.mvStyleVar_WindowTitleAlign
mvStyleVar_ChildRounding=internal_dpg.mvStyleVar_ChildRounding
mvStyleVar_ChildBorderSize=internal_dpg.mvStyleVar_ChildBorderSize
mvStyleVar_PopupRounding=internal_dpg.mvStyleVar_PopupRounding
mvStyleVar_PopupBorderSize=internal_dpg.mvStyleVar_PopupBorderSize
mvStyleVar_FramePadding=internal_dpg.mvStyleVar_FramePadding
mvStyleVar_FrameRounding=internal_dpg.mvStyleVar_FrameRounding
mvStyleVar_FrameBorderSize=internal_dpg.mvStyleVar_FrameBorderSize
mvStyleVar_ItemSpacing=internal_dpg.mvStyleVar_ItemSpacing
mvStyleVar_ItemInnerSpacing=internal_dpg.mvStyleVar_ItemInnerSpacing
mvStyleVar_IndentSpacing=internal_dpg.mvStyleVar_IndentSpacing
mvStyleVar_CellPadding=internal_dpg.mvStyleVar_CellPadding
mvStyleVar_ScrollbarSize=internal_dpg.mvStyleVar_ScrollbarSize
mvStyleVar_ScrollbarRounding=internal_dpg.mvStyleVar_ScrollbarRounding
mvStyleVar_GrabMinSize=internal_dpg.mvStyleVar_GrabMinSize
mvStyleVar_GrabRounding=internal_dpg.mvStyleVar_GrabRounding
mvStyleVar_TabRounding=internal_dpg.mvStyleVar_TabRounding
mvStyleVar_TabBorderSize=internal_dpg.mvStyleVar_TabBorderSize
mvStyleVar_TabBarBorderSize=internal_dpg.mvStyleVar_TabBarBorderSize
mvStyleVar_TableAngledHeadersAngle=internal_dpg.mvStyleVar_TableAngledHeadersAngle
mvStyleVar_TableAngledHeadersTextAlign=internal_dpg.mvStyleVar_TableAngledHeadersTextAlign
mvStyleVar_ButtonTextAlign=internal_dpg.mvStyleVar_ButtonTextAlign
mvStyleVar_SelectableTextAlign=internal_dpg.mvStyleVar_SelectableTextAlign
mvStyleVar_SeparatorTextBorderSize=internal_dpg.mvStyleVar_SeparatorTextBorderSize
mvStyleVar_SeparatorTextAlign=internal_dpg.mvStyleVar_SeparatorTextAlign
mvStyleVar_SeparatorTextPadding=internal_dpg.mvStyleVar_SeparatorTextPadding
mvStyleVar_DockingSeparatorSize=internal_dpg.mvStyleVar_DockingSeparatorSize
mvPlotStyleVar_LineWeight=internal_dpg.mvPlotStyleVar_LineWeight
mvPlotStyleVar_Marker=internal_dpg.mvPlotStyleVar_Marker
mvPlotStyleVar_MarkerSize=internal_dpg.mvPlotStyleVar_MarkerSize
mvPlotStyleVar_MarkerWeight=internal_dpg.mvPlotStyleVar_MarkerWeight
mvPlotStyleVar_FillAlpha=internal_dpg.mvPlotStyleVar_FillAlpha
mvPlotStyleVar_ErrorBarSize=internal_dpg.mvPlotStyleVar_ErrorBarSize
mvPlotStyleVar_ErrorBarWeight=internal_dpg.mvPlotStyleVar_ErrorBarWeight
mvPlotStyleVar_DigitalBitHeight=internal_dpg.mvPlotStyleVar_DigitalBitHeight
mvPlotStyleVar_DigitalBitGap=internal_dpg.mvPlotStyleVar_DigitalBitGap
mvPlotStyleVar_PlotBorderSize=internal_dpg.mvPlotStyleVar_PlotBorderSize
mvPlotStyleVar_MinorAlpha=internal_dpg.mvPlotStyleVar_MinorAlpha
mvPlotStyleVar_MajorTickLen=internal_dpg.mvPlotStyleVar_MajorTickLen
mvPlotStyleVar_MinorTickLen=internal_dpg.mvPlotStyleVar_MinorTickLen
mvPlotStyleVar_MajorTickSize=internal_dpg.mvPlotStyleVar_MajorTickSize
mvPlotStyleVar_MinorTickSize=internal_dpg.mvPlotStyleVar_MinorTickSize
mvPlotStyleVar_MajorGridSize=internal_dpg.mvPlotStyleVar_MajorGridSize
mvPlotStyleVar_MinorGridSize=internal_dpg.mvPlotStyleVar_MinorGridSize
mvPlotStyleVar_PlotPadding=internal_dpg.mvPlotStyleVar_PlotPadding
mvPlotStyleVar_LabelPadding=internal_dpg.mvPlotStyleVar_LabelPadding
mvPlotStyleVar_LegendPadding=internal_dpg.mvPlotStyleVar_LegendPadding
mvPlotStyleVar_LegendInnerPadding=internal_dpg.mvPlotStyleVar_LegendInnerPadding
mvPlotStyleVar_LegendSpacing=internal_dpg.mvPlotStyleVar_LegendSpacing
mvPlotStyleVar_MousePosPadding=internal_dpg.mvPlotStyleVar_MousePosPadding
mvPlotStyleVar_AnnotationPadding=internal_dpg.mvPlotStyleVar_AnnotationPadding
mvPlotStyleVar_FitPadding=internal_dpg.mvPlotStyleVar_FitPadding
mvPlotStyleVar_PlotDefaultSize=internal_dpg.mvPlotStyleVar_PlotDefaultSize
mvPlotStyleVar_PlotMinSize=internal_dpg.mvPlotStyleVar_PlotMinSize
mvNodeStyleVar_GridSpacing=internal_dpg.mvNodeStyleVar_GridSpacing
mvNodeStyleVar_NodeCornerRounding=internal_dpg.mvNodeStyleVar_NodeCornerRounding
mvNodeStyleVar_NodePadding=internal_dpg.mvNodeStyleVar_NodePadding
mvNodeStyleVar_NodeBorderThickness=internal_dpg.mvNodeStyleVar_NodeBorderThickness
mvNodeStyleVar_LinkThickness=internal_dpg.mvNodeStyleVar_LinkThickness
mvNodeStyleVar_LinkLineSegmentsPerLength=internal_dpg.mvNodeStyleVar_LinkLineSegmentsPerLength
mvNodeStyleVar_LinkHoverDistance=internal_dpg.mvNodeStyleVar_LinkHoverDistance
mvNodeStyleVar_PinCircleRadius=internal_dpg.mvNodeStyleVar_PinCircleRadius
mvNodeStyleVar_PinQuadSideLength=internal_dpg.mvNodeStyleVar_PinQuadSideLength
mvNodeStyleVar_PinTriangleSideLength=internal_dpg.mvNodeStyleVar_PinTriangleSideLength
mvNodeStyleVar_PinLineThickness=internal_dpg.mvNodeStyleVar_PinLineThickness
mvNodeStyleVar_PinHoverRadius=internal_dpg.mvNodeStyleVar_PinHoverRadius
mvNodeStyleVar_PinOffset=internal_dpg.mvNodeStyleVar_PinOffset
mvNodesStyleVar_MiniMapPadding=internal_dpg.mvNodesStyleVar_MiniMapPadding
mvNodesStyleVar_MiniMapOffset=internal_dpg.mvNodesStyleVar_MiniMapOffset
mvInputText=internal_dpg.mvInputText
mvButton=internal_dpg.mvButton
mvRadioButton=internal_dpg.mvRadioButton
mvTabBar=internal_dpg.mvTabBar
mvTab=internal_dpg.mvTab
mvImage=internal_dpg.mvImage
mvMenuBar=internal_dpg.mvMenuBar
mvViewportMenuBar=internal_dpg.mvViewportMenuBar
mvMenu=internal_dpg.mvMenu
mvMenuItem=internal_dpg.mvMenuItem
mvChildWindow=internal_dpg.mvChildWindow
mvGroup=internal_dpg.mvGroup
mvSliderFloat=internal_dpg.mvSliderFloat
mvSliderInt=internal_dpg.mvSliderInt
mvFilterSet=internal_dpg.mvFilterSet
mvDragFloat=internal_dpg.mvDragFloat
mvDragInt=internal_dpg.mvDragInt
mvInputFloat=internal_dpg.mvInputFloat
mvInputInt=internal_dpg.mvInputInt
mvColorEdit=internal_dpg.mvColorEdit
mvClipper=internal_dpg.mvClipper
mvColorPicker=internal_dpg.mvColorPicker
mvTooltip=internal_dpg.mvTooltip
mvCollapsingHeader=internal_dpg.mvCollapsingHeader
mvSeparator=internal_dpg.mvSeparator
mvCheckbox=internal_dpg.mvCheckbox
mvListbox=internal_dpg.mvListbox
mvText=internal_dpg.mvText
mvCombo=internal_dpg.mvCombo
mvPlot=internal_dpg.mvPlot
mvSimplePlot=internal_dpg.mvSimplePlot
mvDrawlist=internal_dpg.mvDrawlist
mvWindowAppItem=internal_dpg.mvWindowAppItem
mvSelectable=internal_dpg.mvSelectable
mvTreeNode=internal_dpg.mvTreeNode
mvProgressBar=internal_dpg.mvProgressBar
mvSpacer=internal_dpg.mvSpacer
mvImageButton=internal_dpg.mvImageButton
mvTimePicker=internal_dpg.mvTimePicker
mvDatePicker=internal_dpg.mvDatePicker
mvColorButton=internal_dpg.mvColorButton
mvFileDialog=internal_dpg.mvFileDialog
mvTabButton=internal_dpg.mvTabButton
mvDrawNode=internal_dpg.mvDrawNode
mvNodeEditor=internal_dpg.mvNodeEditor
mvNode=internal_dpg.mvNode
mvNodeAttribute=internal_dpg.mvNodeAttribute
mvTable=internal_dpg.mvTable
mvTableColumn=internal_dpg.mvTableColumn
mvTableRow=internal_dpg.mvTableRow
mvDrawLine=internal_dpg.mvDrawLine
mvDrawArrow=internal_dpg.mvDrawArrow
mvDrawTriangle=internal_dpg.mvDrawTriangle
mvDrawImageQuad=internal_dpg.mvDrawImageQuad
mvDrawCircle=internal_dpg.mvDrawCircle
mvDrawEllipse=internal_dpg.mvDrawEllipse
mvDrawBezierCubic=internal_dpg.mvDrawBezierCubic
mvDrawBezierQuadratic=internal_dpg.mvDrawBezierQuadratic
mvDrawQuad=internal_dpg.mvDrawQuad
mvDrawRect=internal_dpg.mvDrawRect
mvDrawText=internal_dpg.mvDrawText
mvDrawPolygon=internal_dpg.mvDrawPolygon
mvDrawPolyline=internal_dpg.mvDrawPolyline
mvDrawImage=internal_dpg.mvDrawImage
mvDragFloatMulti=internal_dpg.mvDragFloatMulti
mvDragIntMulti=internal_dpg.mvDragIntMulti
mvSliderFloatMulti=internal_dpg.mvSliderFloatMulti
mvSliderIntMulti=internal_dpg.mvSliderIntMulti
mvInputIntMulti=internal_dpg.mvInputIntMulti
mvInputFloatMulti=internal_dpg.mvInputFloatMulti
mvDragPoint=internal_dpg.mvDragPoint
mvDragLine=internal_dpg.mvDragLine
mvDragRect=internal_dpg.mvDragRect
mvAnnotation=internal_dpg.mvAnnotation
mvAxisTag=internal_dpg.mvAxisTag
mvLineSeries=internal_dpg.mvLineSeries
mvScatterSeries=internal_dpg.mvScatterSeries
mvStemSeries=internal_dpg.mvStemSeries
mvStairSeries=internal_dpg.mvStairSeries
mvBarSeries=internal_dpg.mvBarSeries
mvBarGroupSeries=internal_dpg.mvBarGroupSeries
mvErrorSeries=internal_dpg.mvErrorSeries
mvInfLineSeries=internal_dpg.mvInfLineSeries
mvHeatSeries=internal_dpg.mvHeatSeries
mvImageSeries=internal_dpg.mvImageSeries
mvPieSeries=internal_dpg.mvPieSeries
mvShadeSeries=internal_dpg.mvShadeSeries
mvLabelSeries=internal_dpg.mvLabelSeries
mvHistogramSeries=internal_dpg.mvHistogramSeries
mvDigitalSeries=internal_dpg.mvDigitalSeries
mv2dHistogramSeries=internal_dpg.mv2dHistogramSeries
mvCandleSeries=internal_dpg.mvCandleSeries
mvAreaSeries=internal_dpg.mvAreaSeries
mvColorMapScale=internal_dpg.mvColorMapScale
mvSlider3D=internal_dpg.mvSlider3D
mvKnobFloat=internal_dpg.mvKnobFloat
mvLoadingIndicator=internal_dpg.mvLoadingIndicator
mvNodeLink=internal_dpg.mvNodeLink
mvTextureRegistry=internal_dpg.mvTextureRegistry
mvStaticTexture=internal_dpg.mvStaticTexture
mvDynamicTexture=internal_dpg.mvDynamicTexture
mvStage=internal_dpg.mvStage
mvDrawLayer=internal_dpg.mvDrawLayer
mvViewportDrawlist=internal_dpg.mvViewportDrawlist
mvFileExtension=internal_dpg.mvFileExtension
mvPlotLegend=internal_dpg.mvPlotLegend
mvPlotAxis=internal_dpg.mvPlotAxis
mvHandlerRegistry=internal_dpg.mvHandlerRegistry
mvKeyDownHandler=internal_dpg.mvKeyDownHandler
mvKeyPressHandler=internal_dpg.mvKeyPressHandler
mvKeyReleaseHandler=internal_dpg.mvKeyReleaseHandler
mvMouseMoveHandler=internal_dpg.mvMouseMoveHandler
mvMouseWheelHandler=internal_dpg.mvMouseWheelHandler
mvMouseClickHandler=internal_dpg.mvMouseClickHandler
mvMouseDoubleClickHandler=internal_dpg.mvMouseDoubleClickHandler
mvMouseDownHandler=internal_dpg.mvMouseDownHandler
mvMouseReleaseHandler=internal_dpg.mvMouseReleaseHandler
mvMouseDragHandler=internal_dpg.mvMouseDragHandler
mvHoverHandler=internal_dpg.mvHoverHandler
mvActiveHandler=internal_dpg.mvActiveHandler
mvFocusHandler=internal_dpg.mvFocusHandler
mvVisibleHandler=internal_dpg.mvVisibleHandler
mvEditedHandler=internal_dpg.mvEditedHandler
mvActivatedHandler=internal_dpg.mvActivatedHandler
mvDeactivatedHandler=internal_dpg.mvDeactivatedHandler
mvDeactivatedAfterEditHandler=internal_dpg.mvDeactivatedAfterEditHandler
mvToggledOpenHandler=internal_dpg.mvToggledOpenHandler
mvClickedHandler=internal_dpg.mvClickedHandler
mvDoubleClickedHandler=internal_dpg.mvDoubleClickedHandler
mvScrollHandler=internal_dpg.mvScrollHandler
mvDragPayload=internal_dpg.mvDragPayload
mvResizeHandler=internal_dpg.mvResizeHandler
mvFont=internal_dpg.mvFont
mvFontRegistry=internal_dpg.mvFontRegistry
mvTheme=internal_dpg.mvTheme
mvThemeColor=internal_dpg.mvThemeColor
mvThemeStyle=internal_dpg.mvThemeStyle
mvThemeComponent=internal_dpg.mvThemeComponent
mvFontRangeHint=internal_dpg.mvFontRangeHint
mvFontRange=internal_dpg.mvFontRange
mvFontChars=internal_dpg.mvFontChars
mvCharRemap=internal_dpg.mvCharRemap
mvValueRegistry=internal_dpg.mvValueRegistry
mvIntValue=internal_dpg.mvIntValue
mvFloatValue=internal_dpg.mvFloatValue
mvFloat4Value=internal_dpg.mvFloat4Value
mvInt4Value=internal_dpg.mvInt4Value
mvBoolValue=internal_dpg.mvBoolValue
mvStringValue=internal_dpg.mvStringValue
mvDoubleValue=internal_dpg.mvDoubleValue
mvDouble4Value=internal_dpg.mvDouble4Value
mvColorValue=internal_dpg.mvColorValue
mvFloatVectValue=internal_dpg.mvFloatVectValue
mvSeriesValue=internal_dpg.mvSeriesValue
mvRawTexture=internal_dpg.mvRawTexture
mvSubPlots=internal_dpg.mvSubPlots
mvColorMap=internal_dpg.mvColorMap
mvColorMapRegistry=internal_dpg.mvColorMapRegistry
mvColorMapButton=internal_dpg.mvColorMapButton
mvColorMapSlider=internal_dpg.mvColorMapSlider
mvTemplateRegistry=internal_dpg.mvTemplateRegistry
mvTableCell=internal_dpg.mvTableCell
mvItemHandlerRegistry=internal_dpg.mvItemHandlerRegistry
mvInputDouble=internal_dpg.mvInputDouble
mvInputDoubleMulti=internal_dpg.mvInputDoubleMulti
mvDragDouble=internal_dpg.mvDragDouble
mvDragDoubleMulti=internal_dpg.mvDragDoubleMulti
mvSliderDouble=internal_dpg.mvSliderDouble
mvSliderDoubleMulti=internal_dpg.mvSliderDoubleMulti
mvCustomSeries=internal_dpg.mvCustomSeries
mvReservedUUID_0=internal_dpg.mvReservedUUID_0
mvReservedUUID_1=internal_dpg.mvReservedUUID_1
mvReservedUUID_2=internal_dpg.mvReservedUUID_2
mvReservedUUID_3=internal_dpg.mvReservedUUID_3
mvReservedUUID_4=internal_dpg.mvReservedUUID_4
mvReservedUUID_5=internal_dpg.mvReservedUUID_5
mvReservedUUID_6=internal_dpg.mvReservedUUID_6
mvReservedUUID_7=internal_dpg.mvReservedUUID_7
mvReservedUUID_8=internal_dpg.mvReservedUUID_8
mvReservedUUID_9=internal_dpg.mvReservedUUID_9
mvReservedUUID_10=internal_dpg.mvReservedUUID_10
