:arrow_down::scissors: *Please delete the checklist before submitting your PR!* :scissors::arrow_down:

Thank you very much for submitting a **Pull Request** to Indico! We will be happy to review your code as soon as we can. However, in order to make things simpler to everyone, we'll ask you to do a final "check" before you send your code.

:warning: First of all, if you are implementing a new feature, please make sure that you have discuss it previously with the development team and the community either through the [forum](https://talk.getindico.io) or any other communication channel. The more consensual the new feature has within the community, the more potential it has to make a difference and thus to be accepted. :warning:

* Make sure your code is complete :full_moon::
  - [ ] Have you added **docstrings** to newly created classes?
  - [ ] Have you added [**jsdoc** strings](https://react-styleguidist.js.org/docs/documenting.html) to new React components?
  - [ ] Have you added **code comments** in parts that are harder to understand?
  - [ ] Have you checked that you haven't forgotten to add any **newly created files** to the Git repo?

* Make sure that your code has no errors :white_check_mark::
  - [ ] **Code style and formatting** - have you run `eslint` and `ruff` (or the [pre-commit hook](https://github.com/indico/indico/blob/master/pre-commit.githook))?
  - [ ] **Regressions** - have you tried running the unit tests? (`pytest`)

* Make sure others understand what has changed :loudspeaker::
  - [ ] Log any feature changes and bug fixes in `CHANGES.rst` (**changelog** for developers)
  - [ ] **Update the documentation** if needed
  - [ ] Check that your **commit messages** are clear and contain no typos. The subject message should be in the [**imperative mood**](https://chris.beams.io/posts/git-commit/);

If you ticked all the boxes above, you're good to go! :rocket:

:arrow_up::scissors: *Please delete the checklist before submitting your PR!* :scissors::arrow_up:
