# Security Policy

The Indico Team takes security very seriously. We greatly value the efforts of those who help us
maintain the security and integrity of the project. If you discover a vulnerability, we ask that you
report it responsibly so that we can fix it promptly.

## 💌 Reporting a Vulnerability

Please report it using GitHub's ["Report a Vulnerability" button][github-report-vuln].
If you don't have a GitHub account, you can instead send an email with the details of the issue to:

**indico-team@cern.ch**

To help us assess and fix the problem quickly, we ask that you include:

- A clear description of the vulnerability
- The version of Indico you tested
- Detailed steps to reproduce the issue

Your report will go to experienced developers. We appreciate conciseness. In particular, we ask you
to **not use an LLM** to make your report "nicer" and instead focus on the technical details of the
issue you are reporting.

⚠️ **Important:** Do not open a public GitHub issue for security vulnerabilities.

## 🦾 Our Commitment

We will acknowledge your report within 48 hours and work with you to:

- Assess the issue and its impact
- Develop and release a fix
- Communicate openly and clearly about the timeline and resolution

## 🆘 Supported Versions

We currently maintain security fixes for the following versions:

<!-- VERSIONS - this is all machine-generated! Don't change it. -->
| Version | Supported                  |
|---------|----------------------------|
| 3.3.x   | ✅ Yes (latest version)    |
| 3.2.x   | ❌ No (ended Jul 30, 2024) |
| Others  | ❌ No                      |
<!-- ENDVERSIONS -->

If a version has "Limited" support, only important security fixes ("High" or "Critical" severity)
will be backported.

## 🫶 Thanks!

We deeply appreciate the efforts of security researchers and the wider Indico community in making
Indico more secure.

[github-report-vuln]: https://github.com/indico/indico/security/advisories/new
