// This file is part of Indico.
// Copyright (C) 2002 - 2026 CERN
//
// Indico is free software; you can redistribute it and/or
// modify it under the terms of the MIT License; see the
// LICENSE file for more details.

/* global ajaxDialog:false */

import React from 'react';
import ReactDOM from 'react-dom';

import {ManageNotes} from 'indico/react/components';

import './util/list_generator';
import './util/static_filters';
import './favorite';

(function() {
  function setupEventDisplay() {
    function openAjaxDialog($element) {
      ajaxDialog({
        title: $element.data('title'),
        subtitle: $element.data('subtitle'),
        url: $element.data('href'),
        confirmCloseUnsaved: true,
        onClose(data, customData) {
          if (data || customData) {
            location.reload();
          }
        },
      });
    }

    const containers = document.querySelectorAll('.manage-notes-container');
    containers.forEach(container => {
      ReactDOM.render(
        React.createElement(ManageNotes, {
          icon: container.dataset.icon !== undefined,
          title: container.dataset.title,
          compile: container.CDATA_SECTION_NODE.icon !== undefined,
          apiURL: container.dataset.apiUrl,
          imageUploadURL: container.dataset.imageUploadUrl,
          getNoteURL: container.dataset.getNoteUrl,
          modalTitle: container.dataset.modalTitle,
        }),
        container
      );
    });

    $('.js-go-to-day')
      .dropdown({
        always_listen: true,
      })
      .find('li a')
      .on('menu_select', function() {
        const anchor = $(this).attr('href');
        $('body, html').animate(
          {
            scrollTop: $(anchor).offset().top,
          },
          {
            duration: 700,
            complete() {
              location.href = anchor;
            },
          }
        );
        return false;
      });

    const selectors = [
      '.notes-compile',
      '.contribution-edit',
      '.subcontribution-edit',
      '.subcontributions-edit',
    ].join(', ');
    $('body').on('click', selectors, function(e) {
      e.preventDefault();
      openAjaxDialog($(this));
      return false;
    });

    $(document).ready(() => {
      $('h1, .item-description, .timetable-title').mathJax();
    });
  }

  function toggleNote(element, visible, immediate) {
    // Note for event
    let note = element.closest('.event-note-section');
    // Note for other elements
    if (note.length === 0) {
      note = element.closest('li').find('.note-area-wrapper');
    }
    const content = note.hasClass('togglable') ? note : note.find('.togglable');
    if (immediate) {
      content.toggle(visible);
    } else {
      content[visible === undefined ? 'slideToggle' : visible ? 'slideDown' : 'slideUp']();
    }
  }

  $(document).ready(() => {
    $('.event-service-row > .trigger').on('click', function() {
      const toggler = $(this);
      toggler.siblings('.event-service-details').slideToggle({
        start() {
          toggler.toggleClass('icon-expand icon-collapse');
        },
        duration: 'fast',
      });
    });

    $('.event-service-row-toggle').on('click', function(e) {
      e.preventDefault();
      const toggler = $(this);
      const togglerButton = $(this).parent().siblings('.trigger');
      toggler
        .parent()
        .siblings('.event-service-details')
        .slideToggle({
          start() {
            togglerButton.toggleClass('icon-expand icon-collapse');
          },
          duration: 'fast',
        });
    });

    const threeRowsHeight = 70;
    $('.participant-list-wrapper').toggleClass(
      'collapsible collapsed transparent-overlay',
      $('.participant-list').height() > threeRowsHeight
    );
    const initialHeight = $('.participant-list-wrapper').height();

    $('.participant-list-wrapper.transparent-overlay').on('click', () => {
      const toggler = $('.participant-list-wrapper > .trigger');
      const participantList = toggler.siblings('.participant-list');
      const wrapper = participantList.parent();
      if (wrapper.hasClass('collapsed')) {
        const newHeight = participantList.height();
        participantList.height(initialHeight);
        wrapper.removeClass('collapsed transparent-overlay');
        wrapper.animate(
          {
            height: newHeight,
          },
          {
            duration: 'fast',
            start() {
              toggler.addClass('icon-collapse').removeClass('icon-expand');
            },
            complete() {
              participantList.height(newHeight);
            },
          }
        );
      } else {
        wrapper.addClass('transparent-overlay');
        wrapper.animate(
          {
            height: initialHeight,
          },
          {
            duration: 'fast',
            start() {
              toggler.removeClass('icon-collapse').addClass('icon-expand');
            },
            complete() {
              wrapper.addClass('collapsed');
            },
          }
        );
      }
    });

    $('a.js-show-note-toggle').on('click', function(e) {
      e.preventDefault();
      toggleNote($(this));
    });

    $('input.js-toggle-note-cb').on('change', function(e, immediate) {
      toggleNote($(this), this.checked, immediate);
    });

    $('input.js-toggle-note-cb').trigger('change', [true]);

    setupEventDisplay();
  });
})();
