# This file is part of Indico.
# Copyright (C) 2002 - 2026 CERN
#
# Indico is free software; you can redistribute it and/or
# modify it under the terms of the MIT License; see the
# LICENSE file for more details.

from flask import session

from indico.core import signals
from indico.core.logger import Logger
from indico.modules.events.static.models.static import StaticSite
from indico.util.i18n import _
from indico.web.flask.util import url_for
from indico.web.menu import SideMenuItem


logger = Logger.get('events.static')


@signals.users.merged.connect
def _merge_users(target, source, **kwargs):
    StaticSite.query.filter_by(creator_id=source.id).update({StaticSite.creator_id: target.id})


@signals.menu.items.connect_via('event-management-sidemenu')
def _extend_event_management_menu(sender, event, **kwargs):
    if not event.can_manage(session.user):
        return
    return SideMenuItem('static', _('Offline Copy'), url_for('static_site.list', event), section='advanced')
