#
#  Copyright 2025 The InfiniFlow Authors. All Rights Reserved.
#
#  Licensed under the Apache License, Version 2.0 (the "License");
#  you may not use this file except in compliance with the License.
#  You may obtain a copy of the License at
#
#      http://www.apache.org/licenses/LICENSE-2.0
#
#  Unless required by applicable law or agreed to in writing, software
#  distributed under the License is distributed on an "AS IS" BASIS,
#  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
#  See the License for the specific language governing permissions and
#  limitations under the License.
#

TBL = {
    "1": {"name": "IT/通信/电子", "parent": "0"},
    "2": {"name": "互联网", "parent": "0"},
    "3": {"name": "电子商务", "parent": "2"},
    "4": {"name": "互联网金融", "parent": "2"},
    "5": {"name": "网络游戏", "parent": "2"},
    "6": {"name": "社交网络平台", "parent": "2"},
    "7": {"name": "视频音乐", "parent": "2"},
    "9": {"name": "安全", "parent": "2"},
    "10": {"name": "云计算", "parent": "2"},
    "12": {"name": "工具类客户端应用", "parent": "2"},
    "13": {"name": "互联网广告", "parent": "2"},
    "14": {"name": "企业互联网服务", "parent": "2"},
    "16": {"name": "在线教育", "parent": "2"},
    "17": {"name": "在线医疗", "parent": "2"},
    "19": {"name": "B2B", "parent": "3"},
    "20": {"name": "B2C", "parent": "3"},
    "21": {"name": "C2C", "parent": "3"},
    "22": {"name": "生活信息本地化", "parent": "3"},
    "23": {"name": "在线旅游", "parent": "2"},
    "24": {"name": "第三方支付", "parent": "4"},
    "26": {"name": "客户端游戏", "parent": "5"},
    "27": {"name": "网页游戏", "parent": "5"},
    "28": {"name": "手机游戏", "parent": "5"},
    "29": {"name": "微博", "parent": "6"},
    "30": {"name": "社交网站", "parent": "6"},
    "31": {"name": "在线视频", "parent": "7"},
    "32": {"name": "在线音乐", "parent": "7"},
    "35": {"name": "企业安全", "parent": "9"},
    "36": {"name": "个人安全", "parent": "9"},
    "37": {"name": "企业级云服务", "parent": "10"},
    "38": {"name": "个人级云服务", "parent": "10"},
    "43": {"name": "输入法", "parent": "12"},
    "44": {"name": "浏览器", "parent": "12"},
    "45": {"name": "词典", "parent": "12"},
    "46": {"name": "播放器", "parent": "12"},
    "47": {"name": "下载器", "parent": "12"},
    "48": {"name": "IM", "parent": "12"},
    "49": {"name": "广告服务", "parent": "13"},
    "50": {"name": "第三方广告网络平台", "parent": "13"},
    "51": {"name": "媒体代理", "parent": "13"},
    "52": {"name": "创意代理", "parent": "13"},
    "53": {"name": "IT-综合", "parent": "1"},
    "71": {"name": "团购", "parent": "3"},
    "72": {"name": "地图", "parent": "2"},
    "73": {"name": "数据存储", "parent": "2"},
    "414": {"name": "计算机软件", "parent": "1"},
    "415": {"name": "计算机硬件", "parent": "1"},
    "416": {"name": "计算机服务(系统、数据服务、维修)", "parent": "1"},
    "417": {"name": "通信/电信/网络设备", "parent": "1"},
    "418": {"name": "通信/电信运营、增值服务", "parent": "1"},
    "419": {"name": "电子技术/半导体/集成电路", "parent": "1"},
    "472": {"name": "P2P网贷", "parent": "4"},
    "473": {"name": "互联网理财", "parent": "4"},
    "474": {"name": "婚恋", "parent": "6"},
    "476": {"name": "虚拟化", "parent": "10"},
    "477": {"name": "邮箱", "parent": "12"},
    "478": {"name": "商业智能", "parent": "14"},
    "479": {"name": "企业建站", "parent": "14"},
    "480": {"name": "安防", "parent": "14"},
    "481": {"name": "网络营销", "parent": "2"},
    "487": {"name": "智能终端", "parent": "2"},
    "488": {"name": "移动互联网", "parent": "2"},
    "489": {"name": "数字城市", "parent": "2"},
    "490": {"name": "大数据", "parent": "2"},
    "491": {"name": "互联网人力资源", "parent": "2"},
    "492": {"name": "舆情监控", "parent": "2"},
    "493": {"name": "移动营销", "parent": "481"},
    "494": {"name": "微博营销", "parent": "481"},
    "495": {"name": "精准营销", "parent": "481"},
    "496": {"name": "海外营销", "parent": "481"},
    "497": {"name": "微信营销", "parent": "481"},
    "498": {"name": "智能手机", "parent": "487"},
    "499": {"name": "可穿戴设备", "parent": "487"},
    "500": {"name": "智能电视", "parent": "487"},
    "501": {"name": "WAP", "parent": "488"},
    "502": {"name": "物联网", "parent": "489"},
    "503": {"name": "O2O", "parent": "489"},
    "504": {"name": "数字出版", "parent": "489"},
    "505": {"name": "搜索", "parent": "2"},
    "506": {"name": "垂直搜索", "parent": "505"},
    "507": {"name": "无线搜索", "parent": "505"},
    "508": {"name": "网页搜索", "parent": "505"},
    "509": {"name": "网址导航", "parent": "2"},
    "510": {"name": "门户", "parent": "2"},
    "511": {"name": "网络文学", "parent": "2"},
    "512": {"name": "自媒体", "parent": "2"},
    "513": {"name": "金融", "parent": "0"},
    "514": {"name": "建筑与房地产", "parent": "0"},
    "515": {"name": "专业服务", "parent": "0"},
    "516": {"name": "教育培训", "parent": "0"},
    "517": {"name": "文化传媒", "parent": "0"},
    "518": {"name": "消费品", "parent": "0"},
    "519": {"name": "工业", "parent": "0"},
    "520": {"name": "交通物流", "parent": "0"},
    "521": {"name": "贸易", "parent": "0"},
    "522": {"name": "医药", "parent": "0"},
    "523": {"name": "医疗器械", "parent": "522"},
    "524": {"name": "保健品", "parent": "518"},
    "525": {"name": "服务业", "parent": "0"},
    "526": {"name": "能源/矿产/环保", "parent": "0"},
    "527": {"name": "化工", "parent": "0"},
    "528": {"name": "政府", "parent": "0"},
    "529": {"name": "公共事业", "parent": "0"},
    "530": {"name": "非盈利机构", "parent": "0"},
    "531": {"name": "农业", "parent": "1131"},
    "532": {"name": "林业", "parent": "1131"},
    "533": {"name": "畜牧业", "parent": "1131"},
    "534": {"name": "渔业", "parent": "1131"},
    "535": {"name": "学术科研", "parent": "0"},
    "536": {"name": "零售", "parent": "0"},
    "537": {"name": "银行", "parent": "513"},
    "538": {"name": "保险", "parent": "513"},
    "539": {"name": "证券", "parent": "513"},
    "540": {"name": "基金", "parent": "513"},
    "541": {"name": "信托", "parent": "513"},
    "542": {"name": "担保", "parent": "513"},
    "543": {"name": "典当", "parent": "513"},
    "544": {"name": "拍卖", "parent": "513"},
    "545": {"name": "投资/融资", "parent": "513"},
    "546": {"name": "期货", "parent": "513"},
    "547": {"name": "房地产开发", "parent": "514"},
    "548": {"name": "工程施工", "parent": "514"},
    "549": {"name": "建筑设计", "parent": "514"},
    "550": {"name": "房地产代理", "parent": "514"},
    "551": {"name": "物业管理", "parent": "514"},
    "552": {"name": "室内设计", "parent": "514"},
    "553": {"name": "装修装潢", "parent": "514"},
    "554": {"name": "市政工程", "parent": "514"},
    "555": {"name": "工程造价", "parent": "514"},
    "556": {"name": "工程监理", "parent": "514"},
    "557": {"name": "环境工程", "parent": "514"},
    "558": {"name": "园林景观", "parent": "514"},
    "559": {"name": "法律", "parent": "515"},
    "560": {"name": "人力资源", "parent": "515"},
    "561": {"name": "会计", "parent": "1125"},
    "562": {"name": "审计", "parent": "515"},
    "563": {"name": "检测认证", "parent": "515"},
    "565": {"name": "翻译", "parent": "515"},
    "566": {"name": "中介", "parent": "515"},
    "567": {"name": "咨询", "parent": "515"},
    "568": {"name": "外包服务", "parent": "515"},
    "569": {"name": "家教", "parent": "516"},
    "570": {"name": "早教", "parent": "516"},
    "571": {"name": "职业技能培训", "parent": "516"},
    "572": {"name": "外语培训", "parent": "516"},
    "573": {"name": "设计培训", "parent": "516"},
    "574": {"name": "IT培训", "parent": "516"},
    "575": {"name": "文艺体育培训", "parent": "516"},
    "576": {"name": "学历教育", "parent": "516"},
    "577": {"name": "管理培训", "parent": "516"},
    "578": {"name": "民办基础教育", "parent": "516"},
    "579": {"name": "广告", "parent": "517"},
    "580": {"name": "媒体", "parent": "517"},
    "581": {"name": "会展", "parent": "517"},
    "582": {"name": "公关", "parent": "517"},
    "583": {"name": "影视", "parent": "517"},
    "584": {"name": "艺术", "parent": "517"},
    "585": {"name": "文化传播", "parent": "517"},
    "586": {"name": "娱乐", "parent": "517"},
    "587": {"name": "体育", "parent": "517"},
    "588": {"name": "出版", "parent": "517"},
    "589": {"name": "休闲", "parent": "517"},
    "590": {"name": "动漫", "parent": "517"},
    "591": {"name": "市场推广", "parent": "517"},
    "592": {"name": "市场研究", "parent": "517"},
    "593": {"name": "食品", "parent": "1129"},
    "594": {"name": "饮料", "parent": "1129"},
    "595": {"name": "烟草", "parent": "1129"},
    "596": {"name": "酒品", "parent": "518"},
    "597": {"name": "服饰", "parent": "518"},
    "598": {"name": "纺织", "parent": "518"},
    "599": {"name": "化妆品", "parent": "1129"},
    "600": {"name": "日用品", "parent": "1129"},
    "601": {"name": "家电", "parent": "518"},
    "602": {"name": "家具", "parent": "518"},
    "603": {"name": "办公用品", "parent": "518"},
    "604": {"name": "奢侈品", "parent": "518"},
    "605": {"name": "珠宝", "parent": "518"},
    "606": {"name": "数码产品", "parent": "518"},
    "607": {"name": "玩具", "parent": "518"},
    "608": {"name": "图书", "parent": "518"},
    "609": {"name": "音像", "parent": "518"},
    "610": {"name": "钟表", "parent": "518"},
    "611": {"name": "箱包", "parent": "518"},
    "612": {"name": "母婴", "parent": "518"},
    "613": {"name": "营养保健", "parent": "518"},
    "614": {"name": "户外用品", "parent": "518"},
    "615": {"name": "健身器材", "parent": "518"},
    "616": {"name": "乐器", "parent": "518"},
    "617": {"name": "汽车用品", "parent": "518"},
    "619": {"name": "厨具", "parent": "518"},
    "620": {"name": "机械制造", "parent": "519"},
    "621": {"name": "流体控制", "parent": "519"},
    "622": {"name": "自动化控制", "parent": "519"},
    "623": {"name": "仪器仪表", "parent": "519"},
    "624": {"name": "航空/航天", "parent": "519"},
    "625": {"name": "交通设施", "parent": "519"},
    "626": {"name": "工业电子", "parent": "519"},
    "627": {"name": "建材", "parent": "519"},
    "628": {"name": "五金材料", "parent": "519"},
    "629": {"name": "汽车", "parent": "519"},
    "630": {"name": "印刷", "parent": "519"},
    "631": {"name": "造纸", "parent": "519"},
    "632": {"name": "包装", "parent": "519"},
    "633": {"name": "原材料及加工", "parent": "519"},
    "634": {"name": "物流", "parent": "520"},
    "635": {"name": "仓储", "parent": "520"},
    "636": {"name": "客运", "parent": "520"},
    "637": {"name": "快递", "parent": "520"},
    "638": {"name": "化学药", "parent": "522"},
    "639": {"name": "中药", "parent": "522"},
    "640": {"name": "生物制药", "parent": "522"},
    "641": {"name": "兽药", "parent": "522"},
    "642": {"name": "农药", "parent": "522"},
    "643": {"name": "CRO", "parent": "522"},
    "644": {"name": "消毒", "parent": "522"},
    "645": {"name": "医药商业", "parent": "522"},
    "646": {"name": "医疗服务", "parent": "522"},
    "647": {"name": "医疗器械", "parent": "523"},
    "648": {"name": "制药设备", "parent": "523"},
    "649": {"name": "医用耗材", "parent": "523"},
    "650": {"name": "手术器械", "parent": "523"},
    "651": {"name": "保健器材", "parent": "524"},
    "652": {"name": "性保健品", "parent": "524"},
    "653": {"name": "医药保养", "parent": "524"},
    "654": {"name": "医用保健", "parent": "524"},
    "655": {"name": "酒店", "parent": "525"},
    "656": {"name": "餐饮", "parent": "525"},
    "657": {"name": "旅游", "parent": "525"},
    "658": {"name": "生活服务", "parent": "525"},
    "659": {"name": "保健服务", "parent": "525"},
    "660": {"name": "运动健身", "parent": "525"},
    "661": {"name": "家政服务", "parent": "525"},
    "662": {"name": "婚庆服务", "parent": "525"},
    "663": {"name": "租赁服务", "parent": "525"},
    "664": {"name": "维修服务", "parent": "525"},
    "665": {"name": "石油天然气", "parent": "526"},
    "666": {"name": "电力", "parent": "526"},
    "667": {"name": "新能源", "parent": "526"},
    "668": {"name": "水利", "parent": "526"},
    "669": {"name": "矿产", "parent": "526"},
    "670": {"name": "采掘业", "parent": "526"},
    "671": {"name": "冶炼", "parent": "526"},
    "672": {"name": "环保", "parent": "526"},
    "673": {"name": "无机化工原料", "parent": "527"},
    "674": {"name": "有机化工原料", "parent": "527"},
    "675": {"name": "精细化学品", "parent": "527"},
    "676": {"name": "化工设备", "parent": "527"},
    "677": {"name": "化工工程", "parent": "527"},
    "678": {"name": "资产管理", "parent": "513"},
    "679": {"name": "金融租赁", "parent": "513"},
    "680": {"name": "征信及信评机构", "parent": "513"},
    "681": {"name": "资产评估机构", "parent": "513"},
    "683": {"name": "金融监管机构", "parent": "513"},
    "684": {"name": "国际贸易", "parent": "521"},
    "685": {"name": "海关", "parent": "521"},
    "686": {"name": "购物中心", "parent": "536"},
    "687": {"name": "超市", "parent": "536"},
    "688": {"name": "便利店", "parent": "536"},
    "689": {"name": "专卖店", "parent": "536"},
    "690": {"name": "专业店", "parent": "536"},
    "691": {"name": "百货店", "parent": "536"},
    "692": {"name": "杂货店", "parent": "536"},
    "693": {"name": "个人银行", "parent": "537"},
    "695": {"name": "私人银行", "parent": "537"},
    "696": {"name": "公司银行", "parent": "537"},
    "697": {"name": "投资银行", "parent": "537"},
    "698": {"name": "政策性银行", "parent": "537"},
    "699": {"name": "中央银行", "parent": "537"},
    "700": {"name": "人寿险", "parent": "538"},
    "701": {"name": "财产险", "parent": "538"},
    "702": {"name": "再保险", "parent": "538"},
    "703": {"name": "养老险", "parent": "538"},
    "704": {"name": "保险代理公司", "parent": "538"},
    "705": {"name": "公募基金", "parent": "540"},
    "707": {"name": "私募基金", "parent": "540"},
    "708": {"name": "第三方理财", "parent": "679"},
    "709": {"name": "资产管理公司", "parent": "679"},
    "711": {"name": "房产中介", "parent": "566"},
    "712": {"name": "职业中介", "parent": "566"},
    "713": {"name": "婚姻中介", "parent": "566"},
    "714": {"name": "战略咨询", "parent": "567"},
    "715": {"name": "投资咨询", "parent": "567"},
    "716": {"name": "心理咨询", "parent": "567"},
    "717": {"name": "留学移民咨询", "parent": "567"},
    "718": {"name": "工商注册代理", "parent": "568"},
    "719": {"name": "商标专利代理", "parent": "568"},
    "720": {"name": "财务代理", "parent": "568"},
    "721": {"name": "工程机械", "parent": "620"},
    "722": {"name": "农业机械", "parent": "620"},
    "723": {"name": "海工设备", "parent": "620"},
    "724": {"name": "包装机械", "parent": "620"},
    "725": {"name": "印刷机械", "parent": "620"},
    "726": {"name": "数控机床", "parent": "620"},
    "727": {"name": "矿山机械", "parent": "620"},
    "728": {"name": "水泵", "parent": "621"},
    "729": {"name": "管道", "parent": "621"},
    "730": {"name": "阀门", "parent": "621"},
    "732": {"name": "压缩机", "parent": "621"},
    "733": {"name": "集散控制系统", "parent": "622"},
    "734": {"name": "远程控制", "parent": "622"},
    "735": {"name": "液压系统", "parent": "622"},
    "736": {"name": "楼宇智能化", "parent": "622"},
    "737": {"name": "飞机制造", "parent": "624"},
    "738": {"name": "航空公司", "parent": "624"},
    "739": {"name": "发动机", "parent": "624"},
    "740": {"name": "复合材料", "parent": "624"},
    "741": {"name": "高铁", "parent": "625"},
    "742": {"name": "地铁", "parent": "625"},
    "743": {"name": "信号传输", "parent": "625"},
    "745": {"name": "结构材料", "parent": "627"},
    "746": {"name": "装饰材料", "parent": "627"},
    "747": {"name": "专用材料", "parent": "627"},
    "749": {"name": "经销商集团", "parent": "629"},
    "750": {"name": "整车制造", "parent": "629"},
    "751": {"name": "汽车零配件", "parent": "629"},
    "752": {"name": "外型设计", "parent": "629"},
    "753": {"name": "平版印刷", "parent": "630"},
    "754": {"name": "凸版印刷", "parent": "630"},
    "755": {"name": "凹版印刷", "parent": "630"},
    "756": {"name": "孔版印刷", "parent": "630"},
    "757": {"name": "印刷用纸", "parent": "631"},
    "758": {"name": "书写、制图及复制用纸", "parent": "631"},
    "759": {"name": "包装用纸", "parent": "631"},
    "760": {"name": "生活、卫生及装饰用纸", "parent": "631"},
    "761": {"name": "技术用纸", "parent": "631"},
    "762": {"name": "加工纸原纸", "parent": "631"},
    "763": {"name": "食品包装", "parent": "632"},
    "764": {"name": "医药包装", "parent": "632"},
    "765": {"name": "日化包装", "parent": "632"},
    "766": {"name": "物流包装", "parent": "632"},
    "767": {"name": "礼品包装", "parent": "632"},
    "768": {"name": "电子五金包装", "parent": "632"},
    "769": {"name": "汽车服务", "parent": "525"},
    "770": {"name": "汽车保养", "parent": "769"},
    "771": {"name": "租车", "parent": "769"},
    "773": {"name": "出租车", "parent": "769"},
    "774": {"name": "代驾", "parent": "769"},
    "775": {"name": "发电", "parent": "666"},
    "777": {"name": "输配电", "parent": "666"},
    "779": {"name": "风电", "parent": "667"},
    "780": {"name": "光伏/太阳能", "parent": "667"},
    "781": {"name": "生物质发电", "parent": "667"},
    "782": {"name": "煤化工", "parent": "667"},
    "783": {"name": "垃圾发电", "parent": "667"},
    "784": {"name": "核电", "parent": "667"},
    "785": {"name": "能源矿产", "parent": "669"},
    "786": {"name": "金属矿产", "parent": "669"},
    "787": {"name": "非金属矿产", "parent": "669"},
    "788": {"name": "水气矿产", "parent": "669"},
    "789": {"name": "锅炉", "parent": "775"},
    "790": {"name": "发电机", "parent": "775"},
    "791": {"name": "汽轮机", "parent": "775"},
    "792": {"name": "燃机", "parent": "775"},
    "793": {"name": "冷却", "parent": "775"},
    "794": {"name": "电力设计院", "parent": "775"},
    "795": {"name": "高压输配电", "parent": "777"},
    "796": {"name": "中压输配电", "parent": "777"},
    "797": {"name": "低压输配电", "parent": "777"},
    "798": {"name": "继电保护", "parent": "777"},
    "799": {"name": "智能电网", "parent": "777"},
    "800": {"name": "小学", "parent": "516"},
    "801": {"name": "电动车", "parent": "519"},
    "802": {"name": "皮具箱包", "parent": "518"},
    "803": {"name": "医药制造", "parent": "522"},
    "804": {"name": "电器销售", "parent": "536"},
    "805": {"name": "塑料制品", "parent": "527"},
    "806": {"name": "公益基金会", "parent": "530"},
    "807": {"name": "美发服务", "parent": "525"},
    "808": {"name": "农业养殖", "parent": "531"},
    "809": {"name": "金融服务", "parent": "513"},
    "810": {"name": "商业地产综合体", "parent": "514"},
    "811": {"name": "美容服务", "parent": "525"},
    "812": {"name": "灯饰", "parent": "518"},
    "813": {"name": "油墨颜料产品", "parent": "527"},
    "814": {"name": "眼镜制造", "parent": "518"},
    "815": {"name": "农业生物技术", "parent": "531"},
    "816": {"name": "体育用品", "parent": "518"},
    "817": {"name": "保健用品", "parent": "524"},
    "818": {"name": "化学化工产品", "parent": "527"},
    "819": {"name": "饲料", "parent": "531"},
    "821": {"name": "保安服务", "parent": "525"},
    "822": {"name": "干细胞技术", "parent": "522"},
    "824": {"name": "农药化肥", "parent": "527"},
    "825": {"name": "卫生洁具", "parent": "518"},
    "826": {"name": "体育器材、场馆", "parent": "518"},
    "827": {"name": "饲料加工", "parent": "531"},
    "828": {"name": "测绘服务", "parent": "529"},
    "830": {"name": "金属船舶制造", "parent": "519"},
    "831": {"name": "基因工程", "parent": "522"},
    "832": {"name": "花卉服务", "parent": "536"},
    "833": {"name": "农业种植", "parent": "531"},
    "834": {"name": "皮革制品", "parent": "518"},
    "835": {"name": "地理信息加工服务", "parent": "529"},
    "836": {"name": "机器人", "parent": "519"},
    "837": {"name": "礼品", "parent": "518"},
    "838": {"name": "理发及美容服务", "parent": "525"},
    "839": {"name": "其他清洁服务", "parent": "525"},
    "840": {"name": "硅胶材料", "parent": "527"},
    "841": {"name": "茶叶销售", "parent": "518"},
    "842": {"name": "彩票活动", "parent": "529"},
    "843": {"name": "化妆培训", "parent": "516"},
    "844": {"name": "鞋业", "parent": "518"},
    "845": {"name": "酒店用品", "parent": "518"},
    "846": {"name": "复合材料", "parent": "527"},
    "847": {"name": "房地产工程建设", "parent": "548"},
    "848": {"name": "知识产权服务", "parent": "559"},
    "849": {"name": "新型建材", "parent": "627"},
    "850": {"name": "企业投资咨询", "parent": "567"},
    "851": {"name": "含乳饮料和植物蛋白饮料制造", "parent": "594"},
    "852": {"name": "汽车检测设备", "parent": "629"},
    "853": {"name": "手机通讯器材", "parent": "417"},
    "854": {"name": "环保材料", "parent": "672"},
    "855": {"name": "交通设施", "parent": "554"},
    "856": {"name": "电子器件", "parent": "419"},
    "857": {"name": "啤酒", "parent": "594"},
    "858": {"name": "生态旅游", "parent": "657"},
    "859": {"name": "自动化设备", "parent": "626"},
    "860": {"name": "软件开发", "parent": "414"},
    "861": {"name": "葡萄酒销售", "parent": "594"},
    "862": {"name": "钢材", "parent": "633"},
    "863": {"name": "餐饮培训", "parent": "656"},
    "864": {"name": "速冻食品", "parent": "593"},
    "865": {"name": "空气环保", "parent": "672"},
    "866": {"name": "互联网房地产经纪服务", "parent": "550"},
    "867": {"name": "食品添加剂", "parent": "593"},
    "868": {"name": "演艺传播", "parent": "585"},
    "869": {"name": "信用卡", "parent": "537"},
    "870": {"name": "报纸期刊广告", "parent": "579"},
    "871": {"name": "摄影", "parent": "525"},
    "872": {"name": "手机软件", "parent": "414"},
    "873": {"name": "地坪建材", "parent": "627"},
    "874": {"name": "企业管理咨询", "parent": "567"},
    "875": {"name": "幼儿教育", "parent": "570"},
    "876": {"name": "系统集成", "parent": "416"},
    "877": {"name": "皮革服饰", "parent": "597"},
    "878": {"name": "保健食品", "parent": "593"},
    "879": {"name": "叉车", "parent": "620"},
    "880": {"name": "厨卫电器", "parent": "601"},
    "882": {"name": "地暖设备", "parent": "627"},
    "883": {"name": "钢结构制造", "parent": "548"},
    "884": {"name": "投影机", "parent": "606"},
    "885": {"name": "啤酒销售", "parent": "594"},
    "886": {"name": "度假村旅游", "parent": "657"},
    "887": {"name": "电力元件设备", "parent": "626"},
    "888": {"name": "管理软件", "parent": "414"},
    "889": {"name": "轴承", "parent": "628"},
    "890": {"name": "餐饮设备", "parent": "656"},
    "891": {"name": "肉制品及副产品加工", "parent": "593"},
    "892": {"name": "艺术收藏品投资交易", "parent": "584"},
    "893": {"name": "净水器", "parent": "601"},
    "894": {"name": "进口食品", "parent": "593"},
    "895": {"name": "娱乐文化传播", "parent": "585"},
    "896": {"name": "文化传播", "parent": "585"},
    "897": {"name": "商旅传媒", "parent": "580"},
    "898": {"name": "广告设计制作", "parent": "579"},
    "899": {"name": "金属丝绳及其制品制造", "parent": "627"},
    "900": {"name": "建筑涂料", "parent": "627"},
    "901": {"name": "抵押贷款", "parent": "543"},
    "902": {"name": "早教", "parent": "570"},
    "903": {"name": "电影放映", "parent": "583"},
    "904": {"name": "内衣服饰", "parent": "597"},
    "905": {"name": "无线网络通信", "parent": "418"},
    "906": {"name": "记忆卡", "parent": "415"},
    "907": {"name": "女装服饰", "parent": "597"},
    "908": {"name": "建筑机械", "parent": "620"},
    "909": {"name": "制冷电器", "parent": "601"},
    "910": {"name": "通信设备", "parent": "417"},
    "911": {"name": "空调设备", "parent": "601"},
    "912": {"name": "建筑装饰", "parent": "553"},
    "913": {"name": "办公设备", "parent": "603"},
    "916": {"name": "数据处理软件", "parent": "414"},
    "917": {"name": "葡萄酒贸易", "parent": "594"},
    "918": {"name": "通讯器材", "parent": "417"},
    "919": {"name": "铜业", "parent": "633"},
    "920": {"name": "食堂", "parent": "656"},
    "921": {"name": "糖果零食", "parent": "593"},
    "922": {"name": "文化艺术传播", "parent": "584"},
    "923": {"name": "太阳能电器", "parent": "601"},
    "924": {"name": "药品零售", "parent": "645"},
    "925": {"name": "果蔬食品", "parent": "593"},
    "926": {"name": "文化活动策划", "parent": "585"},
    "928": {"name": "汽车广告", "parent": "657"},
    "929": {"name": "条码设备", "parent": "630"},
    "930": {"name": "建筑石材", "parent": "627"},
    "931": {"name": "贵金属", "parent": "545"},
    "932": {"name": "体育", "parent": "660"},
    "933": {"name": "金融信息服务", "parent": "414"},
    "934": {"name": "玻璃建材", "parent": "627"},
    "935": {"name": "家教", "parent": "569"},
    "936": {"name": "歌舞厅娱乐活动", "parent": "586"},
    "937": {"name": "计算机服务器", "parent": "415"},
    "938": {"name": "管道", "parent": "627"},
    "939": {"name": "婴幼儿服饰", "parent": "597"},
    "940": {"name": "热水器", "parent": "601"},
    "941": {"name": "计算机及零部件制造", "parent": "415"},
    "942": {"name": "钢铁贸易", "parent": "633"},
    "944": {"name": "包装材料", "parent": "632"},
    "945": {"name": "计算机办公设备", "parent": "603"},
    "946": {"name": "白酒", "parent": "594"},
    "948": {"name": "发动机", "parent": "620"},
    "949": {"name": "快餐服务", "parent": "656"},
    "950": {"name": "酒类销售", "parent": "594"},
    "951": {"name": "电子产品、机电设备", "parent": "626"},
    "952": {"name": "激光设备", "parent": "626"},
    "953": {"name": "餐饮策划", "parent": "656"},
    "954": {"name": "饮料、食品", "parent": "594"},
    "955": {"name": "文化娱乐经纪", "parent": "585"},
    "956": {"name": "天然气", "parent": "665"},
    "957": {"name": "农副食品", "parent": "593"},
    "958": {"name": "艺术表演", "parent": "585"},
    "959": {"name": "石膏、水泥制品及类似制品制造", "parent": "627"},
    "960": {"name": "橱柜", "parent": "602"},
    "961": {"name": "管理培训", "parent": "577"},
    "962": {"name": "男装服饰", "parent": "597"},
    "963": {"name": "化肥制造", "parent": "675"},
    "964": {"name": "童装服饰", "parent": "597"},
    "965": {"name": "电源电池", "parent": "626"},
    "966": {"name": "家电维修", "parent": "664"},
    "967": {"name": "光电子器件", "parent": "419"},
    "968": {"name": "旅行社服务", "parent": "657"},
    "969": {"name": "电线、电缆制造", "parent": "626"},
    "970": {"name": "软件开发、信息系统集成", "parent": "419"},
    "971": {"name": "白酒制造", "parent": "594"},
    "973": {"name": "甜品服务", "parent": "656"},
    "974": {"name": "糕点、面包制造", "parent": "593"},
    "975": {"name": "木工机械", "parent": "620"},
    "976": {"name": "酒吧服务", "parent": "656"},
    "977": {"name": "火腿肠", "parent": "593"},
    "978": {"name": "广告策划推广", "parent": "579"},
    "979": {"name": "新能源产品和生产装备制造", "parent": "667"},
    "980": {"name": "调味品", "parent": "593"},
    "981": {"name": "礼仪表演", "parent": "585"},
    "982": {"name": "劳务派遣", "parent": "560"},
    "983": {"name": "建材零售", "parent": "627"},
    "984": {"name": "商品交易中心", "parent": "545"},
    "985": {"name": "体育推广", "parent": "585"},
    "986": {"name": "茶饮料及其他饮料制造", "parent": "594"},
    "987": {"name": "金属建材", "parent": "627"},
    "988": {"name": "职业技能培训", "parent": "571"},
    "989": {"name": "网吧活动", "parent": "586"},
    "990": {"name": "洗衣服务", "parent": "658"},
    "991": {"name": "管道工程", "parent": "554"},
    "992": {"name": "通信工程", "parent": "417"},
    "993": {"name": "电子元器件", "parent": "626"},
    "994": {"name": "电子设备", "parent": "419"},
    "995": {"name": "茶馆服务", "parent": "656"},
    "996": {"name": "旅游开发", "parent": "657"},
    "997": {"name": "视频通讯", "parent": "417"},
    "998": {"name": "白酒销售", "parent": "594"},
    "1000": {"name": "咖啡馆服务", "parent": "656"},
    "1001": {"name": "食品零售", "parent": "593"},
    "1002": {"name": "健康疗养旅游", "parent": "655"},
    "1003": {"name": "粮油食品", "parent": "593"},
    "1004": {"name": "儿童教育影视", "parent": "583"},
    "1005": {"name": "新能源发电", "parent": "667"},
    "1006": {"name": "旅游策划", "parent": "657"},
    "1007": {"name": "绘画", "parent": "575"},
    "1008": {"name": "方便面及其他方便食品", "parent": "593"},
    "1009": {"name": "房地产经纪", "parent": "550"},
    "1010": {"name": "母婴家政", "parent": "661"},
    "1011": {"name": "居家养老健康服务", "parent": "661"},
    "1012": {"name": "文化艺术投资", "parent": "545"},
    "1013": {"name": "运动健身", "parent": "660"},
    "1014": {"name": "瓶（罐）装饮用水制造", "parent": "594"},
    "1015": {"name": "金属门窗", "parent": "627"},
    "1016": {"name": "机动车检测", "parent": "563"},
    "1017": {"name": "货物运输", "parent": "634"},
    "1018": {"name": "服饰专卖", "parent": "690"},
    "1019": {"name": "酒店服装", "parent": "597"},
    "1020": {"name": "通讯软件", "parent": "417"},
    "1021": {"name": "消防工程", "parent": "554"},
    "1022": {"name": "嵌入式电子系统", "parent": "419"},
    "1023": {"name": "航空票务", "parent": "636"},
    "1024": {"name": "电气设备", "parent": "626"},
    "1025": {"name": "酒业贸易", "parent": "594"},
    "1027": {"name": "其他饮料及冷饮服务", "parent": "656"},
    "1028": {"name": "乳制品", "parent": "593"},
    "1029": {"name": "新闻期刊出版", "parent": "588"},
    "1030": {"name": "水污染治理", "parent": "672"},
    "1031": {"name": "谷物食品", "parent": "593"},
    "1032": {"name": "数字动漫设计制造服务", "parent": "590"},
    "1033": {"name": "医院", "parent": "646"},
    "1034": {"name": "旅游广告", "parent": "657"},
    "1035": {"name": "办公家具", "parent": "602"},
    "1036": {"name": "房地产营销策划", "parent": "550"},
    "1037": {"name": "保洁家政", "parent": "661"},
    "1038": {"name": "水泥制造", "parent": "627"},
    "1039": {"name": "市场研究咨询", "parent": "567"},
    "1040": {"name": "驾校", "parent": "571"},
    "1041": {"name": "正餐服务", "parent": "656"},
    "1043": {"name": "机动车燃油", "parent": "665"},
    "1044": {"name": "食品", "parent": "593"},
    "1045": {"name": "新能源汽车", "parent": "629"},
    "1046": {"name": "手机无线网络推广", "parent": "417"},
    "1047": {"name": "环保设备", "parent": "672"},
    "1048": {"name": "通讯工程", "parent": "418"},
    "1049": {"name": "半导体集成电路", "parent": "419"},
    "1050": {"name": "航空服务", "parent": "636"},
    "1051": {"name": "电机设备", "parent": "626"},
    "1052": {"name": "档案软件", "parent": "414"},
    "1053": {"name": "冷链物流服务", "parent": "634"},
    "1054": {"name": "小吃服务", "parent": "656"},
    "1055": {"name": "水产品加工", "parent": "593"},
    "1056": {"name": "图书出版", "parent": "588"},
    "1057": {"name": "固体废物治理", "parent": "672"},
    "1059": {"name": "坚果食品", "parent": "593"},
    "1060": {"name": "广告传媒", "parent": "579"},
    "1061": {"name": "电梯", "parent": "622"},
    "1062": {"name": "社区医疗与卫生院", "parent": "646"},
    "1063": {"name": "广告、印刷包装", "parent": "630"},
    "1064": {"name": "婚纱礼服", "parent": "662"},
    "1065": {"name": "地毯", "parent": "602"},
    "1066": {"name": "互联网物业", "parent": "551"},
    "1067": {"name": "跨境电商", "parent": "3"},
    "1068": {"name": "信息安全、系统集成", "parent": "9"},
    "1069": {"name": "专用汽车制造", "parent": "750"},
    "1070": {"name": "商品贸易", "parent": "3"},
    "1071": {"name": "墙壁装饰材料", "parent": "746"},
    "1072": {"name": "窗帘装饰材料", "parent": "746"},
    "1073": {"name": "电子商务、本地生活服务", "parent": "3"},
    "1075": {"name": "白酒电子商务", "parent": "3"},
    "1076": {"name": "商品贸易、电子商务", "parent": "3"},
    "1077": {"name": "木质装饰材料", "parent": "746"},
    "1078": {"name": "电子商务、汽车电商交易平台", "parent": "3"},
    "1079": {"name": "汽车轮胎", "parent": "751"},
    "1080": {"name": "气体压缩机械制造", "parent": "732"},
    "1081": {"name": "家装家具电子商务", "parent": "3"},
    "1082": {"name": "化妆品电子商务", "parent": "3"},
    "1083": {"name": "汽车销售", "parent": "749"},
    "1084": {"name": "新闻资讯网站", "parent": "510"},
    "1085": {"name": "母婴电商", "parent": "3"},
    "1086": {"name": "电商商务、收藏品交易", "parent": "3"},
    "1088": {"name": "电子商务、数码产品", "parent": "3"},
    "1089": {"name": "二手车交易", "parent": "749"},
    "1090": {"name": "游戏制作服务", "parent": "5"},
    "1091": {"name": "母婴服务", "parent": "510"},
    "1092": {"name": "家具电子商务", "parent": "3"},
    "1093": {"name": "汽车配件电子商务", "parent": "3"},
    "1094": {"name": "输配电设备", "parent": "777"},
    "1095": {"name": "矿山设备", "parent": "727"},
    "1096": {"name": "机床机械", "parent": "726"},
    "1097": {"name": "农产品电商", "parent": "3"},
    "1098": {"name": "陶瓷装饰材料", "parent": "746"},
    "1099": {"name": "车载联网设备", "parent": "487"},
    "1100": {"name": "汽车销售电子商务", "parent": "3"},
    "1101": {"name": "石油设备", "parent": "730"},
    "1102": {"name": "智能家居", "parent": "487"},
    "1103": {"name": "散热器", "parent": "751"},
    "1104": {"name": "电力工程", "parent": "775"},
    "1105": {"name": "生鲜电商", "parent": "3"},
    "1106": {"name": "互联网数据服务", "parent": "490"},
    "1107": {"name": "房车、商务车销售", "parent": "749"},
    "1108": {"name": "茶叶电子商务", "parent": "3"},
    "1109": {"name": "酒类电子商务", "parent": "3"},
    "1110": {"name": "阀门", "parent": "730"},
    "1111": {"name": "食品电商", "parent": "3"},
    "1112": {"name": "儿童摄影", "parent": "871"},
    "1113": {"name": "广告摄影", "parent": "871"},
    "1114": {"name": "婚纱摄影", "parent": "871"},
    "1115": {"name": "模具制造", "parent": "620"},
    "1116": {"name": "汽车模具", "parent": "629"},
    "1117": {"name": "认证咨询", "parent": "567"},
    "1118": {"name": "数字视觉制作服务", "parent": "590"},
    "1119": {"name": "牙科及医疗器械", "parent": "646"},
    "1120": {"name": "猎头招聘", "parent": "560"},
    "1121": {"name": "家居", "parent": "518"},
    "1122": {"name": "收藏品", "parent": "518"},
    "1123": {"name": "首饰", "parent": "518"},
    "1124": {"name": "工艺品", "parent": "518"},
    "1125": {"name": "财务", "parent": "515"},
    "1126": {"name": "税务", "parent": "515"},
    "1127": {"name": "分类信息", "parent": "2"},
    "1128": {"name": "宠物", "parent": "0"},
    "1129": {"name": "快消品", "parent": "518"},
    "1130": {"name": "人工智能", "parent": "2"},
    "1131": {"name": "农/林/牧/渔", "parent": "0"},
}


def get_names(id):
    id = str(id)
    nms = []
    d = TBL.get(id)
    if not d:
        return []
    nms.append(d["name"])
    p = get_names(d["parent"])
    if p:
        nms.extend(p)
    return nms


if __name__ == "__main__":
    print(get_names("1119"))
