export enum LLMFactory {
  TongYiQianWen = 'Tongyi-Qianwen',
  Moonshot = 'Moonshot',
  OpenAI = 'OpenAI',
  ZhipuAI = 'ZHIPU-AI',
  WenXinYiYan = '文心一言',
  Ollama = 'Ollama',
  Xinference = 'Xinference',
  ModelScope = 'ModelScope',
  DeepSeek = 'DeepSeek',
  VolcEngine = 'VolcEngine',
  BaiChuan = 'BaiChuan',
  Jina = 'Jina',
  MiniMax = 'MiniMax',
  Mistral = 'Mistral',
  AzureOpenAI = 'Azure-OpenAI',
  Bedrock = 'Bedrock',
  Gemini = 'Gemini',
  Groq = 'Groq',
  OpenRouter = 'OpenRouter',
  LocalAI = 'LocalAI',
  StepFun = 'StepFun',
  NVIDIA = 'NVIDIA',
  LMStudio = 'LM-Studio',
  OpenAiAPICompatible = 'OpenAI-API-Compatible',
  Cohere = 'Cohere',
  LeptonAI = 'LeptonAI',
  TogetherAI = 'TogetherAI',
  PerfXCloud = 'PerfXCloud',
  Upstage = 'Upstage',
  NovitaAI = 'NovitaAI',
  SILICONFLOW = 'SILICONFLOW',
  PPIO = 'PPIO',
  Replicate = 'Replicate',
  TencentHunYuan = 'Tencent Hunyuan',
  XunFeiSpark = 'XunFei Spark',
  BaiduYiYan = 'BaiduYiyan',
  FishAudio = 'Fish Audio',
  TencentCloud = 'Tencent Cloud',
  Anthropic = 'Anthropic',
  VoyageAI = 'Voyage AI',
  GoogleCloud = 'Google Cloud',
  HuggingFace = 'HuggingFace',
  YouDao = 'Youdao',
  BAAI = 'BAAI',
  NomicAI = 'nomic-ai',
  JinaAI = 'jinaai',
  SentenceTransformers = 'sentence-transformers',
  GPUStack = 'GPUStack',
  VLLM = 'VLLM',
  GiteeAI = 'GiteeAI',
  Ai302 = '302.AI',
  DeepInfra = 'DeepInfra',
  Grok = 'Grok',
  XAI = 'xAI',
  TokenPony = 'TokenPony',
  Meituan = 'Meituan',
  Longcat = 'LongCat',
  CometAPI = 'CometAPI',
  DeerAPI = 'DeerAPI',
  JiekouAI = 'Jiekou.AI',
  Builtin = 'Builtin',
  MinerU = 'MinerU',
  PaddleOCR = 'PaddleOCR',
}

// Please lowercase the file name
export const IconMap = {
  [LLMFactory.TongYiQianWen]: 'tongyi-qianwen',
  [LLMFactory.Moonshot]: 'moonshot',
  [LLMFactory.OpenAI]: 'openai',
  [LLMFactory.ZhipuAI]: 'zhipu',
  [LLMFactory.WenXinYiYan]: 'wenxin',
  [LLMFactory.Ollama]: 'ollama',
  [LLMFactory.Xinference]: 'xinference',
  [LLMFactory.ModelScope]: 'modelscope',
  [LLMFactory.DeepSeek]: 'deepseek',
  [LLMFactory.VolcEngine]: 'volcengine',
  [LLMFactory.BaiChuan]: 'baichuan',
  [LLMFactory.Jina]: 'jina',
  [LLMFactory.MiniMax]: 'MiniMax',
  [LLMFactory.Mistral]: 'mistral',
  [LLMFactory.AzureOpenAI]: 'azure',
  [LLMFactory.Bedrock]: 'bedrock',
  [LLMFactory.Gemini]: 'gemini',
  [LLMFactory.Groq]: 'groq-next',
  [LLMFactory.OpenRouter]: 'open-router',
  [LLMFactory.LocalAI]: 'local-ai',
  [LLMFactory.StepFun]: 'stepfun',
  [LLMFactory.NVIDIA]: 'nvidia',
  [LLMFactory.LMStudio]: 'lm-studio',
  [LLMFactory.OpenAiAPICompatible]: 'openai-api',
  [LLMFactory.Cohere]: 'cohere',
  [LLMFactory.LeptonAI]: 'lepton',
  [LLMFactory.TogetherAI]: 'together',
  [LLMFactory.PerfXCloud]: 'perfx-cloud',
  [LLMFactory.Upstage]: 'upstage',
  [LLMFactory.NovitaAI]: 'novita-ai',
  [LLMFactory.SILICONFLOW]: 'siliconflow',
  [LLMFactory.PPIO]: 'ppio',
  [LLMFactory.Replicate]: 'replicate',
  [LLMFactory.TencentHunYuan]: 'hunyuan',
  [LLMFactory.XunFeiSpark]: 'spark',
  [LLMFactory.BaiduYiYan]: 'wenxinyiyan',
  [LLMFactory.FishAudio]: 'fish-audio',
  [LLMFactory.TencentCloud]: 'tencent-cloud',
  [LLMFactory.Anthropic]: 'anthropic',
  [LLMFactory.VoyageAI]: 'voyage',
  [LLMFactory.GoogleCloud]: 'google-cloud',
  [LLMFactory.HuggingFace]: 'huggingface',
  [LLMFactory.YouDao]: 'youdao',
  [LLMFactory.BAAI]: 'baai',
  [LLMFactory.NomicAI]: 'nomic-ai',
  [LLMFactory.JinaAI]: 'jina',
  [LLMFactory.SentenceTransformers]: 'sentence-transformers',
  [LLMFactory.GPUStack]: 'gpustack',
  [LLMFactory.VLLM]: 'vllm',
  [LLMFactory.GiteeAI]: 'gitee-ai',
  [LLMFactory.Ai302]: 'ai302',
  [LLMFactory.DeepInfra]: 'deepinfra',
  [LLMFactory.Grok]: 'grok',
  [LLMFactory.XAI]: 'xai',
  [LLMFactory.TokenPony]: 'tokenpony',
  [LLMFactory.Meituan]: 'longcat',
  [LLMFactory.Longcat]: 'longcat',
  [LLMFactory.CometAPI]: 'cometapi',
  [LLMFactory.DeerAPI]: 'deerapi',
  [LLMFactory.JiekouAI]: 'jiekouai',
  [LLMFactory.Builtin]: 'builtin',
  [LLMFactory.MinerU]: 'mineru',
  [LLMFactory.PaddleOCR]: 'paddleocr',
};

export const APIMapUrl = {
  [LLMFactory.OpenAI]: 'https://platform.openai.com/api-keys',
  [LLMFactory.Anthropic]: 'https://console.anthropic.com/settings/keys',
  [LLMFactory.Gemini]: 'https://aistudio.google.com/app/apikey',
  [LLMFactory.DeepSeek]: 'https://platform.deepseek.com/api_keys',
  [LLMFactory.Moonshot]: 'https://platform.moonshot.cn/console/api-keys',
  [LLMFactory.TongYiQianWen]: 'https://dashscope.console.aliyun.com/apiKey',
  [LLMFactory.ZhipuAI]: 'https://open.bigmodel.cn/usercenter/apikeys',
  [LLMFactory.XAI]: 'https://x.ai/api/',
  [LLMFactory.HuggingFace]: 'https://huggingface.co/settings/tokens',
  [LLMFactory.Mistral]: 'https://console.mistral.ai/api-keys/',
  [LLMFactory.Cohere]: 'https://dashboard.cohere.com/api-keys',
  [LLMFactory.BaiduYiYan]:
    'https://console.bce.baidu.com/qianfan/ais/console/apiKey',
  [LLMFactory.Meituan]: 'https://longcat.chat/platform/api_keys',
  [LLMFactory.Bedrock]:
    'https://us-east-1.console.aws.amazon.com/iam/home?region=us-east-2#/users',
  [LLMFactory.AzureOpenAI]:
    'https://portal.azure.com/#create/Microsoft.CognitiveServicesOpenAI',
  [LLMFactory.OpenRouter]: 'https://openrouter.ai/keys',
  [LLMFactory.XunFeiSpark]: 'https://console.xfyun.cn/services/cbm',
  [LLMFactory.MiniMax]:
    'https://platform.minimaxi.com/user-center/basic-information',
  [LLMFactory.Groq]: 'https://console.groq.com/keys',
  [LLMFactory.NVIDIA]: 'https://build.nvidia.com/settings/api-keys',
  [LLMFactory.SILICONFLOW]: 'https://cloud.siliconflow.cn/account/ak',
  [LLMFactory.Replicate]: 'https://replicate.com/account/api-tokens',
  [LLMFactory.VolcEngine]: 'https://console.volcengine.com/ark',
  [LLMFactory.Jina]: 'https://jina.ai/embeddings/',
  [LLMFactory.TencentHunYuan]:
    'https://console.cloud.tencent.com/hunyuan/api-key',
  [LLMFactory.TencentCloud]: 'https://console.cloud.tencent.com/cam/capi',
  [LLMFactory.ModelScope]: 'https://modelscope.cn/my/myaccesstoken',
  [LLMFactory.GoogleCloud]: 'https://console.cloud.google.com/apis/credentials',
  [LLMFactory.FishAudio]: 'https://fish.audio/app/api-keys/',
  [LLMFactory.GiteeAI]:
    'https://ai.gitee.com/hhxzgrjn/dashboard/settings/tokens',
  [LLMFactory.StepFun]: 'https://platform.stepfun.com/interface-key',
  [LLMFactory.BaiChuan]: 'https://platform.baichuan-ai.com/console/apikey',
  [LLMFactory.PPIO]: 'https://ppio.com/settings/key-management',
  [LLMFactory.VoyageAI]: 'https://dash.voyageai.com/api-keys',
  [LLMFactory.TogetherAI]: 'https://api.together.xyz/settings/api-keys',
  [LLMFactory.NovitaAI]: 'https://novita.ai/dashboard/key',
  [LLMFactory.Upstage]: 'https://console.upstage.ai/api-keys',
  [LLMFactory.CometAPI]: 'https://api.cometapi.com/console/token',
  [LLMFactory.Ai302]: 'https://302.ai/apis/list',
  [LLMFactory.DeerAPI]: 'https://api.deerapi.com/token',
  [LLMFactory.TokenPony]: 'https://www.tokenpony.cn/#/user/keys',
  [LLMFactory.DeepInfra]: 'https://deepinfra.com/dash/api_keys',
  [LLMFactory.PaddleOCR]: 'https://www.paddleocr.ai/latest/',
};
