# Contribution Guidelines

Thanks for submitting your entry to Awesome IPFS!
Please ensure your pull request adheres to the following guidelines:

## Content Policy

Entries are accepted if they meet the following criteria:

- Entries must use _IPFS_
- Entries in the **apps** & **tools** categories must be **open-source** and contain a link to their source code.
- Entries in the services & platforms category must contain a clear description of how they relate to IPFS and avoid marketing buzzwords. 
- Entries must be immediately usable (eg. nothing that is paywall-only, even a free trial would be ok).
- Entries must have a clear license and/or privacy policy where applicable.
- Entries must respect the [IPFS Community Code of Conduct](https://github.com/ipfs/community/blob/master/code-of-conduct.md).

### 1. Before submitting

- Search previous suggestions before making a new one, as yours may be a duplicate.
- If you just created something, wait at least a couple of weeks before submitting.
- Review the [content policy](#content-policy) to ensure your submission meets the requirements.

### 2. Creating a submission

Make an **individual pull request for each suggestion**:

Style tips:

- Keep descriptions short and simple, but descriptive.
- Don't mention `IPFS` in the description as it's implied.
- Start the description with a capital and end with a full stop/period.
- Check your spelling and grammar.

### 3. Submitting it through a PR

- The pull request should have a useful title and include a link to the package and why it should be included.
- Submit products when they are useable, or at a state which has something to show which is awesome in itself. This cuts down on half-finished implementations.

Thank you for your suggestions!

---
